# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetImageResult',
    'AwaitableGetImageResult',
    'get_image',
    'get_image_output',
]

@pulumi.output_type
class GetImageResult:
    """
    A collection of values returned by getImage.
    """
    def __init__(__self__, data_disks=None, id=None, location=None, name=None, name_regex=None, os_disks=None, resource_group_name=None, sort_descending=None, tags=None, zone_resilient=None):
        if data_disks and not isinstance(data_disks, list):
            raise TypeError("Expected argument 'data_disks' to be a list")
        pulumi.set(__self__, "data_disks", data_disks)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if name_regex and not isinstance(name_regex, str):
            raise TypeError("Expected argument 'name_regex' to be a str")
        pulumi.set(__self__, "name_regex", name_regex)
        if os_disks and not isinstance(os_disks, list):
            raise TypeError("Expected argument 'os_disks' to be a list")
        pulumi.set(__self__, "os_disks", os_disks)
        if resource_group_name and not isinstance(resource_group_name, str):
            raise TypeError("Expected argument 'resource_group_name' to be a str")
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if sort_descending and not isinstance(sort_descending, bool):
            raise TypeError("Expected argument 'sort_descending' to be a bool")
        pulumi.set(__self__, "sort_descending", sort_descending)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if zone_resilient and not isinstance(zone_resilient, bool):
            raise TypeError("Expected argument 'zone_resilient' to be a bool")
        pulumi.set(__self__, "zone_resilient", zone_resilient)

    @_builtins.property
    @pulumi.getter(name="dataDisks")
    def data_disks(self) -> Sequence['outputs.GetImageDataDiskResult']:
        """
        a collection of `data_disk` blocks as defined below.
        """
        return pulumi.get(self, "data_disks")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def location(self) -> _builtins.str:
        """
        the Azure Location where this Image exists.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        the name of the Image.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="nameRegex")
    def name_regex(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "name_regex")

    @_builtins.property
    @pulumi.getter(name="osDisks")
    def os_disks(self) -> Sequence['outputs.GetImageOsDiskResult']:
        """
        a `os_disk` block as defined below.
        """
        return pulumi.get(self, "os_disks")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> _builtins.str:
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter(name="sortDescending")
    def sort_descending(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "sort_descending")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        a mapping of tags to assigned to the resource.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="zoneResilient")
    def zone_resilient(self) -> _builtins.bool:
        """
        is zone resiliency enabled?
        """
        return pulumi.get(self, "zone_resilient")


class AwaitableGetImageResult(GetImageResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetImageResult(
            data_disks=self.data_disks,
            id=self.id,
            location=self.location,
            name=self.name,
            name_regex=self.name_regex,
            os_disks=self.os_disks,
            resource_group_name=self.resource_group_name,
            sort_descending=self.sort_descending,
            tags=self.tags,
            zone_resilient=self.zone_resilient)


def get_image(name: Optional[_builtins.str] = None,
              name_regex: Optional[_builtins.str] = None,
              resource_group_name: Optional[_builtins.str] = None,
              sort_descending: Optional[_builtins.bool] = None,
              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetImageResult:
    """
    Use this data source to access information about an existing Image.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    search = azure.compute.get_image(name="search-api",
        resource_group_name="packerimages")
    pulumi.export("imageId", search.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.Compute`: 2022-03-01


    :param _builtins.str name: The name of the Image.
    :param _builtins.str name_regex: Regex pattern of the image to match.
    :param _builtins.str resource_group_name: The Name of the Resource Group where this Image exists.
    :param _builtins.bool sort_descending: By default when matching by regex, images are sorted by name in ascending order and the first match is chosen, to sort descending, set this flag.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['nameRegex'] = name_regex
    __args__['resourceGroupName'] = resource_group_name
    __args__['sortDescending'] = sort_descending
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:compute/getImage:getImage', __args__, opts=opts, typ=GetImageResult).value

    return AwaitableGetImageResult(
        data_disks=pulumi.get(__ret__, 'data_disks'),
        id=pulumi.get(__ret__, 'id'),
        location=pulumi.get(__ret__, 'location'),
        name=pulumi.get(__ret__, 'name'),
        name_regex=pulumi.get(__ret__, 'name_regex'),
        os_disks=pulumi.get(__ret__, 'os_disks'),
        resource_group_name=pulumi.get(__ret__, 'resource_group_name'),
        sort_descending=pulumi.get(__ret__, 'sort_descending'),
        tags=pulumi.get(__ret__, 'tags'),
        zone_resilient=pulumi.get(__ret__, 'zone_resilient'))
def get_image_output(name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                     name_regex: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                     resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                     sort_descending: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetImageResult]:
    """
    Use this data source to access information about an existing Image.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    search = azure.compute.get_image(name="search-api",
        resource_group_name="packerimages")
    pulumi.export("imageId", search.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.Compute`: 2022-03-01


    :param _builtins.str name: The name of the Image.
    :param _builtins.str name_regex: Regex pattern of the image to match.
    :param _builtins.str resource_group_name: The Name of the Resource Group where this Image exists.
    :param _builtins.bool sort_descending: By default when matching by regex, images are sorted by name in ascending order and the first match is chosen, to sort descending, set this flag.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['nameRegex'] = name_regex
    __args__['resourceGroupName'] = resource_group_name
    __args__['sortDescending'] = sort_descending
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:compute/getImage:getImage', __args__, opts=opts, typ=GetImageResult)
    return __ret__.apply(lambda __response__: GetImageResult(
        data_disks=pulumi.get(__response__, 'data_disks'),
        id=pulumi.get(__response__, 'id'),
        location=pulumi.get(__response__, 'location'),
        name=pulumi.get(__response__, 'name'),
        name_regex=pulumi.get(__response__, 'name_regex'),
        os_disks=pulumi.get(__response__, 'os_disks'),
        resource_group_name=pulumi.get(__response__, 'resource_group_name'),
        sort_descending=pulumi.get(__response__, 'sort_descending'),
        tags=pulumi.get(__response__, 'tags'),
        zone_resilient=pulumi.get(__response__, 'zone_resilient')))
