# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetPlatformImageResult',
    'AwaitableGetPlatformImageResult',
    'get_platform_image',
    'get_platform_image_output',
]

@pulumi.output_type
class GetPlatformImageResult:
    """
    A collection of values returned by getPlatformImage.
    """
    def __init__(__self__, id=None, location=None, offer=None, publisher=None, sku=None, version=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if offer and not isinstance(offer, str):
            raise TypeError("Expected argument 'offer' to be a str")
        pulumi.set(__self__, "offer", offer)
        if publisher and not isinstance(publisher, str):
            raise TypeError("Expected argument 'publisher' to be a str")
        pulumi.set(__self__, "publisher", publisher)
        if sku and not isinstance(sku, str):
            raise TypeError("Expected argument 'sku' to be a str")
        pulumi.set(__self__, "sku", sku)
        if version and not isinstance(version, str):
            raise TypeError("Expected argument 'version' to be a str")
        pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def location(self) -> _builtins.str:
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def offer(self) -> _builtins.str:
        return pulumi.get(self, "offer")

    @_builtins.property
    @pulumi.getter
    def publisher(self) -> _builtins.str:
        return pulumi.get(self, "publisher")

    @_builtins.property
    @pulumi.getter
    def sku(self) -> _builtins.str:
        return pulumi.get(self, "sku")

    @_builtins.property
    @pulumi.getter
    def version(self) -> _builtins.str:
        return pulumi.get(self, "version")


class AwaitableGetPlatformImageResult(GetPlatformImageResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPlatformImageResult(
            id=self.id,
            location=self.location,
            offer=self.offer,
            publisher=self.publisher,
            sku=self.sku,
            version=self.version)


def get_platform_image(location: Optional[_builtins.str] = None,
                       offer: Optional[_builtins.str] = None,
                       publisher: Optional[_builtins.str] = None,
                       sku: Optional[_builtins.str] = None,
                       version: Optional[_builtins.str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPlatformImageResult:
    """
    Use this data source to access information about a Platform Image.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.compute.get_platform_image(location="West Europe",
        publisher="Canonical",
        offer="0001-com-ubuntu-server-focal",
        sku="20_04-lts")
    pulumi.export("id", example.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.Compute`: 2024-03-01


    :param _builtins.str location: Specifies the Location to pull information about this Platform Image from.
    :param _builtins.str offer: Specifies the Offer associated with the Platform Image.
    :param _builtins.str publisher: Specifies the Publisher associated with the Platform Image.
    :param _builtins.str sku: Specifies the SKU of the Platform Image.
    :param _builtins.str version: The version of the Platform Image.
    """
    __args__ = dict()
    __args__['location'] = location
    __args__['offer'] = offer
    __args__['publisher'] = publisher
    __args__['sku'] = sku
    __args__['version'] = version
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:compute/getPlatformImage:getPlatformImage', __args__, opts=opts, typ=GetPlatformImageResult).value

    return AwaitableGetPlatformImageResult(
        id=pulumi.get(__ret__, 'id'),
        location=pulumi.get(__ret__, 'location'),
        offer=pulumi.get(__ret__, 'offer'),
        publisher=pulumi.get(__ret__, 'publisher'),
        sku=pulumi.get(__ret__, 'sku'),
        version=pulumi.get(__ret__, 'version'))
def get_platform_image_output(location: Optional[pulumi.Input[_builtins.str]] = None,
                              offer: Optional[pulumi.Input[_builtins.str]] = None,
                              publisher: Optional[pulumi.Input[_builtins.str]] = None,
                              sku: Optional[pulumi.Input[_builtins.str]] = None,
                              version: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetPlatformImageResult]:
    """
    Use this data source to access information about a Platform Image.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.compute.get_platform_image(location="West Europe",
        publisher="Canonical",
        offer="0001-com-ubuntu-server-focal",
        sku="20_04-lts")
    pulumi.export("id", example.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.Compute`: 2024-03-01


    :param _builtins.str location: Specifies the Location to pull information about this Platform Image from.
    :param _builtins.str offer: Specifies the Offer associated with the Platform Image.
    :param _builtins.str publisher: Specifies the Publisher associated with the Platform Image.
    :param _builtins.str sku: Specifies the SKU of the Platform Image.
    :param _builtins.str version: The version of the Platform Image.
    """
    __args__ = dict()
    __args__['location'] = location
    __args__['offer'] = offer
    __args__['publisher'] = publisher
    __args__['sku'] = sku
    __args__['version'] = version
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:compute/getPlatformImage:getPlatformImage', __args__, opts=opts, typ=GetPlatformImageResult)
    return __ret__.apply(lambda __response__: GetPlatformImageResult(
        id=pulumi.get(__response__, 'id'),
        location=pulumi.get(__response__, 'location'),
        offer=pulumi.get(__response__, 'offer'),
        publisher=pulumi.get(__response__, 'publisher'),
        sku=pulumi.get(__response__, 'sku'),
        version=pulumi.get(__response__, 'version')))
