# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['OrchestratedVirtualMachineScaleSetArgs', 'OrchestratedVirtualMachineScaleSet']

@pulumi.input_type
class OrchestratedVirtualMachineScaleSetArgs:
    def __init__(__self__, *,
                 platform_fault_domain_count: pulumi.Input[_builtins.int],
                 resource_group_name: pulumi.Input[_builtins.str],
                 additional_capabilities: Optional[pulumi.Input['OrchestratedVirtualMachineScaleSetAdditionalCapabilitiesArgs']] = None,
                 automatic_instance_repair: Optional[pulumi.Input['OrchestratedVirtualMachineScaleSetAutomaticInstanceRepairArgs']] = None,
                 boot_diagnostics: Optional[pulumi.Input['OrchestratedVirtualMachineScaleSetBootDiagnosticsArgs']] = None,
                 capacity_reservation_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 data_disks: Optional[pulumi.Input[Sequence[pulumi.Input['OrchestratedVirtualMachineScaleSetDataDiskArgs']]]] = None,
                 encryption_at_host_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 eviction_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 extension_operations_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 extensions: Optional[pulumi.Input[Sequence[pulumi.Input['OrchestratedVirtualMachineScaleSetExtensionArgs']]]] = None,
                 extensions_time_budget: Optional[pulumi.Input[_builtins.str]] = None,
                 identity: Optional[pulumi.Input['OrchestratedVirtualMachineScaleSetIdentityArgs']] = None,
                 instances: Optional[pulumi.Input[_builtins.int]] = None,
                 license_type: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 max_bid_price: Optional[pulumi.Input[_builtins.float]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input['OrchestratedVirtualMachineScaleSetNetworkInterfaceArgs']]]] = None,
                 os_disk: Optional[pulumi.Input['OrchestratedVirtualMachineScaleSetOsDiskArgs']] = None,
                 os_profile: Optional[pulumi.Input['OrchestratedVirtualMachineScaleSetOsProfileArgs']] = None,
                 plan: Optional[pulumi.Input['OrchestratedVirtualMachineScaleSetPlanArgs']] = None,
                 priority: Optional[pulumi.Input[_builtins.str]] = None,
                 priority_mix: Optional[pulumi.Input['OrchestratedVirtualMachineScaleSetPriorityMixArgs']] = None,
                 proximity_placement_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 rolling_upgrade_policy: Optional[pulumi.Input['OrchestratedVirtualMachineScaleSetRollingUpgradePolicyArgs']] = None,
                 single_placement_group: Optional[pulumi.Input[_builtins.bool]] = None,
                 sku_name: Optional[pulumi.Input[_builtins.str]] = None,
                 sku_profile: Optional[pulumi.Input['OrchestratedVirtualMachineScaleSetSkuProfileArgs']] = None,
                 source_image_id: Optional[pulumi.Input[_builtins.str]] = None,
                 source_image_reference: Optional[pulumi.Input['OrchestratedVirtualMachineScaleSetSourceImageReferenceArgs']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 termination_notification: Optional[pulumi.Input['OrchestratedVirtualMachineScaleSetTerminationNotificationArgs']] = None,
                 upgrade_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 user_data_base64: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_balance: Optional[pulumi.Input[_builtins.bool]] = None,
                 zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a OrchestratedVirtualMachineScaleSet resource.
        :param pulumi.Input[_builtins.int] platform_fault_domain_count: Specifies the number of fault domains that are used by this Virtual Machine Scale Set. Changing this forces a new resource to be created.
               
               > **Note:** The number of Fault Domains varies depending on which Azure Region you're using. More information about update and fault domains and how they work can be found [here](https://learn.microsoft.com/en-us/azure/virtual-machines/availability-set-overview).
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group in which the Virtual Machine Scale Set should exist. Changing this forces a new resource to be created.
        :param pulumi.Input['OrchestratedVirtualMachineScaleSetAdditionalCapabilitiesArgs'] additional_capabilities: An `additional_capabilities` block as defined below.
        :param pulumi.Input['OrchestratedVirtualMachineScaleSetAutomaticInstanceRepairArgs'] automatic_instance_repair: An `automatic_instance_repair` block as defined below.
               
               > **Note:** To enable the `automatic_instance_repair`, the Orchestrated Virtual Machine Scale Set must have a valid [Application Health Extension](https://docs.microsoft.com/azure/virtual-machine-scale-sets/virtual-machine-scale-sets-health-extension).
        :param pulumi.Input['OrchestratedVirtualMachineScaleSetBootDiagnosticsArgs'] boot_diagnostics: A `boot_diagnostics` block as defined below.
        :param pulumi.Input[_builtins.str] capacity_reservation_group_id: Specifies the ID of the Capacity Reservation Group which the Virtual Machine Scale Set should be allocated to. Changing this forces a new resource to be created.
               
               > **Note:** `capacity_reservation_group_id` cannot be specified with `proximity_placement_group_id`
               
               > **Note:** If `capacity_reservation_group_id` is specified the `single_placement_group` must be set to `false`.
        :param pulumi.Input[Sequence[pulumi.Input['OrchestratedVirtualMachineScaleSetDataDiskArgs']]] data_disks: One or more `data_disk` blocks as defined below.
        :param pulumi.Input[_builtins.bool] encryption_at_host_enabled: Should disks attached to this Virtual Machine Scale Set be encrypted by enabling Encryption at Host?
        :param pulumi.Input[_builtins.str] eviction_policy: The Policy which should be used by Spot Virtual Machines that are Evicted from the Scale Set. Possible values are `Deallocate` and `Delete`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] extension_operations_enabled: Should extension operations be allowed on the Virtual Machine Scale Set? Possible values are `true` or `false`. Defaults to `true`. Changing this forces a new Virtual Machine Scale Set to be created.
               
               > **Note:** `extension_operations_enabled` may only be set to `false` if there are no extensions defined in the `extension` field.
        :param pulumi.Input[Sequence[pulumi.Input['OrchestratedVirtualMachineScaleSetExtensionArgs']]] extensions: One or more `extension` blocks as defined below
        :param pulumi.Input[_builtins.str] extensions_time_budget: Specifies the time alloted for all extensions to start. The time duration should be between 15 minutes and 120 minutes (inclusive) and should be specified in ISO 8601 format. Defaults to `PT1H30M`.
        :param pulumi.Input['OrchestratedVirtualMachineScaleSetIdentityArgs'] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.int] instances: The number of Virtual Machines in the Virtual Machine Scale Set.
        :param pulumi.Input[_builtins.str] license_type: Specifies the type of on-premise license (also known as Azure Hybrid Use Benefit) which should be used for this Virtual Machine Scale Set. Possible values are `None`, `Windows_Client` and `Windows_Server`.
        :param pulumi.Input[_builtins.str] location: The Azure location where the Virtual Machine Scale Set should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.float] max_bid_price: The maximum price you're willing to pay for each Virtual Machine in this Scale Set, in US Dollars; which must be greater than the current spot price. If this bid price falls below the current spot price the Virtual Machines in the Scale Set will be evicted using the eviction_policy. Defaults to `-1`, which means that each Virtual Machine in the Scale Set should not be evicted for price reasons.
        :param pulumi.Input[_builtins.str] name: The name of the Virtual Machine Scale Set. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input['OrchestratedVirtualMachineScaleSetNetworkInterfaceArgs']]] network_interfaces: One or more `network_interface` blocks as defined below.
        :param pulumi.Input['OrchestratedVirtualMachineScaleSetOsDiskArgs'] os_disk: An `os_disk` block as defined below.
        :param pulumi.Input['OrchestratedVirtualMachineScaleSetOsProfileArgs'] os_profile: An `os_profile` block as defined below.
        :param pulumi.Input['OrchestratedVirtualMachineScaleSetPlanArgs'] plan: A `plan` block as documented below. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] priority: The Priority of this Virtual Machine Scale Set. Possible values are `Regular` and `Spot`. Defaults to `Regular`. Changing this value forces a new resource.
        :param pulumi.Input['OrchestratedVirtualMachineScaleSetPriorityMixArgs'] priority_mix: a `priority_mix` block as defined below
        :param pulumi.Input[_builtins.str] proximity_placement_group_id: The ID of the Proximity Placement Group which the Virtual Machine should be assigned to. Changing this forces a new resource to be created.
        :param pulumi.Input['OrchestratedVirtualMachineScaleSetRollingUpgradePolicyArgs'] rolling_upgrade_policy: A `rolling_upgrade_policy` block as defined below. This is Required when `upgrade_mode` is set to `Rolling` and cannot be specified when `upgrade_mode` is set to `Manual`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] single_placement_group: Should this Virtual Machine Scale Set be limited to a Single Placement Group, which means the number of instances will be capped at 100 Virtual Machines. Possible values are `true` or `false`.
               
               > **Note:** `single_placement_group` behaves differently for Flexible orchestration Virtual Machine Scale Sets than it does for Uniform orchestration Virtual Machine Scale Sets. It is recommended that you do not define the `single_placement_group` field in your configuration file as the service will determine what this value should be based off of the value contained within the `sku_name` field of your configuration file. You may set the `single_placement_group` field to `true`, however once you set it to `false` you will not be able to revert it back to `true`.
        :param pulumi.Input[_builtins.str] sku_name: The `name` of the SKU to be used by this Virtual Machine Scale Set. Valid values include: any of the [General purpose](https://docs.microsoft.com/azure/virtual-machines/sizes-general), [Compute optimized](https://docs.microsoft.com/azure/virtual-machines/sizes-compute), [Memory optimized](https://docs.microsoft.com/azure/virtual-machines/sizes-memory), [Storage optimized](https://docs.microsoft.com/azure/virtual-machines/sizes-storage), [GPU optimized](https://docs.microsoft.com/azure/virtual-machines/sizes-gpu), [FPGA optimized](https://docs.microsoft.com/azure/virtual-machines/sizes-field-programmable-gate-arrays), [High performance](https://docs.microsoft.com/azure/virtual-machines/sizes-hpc), or [Previous generation](https://docs.microsoft.com/azure/virtual-machines/sizes-previous-gen) virtual machine SKUs.
        :param pulumi.Input['OrchestratedVirtualMachineScaleSetSkuProfileArgs'] sku_profile: An `sku_profile` block as defined below. Changing this forces a new resource to be created.
               
               > **Note:** If `sku_profile` is specified the `sku_name` must be set to `Mix`.
        :param pulumi.Input[_builtins.str] source_image_id: The ID of an Image which each Virtual Machine in this Scale Set should be based on. Possible Image ID types include `Image ID`s, `Shared Image ID`s, `Shared Image Version ID`s, `Community Gallery Image ID`s, `Community Gallery Image Version ID`s, `Shared Gallery Image ID`s and `Shared Gallery Image Version ID`s.
        :param pulumi.Input['OrchestratedVirtualMachineScaleSetSourceImageReferenceArgs'] source_image_reference: A `source_image_reference` block as defined below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to this Virtual Machine Scale Set.
        :param pulumi.Input['OrchestratedVirtualMachineScaleSetTerminationNotificationArgs'] termination_notification: A `termination_notification` block as defined below.
        :param pulumi.Input[_builtins.str] upgrade_mode: Specifies how upgrades (e.g. changing the Image/SKU) should be performed to Virtual Machine Instances. Possible values are `Automatic`, `Manual` and `Rolling`. Defaults to `Manual`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] user_data_base64: The Base64-Encoded User Data which should be used for this Virtual Machine Scale Set.
        :param pulumi.Input[_builtins.bool] zone_balance: Should the Virtual Machines in this Scale Set be strictly evenly distributed across Availability Zones? Defaults to `false`. Changing this forces a new resource to be created.
               
               > **Note:** This can only be set to `true` when one or more `zones` are configured.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] zones: Specifies a list of Availability Zones across which the Virtual Machine Scale Set will create instances.
               
               > **Note:** Updating `zones` to remove an existing zone forces a new Virtual Machine Scale Set to be created.
               
               > **Note:** Availability Zones are [only supported in several regions at this time](https://docs.microsoft.com/azure/availability-zones/az-overview).
        """
        pulumi.set(__self__, "platform_fault_domain_count", platform_fault_domain_count)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if additional_capabilities is not None:
            pulumi.set(__self__, "additional_capabilities", additional_capabilities)
        if automatic_instance_repair is not None:
            pulumi.set(__self__, "automatic_instance_repair", automatic_instance_repair)
        if boot_diagnostics is not None:
            pulumi.set(__self__, "boot_diagnostics", boot_diagnostics)
        if capacity_reservation_group_id is not None:
            pulumi.set(__self__, "capacity_reservation_group_id", capacity_reservation_group_id)
        if data_disks is not None:
            pulumi.set(__self__, "data_disks", data_disks)
        if encryption_at_host_enabled is not None:
            pulumi.set(__self__, "encryption_at_host_enabled", encryption_at_host_enabled)
        if eviction_policy is not None:
            pulumi.set(__self__, "eviction_policy", eviction_policy)
        if extension_operations_enabled is not None:
            pulumi.set(__self__, "extension_operations_enabled", extension_operations_enabled)
        if extensions is not None:
            pulumi.set(__self__, "extensions", extensions)
        if extensions_time_budget is not None:
            pulumi.set(__self__, "extensions_time_budget", extensions_time_budget)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if instances is not None:
            pulumi.set(__self__, "instances", instances)
        if license_type is not None:
            pulumi.set(__self__, "license_type", license_type)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if max_bid_price is not None:
            pulumi.set(__self__, "max_bid_price", max_bid_price)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_interfaces is not None:
            pulumi.set(__self__, "network_interfaces", network_interfaces)
        if os_disk is not None:
            pulumi.set(__self__, "os_disk", os_disk)
        if os_profile is not None:
            pulumi.set(__self__, "os_profile", os_profile)
        if plan is not None:
            pulumi.set(__self__, "plan", plan)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if priority_mix is not None:
            pulumi.set(__self__, "priority_mix", priority_mix)
        if proximity_placement_group_id is not None:
            pulumi.set(__self__, "proximity_placement_group_id", proximity_placement_group_id)
        if rolling_upgrade_policy is not None:
            pulumi.set(__self__, "rolling_upgrade_policy", rolling_upgrade_policy)
        if single_placement_group is not None:
            pulumi.set(__self__, "single_placement_group", single_placement_group)
        if sku_name is not None:
            pulumi.set(__self__, "sku_name", sku_name)
        if sku_profile is not None:
            pulumi.set(__self__, "sku_profile", sku_profile)
        if source_image_id is not None:
            pulumi.set(__self__, "source_image_id", source_image_id)
        if source_image_reference is not None:
            pulumi.set(__self__, "source_image_reference", source_image_reference)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if termination_notification is not None:
            pulumi.set(__self__, "termination_notification", termination_notification)
        if upgrade_mode is not None:
            pulumi.set(__self__, "upgrade_mode", upgrade_mode)
        if user_data_base64 is not None:
            pulumi.set(__self__, "user_data_base64", user_data_base64)
        if zone_balance is not None:
            pulumi.set(__self__, "zone_balance", zone_balance)
        if zones is not None:
            pulumi.set(__self__, "zones", zones)

    @_builtins.property
    @pulumi.getter(name="platformFaultDomainCount")
    def platform_fault_domain_count(self) -> pulumi.Input[_builtins.int]:
        """
        Specifies the number of fault domains that are used by this Virtual Machine Scale Set. Changing this forces a new resource to be created.

        > **Note:** The number of Fault Domains varies depending on which Azure Region you're using. More information about update and fault domains and how they work can be found [here](https://learn.microsoft.com/en-us/azure/virtual-machines/availability-set-overview).
        """
        return pulumi.get(self, "platform_fault_domain_count")

    @platform_fault_domain_count.setter
    def platform_fault_domain_count(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "platform_fault_domain_count", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the Resource Group in which the Virtual Machine Scale Set should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="additionalCapabilities")
    def additional_capabilities(self) -> Optional[pulumi.Input['OrchestratedVirtualMachineScaleSetAdditionalCapabilitiesArgs']]:
        """
        An `additional_capabilities` block as defined below.
        """
        return pulumi.get(self, "additional_capabilities")

    @additional_capabilities.setter
    def additional_capabilities(self, value: Optional[pulumi.Input['OrchestratedVirtualMachineScaleSetAdditionalCapabilitiesArgs']]):
        pulumi.set(self, "additional_capabilities", value)

    @_builtins.property
    @pulumi.getter(name="automaticInstanceRepair")
    def automatic_instance_repair(self) -> Optional[pulumi.Input['OrchestratedVirtualMachineScaleSetAutomaticInstanceRepairArgs']]:
        """
        An `automatic_instance_repair` block as defined below.

        > **Note:** To enable the `automatic_instance_repair`, the Orchestrated Virtual Machine Scale Set must have a valid [Application Health Extension](https://docs.microsoft.com/azure/virtual-machine-scale-sets/virtual-machine-scale-sets-health-extension).
        """
        return pulumi.get(self, "automatic_instance_repair")

    @automatic_instance_repair.setter
    def automatic_instance_repair(self, value: Optional[pulumi.Input['OrchestratedVirtualMachineScaleSetAutomaticInstanceRepairArgs']]):
        pulumi.set(self, "automatic_instance_repair", value)

    @_builtins.property
    @pulumi.getter(name="bootDiagnostics")
    def boot_diagnostics(self) -> Optional[pulumi.Input['OrchestratedVirtualMachineScaleSetBootDiagnosticsArgs']]:
        """
        A `boot_diagnostics` block as defined below.
        """
        return pulumi.get(self, "boot_diagnostics")

    @boot_diagnostics.setter
    def boot_diagnostics(self, value: Optional[pulumi.Input['OrchestratedVirtualMachineScaleSetBootDiagnosticsArgs']]):
        pulumi.set(self, "boot_diagnostics", value)

    @_builtins.property
    @pulumi.getter(name="capacityReservationGroupId")
    def capacity_reservation_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the ID of the Capacity Reservation Group which the Virtual Machine Scale Set should be allocated to. Changing this forces a new resource to be created.

        > **Note:** `capacity_reservation_group_id` cannot be specified with `proximity_placement_group_id`

        > **Note:** If `capacity_reservation_group_id` is specified the `single_placement_group` must be set to `false`.
        """
        return pulumi.get(self, "capacity_reservation_group_id")

    @capacity_reservation_group_id.setter
    def capacity_reservation_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "capacity_reservation_group_id", value)

    @_builtins.property
    @pulumi.getter(name="dataDisks")
    def data_disks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OrchestratedVirtualMachineScaleSetDataDiskArgs']]]]:
        """
        One or more `data_disk` blocks as defined below.
        """
        return pulumi.get(self, "data_disks")

    @data_disks.setter
    def data_disks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OrchestratedVirtualMachineScaleSetDataDiskArgs']]]]):
        pulumi.set(self, "data_disks", value)

    @_builtins.property
    @pulumi.getter(name="encryptionAtHostEnabled")
    def encryption_at_host_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should disks attached to this Virtual Machine Scale Set be encrypted by enabling Encryption at Host?
        """
        return pulumi.get(self, "encryption_at_host_enabled")

    @encryption_at_host_enabled.setter
    def encryption_at_host_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "encryption_at_host_enabled", value)

    @_builtins.property
    @pulumi.getter(name="evictionPolicy")
    def eviction_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Policy which should be used by Spot Virtual Machines that are Evicted from the Scale Set. Possible values are `Deallocate` and `Delete`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "eviction_policy")

    @eviction_policy.setter
    def eviction_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "eviction_policy", value)

    @_builtins.property
    @pulumi.getter(name="extensionOperationsEnabled")
    def extension_operations_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should extension operations be allowed on the Virtual Machine Scale Set? Possible values are `true` or `false`. Defaults to `true`. Changing this forces a new Virtual Machine Scale Set to be created.

        > **Note:** `extension_operations_enabled` may only be set to `false` if there are no extensions defined in the `extension` field.
        """
        return pulumi.get(self, "extension_operations_enabled")

    @extension_operations_enabled.setter
    def extension_operations_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "extension_operations_enabled", value)

    @_builtins.property
    @pulumi.getter
    def extensions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OrchestratedVirtualMachineScaleSetExtensionArgs']]]]:
        """
        One or more `extension` blocks as defined below
        """
        return pulumi.get(self, "extensions")

    @extensions.setter
    def extensions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OrchestratedVirtualMachineScaleSetExtensionArgs']]]]):
        pulumi.set(self, "extensions", value)

    @_builtins.property
    @pulumi.getter(name="extensionsTimeBudget")
    def extensions_time_budget(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the time alloted for all extensions to start. The time duration should be between 15 minutes and 120 minutes (inclusive) and should be specified in ISO 8601 format. Defaults to `PT1H30M`.
        """
        return pulumi.get(self, "extensions_time_budget")

    @extensions_time_budget.setter
    def extensions_time_budget(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "extensions_time_budget", value)

    @_builtins.property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['OrchestratedVirtualMachineScaleSetIdentityArgs']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['OrchestratedVirtualMachineScaleSetIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @_builtins.property
    @pulumi.getter
    def instances(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of Virtual Machines in the Virtual Machine Scale Set.
        """
        return pulumi.get(self, "instances")

    @instances.setter
    def instances(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "instances", value)

    @_builtins.property
    @pulumi.getter(name="licenseType")
    def license_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the type of on-premise license (also known as Azure Hybrid Use Benefit) which should be used for this Virtual Machine Scale Set. Possible values are `None`, `Windows_Client` and `Windows_Server`.
        """
        return pulumi.get(self, "license_type")

    @license_type.setter
    def license_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "license_type", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Azure location where the Virtual Machine Scale Set should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="maxBidPrice")
    def max_bid_price(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        The maximum price you're willing to pay for each Virtual Machine in this Scale Set, in US Dollars; which must be greater than the current spot price. If this bid price falls below the current spot price the Virtual Machines in the Scale Set will be evicted using the eviction_policy. Defaults to `-1`, which means that each Virtual Machine in the Scale Set should not be evicted for price reasons.
        """
        return pulumi.get(self, "max_bid_price")

    @max_bid_price.setter
    def max_bid_price(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "max_bid_price", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Virtual Machine Scale Set. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="networkInterfaces")
    def network_interfaces(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OrchestratedVirtualMachineScaleSetNetworkInterfaceArgs']]]]:
        """
        One or more `network_interface` blocks as defined below.
        """
        return pulumi.get(self, "network_interfaces")

    @network_interfaces.setter
    def network_interfaces(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OrchestratedVirtualMachineScaleSetNetworkInterfaceArgs']]]]):
        pulumi.set(self, "network_interfaces", value)

    @_builtins.property
    @pulumi.getter(name="osDisk")
    def os_disk(self) -> Optional[pulumi.Input['OrchestratedVirtualMachineScaleSetOsDiskArgs']]:
        """
        An `os_disk` block as defined below.
        """
        return pulumi.get(self, "os_disk")

    @os_disk.setter
    def os_disk(self, value: Optional[pulumi.Input['OrchestratedVirtualMachineScaleSetOsDiskArgs']]):
        pulumi.set(self, "os_disk", value)

    @_builtins.property
    @pulumi.getter(name="osProfile")
    def os_profile(self) -> Optional[pulumi.Input['OrchestratedVirtualMachineScaleSetOsProfileArgs']]:
        """
        An `os_profile` block as defined below.
        """
        return pulumi.get(self, "os_profile")

    @os_profile.setter
    def os_profile(self, value: Optional[pulumi.Input['OrchestratedVirtualMachineScaleSetOsProfileArgs']]):
        pulumi.set(self, "os_profile", value)

    @_builtins.property
    @pulumi.getter
    def plan(self) -> Optional[pulumi.Input['OrchestratedVirtualMachineScaleSetPlanArgs']]:
        """
        A `plan` block as documented below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "plan")

    @plan.setter
    def plan(self, value: Optional[pulumi.Input['OrchestratedVirtualMachineScaleSetPlanArgs']]):
        pulumi.set(self, "plan", value)

    @_builtins.property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Priority of this Virtual Machine Scale Set. Possible values are `Regular` and `Spot`. Defaults to `Regular`. Changing this value forces a new resource.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "priority", value)

    @_builtins.property
    @pulumi.getter(name="priorityMix")
    def priority_mix(self) -> Optional[pulumi.Input['OrchestratedVirtualMachineScaleSetPriorityMixArgs']]:
        """
        a `priority_mix` block as defined below
        """
        return pulumi.get(self, "priority_mix")

    @priority_mix.setter
    def priority_mix(self, value: Optional[pulumi.Input['OrchestratedVirtualMachineScaleSetPriorityMixArgs']]):
        pulumi.set(self, "priority_mix", value)

    @_builtins.property
    @pulumi.getter(name="proximityPlacementGroupId")
    def proximity_placement_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Proximity Placement Group which the Virtual Machine should be assigned to. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "proximity_placement_group_id")

    @proximity_placement_group_id.setter
    def proximity_placement_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "proximity_placement_group_id", value)

    @_builtins.property
    @pulumi.getter(name="rollingUpgradePolicy")
    def rolling_upgrade_policy(self) -> Optional[pulumi.Input['OrchestratedVirtualMachineScaleSetRollingUpgradePolicyArgs']]:
        """
        A `rolling_upgrade_policy` block as defined below. This is Required when `upgrade_mode` is set to `Rolling` and cannot be specified when `upgrade_mode` is set to `Manual`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "rolling_upgrade_policy")

    @rolling_upgrade_policy.setter
    def rolling_upgrade_policy(self, value: Optional[pulumi.Input['OrchestratedVirtualMachineScaleSetRollingUpgradePolicyArgs']]):
        pulumi.set(self, "rolling_upgrade_policy", value)

    @_builtins.property
    @pulumi.getter(name="singlePlacementGroup")
    def single_placement_group(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should this Virtual Machine Scale Set be limited to a Single Placement Group, which means the number of instances will be capped at 100 Virtual Machines. Possible values are `true` or `false`.

        > **Note:** `single_placement_group` behaves differently for Flexible orchestration Virtual Machine Scale Sets than it does for Uniform orchestration Virtual Machine Scale Sets. It is recommended that you do not define the `single_placement_group` field in your configuration file as the service will determine what this value should be based off of the value contained within the `sku_name` field of your configuration file. You may set the `single_placement_group` field to `true`, however once you set it to `false` you will not be able to revert it back to `true`.
        """
        return pulumi.get(self, "single_placement_group")

    @single_placement_group.setter
    def single_placement_group(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "single_placement_group", value)

    @_builtins.property
    @pulumi.getter(name="skuName")
    def sku_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The `name` of the SKU to be used by this Virtual Machine Scale Set. Valid values include: any of the [General purpose](https://docs.microsoft.com/azure/virtual-machines/sizes-general), [Compute optimized](https://docs.microsoft.com/azure/virtual-machines/sizes-compute), [Memory optimized](https://docs.microsoft.com/azure/virtual-machines/sizes-memory), [Storage optimized](https://docs.microsoft.com/azure/virtual-machines/sizes-storage), [GPU optimized](https://docs.microsoft.com/azure/virtual-machines/sizes-gpu), [FPGA optimized](https://docs.microsoft.com/azure/virtual-machines/sizes-field-programmable-gate-arrays), [High performance](https://docs.microsoft.com/azure/virtual-machines/sizes-hpc), or [Previous generation](https://docs.microsoft.com/azure/virtual-machines/sizes-previous-gen) virtual machine SKUs.
        """
        return pulumi.get(self, "sku_name")

    @sku_name.setter
    def sku_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sku_name", value)

    @_builtins.property
    @pulumi.getter(name="skuProfile")
    def sku_profile(self) -> Optional[pulumi.Input['OrchestratedVirtualMachineScaleSetSkuProfileArgs']]:
        """
        An `sku_profile` block as defined below. Changing this forces a new resource to be created.

        > **Note:** If `sku_profile` is specified the `sku_name` must be set to `Mix`.
        """
        return pulumi.get(self, "sku_profile")

    @sku_profile.setter
    def sku_profile(self, value: Optional[pulumi.Input['OrchestratedVirtualMachineScaleSetSkuProfileArgs']]):
        pulumi.set(self, "sku_profile", value)

    @_builtins.property
    @pulumi.getter(name="sourceImageId")
    def source_image_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of an Image which each Virtual Machine in this Scale Set should be based on. Possible Image ID types include `Image ID`s, `Shared Image ID`s, `Shared Image Version ID`s, `Community Gallery Image ID`s, `Community Gallery Image Version ID`s, `Shared Gallery Image ID`s and `Shared Gallery Image Version ID`s.
        """
        return pulumi.get(self, "source_image_id")

    @source_image_id.setter
    def source_image_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_image_id", value)

    @_builtins.property
    @pulumi.getter(name="sourceImageReference")
    def source_image_reference(self) -> Optional[pulumi.Input['OrchestratedVirtualMachineScaleSetSourceImageReferenceArgs']]:
        """
        A `source_image_reference` block as defined below.
        """
        return pulumi.get(self, "source_image_reference")

    @source_image_reference.setter
    def source_image_reference(self, value: Optional[pulumi.Input['OrchestratedVirtualMachineScaleSetSourceImageReferenceArgs']]):
        pulumi.set(self, "source_image_reference", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags which should be assigned to this Virtual Machine Scale Set.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="terminationNotification")
    def termination_notification(self) -> Optional[pulumi.Input['OrchestratedVirtualMachineScaleSetTerminationNotificationArgs']]:
        """
        A `termination_notification` block as defined below.
        """
        return pulumi.get(self, "termination_notification")

    @termination_notification.setter
    def termination_notification(self, value: Optional[pulumi.Input['OrchestratedVirtualMachineScaleSetTerminationNotificationArgs']]):
        pulumi.set(self, "termination_notification", value)

    @_builtins.property
    @pulumi.getter(name="upgradeMode")
    def upgrade_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies how upgrades (e.g. changing the Image/SKU) should be performed to Virtual Machine Instances. Possible values are `Automatic`, `Manual` and `Rolling`. Defaults to `Manual`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "upgrade_mode")

    @upgrade_mode.setter
    def upgrade_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "upgrade_mode", value)

    @_builtins.property
    @pulumi.getter(name="userDataBase64")
    def user_data_base64(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Base64-Encoded User Data which should be used for this Virtual Machine Scale Set.
        """
        return pulumi.get(self, "user_data_base64")

    @user_data_base64.setter
    def user_data_base64(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_data_base64", value)

    @_builtins.property
    @pulumi.getter(name="zoneBalance")
    def zone_balance(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should the Virtual Machines in this Scale Set be strictly evenly distributed across Availability Zones? Defaults to `false`. Changing this forces a new resource to be created.

        > **Note:** This can only be set to `true` when one or more `zones` are configured.
        """
        return pulumi.get(self, "zone_balance")

    @zone_balance.setter
    def zone_balance(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "zone_balance", value)

    @_builtins.property
    @pulumi.getter
    def zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies a list of Availability Zones across which the Virtual Machine Scale Set will create instances.

        > **Note:** Updating `zones` to remove an existing zone forces a new Virtual Machine Scale Set to be created.

        > **Note:** Availability Zones are [only supported in several regions at this time](https://docs.microsoft.com/azure/availability-zones/az-overview).
        """
        return pulumi.get(self, "zones")

    @zones.setter
    def zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "zones", value)


@pulumi.input_type
class _OrchestratedVirtualMachineScaleSetState:
    def __init__(__self__, *,
                 additional_capabilities: Optional[pulumi.Input['OrchestratedVirtualMachineScaleSetAdditionalCapabilitiesArgs']] = None,
                 automatic_instance_repair: Optional[pulumi.Input['OrchestratedVirtualMachineScaleSetAutomaticInstanceRepairArgs']] = None,
                 boot_diagnostics: Optional[pulumi.Input['OrchestratedVirtualMachineScaleSetBootDiagnosticsArgs']] = None,
                 capacity_reservation_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 data_disks: Optional[pulumi.Input[Sequence[pulumi.Input['OrchestratedVirtualMachineScaleSetDataDiskArgs']]]] = None,
                 encryption_at_host_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 eviction_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 extension_operations_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 extensions: Optional[pulumi.Input[Sequence[pulumi.Input['OrchestratedVirtualMachineScaleSetExtensionArgs']]]] = None,
                 extensions_time_budget: Optional[pulumi.Input[_builtins.str]] = None,
                 identity: Optional[pulumi.Input['OrchestratedVirtualMachineScaleSetIdentityArgs']] = None,
                 instances: Optional[pulumi.Input[_builtins.int]] = None,
                 license_type: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 max_bid_price: Optional[pulumi.Input[_builtins.float]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input['OrchestratedVirtualMachineScaleSetNetworkInterfaceArgs']]]] = None,
                 os_disk: Optional[pulumi.Input['OrchestratedVirtualMachineScaleSetOsDiskArgs']] = None,
                 os_profile: Optional[pulumi.Input['OrchestratedVirtualMachineScaleSetOsProfileArgs']] = None,
                 plan: Optional[pulumi.Input['OrchestratedVirtualMachineScaleSetPlanArgs']] = None,
                 platform_fault_domain_count: Optional[pulumi.Input[_builtins.int]] = None,
                 priority: Optional[pulumi.Input[_builtins.str]] = None,
                 priority_mix: Optional[pulumi.Input['OrchestratedVirtualMachineScaleSetPriorityMixArgs']] = None,
                 proximity_placement_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 rolling_upgrade_policy: Optional[pulumi.Input['OrchestratedVirtualMachineScaleSetRollingUpgradePolicyArgs']] = None,
                 single_placement_group: Optional[pulumi.Input[_builtins.bool]] = None,
                 sku_name: Optional[pulumi.Input[_builtins.str]] = None,
                 sku_profile: Optional[pulumi.Input['OrchestratedVirtualMachineScaleSetSkuProfileArgs']] = None,
                 source_image_id: Optional[pulumi.Input[_builtins.str]] = None,
                 source_image_reference: Optional[pulumi.Input['OrchestratedVirtualMachineScaleSetSourceImageReferenceArgs']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 termination_notification: Optional[pulumi.Input['OrchestratedVirtualMachineScaleSetTerminationNotificationArgs']] = None,
                 unique_id: Optional[pulumi.Input[_builtins.str]] = None,
                 upgrade_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 user_data_base64: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_balance: Optional[pulumi.Input[_builtins.bool]] = None,
                 zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering OrchestratedVirtualMachineScaleSet resources.
        :param pulumi.Input['OrchestratedVirtualMachineScaleSetAdditionalCapabilitiesArgs'] additional_capabilities: An `additional_capabilities` block as defined below.
        :param pulumi.Input['OrchestratedVirtualMachineScaleSetAutomaticInstanceRepairArgs'] automatic_instance_repair: An `automatic_instance_repair` block as defined below.
               
               > **Note:** To enable the `automatic_instance_repair`, the Orchestrated Virtual Machine Scale Set must have a valid [Application Health Extension](https://docs.microsoft.com/azure/virtual-machine-scale-sets/virtual-machine-scale-sets-health-extension).
        :param pulumi.Input['OrchestratedVirtualMachineScaleSetBootDiagnosticsArgs'] boot_diagnostics: A `boot_diagnostics` block as defined below.
        :param pulumi.Input[_builtins.str] capacity_reservation_group_id: Specifies the ID of the Capacity Reservation Group which the Virtual Machine Scale Set should be allocated to. Changing this forces a new resource to be created.
               
               > **Note:** `capacity_reservation_group_id` cannot be specified with `proximity_placement_group_id`
               
               > **Note:** If `capacity_reservation_group_id` is specified the `single_placement_group` must be set to `false`.
        :param pulumi.Input[Sequence[pulumi.Input['OrchestratedVirtualMachineScaleSetDataDiskArgs']]] data_disks: One or more `data_disk` blocks as defined below.
        :param pulumi.Input[_builtins.bool] encryption_at_host_enabled: Should disks attached to this Virtual Machine Scale Set be encrypted by enabling Encryption at Host?
        :param pulumi.Input[_builtins.str] eviction_policy: The Policy which should be used by Spot Virtual Machines that are Evicted from the Scale Set. Possible values are `Deallocate` and `Delete`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] extension_operations_enabled: Should extension operations be allowed on the Virtual Machine Scale Set? Possible values are `true` or `false`. Defaults to `true`. Changing this forces a new Virtual Machine Scale Set to be created.
               
               > **Note:** `extension_operations_enabled` may only be set to `false` if there are no extensions defined in the `extension` field.
        :param pulumi.Input[Sequence[pulumi.Input['OrchestratedVirtualMachineScaleSetExtensionArgs']]] extensions: One or more `extension` blocks as defined below
        :param pulumi.Input[_builtins.str] extensions_time_budget: Specifies the time alloted for all extensions to start. The time duration should be between 15 minutes and 120 minutes (inclusive) and should be specified in ISO 8601 format. Defaults to `PT1H30M`.
        :param pulumi.Input['OrchestratedVirtualMachineScaleSetIdentityArgs'] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.int] instances: The number of Virtual Machines in the Virtual Machine Scale Set.
        :param pulumi.Input[_builtins.str] license_type: Specifies the type of on-premise license (also known as Azure Hybrid Use Benefit) which should be used for this Virtual Machine Scale Set. Possible values are `None`, `Windows_Client` and `Windows_Server`.
        :param pulumi.Input[_builtins.str] location: The Azure location where the Virtual Machine Scale Set should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.float] max_bid_price: The maximum price you're willing to pay for each Virtual Machine in this Scale Set, in US Dollars; which must be greater than the current spot price. If this bid price falls below the current spot price the Virtual Machines in the Scale Set will be evicted using the eviction_policy. Defaults to `-1`, which means that each Virtual Machine in the Scale Set should not be evicted for price reasons.
        :param pulumi.Input[_builtins.str] name: The name of the Virtual Machine Scale Set. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input['OrchestratedVirtualMachineScaleSetNetworkInterfaceArgs']]] network_interfaces: One or more `network_interface` blocks as defined below.
        :param pulumi.Input['OrchestratedVirtualMachineScaleSetOsDiskArgs'] os_disk: An `os_disk` block as defined below.
        :param pulumi.Input['OrchestratedVirtualMachineScaleSetOsProfileArgs'] os_profile: An `os_profile` block as defined below.
        :param pulumi.Input['OrchestratedVirtualMachineScaleSetPlanArgs'] plan: A `plan` block as documented below. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] platform_fault_domain_count: Specifies the number of fault domains that are used by this Virtual Machine Scale Set. Changing this forces a new resource to be created.
               
               > **Note:** The number of Fault Domains varies depending on which Azure Region you're using. More information about update and fault domains and how they work can be found [here](https://learn.microsoft.com/en-us/azure/virtual-machines/availability-set-overview).
        :param pulumi.Input[_builtins.str] priority: The Priority of this Virtual Machine Scale Set. Possible values are `Regular` and `Spot`. Defaults to `Regular`. Changing this value forces a new resource.
        :param pulumi.Input['OrchestratedVirtualMachineScaleSetPriorityMixArgs'] priority_mix: a `priority_mix` block as defined below
        :param pulumi.Input[_builtins.str] proximity_placement_group_id: The ID of the Proximity Placement Group which the Virtual Machine should be assigned to. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group in which the Virtual Machine Scale Set should exist. Changing this forces a new resource to be created.
        :param pulumi.Input['OrchestratedVirtualMachineScaleSetRollingUpgradePolicyArgs'] rolling_upgrade_policy: A `rolling_upgrade_policy` block as defined below. This is Required when `upgrade_mode` is set to `Rolling` and cannot be specified when `upgrade_mode` is set to `Manual`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] single_placement_group: Should this Virtual Machine Scale Set be limited to a Single Placement Group, which means the number of instances will be capped at 100 Virtual Machines. Possible values are `true` or `false`.
               
               > **Note:** `single_placement_group` behaves differently for Flexible orchestration Virtual Machine Scale Sets than it does for Uniform orchestration Virtual Machine Scale Sets. It is recommended that you do not define the `single_placement_group` field in your configuration file as the service will determine what this value should be based off of the value contained within the `sku_name` field of your configuration file. You may set the `single_placement_group` field to `true`, however once you set it to `false` you will not be able to revert it back to `true`.
        :param pulumi.Input[_builtins.str] sku_name: The `name` of the SKU to be used by this Virtual Machine Scale Set. Valid values include: any of the [General purpose](https://docs.microsoft.com/azure/virtual-machines/sizes-general), [Compute optimized](https://docs.microsoft.com/azure/virtual-machines/sizes-compute), [Memory optimized](https://docs.microsoft.com/azure/virtual-machines/sizes-memory), [Storage optimized](https://docs.microsoft.com/azure/virtual-machines/sizes-storage), [GPU optimized](https://docs.microsoft.com/azure/virtual-machines/sizes-gpu), [FPGA optimized](https://docs.microsoft.com/azure/virtual-machines/sizes-field-programmable-gate-arrays), [High performance](https://docs.microsoft.com/azure/virtual-machines/sizes-hpc), or [Previous generation](https://docs.microsoft.com/azure/virtual-machines/sizes-previous-gen) virtual machine SKUs.
        :param pulumi.Input['OrchestratedVirtualMachineScaleSetSkuProfileArgs'] sku_profile: An `sku_profile` block as defined below. Changing this forces a new resource to be created.
               
               > **Note:** If `sku_profile` is specified the `sku_name` must be set to `Mix`.
        :param pulumi.Input[_builtins.str] source_image_id: The ID of an Image which each Virtual Machine in this Scale Set should be based on. Possible Image ID types include `Image ID`s, `Shared Image ID`s, `Shared Image Version ID`s, `Community Gallery Image ID`s, `Community Gallery Image Version ID`s, `Shared Gallery Image ID`s and `Shared Gallery Image Version ID`s.
        :param pulumi.Input['OrchestratedVirtualMachineScaleSetSourceImageReferenceArgs'] source_image_reference: A `source_image_reference` block as defined below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to this Virtual Machine Scale Set.
        :param pulumi.Input['OrchestratedVirtualMachineScaleSetTerminationNotificationArgs'] termination_notification: A `termination_notification` block as defined below.
        :param pulumi.Input[_builtins.str] unique_id: The Unique ID for the Virtual Machine Scale Set.
        :param pulumi.Input[_builtins.str] upgrade_mode: Specifies how upgrades (e.g. changing the Image/SKU) should be performed to Virtual Machine Instances. Possible values are `Automatic`, `Manual` and `Rolling`. Defaults to `Manual`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] user_data_base64: The Base64-Encoded User Data which should be used for this Virtual Machine Scale Set.
        :param pulumi.Input[_builtins.bool] zone_balance: Should the Virtual Machines in this Scale Set be strictly evenly distributed across Availability Zones? Defaults to `false`. Changing this forces a new resource to be created.
               
               > **Note:** This can only be set to `true` when one or more `zones` are configured.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] zones: Specifies a list of Availability Zones across which the Virtual Machine Scale Set will create instances.
               
               > **Note:** Updating `zones` to remove an existing zone forces a new Virtual Machine Scale Set to be created.
               
               > **Note:** Availability Zones are [only supported in several regions at this time](https://docs.microsoft.com/azure/availability-zones/az-overview).
        """
        if additional_capabilities is not None:
            pulumi.set(__self__, "additional_capabilities", additional_capabilities)
        if automatic_instance_repair is not None:
            pulumi.set(__self__, "automatic_instance_repair", automatic_instance_repair)
        if boot_diagnostics is not None:
            pulumi.set(__self__, "boot_diagnostics", boot_diagnostics)
        if capacity_reservation_group_id is not None:
            pulumi.set(__self__, "capacity_reservation_group_id", capacity_reservation_group_id)
        if data_disks is not None:
            pulumi.set(__self__, "data_disks", data_disks)
        if encryption_at_host_enabled is not None:
            pulumi.set(__self__, "encryption_at_host_enabled", encryption_at_host_enabled)
        if eviction_policy is not None:
            pulumi.set(__self__, "eviction_policy", eviction_policy)
        if extension_operations_enabled is not None:
            pulumi.set(__self__, "extension_operations_enabled", extension_operations_enabled)
        if extensions is not None:
            pulumi.set(__self__, "extensions", extensions)
        if extensions_time_budget is not None:
            pulumi.set(__self__, "extensions_time_budget", extensions_time_budget)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if instances is not None:
            pulumi.set(__self__, "instances", instances)
        if license_type is not None:
            pulumi.set(__self__, "license_type", license_type)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if max_bid_price is not None:
            pulumi.set(__self__, "max_bid_price", max_bid_price)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_interfaces is not None:
            pulumi.set(__self__, "network_interfaces", network_interfaces)
        if os_disk is not None:
            pulumi.set(__self__, "os_disk", os_disk)
        if os_profile is not None:
            pulumi.set(__self__, "os_profile", os_profile)
        if plan is not None:
            pulumi.set(__self__, "plan", plan)
        if platform_fault_domain_count is not None:
            pulumi.set(__self__, "platform_fault_domain_count", platform_fault_domain_count)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if priority_mix is not None:
            pulumi.set(__self__, "priority_mix", priority_mix)
        if proximity_placement_group_id is not None:
            pulumi.set(__self__, "proximity_placement_group_id", proximity_placement_group_id)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if rolling_upgrade_policy is not None:
            pulumi.set(__self__, "rolling_upgrade_policy", rolling_upgrade_policy)
        if single_placement_group is not None:
            pulumi.set(__self__, "single_placement_group", single_placement_group)
        if sku_name is not None:
            pulumi.set(__self__, "sku_name", sku_name)
        if sku_profile is not None:
            pulumi.set(__self__, "sku_profile", sku_profile)
        if source_image_id is not None:
            pulumi.set(__self__, "source_image_id", source_image_id)
        if source_image_reference is not None:
            pulumi.set(__self__, "source_image_reference", source_image_reference)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if termination_notification is not None:
            pulumi.set(__self__, "termination_notification", termination_notification)
        if unique_id is not None:
            pulumi.set(__self__, "unique_id", unique_id)
        if upgrade_mode is not None:
            pulumi.set(__self__, "upgrade_mode", upgrade_mode)
        if user_data_base64 is not None:
            pulumi.set(__self__, "user_data_base64", user_data_base64)
        if zone_balance is not None:
            pulumi.set(__self__, "zone_balance", zone_balance)
        if zones is not None:
            pulumi.set(__self__, "zones", zones)

    @_builtins.property
    @pulumi.getter(name="additionalCapabilities")
    def additional_capabilities(self) -> Optional[pulumi.Input['OrchestratedVirtualMachineScaleSetAdditionalCapabilitiesArgs']]:
        """
        An `additional_capabilities` block as defined below.
        """
        return pulumi.get(self, "additional_capabilities")

    @additional_capabilities.setter
    def additional_capabilities(self, value: Optional[pulumi.Input['OrchestratedVirtualMachineScaleSetAdditionalCapabilitiesArgs']]):
        pulumi.set(self, "additional_capabilities", value)

    @_builtins.property
    @pulumi.getter(name="automaticInstanceRepair")
    def automatic_instance_repair(self) -> Optional[pulumi.Input['OrchestratedVirtualMachineScaleSetAutomaticInstanceRepairArgs']]:
        """
        An `automatic_instance_repair` block as defined below.

        > **Note:** To enable the `automatic_instance_repair`, the Orchestrated Virtual Machine Scale Set must have a valid [Application Health Extension](https://docs.microsoft.com/azure/virtual-machine-scale-sets/virtual-machine-scale-sets-health-extension).
        """
        return pulumi.get(self, "automatic_instance_repair")

    @automatic_instance_repair.setter
    def automatic_instance_repair(self, value: Optional[pulumi.Input['OrchestratedVirtualMachineScaleSetAutomaticInstanceRepairArgs']]):
        pulumi.set(self, "automatic_instance_repair", value)

    @_builtins.property
    @pulumi.getter(name="bootDiagnostics")
    def boot_diagnostics(self) -> Optional[pulumi.Input['OrchestratedVirtualMachineScaleSetBootDiagnosticsArgs']]:
        """
        A `boot_diagnostics` block as defined below.
        """
        return pulumi.get(self, "boot_diagnostics")

    @boot_diagnostics.setter
    def boot_diagnostics(self, value: Optional[pulumi.Input['OrchestratedVirtualMachineScaleSetBootDiagnosticsArgs']]):
        pulumi.set(self, "boot_diagnostics", value)

    @_builtins.property
    @pulumi.getter(name="capacityReservationGroupId")
    def capacity_reservation_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the ID of the Capacity Reservation Group which the Virtual Machine Scale Set should be allocated to. Changing this forces a new resource to be created.

        > **Note:** `capacity_reservation_group_id` cannot be specified with `proximity_placement_group_id`

        > **Note:** If `capacity_reservation_group_id` is specified the `single_placement_group` must be set to `false`.
        """
        return pulumi.get(self, "capacity_reservation_group_id")

    @capacity_reservation_group_id.setter
    def capacity_reservation_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "capacity_reservation_group_id", value)

    @_builtins.property
    @pulumi.getter(name="dataDisks")
    def data_disks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OrchestratedVirtualMachineScaleSetDataDiskArgs']]]]:
        """
        One or more `data_disk` blocks as defined below.
        """
        return pulumi.get(self, "data_disks")

    @data_disks.setter
    def data_disks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OrchestratedVirtualMachineScaleSetDataDiskArgs']]]]):
        pulumi.set(self, "data_disks", value)

    @_builtins.property
    @pulumi.getter(name="encryptionAtHostEnabled")
    def encryption_at_host_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should disks attached to this Virtual Machine Scale Set be encrypted by enabling Encryption at Host?
        """
        return pulumi.get(self, "encryption_at_host_enabled")

    @encryption_at_host_enabled.setter
    def encryption_at_host_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "encryption_at_host_enabled", value)

    @_builtins.property
    @pulumi.getter(name="evictionPolicy")
    def eviction_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Policy which should be used by Spot Virtual Machines that are Evicted from the Scale Set. Possible values are `Deallocate` and `Delete`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "eviction_policy")

    @eviction_policy.setter
    def eviction_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "eviction_policy", value)

    @_builtins.property
    @pulumi.getter(name="extensionOperationsEnabled")
    def extension_operations_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should extension operations be allowed on the Virtual Machine Scale Set? Possible values are `true` or `false`. Defaults to `true`. Changing this forces a new Virtual Machine Scale Set to be created.

        > **Note:** `extension_operations_enabled` may only be set to `false` if there are no extensions defined in the `extension` field.
        """
        return pulumi.get(self, "extension_operations_enabled")

    @extension_operations_enabled.setter
    def extension_operations_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "extension_operations_enabled", value)

    @_builtins.property
    @pulumi.getter
    def extensions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OrchestratedVirtualMachineScaleSetExtensionArgs']]]]:
        """
        One or more `extension` blocks as defined below
        """
        return pulumi.get(self, "extensions")

    @extensions.setter
    def extensions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OrchestratedVirtualMachineScaleSetExtensionArgs']]]]):
        pulumi.set(self, "extensions", value)

    @_builtins.property
    @pulumi.getter(name="extensionsTimeBudget")
    def extensions_time_budget(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the time alloted for all extensions to start. The time duration should be between 15 minutes and 120 minutes (inclusive) and should be specified in ISO 8601 format. Defaults to `PT1H30M`.
        """
        return pulumi.get(self, "extensions_time_budget")

    @extensions_time_budget.setter
    def extensions_time_budget(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "extensions_time_budget", value)

    @_builtins.property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['OrchestratedVirtualMachineScaleSetIdentityArgs']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['OrchestratedVirtualMachineScaleSetIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @_builtins.property
    @pulumi.getter
    def instances(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of Virtual Machines in the Virtual Machine Scale Set.
        """
        return pulumi.get(self, "instances")

    @instances.setter
    def instances(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "instances", value)

    @_builtins.property
    @pulumi.getter(name="licenseType")
    def license_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the type of on-premise license (also known as Azure Hybrid Use Benefit) which should be used for this Virtual Machine Scale Set. Possible values are `None`, `Windows_Client` and `Windows_Server`.
        """
        return pulumi.get(self, "license_type")

    @license_type.setter
    def license_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "license_type", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Azure location where the Virtual Machine Scale Set should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="maxBidPrice")
    def max_bid_price(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        The maximum price you're willing to pay for each Virtual Machine in this Scale Set, in US Dollars; which must be greater than the current spot price. If this bid price falls below the current spot price the Virtual Machines in the Scale Set will be evicted using the eviction_policy. Defaults to `-1`, which means that each Virtual Machine in the Scale Set should not be evicted for price reasons.
        """
        return pulumi.get(self, "max_bid_price")

    @max_bid_price.setter
    def max_bid_price(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "max_bid_price", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Virtual Machine Scale Set. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="networkInterfaces")
    def network_interfaces(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OrchestratedVirtualMachineScaleSetNetworkInterfaceArgs']]]]:
        """
        One or more `network_interface` blocks as defined below.
        """
        return pulumi.get(self, "network_interfaces")

    @network_interfaces.setter
    def network_interfaces(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OrchestratedVirtualMachineScaleSetNetworkInterfaceArgs']]]]):
        pulumi.set(self, "network_interfaces", value)

    @_builtins.property
    @pulumi.getter(name="osDisk")
    def os_disk(self) -> Optional[pulumi.Input['OrchestratedVirtualMachineScaleSetOsDiskArgs']]:
        """
        An `os_disk` block as defined below.
        """
        return pulumi.get(self, "os_disk")

    @os_disk.setter
    def os_disk(self, value: Optional[pulumi.Input['OrchestratedVirtualMachineScaleSetOsDiskArgs']]):
        pulumi.set(self, "os_disk", value)

    @_builtins.property
    @pulumi.getter(name="osProfile")
    def os_profile(self) -> Optional[pulumi.Input['OrchestratedVirtualMachineScaleSetOsProfileArgs']]:
        """
        An `os_profile` block as defined below.
        """
        return pulumi.get(self, "os_profile")

    @os_profile.setter
    def os_profile(self, value: Optional[pulumi.Input['OrchestratedVirtualMachineScaleSetOsProfileArgs']]):
        pulumi.set(self, "os_profile", value)

    @_builtins.property
    @pulumi.getter
    def plan(self) -> Optional[pulumi.Input['OrchestratedVirtualMachineScaleSetPlanArgs']]:
        """
        A `plan` block as documented below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "plan")

    @plan.setter
    def plan(self, value: Optional[pulumi.Input['OrchestratedVirtualMachineScaleSetPlanArgs']]):
        pulumi.set(self, "plan", value)

    @_builtins.property
    @pulumi.getter(name="platformFaultDomainCount")
    def platform_fault_domain_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the number of fault domains that are used by this Virtual Machine Scale Set. Changing this forces a new resource to be created.

        > **Note:** The number of Fault Domains varies depending on which Azure Region you're using. More information about update and fault domains and how they work can be found [here](https://learn.microsoft.com/en-us/azure/virtual-machines/availability-set-overview).
        """
        return pulumi.get(self, "platform_fault_domain_count")

    @platform_fault_domain_count.setter
    def platform_fault_domain_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "platform_fault_domain_count", value)

    @_builtins.property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Priority of this Virtual Machine Scale Set. Possible values are `Regular` and `Spot`. Defaults to `Regular`. Changing this value forces a new resource.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "priority", value)

    @_builtins.property
    @pulumi.getter(name="priorityMix")
    def priority_mix(self) -> Optional[pulumi.Input['OrchestratedVirtualMachineScaleSetPriorityMixArgs']]:
        """
        a `priority_mix` block as defined below
        """
        return pulumi.get(self, "priority_mix")

    @priority_mix.setter
    def priority_mix(self, value: Optional[pulumi.Input['OrchestratedVirtualMachineScaleSetPriorityMixArgs']]):
        pulumi.set(self, "priority_mix", value)

    @_builtins.property
    @pulumi.getter(name="proximityPlacementGroupId")
    def proximity_placement_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Proximity Placement Group which the Virtual Machine should be assigned to. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "proximity_placement_group_id")

    @proximity_placement_group_id.setter
    def proximity_placement_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "proximity_placement_group_id", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Resource Group in which the Virtual Machine Scale Set should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="rollingUpgradePolicy")
    def rolling_upgrade_policy(self) -> Optional[pulumi.Input['OrchestratedVirtualMachineScaleSetRollingUpgradePolicyArgs']]:
        """
        A `rolling_upgrade_policy` block as defined below. This is Required when `upgrade_mode` is set to `Rolling` and cannot be specified when `upgrade_mode` is set to `Manual`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "rolling_upgrade_policy")

    @rolling_upgrade_policy.setter
    def rolling_upgrade_policy(self, value: Optional[pulumi.Input['OrchestratedVirtualMachineScaleSetRollingUpgradePolicyArgs']]):
        pulumi.set(self, "rolling_upgrade_policy", value)

    @_builtins.property
    @pulumi.getter(name="singlePlacementGroup")
    def single_placement_group(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should this Virtual Machine Scale Set be limited to a Single Placement Group, which means the number of instances will be capped at 100 Virtual Machines. Possible values are `true` or `false`.

        > **Note:** `single_placement_group` behaves differently for Flexible orchestration Virtual Machine Scale Sets than it does for Uniform orchestration Virtual Machine Scale Sets. It is recommended that you do not define the `single_placement_group` field in your configuration file as the service will determine what this value should be based off of the value contained within the `sku_name` field of your configuration file. You may set the `single_placement_group` field to `true`, however once you set it to `false` you will not be able to revert it back to `true`.
        """
        return pulumi.get(self, "single_placement_group")

    @single_placement_group.setter
    def single_placement_group(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "single_placement_group", value)

    @_builtins.property
    @pulumi.getter(name="skuName")
    def sku_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The `name` of the SKU to be used by this Virtual Machine Scale Set. Valid values include: any of the [General purpose](https://docs.microsoft.com/azure/virtual-machines/sizes-general), [Compute optimized](https://docs.microsoft.com/azure/virtual-machines/sizes-compute), [Memory optimized](https://docs.microsoft.com/azure/virtual-machines/sizes-memory), [Storage optimized](https://docs.microsoft.com/azure/virtual-machines/sizes-storage), [GPU optimized](https://docs.microsoft.com/azure/virtual-machines/sizes-gpu), [FPGA optimized](https://docs.microsoft.com/azure/virtual-machines/sizes-field-programmable-gate-arrays), [High performance](https://docs.microsoft.com/azure/virtual-machines/sizes-hpc), or [Previous generation](https://docs.microsoft.com/azure/virtual-machines/sizes-previous-gen) virtual machine SKUs.
        """
        return pulumi.get(self, "sku_name")

    @sku_name.setter
    def sku_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sku_name", value)

    @_builtins.property
    @pulumi.getter(name="skuProfile")
    def sku_profile(self) -> Optional[pulumi.Input['OrchestratedVirtualMachineScaleSetSkuProfileArgs']]:
        """
        An `sku_profile` block as defined below. Changing this forces a new resource to be created.

        > **Note:** If `sku_profile` is specified the `sku_name` must be set to `Mix`.
        """
        return pulumi.get(self, "sku_profile")

    @sku_profile.setter
    def sku_profile(self, value: Optional[pulumi.Input['OrchestratedVirtualMachineScaleSetSkuProfileArgs']]):
        pulumi.set(self, "sku_profile", value)

    @_builtins.property
    @pulumi.getter(name="sourceImageId")
    def source_image_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of an Image which each Virtual Machine in this Scale Set should be based on. Possible Image ID types include `Image ID`s, `Shared Image ID`s, `Shared Image Version ID`s, `Community Gallery Image ID`s, `Community Gallery Image Version ID`s, `Shared Gallery Image ID`s and `Shared Gallery Image Version ID`s.
        """
        return pulumi.get(self, "source_image_id")

    @source_image_id.setter
    def source_image_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_image_id", value)

    @_builtins.property
    @pulumi.getter(name="sourceImageReference")
    def source_image_reference(self) -> Optional[pulumi.Input['OrchestratedVirtualMachineScaleSetSourceImageReferenceArgs']]:
        """
        A `source_image_reference` block as defined below.
        """
        return pulumi.get(self, "source_image_reference")

    @source_image_reference.setter
    def source_image_reference(self, value: Optional[pulumi.Input['OrchestratedVirtualMachineScaleSetSourceImageReferenceArgs']]):
        pulumi.set(self, "source_image_reference", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags which should be assigned to this Virtual Machine Scale Set.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="terminationNotification")
    def termination_notification(self) -> Optional[pulumi.Input['OrchestratedVirtualMachineScaleSetTerminationNotificationArgs']]:
        """
        A `termination_notification` block as defined below.
        """
        return pulumi.get(self, "termination_notification")

    @termination_notification.setter
    def termination_notification(self, value: Optional[pulumi.Input['OrchestratedVirtualMachineScaleSetTerminationNotificationArgs']]):
        pulumi.set(self, "termination_notification", value)

    @_builtins.property
    @pulumi.getter(name="uniqueId")
    def unique_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Unique ID for the Virtual Machine Scale Set.
        """
        return pulumi.get(self, "unique_id")

    @unique_id.setter
    def unique_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "unique_id", value)

    @_builtins.property
    @pulumi.getter(name="upgradeMode")
    def upgrade_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies how upgrades (e.g. changing the Image/SKU) should be performed to Virtual Machine Instances. Possible values are `Automatic`, `Manual` and `Rolling`. Defaults to `Manual`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "upgrade_mode")

    @upgrade_mode.setter
    def upgrade_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "upgrade_mode", value)

    @_builtins.property
    @pulumi.getter(name="userDataBase64")
    def user_data_base64(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Base64-Encoded User Data which should be used for this Virtual Machine Scale Set.
        """
        return pulumi.get(self, "user_data_base64")

    @user_data_base64.setter
    def user_data_base64(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_data_base64", value)

    @_builtins.property
    @pulumi.getter(name="zoneBalance")
    def zone_balance(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should the Virtual Machines in this Scale Set be strictly evenly distributed across Availability Zones? Defaults to `false`. Changing this forces a new resource to be created.

        > **Note:** This can only be set to `true` when one or more `zones` are configured.
        """
        return pulumi.get(self, "zone_balance")

    @zone_balance.setter
    def zone_balance(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "zone_balance", value)

    @_builtins.property
    @pulumi.getter
    def zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies a list of Availability Zones across which the Virtual Machine Scale Set will create instances.

        > **Note:** Updating `zones` to remove an existing zone forces a new Virtual Machine Scale Set to be created.

        > **Note:** Availability Zones are [only supported in several regions at this time](https://docs.microsoft.com/azure/availability-zones/az-overview).
        """
        return pulumi.get(self, "zones")

    @zones.setter
    def zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "zones", value)


@pulumi.type_token("azure:compute/orchestratedVirtualMachineScaleSet:OrchestratedVirtualMachineScaleSet")
class OrchestratedVirtualMachineScaleSet(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 additional_capabilities: Optional[pulumi.Input[Union['OrchestratedVirtualMachineScaleSetAdditionalCapabilitiesArgs', 'OrchestratedVirtualMachineScaleSetAdditionalCapabilitiesArgsDict']]] = None,
                 automatic_instance_repair: Optional[pulumi.Input[Union['OrchestratedVirtualMachineScaleSetAutomaticInstanceRepairArgs', 'OrchestratedVirtualMachineScaleSetAutomaticInstanceRepairArgsDict']]] = None,
                 boot_diagnostics: Optional[pulumi.Input[Union['OrchestratedVirtualMachineScaleSetBootDiagnosticsArgs', 'OrchestratedVirtualMachineScaleSetBootDiagnosticsArgsDict']]] = None,
                 capacity_reservation_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 data_disks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OrchestratedVirtualMachineScaleSetDataDiskArgs', 'OrchestratedVirtualMachineScaleSetDataDiskArgsDict']]]]] = None,
                 encryption_at_host_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 eviction_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 extension_operations_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 extensions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OrchestratedVirtualMachineScaleSetExtensionArgs', 'OrchestratedVirtualMachineScaleSetExtensionArgsDict']]]]] = None,
                 extensions_time_budget: Optional[pulumi.Input[_builtins.str]] = None,
                 identity: Optional[pulumi.Input[Union['OrchestratedVirtualMachineScaleSetIdentityArgs', 'OrchestratedVirtualMachineScaleSetIdentityArgsDict']]] = None,
                 instances: Optional[pulumi.Input[_builtins.int]] = None,
                 license_type: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 max_bid_price: Optional[pulumi.Input[_builtins.float]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OrchestratedVirtualMachineScaleSetNetworkInterfaceArgs', 'OrchestratedVirtualMachineScaleSetNetworkInterfaceArgsDict']]]]] = None,
                 os_disk: Optional[pulumi.Input[Union['OrchestratedVirtualMachineScaleSetOsDiskArgs', 'OrchestratedVirtualMachineScaleSetOsDiskArgsDict']]] = None,
                 os_profile: Optional[pulumi.Input[Union['OrchestratedVirtualMachineScaleSetOsProfileArgs', 'OrchestratedVirtualMachineScaleSetOsProfileArgsDict']]] = None,
                 plan: Optional[pulumi.Input[Union['OrchestratedVirtualMachineScaleSetPlanArgs', 'OrchestratedVirtualMachineScaleSetPlanArgsDict']]] = None,
                 platform_fault_domain_count: Optional[pulumi.Input[_builtins.int]] = None,
                 priority: Optional[pulumi.Input[_builtins.str]] = None,
                 priority_mix: Optional[pulumi.Input[Union['OrchestratedVirtualMachineScaleSetPriorityMixArgs', 'OrchestratedVirtualMachineScaleSetPriorityMixArgsDict']]] = None,
                 proximity_placement_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 rolling_upgrade_policy: Optional[pulumi.Input[Union['OrchestratedVirtualMachineScaleSetRollingUpgradePolicyArgs', 'OrchestratedVirtualMachineScaleSetRollingUpgradePolicyArgsDict']]] = None,
                 single_placement_group: Optional[pulumi.Input[_builtins.bool]] = None,
                 sku_name: Optional[pulumi.Input[_builtins.str]] = None,
                 sku_profile: Optional[pulumi.Input[Union['OrchestratedVirtualMachineScaleSetSkuProfileArgs', 'OrchestratedVirtualMachineScaleSetSkuProfileArgsDict']]] = None,
                 source_image_id: Optional[pulumi.Input[_builtins.str]] = None,
                 source_image_reference: Optional[pulumi.Input[Union['OrchestratedVirtualMachineScaleSetSourceImageReferenceArgs', 'OrchestratedVirtualMachineScaleSetSourceImageReferenceArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 termination_notification: Optional[pulumi.Input[Union['OrchestratedVirtualMachineScaleSetTerminationNotificationArgs', 'OrchestratedVirtualMachineScaleSetTerminationNotificationArgsDict']]] = None,
                 upgrade_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 user_data_base64: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_balance: Optional[pulumi.Input[_builtins.bool]] = None,
                 zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Manages an Virtual Machine Scale Set in Flexible Orchestration Mode.

        ## Disclaimers

        > **Note:** As of the **v2.86.0** (November 19, 2021) release of the provider this resource will only create Virtual Machine Scale Sets with the **Flexible** Orchestration Mode.

        > **Note:** All arguments including the administrator login and password will be stored in the raw state as plain-text. [Read more about sensitive data in state](https://www.terraform.io/docs/state/sensitive-data.html).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_orchestrated_virtual_machine_scale_set = azure.compute.OrchestratedVirtualMachineScaleSet("example",
            name="example-VMSS",
            location=example.location,
            resource_group_name=example.name,
            platform_fault_domain_count=1,
            zones=["1"])
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Compute`: 2024-11-01

        ## Import

        An Virtual Machine Scale Set can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:compute/orchestratedVirtualMachineScaleSet:OrchestratedVirtualMachineScaleSet example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.Compute/virtualMachineScaleSets/scaleset1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['OrchestratedVirtualMachineScaleSetAdditionalCapabilitiesArgs', 'OrchestratedVirtualMachineScaleSetAdditionalCapabilitiesArgsDict']] additional_capabilities: An `additional_capabilities` block as defined below.
        :param pulumi.Input[Union['OrchestratedVirtualMachineScaleSetAutomaticInstanceRepairArgs', 'OrchestratedVirtualMachineScaleSetAutomaticInstanceRepairArgsDict']] automatic_instance_repair: An `automatic_instance_repair` block as defined below.
               
               > **Note:** To enable the `automatic_instance_repair`, the Orchestrated Virtual Machine Scale Set must have a valid [Application Health Extension](https://docs.microsoft.com/azure/virtual-machine-scale-sets/virtual-machine-scale-sets-health-extension).
        :param pulumi.Input[Union['OrchestratedVirtualMachineScaleSetBootDiagnosticsArgs', 'OrchestratedVirtualMachineScaleSetBootDiagnosticsArgsDict']] boot_diagnostics: A `boot_diagnostics` block as defined below.
        :param pulumi.Input[_builtins.str] capacity_reservation_group_id: Specifies the ID of the Capacity Reservation Group which the Virtual Machine Scale Set should be allocated to. Changing this forces a new resource to be created.
               
               > **Note:** `capacity_reservation_group_id` cannot be specified with `proximity_placement_group_id`
               
               > **Note:** If `capacity_reservation_group_id` is specified the `single_placement_group` must be set to `false`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['OrchestratedVirtualMachineScaleSetDataDiskArgs', 'OrchestratedVirtualMachineScaleSetDataDiskArgsDict']]]] data_disks: One or more `data_disk` blocks as defined below.
        :param pulumi.Input[_builtins.bool] encryption_at_host_enabled: Should disks attached to this Virtual Machine Scale Set be encrypted by enabling Encryption at Host?
        :param pulumi.Input[_builtins.str] eviction_policy: The Policy which should be used by Spot Virtual Machines that are Evicted from the Scale Set. Possible values are `Deallocate` and `Delete`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] extension_operations_enabled: Should extension operations be allowed on the Virtual Machine Scale Set? Possible values are `true` or `false`. Defaults to `true`. Changing this forces a new Virtual Machine Scale Set to be created.
               
               > **Note:** `extension_operations_enabled` may only be set to `false` if there are no extensions defined in the `extension` field.
        :param pulumi.Input[Sequence[pulumi.Input[Union['OrchestratedVirtualMachineScaleSetExtensionArgs', 'OrchestratedVirtualMachineScaleSetExtensionArgsDict']]]] extensions: One or more `extension` blocks as defined below
        :param pulumi.Input[_builtins.str] extensions_time_budget: Specifies the time alloted for all extensions to start. The time duration should be between 15 minutes and 120 minutes (inclusive) and should be specified in ISO 8601 format. Defaults to `PT1H30M`.
        :param pulumi.Input[Union['OrchestratedVirtualMachineScaleSetIdentityArgs', 'OrchestratedVirtualMachineScaleSetIdentityArgsDict']] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.int] instances: The number of Virtual Machines in the Virtual Machine Scale Set.
        :param pulumi.Input[_builtins.str] license_type: Specifies the type of on-premise license (also known as Azure Hybrid Use Benefit) which should be used for this Virtual Machine Scale Set. Possible values are `None`, `Windows_Client` and `Windows_Server`.
        :param pulumi.Input[_builtins.str] location: The Azure location where the Virtual Machine Scale Set should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.float] max_bid_price: The maximum price you're willing to pay for each Virtual Machine in this Scale Set, in US Dollars; which must be greater than the current spot price. If this bid price falls below the current spot price the Virtual Machines in the Scale Set will be evicted using the eviction_policy. Defaults to `-1`, which means that each Virtual Machine in the Scale Set should not be evicted for price reasons.
        :param pulumi.Input[_builtins.str] name: The name of the Virtual Machine Scale Set. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[Union['OrchestratedVirtualMachineScaleSetNetworkInterfaceArgs', 'OrchestratedVirtualMachineScaleSetNetworkInterfaceArgsDict']]]] network_interfaces: One or more `network_interface` blocks as defined below.
        :param pulumi.Input[Union['OrchestratedVirtualMachineScaleSetOsDiskArgs', 'OrchestratedVirtualMachineScaleSetOsDiskArgsDict']] os_disk: An `os_disk` block as defined below.
        :param pulumi.Input[Union['OrchestratedVirtualMachineScaleSetOsProfileArgs', 'OrchestratedVirtualMachineScaleSetOsProfileArgsDict']] os_profile: An `os_profile` block as defined below.
        :param pulumi.Input[Union['OrchestratedVirtualMachineScaleSetPlanArgs', 'OrchestratedVirtualMachineScaleSetPlanArgsDict']] plan: A `plan` block as documented below. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] platform_fault_domain_count: Specifies the number of fault domains that are used by this Virtual Machine Scale Set. Changing this forces a new resource to be created.
               
               > **Note:** The number of Fault Domains varies depending on which Azure Region you're using. More information about update and fault domains and how they work can be found [here](https://learn.microsoft.com/en-us/azure/virtual-machines/availability-set-overview).
        :param pulumi.Input[_builtins.str] priority: The Priority of this Virtual Machine Scale Set. Possible values are `Regular` and `Spot`. Defaults to `Regular`. Changing this value forces a new resource.
        :param pulumi.Input[Union['OrchestratedVirtualMachineScaleSetPriorityMixArgs', 'OrchestratedVirtualMachineScaleSetPriorityMixArgsDict']] priority_mix: a `priority_mix` block as defined below
        :param pulumi.Input[_builtins.str] proximity_placement_group_id: The ID of the Proximity Placement Group which the Virtual Machine should be assigned to. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group in which the Virtual Machine Scale Set should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['OrchestratedVirtualMachineScaleSetRollingUpgradePolicyArgs', 'OrchestratedVirtualMachineScaleSetRollingUpgradePolicyArgsDict']] rolling_upgrade_policy: A `rolling_upgrade_policy` block as defined below. This is Required when `upgrade_mode` is set to `Rolling` and cannot be specified when `upgrade_mode` is set to `Manual`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] single_placement_group: Should this Virtual Machine Scale Set be limited to a Single Placement Group, which means the number of instances will be capped at 100 Virtual Machines. Possible values are `true` or `false`.
               
               > **Note:** `single_placement_group` behaves differently for Flexible orchestration Virtual Machine Scale Sets than it does for Uniform orchestration Virtual Machine Scale Sets. It is recommended that you do not define the `single_placement_group` field in your configuration file as the service will determine what this value should be based off of the value contained within the `sku_name` field of your configuration file. You may set the `single_placement_group` field to `true`, however once you set it to `false` you will not be able to revert it back to `true`.
        :param pulumi.Input[_builtins.str] sku_name: The `name` of the SKU to be used by this Virtual Machine Scale Set. Valid values include: any of the [General purpose](https://docs.microsoft.com/azure/virtual-machines/sizes-general), [Compute optimized](https://docs.microsoft.com/azure/virtual-machines/sizes-compute), [Memory optimized](https://docs.microsoft.com/azure/virtual-machines/sizes-memory), [Storage optimized](https://docs.microsoft.com/azure/virtual-machines/sizes-storage), [GPU optimized](https://docs.microsoft.com/azure/virtual-machines/sizes-gpu), [FPGA optimized](https://docs.microsoft.com/azure/virtual-machines/sizes-field-programmable-gate-arrays), [High performance](https://docs.microsoft.com/azure/virtual-machines/sizes-hpc), or [Previous generation](https://docs.microsoft.com/azure/virtual-machines/sizes-previous-gen) virtual machine SKUs.
        :param pulumi.Input[Union['OrchestratedVirtualMachineScaleSetSkuProfileArgs', 'OrchestratedVirtualMachineScaleSetSkuProfileArgsDict']] sku_profile: An `sku_profile` block as defined below. Changing this forces a new resource to be created.
               
               > **Note:** If `sku_profile` is specified the `sku_name` must be set to `Mix`.
        :param pulumi.Input[_builtins.str] source_image_id: The ID of an Image which each Virtual Machine in this Scale Set should be based on. Possible Image ID types include `Image ID`s, `Shared Image ID`s, `Shared Image Version ID`s, `Community Gallery Image ID`s, `Community Gallery Image Version ID`s, `Shared Gallery Image ID`s and `Shared Gallery Image Version ID`s.
        :param pulumi.Input[Union['OrchestratedVirtualMachineScaleSetSourceImageReferenceArgs', 'OrchestratedVirtualMachineScaleSetSourceImageReferenceArgsDict']] source_image_reference: A `source_image_reference` block as defined below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to this Virtual Machine Scale Set.
        :param pulumi.Input[Union['OrchestratedVirtualMachineScaleSetTerminationNotificationArgs', 'OrchestratedVirtualMachineScaleSetTerminationNotificationArgsDict']] termination_notification: A `termination_notification` block as defined below.
        :param pulumi.Input[_builtins.str] upgrade_mode: Specifies how upgrades (e.g. changing the Image/SKU) should be performed to Virtual Machine Instances. Possible values are `Automatic`, `Manual` and `Rolling`. Defaults to `Manual`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] user_data_base64: The Base64-Encoded User Data which should be used for this Virtual Machine Scale Set.
        :param pulumi.Input[_builtins.bool] zone_balance: Should the Virtual Machines in this Scale Set be strictly evenly distributed across Availability Zones? Defaults to `false`. Changing this forces a new resource to be created.
               
               > **Note:** This can only be set to `true` when one or more `zones` are configured.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] zones: Specifies a list of Availability Zones across which the Virtual Machine Scale Set will create instances.
               
               > **Note:** Updating `zones` to remove an existing zone forces a new Virtual Machine Scale Set to be created.
               
               > **Note:** Availability Zones are [only supported in several regions at this time](https://docs.microsoft.com/azure/availability-zones/az-overview).
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: OrchestratedVirtualMachineScaleSetArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an Virtual Machine Scale Set in Flexible Orchestration Mode.

        ## Disclaimers

        > **Note:** As of the **v2.86.0** (November 19, 2021) release of the provider this resource will only create Virtual Machine Scale Sets with the **Flexible** Orchestration Mode.

        > **Note:** All arguments including the administrator login and password will be stored in the raw state as plain-text. [Read more about sensitive data in state](https://www.terraform.io/docs/state/sensitive-data.html).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_orchestrated_virtual_machine_scale_set = azure.compute.OrchestratedVirtualMachineScaleSet("example",
            name="example-VMSS",
            location=example.location,
            resource_group_name=example.name,
            platform_fault_domain_count=1,
            zones=["1"])
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Compute`: 2024-11-01

        ## Import

        An Virtual Machine Scale Set can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:compute/orchestratedVirtualMachineScaleSet:OrchestratedVirtualMachineScaleSet example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.Compute/virtualMachineScaleSets/scaleset1
        ```

        :param str resource_name: The name of the resource.
        :param OrchestratedVirtualMachineScaleSetArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(OrchestratedVirtualMachineScaleSetArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 additional_capabilities: Optional[pulumi.Input[Union['OrchestratedVirtualMachineScaleSetAdditionalCapabilitiesArgs', 'OrchestratedVirtualMachineScaleSetAdditionalCapabilitiesArgsDict']]] = None,
                 automatic_instance_repair: Optional[pulumi.Input[Union['OrchestratedVirtualMachineScaleSetAutomaticInstanceRepairArgs', 'OrchestratedVirtualMachineScaleSetAutomaticInstanceRepairArgsDict']]] = None,
                 boot_diagnostics: Optional[pulumi.Input[Union['OrchestratedVirtualMachineScaleSetBootDiagnosticsArgs', 'OrchestratedVirtualMachineScaleSetBootDiagnosticsArgsDict']]] = None,
                 capacity_reservation_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 data_disks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OrchestratedVirtualMachineScaleSetDataDiskArgs', 'OrchestratedVirtualMachineScaleSetDataDiskArgsDict']]]]] = None,
                 encryption_at_host_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 eviction_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 extension_operations_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 extensions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OrchestratedVirtualMachineScaleSetExtensionArgs', 'OrchestratedVirtualMachineScaleSetExtensionArgsDict']]]]] = None,
                 extensions_time_budget: Optional[pulumi.Input[_builtins.str]] = None,
                 identity: Optional[pulumi.Input[Union['OrchestratedVirtualMachineScaleSetIdentityArgs', 'OrchestratedVirtualMachineScaleSetIdentityArgsDict']]] = None,
                 instances: Optional[pulumi.Input[_builtins.int]] = None,
                 license_type: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 max_bid_price: Optional[pulumi.Input[_builtins.float]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OrchestratedVirtualMachineScaleSetNetworkInterfaceArgs', 'OrchestratedVirtualMachineScaleSetNetworkInterfaceArgsDict']]]]] = None,
                 os_disk: Optional[pulumi.Input[Union['OrchestratedVirtualMachineScaleSetOsDiskArgs', 'OrchestratedVirtualMachineScaleSetOsDiskArgsDict']]] = None,
                 os_profile: Optional[pulumi.Input[Union['OrchestratedVirtualMachineScaleSetOsProfileArgs', 'OrchestratedVirtualMachineScaleSetOsProfileArgsDict']]] = None,
                 plan: Optional[pulumi.Input[Union['OrchestratedVirtualMachineScaleSetPlanArgs', 'OrchestratedVirtualMachineScaleSetPlanArgsDict']]] = None,
                 platform_fault_domain_count: Optional[pulumi.Input[_builtins.int]] = None,
                 priority: Optional[pulumi.Input[_builtins.str]] = None,
                 priority_mix: Optional[pulumi.Input[Union['OrchestratedVirtualMachineScaleSetPriorityMixArgs', 'OrchestratedVirtualMachineScaleSetPriorityMixArgsDict']]] = None,
                 proximity_placement_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 rolling_upgrade_policy: Optional[pulumi.Input[Union['OrchestratedVirtualMachineScaleSetRollingUpgradePolicyArgs', 'OrchestratedVirtualMachineScaleSetRollingUpgradePolicyArgsDict']]] = None,
                 single_placement_group: Optional[pulumi.Input[_builtins.bool]] = None,
                 sku_name: Optional[pulumi.Input[_builtins.str]] = None,
                 sku_profile: Optional[pulumi.Input[Union['OrchestratedVirtualMachineScaleSetSkuProfileArgs', 'OrchestratedVirtualMachineScaleSetSkuProfileArgsDict']]] = None,
                 source_image_id: Optional[pulumi.Input[_builtins.str]] = None,
                 source_image_reference: Optional[pulumi.Input[Union['OrchestratedVirtualMachineScaleSetSourceImageReferenceArgs', 'OrchestratedVirtualMachineScaleSetSourceImageReferenceArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 termination_notification: Optional[pulumi.Input[Union['OrchestratedVirtualMachineScaleSetTerminationNotificationArgs', 'OrchestratedVirtualMachineScaleSetTerminationNotificationArgsDict']]] = None,
                 upgrade_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 user_data_base64: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_balance: Optional[pulumi.Input[_builtins.bool]] = None,
                 zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = OrchestratedVirtualMachineScaleSetArgs.__new__(OrchestratedVirtualMachineScaleSetArgs)

            __props__.__dict__["additional_capabilities"] = additional_capabilities
            __props__.__dict__["automatic_instance_repair"] = automatic_instance_repair
            __props__.__dict__["boot_diagnostics"] = boot_diagnostics
            __props__.__dict__["capacity_reservation_group_id"] = capacity_reservation_group_id
            __props__.__dict__["data_disks"] = data_disks
            __props__.__dict__["encryption_at_host_enabled"] = encryption_at_host_enabled
            __props__.__dict__["eviction_policy"] = eviction_policy
            __props__.__dict__["extension_operations_enabled"] = extension_operations_enabled
            __props__.__dict__["extensions"] = extensions
            __props__.__dict__["extensions_time_budget"] = extensions_time_budget
            __props__.__dict__["identity"] = identity
            __props__.__dict__["instances"] = instances
            __props__.__dict__["license_type"] = license_type
            __props__.__dict__["location"] = location
            __props__.__dict__["max_bid_price"] = max_bid_price
            __props__.__dict__["name"] = name
            __props__.__dict__["network_interfaces"] = network_interfaces
            __props__.__dict__["os_disk"] = os_disk
            __props__.__dict__["os_profile"] = os_profile
            __props__.__dict__["plan"] = plan
            if platform_fault_domain_count is None and not opts.urn:
                raise TypeError("Missing required property 'platform_fault_domain_count'")
            __props__.__dict__["platform_fault_domain_count"] = platform_fault_domain_count
            __props__.__dict__["priority"] = priority
            __props__.__dict__["priority_mix"] = priority_mix
            __props__.__dict__["proximity_placement_group_id"] = proximity_placement_group_id
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["rolling_upgrade_policy"] = rolling_upgrade_policy
            __props__.__dict__["single_placement_group"] = single_placement_group
            __props__.__dict__["sku_name"] = sku_name
            __props__.__dict__["sku_profile"] = sku_profile
            __props__.__dict__["source_image_id"] = source_image_id
            __props__.__dict__["source_image_reference"] = source_image_reference
            __props__.__dict__["tags"] = tags
            __props__.__dict__["termination_notification"] = termination_notification
            __props__.__dict__["upgrade_mode"] = upgrade_mode
            __props__.__dict__["user_data_base64"] = None if user_data_base64 is None else pulumi.Output.secret(user_data_base64)
            __props__.__dict__["zone_balance"] = zone_balance
            __props__.__dict__["zones"] = zones
            __props__.__dict__["unique_id"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["userDataBase64"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(OrchestratedVirtualMachineScaleSet, __self__).__init__(
            'azure:compute/orchestratedVirtualMachineScaleSet:OrchestratedVirtualMachineScaleSet',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            additional_capabilities: Optional[pulumi.Input[Union['OrchestratedVirtualMachineScaleSetAdditionalCapabilitiesArgs', 'OrchestratedVirtualMachineScaleSetAdditionalCapabilitiesArgsDict']]] = None,
            automatic_instance_repair: Optional[pulumi.Input[Union['OrchestratedVirtualMachineScaleSetAutomaticInstanceRepairArgs', 'OrchestratedVirtualMachineScaleSetAutomaticInstanceRepairArgsDict']]] = None,
            boot_diagnostics: Optional[pulumi.Input[Union['OrchestratedVirtualMachineScaleSetBootDiagnosticsArgs', 'OrchestratedVirtualMachineScaleSetBootDiagnosticsArgsDict']]] = None,
            capacity_reservation_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            data_disks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OrchestratedVirtualMachineScaleSetDataDiskArgs', 'OrchestratedVirtualMachineScaleSetDataDiskArgsDict']]]]] = None,
            encryption_at_host_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            eviction_policy: Optional[pulumi.Input[_builtins.str]] = None,
            extension_operations_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            extensions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OrchestratedVirtualMachineScaleSetExtensionArgs', 'OrchestratedVirtualMachineScaleSetExtensionArgsDict']]]]] = None,
            extensions_time_budget: Optional[pulumi.Input[_builtins.str]] = None,
            identity: Optional[pulumi.Input[Union['OrchestratedVirtualMachineScaleSetIdentityArgs', 'OrchestratedVirtualMachineScaleSetIdentityArgsDict']]] = None,
            instances: Optional[pulumi.Input[_builtins.int]] = None,
            license_type: Optional[pulumi.Input[_builtins.str]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            max_bid_price: Optional[pulumi.Input[_builtins.float]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OrchestratedVirtualMachineScaleSetNetworkInterfaceArgs', 'OrchestratedVirtualMachineScaleSetNetworkInterfaceArgsDict']]]]] = None,
            os_disk: Optional[pulumi.Input[Union['OrchestratedVirtualMachineScaleSetOsDiskArgs', 'OrchestratedVirtualMachineScaleSetOsDiskArgsDict']]] = None,
            os_profile: Optional[pulumi.Input[Union['OrchestratedVirtualMachineScaleSetOsProfileArgs', 'OrchestratedVirtualMachineScaleSetOsProfileArgsDict']]] = None,
            plan: Optional[pulumi.Input[Union['OrchestratedVirtualMachineScaleSetPlanArgs', 'OrchestratedVirtualMachineScaleSetPlanArgsDict']]] = None,
            platform_fault_domain_count: Optional[pulumi.Input[_builtins.int]] = None,
            priority: Optional[pulumi.Input[_builtins.str]] = None,
            priority_mix: Optional[pulumi.Input[Union['OrchestratedVirtualMachineScaleSetPriorityMixArgs', 'OrchestratedVirtualMachineScaleSetPriorityMixArgsDict']]] = None,
            proximity_placement_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            rolling_upgrade_policy: Optional[pulumi.Input[Union['OrchestratedVirtualMachineScaleSetRollingUpgradePolicyArgs', 'OrchestratedVirtualMachineScaleSetRollingUpgradePolicyArgsDict']]] = None,
            single_placement_group: Optional[pulumi.Input[_builtins.bool]] = None,
            sku_name: Optional[pulumi.Input[_builtins.str]] = None,
            sku_profile: Optional[pulumi.Input[Union['OrchestratedVirtualMachineScaleSetSkuProfileArgs', 'OrchestratedVirtualMachineScaleSetSkuProfileArgsDict']]] = None,
            source_image_id: Optional[pulumi.Input[_builtins.str]] = None,
            source_image_reference: Optional[pulumi.Input[Union['OrchestratedVirtualMachineScaleSetSourceImageReferenceArgs', 'OrchestratedVirtualMachineScaleSetSourceImageReferenceArgsDict']]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            termination_notification: Optional[pulumi.Input[Union['OrchestratedVirtualMachineScaleSetTerminationNotificationArgs', 'OrchestratedVirtualMachineScaleSetTerminationNotificationArgsDict']]] = None,
            unique_id: Optional[pulumi.Input[_builtins.str]] = None,
            upgrade_mode: Optional[pulumi.Input[_builtins.str]] = None,
            user_data_base64: Optional[pulumi.Input[_builtins.str]] = None,
            zone_balance: Optional[pulumi.Input[_builtins.bool]] = None,
            zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None) -> 'OrchestratedVirtualMachineScaleSet':
        """
        Get an existing OrchestratedVirtualMachineScaleSet resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['OrchestratedVirtualMachineScaleSetAdditionalCapabilitiesArgs', 'OrchestratedVirtualMachineScaleSetAdditionalCapabilitiesArgsDict']] additional_capabilities: An `additional_capabilities` block as defined below.
        :param pulumi.Input[Union['OrchestratedVirtualMachineScaleSetAutomaticInstanceRepairArgs', 'OrchestratedVirtualMachineScaleSetAutomaticInstanceRepairArgsDict']] automatic_instance_repair: An `automatic_instance_repair` block as defined below.
               
               > **Note:** To enable the `automatic_instance_repair`, the Orchestrated Virtual Machine Scale Set must have a valid [Application Health Extension](https://docs.microsoft.com/azure/virtual-machine-scale-sets/virtual-machine-scale-sets-health-extension).
        :param pulumi.Input[Union['OrchestratedVirtualMachineScaleSetBootDiagnosticsArgs', 'OrchestratedVirtualMachineScaleSetBootDiagnosticsArgsDict']] boot_diagnostics: A `boot_diagnostics` block as defined below.
        :param pulumi.Input[_builtins.str] capacity_reservation_group_id: Specifies the ID of the Capacity Reservation Group which the Virtual Machine Scale Set should be allocated to. Changing this forces a new resource to be created.
               
               > **Note:** `capacity_reservation_group_id` cannot be specified with `proximity_placement_group_id`
               
               > **Note:** If `capacity_reservation_group_id` is specified the `single_placement_group` must be set to `false`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['OrchestratedVirtualMachineScaleSetDataDiskArgs', 'OrchestratedVirtualMachineScaleSetDataDiskArgsDict']]]] data_disks: One or more `data_disk` blocks as defined below.
        :param pulumi.Input[_builtins.bool] encryption_at_host_enabled: Should disks attached to this Virtual Machine Scale Set be encrypted by enabling Encryption at Host?
        :param pulumi.Input[_builtins.str] eviction_policy: The Policy which should be used by Spot Virtual Machines that are Evicted from the Scale Set. Possible values are `Deallocate` and `Delete`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] extension_operations_enabled: Should extension operations be allowed on the Virtual Machine Scale Set? Possible values are `true` or `false`. Defaults to `true`. Changing this forces a new Virtual Machine Scale Set to be created.
               
               > **Note:** `extension_operations_enabled` may only be set to `false` if there are no extensions defined in the `extension` field.
        :param pulumi.Input[Sequence[pulumi.Input[Union['OrchestratedVirtualMachineScaleSetExtensionArgs', 'OrchestratedVirtualMachineScaleSetExtensionArgsDict']]]] extensions: One or more `extension` blocks as defined below
        :param pulumi.Input[_builtins.str] extensions_time_budget: Specifies the time alloted for all extensions to start. The time duration should be between 15 minutes and 120 minutes (inclusive) and should be specified in ISO 8601 format. Defaults to `PT1H30M`.
        :param pulumi.Input[Union['OrchestratedVirtualMachineScaleSetIdentityArgs', 'OrchestratedVirtualMachineScaleSetIdentityArgsDict']] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.int] instances: The number of Virtual Machines in the Virtual Machine Scale Set.
        :param pulumi.Input[_builtins.str] license_type: Specifies the type of on-premise license (also known as Azure Hybrid Use Benefit) which should be used for this Virtual Machine Scale Set. Possible values are `None`, `Windows_Client` and `Windows_Server`.
        :param pulumi.Input[_builtins.str] location: The Azure location where the Virtual Machine Scale Set should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.float] max_bid_price: The maximum price you're willing to pay for each Virtual Machine in this Scale Set, in US Dollars; which must be greater than the current spot price. If this bid price falls below the current spot price the Virtual Machines in the Scale Set will be evicted using the eviction_policy. Defaults to `-1`, which means that each Virtual Machine in the Scale Set should not be evicted for price reasons.
        :param pulumi.Input[_builtins.str] name: The name of the Virtual Machine Scale Set. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[Union['OrchestratedVirtualMachineScaleSetNetworkInterfaceArgs', 'OrchestratedVirtualMachineScaleSetNetworkInterfaceArgsDict']]]] network_interfaces: One or more `network_interface` blocks as defined below.
        :param pulumi.Input[Union['OrchestratedVirtualMachineScaleSetOsDiskArgs', 'OrchestratedVirtualMachineScaleSetOsDiskArgsDict']] os_disk: An `os_disk` block as defined below.
        :param pulumi.Input[Union['OrchestratedVirtualMachineScaleSetOsProfileArgs', 'OrchestratedVirtualMachineScaleSetOsProfileArgsDict']] os_profile: An `os_profile` block as defined below.
        :param pulumi.Input[Union['OrchestratedVirtualMachineScaleSetPlanArgs', 'OrchestratedVirtualMachineScaleSetPlanArgsDict']] plan: A `plan` block as documented below. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] platform_fault_domain_count: Specifies the number of fault domains that are used by this Virtual Machine Scale Set. Changing this forces a new resource to be created.
               
               > **Note:** The number of Fault Domains varies depending on which Azure Region you're using. More information about update and fault domains and how they work can be found [here](https://learn.microsoft.com/en-us/azure/virtual-machines/availability-set-overview).
        :param pulumi.Input[_builtins.str] priority: The Priority of this Virtual Machine Scale Set. Possible values are `Regular` and `Spot`. Defaults to `Regular`. Changing this value forces a new resource.
        :param pulumi.Input[Union['OrchestratedVirtualMachineScaleSetPriorityMixArgs', 'OrchestratedVirtualMachineScaleSetPriorityMixArgsDict']] priority_mix: a `priority_mix` block as defined below
        :param pulumi.Input[_builtins.str] proximity_placement_group_id: The ID of the Proximity Placement Group which the Virtual Machine should be assigned to. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group in which the Virtual Machine Scale Set should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['OrchestratedVirtualMachineScaleSetRollingUpgradePolicyArgs', 'OrchestratedVirtualMachineScaleSetRollingUpgradePolicyArgsDict']] rolling_upgrade_policy: A `rolling_upgrade_policy` block as defined below. This is Required when `upgrade_mode` is set to `Rolling` and cannot be specified when `upgrade_mode` is set to `Manual`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] single_placement_group: Should this Virtual Machine Scale Set be limited to a Single Placement Group, which means the number of instances will be capped at 100 Virtual Machines. Possible values are `true` or `false`.
               
               > **Note:** `single_placement_group` behaves differently for Flexible orchestration Virtual Machine Scale Sets than it does for Uniform orchestration Virtual Machine Scale Sets. It is recommended that you do not define the `single_placement_group` field in your configuration file as the service will determine what this value should be based off of the value contained within the `sku_name` field of your configuration file. You may set the `single_placement_group` field to `true`, however once you set it to `false` you will not be able to revert it back to `true`.
        :param pulumi.Input[_builtins.str] sku_name: The `name` of the SKU to be used by this Virtual Machine Scale Set. Valid values include: any of the [General purpose](https://docs.microsoft.com/azure/virtual-machines/sizes-general), [Compute optimized](https://docs.microsoft.com/azure/virtual-machines/sizes-compute), [Memory optimized](https://docs.microsoft.com/azure/virtual-machines/sizes-memory), [Storage optimized](https://docs.microsoft.com/azure/virtual-machines/sizes-storage), [GPU optimized](https://docs.microsoft.com/azure/virtual-machines/sizes-gpu), [FPGA optimized](https://docs.microsoft.com/azure/virtual-machines/sizes-field-programmable-gate-arrays), [High performance](https://docs.microsoft.com/azure/virtual-machines/sizes-hpc), or [Previous generation](https://docs.microsoft.com/azure/virtual-machines/sizes-previous-gen) virtual machine SKUs.
        :param pulumi.Input[Union['OrchestratedVirtualMachineScaleSetSkuProfileArgs', 'OrchestratedVirtualMachineScaleSetSkuProfileArgsDict']] sku_profile: An `sku_profile` block as defined below. Changing this forces a new resource to be created.
               
               > **Note:** If `sku_profile` is specified the `sku_name` must be set to `Mix`.
        :param pulumi.Input[_builtins.str] source_image_id: The ID of an Image which each Virtual Machine in this Scale Set should be based on. Possible Image ID types include `Image ID`s, `Shared Image ID`s, `Shared Image Version ID`s, `Community Gallery Image ID`s, `Community Gallery Image Version ID`s, `Shared Gallery Image ID`s and `Shared Gallery Image Version ID`s.
        :param pulumi.Input[Union['OrchestratedVirtualMachineScaleSetSourceImageReferenceArgs', 'OrchestratedVirtualMachineScaleSetSourceImageReferenceArgsDict']] source_image_reference: A `source_image_reference` block as defined below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to this Virtual Machine Scale Set.
        :param pulumi.Input[Union['OrchestratedVirtualMachineScaleSetTerminationNotificationArgs', 'OrchestratedVirtualMachineScaleSetTerminationNotificationArgsDict']] termination_notification: A `termination_notification` block as defined below.
        :param pulumi.Input[_builtins.str] unique_id: The Unique ID for the Virtual Machine Scale Set.
        :param pulumi.Input[_builtins.str] upgrade_mode: Specifies how upgrades (e.g. changing the Image/SKU) should be performed to Virtual Machine Instances. Possible values are `Automatic`, `Manual` and `Rolling`. Defaults to `Manual`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] user_data_base64: The Base64-Encoded User Data which should be used for this Virtual Machine Scale Set.
        :param pulumi.Input[_builtins.bool] zone_balance: Should the Virtual Machines in this Scale Set be strictly evenly distributed across Availability Zones? Defaults to `false`. Changing this forces a new resource to be created.
               
               > **Note:** This can only be set to `true` when one or more `zones` are configured.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] zones: Specifies a list of Availability Zones across which the Virtual Machine Scale Set will create instances.
               
               > **Note:** Updating `zones` to remove an existing zone forces a new Virtual Machine Scale Set to be created.
               
               > **Note:** Availability Zones are [only supported in several regions at this time](https://docs.microsoft.com/azure/availability-zones/az-overview).
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _OrchestratedVirtualMachineScaleSetState.__new__(_OrchestratedVirtualMachineScaleSetState)

        __props__.__dict__["additional_capabilities"] = additional_capabilities
        __props__.__dict__["automatic_instance_repair"] = automatic_instance_repair
        __props__.__dict__["boot_diagnostics"] = boot_diagnostics
        __props__.__dict__["capacity_reservation_group_id"] = capacity_reservation_group_id
        __props__.__dict__["data_disks"] = data_disks
        __props__.__dict__["encryption_at_host_enabled"] = encryption_at_host_enabled
        __props__.__dict__["eviction_policy"] = eviction_policy
        __props__.__dict__["extension_operations_enabled"] = extension_operations_enabled
        __props__.__dict__["extensions"] = extensions
        __props__.__dict__["extensions_time_budget"] = extensions_time_budget
        __props__.__dict__["identity"] = identity
        __props__.__dict__["instances"] = instances
        __props__.__dict__["license_type"] = license_type
        __props__.__dict__["location"] = location
        __props__.__dict__["max_bid_price"] = max_bid_price
        __props__.__dict__["name"] = name
        __props__.__dict__["network_interfaces"] = network_interfaces
        __props__.__dict__["os_disk"] = os_disk
        __props__.__dict__["os_profile"] = os_profile
        __props__.__dict__["plan"] = plan
        __props__.__dict__["platform_fault_domain_count"] = platform_fault_domain_count
        __props__.__dict__["priority"] = priority
        __props__.__dict__["priority_mix"] = priority_mix
        __props__.__dict__["proximity_placement_group_id"] = proximity_placement_group_id
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["rolling_upgrade_policy"] = rolling_upgrade_policy
        __props__.__dict__["single_placement_group"] = single_placement_group
        __props__.__dict__["sku_name"] = sku_name
        __props__.__dict__["sku_profile"] = sku_profile
        __props__.__dict__["source_image_id"] = source_image_id
        __props__.__dict__["source_image_reference"] = source_image_reference
        __props__.__dict__["tags"] = tags
        __props__.__dict__["termination_notification"] = termination_notification
        __props__.__dict__["unique_id"] = unique_id
        __props__.__dict__["upgrade_mode"] = upgrade_mode
        __props__.__dict__["user_data_base64"] = user_data_base64
        __props__.__dict__["zone_balance"] = zone_balance
        __props__.__dict__["zones"] = zones
        return OrchestratedVirtualMachineScaleSet(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="additionalCapabilities")
    def additional_capabilities(self) -> pulumi.Output[Optional['outputs.OrchestratedVirtualMachineScaleSetAdditionalCapabilities']]:
        """
        An `additional_capabilities` block as defined below.
        """
        return pulumi.get(self, "additional_capabilities")

    @_builtins.property
    @pulumi.getter(name="automaticInstanceRepair")
    def automatic_instance_repair(self) -> pulumi.Output['outputs.OrchestratedVirtualMachineScaleSetAutomaticInstanceRepair']:
        """
        An `automatic_instance_repair` block as defined below.

        > **Note:** To enable the `automatic_instance_repair`, the Orchestrated Virtual Machine Scale Set must have a valid [Application Health Extension](https://docs.microsoft.com/azure/virtual-machine-scale-sets/virtual-machine-scale-sets-health-extension).
        """
        return pulumi.get(self, "automatic_instance_repair")

    @_builtins.property
    @pulumi.getter(name="bootDiagnostics")
    def boot_diagnostics(self) -> pulumi.Output[Optional['outputs.OrchestratedVirtualMachineScaleSetBootDiagnostics']]:
        """
        A `boot_diagnostics` block as defined below.
        """
        return pulumi.get(self, "boot_diagnostics")

    @_builtins.property
    @pulumi.getter(name="capacityReservationGroupId")
    def capacity_reservation_group_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the ID of the Capacity Reservation Group which the Virtual Machine Scale Set should be allocated to. Changing this forces a new resource to be created.

        > **Note:** `capacity_reservation_group_id` cannot be specified with `proximity_placement_group_id`

        > **Note:** If `capacity_reservation_group_id` is specified the `single_placement_group` must be set to `false`.
        """
        return pulumi.get(self, "capacity_reservation_group_id")

    @_builtins.property
    @pulumi.getter(name="dataDisks")
    def data_disks(self) -> pulumi.Output[Optional[Sequence['outputs.OrchestratedVirtualMachineScaleSetDataDisk']]]:
        """
        One or more `data_disk` blocks as defined below.
        """
        return pulumi.get(self, "data_disks")

    @_builtins.property
    @pulumi.getter(name="encryptionAtHostEnabled")
    def encryption_at_host_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Should disks attached to this Virtual Machine Scale Set be encrypted by enabling Encryption at Host?
        """
        return pulumi.get(self, "encryption_at_host_enabled")

    @_builtins.property
    @pulumi.getter(name="evictionPolicy")
    def eviction_policy(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The Policy which should be used by Spot Virtual Machines that are Evicted from the Scale Set. Possible values are `Deallocate` and `Delete`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "eviction_policy")

    @_builtins.property
    @pulumi.getter(name="extensionOperationsEnabled")
    def extension_operations_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Should extension operations be allowed on the Virtual Machine Scale Set? Possible values are `true` or `false`. Defaults to `true`. Changing this forces a new Virtual Machine Scale Set to be created.

        > **Note:** `extension_operations_enabled` may only be set to `false` if there are no extensions defined in the `extension` field.
        """
        return pulumi.get(self, "extension_operations_enabled")

    @_builtins.property
    @pulumi.getter
    def extensions(self) -> pulumi.Output[Sequence['outputs.OrchestratedVirtualMachineScaleSetExtension']]:
        """
        One or more `extension` blocks as defined below
        """
        return pulumi.get(self, "extensions")

    @_builtins.property
    @pulumi.getter(name="extensionsTimeBudget")
    def extensions_time_budget(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the time alloted for all extensions to start. The time duration should be between 15 minutes and 120 minutes (inclusive) and should be specified in ISO 8601 format. Defaults to `PT1H30M`.
        """
        return pulumi.get(self, "extensions_time_budget")

    @_builtins.property
    @pulumi.getter
    def identity(self) -> pulumi.Output[Optional['outputs.OrchestratedVirtualMachineScaleSetIdentity']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @_builtins.property
    @pulumi.getter
    def instances(self) -> pulumi.Output[_builtins.int]:
        """
        The number of Virtual Machines in the Virtual Machine Scale Set.
        """
        return pulumi.get(self, "instances")

    @_builtins.property
    @pulumi.getter(name="licenseType")
    def license_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the type of on-premise license (also known as Azure Hybrid Use Benefit) which should be used for this Virtual Machine Scale Set. Possible values are `None`, `Windows_Client` and `Windows_Server`.
        """
        return pulumi.get(self, "license_type")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        The Azure location where the Virtual Machine Scale Set should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter(name="maxBidPrice")
    def max_bid_price(self) -> pulumi.Output[Optional[_builtins.float]]:
        """
        The maximum price you're willing to pay for each Virtual Machine in this Scale Set, in US Dollars; which must be greater than the current spot price. If this bid price falls below the current spot price the Virtual Machines in the Scale Set will be evicted using the eviction_policy. Defaults to `-1`, which means that each Virtual Machine in the Scale Set should not be evicted for price reasons.
        """
        return pulumi.get(self, "max_bid_price")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Virtual Machine Scale Set. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="networkInterfaces")
    def network_interfaces(self) -> pulumi.Output[Optional[Sequence['outputs.OrchestratedVirtualMachineScaleSetNetworkInterface']]]:
        """
        One or more `network_interface` blocks as defined below.
        """
        return pulumi.get(self, "network_interfaces")

    @_builtins.property
    @pulumi.getter(name="osDisk")
    def os_disk(self) -> pulumi.Output[Optional['outputs.OrchestratedVirtualMachineScaleSetOsDisk']]:
        """
        An `os_disk` block as defined below.
        """
        return pulumi.get(self, "os_disk")

    @_builtins.property
    @pulumi.getter(name="osProfile")
    def os_profile(self) -> pulumi.Output[Optional['outputs.OrchestratedVirtualMachineScaleSetOsProfile']]:
        """
        An `os_profile` block as defined below.
        """
        return pulumi.get(self, "os_profile")

    @_builtins.property
    @pulumi.getter
    def plan(self) -> pulumi.Output[Optional['outputs.OrchestratedVirtualMachineScaleSetPlan']]:
        """
        A `plan` block as documented below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "plan")

    @_builtins.property
    @pulumi.getter(name="platformFaultDomainCount")
    def platform_fault_domain_count(self) -> pulumi.Output[_builtins.int]:
        """
        Specifies the number of fault domains that are used by this Virtual Machine Scale Set. Changing this forces a new resource to be created.

        > **Note:** The number of Fault Domains varies depending on which Azure Region you're using. More information about update and fault domains and how they work can be found [here](https://learn.microsoft.com/en-us/azure/virtual-machines/availability-set-overview).
        """
        return pulumi.get(self, "platform_fault_domain_count")

    @_builtins.property
    @pulumi.getter
    def priority(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The Priority of this Virtual Machine Scale Set. Possible values are `Regular` and `Spot`. Defaults to `Regular`. Changing this value forces a new resource.
        """
        return pulumi.get(self, "priority")

    @_builtins.property
    @pulumi.getter(name="priorityMix")
    def priority_mix(self) -> pulumi.Output[Optional['outputs.OrchestratedVirtualMachineScaleSetPriorityMix']]:
        """
        a `priority_mix` block as defined below
        """
        return pulumi.get(self, "priority_mix")

    @_builtins.property
    @pulumi.getter(name="proximityPlacementGroupId")
    def proximity_placement_group_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the Proximity Placement Group which the Virtual Machine should be assigned to. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "proximity_placement_group_id")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Resource Group in which the Virtual Machine Scale Set should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter(name="rollingUpgradePolicy")
    def rolling_upgrade_policy(self) -> pulumi.Output[Optional['outputs.OrchestratedVirtualMachineScaleSetRollingUpgradePolicy']]:
        """
        A `rolling_upgrade_policy` block as defined below. This is Required when `upgrade_mode` is set to `Rolling` and cannot be specified when `upgrade_mode` is set to `Manual`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "rolling_upgrade_policy")

    @_builtins.property
    @pulumi.getter(name="singlePlacementGroup")
    def single_placement_group(self) -> pulumi.Output[_builtins.bool]:
        """
        Should this Virtual Machine Scale Set be limited to a Single Placement Group, which means the number of instances will be capped at 100 Virtual Machines. Possible values are `true` or `false`.

        > **Note:** `single_placement_group` behaves differently for Flexible orchestration Virtual Machine Scale Sets than it does for Uniform orchestration Virtual Machine Scale Sets. It is recommended that you do not define the `single_placement_group` field in your configuration file as the service will determine what this value should be based off of the value contained within the `sku_name` field of your configuration file. You may set the `single_placement_group` field to `true`, however once you set it to `false` you will not be able to revert it back to `true`.
        """
        return pulumi.get(self, "single_placement_group")

    @_builtins.property
    @pulumi.getter(name="skuName")
    def sku_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The `name` of the SKU to be used by this Virtual Machine Scale Set. Valid values include: any of the [General purpose](https://docs.microsoft.com/azure/virtual-machines/sizes-general), [Compute optimized](https://docs.microsoft.com/azure/virtual-machines/sizes-compute), [Memory optimized](https://docs.microsoft.com/azure/virtual-machines/sizes-memory), [Storage optimized](https://docs.microsoft.com/azure/virtual-machines/sizes-storage), [GPU optimized](https://docs.microsoft.com/azure/virtual-machines/sizes-gpu), [FPGA optimized](https://docs.microsoft.com/azure/virtual-machines/sizes-field-programmable-gate-arrays), [High performance](https://docs.microsoft.com/azure/virtual-machines/sizes-hpc), or [Previous generation](https://docs.microsoft.com/azure/virtual-machines/sizes-previous-gen) virtual machine SKUs.
        """
        return pulumi.get(self, "sku_name")

    @_builtins.property
    @pulumi.getter(name="skuProfile")
    def sku_profile(self) -> pulumi.Output[Optional['outputs.OrchestratedVirtualMachineScaleSetSkuProfile']]:
        """
        An `sku_profile` block as defined below. Changing this forces a new resource to be created.

        > **Note:** If `sku_profile` is specified the `sku_name` must be set to `Mix`.
        """
        return pulumi.get(self, "sku_profile")

    @_builtins.property
    @pulumi.getter(name="sourceImageId")
    def source_image_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of an Image which each Virtual Machine in this Scale Set should be based on. Possible Image ID types include `Image ID`s, `Shared Image ID`s, `Shared Image Version ID`s, `Community Gallery Image ID`s, `Community Gallery Image Version ID`s, `Shared Gallery Image ID`s and `Shared Gallery Image Version ID`s.
        """
        return pulumi.get(self, "source_image_id")

    @_builtins.property
    @pulumi.getter(name="sourceImageReference")
    def source_image_reference(self) -> pulumi.Output[Optional['outputs.OrchestratedVirtualMachineScaleSetSourceImageReference']]:
        """
        A `source_image_reference` block as defined below.
        """
        return pulumi.get(self, "source_image_reference")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags which should be assigned to this Virtual Machine Scale Set.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="terminationNotification")
    def termination_notification(self) -> pulumi.Output['outputs.OrchestratedVirtualMachineScaleSetTerminationNotification']:
        """
        A `termination_notification` block as defined below.
        """
        return pulumi.get(self, "termination_notification")

    @_builtins.property
    @pulumi.getter(name="uniqueId")
    def unique_id(self) -> pulumi.Output[_builtins.str]:
        """
        The Unique ID for the Virtual Machine Scale Set.
        """
        return pulumi.get(self, "unique_id")

    @_builtins.property
    @pulumi.getter(name="upgradeMode")
    def upgrade_mode(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies how upgrades (e.g. changing the Image/SKU) should be performed to Virtual Machine Instances. Possible values are `Automatic`, `Manual` and `Rolling`. Defaults to `Manual`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "upgrade_mode")

    @_builtins.property
    @pulumi.getter(name="userDataBase64")
    def user_data_base64(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The Base64-Encoded User Data which should be used for this Virtual Machine Scale Set.
        """
        return pulumi.get(self, "user_data_base64")

    @_builtins.property
    @pulumi.getter(name="zoneBalance")
    def zone_balance(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Should the Virtual Machines in this Scale Set be strictly evenly distributed across Availability Zones? Defaults to `false`. Changing this forces a new resource to be created.

        > **Note:** This can only be set to `true` when one or more `zones` are configured.
        """
        return pulumi.get(self, "zone_balance")

    @_builtins.property
    @pulumi.getter
    def zones(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Specifies a list of Availability Zones across which the Virtual Machine Scale Set will create instances.

        > **Note:** Updating `zones` to remove an existing zone forces a new Virtual Machine Scale Set to be created.

        > **Note:** Availability Zones are [only supported in several regions at this time](https://docs.microsoft.com/azure/availability-zones/az-overview).
        """
        return pulumi.get(self, "zones")

