# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['VirtualMachineScaleSetExtensionArgs', 'VirtualMachineScaleSetExtension']

@pulumi.input_type
class VirtualMachineScaleSetExtensionArgs:
    def __init__(__self__, *,
                 publisher: pulumi.Input[_builtins.str],
                 type: pulumi.Input[_builtins.str],
                 type_handler_version: pulumi.Input[_builtins.str],
                 virtual_machine_scale_set_id: pulumi.Input[_builtins.str],
                 auto_upgrade_minor_version: Optional[pulumi.Input[_builtins.bool]] = None,
                 automatic_upgrade_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 failure_suppression_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 force_update_tag: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 protected_settings: Optional[pulumi.Input[_builtins.str]] = None,
                 protected_settings_from_key_vault: Optional[pulumi.Input['VirtualMachineScaleSetExtensionProtectedSettingsFromKeyVaultArgs']] = None,
                 provision_after_extensions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 settings: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a VirtualMachineScaleSetExtension resource.
        :param pulumi.Input[_builtins.str] publisher: Specifies the Publisher of the Extension. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] type: Specifies the Type of the Extension. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] type_handler_version: Specifies the version of the extension to use, available versions can be found using the Azure CLI.
               
               > **Note:** The `Publisher` and `Type` of Virtual Machine Scale Set Extensions can be found using the Azure CLI, via:
               
               ```shell
               az vmss extension image list --location westus -o table
               ```
        :param pulumi.Input[_builtins.str] virtual_machine_scale_set_id: The ID of the Virtual Machine Scale Set. Changing this forces a new resource to be created.
               
               > **Note:** This should be the ID from the `compute.LinuxVirtualMachineScaleSet` or `compute.WindowsVirtualMachineScaleSet` resource - when using the older `compute.ScaleSet` resource extensions should instead be defined inline.
        :param pulumi.Input[_builtins.bool] auto_upgrade_minor_version: Should the latest version of the Extension be used at Deployment Time, if one is available? This won't auto-update the extension on existing installation. Defaults to `true`.
        :param pulumi.Input[_builtins.bool] automatic_upgrade_enabled: Should the Extension be automatically updated whenever the Publisher releases a new version of this VM Extension?
        :param pulumi.Input[_builtins.bool] failure_suppression_enabled: Should failures from the extension be suppressed? Possible values are `true` or `false`. Defaults to `false`.
               
               > **Note:** Operational failures such as not connecting to the VM will not be suppressed regardless of the `failure_suppression_enabled` value.
        :param pulumi.Input[_builtins.str] force_update_tag: A value which, when different to the previous value can be used to force-run the Extension even if the Extension Configuration hasn't changed.
        :param pulumi.Input[_builtins.str] name: The name for the Virtual Machine Scale Set Extension. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] protected_settings: A JSON String which specifies Sensitive Settings (such as Passwords) for the Extension.
               
               > **Note:** Keys within the `protected_settings` block are notoriously case-sensitive, where the casing required (e.g. TitleCase vs snakeCase) depends on the Extension being used. Please refer to the documentation for the specific Virtual Machine Extension you're looking to use for more information.
        :param pulumi.Input['VirtualMachineScaleSetExtensionProtectedSettingsFromKeyVaultArgs'] protected_settings_from_key_vault: A `protected_settings_from_key_vault` block as defined below.
               
               > **Note:** `protected_settings_from_key_vault` cannot be used with `protected_settings`
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] provision_after_extensions: An ordered list of Extension names which this should be provisioned after.
        :param pulumi.Input[_builtins.str] settings: A JSON String which specifies Settings for the Extension.
               
               > **Note:** Keys within the `settings` block are notoriously case-sensitive, where the casing required (e.g. TitleCase vs snakeCase) depends on the Extension being used. Please refer to the documentation for the specific Virtual Machine Extension you're looking to use for more information.
        """
        pulumi.set(__self__, "publisher", publisher)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "type_handler_version", type_handler_version)
        pulumi.set(__self__, "virtual_machine_scale_set_id", virtual_machine_scale_set_id)
        if auto_upgrade_minor_version is not None:
            pulumi.set(__self__, "auto_upgrade_minor_version", auto_upgrade_minor_version)
        if automatic_upgrade_enabled is not None:
            pulumi.set(__self__, "automatic_upgrade_enabled", automatic_upgrade_enabled)
        if failure_suppression_enabled is not None:
            pulumi.set(__self__, "failure_suppression_enabled", failure_suppression_enabled)
        if force_update_tag is not None:
            pulumi.set(__self__, "force_update_tag", force_update_tag)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if protected_settings is not None:
            pulumi.set(__self__, "protected_settings", protected_settings)
        if protected_settings_from_key_vault is not None:
            pulumi.set(__self__, "protected_settings_from_key_vault", protected_settings_from_key_vault)
        if provision_after_extensions is not None:
            pulumi.set(__self__, "provision_after_extensions", provision_after_extensions)
        if settings is not None:
            pulumi.set(__self__, "settings", settings)

    @_builtins.property
    @pulumi.getter
    def publisher(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the Publisher of the Extension. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "publisher")

    @publisher.setter
    def publisher(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "publisher", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the Type of the Extension. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="typeHandlerVersion")
    def type_handler_version(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the version of the extension to use, available versions can be found using the Azure CLI.

        > **Note:** The `Publisher` and `Type` of Virtual Machine Scale Set Extensions can be found using the Azure CLI, via:

        ```shell
        az vmss extension image list --location westus -o table
        ```
        """
        return pulumi.get(self, "type_handler_version")

    @type_handler_version.setter
    def type_handler_version(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type_handler_version", value)

    @_builtins.property
    @pulumi.getter(name="virtualMachineScaleSetId")
    def virtual_machine_scale_set_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Virtual Machine Scale Set. Changing this forces a new resource to be created.

        > **Note:** This should be the ID from the `compute.LinuxVirtualMachineScaleSet` or `compute.WindowsVirtualMachineScaleSet` resource - when using the older `compute.ScaleSet` resource extensions should instead be defined inline.
        """
        return pulumi.get(self, "virtual_machine_scale_set_id")

    @virtual_machine_scale_set_id.setter
    def virtual_machine_scale_set_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "virtual_machine_scale_set_id", value)

    @_builtins.property
    @pulumi.getter(name="autoUpgradeMinorVersion")
    def auto_upgrade_minor_version(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should the latest version of the Extension be used at Deployment Time, if one is available? This won't auto-update the extension on existing installation. Defaults to `true`.
        """
        return pulumi.get(self, "auto_upgrade_minor_version")

    @auto_upgrade_minor_version.setter
    def auto_upgrade_minor_version(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_upgrade_minor_version", value)

    @_builtins.property
    @pulumi.getter(name="automaticUpgradeEnabled")
    def automatic_upgrade_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should the Extension be automatically updated whenever the Publisher releases a new version of this VM Extension?
        """
        return pulumi.get(self, "automatic_upgrade_enabled")

    @automatic_upgrade_enabled.setter
    def automatic_upgrade_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "automatic_upgrade_enabled", value)

    @_builtins.property
    @pulumi.getter(name="failureSuppressionEnabled")
    def failure_suppression_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should failures from the extension be suppressed? Possible values are `true` or `false`. Defaults to `false`.

        > **Note:** Operational failures such as not connecting to the VM will not be suppressed regardless of the `failure_suppression_enabled` value.
        """
        return pulumi.get(self, "failure_suppression_enabled")

    @failure_suppression_enabled.setter
    def failure_suppression_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "failure_suppression_enabled", value)

    @_builtins.property
    @pulumi.getter(name="forceUpdateTag")
    def force_update_tag(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A value which, when different to the previous value can be used to force-run the Extension even if the Extension Configuration hasn't changed.
        """
        return pulumi.get(self, "force_update_tag")

    @force_update_tag.setter
    def force_update_tag(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "force_update_tag", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name for the Virtual Machine Scale Set Extension. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="protectedSettings")
    def protected_settings(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A JSON String which specifies Sensitive Settings (such as Passwords) for the Extension.

        > **Note:** Keys within the `protected_settings` block are notoriously case-sensitive, where the casing required (e.g. TitleCase vs snakeCase) depends on the Extension being used. Please refer to the documentation for the specific Virtual Machine Extension you're looking to use for more information.
        """
        return pulumi.get(self, "protected_settings")

    @protected_settings.setter
    def protected_settings(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "protected_settings", value)

    @_builtins.property
    @pulumi.getter(name="protectedSettingsFromKeyVault")
    def protected_settings_from_key_vault(self) -> Optional[pulumi.Input['VirtualMachineScaleSetExtensionProtectedSettingsFromKeyVaultArgs']]:
        """
        A `protected_settings_from_key_vault` block as defined below.

        > **Note:** `protected_settings_from_key_vault` cannot be used with `protected_settings`
        """
        return pulumi.get(self, "protected_settings_from_key_vault")

    @protected_settings_from_key_vault.setter
    def protected_settings_from_key_vault(self, value: Optional[pulumi.Input['VirtualMachineScaleSetExtensionProtectedSettingsFromKeyVaultArgs']]):
        pulumi.set(self, "protected_settings_from_key_vault", value)

    @_builtins.property
    @pulumi.getter(name="provisionAfterExtensions")
    def provision_after_extensions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        An ordered list of Extension names which this should be provisioned after.
        """
        return pulumi.get(self, "provision_after_extensions")

    @provision_after_extensions.setter
    def provision_after_extensions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "provision_after_extensions", value)

    @_builtins.property
    @pulumi.getter
    def settings(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A JSON String which specifies Settings for the Extension.

        > **Note:** Keys within the `settings` block are notoriously case-sensitive, where the casing required (e.g. TitleCase vs snakeCase) depends on the Extension being used. Please refer to the documentation for the specific Virtual Machine Extension you're looking to use for more information.
        """
        return pulumi.get(self, "settings")

    @settings.setter
    def settings(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "settings", value)


@pulumi.input_type
class _VirtualMachineScaleSetExtensionState:
    def __init__(__self__, *,
                 auto_upgrade_minor_version: Optional[pulumi.Input[_builtins.bool]] = None,
                 automatic_upgrade_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 failure_suppression_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 force_update_tag: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 protected_settings: Optional[pulumi.Input[_builtins.str]] = None,
                 protected_settings_from_key_vault: Optional[pulumi.Input['VirtualMachineScaleSetExtensionProtectedSettingsFromKeyVaultArgs']] = None,
                 provision_after_extensions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 publisher: Optional[pulumi.Input[_builtins.str]] = None,
                 settings: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 type_handler_version: Optional[pulumi.Input[_builtins.str]] = None,
                 virtual_machine_scale_set_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering VirtualMachineScaleSetExtension resources.
        :param pulumi.Input[_builtins.bool] auto_upgrade_minor_version: Should the latest version of the Extension be used at Deployment Time, if one is available? This won't auto-update the extension on existing installation. Defaults to `true`.
        :param pulumi.Input[_builtins.bool] automatic_upgrade_enabled: Should the Extension be automatically updated whenever the Publisher releases a new version of this VM Extension?
        :param pulumi.Input[_builtins.bool] failure_suppression_enabled: Should failures from the extension be suppressed? Possible values are `true` or `false`. Defaults to `false`.
               
               > **Note:** Operational failures such as not connecting to the VM will not be suppressed regardless of the `failure_suppression_enabled` value.
        :param pulumi.Input[_builtins.str] force_update_tag: A value which, when different to the previous value can be used to force-run the Extension even if the Extension Configuration hasn't changed.
        :param pulumi.Input[_builtins.str] name: The name for the Virtual Machine Scale Set Extension. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] protected_settings: A JSON String which specifies Sensitive Settings (such as Passwords) for the Extension.
               
               > **Note:** Keys within the `protected_settings` block are notoriously case-sensitive, where the casing required (e.g. TitleCase vs snakeCase) depends on the Extension being used. Please refer to the documentation for the specific Virtual Machine Extension you're looking to use for more information.
        :param pulumi.Input['VirtualMachineScaleSetExtensionProtectedSettingsFromKeyVaultArgs'] protected_settings_from_key_vault: A `protected_settings_from_key_vault` block as defined below.
               
               > **Note:** `protected_settings_from_key_vault` cannot be used with `protected_settings`
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] provision_after_extensions: An ordered list of Extension names which this should be provisioned after.
        :param pulumi.Input[_builtins.str] publisher: Specifies the Publisher of the Extension. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] settings: A JSON String which specifies Settings for the Extension.
               
               > **Note:** Keys within the `settings` block are notoriously case-sensitive, where the casing required (e.g. TitleCase vs snakeCase) depends on the Extension being used. Please refer to the documentation for the specific Virtual Machine Extension you're looking to use for more information.
        :param pulumi.Input[_builtins.str] type: Specifies the Type of the Extension. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] type_handler_version: Specifies the version of the extension to use, available versions can be found using the Azure CLI.
               
               > **Note:** The `Publisher` and `Type` of Virtual Machine Scale Set Extensions can be found using the Azure CLI, via:
               
               ```shell
               az vmss extension image list --location westus -o table
               ```
        :param pulumi.Input[_builtins.str] virtual_machine_scale_set_id: The ID of the Virtual Machine Scale Set. Changing this forces a new resource to be created.
               
               > **Note:** This should be the ID from the `compute.LinuxVirtualMachineScaleSet` or `compute.WindowsVirtualMachineScaleSet` resource - when using the older `compute.ScaleSet` resource extensions should instead be defined inline.
        """
        if auto_upgrade_minor_version is not None:
            pulumi.set(__self__, "auto_upgrade_minor_version", auto_upgrade_minor_version)
        if automatic_upgrade_enabled is not None:
            pulumi.set(__self__, "automatic_upgrade_enabled", automatic_upgrade_enabled)
        if failure_suppression_enabled is not None:
            pulumi.set(__self__, "failure_suppression_enabled", failure_suppression_enabled)
        if force_update_tag is not None:
            pulumi.set(__self__, "force_update_tag", force_update_tag)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if protected_settings is not None:
            pulumi.set(__self__, "protected_settings", protected_settings)
        if protected_settings_from_key_vault is not None:
            pulumi.set(__self__, "protected_settings_from_key_vault", protected_settings_from_key_vault)
        if provision_after_extensions is not None:
            pulumi.set(__self__, "provision_after_extensions", provision_after_extensions)
        if publisher is not None:
            pulumi.set(__self__, "publisher", publisher)
        if settings is not None:
            pulumi.set(__self__, "settings", settings)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if type_handler_version is not None:
            pulumi.set(__self__, "type_handler_version", type_handler_version)
        if virtual_machine_scale_set_id is not None:
            pulumi.set(__self__, "virtual_machine_scale_set_id", virtual_machine_scale_set_id)

    @_builtins.property
    @pulumi.getter(name="autoUpgradeMinorVersion")
    def auto_upgrade_minor_version(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should the latest version of the Extension be used at Deployment Time, if one is available? This won't auto-update the extension on existing installation. Defaults to `true`.
        """
        return pulumi.get(self, "auto_upgrade_minor_version")

    @auto_upgrade_minor_version.setter
    def auto_upgrade_minor_version(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_upgrade_minor_version", value)

    @_builtins.property
    @pulumi.getter(name="automaticUpgradeEnabled")
    def automatic_upgrade_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should the Extension be automatically updated whenever the Publisher releases a new version of this VM Extension?
        """
        return pulumi.get(self, "automatic_upgrade_enabled")

    @automatic_upgrade_enabled.setter
    def automatic_upgrade_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "automatic_upgrade_enabled", value)

    @_builtins.property
    @pulumi.getter(name="failureSuppressionEnabled")
    def failure_suppression_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should failures from the extension be suppressed? Possible values are `true` or `false`. Defaults to `false`.

        > **Note:** Operational failures such as not connecting to the VM will not be suppressed regardless of the `failure_suppression_enabled` value.
        """
        return pulumi.get(self, "failure_suppression_enabled")

    @failure_suppression_enabled.setter
    def failure_suppression_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "failure_suppression_enabled", value)

    @_builtins.property
    @pulumi.getter(name="forceUpdateTag")
    def force_update_tag(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A value which, when different to the previous value can be used to force-run the Extension even if the Extension Configuration hasn't changed.
        """
        return pulumi.get(self, "force_update_tag")

    @force_update_tag.setter
    def force_update_tag(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "force_update_tag", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name for the Virtual Machine Scale Set Extension. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="protectedSettings")
    def protected_settings(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A JSON String which specifies Sensitive Settings (such as Passwords) for the Extension.

        > **Note:** Keys within the `protected_settings` block are notoriously case-sensitive, where the casing required (e.g. TitleCase vs snakeCase) depends on the Extension being used. Please refer to the documentation for the specific Virtual Machine Extension you're looking to use for more information.
        """
        return pulumi.get(self, "protected_settings")

    @protected_settings.setter
    def protected_settings(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "protected_settings", value)

    @_builtins.property
    @pulumi.getter(name="protectedSettingsFromKeyVault")
    def protected_settings_from_key_vault(self) -> Optional[pulumi.Input['VirtualMachineScaleSetExtensionProtectedSettingsFromKeyVaultArgs']]:
        """
        A `protected_settings_from_key_vault` block as defined below.

        > **Note:** `protected_settings_from_key_vault` cannot be used with `protected_settings`
        """
        return pulumi.get(self, "protected_settings_from_key_vault")

    @protected_settings_from_key_vault.setter
    def protected_settings_from_key_vault(self, value: Optional[pulumi.Input['VirtualMachineScaleSetExtensionProtectedSettingsFromKeyVaultArgs']]):
        pulumi.set(self, "protected_settings_from_key_vault", value)

    @_builtins.property
    @pulumi.getter(name="provisionAfterExtensions")
    def provision_after_extensions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        An ordered list of Extension names which this should be provisioned after.
        """
        return pulumi.get(self, "provision_after_extensions")

    @provision_after_extensions.setter
    def provision_after_extensions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "provision_after_extensions", value)

    @_builtins.property
    @pulumi.getter
    def publisher(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the Publisher of the Extension. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "publisher")

    @publisher.setter
    def publisher(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "publisher", value)

    @_builtins.property
    @pulumi.getter
    def settings(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A JSON String which specifies Settings for the Extension.

        > **Note:** Keys within the `settings` block are notoriously case-sensitive, where the casing required (e.g. TitleCase vs snakeCase) depends on the Extension being used. Please refer to the documentation for the specific Virtual Machine Extension you're looking to use for more information.
        """
        return pulumi.get(self, "settings")

    @settings.setter
    def settings(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "settings", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the Type of the Extension. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="typeHandlerVersion")
    def type_handler_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the version of the extension to use, available versions can be found using the Azure CLI.

        > **Note:** The `Publisher` and `Type` of Virtual Machine Scale Set Extensions can be found using the Azure CLI, via:

        ```shell
        az vmss extension image list --location westus -o table
        ```
        """
        return pulumi.get(self, "type_handler_version")

    @type_handler_version.setter
    def type_handler_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type_handler_version", value)

    @_builtins.property
    @pulumi.getter(name="virtualMachineScaleSetId")
    def virtual_machine_scale_set_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Virtual Machine Scale Set. Changing this forces a new resource to be created.

        > **Note:** This should be the ID from the `compute.LinuxVirtualMachineScaleSet` or `compute.WindowsVirtualMachineScaleSet` resource - when using the older `compute.ScaleSet` resource extensions should instead be defined inline.
        """
        return pulumi.get(self, "virtual_machine_scale_set_id")

    @virtual_machine_scale_set_id.setter
    def virtual_machine_scale_set_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "virtual_machine_scale_set_id", value)


@pulumi.type_token("azure:compute/virtualMachineScaleSetExtension:VirtualMachineScaleSetExtension")
class VirtualMachineScaleSetExtension(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_upgrade_minor_version: Optional[pulumi.Input[_builtins.bool]] = None,
                 automatic_upgrade_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 failure_suppression_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 force_update_tag: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 protected_settings: Optional[pulumi.Input[_builtins.str]] = None,
                 protected_settings_from_key_vault: Optional[pulumi.Input[Union['VirtualMachineScaleSetExtensionProtectedSettingsFromKeyVaultArgs', 'VirtualMachineScaleSetExtensionProtectedSettingsFromKeyVaultArgsDict']]] = None,
                 provision_after_extensions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 publisher: Optional[pulumi.Input[_builtins.str]] = None,
                 settings: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 type_handler_version: Optional[pulumi.Input[_builtins.str]] = None,
                 virtual_machine_scale_set_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages an Extension for a Virtual Machine Scale Set.

        > **Note:** This resource is not intended to be used with the `compute.ScaleSet` resource - instead it's intended for this to be used with the `compute.LinuxVirtualMachineScaleSet` and `compute.WindowsVirtualMachineScaleSet` resources.

        ## Example Usage

        ```python
        import pulumi
        import json
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example",
            location="West Europe")
        example_linux_virtual_machine_scale_set = azure.compute.LinuxVirtualMachineScaleSet("example",
            name="example",
            resource_group_name=example.name,
            location=example.location,
            sku="Standard_F2",
            admin_username="adminuser",
            instances=1,
            source_image_reference={
                "publisher": "Canonical",
                "offer": "0001-com-ubuntu-server-jammy",
                "sku": "22_04-lts",
                "version": "latest",
            },
            network_interfaces=[{
                "name": "example",
                "ip_configurations": [{
                    "name": "internal",
                }],
            }],
            os_disk={
                "storage_account_type": "Standard_LRS",
                "caching": "ReadWrite",
            })
        example_virtual_machine_scale_set_extension = azure.compute.VirtualMachineScaleSetExtension("example",
            name="example",
            virtual_machine_scale_set_id=example_linux_virtual_machine_scale_set.id,
            publisher="Microsoft.Azure.Extensions",
            type="CustomScript",
            type_handler_version="2.0",
            settings=json.dumps({
                "commandToExecute": "echo $HOSTNAME",
            }))
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Compute`: 2024-11-01, 2024-03-01

        ## Import

        Virtual Machine Scale Set Extensions can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:compute/virtualMachineScaleSetExtension:VirtualMachineScaleSetExtension test /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.Compute/virtualMachineScaleSets/scaleSet1/extensions/extension1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] auto_upgrade_minor_version: Should the latest version of the Extension be used at Deployment Time, if one is available? This won't auto-update the extension on existing installation. Defaults to `true`.
        :param pulumi.Input[_builtins.bool] automatic_upgrade_enabled: Should the Extension be automatically updated whenever the Publisher releases a new version of this VM Extension?
        :param pulumi.Input[_builtins.bool] failure_suppression_enabled: Should failures from the extension be suppressed? Possible values are `true` or `false`. Defaults to `false`.
               
               > **Note:** Operational failures such as not connecting to the VM will not be suppressed regardless of the `failure_suppression_enabled` value.
        :param pulumi.Input[_builtins.str] force_update_tag: A value which, when different to the previous value can be used to force-run the Extension even if the Extension Configuration hasn't changed.
        :param pulumi.Input[_builtins.str] name: The name for the Virtual Machine Scale Set Extension. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] protected_settings: A JSON String which specifies Sensitive Settings (such as Passwords) for the Extension.
               
               > **Note:** Keys within the `protected_settings` block are notoriously case-sensitive, where the casing required (e.g. TitleCase vs snakeCase) depends on the Extension being used. Please refer to the documentation for the specific Virtual Machine Extension you're looking to use for more information.
        :param pulumi.Input[Union['VirtualMachineScaleSetExtensionProtectedSettingsFromKeyVaultArgs', 'VirtualMachineScaleSetExtensionProtectedSettingsFromKeyVaultArgsDict']] protected_settings_from_key_vault: A `protected_settings_from_key_vault` block as defined below.
               
               > **Note:** `protected_settings_from_key_vault` cannot be used with `protected_settings`
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] provision_after_extensions: An ordered list of Extension names which this should be provisioned after.
        :param pulumi.Input[_builtins.str] publisher: Specifies the Publisher of the Extension. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] settings: A JSON String which specifies Settings for the Extension.
               
               > **Note:** Keys within the `settings` block are notoriously case-sensitive, where the casing required (e.g. TitleCase vs snakeCase) depends on the Extension being used. Please refer to the documentation for the specific Virtual Machine Extension you're looking to use for more information.
        :param pulumi.Input[_builtins.str] type: Specifies the Type of the Extension. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] type_handler_version: Specifies the version of the extension to use, available versions can be found using the Azure CLI.
               
               > **Note:** The `Publisher` and `Type` of Virtual Machine Scale Set Extensions can be found using the Azure CLI, via:
               
               ```shell
               az vmss extension image list --location westus -o table
               ```
        :param pulumi.Input[_builtins.str] virtual_machine_scale_set_id: The ID of the Virtual Machine Scale Set. Changing this forces a new resource to be created.
               
               > **Note:** This should be the ID from the `compute.LinuxVirtualMachineScaleSet` or `compute.WindowsVirtualMachineScaleSet` resource - when using the older `compute.ScaleSet` resource extensions should instead be defined inline.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: VirtualMachineScaleSetExtensionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an Extension for a Virtual Machine Scale Set.

        > **Note:** This resource is not intended to be used with the `compute.ScaleSet` resource - instead it's intended for this to be used with the `compute.LinuxVirtualMachineScaleSet` and `compute.WindowsVirtualMachineScaleSet` resources.

        ## Example Usage

        ```python
        import pulumi
        import json
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example",
            location="West Europe")
        example_linux_virtual_machine_scale_set = azure.compute.LinuxVirtualMachineScaleSet("example",
            name="example",
            resource_group_name=example.name,
            location=example.location,
            sku="Standard_F2",
            admin_username="adminuser",
            instances=1,
            source_image_reference={
                "publisher": "Canonical",
                "offer": "0001-com-ubuntu-server-jammy",
                "sku": "22_04-lts",
                "version": "latest",
            },
            network_interfaces=[{
                "name": "example",
                "ip_configurations": [{
                    "name": "internal",
                }],
            }],
            os_disk={
                "storage_account_type": "Standard_LRS",
                "caching": "ReadWrite",
            })
        example_virtual_machine_scale_set_extension = azure.compute.VirtualMachineScaleSetExtension("example",
            name="example",
            virtual_machine_scale_set_id=example_linux_virtual_machine_scale_set.id,
            publisher="Microsoft.Azure.Extensions",
            type="CustomScript",
            type_handler_version="2.0",
            settings=json.dumps({
                "commandToExecute": "echo $HOSTNAME",
            }))
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Compute`: 2024-11-01, 2024-03-01

        ## Import

        Virtual Machine Scale Set Extensions can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:compute/virtualMachineScaleSetExtension:VirtualMachineScaleSetExtension test /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.Compute/virtualMachineScaleSets/scaleSet1/extensions/extension1
        ```

        :param str resource_name: The name of the resource.
        :param VirtualMachineScaleSetExtensionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VirtualMachineScaleSetExtensionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_upgrade_minor_version: Optional[pulumi.Input[_builtins.bool]] = None,
                 automatic_upgrade_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 failure_suppression_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 force_update_tag: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 protected_settings: Optional[pulumi.Input[_builtins.str]] = None,
                 protected_settings_from_key_vault: Optional[pulumi.Input[Union['VirtualMachineScaleSetExtensionProtectedSettingsFromKeyVaultArgs', 'VirtualMachineScaleSetExtensionProtectedSettingsFromKeyVaultArgsDict']]] = None,
                 provision_after_extensions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 publisher: Optional[pulumi.Input[_builtins.str]] = None,
                 settings: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 type_handler_version: Optional[pulumi.Input[_builtins.str]] = None,
                 virtual_machine_scale_set_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VirtualMachineScaleSetExtensionArgs.__new__(VirtualMachineScaleSetExtensionArgs)

            __props__.__dict__["auto_upgrade_minor_version"] = auto_upgrade_minor_version
            __props__.__dict__["automatic_upgrade_enabled"] = automatic_upgrade_enabled
            __props__.__dict__["failure_suppression_enabled"] = failure_suppression_enabled
            __props__.__dict__["force_update_tag"] = force_update_tag
            __props__.__dict__["name"] = name
            __props__.__dict__["protected_settings"] = None if protected_settings is None else pulumi.Output.secret(protected_settings)
            __props__.__dict__["protected_settings_from_key_vault"] = protected_settings_from_key_vault
            __props__.__dict__["provision_after_extensions"] = provision_after_extensions
            if publisher is None and not opts.urn:
                raise TypeError("Missing required property 'publisher'")
            __props__.__dict__["publisher"] = publisher
            __props__.__dict__["settings"] = settings
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            if type_handler_version is None and not opts.urn:
                raise TypeError("Missing required property 'type_handler_version'")
            __props__.__dict__["type_handler_version"] = type_handler_version
            if virtual_machine_scale_set_id is None and not opts.urn:
                raise TypeError("Missing required property 'virtual_machine_scale_set_id'")
            __props__.__dict__["virtual_machine_scale_set_id"] = virtual_machine_scale_set_id
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["protectedSettings"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(VirtualMachineScaleSetExtension, __self__).__init__(
            'azure:compute/virtualMachineScaleSetExtension:VirtualMachineScaleSetExtension',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            auto_upgrade_minor_version: Optional[pulumi.Input[_builtins.bool]] = None,
            automatic_upgrade_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            failure_suppression_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            force_update_tag: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            protected_settings: Optional[pulumi.Input[_builtins.str]] = None,
            protected_settings_from_key_vault: Optional[pulumi.Input[Union['VirtualMachineScaleSetExtensionProtectedSettingsFromKeyVaultArgs', 'VirtualMachineScaleSetExtensionProtectedSettingsFromKeyVaultArgsDict']]] = None,
            provision_after_extensions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            publisher: Optional[pulumi.Input[_builtins.str]] = None,
            settings: Optional[pulumi.Input[_builtins.str]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None,
            type_handler_version: Optional[pulumi.Input[_builtins.str]] = None,
            virtual_machine_scale_set_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'VirtualMachineScaleSetExtension':
        """
        Get an existing VirtualMachineScaleSetExtension resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] auto_upgrade_minor_version: Should the latest version of the Extension be used at Deployment Time, if one is available? This won't auto-update the extension on existing installation. Defaults to `true`.
        :param pulumi.Input[_builtins.bool] automatic_upgrade_enabled: Should the Extension be automatically updated whenever the Publisher releases a new version of this VM Extension?
        :param pulumi.Input[_builtins.bool] failure_suppression_enabled: Should failures from the extension be suppressed? Possible values are `true` or `false`. Defaults to `false`.
               
               > **Note:** Operational failures such as not connecting to the VM will not be suppressed regardless of the `failure_suppression_enabled` value.
        :param pulumi.Input[_builtins.str] force_update_tag: A value which, when different to the previous value can be used to force-run the Extension even if the Extension Configuration hasn't changed.
        :param pulumi.Input[_builtins.str] name: The name for the Virtual Machine Scale Set Extension. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] protected_settings: A JSON String which specifies Sensitive Settings (such as Passwords) for the Extension.
               
               > **Note:** Keys within the `protected_settings` block are notoriously case-sensitive, where the casing required (e.g. TitleCase vs snakeCase) depends on the Extension being used. Please refer to the documentation for the specific Virtual Machine Extension you're looking to use for more information.
        :param pulumi.Input[Union['VirtualMachineScaleSetExtensionProtectedSettingsFromKeyVaultArgs', 'VirtualMachineScaleSetExtensionProtectedSettingsFromKeyVaultArgsDict']] protected_settings_from_key_vault: A `protected_settings_from_key_vault` block as defined below.
               
               > **Note:** `protected_settings_from_key_vault` cannot be used with `protected_settings`
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] provision_after_extensions: An ordered list of Extension names which this should be provisioned after.
        :param pulumi.Input[_builtins.str] publisher: Specifies the Publisher of the Extension. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] settings: A JSON String which specifies Settings for the Extension.
               
               > **Note:** Keys within the `settings` block are notoriously case-sensitive, where the casing required (e.g. TitleCase vs snakeCase) depends on the Extension being used. Please refer to the documentation for the specific Virtual Machine Extension you're looking to use for more information.
        :param pulumi.Input[_builtins.str] type: Specifies the Type of the Extension. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] type_handler_version: Specifies the version of the extension to use, available versions can be found using the Azure CLI.
               
               > **Note:** The `Publisher` and `Type` of Virtual Machine Scale Set Extensions can be found using the Azure CLI, via:
               
               ```shell
               az vmss extension image list --location westus -o table
               ```
        :param pulumi.Input[_builtins.str] virtual_machine_scale_set_id: The ID of the Virtual Machine Scale Set. Changing this forces a new resource to be created.
               
               > **Note:** This should be the ID from the `compute.LinuxVirtualMachineScaleSet` or `compute.WindowsVirtualMachineScaleSet` resource - when using the older `compute.ScaleSet` resource extensions should instead be defined inline.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _VirtualMachineScaleSetExtensionState.__new__(_VirtualMachineScaleSetExtensionState)

        __props__.__dict__["auto_upgrade_minor_version"] = auto_upgrade_minor_version
        __props__.__dict__["automatic_upgrade_enabled"] = automatic_upgrade_enabled
        __props__.__dict__["failure_suppression_enabled"] = failure_suppression_enabled
        __props__.__dict__["force_update_tag"] = force_update_tag
        __props__.__dict__["name"] = name
        __props__.__dict__["protected_settings"] = protected_settings
        __props__.__dict__["protected_settings_from_key_vault"] = protected_settings_from_key_vault
        __props__.__dict__["provision_after_extensions"] = provision_after_extensions
        __props__.__dict__["publisher"] = publisher
        __props__.__dict__["settings"] = settings
        __props__.__dict__["type"] = type
        __props__.__dict__["type_handler_version"] = type_handler_version
        __props__.__dict__["virtual_machine_scale_set_id"] = virtual_machine_scale_set_id
        return VirtualMachineScaleSetExtension(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="autoUpgradeMinorVersion")
    def auto_upgrade_minor_version(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Should the latest version of the Extension be used at Deployment Time, if one is available? This won't auto-update the extension on existing installation. Defaults to `true`.
        """
        return pulumi.get(self, "auto_upgrade_minor_version")

    @_builtins.property
    @pulumi.getter(name="automaticUpgradeEnabled")
    def automatic_upgrade_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Should the Extension be automatically updated whenever the Publisher releases a new version of this VM Extension?
        """
        return pulumi.get(self, "automatic_upgrade_enabled")

    @_builtins.property
    @pulumi.getter(name="failureSuppressionEnabled")
    def failure_suppression_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Should failures from the extension be suppressed? Possible values are `true` or `false`. Defaults to `false`.

        > **Note:** Operational failures such as not connecting to the VM will not be suppressed regardless of the `failure_suppression_enabled` value.
        """
        return pulumi.get(self, "failure_suppression_enabled")

    @_builtins.property
    @pulumi.getter(name="forceUpdateTag")
    def force_update_tag(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        A value which, when different to the previous value can be used to force-run the Extension even if the Extension Configuration hasn't changed.
        """
        return pulumi.get(self, "force_update_tag")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name for the Virtual Machine Scale Set Extension. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="protectedSettings")
    def protected_settings(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        A JSON String which specifies Sensitive Settings (such as Passwords) for the Extension.

        > **Note:** Keys within the `protected_settings` block are notoriously case-sensitive, where the casing required (e.g. TitleCase vs snakeCase) depends on the Extension being used. Please refer to the documentation for the specific Virtual Machine Extension you're looking to use for more information.
        """
        return pulumi.get(self, "protected_settings")

    @_builtins.property
    @pulumi.getter(name="protectedSettingsFromKeyVault")
    def protected_settings_from_key_vault(self) -> pulumi.Output[Optional['outputs.VirtualMachineScaleSetExtensionProtectedSettingsFromKeyVault']]:
        """
        A `protected_settings_from_key_vault` block as defined below.

        > **Note:** `protected_settings_from_key_vault` cannot be used with `protected_settings`
        """
        return pulumi.get(self, "protected_settings_from_key_vault")

    @_builtins.property
    @pulumi.getter(name="provisionAfterExtensions")
    def provision_after_extensions(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        An ordered list of Extension names which this should be provisioned after.
        """
        return pulumi.get(self, "provision_after_extensions")

    @_builtins.property
    @pulumi.getter
    def publisher(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the Publisher of the Extension. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "publisher")

    @_builtins.property
    @pulumi.getter
    def settings(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        A JSON String which specifies Settings for the Extension.

        > **Note:** Keys within the `settings` block are notoriously case-sensitive, where the casing required (e.g. TitleCase vs snakeCase) depends on the Extension being used. Please refer to the documentation for the specific Virtual Machine Extension you're looking to use for more information.
        """
        return pulumi.get(self, "settings")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the Type of the Extension. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="typeHandlerVersion")
    def type_handler_version(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the version of the extension to use, available versions can be found using the Azure CLI.

        > **Note:** The `Publisher` and `Type` of Virtual Machine Scale Set Extensions can be found using the Azure CLI, via:

        ```shell
        az vmss extension image list --location westus -o table
        ```
        """
        return pulumi.get(self, "type_handler_version")

    @_builtins.property
    @pulumi.getter(name="virtualMachineScaleSetId")
    def virtual_machine_scale_set_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Virtual Machine Scale Set. Changing this forces a new resource to be created.

        > **Note:** This should be the ID from the `compute.LinuxVirtualMachineScaleSet` or `compute.WindowsVirtualMachineScaleSet` resource - when using the older `compute.ScaleSet` resource extensions should instead be defined inline.
        """
        return pulumi.get(self, "virtual_machine_scale_set_id")

