# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

import types

__config__ = pulumi.Config('azure')


class _ExportableConfig(types.ModuleType):
    @_builtins.property
    def ado_pipeline_service_connection_id(self) -> Optional[str]:
        """
        The Azure DevOps Pipeline Service Connection ID.
        """
        return __config__.get('adoPipelineServiceConnectionId')

    @_builtins.property
    def auxiliary_tenant_ids(self) -> Optional[str]:
        return __config__.get('auxiliaryTenantIds')

    @_builtins.property
    def client_certificate(self) -> Optional[str]:
        """
        Base64 encoded PKCS#12 certificate bundle to use when authenticating as a Service Principal using a Client Certificate
        """
        return __config__.get('clientCertificate')

    @_builtins.property
    def client_certificate_password(self) -> Optional[str]:
        """
        The password associated with the Client Certificate. For use when authenticating as a Service Principal using a Client
        Certificate
        """
        return __config__.get('clientCertificatePassword')

    @_builtins.property
    def client_certificate_path(self) -> Optional[str]:
        """
        The path to the Client Certificate associated with the Service Principal for use when authenticating as a Service
        Principal using a Client Certificate.
        """
        return __config__.get('clientCertificatePath')

    @_builtins.property
    def client_id(self) -> Optional[str]:
        """
        The Client ID which should be used.
        """
        return __config__.get('clientId')

    @_builtins.property
    def client_id_file_path(self) -> Optional[str]:
        """
        The path to a file containing the Client ID which should be used.
        """
        return __config__.get('clientIdFilePath')

    @_builtins.property
    def client_secret(self) -> Optional[str]:
        """
        The Client Secret which should be used. For use When authenticating as a Service Principal using a Client Secret.
        """
        return __config__.get('clientSecret')

    @_builtins.property
    def client_secret_file_path(self) -> Optional[str]:
        """
        The path to a file containing the Client Secret which should be used. For use When authenticating as a Service Principal
        using a Client Secret.
        """
        return __config__.get('clientSecretFilePath')

    @_builtins.property
    def disable_correlation_request_id(self) -> Optional[bool]:
        """
        This will disable the x-ms-correlation-request-id header.
        """
        return __config__.get_bool('disableCorrelationRequestId')

    @_builtins.property
    def disable_terraform_partner_id(self) -> Optional[bool]:
        return __config__.get_bool('disableTerraformPartnerId')

    @_builtins.property
    def environment(self) -> str:
        """
        The Cloud Environment which should be used. Possible values are public, usgovernment, and china. Defaults to public. Not
        used and should not be specified when `metadata_host` is specified.
        """
        return __config__.get('environment') or (_utilities.get_env('AZURE_ENVIRONMENT', 'ARM_ENVIRONMENT') or 'public')

    @_builtins.property
    def features(self) -> Optional[str]:
        return __config__.get('features')

    @_builtins.property
    def location(self) -> Optional[str]:
        return __config__.get('location') or _utilities.get_env('ARM_LOCATION')

    @_builtins.property
    def metadata_host(self) -> Optional[str]:
        """
        The Hostname which should be used for the Azure Metadata Service.
        """
        return __config__.get('metadataHost') or _utilities.get_env('ARM_METADATA_HOSTNAME')

    @_builtins.property
    def msi_endpoint(self) -> Optional[str]:
        """
        The path to a custom endpoint for Managed Service Identity - in most circumstances this should be detected
        automatically.
        """
        return __config__.get('msiEndpoint')

    @_builtins.property
    def oidc_request_token(self) -> Optional[str]:
        """
        The bearer token for the request to the OIDC provider. For use when authenticating as a Service Principal using OpenID
        Connect.
        """
        return __config__.get('oidcRequestToken')

    @_builtins.property
    def oidc_request_url(self) -> Optional[str]:
        """
        The URL for the OIDC provider from which to request an ID token. For use when authenticating as a Service Principal
        using OpenID Connect.
        """
        return __config__.get('oidcRequestUrl')

    @_builtins.property
    def oidc_token(self) -> Optional[str]:
        """
        The OIDC ID token for use when authenticating as a Service Principal using OpenID Connect.
        """
        return __config__.get('oidcToken')

    @_builtins.property
    def oidc_token_file_path(self) -> Optional[str]:
        """
        The path to a file containing an OIDC ID token for use when authenticating as a Service Principal using OpenID Connect.
        """
        return __config__.get('oidcTokenFilePath')

    @_builtins.property
    def partner_id(self) -> Optional[str]:
        """
        A GUID/UUID that is registered with Microsoft to facilitate partner resource usage attribution.
        """
        return __config__.get('partnerId')

    @_builtins.property
    def resource_provider_registrations(self) -> Optional[str]:
        """
        The set of Resource Providers which should be automatically registered for the subscription.
        """
        return __config__.get('resourceProviderRegistrations')

    @_builtins.property
    def resource_providers_to_registers(self) -> Optional[str]:
        """
        A list of Resource Providers to explicitly register for the subscription, in addition to those specified by the
        `resource_provider_registrations` property.
        """
        return __config__.get('resourceProvidersToRegisters')

    @_builtins.property
    def skip_provider_registration(self) -> bool:
        """
        Should the AzureRM Provider skip registering all of the Resource Providers that it supports, if they're not already
        registered?
        """
        return __config__.get_bool('skipProviderRegistration') or (_utilities.get_env_bool('ARM_SKIP_PROVIDER_REGISTRATION') or False)

    @_builtins.property
    def storage_use_azuread(self) -> bool:
        """
        Should the AzureRM Provider use Azure AD Authentication when accessing the Storage Data Plane APIs?
        """
        return __config__.get_bool('storageUseAzuread') or (_utilities.get_env_bool('ARM_STORAGE_USE_AZUREAD') or False)

    @_builtins.property
    def subscription_id(self) -> str:
        """
        The Subscription ID which should be used.
        """
        return __config__.get('subscriptionId') or (_utilities.get_env('ARM_SUBSCRIPTION_ID') or '')

    @_builtins.property
    def tenant_id(self) -> Optional[str]:
        """
        The Tenant ID which should be used.
        """
        return __config__.get('tenantId')

    @_builtins.property
    def use_aks_workload_identity(self) -> Optional[bool]:
        """
        Allow Azure AKS Workload Identity to be used for Authentication.
        """
        return __config__.get_bool('useAksWorkloadIdentity')

    @_builtins.property
    def use_cli(self) -> Optional[bool]:
        """
        Allow Azure CLI to be used for Authentication.
        """
        return __config__.get_bool('useCli')

    @_builtins.property
    def use_msi(self) -> Optional[bool]:
        """
        Allow Managed Service Identity to be used for Authentication.
        """
        return __config__.get_bool('useMsi')

    @_builtins.property
    def use_oidc(self) -> Optional[bool]:
        """
        Allow OpenID Connect to be used for authentication
        """
        return __config__.get_bool('useOidc')

