# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['FleetUpdateRunArgs', 'FleetUpdateRun']

@pulumi.input_type
class FleetUpdateRunArgs:
    def __init__(__self__, *,
                 kubernetes_fleet_manager_id: pulumi.Input[_builtins.str],
                 managed_cluster_update: pulumi.Input['FleetUpdateRunManagedClusterUpdateArgs'],
                 fleet_update_strategy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 stages: Optional[pulumi.Input[Sequence[pulumi.Input['FleetUpdateRunStageArgs']]]] = None):
        """
        The set of arguments for constructing a FleetUpdateRun resource.
        :param pulumi.Input[_builtins.str] kubernetes_fleet_manager_id: The ID of the Fleet Manager. Changing this forces a new Kubernetes Fleet Update Run to be created.
        :param pulumi.Input['FleetUpdateRunManagedClusterUpdateArgs'] managed_cluster_update: A `managed_cluster_update` block as defined below.
        :param pulumi.Input[_builtins.str] fleet_update_strategy_id: The ID of the Fleet Update Strategy. Only one of `fleet_update_strategy_id` or `stage` can be specified.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Kubernetes Fleet Update Run. Changing this forces a new Kubernetes Fleet Update Run to be created.
        :param pulumi.Input[Sequence[pulumi.Input['FleetUpdateRunStageArgs']]] stages: One or more `stage` blocks as defined below. Only one of `stage` or `fleet_update_strategy_id` can be specified.
        """
        pulumi.set(__self__, "kubernetes_fleet_manager_id", kubernetes_fleet_manager_id)
        pulumi.set(__self__, "managed_cluster_update", managed_cluster_update)
        if fleet_update_strategy_id is not None:
            pulumi.set(__self__, "fleet_update_strategy_id", fleet_update_strategy_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if stages is not None:
            pulumi.set(__self__, "stages", stages)

    @_builtins.property
    @pulumi.getter(name="kubernetesFleetManagerId")
    def kubernetes_fleet_manager_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Fleet Manager. Changing this forces a new Kubernetes Fleet Update Run to be created.
        """
        return pulumi.get(self, "kubernetes_fleet_manager_id")

    @kubernetes_fleet_manager_id.setter
    def kubernetes_fleet_manager_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "kubernetes_fleet_manager_id", value)

    @_builtins.property
    @pulumi.getter(name="managedClusterUpdate")
    def managed_cluster_update(self) -> pulumi.Input['FleetUpdateRunManagedClusterUpdateArgs']:
        """
        A `managed_cluster_update` block as defined below.
        """
        return pulumi.get(self, "managed_cluster_update")

    @managed_cluster_update.setter
    def managed_cluster_update(self, value: pulumi.Input['FleetUpdateRunManagedClusterUpdateArgs']):
        pulumi.set(self, "managed_cluster_update", value)

    @_builtins.property
    @pulumi.getter(name="fleetUpdateStrategyId")
    def fleet_update_strategy_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Fleet Update Strategy. Only one of `fleet_update_strategy_id` or `stage` can be specified.
        """
        return pulumi.get(self, "fleet_update_strategy_id")

    @fleet_update_strategy_id.setter
    def fleet_update_strategy_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "fleet_update_strategy_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Kubernetes Fleet Update Run. Changing this forces a new Kubernetes Fleet Update Run to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def stages(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FleetUpdateRunStageArgs']]]]:
        """
        One or more `stage` blocks as defined below. Only one of `stage` or `fleet_update_strategy_id` can be specified.
        """
        return pulumi.get(self, "stages")

    @stages.setter
    def stages(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FleetUpdateRunStageArgs']]]]):
        pulumi.set(self, "stages", value)


@pulumi.input_type
class _FleetUpdateRunState:
    def __init__(__self__, *,
                 fleet_update_strategy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 kubernetes_fleet_manager_id: Optional[pulumi.Input[_builtins.str]] = None,
                 managed_cluster_update: Optional[pulumi.Input['FleetUpdateRunManagedClusterUpdateArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 stages: Optional[pulumi.Input[Sequence[pulumi.Input['FleetUpdateRunStageArgs']]]] = None):
        """
        Input properties used for looking up and filtering FleetUpdateRun resources.
        :param pulumi.Input[_builtins.str] fleet_update_strategy_id: The ID of the Fleet Update Strategy. Only one of `fleet_update_strategy_id` or `stage` can be specified.
        :param pulumi.Input[_builtins.str] kubernetes_fleet_manager_id: The ID of the Fleet Manager. Changing this forces a new Kubernetes Fleet Update Run to be created.
        :param pulumi.Input['FleetUpdateRunManagedClusterUpdateArgs'] managed_cluster_update: A `managed_cluster_update` block as defined below.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Kubernetes Fleet Update Run. Changing this forces a new Kubernetes Fleet Update Run to be created.
        :param pulumi.Input[Sequence[pulumi.Input['FleetUpdateRunStageArgs']]] stages: One or more `stage` blocks as defined below. Only one of `stage` or `fleet_update_strategy_id` can be specified.
        """
        if fleet_update_strategy_id is not None:
            pulumi.set(__self__, "fleet_update_strategy_id", fleet_update_strategy_id)
        if kubernetes_fleet_manager_id is not None:
            pulumi.set(__self__, "kubernetes_fleet_manager_id", kubernetes_fleet_manager_id)
        if managed_cluster_update is not None:
            pulumi.set(__self__, "managed_cluster_update", managed_cluster_update)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if stages is not None:
            pulumi.set(__self__, "stages", stages)

    @_builtins.property
    @pulumi.getter(name="fleetUpdateStrategyId")
    def fleet_update_strategy_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Fleet Update Strategy. Only one of `fleet_update_strategy_id` or `stage` can be specified.
        """
        return pulumi.get(self, "fleet_update_strategy_id")

    @fleet_update_strategy_id.setter
    def fleet_update_strategy_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "fleet_update_strategy_id", value)

    @_builtins.property
    @pulumi.getter(name="kubernetesFleetManagerId")
    def kubernetes_fleet_manager_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Fleet Manager. Changing this forces a new Kubernetes Fleet Update Run to be created.
        """
        return pulumi.get(self, "kubernetes_fleet_manager_id")

    @kubernetes_fleet_manager_id.setter
    def kubernetes_fleet_manager_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kubernetes_fleet_manager_id", value)

    @_builtins.property
    @pulumi.getter(name="managedClusterUpdate")
    def managed_cluster_update(self) -> Optional[pulumi.Input['FleetUpdateRunManagedClusterUpdateArgs']]:
        """
        A `managed_cluster_update` block as defined below.
        """
        return pulumi.get(self, "managed_cluster_update")

    @managed_cluster_update.setter
    def managed_cluster_update(self, value: Optional[pulumi.Input['FleetUpdateRunManagedClusterUpdateArgs']]):
        pulumi.set(self, "managed_cluster_update", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Kubernetes Fleet Update Run. Changing this forces a new Kubernetes Fleet Update Run to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def stages(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FleetUpdateRunStageArgs']]]]:
        """
        One or more `stage` blocks as defined below. Only one of `stage` or `fleet_update_strategy_id` can be specified.
        """
        return pulumi.get(self, "stages")

    @stages.setter
    def stages(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FleetUpdateRunStageArgs']]]]):
        pulumi.set(self, "stages", value)


@pulumi.type_token("azure:containerservice/fleetUpdateRun:FleetUpdateRun")
class FleetUpdateRun(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 fleet_update_strategy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 kubernetes_fleet_manager_id: Optional[pulumi.Input[_builtins.str]] = None,
                 managed_cluster_update: Optional[pulumi.Input[Union['FleetUpdateRunManagedClusterUpdateArgs', 'FleetUpdateRunManagedClusterUpdateArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 stages: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FleetUpdateRunStageArgs', 'FleetUpdateRunStageArgsDict']]]]] = None,
                 __props__=None):
        """
        Manages a Kubernetes Fleet Update Run.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-rg",
            location="westeurope")
        example_kubernetes_fleet_manager = azure.containerservice.KubernetesFleetManager("example",
            location=example.location,
            name="example",
            resource_group_name=example.name)
        example_kubernetes_cluster = azure.containerservice.KubernetesCluster("example",
            name="example",
            location=example.location,
            resource_group_name=example.name,
            dns_prefix="example",
            default_node_pool={
                "name": "default",
                "node_count": 1,
                "vm_size": "Standard_DS2_v2",
            },
            identity={
                "type": "SystemAssigned",
            })
        example_fleet_member = azure.containerservice.FleetMember("example",
            name="example",
            kubernetes_fleet_id=example_kubernetes_fleet_manager.id,
            kubernetes_cluster_id=example_kubernetes_cluster.id,
            group="example-group")
        example_fleet_update_run = azure.containerservice.FleetUpdateRun("example",
            name="example",
            kubernetes_fleet_manager_id=example_kubernetes_fleet_manager.id,
            managed_cluster_update={
                "upgrade": {
                    "type": "Full",
                    "kubernetes_version": "1.27",
                },
                "node_image_selection": {
                    "type": "Latest",
                },
            },
            stages=[{
                "name": "example",
                "groups": [{
                    "name": "example-group",
                }],
                "after_stage_wait_in_seconds": 21,
            }])
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.ContainerService`: 2024-04-01

        ## Import

        Kubernetes Fleet Update Runs can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:containerservice/fleetUpdateRun:FleetUpdateRun example /subscriptions/12345678-1234-9876-4563-123456789012/resourceGroups/resourceGroup1/providers/Microsoft.ContainerService/fleets/fleet1/updateRuns/updateRun1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] fleet_update_strategy_id: The ID of the Fleet Update Strategy. Only one of `fleet_update_strategy_id` or `stage` can be specified.
        :param pulumi.Input[_builtins.str] kubernetes_fleet_manager_id: The ID of the Fleet Manager. Changing this forces a new Kubernetes Fleet Update Run to be created.
        :param pulumi.Input[Union['FleetUpdateRunManagedClusterUpdateArgs', 'FleetUpdateRunManagedClusterUpdateArgsDict']] managed_cluster_update: A `managed_cluster_update` block as defined below.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Kubernetes Fleet Update Run. Changing this forces a new Kubernetes Fleet Update Run to be created.
        :param pulumi.Input[Sequence[pulumi.Input[Union['FleetUpdateRunStageArgs', 'FleetUpdateRunStageArgsDict']]]] stages: One or more `stage` blocks as defined below. Only one of `stage` or `fleet_update_strategy_id` can be specified.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FleetUpdateRunArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Kubernetes Fleet Update Run.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-rg",
            location="westeurope")
        example_kubernetes_fleet_manager = azure.containerservice.KubernetesFleetManager("example",
            location=example.location,
            name="example",
            resource_group_name=example.name)
        example_kubernetes_cluster = azure.containerservice.KubernetesCluster("example",
            name="example",
            location=example.location,
            resource_group_name=example.name,
            dns_prefix="example",
            default_node_pool={
                "name": "default",
                "node_count": 1,
                "vm_size": "Standard_DS2_v2",
            },
            identity={
                "type": "SystemAssigned",
            })
        example_fleet_member = azure.containerservice.FleetMember("example",
            name="example",
            kubernetes_fleet_id=example_kubernetes_fleet_manager.id,
            kubernetes_cluster_id=example_kubernetes_cluster.id,
            group="example-group")
        example_fleet_update_run = azure.containerservice.FleetUpdateRun("example",
            name="example",
            kubernetes_fleet_manager_id=example_kubernetes_fleet_manager.id,
            managed_cluster_update={
                "upgrade": {
                    "type": "Full",
                    "kubernetes_version": "1.27",
                },
                "node_image_selection": {
                    "type": "Latest",
                },
            },
            stages=[{
                "name": "example",
                "groups": [{
                    "name": "example-group",
                }],
                "after_stage_wait_in_seconds": 21,
            }])
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.ContainerService`: 2024-04-01

        ## Import

        Kubernetes Fleet Update Runs can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:containerservice/fleetUpdateRun:FleetUpdateRun example /subscriptions/12345678-1234-9876-4563-123456789012/resourceGroups/resourceGroup1/providers/Microsoft.ContainerService/fleets/fleet1/updateRuns/updateRun1
        ```

        :param str resource_name: The name of the resource.
        :param FleetUpdateRunArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FleetUpdateRunArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 fleet_update_strategy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 kubernetes_fleet_manager_id: Optional[pulumi.Input[_builtins.str]] = None,
                 managed_cluster_update: Optional[pulumi.Input[Union['FleetUpdateRunManagedClusterUpdateArgs', 'FleetUpdateRunManagedClusterUpdateArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 stages: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FleetUpdateRunStageArgs', 'FleetUpdateRunStageArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FleetUpdateRunArgs.__new__(FleetUpdateRunArgs)

            __props__.__dict__["fleet_update_strategy_id"] = fleet_update_strategy_id
            if kubernetes_fleet_manager_id is None and not opts.urn:
                raise TypeError("Missing required property 'kubernetes_fleet_manager_id'")
            __props__.__dict__["kubernetes_fleet_manager_id"] = kubernetes_fleet_manager_id
            if managed_cluster_update is None and not opts.urn:
                raise TypeError("Missing required property 'managed_cluster_update'")
            __props__.__dict__["managed_cluster_update"] = managed_cluster_update
            __props__.__dict__["name"] = name
            __props__.__dict__["stages"] = stages
        super(FleetUpdateRun, __self__).__init__(
            'azure:containerservice/fleetUpdateRun:FleetUpdateRun',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            fleet_update_strategy_id: Optional[pulumi.Input[_builtins.str]] = None,
            kubernetes_fleet_manager_id: Optional[pulumi.Input[_builtins.str]] = None,
            managed_cluster_update: Optional[pulumi.Input[Union['FleetUpdateRunManagedClusterUpdateArgs', 'FleetUpdateRunManagedClusterUpdateArgsDict']]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            stages: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FleetUpdateRunStageArgs', 'FleetUpdateRunStageArgsDict']]]]] = None) -> 'FleetUpdateRun':
        """
        Get an existing FleetUpdateRun resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] fleet_update_strategy_id: The ID of the Fleet Update Strategy. Only one of `fleet_update_strategy_id` or `stage` can be specified.
        :param pulumi.Input[_builtins.str] kubernetes_fleet_manager_id: The ID of the Fleet Manager. Changing this forces a new Kubernetes Fleet Update Run to be created.
        :param pulumi.Input[Union['FleetUpdateRunManagedClusterUpdateArgs', 'FleetUpdateRunManagedClusterUpdateArgsDict']] managed_cluster_update: A `managed_cluster_update` block as defined below.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Kubernetes Fleet Update Run. Changing this forces a new Kubernetes Fleet Update Run to be created.
        :param pulumi.Input[Sequence[pulumi.Input[Union['FleetUpdateRunStageArgs', 'FleetUpdateRunStageArgsDict']]]] stages: One or more `stage` blocks as defined below. Only one of `stage` or `fleet_update_strategy_id` can be specified.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FleetUpdateRunState.__new__(_FleetUpdateRunState)

        __props__.__dict__["fleet_update_strategy_id"] = fleet_update_strategy_id
        __props__.__dict__["kubernetes_fleet_manager_id"] = kubernetes_fleet_manager_id
        __props__.__dict__["managed_cluster_update"] = managed_cluster_update
        __props__.__dict__["name"] = name
        __props__.__dict__["stages"] = stages
        return FleetUpdateRun(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="fleetUpdateStrategyId")
    def fleet_update_strategy_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the Fleet Update Strategy. Only one of `fleet_update_strategy_id` or `stage` can be specified.
        """
        return pulumi.get(self, "fleet_update_strategy_id")

    @_builtins.property
    @pulumi.getter(name="kubernetesFleetManagerId")
    def kubernetes_fleet_manager_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Fleet Manager. Changing this forces a new Kubernetes Fleet Update Run to be created.
        """
        return pulumi.get(self, "kubernetes_fleet_manager_id")

    @_builtins.property
    @pulumi.getter(name="managedClusterUpdate")
    def managed_cluster_update(self) -> pulumi.Output['outputs.FleetUpdateRunManagedClusterUpdate']:
        """
        A `managed_cluster_update` block as defined below.
        """
        return pulumi.get(self, "managed_cluster_update")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name which should be used for this Kubernetes Fleet Update Run. Changing this forces a new Kubernetes Fleet Update Run to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def stages(self) -> pulumi.Output[Optional[Sequence['outputs.FleetUpdateRunStage']]]:
        """
        One or more `stage` blocks as defined below. Only one of `stage` or `fleet_update_strategy_id` can be specified.
        """
        return pulumi.get(self, "stages")

