# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetKubernetesClusterResult',
    'AwaitableGetKubernetesClusterResult',
    'get_kubernetes_cluster',
    'get_kubernetes_cluster_output',
]

@pulumi.output_type
class GetKubernetesClusterResult:
    """
    A collection of values returned by getKubernetesCluster.
    """
    def __init__(__self__, aci_connector_linuxes=None, agent_pool_profiles=None, api_server_authorized_ip_ranges=None, azure_active_directory_role_based_access_controls=None, azure_policy_enabled=None, current_kubernetes_version=None, disk_encryption_set_id=None, dns_prefix=None, fqdn=None, http_application_routing_enabled=None, http_application_routing_zone_name=None, id=None, identities=None, ingress_application_gateways=None, key_management_services=None, key_vault_secrets_providers=None, kube_admin_config_raw=None, kube_admin_configs=None, kube_config_raw=None, kube_configs=None, kubelet_identities=None, kubernetes_version=None, linux_profiles=None, location=None, microsoft_defenders=None, name=None, network_profiles=None, node_resource_group=None, node_resource_group_id=None, oidc_issuer_enabled=None, oidc_issuer_url=None, oms_agents=None, open_service_mesh_enabled=None, private_cluster_enabled=None, private_fqdn=None, resource_group_name=None, role_based_access_control_enabled=None, service_mesh_profiles=None, service_principals=None, storage_profiles=None, tags=None, windows_profiles=None):
        if aci_connector_linuxes and not isinstance(aci_connector_linuxes, list):
            raise TypeError("Expected argument 'aci_connector_linuxes' to be a list")
        pulumi.set(__self__, "aci_connector_linuxes", aci_connector_linuxes)
        if agent_pool_profiles and not isinstance(agent_pool_profiles, list):
            raise TypeError("Expected argument 'agent_pool_profiles' to be a list")
        pulumi.set(__self__, "agent_pool_profiles", agent_pool_profiles)
        if api_server_authorized_ip_ranges and not isinstance(api_server_authorized_ip_ranges, list):
            raise TypeError("Expected argument 'api_server_authorized_ip_ranges' to be a list")
        pulumi.set(__self__, "api_server_authorized_ip_ranges", api_server_authorized_ip_ranges)
        if azure_active_directory_role_based_access_controls and not isinstance(azure_active_directory_role_based_access_controls, list):
            raise TypeError("Expected argument 'azure_active_directory_role_based_access_controls' to be a list")
        pulumi.set(__self__, "azure_active_directory_role_based_access_controls", azure_active_directory_role_based_access_controls)
        if azure_policy_enabled and not isinstance(azure_policy_enabled, bool):
            raise TypeError("Expected argument 'azure_policy_enabled' to be a bool")
        pulumi.set(__self__, "azure_policy_enabled", azure_policy_enabled)
        if current_kubernetes_version and not isinstance(current_kubernetes_version, str):
            raise TypeError("Expected argument 'current_kubernetes_version' to be a str")
        pulumi.set(__self__, "current_kubernetes_version", current_kubernetes_version)
        if disk_encryption_set_id and not isinstance(disk_encryption_set_id, str):
            raise TypeError("Expected argument 'disk_encryption_set_id' to be a str")
        pulumi.set(__self__, "disk_encryption_set_id", disk_encryption_set_id)
        if dns_prefix and not isinstance(dns_prefix, str):
            raise TypeError("Expected argument 'dns_prefix' to be a str")
        pulumi.set(__self__, "dns_prefix", dns_prefix)
        if fqdn and not isinstance(fqdn, str):
            raise TypeError("Expected argument 'fqdn' to be a str")
        pulumi.set(__self__, "fqdn", fqdn)
        if http_application_routing_enabled and not isinstance(http_application_routing_enabled, bool):
            raise TypeError("Expected argument 'http_application_routing_enabled' to be a bool")
        pulumi.set(__self__, "http_application_routing_enabled", http_application_routing_enabled)
        if http_application_routing_zone_name and not isinstance(http_application_routing_zone_name, str):
            raise TypeError("Expected argument 'http_application_routing_zone_name' to be a str")
        pulumi.set(__self__, "http_application_routing_zone_name", http_application_routing_zone_name)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if identities and not isinstance(identities, list):
            raise TypeError("Expected argument 'identities' to be a list")
        pulumi.set(__self__, "identities", identities)
        if ingress_application_gateways and not isinstance(ingress_application_gateways, list):
            raise TypeError("Expected argument 'ingress_application_gateways' to be a list")
        pulumi.set(__self__, "ingress_application_gateways", ingress_application_gateways)
        if key_management_services and not isinstance(key_management_services, list):
            raise TypeError("Expected argument 'key_management_services' to be a list")
        pulumi.set(__self__, "key_management_services", key_management_services)
        if key_vault_secrets_providers and not isinstance(key_vault_secrets_providers, list):
            raise TypeError("Expected argument 'key_vault_secrets_providers' to be a list")
        pulumi.set(__self__, "key_vault_secrets_providers", key_vault_secrets_providers)
        if kube_admin_config_raw and not isinstance(kube_admin_config_raw, str):
            raise TypeError("Expected argument 'kube_admin_config_raw' to be a str")
        pulumi.set(__self__, "kube_admin_config_raw", kube_admin_config_raw)
        if kube_admin_configs and not isinstance(kube_admin_configs, list):
            raise TypeError("Expected argument 'kube_admin_configs' to be a list")
        pulumi.set(__self__, "kube_admin_configs", kube_admin_configs)
        if kube_config_raw and not isinstance(kube_config_raw, str):
            raise TypeError("Expected argument 'kube_config_raw' to be a str")
        pulumi.set(__self__, "kube_config_raw", kube_config_raw)
        if kube_configs and not isinstance(kube_configs, list):
            raise TypeError("Expected argument 'kube_configs' to be a list")
        pulumi.set(__self__, "kube_configs", kube_configs)
        if kubelet_identities and not isinstance(kubelet_identities, list):
            raise TypeError("Expected argument 'kubelet_identities' to be a list")
        pulumi.set(__self__, "kubelet_identities", kubelet_identities)
        if kubernetes_version and not isinstance(kubernetes_version, str):
            raise TypeError("Expected argument 'kubernetes_version' to be a str")
        pulumi.set(__self__, "kubernetes_version", kubernetes_version)
        if linux_profiles and not isinstance(linux_profiles, list):
            raise TypeError("Expected argument 'linux_profiles' to be a list")
        pulumi.set(__self__, "linux_profiles", linux_profiles)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if microsoft_defenders and not isinstance(microsoft_defenders, list):
            raise TypeError("Expected argument 'microsoft_defenders' to be a list")
        pulumi.set(__self__, "microsoft_defenders", microsoft_defenders)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if network_profiles and not isinstance(network_profiles, list):
            raise TypeError("Expected argument 'network_profiles' to be a list")
        pulumi.set(__self__, "network_profiles", network_profiles)
        if node_resource_group and not isinstance(node_resource_group, str):
            raise TypeError("Expected argument 'node_resource_group' to be a str")
        pulumi.set(__self__, "node_resource_group", node_resource_group)
        if node_resource_group_id and not isinstance(node_resource_group_id, str):
            raise TypeError("Expected argument 'node_resource_group_id' to be a str")
        pulumi.set(__self__, "node_resource_group_id", node_resource_group_id)
        if oidc_issuer_enabled and not isinstance(oidc_issuer_enabled, bool):
            raise TypeError("Expected argument 'oidc_issuer_enabled' to be a bool")
        pulumi.set(__self__, "oidc_issuer_enabled", oidc_issuer_enabled)
        if oidc_issuer_url and not isinstance(oidc_issuer_url, str):
            raise TypeError("Expected argument 'oidc_issuer_url' to be a str")
        pulumi.set(__self__, "oidc_issuer_url", oidc_issuer_url)
        if oms_agents and not isinstance(oms_agents, list):
            raise TypeError("Expected argument 'oms_agents' to be a list")
        pulumi.set(__self__, "oms_agents", oms_agents)
        if open_service_mesh_enabled and not isinstance(open_service_mesh_enabled, bool):
            raise TypeError("Expected argument 'open_service_mesh_enabled' to be a bool")
        pulumi.set(__self__, "open_service_mesh_enabled", open_service_mesh_enabled)
        if private_cluster_enabled and not isinstance(private_cluster_enabled, bool):
            raise TypeError("Expected argument 'private_cluster_enabled' to be a bool")
        pulumi.set(__self__, "private_cluster_enabled", private_cluster_enabled)
        if private_fqdn and not isinstance(private_fqdn, str):
            raise TypeError("Expected argument 'private_fqdn' to be a str")
        pulumi.set(__self__, "private_fqdn", private_fqdn)
        if resource_group_name and not isinstance(resource_group_name, str):
            raise TypeError("Expected argument 'resource_group_name' to be a str")
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if role_based_access_control_enabled and not isinstance(role_based_access_control_enabled, bool):
            raise TypeError("Expected argument 'role_based_access_control_enabled' to be a bool")
        pulumi.set(__self__, "role_based_access_control_enabled", role_based_access_control_enabled)
        if service_mesh_profiles and not isinstance(service_mesh_profiles, list):
            raise TypeError("Expected argument 'service_mesh_profiles' to be a list")
        pulumi.set(__self__, "service_mesh_profiles", service_mesh_profiles)
        if service_principals and not isinstance(service_principals, list):
            raise TypeError("Expected argument 'service_principals' to be a list")
        pulumi.set(__self__, "service_principals", service_principals)
        if storage_profiles and not isinstance(storage_profiles, list):
            raise TypeError("Expected argument 'storage_profiles' to be a list")
        pulumi.set(__self__, "storage_profiles", storage_profiles)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if windows_profiles and not isinstance(windows_profiles, list):
            raise TypeError("Expected argument 'windows_profiles' to be a list")
        pulumi.set(__self__, "windows_profiles", windows_profiles)

    @_builtins.property
    @pulumi.getter(name="aciConnectorLinuxes")
    def aci_connector_linuxes(self) -> Sequence['outputs.GetKubernetesClusterAciConnectorLinuxResult']:
        """
        An `aci_connector_linux` block as documented below.
        """
        return pulumi.get(self, "aci_connector_linuxes")

    @_builtins.property
    @pulumi.getter(name="agentPoolProfiles")
    def agent_pool_profiles(self) -> Sequence['outputs.GetKubernetesClusterAgentPoolProfileResult']:
        """
        An `agent_pool_profile` block as documented below.
        """
        return pulumi.get(self, "agent_pool_profiles")

    @_builtins.property
    @pulumi.getter(name="apiServerAuthorizedIpRanges")
    def api_server_authorized_ip_ranges(self) -> Sequence[_builtins.str]:
        """
        The IP ranges to whitelist for incoming traffic to the primaries.
        """
        return pulumi.get(self, "api_server_authorized_ip_ranges")

    @_builtins.property
    @pulumi.getter(name="azureActiveDirectoryRoleBasedAccessControls")
    def azure_active_directory_role_based_access_controls(self) -> Sequence['outputs.GetKubernetesClusterAzureActiveDirectoryRoleBasedAccessControlResult']:
        """
        An `azure_active_directory_role_based_access_control` block as documented below.
        """
        return pulumi.get(self, "azure_active_directory_role_based_access_controls")

    @_builtins.property
    @pulumi.getter(name="azurePolicyEnabled")
    def azure_policy_enabled(self) -> _builtins.bool:
        """
        Is Azure Policy enabled on this managed Kubernetes Cluster?
        """
        return pulumi.get(self, "azure_policy_enabled")

    @_builtins.property
    @pulumi.getter(name="currentKubernetesVersion")
    def current_kubernetes_version(self) -> _builtins.str:
        """
        Contains the current version of Kubernetes running on the Cluster.
        """
        return pulumi.get(self, "current_kubernetes_version")

    @_builtins.property
    @pulumi.getter(name="diskEncryptionSetId")
    def disk_encryption_set_id(self) -> _builtins.str:
        """
        The ID of the Disk Encryption Set used for the Nodes and Volumes.
        """
        return pulumi.get(self, "disk_encryption_set_id")

    @_builtins.property
    @pulumi.getter(name="dnsPrefix")
    def dns_prefix(self) -> _builtins.str:
        """
        The DNS Prefix of the managed Kubernetes cluster.
        """
        return pulumi.get(self, "dns_prefix")

    @_builtins.property
    @pulumi.getter
    def fqdn(self) -> _builtins.str:
        """
        The FQDN of the Azure Kubernetes Managed Cluster.
        """
        return pulumi.get(self, "fqdn")

    @_builtins.property
    @pulumi.getter(name="httpApplicationRoutingEnabled")
    def http_application_routing_enabled(self) -> _builtins.bool:
        """
        Is HTTP Application Routing enabled for this managed Kubernetes Cluster?
        """
        return pulumi.get(self, "http_application_routing_enabled")

    @_builtins.property
    @pulumi.getter(name="httpApplicationRoutingZoneName")
    def http_application_routing_zone_name(self) -> _builtins.str:
        """
        The Zone Name of the HTTP Application Routing.
        """
        return pulumi.get(self, "http_application_routing_zone_name")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def identities(self) -> Sequence['outputs.GetKubernetesClusterIdentityResult']:
        """
        An `identity` block as documented below.
        """
        return pulumi.get(self, "identities")

    @_builtins.property
    @pulumi.getter(name="ingressApplicationGateways")
    def ingress_application_gateways(self) -> Sequence['outputs.GetKubernetesClusterIngressApplicationGatewayResult']:
        """
        An `ingress_application_gateway` block as documented below.
        """
        return pulumi.get(self, "ingress_application_gateways")

    @_builtins.property
    @pulumi.getter(name="keyManagementServices")
    def key_management_services(self) -> Sequence['outputs.GetKubernetesClusterKeyManagementServiceResult']:
        """
        A `key_management_service` block as documented below.
        """
        return pulumi.get(self, "key_management_services")

    @_builtins.property
    @pulumi.getter(name="keyVaultSecretsProviders")
    def key_vault_secrets_providers(self) -> Sequence['outputs.GetKubernetesClusterKeyVaultSecretsProviderResult']:
        """
        A `key_vault_secrets_provider` block as documented below.
        """
        return pulumi.get(self, "key_vault_secrets_providers")

    @_builtins.property
    @pulumi.getter(name="kubeAdminConfigRaw")
    def kube_admin_config_raw(self) -> _builtins.str:
        """
        Raw Kubernetes config for the admin account to be used by [kubectl](https://kubernetes.io/docs/reference/kubectl/overview/) and other compatible tools. This is only available when Role Based Access Control with Azure Active Directory is enabled and local accounts are not disabled.
        """
        return pulumi.get(self, "kube_admin_config_raw")

    @_builtins.property
    @pulumi.getter(name="kubeAdminConfigs")
    def kube_admin_configs(self) -> Sequence['outputs.GetKubernetesClusterKubeAdminConfigResult']:
        """
        A `kube_admin_config` block as defined below. This is only available when Role Based Access Control with Azure Active Directory is enabled and local accounts are not disabled.
        """
        return pulumi.get(self, "kube_admin_configs")

    @_builtins.property
    @pulumi.getter(name="kubeConfigRaw")
    def kube_config_raw(self) -> _builtins.str:
        """
        Base64 encoded Kubernetes configuration.
        """
        return pulumi.get(self, "kube_config_raw")

    @_builtins.property
    @pulumi.getter(name="kubeConfigs")
    def kube_configs(self) -> Sequence['outputs.GetKubernetesClusterKubeConfigResult']:
        """
        A `kube_config` block as defined below.
        """
        return pulumi.get(self, "kube_configs")

    @_builtins.property
    @pulumi.getter(name="kubeletIdentities")
    def kubelet_identities(self) -> Sequence['outputs.GetKubernetesClusterKubeletIdentityResult']:
        """
        A `kubelet_identity` block as documented below.
        """
        return pulumi.get(self, "kubelet_identities")

    @_builtins.property
    @pulumi.getter(name="kubernetesVersion")
    def kubernetes_version(self) -> _builtins.str:
        """
        The version of Kubernetes used on the managed Kubernetes Cluster.
        """
        return pulumi.get(self, "kubernetes_version")

    @_builtins.property
    @pulumi.getter(name="linuxProfiles")
    def linux_profiles(self) -> Sequence['outputs.GetKubernetesClusterLinuxProfileResult']:
        """
        A `linux_profile` block as documented below.
        """
        return pulumi.get(self, "linux_profiles")

    @_builtins.property
    @pulumi.getter
    def location(self) -> _builtins.str:
        """
        The Azure Region in which the managed Kubernetes Cluster exists.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter(name="microsoftDefenders")
    def microsoft_defenders(self) -> Sequence['outputs.GetKubernetesClusterMicrosoftDefenderResult']:
        """
        A `microsoft_defender` block as defined below.
        """
        return pulumi.get(self, "microsoft_defenders")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name assigned to this pool of agents.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="networkProfiles")
    def network_profiles(self) -> Sequence['outputs.GetKubernetesClusterNetworkProfileResult']:
        """
        A `network_profile` block as documented below.
        """
        return pulumi.get(self, "network_profiles")

    @_builtins.property
    @pulumi.getter(name="nodeResourceGroup")
    def node_resource_group(self) -> _builtins.str:
        """
        Auto-generated Resource Group containing AKS Cluster resources.
        """
        return pulumi.get(self, "node_resource_group")

    @_builtins.property
    @pulumi.getter(name="nodeResourceGroupId")
    def node_resource_group_id(self) -> _builtins.str:
        """
        The ID of the Resource Group containing the resources for this Managed Kubernetes Cluster.
        """
        return pulumi.get(self, "node_resource_group_id")

    @_builtins.property
    @pulumi.getter(name="oidcIssuerEnabled")
    def oidc_issuer_enabled(self) -> _builtins.bool:
        """
        Whether or not the OIDC feature is enabled or disabled.
        """
        return pulumi.get(self, "oidc_issuer_enabled")

    @_builtins.property
    @pulumi.getter(name="oidcIssuerUrl")
    def oidc_issuer_url(self) -> _builtins.str:
        """
        The OIDC issuer URL that is associated with the cluster.
        """
        return pulumi.get(self, "oidc_issuer_url")

    @_builtins.property
    @pulumi.getter(name="omsAgents")
    def oms_agents(self) -> Sequence['outputs.GetKubernetesClusterOmsAgentResult']:
        """
        An `oms_agent` block as documented below.
        """
        return pulumi.get(self, "oms_agents")

    @_builtins.property
    @pulumi.getter(name="openServiceMeshEnabled")
    def open_service_mesh_enabled(self) -> _builtins.bool:
        """
        Is Open Service Mesh enabled for this managed Kubernetes Cluster?
        """
        return pulumi.get(self, "open_service_mesh_enabled")

    @_builtins.property
    @pulumi.getter(name="privateClusterEnabled")
    def private_cluster_enabled(self) -> _builtins.bool:
        """
        If the cluster has the Kubernetes API only exposed on internal IP addresses.
        """
        return pulumi.get(self, "private_cluster_enabled")

    @_builtins.property
    @pulumi.getter(name="privateFqdn")
    def private_fqdn(self) -> _builtins.str:
        """
        The FQDN of this Kubernetes Cluster when private link has been enabled. This name is only resolvable inside the Virtual Network where the Azure Kubernetes Service is located
        """
        return pulumi.get(self, "private_fqdn")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> _builtins.str:
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter(name="roleBasedAccessControlEnabled")
    def role_based_access_control_enabled(self) -> _builtins.bool:
        """
        Is Role Based Access Control enabled for this managed Kubernetes Cluster?
        """
        return pulumi.get(self, "role_based_access_control_enabled")

    @_builtins.property
    @pulumi.getter(name="serviceMeshProfiles")
    def service_mesh_profiles(self) -> Sequence['outputs.GetKubernetesClusterServiceMeshProfileResult']:
        return pulumi.get(self, "service_mesh_profiles")

    @_builtins.property
    @pulumi.getter(name="servicePrincipals")
    def service_principals(self) -> Sequence['outputs.GetKubernetesClusterServicePrincipalResult']:
        """
        A `service_principal` block as documented below.
        """
        return pulumi.get(self, "service_principals")

    @_builtins.property
    @pulumi.getter(name="storageProfiles")
    def storage_profiles(self) -> Sequence['outputs.GetKubernetesClusterStorageProfileResult']:
        """
        A `storage_profile` block as documented below.
        """
        return pulumi.get(self, "storage_profiles")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="windowsProfiles")
    def windows_profiles(self) -> Sequence['outputs.GetKubernetesClusterWindowsProfileResult']:
        """
        A `windows_profile` block as documented below.
        """
        return pulumi.get(self, "windows_profiles")


class AwaitableGetKubernetesClusterResult(GetKubernetesClusterResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetKubernetesClusterResult(
            aci_connector_linuxes=self.aci_connector_linuxes,
            agent_pool_profiles=self.agent_pool_profiles,
            api_server_authorized_ip_ranges=self.api_server_authorized_ip_ranges,
            azure_active_directory_role_based_access_controls=self.azure_active_directory_role_based_access_controls,
            azure_policy_enabled=self.azure_policy_enabled,
            current_kubernetes_version=self.current_kubernetes_version,
            disk_encryption_set_id=self.disk_encryption_set_id,
            dns_prefix=self.dns_prefix,
            fqdn=self.fqdn,
            http_application_routing_enabled=self.http_application_routing_enabled,
            http_application_routing_zone_name=self.http_application_routing_zone_name,
            id=self.id,
            identities=self.identities,
            ingress_application_gateways=self.ingress_application_gateways,
            key_management_services=self.key_management_services,
            key_vault_secrets_providers=self.key_vault_secrets_providers,
            kube_admin_config_raw=self.kube_admin_config_raw,
            kube_admin_configs=self.kube_admin_configs,
            kube_config_raw=self.kube_config_raw,
            kube_configs=self.kube_configs,
            kubelet_identities=self.kubelet_identities,
            kubernetes_version=self.kubernetes_version,
            linux_profiles=self.linux_profiles,
            location=self.location,
            microsoft_defenders=self.microsoft_defenders,
            name=self.name,
            network_profiles=self.network_profiles,
            node_resource_group=self.node_resource_group,
            node_resource_group_id=self.node_resource_group_id,
            oidc_issuer_enabled=self.oidc_issuer_enabled,
            oidc_issuer_url=self.oidc_issuer_url,
            oms_agents=self.oms_agents,
            open_service_mesh_enabled=self.open_service_mesh_enabled,
            private_cluster_enabled=self.private_cluster_enabled,
            private_fqdn=self.private_fqdn,
            resource_group_name=self.resource_group_name,
            role_based_access_control_enabled=self.role_based_access_control_enabled,
            service_mesh_profiles=self.service_mesh_profiles,
            service_principals=self.service_principals,
            storage_profiles=self.storage_profiles,
            tags=self.tags,
            windows_profiles=self.windows_profiles)


def get_kubernetes_cluster(name: Optional[_builtins.str] = None,
                           resource_group_name: Optional[_builtins.str] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetKubernetesClusterResult:
    """
    Use this data source to access information about an existing Managed Kubernetes Cluster (AKS).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.containerservice.get_kubernetes_cluster(name="myakscluster",
        resource_group_name="my-example-resource-group")
    ```


    :param _builtins.str name: The name of the managed Kubernetes Cluster.
    :param _builtins.str resource_group_name: The name of the Resource Group in which the managed Kubernetes Cluster exists.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:containerservice/getKubernetesCluster:getKubernetesCluster', __args__, opts=opts, typ=GetKubernetesClusterResult).value

    return AwaitableGetKubernetesClusterResult(
        aci_connector_linuxes=pulumi.get(__ret__, 'aci_connector_linuxes'),
        agent_pool_profiles=pulumi.get(__ret__, 'agent_pool_profiles'),
        api_server_authorized_ip_ranges=pulumi.get(__ret__, 'api_server_authorized_ip_ranges'),
        azure_active_directory_role_based_access_controls=pulumi.get(__ret__, 'azure_active_directory_role_based_access_controls'),
        azure_policy_enabled=pulumi.get(__ret__, 'azure_policy_enabled'),
        current_kubernetes_version=pulumi.get(__ret__, 'current_kubernetes_version'),
        disk_encryption_set_id=pulumi.get(__ret__, 'disk_encryption_set_id'),
        dns_prefix=pulumi.get(__ret__, 'dns_prefix'),
        fqdn=pulumi.get(__ret__, 'fqdn'),
        http_application_routing_enabled=pulumi.get(__ret__, 'http_application_routing_enabled'),
        http_application_routing_zone_name=pulumi.get(__ret__, 'http_application_routing_zone_name'),
        id=pulumi.get(__ret__, 'id'),
        identities=pulumi.get(__ret__, 'identities'),
        ingress_application_gateways=pulumi.get(__ret__, 'ingress_application_gateways'),
        key_management_services=pulumi.get(__ret__, 'key_management_services'),
        key_vault_secrets_providers=pulumi.get(__ret__, 'key_vault_secrets_providers'),
        kube_admin_config_raw=pulumi.get(__ret__, 'kube_admin_config_raw'),
        kube_admin_configs=pulumi.get(__ret__, 'kube_admin_configs'),
        kube_config_raw=pulumi.get(__ret__, 'kube_config_raw'),
        kube_configs=pulumi.get(__ret__, 'kube_configs'),
        kubelet_identities=pulumi.get(__ret__, 'kubelet_identities'),
        kubernetes_version=pulumi.get(__ret__, 'kubernetes_version'),
        linux_profiles=pulumi.get(__ret__, 'linux_profiles'),
        location=pulumi.get(__ret__, 'location'),
        microsoft_defenders=pulumi.get(__ret__, 'microsoft_defenders'),
        name=pulumi.get(__ret__, 'name'),
        network_profiles=pulumi.get(__ret__, 'network_profiles'),
        node_resource_group=pulumi.get(__ret__, 'node_resource_group'),
        node_resource_group_id=pulumi.get(__ret__, 'node_resource_group_id'),
        oidc_issuer_enabled=pulumi.get(__ret__, 'oidc_issuer_enabled'),
        oidc_issuer_url=pulumi.get(__ret__, 'oidc_issuer_url'),
        oms_agents=pulumi.get(__ret__, 'oms_agents'),
        open_service_mesh_enabled=pulumi.get(__ret__, 'open_service_mesh_enabled'),
        private_cluster_enabled=pulumi.get(__ret__, 'private_cluster_enabled'),
        private_fqdn=pulumi.get(__ret__, 'private_fqdn'),
        resource_group_name=pulumi.get(__ret__, 'resource_group_name'),
        role_based_access_control_enabled=pulumi.get(__ret__, 'role_based_access_control_enabled'),
        service_mesh_profiles=pulumi.get(__ret__, 'service_mesh_profiles'),
        service_principals=pulumi.get(__ret__, 'service_principals'),
        storage_profiles=pulumi.get(__ret__, 'storage_profiles'),
        tags=pulumi.get(__ret__, 'tags'),
        windows_profiles=pulumi.get(__ret__, 'windows_profiles'))
def get_kubernetes_cluster_output(name: Optional[pulumi.Input[_builtins.str]] = None,
                                  resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                                  opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetKubernetesClusterResult]:
    """
    Use this data source to access information about an existing Managed Kubernetes Cluster (AKS).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.containerservice.get_kubernetes_cluster(name="myakscluster",
        resource_group_name="my-example-resource-group")
    ```


    :param _builtins.str name: The name of the managed Kubernetes Cluster.
    :param _builtins.str resource_group_name: The name of the Resource Group in which the managed Kubernetes Cluster exists.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:containerservice/getKubernetesCluster:getKubernetesCluster', __args__, opts=opts, typ=GetKubernetesClusterResult)
    return __ret__.apply(lambda __response__: GetKubernetesClusterResult(
        aci_connector_linuxes=pulumi.get(__response__, 'aci_connector_linuxes'),
        agent_pool_profiles=pulumi.get(__response__, 'agent_pool_profiles'),
        api_server_authorized_ip_ranges=pulumi.get(__response__, 'api_server_authorized_ip_ranges'),
        azure_active_directory_role_based_access_controls=pulumi.get(__response__, 'azure_active_directory_role_based_access_controls'),
        azure_policy_enabled=pulumi.get(__response__, 'azure_policy_enabled'),
        current_kubernetes_version=pulumi.get(__response__, 'current_kubernetes_version'),
        disk_encryption_set_id=pulumi.get(__response__, 'disk_encryption_set_id'),
        dns_prefix=pulumi.get(__response__, 'dns_prefix'),
        fqdn=pulumi.get(__response__, 'fqdn'),
        http_application_routing_enabled=pulumi.get(__response__, 'http_application_routing_enabled'),
        http_application_routing_zone_name=pulumi.get(__response__, 'http_application_routing_zone_name'),
        id=pulumi.get(__response__, 'id'),
        identities=pulumi.get(__response__, 'identities'),
        ingress_application_gateways=pulumi.get(__response__, 'ingress_application_gateways'),
        key_management_services=pulumi.get(__response__, 'key_management_services'),
        key_vault_secrets_providers=pulumi.get(__response__, 'key_vault_secrets_providers'),
        kube_admin_config_raw=pulumi.get(__response__, 'kube_admin_config_raw'),
        kube_admin_configs=pulumi.get(__response__, 'kube_admin_configs'),
        kube_config_raw=pulumi.get(__response__, 'kube_config_raw'),
        kube_configs=pulumi.get(__response__, 'kube_configs'),
        kubelet_identities=pulumi.get(__response__, 'kubelet_identities'),
        kubernetes_version=pulumi.get(__response__, 'kubernetes_version'),
        linux_profiles=pulumi.get(__response__, 'linux_profiles'),
        location=pulumi.get(__response__, 'location'),
        microsoft_defenders=pulumi.get(__response__, 'microsoft_defenders'),
        name=pulumi.get(__response__, 'name'),
        network_profiles=pulumi.get(__response__, 'network_profiles'),
        node_resource_group=pulumi.get(__response__, 'node_resource_group'),
        node_resource_group_id=pulumi.get(__response__, 'node_resource_group_id'),
        oidc_issuer_enabled=pulumi.get(__response__, 'oidc_issuer_enabled'),
        oidc_issuer_url=pulumi.get(__response__, 'oidc_issuer_url'),
        oms_agents=pulumi.get(__response__, 'oms_agents'),
        open_service_mesh_enabled=pulumi.get(__response__, 'open_service_mesh_enabled'),
        private_cluster_enabled=pulumi.get(__response__, 'private_cluster_enabled'),
        private_fqdn=pulumi.get(__response__, 'private_fqdn'),
        resource_group_name=pulumi.get(__response__, 'resource_group_name'),
        role_based_access_control_enabled=pulumi.get(__response__, 'role_based_access_control_enabled'),
        service_mesh_profiles=pulumi.get(__response__, 'service_mesh_profiles'),
        service_principals=pulumi.get(__response__, 'service_principals'),
        storage_profiles=pulumi.get(__response__, 'storage_profiles'),
        tags=pulumi.get(__response__, 'tags'),
        windows_profiles=pulumi.get(__response__, 'windows_profiles')))
