# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['TokenPasswordArgs', 'TokenPassword']

@pulumi.input_type
class TokenPasswordArgs:
    def __init__(__self__, *,
                 container_registry_token_id: pulumi.Input[_builtins.str],
                 password1: pulumi.Input['TokenPasswordPassword1Args'],
                 password2: Optional[pulumi.Input['TokenPasswordPassword2Args']] = None):
        """
        The set of arguments for constructing a TokenPassword resource.
        :param pulumi.Input[_builtins.str] container_registry_token_id: The ID of the Container Registry Token that this Container Registry Token Password resides in. Changing this forces a new Container Registry Token Password to be created.
        :param pulumi.Input['TokenPasswordPassword1Args'] password1: One `password` block as defined below.
        :param pulumi.Input['TokenPasswordPassword2Args'] password2: One `password` block as defined below.
        """
        pulumi.set(__self__, "container_registry_token_id", container_registry_token_id)
        pulumi.set(__self__, "password1", password1)
        if password2 is not None:
            pulumi.set(__self__, "password2", password2)

    @_builtins.property
    @pulumi.getter(name="containerRegistryTokenId")
    def container_registry_token_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Container Registry Token that this Container Registry Token Password resides in. Changing this forces a new Container Registry Token Password to be created.
        """
        return pulumi.get(self, "container_registry_token_id")

    @container_registry_token_id.setter
    def container_registry_token_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "container_registry_token_id", value)

    @_builtins.property
    @pulumi.getter
    def password1(self) -> pulumi.Input['TokenPasswordPassword1Args']:
        """
        One `password` block as defined below.
        """
        return pulumi.get(self, "password1")

    @password1.setter
    def password1(self, value: pulumi.Input['TokenPasswordPassword1Args']):
        pulumi.set(self, "password1", value)

    @_builtins.property
    @pulumi.getter
    def password2(self) -> Optional[pulumi.Input['TokenPasswordPassword2Args']]:
        """
        One `password` block as defined below.
        """
        return pulumi.get(self, "password2")

    @password2.setter
    def password2(self, value: Optional[pulumi.Input['TokenPasswordPassword2Args']]):
        pulumi.set(self, "password2", value)


@pulumi.input_type
class _TokenPasswordState:
    def __init__(__self__, *,
                 container_registry_token_id: Optional[pulumi.Input[_builtins.str]] = None,
                 password1: Optional[pulumi.Input['TokenPasswordPassword1Args']] = None,
                 password2: Optional[pulumi.Input['TokenPasswordPassword2Args']] = None):
        """
        Input properties used for looking up and filtering TokenPassword resources.
        :param pulumi.Input[_builtins.str] container_registry_token_id: The ID of the Container Registry Token that this Container Registry Token Password resides in. Changing this forces a new Container Registry Token Password to be created.
        :param pulumi.Input['TokenPasswordPassword1Args'] password1: One `password` block as defined below.
        :param pulumi.Input['TokenPasswordPassword2Args'] password2: One `password` block as defined below.
        """
        if container_registry_token_id is not None:
            pulumi.set(__self__, "container_registry_token_id", container_registry_token_id)
        if password1 is not None:
            pulumi.set(__self__, "password1", password1)
        if password2 is not None:
            pulumi.set(__self__, "password2", password2)

    @_builtins.property
    @pulumi.getter(name="containerRegistryTokenId")
    def container_registry_token_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Container Registry Token that this Container Registry Token Password resides in. Changing this forces a new Container Registry Token Password to be created.
        """
        return pulumi.get(self, "container_registry_token_id")

    @container_registry_token_id.setter
    def container_registry_token_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "container_registry_token_id", value)

    @_builtins.property
    @pulumi.getter
    def password1(self) -> Optional[pulumi.Input['TokenPasswordPassword1Args']]:
        """
        One `password` block as defined below.
        """
        return pulumi.get(self, "password1")

    @password1.setter
    def password1(self, value: Optional[pulumi.Input['TokenPasswordPassword1Args']]):
        pulumi.set(self, "password1", value)

    @_builtins.property
    @pulumi.getter
    def password2(self) -> Optional[pulumi.Input['TokenPasswordPassword2Args']]:
        """
        One `password` block as defined below.
        """
        return pulumi.get(self, "password2")

    @password2.setter
    def password2(self, value: Optional[pulumi.Input['TokenPasswordPassword2Args']]):
        pulumi.set(self, "password2", value)


@pulumi.type_token("azure:containerservice/tokenPassword:TokenPassword")
class TokenPassword(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 container_registry_token_id: Optional[pulumi.Input[_builtins.str]] = None,
                 password1: Optional[pulumi.Input[Union['TokenPasswordPassword1Args', 'TokenPasswordPassword1ArgsDict']]] = None,
                 password2: Optional[pulumi.Input[Union['TokenPasswordPassword2Args', 'TokenPasswordPassword2ArgsDict']]] = None,
                 __props__=None):
        """
        Manages a Container Registry Token Password associated with a scope map.  For more information on scope maps and their tokens see the [product documentation](https://learn.microsoft.com/en-us/azure/container-registry/container-registry-repository-scoped-permissions).

        ## Import

        Container Registry Token Passwords can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:containerservice/tokenPassword:TokenPassword example /subscriptions/12345678-1234-9876-4563-123456789012/resourceGroups/group1/providers/Microsoft.ContainerRegistry/registries/registry1/tokens/token1/passwords/password
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] container_registry_token_id: The ID of the Container Registry Token that this Container Registry Token Password resides in. Changing this forces a new Container Registry Token Password to be created.
        :param pulumi.Input[Union['TokenPasswordPassword1Args', 'TokenPasswordPassword1ArgsDict']] password1: One `password` block as defined below.
        :param pulumi.Input[Union['TokenPasswordPassword2Args', 'TokenPasswordPassword2ArgsDict']] password2: One `password` block as defined below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TokenPasswordArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Container Registry Token Password associated with a scope map.  For more information on scope maps and their tokens see the [product documentation](https://learn.microsoft.com/en-us/azure/container-registry/container-registry-repository-scoped-permissions).

        ## Import

        Container Registry Token Passwords can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:containerservice/tokenPassword:TokenPassword example /subscriptions/12345678-1234-9876-4563-123456789012/resourceGroups/group1/providers/Microsoft.ContainerRegistry/registries/registry1/tokens/token1/passwords/password
        ```

        :param str resource_name: The name of the resource.
        :param TokenPasswordArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TokenPasswordArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 container_registry_token_id: Optional[pulumi.Input[_builtins.str]] = None,
                 password1: Optional[pulumi.Input[Union['TokenPasswordPassword1Args', 'TokenPasswordPassword1ArgsDict']]] = None,
                 password2: Optional[pulumi.Input[Union['TokenPasswordPassword2Args', 'TokenPasswordPassword2ArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TokenPasswordArgs.__new__(TokenPasswordArgs)

            if container_registry_token_id is None and not opts.urn:
                raise TypeError("Missing required property 'container_registry_token_id'")
            __props__.__dict__["container_registry_token_id"] = container_registry_token_id
            if password1 is None and not opts.urn:
                raise TypeError("Missing required property 'password1'")
            __props__.__dict__["password1"] = password1
            __props__.__dict__["password2"] = password2
        super(TokenPassword, __self__).__init__(
            'azure:containerservice/tokenPassword:TokenPassword',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            container_registry_token_id: Optional[pulumi.Input[_builtins.str]] = None,
            password1: Optional[pulumi.Input[Union['TokenPasswordPassword1Args', 'TokenPasswordPassword1ArgsDict']]] = None,
            password2: Optional[pulumi.Input[Union['TokenPasswordPassword2Args', 'TokenPasswordPassword2ArgsDict']]] = None) -> 'TokenPassword':
        """
        Get an existing TokenPassword resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] container_registry_token_id: The ID of the Container Registry Token that this Container Registry Token Password resides in. Changing this forces a new Container Registry Token Password to be created.
        :param pulumi.Input[Union['TokenPasswordPassword1Args', 'TokenPasswordPassword1ArgsDict']] password1: One `password` block as defined below.
        :param pulumi.Input[Union['TokenPasswordPassword2Args', 'TokenPasswordPassword2ArgsDict']] password2: One `password` block as defined below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TokenPasswordState.__new__(_TokenPasswordState)

        __props__.__dict__["container_registry_token_id"] = container_registry_token_id
        __props__.__dict__["password1"] = password1
        __props__.__dict__["password2"] = password2
        return TokenPassword(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="containerRegistryTokenId")
    def container_registry_token_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Container Registry Token that this Container Registry Token Password resides in. Changing this forces a new Container Registry Token Password to be created.
        """
        return pulumi.get(self, "container_registry_token_id")

    @_builtins.property
    @pulumi.getter
    def password1(self) -> pulumi.Output['outputs.TokenPasswordPassword1']:
        """
        One `password` block as defined below.
        """
        return pulumi.get(self, "password1")

    @_builtins.property
    @pulumi.getter
    def password2(self) -> pulumi.Output[Optional['outputs.TokenPasswordPassword2']]:
        """
        One `password` block as defined below.
        """
        return pulumi.get(self, "password2")

