# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CustomProviderArgs', 'CustomProvider']

@pulumi.input_type
class CustomProviderArgs:
    def __init__(__self__, *,
                 resource_group_name: pulumi.Input[_builtins.str],
                 actions: Optional[pulumi.Input[Sequence[pulumi.Input['CustomProviderActionArgs']]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_types: Optional[pulumi.Input[Sequence[pulumi.Input['CustomProviderResourceTypeArgs']]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 validations: Optional[pulumi.Input[Sequence[pulumi.Input['CustomProviderValidationArgs']]]] = None):
        """
        The set of arguments for constructing a CustomProvider resource.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which to create the Custom Provider. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input['CustomProviderActionArgs']]] actions: Any number of `action` block as defined below. One of `resource_type` or `action` must be specified.
        :param pulumi.Input[_builtins.str] location: Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Custom Provider. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input['CustomProviderResourceTypeArgs']]] resource_types: Any number of `resource_type` block as defined below. One of `resource_type` or `action` must be specified.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input['CustomProviderValidationArgs']]] validations: Any number of `validation` block as defined below.
        """
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if actions is not None:
            pulumi.set(__self__, "actions", actions)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if resource_types is not None:
            pulumi.set(__self__, "resource_types", resource_types)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if validations is not None:
            pulumi.set(__self__, "validations", validations)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the resource group in which to create the Custom Provider. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter
    def actions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CustomProviderActionArgs']]]]:
        """
        Any number of `action` block as defined below. One of `resource_type` or `action` must be specified.
        """
        return pulumi.get(self, "actions")

    @actions.setter
    def actions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CustomProviderActionArgs']]]]):
        pulumi.set(self, "actions", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the Custom Provider. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="resourceTypes")
    def resource_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CustomProviderResourceTypeArgs']]]]:
        """
        Any number of `resource_type` block as defined below. One of `resource_type` or `action` must be specified.
        """
        return pulumi.get(self, "resource_types")

    @resource_types.setter
    def resource_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CustomProviderResourceTypeArgs']]]]):
        pulumi.set(self, "resource_types", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def validations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CustomProviderValidationArgs']]]]:
        """
        Any number of `validation` block as defined below.
        """
        return pulumi.get(self, "validations")

    @validations.setter
    def validations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CustomProviderValidationArgs']]]]):
        pulumi.set(self, "validations", value)


@pulumi.input_type
class _CustomProviderState:
    def __init__(__self__, *,
                 actions: Optional[pulumi.Input[Sequence[pulumi.Input['CustomProviderActionArgs']]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_types: Optional[pulumi.Input[Sequence[pulumi.Input['CustomProviderResourceTypeArgs']]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 validations: Optional[pulumi.Input[Sequence[pulumi.Input['CustomProviderValidationArgs']]]] = None):
        """
        Input properties used for looking up and filtering CustomProvider resources.
        :param pulumi.Input[Sequence[pulumi.Input['CustomProviderActionArgs']]] actions: Any number of `action` block as defined below. One of `resource_type` or `action` must be specified.
        :param pulumi.Input[_builtins.str] location: Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Custom Provider. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which to create the Custom Provider. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input['CustomProviderResourceTypeArgs']]] resource_types: Any number of `resource_type` block as defined below. One of `resource_type` or `action` must be specified.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input['CustomProviderValidationArgs']]] validations: Any number of `validation` block as defined below.
        """
        if actions is not None:
            pulumi.set(__self__, "actions", actions)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if resource_types is not None:
            pulumi.set(__self__, "resource_types", resource_types)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if validations is not None:
            pulumi.set(__self__, "validations", validations)

    @_builtins.property
    @pulumi.getter
    def actions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CustomProviderActionArgs']]]]:
        """
        Any number of `action` block as defined below. One of `resource_type` or `action` must be specified.
        """
        return pulumi.get(self, "actions")

    @actions.setter
    def actions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CustomProviderActionArgs']]]]):
        pulumi.set(self, "actions", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the Custom Provider. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the resource group in which to create the Custom Provider. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="resourceTypes")
    def resource_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CustomProviderResourceTypeArgs']]]]:
        """
        Any number of `resource_type` block as defined below. One of `resource_type` or `action` must be specified.
        """
        return pulumi.get(self, "resource_types")

    @resource_types.setter
    def resource_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CustomProviderResourceTypeArgs']]]]):
        pulumi.set(self, "resource_types", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def validations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CustomProviderValidationArgs']]]]:
        """
        Any number of `validation` block as defined below.
        """
        return pulumi.get(self, "validations")

    @validations.setter
    def validations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CustomProviderValidationArgs']]]]):
        pulumi.set(self, "validations", value)


@pulumi.type_token("azure:core/customProvider:CustomProvider")
class CustomProvider(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 actions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CustomProviderActionArgs', 'CustomProviderActionArgsDict']]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_types: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CustomProviderResourceTypeArgs', 'CustomProviderResourceTypeArgsDict']]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 validations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CustomProviderValidationArgs', 'CustomProviderValidationArgsDict']]]]] = None,
                 __props__=None):
        """
        Manages an Azure Custom Provider.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_custom_provider = azure.core.CustomProvider("example",
            name="example_provider",
            location=example.location,
            resource_group_name=example.name,
            resource_types=[{
                "name": "dEf1",
                "endpoint": "https://testendpoint.com/",
            }])
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.CustomProviders`: 2018-09-01-preview

        ## Import

        Custom Provider can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:core/customProvider:CustomProvider example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/example/providers/Microsoft.CustomProviders/resourceProviders/example
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CustomProviderActionArgs', 'CustomProviderActionArgsDict']]]] actions: Any number of `action` block as defined below. One of `resource_type` or `action` must be specified.
        :param pulumi.Input[_builtins.str] location: Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Custom Provider. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which to create the Custom Provider. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CustomProviderResourceTypeArgs', 'CustomProviderResourceTypeArgsDict']]]] resource_types: Any number of `resource_type` block as defined below. One of `resource_type` or `action` must be specified.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CustomProviderValidationArgs', 'CustomProviderValidationArgsDict']]]] validations: Any number of `validation` block as defined below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CustomProviderArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an Azure Custom Provider.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_custom_provider = azure.core.CustomProvider("example",
            name="example_provider",
            location=example.location,
            resource_group_name=example.name,
            resource_types=[{
                "name": "dEf1",
                "endpoint": "https://testendpoint.com/",
            }])
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.CustomProviders`: 2018-09-01-preview

        ## Import

        Custom Provider can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:core/customProvider:CustomProvider example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/example/providers/Microsoft.CustomProviders/resourceProviders/example
        ```

        :param str resource_name: The name of the resource.
        :param CustomProviderArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CustomProviderArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 actions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CustomProviderActionArgs', 'CustomProviderActionArgsDict']]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_types: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CustomProviderResourceTypeArgs', 'CustomProviderResourceTypeArgsDict']]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 validations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CustomProviderValidationArgs', 'CustomProviderValidationArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CustomProviderArgs.__new__(CustomProviderArgs)

            __props__.__dict__["actions"] = actions
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["resource_types"] = resource_types
            __props__.__dict__["tags"] = tags
            __props__.__dict__["validations"] = validations
        super(CustomProvider, __self__).__init__(
            'azure:core/customProvider:CustomProvider',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            actions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CustomProviderActionArgs', 'CustomProviderActionArgsDict']]]]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            resource_types: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CustomProviderResourceTypeArgs', 'CustomProviderResourceTypeArgsDict']]]]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            validations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CustomProviderValidationArgs', 'CustomProviderValidationArgsDict']]]]] = None) -> 'CustomProvider':
        """
        Get an existing CustomProvider resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CustomProviderActionArgs', 'CustomProviderActionArgsDict']]]] actions: Any number of `action` block as defined below. One of `resource_type` or `action` must be specified.
        :param pulumi.Input[_builtins.str] location: Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Custom Provider. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which to create the Custom Provider. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CustomProviderResourceTypeArgs', 'CustomProviderResourceTypeArgsDict']]]] resource_types: Any number of `resource_type` block as defined below. One of `resource_type` or `action` must be specified.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CustomProviderValidationArgs', 'CustomProviderValidationArgsDict']]]] validations: Any number of `validation` block as defined below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CustomProviderState.__new__(_CustomProviderState)

        __props__.__dict__["actions"] = actions
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["resource_types"] = resource_types
        __props__.__dict__["tags"] = tags
        __props__.__dict__["validations"] = validations
        return CustomProvider(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def actions(self) -> pulumi.Output[Optional[Sequence['outputs.CustomProviderAction']]]:
        """
        Any number of `action` block as defined below. One of `resource_type` or `action` must be specified.
        """
        return pulumi.get(self, "actions")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of the Custom Provider. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the resource group in which to create the Custom Provider. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter(name="resourceTypes")
    def resource_types(self) -> pulumi.Output[Optional[Sequence['outputs.CustomProviderResourceType']]]:
        """
        Any number of `resource_type` block as defined below. One of `resource_type` or `action` must be specified.
        """
        return pulumi.get(self, "resource_types")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags to assign to the resource. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def validations(self) -> pulumi.Output[Optional[Sequence['outputs.CustomProviderValidation']]]:
        """
        Any number of `validation` block as defined below.
        """
        return pulumi.get(self, "validations")

