# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetAccountResult',
    'AwaitableGetAccountResult',
    'get_account',
    'get_account_output',
]

@pulumi.output_type
class GetAccountResult:
    """
    A collection of values returned by getAccount.
    """
    def __init__(__self__, automatic_failover_enabled=None, capabilities=None, consistency_policies=None, endpoint=None, free_tier_enabled=None, geo_locations=None, id=None, ip_range_filter=None, is_virtual_network_filter_enabled=None, key_vault_key_id=None, kind=None, location=None, multiple_write_locations_enabled=None, name=None, offer_type=None, primary_key=None, primary_mongodb_connection_string=None, primary_readonly_key=None, primary_readonly_mongodb_connection_string=None, primary_readonly_sql_connection_string=None, primary_sql_connection_string=None, read_endpoints=None, resource_group_name=None, secondary_key=None, secondary_mongodb_connection_string=None, secondary_readonly_key=None, secondary_readonly_mongodb_connection_string=None, secondary_readonly_sql_connection_string=None, secondary_sql_connection_string=None, tags=None, virtual_network_rules=None, write_endpoints=None):
        if automatic_failover_enabled and not isinstance(automatic_failover_enabled, bool):
            raise TypeError("Expected argument 'automatic_failover_enabled' to be a bool")
        pulumi.set(__self__, "automatic_failover_enabled", automatic_failover_enabled)
        if capabilities and not isinstance(capabilities, list):
            raise TypeError("Expected argument 'capabilities' to be a list")
        pulumi.set(__self__, "capabilities", capabilities)
        if consistency_policies and not isinstance(consistency_policies, list):
            raise TypeError("Expected argument 'consistency_policies' to be a list")
        pulumi.set(__self__, "consistency_policies", consistency_policies)
        if endpoint and not isinstance(endpoint, str):
            raise TypeError("Expected argument 'endpoint' to be a str")
        pulumi.set(__self__, "endpoint", endpoint)
        if free_tier_enabled and not isinstance(free_tier_enabled, bool):
            raise TypeError("Expected argument 'free_tier_enabled' to be a bool")
        pulumi.set(__self__, "free_tier_enabled", free_tier_enabled)
        if geo_locations and not isinstance(geo_locations, list):
            raise TypeError("Expected argument 'geo_locations' to be a list")
        pulumi.set(__self__, "geo_locations", geo_locations)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ip_range_filter and not isinstance(ip_range_filter, str):
            raise TypeError("Expected argument 'ip_range_filter' to be a str")
        pulumi.set(__self__, "ip_range_filter", ip_range_filter)
        if is_virtual_network_filter_enabled and not isinstance(is_virtual_network_filter_enabled, bool):
            raise TypeError("Expected argument 'is_virtual_network_filter_enabled' to be a bool")
        pulumi.set(__self__, "is_virtual_network_filter_enabled", is_virtual_network_filter_enabled)
        if key_vault_key_id and not isinstance(key_vault_key_id, str):
            raise TypeError("Expected argument 'key_vault_key_id' to be a str")
        pulumi.set(__self__, "key_vault_key_id", key_vault_key_id)
        if kind and not isinstance(kind, str):
            raise TypeError("Expected argument 'kind' to be a str")
        pulumi.set(__self__, "kind", kind)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if multiple_write_locations_enabled and not isinstance(multiple_write_locations_enabled, bool):
            raise TypeError("Expected argument 'multiple_write_locations_enabled' to be a bool")
        pulumi.set(__self__, "multiple_write_locations_enabled", multiple_write_locations_enabled)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if offer_type and not isinstance(offer_type, str):
            raise TypeError("Expected argument 'offer_type' to be a str")
        pulumi.set(__self__, "offer_type", offer_type)
        if primary_key and not isinstance(primary_key, str):
            raise TypeError("Expected argument 'primary_key' to be a str")
        pulumi.set(__self__, "primary_key", primary_key)
        if primary_mongodb_connection_string and not isinstance(primary_mongodb_connection_string, str):
            raise TypeError("Expected argument 'primary_mongodb_connection_string' to be a str")
        pulumi.set(__self__, "primary_mongodb_connection_string", primary_mongodb_connection_string)
        if primary_readonly_key and not isinstance(primary_readonly_key, str):
            raise TypeError("Expected argument 'primary_readonly_key' to be a str")
        pulumi.set(__self__, "primary_readonly_key", primary_readonly_key)
        if primary_readonly_mongodb_connection_string and not isinstance(primary_readonly_mongodb_connection_string, str):
            raise TypeError("Expected argument 'primary_readonly_mongodb_connection_string' to be a str")
        pulumi.set(__self__, "primary_readonly_mongodb_connection_string", primary_readonly_mongodb_connection_string)
        if primary_readonly_sql_connection_string and not isinstance(primary_readonly_sql_connection_string, str):
            raise TypeError("Expected argument 'primary_readonly_sql_connection_string' to be a str")
        pulumi.set(__self__, "primary_readonly_sql_connection_string", primary_readonly_sql_connection_string)
        if primary_sql_connection_string and not isinstance(primary_sql_connection_string, str):
            raise TypeError("Expected argument 'primary_sql_connection_string' to be a str")
        pulumi.set(__self__, "primary_sql_connection_string", primary_sql_connection_string)
        if read_endpoints and not isinstance(read_endpoints, list):
            raise TypeError("Expected argument 'read_endpoints' to be a list")
        pulumi.set(__self__, "read_endpoints", read_endpoints)
        if resource_group_name and not isinstance(resource_group_name, str):
            raise TypeError("Expected argument 'resource_group_name' to be a str")
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if secondary_key and not isinstance(secondary_key, str):
            raise TypeError("Expected argument 'secondary_key' to be a str")
        pulumi.set(__self__, "secondary_key", secondary_key)
        if secondary_mongodb_connection_string and not isinstance(secondary_mongodb_connection_string, str):
            raise TypeError("Expected argument 'secondary_mongodb_connection_string' to be a str")
        pulumi.set(__self__, "secondary_mongodb_connection_string", secondary_mongodb_connection_string)
        if secondary_readonly_key and not isinstance(secondary_readonly_key, str):
            raise TypeError("Expected argument 'secondary_readonly_key' to be a str")
        pulumi.set(__self__, "secondary_readonly_key", secondary_readonly_key)
        if secondary_readonly_mongodb_connection_string and not isinstance(secondary_readonly_mongodb_connection_string, str):
            raise TypeError("Expected argument 'secondary_readonly_mongodb_connection_string' to be a str")
        pulumi.set(__self__, "secondary_readonly_mongodb_connection_string", secondary_readonly_mongodb_connection_string)
        if secondary_readonly_sql_connection_string and not isinstance(secondary_readonly_sql_connection_string, str):
            raise TypeError("Expected argument 'secondary_readonly_sql_connection_string' to be a str")
        pulumi.set(__self__, "secondary_readonly_sql_connection_string", secondary_readonly_sql_connection_string)
        if secondary_sql_connection_string and not isinstance(secondary_sql_connection_string, str):
            raise TypeError("Expected argument 'secondary_sql_connection_string' to be a str")
        pulumi.set(__self__, "secondary_sql_connection_string", secondary_sql_connection_string)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if virtual_network_rules and not isinstance(virtual_network_rules, list):
            raise TypeError("Expected argument 'virtual_network_rules' to be a list")
        pulumi.set(__self__, "virtual_network_rules", virtual_network_rules)
        if write_endpoints and not isinstance(write_endpoints, list):
            raise TypeError("Expected argument 'write_endpoints' to be a list")
        pulumi.set(__self__, "write_endpoints", write_endpoints)

    @_builtins.property
    @pulumi.getter(name="automaticFailoverEnabled")
    def automatic_failover_enabled(self) -> _builtins.bool:
        """
        If automatic failover is enabled for this CosmosDB Account.
        """
        return pulumi.get(self, "automatic_failover_enabled")

    @_builtins.property
    @pulumi.getter
    def capabilities(self) -> Sequence['outputs.GetAccountCapabilityResult']:
        """
        Capabilities enabled on this Cosmos DB account.
        """
        return pulumi.get(self, "capabilities")

    @_builtins.property
    @pulumi.getter(name="consistencyPolicies")
    def consistency_policies(self) -> Sequence['outputs.GetAccountConsistencyPolicyResult']:
        return pulumi.get(self, "consistency_policies")

    @_builtins.property
    @pulumi.getter
    def endpoint(self) -> _builtins.str:
        """
        The endpoint used to connect to the CosmosDB account.
        """
        return pulumi.get(self, "endpoint")

    @_builtins.property
    @pulumi.getter(name="freeTierEnabled")
    def free_tier_enabled(self) -> _builtins.bool:
        """
        If Free Tier pricing option is enabled for this CosmosDB Account. You can have up to one free tier Azure Cosmos DB account per Azure subscription.
        """
        return pulumi.get(self, "free_tier_enabled")

    @_builtins.property
    @pulumi.getter(name="geoLocations")
    def geo_locations(self) -> Sequence['outputs.GetAccountGeoLocationResult']:
        return pulumi.get(self, "geo_locations")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="ipRangeFilter")
    def ip_range_filter(self) -> _builtins.str:
        """
        The current IP Filter for this CosmosDB account
        """
        return pulumi.get(self, "ip_range_filter")

    @_builtins.property
    @pulumi.getter(name="isVirtualNetworkFilterEnabled")
    def is_virtual_network_filter_enabled(self) -> _builtins.bool:
        """
        If virtual network filtering is enabled for this Cosmos DB account.
        """
        return pulumi.get(self, "is_virtual_network_filter_enabled")

    @_builtins.property
    @pulumi.getter(name="keyVaultKeyId")
    def key_vault_key_id(self) -> _builtins.str:
        """
        The Key Vault key URI for CMK encryption.
        """
        return pulumi.get(self, "key_vault_key_id")

    @_builtins.property
    @pulumi.getter
    def kind(self) -> _builtins.str:
        """
        The Kind of the CosmosDB account.
        """
        return pulumi.get(self, "kind")

    @_builtins.property
    @pulumi.getter
    def location(self) -> _builtins.str:
        """
        The name of the Azure region hosting replicated data.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter(name="multipleWriteLocationsEnabled")
    def multiple_write_locations_enabled(self) -> _builtins.bool:
        """
        If multiple write locations are enabled for this Cosmos DB account.
        """
        return pulumi.get(self, "multiple_write_locations_enabled")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="offerType")
    def offer_type(self) -> _builtins.str:
        """
        The Offer Type to used by this CosmosDB Account.
        """
        return pulumi.get(self, "offer_type")

    @_builtins.property
    @pulumi.getter(name="primaryKey")
    def primary_key(self) -> _builtins.str:
        """
        The primary key for the CosmosDB account.
        """
        return pulumi.get(self, "primary_key")

    @_builtins.property
    @pulumi.getter(name="primaryMongodbConnectionString")
    def primary_mongodb_connection_string(self) -> _builtins.str:
        """
        The primary Mongodb connection string for the CosmosDB account.
        """
        return pulumi.get(self, "primary_mongodb_connection_string")

    @_builtins.property
    @pulumi.getter(name="primaryReadonlyKey")
    def primary_readonly_key(self) -> _builtins.str:
        """
        The primary read-only Key for the CosmosDB account.
        """
        return pulumi.get(self, "primary_readonly_key")

    @_builtins.property
    @pulumi.getter(name="primaryReadonlyMongodbConnectionString")
    def primary_readonly_mongodb_connection_string(self) -> _builtins.str:
        """
        The primary readonly Mongodb connection string for the CosmosDB account.
        """
        return pulumi.get(self, "primary_readonly_mongodb_connection_string")

    @_builtins.property
    @pulumi.getter(name="primaryReadonlySqlConnectionString")
    def primary_readonly_sql_connection_string(self) -> _builtins.str:
        """
        The primary read-only SQL connection string for the CosmosDB account.
        """
        return pulumi.get(self, "primary_readonly_sql_connection_string")

    @_builtins.property
    @pulumi.getter(name="primarySqlConnectionString")
    def primary_sql_connection_string(self) -> _builtins.str:
        """
        The primary SQL connection string for the CosmosDB Account.
        """
        return pulumi.get(self, "primary_sql_connection_string")

    @_builtins.property
    @pulumi.getter(name="readEndpoints")
    def read_endpoints(self) -> Sequence[_builtins.str]:
        """
        A list of read endpoints available for this CosmosDB account.
        """
        return pulumi.get(self, "read_endpoints")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> _builtins.str:
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter(name="secondaryKey")
    def secondary_key(self) -> _builtins.str:
        """
        The secondary key for the CosmosDB account.
        """
        return pulumi.get(self, "secondary_key")

    @_builtins.property
    @pulumi.getter(name="secondaryMongodbConnectionString")
    def secondary_mongodb_connection_string(self) -> _builtins.str:
        """
        The secondary Mongodb connection string for the CosmosDB account.
        """
        return pulumi.get(self, "secondary_mongodb_connection_string")

    @_builtins.property
    @pulumi.getter(name="secondaryReadonlyKey")
    def secondary_readonly_key(self) -> _builtins.str:
        """
        The secondary read-only key for the CosmosDB account.
        """
        return pulumi.get(self, "secondary_readonly_key")

    @_builtins.property
    @pulumi.getter(name="secondaryReadonlyMongodbConnectionString")
    def secondary_readonly_mongodb_connection_string(self) -> _builtins.str:
        """
        The secondary readonly Mongodb connection string for the CosmosDB account.
        """
        return pulumi.get(self, "secondary_readonly_mongodb_connection_string")

    @_builtins.property
    @pulumi.getter(name="secondaryReadonlySqlConnectionString")
    def secondary_readonly_sql_connection_string(self) -> _builtins.str:
        """
        The secondary read-only SQL connection string for the CosmosDB account.
        """
        return pulumi.get(self, "secondary_readonly_sql_connection_string")

    @_builtins.property
    @pulumi.getter(name="secondarySqlConnectionString")
    def secondary_sql_connection_string(self) -> _builtins.str:
        """
        The secondary SQL connection string for the CosmosDB Account.
        """
        return pulumi.get(self, "secondary_sql_connection_string")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        A mapping of tags assigned to the resource.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="virtualNetworkRules")
    def virtual_network_rules(self) -> Sequence['outputs.GetAccountVirtualNetworkRuleResult']:
        """
        Subnets that are allowed to access this CosmosDB account.
        """
        return pulumi.get(self, "virtual_network_rules")

    @_builtins.property
    @pulumi.getter(name="writeEndpoints")
    def write_endpoints(self) -> Sequence[_builtins.str]:
        """
        A list of write endpoints available for this CosmosDB account.
        """
        return pulumi.get(self, "write_endpoints")


class AwaitableGetAccountResult(GetAccountResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAccountResult(
            automatic_failover_enabled=self.automatic_failover_enabled,
            capabilities=self.capabilities,
            consistency_policies=self.consistency_policies,
            endpoint=self.endpoint,
            free_tier_enabled=self.free_tier_enabled,
            geo_locations=self.geo_locations,
            id=self.id,
            ip_range_filter=self.ip_range_filter,
            is_virtual_network_filter_enabled=self.is_virtual_network_filter_enabled,
            key_vault_key_id=self.key_vault_key_id,
            kind=self.kind,
            location=self.location,
            multiple_write_locations_enabled=self.multiple_write_locations_enabled,
            name=self.name,
            offer_type=self.offer_type,
            primary_key=self.primary_key,
            primary_mongodb_connection_string=self.primary_mongodb_connection_string,
            primary_readonly_key=self.primary_readonly_key,
            primary_readonly_mongodb_connection_string=self.primary_readonly_mongodb_connection_string,
            primary_readonly_sql_connection_string=self.primary_readonly_sql_connection_string,
            primary_sql_connection_string=self.primary_sql_connection_string,
            read_endpoints=self.read_endpoints,
            resource_group_name=self.resource_group_name,
            secondary_key=self.secondary_key,
            secondary_mongodb_connection_string=self.secondary_mongodb_connection_string,
            secondary_readonly_key=self.secondary_readonly_key,
            secondary_readonly_mongodb_connection_string=self.secondary_readonly_mongodb_connection_string,
            secondary_readonly_sql_connection_string=self.secondary_readonly_sql_connection_string,
            secondary_sql_connection_string=self.secondary_sql_connection_string,
            tags=self.tags,
            virtual_network_rules=self.virtual_network_rules,
            write_endpoints=self.write_endpoints)


def get_account(name: Optional[_builtins.str] = None,
                resource_group_name: Optional[_builtins.str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAccountResult:
    """
    Use this data source to access information about an existing CosmosDB (formally DocumentDB) Account.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.cosmosdb.get_account(name="tfex-cosmosdb-account",
        resource_group_name="tfex-cosmosdb-account-rg")
    pulumi.export("cosmosdbAccountEndpoint", example.endpoint)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.DocumentDB`: 2024-08-15


    :param _builtins.str name: Specifies the name of the CosmosDB Account.
    :param _builtins.str resource_group_name: Specifies the name of the resource group in which the CosmosDB Account resides.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:cosmosdb/getAccount:getAccount', __args__, opts=opts, typ=GetAccountResult).value

    return AwaitableGetAccountResult(
        automatic_failover_enabled=pulumi.get(__ret__, 'automatic_failover_enabled'),
        capabilities=pulumi.get(__ret__, 'capabilities'),
        consistency_policies=pulumi.get(__ret__, 'consistency_policies'),
        endpoint=pulumi.get(__ret__, 'endpoint'),
        free_tier_enabled=pulumi.get(__ret__, 'free_tier_enabled'),
        geo_locations=pulumi.get(__ret__, 'geo_locations'),
        id=pulumi.get(__ret__, 'id'),
        ip_range_filter=pulumi.get(__ret__, 'ip_range_filter'),
        is_virtual_network_filter_enabled=pulumi.get(__ret__, 'is_virtual_network_filter_enabled'),
        key_vault_key_id=pulumi.get(__ret__, 'key_vault_key_id'),
        kind=pulumi.get(__ret__, 'kind'),
        location=pulumi.get(__ret__, 'location'),
        multiple_write_locations_enabled=pulumi.get(__ret__, 'multiple_write_locations_enabled'),
        name=pulumi.get(__ret__, 'name'),
        offer_type=pulumi.get(__ret__, 'offer_type'),
        primary_key=pulumi.get(__ret__, 'primary_key'),
        primary_mongodb_connection_string=pulumi.get(__ret__, 'primary_mongodb_connection_string'),
        primary_readonly_key=pulumi.get(__ret__, 'primary_readonly_key'),
        primary_readonly_mongodb_connection_string=pulumi.get(__ret__, 'primary_readonly_mongodb_connection_string'),
        primary_readonly_sql_connection_string=pulumi.get(__ret__, 'primary_readonly_sql_connection_string'),
        primary_sql_connection_string=pulumi.get(__ret__, 'primary_sql_connection_string'),
        read_endpoints=pulumi.get(__ret__, 'read_endpoints'),
        resource_group_name=pulumi.get(__ret__, 'resource_group_name'),
        secondary_key=pulumi.get(__ret__, 'secondary_key'),
        secondary_mongodb_connection_string=pulumi.get(__ret__, 'secondary_mongodb_connection_string'),
        secondary_readonly_key=pulumi.get(__ret__, 'secondary_readonly_key'),
        secondary_readonly_mongodb_connection_string=pulumi.get(__ret__, 'secondary_readonly_mongodb_connection_string'),
        secondary_readonly_sql_connection_string=pulumi.get(__ret__, 'secondary_readonly_sql_connection_string'),
        secondary_sql_connection_string=pulumi.get(__ret__, 'secondary_sql_connection_string'),
        tags=pulumi.get(__ret__, 'tags'),
        virtual_network_rules=pulumi.get(__ret__, 'virtual_network_rules'),
        write_endpoints=pulumi.get(__ret__, 'write_endpoints'))
def get_account_output(name: Optional[pulumi.Input[_builtins.str]] = None,
                       resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAccountResult]:
    """
    Use this data source to access information about an existing CosmosDB (formally DocumentDB) Account.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.cosmosdb.get_account(name="tfex-cosmosdb-account",
        resource_group_name="tfex-cosmosdb-account-rg")
    pulumi.export("cosmosdbAccountEndpoint", example.endpoint)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.DocumentDB`: 2024-08-15


    :param _builtins.str name: Specifies the name of the CosmosDB Account.
    :param _builtins.str resource_group_name: Specifies the name of the resource group in which the CosmosDB Account resides.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:cosmosdb/getAccount:getAccount', __args__, opts=opts, typ=GetAccountResult)
    return __ret__.apply(lambda __response__: GetAccountResult(
        automatic_failover_enabled=pulumi.get(__response__, 'automatic_failover_enabled'),
        capabilities=pulumi.get(__response__, 'capabilities'),
        consistency_policies=pulumi.get(__response__, 'consistency_policies'),
        endpoint=pulumi.get(__response__, 'endpoint'),
        free_tier_enabled=pulumi.get(__response__, 'free_tier_enabled'),
        geo_locations=pulumi.get(__response__, 'geo_locations'),
        id=pulumi.get(__response__, 'id'),
        ip_range_filter=pulumi.get(__response__, 'ip_range_filter'),
        is_virtual_network_filter_enabled=pulumi.get(__response__, 'is_virtual_network_filter_enabled'),
        key_vault_key_id=pulumi.get(__response__, 'key_vault_key_id'),
        kind=pulumi.get(__response__, 'kind'),
        location=pulumi.get(__response__, 'location'),
        multiple_write_locations_enabled=pulumi.get(__response__, 'multiple_write_locations_enabled'),
        name=pulumi.get(__response__, 'name'),
        offer_type=pulumi.get(__response__, 'offer_type'),
        primary_key=pulumi.get(__response__, 'primary_key'),
        primary_mongodb_connection_string=pulumi.get(__response__, 'primary_mongodb_connection_string'),
        primary_readonly_key=pulumi.get(__response__, 'primary_readonly_key'),
        primary_readonly_mongodb_connection_string=pulumi.get(__response__, 'primary_readonly_mongodb_connection_string'),
        primary_readonly_sql_connection_string=pulumi.get(__response__, 'primary_readonly_sql_connection_string'),
        primary_sql_connection_string=pulumi.get(__response__, 'primary_sql_connection_string'),
        read_endpoints=pulumi.get(__response__, 'read_endpoints'),
        resource_group_name=pulumi.get(__response__, 'resource_group_name'),
        secondary_key=pulumi.get(__response__, 'secondary_key'),
        secondary_mongodb_connection_string=pulumi.get(__response__, 'secondary_mongodb_connection_string'),
        secondary_readonly_key=pulumi.get(__response__, 'secondary_readonly_key'),
        secondary_readonly_mongodb_connection_string=pulumi.get(__response__, 'secondary_readonly_mongodb_connection_string'),
        secondary_readonly_sql_connection_string=pulumi.get(__response__, 'secondary_readonly_sql_connection_string'),
        secondary_sql_connection_string=pulumi.get(__response__, 'secondary_sql_connection_string'),
        tags=pulumi.get(__response__, 'tags'),
        virtual_network_rules=pulumi.get(__response__, 'virtual_network_rules'),
        write_endpoints=pulumi.get(__response__, 'write_endpoints')))
