# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['MongoClusterArgs', 'MongoCluster']

@pulumi.input_type
class MongoClusterArgs:
    def __init__(__self__, *,
                 resource_group_name: pulumi.Input[_builtins.str],
                 administrator_password: Optional[pulumi.Input[_builtins.str]] = None,
                 administrator_username: Optional[pulumi.Input[_builtins.str]] = None,
                 compute_tier: Optional[pulumi.Input[_builtins.str]] = None,
                 create_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 high_availability_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 preview_features: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 public_network_access: Optional[pulumi.Input[_builtins.str]] = None,
                 shard_count: Optional[pulumi.Input[_builtins.int]] = None,
                 source_location: Optional[pulumi.Input[_builtins.str]] = None,
                 source_server_id: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_size_in_gb: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a MongoCluster resource.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which to create the MongoDB Cluster. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] administrator_password: The Password associated with the `administrator_username` for the MongoDB Cluster.
        :param pulumi.Input[_builtins.str] administrator_username: The administrator username of the MongoDB Cluster. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] compute_tier: The compute tier to assign to the MongoDB Cluster. Possible values are `Free`, `M10`, `M20`, `M25`, `M30`, `M40`, `M50`, `M60`, `M80`, and `M200`.
        :param pulumi.Input[_builtins.str] create_mode: The creation mode for the MongoDB Cluster. Possibles values are `Default` and `GeoReplica`. Defaults to `Default`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] high_availability_mode: The high availability mode for the MongoDB Cluster. Possibles values are `Disabled` and `ZoneRedundantPreferred`.
        :param pulumi.Input[_builtins.str] location: The supported Azure location where the MongoDB Cluster exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for the MongoDB Cluster. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] preview_features: The preview features that can be enabled on the MongoDB Cluster. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] public_network_access: The Public Network Access setting for the MongoDB Cluster. Possibles values are `Disabled` and `Enabled`. Defaults to `Enabled`.
        :param pulumi.Input[_builtins.int] shard_count: The Number of shards to provision on the MongoDB Cluster. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] source_location: The location of the source MongoDB Cluster. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] source_server_id: The ID of the replication source MongoDB Cluster. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] storage_size_in_gb: The size of the data disk space for the MongoDB Cluster.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the MongoDB Cluster.
        :param pulumi.Input[_builtins.str] version: The version for the MongoDB Cluster. Possibles values are `5.0`, `6.0` and `7.0`.
        """
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if administrator_password is not None:
            pulumi.set(__self__, "administrator_password", administrator_password)
        if administrator_username is not None:
            pulumi.set(__self__, "administrator_username", administrator_username)
        if compute_tier is not None:
            pulumi.set(__self__, "compute_tier", compute_tier)
        if create_mode is not None:
            pulumi.set(__self__, "create_mode", create_mode)
        if high_availability_mode is not None:
            pulumi.set(__self__, "high_availability_mode", high_availability_mode)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if preview_features is not None:
            pulumi.set(__self__, "preview_features", preview_features)
        if public_network_access is not None:
            pulumi.set(__self__, "public_network_access", public_network_access)
        if shard_count is not None:
            pulumi.set(__self__, "shard_count", shard_count)
        if source_location is not None:
            pulumi.set(__self__, "source_location", source_location)
        if source_server_id is not None:
            pulumi.set(__self__, "source_server_id", source_server_id)
        if storage_size_in_gb is not None:
            pulumi.set(__self__, "storage_size_in_gb", storage_size_in_gb)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the resource group in which to create the MongoDB Cluster. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="administratorPassword")
    def administrator_password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Password associated with the `administrator_username` for the MongoDB Cluster.
        """
        return pulumi.get(self, "administrator_password")

    @administrator_password.setter
    def administrator_password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "administrator_password", value)

    @_builtins.property
    @pulumi.getter(name="administratorUsername")
    def administrator_username(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The administrator username of the MongoDB Cluster. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "administrator_username")

    @administrator_username.setter
    def administrator_username(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "administrator_username", value)

    @_builtins.property
    @pulumi.getter(name="computeTier")
    def compute_tier(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The compute tier to assign to the MongoDB Cluster. Possible values are `Free`, `M10`, `M20`, `M25`, `M30`, `M40`, `M50`, `M60`, `M80`, and `M200`.
        """
        return pulumi.get(self, "compute_tier")

    @compute_tier.setter
    def compute_tier(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compute_tier", value)

    @_builtins.property
    @pulumi.getter(name="createMode")
    def create_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The creation mode for the MongoDB Cluster. Possibles values are `Default` and `GeoReplica`. Defaults to `Default`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "create_mode")

    @create_mode.setter
    def create_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_mode", value)

    @_builtins.property
    @pulumi.getter(name="highAvailabilityMode")
    def high_availability_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The high availability mode for the MongoDB Cluster. Possibles values are `Disabled` and `ZoneRedundantPreferred`.
        """
        return pulumi.get(self, "high_availability_mode")

    @high_availability_mode.setter
    def high_availability_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "high_availability_mode", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The supported Azure location where the MongoDB Cluster exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for the MongoDB Cluster. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="previewFeatures")
    def preview_features(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The preview features that can be enabled on the MongoDB Cluster. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "preview_features")

    @preview_features.setter
    def preview_features(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "preview_features", value)

    @_builtins.property
    @pulumi.getter(name="publicNetworkAccess")
    def public_network_access(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Public Network Access setting for the MongoDB Cluster. Possibles values are `Disabled` and `Enabled`. Defaults to `Enabled`.
        """
        return pulumi.get(self, "public_network_access")

    @public_network_access.setter
    def public_network_access(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "public_network_access", value)

    @_builtins.property
    @pulumi.getter(name="shardCount")
    def shard_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The Number of shards to provision on the MongoDB Cluster. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "shard_count")

    @shard_count.setter
    def shard_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "shard_count", value)

    @_builtins.property
    @pulumi.getter(name="sourceLocation")
    def source_location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The location of the source MongoDB Cluster. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "source_location")

    @source_location.setter
    def source_location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_location", value)

    @_builtins.property
    @pulumi.getter(name="sourceServerId")
    def source_server_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the replication source MongoDB Cluster. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "source_server_id")

    @source_server_id.setter
    def source_server_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_server_id", value)

    @_builtins.property
    @pulumi.getter(name="storageSizeInGb")
    def storage_size_in_gb(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The size of the data disk space for the MongoDB Cluster.
        """
        return pulumi.get(self, "storage_size_in_gb")

    @storage_size_in_gb.setter
    def storage_size_in_gb(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "storage_size_in_gb", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the MongoDB Cluster.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The version for the MongoDB Cluster. Possibles values are `5.0`, `6.0` and `7.0`.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class _MongoClusterState:
    def __init__(__self__, *,
                 administrator_password: Optional[pulumi.Input[_builtins.str]] = None,
                 administrator_username: Optional[pulumi.Input[_builtins.str]] = None,
                 compute_tier: Optional[pulumi.Input[_builtins.str]] = None,
                 connection_strings: Optional[pulumi.Input[Sequence[pulumi.Input['MongoClusterConnectionStringArgs']]]] = None,
                 create_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 high_availability_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 preview_features: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 public_network_access: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 shard_count: Optional[pulumi.Input[_builtins.int]] = None,
                 source_location: Optional[pulumi.Input[_builtins.str]] = None,
                 source_server_id: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_size_in_gb: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering MongoCluster resources.
        :param pulumi.Input[_builtins.str] administrator_password: The Password associated with the `administrator_username` for the MongoDB Cluster.
        :param pulumi.Input[_builtins.str] administrator_username: The administrator username of the MongoDB Cluster. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] compute_tier: The compute tier to assign to the MongoDB Cluster. Possible values are `Free`, `M10`, `M20`, `M25`, `M30`, `M40`, `M50`, `M60`, `M80`, and `M200`.
        :param pulumi.Input[Sequence[pulumi.Input['MongoClusterConnectionStringArgs']]] connection_strings: The list of `connection_strings` blocks as defined below.
        :param pulumi.Input[_builtins.str] create_mode: The creation mode for the MongoDB Cluster. Possibles values are `Default` and `GeoReplica`. Defaults to `Default`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] high_availability_mode: The high availability mode for the MongoDB Cluster. Possibles values are `Disabled` and `ZoneRedundantPreferred`.
        :param pulumi.Input[_builtins.str] location: The supported Azure location where the MongoDB Cluster exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for the MongoDB Cluster. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] preview_features: The preview features that can be enabled on the MongoDB Cluster. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] public_network_access: The Public Network Access setting for the MongoDB Cluster. Possibles values are `Disabled` and `Enabled`. Defaults to `Enabled`.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which to create the MongoDB Cluster. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] shard_count: The Number of shards to provision on the MongoDB Cluster. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] source_location: The location of the source MongoDB Cluster. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] source_server_id: The ID of the replication source MongoDB Cluster. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] storage_size_in_gb: The size of the data disk space for the MongoDB Cluster.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the MongoDB Cluster.
        :param pulumi.Input[_builtins.str] version: The version for the MongoDB Cluster. Possibles values are `5.0`, `6.0` and `7.0`.
        """
        if administrator_password is not None:
            pulumi.set(__self__, "administrator_password", administrator_password)
        if administrator_username is not None:
            pulumi.set(__self__, "administrator_username", administrator_username)
        if compute_tier is not None:
            pulumi.set(__self__, "compute_tier", compute_tier)
        if connection_strings is not None:
            pulumi.set(__self__, "connection_strings", connection_strings)
        if create_mode is not None:
            pulumi.set(__self__, "create_mode", create_mode)
        if high_availability_mode is not None:
            pulumi.set(__self__, "high_availability_mode", high_availability_mode)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if preview_features is not None:
            pulumi.set(__self__, "preview_features", preview_features)
        if public_network_access is not None:
            pulumi.set(__self__, "public_network_access", public_network_access)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if shard_count is not None:
            pulumi.set(__self__, "shard_count", shard_count)
        if source_location is not None:
            pulumi.set(__self__, "source_location", source_location)
        if source_server_id is not None:
            pulumi.set(__self__, "source_server_id", source_server_id)
        if storage_size_in_gb is not None:
            pulumi.set(__self__, "storage_size_in_gb", storage_size_in_gb)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter(name="administratorPassword")
    def administrator_password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Password associated with the `administrator_username` for the MongoDB Cluster.
        """
        return pulumi.get(self, "administrator_password")

    @administrator_password.setter
    def administrator_password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "administrator_password", value)

    @_builtins.property
    @pulumi.getter(name="administratorUsername")
    def administrator_username(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The administrator username of the MongoDB Cluster. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "administrator_username")

    @administrator_username.setter
    def administrator_username(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "administrator_username", value)

    @_builtins.property
    @pulumi.getter(name="computeTier")
    def compute_tier(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The compute tier to assign to the MongoDB Cluster. Possible values are `Free`, `M10`, `M20`, `M25`, `M30`, `M40`, `M50`, `M60`, `M80`, and `M200`.
        """
        return pulumi.get(self, "compute_tier")

    @compute_tier.setter
    def compute_tier(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compute_tier", value)

    @_builtins.property
    @pulumi.getter(name="connectionStrings")
    def connection_strings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MongoClusterConnectionStringArgs']]]]:
        """
        The list of `connection_strings` blocks as defined below.
        """
        return pulumi.get(self, "connection_strings")

    @connection_strings.setter
    def connection_strings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MongoClusterConnectionStringArgs']]]]):
        pulumi.set(self, "connection_strings", value)

    @_builtins.property
    @pulumi.getter(name="createMode")
    def create_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The creation mode for the MongoDB Cluster. Possibles values are `Default` and `GeoReplica`. Defaults to `Default`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "create_mode")

    @create_mode.setter
    def create_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_mode", value)

    @_builtins.property
    @pulumi.getter(name="highAvailabilityMode")
    def high_availability_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The high availability mode for the MongoDB Cluster. Possibles values are `Disabled` and `ZoneRedundantPreferred`.
        """
        return pulumi.get(self, "high_availability_mode")

    @high_availability_mode.setter
    def high_availability_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "high_availability_mode", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The supported Azure location where the MongoDB Cluster exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for the MongoDB Cluster. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="previewFeatures")
    def preview_features(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The preview features that can be enabled on the MongoDB Cluster. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "preview_features")

    @preview_features.setter
    def preview_features(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "preview_features", value)

    @_builtins.property
    @pulumi.getter(name="publicNetworkAccess")
    def public_network_access(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Public Network Access setting for the MongoDB Cluster. Possibles values are `Disabled` and `Enabled`. Defaults to `Enabled`.
        """
        return pulumi.get(self, "public_network_access")

    @public_network_access.setter
    def public_network_access(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "public_network_access", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the resource group in which to create the MongoDB Cluster. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="shardCount")
    def shard_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The Number of shards to provision on the MongoDB Cluster. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "shard_count")

    @shard_count.setter
    def shard_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "shard_count", value)

    @_builtins.property
    @pulumi.getter(name="sourceLocation")
    def source_location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The location of the source MongoDB Cluster. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "source_location")

    @source_location.setter
    def source_location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_location", value)

    @_builtins.property
    @pulumi.getter(name="sourceServerId")
    def source_server_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the replication source MongoDB Cluster. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "source_server_id")

    @source_server_id.setter
    def source_server_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_server_id", value)

    @_builtins.property
    @pulumi.getter(name="storageSizeInGb")
    def storage_size_in_gb(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The size of the data disk space for the MongoDB Cluster.
        """
        return pulumi.get(self, "storage_size_in_gb")

    @storage_size_in_gb.setter
    def storage_size_in_gb(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "storage_size_in_gb", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the MongoDB Cluster.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The version for the MongoDB Cluster. Possibles values are `5.0`, `6.0` and `7.0`.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "version", value)


@pulumi.type_token("azure:cosmosdb/mongoCluster:MongoCluster")
class MongoCluster(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 administrator_password: Optional[pulumi.Input[_builtins.str]] = None,
                 administrator_username: Optional[pulumi.Input[_builtins.str]] = None,
                 compute_tier: Optional[pulumi.Input[_builtins.str]] = None,
                 create_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 high_availability_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 preview_features: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 public_network_access: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 shard_count: Optional[pulumi.Input[_builtins.int]] = None,
                 source_location: Optional[pulumi.Input[_builtins.str]] = None,
                 source_server_id: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_size_in_gb: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a MongoDB Cluster using vCore Architecture.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-rg",
            location="East US")
        example_mongo_cluster = azure.cosmosdb.MongoCluster("example",
            name="example-mc",
            resource_group_name=example.name,
            location=example.location,
            administrator_username="adminTerraform",
            administrator_password="QAZwsx123",
            shard_count=1,
            compute_tier="Free",
            high_availability_mode="Disabled",
            storage_size_in_gb=32)
        ```

        ### Preview Feature GeoReplicas)

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-rg",
            location="East US")
        example_mongo_cluster = azure.cosmosdb.MongoCluster("example",
            name="example-mc",
            resource_group_name=example.name,
            location=example.location,
            administrator_username="adminTerraform",
            administrator_password="QAZwsx123",
            shard_count=1,
            compute_tier="M30",
            high_availability_mode="ZoneRedundantPreferred",
            storage_size_in_gb=64,
            preview_features=["GeoReplicas"])
        example_geo_replica = azure.cosmosdb.MongoCluster("example_geo_replica",
            name="example-mc-geo",
            resource_group_name=example.name,
            location="Central US",
            source_server_id=example_mongo_cluster.id,
            source_location=example_mongo_cluster.location,
            create_mode="GeoReplica")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.DocumentDB`: 2024-07-01

        ## Import

        MongoDB Clusters can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:cosmosdb/mongoCluster:MongoCluster example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.DocumentDB/mongoClusters/myMongoCluster
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] administrator_password: The Password associated with the `administrator_username` for the MongoDB Cluster.
        :param pulumi.Input[_builtins.str] administrator_username: The administrator username of the MongoDB Cluster. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] compute_tier: The compute tier to assign to the MongoDB Cluster. Possible values are `Free`, `M10`, `M20`, `M25`, `M30`, `M40`, `M50`, `M60`, `M80`, and `M200`.
        :param pulumi.Input[_builtins.str] create_mode: The creation mode for the MongoDB Cluster. Possibles values are `Default` and `GeoReplica`. Defaults to `Default`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] high_availability_mode: The high availability mode for the MongoDB Cluster. Possibles values are `Disabled` and `ZoneRedundantPreferred`.
        :param pulumi.Input[_builtins.str] location: The supported Azure location where the MongoDB Cluster exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for the MongoDB Cluster. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] preview_features: The preview features that can be enabled on the MongoDB Cluster. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] public_network_access: The Public Network Access setting for the MongoDB Cluster. Possibles values are `Disabled` and `Enabled`. Defaults to `Enabled`.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which to create the MongoDB Cluster. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] shard_count: The Number of shards to provision on the MongoDB Cluster. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] source_location: The location of the source MongoDB Cluster. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] source_server_id: The ID of the replication source MongoDB Cluster. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] storage_size_in_gb: The size of the data disk space for the MongoDB Cluster.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the MongoDB Cluster.
        :param pulumi.Input[_builtins.str] version: The version for the MongoDB Cluster. Possibles values are `5.0`, `6.0` and `7.0`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MongoClusterArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a MongoDB Cluster using vCore Architecture.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-rg",
            location="East US")
        example_mongo_cluster = azure.cosmosdb.MongoCluster("example",
            name="example-mc",
            resource_group_name=example.name,
            location=example.location,
            administrator_username="adminTerraform",
            administrator_password="QAZwsx123",
            shard_count=1,
            compute_tier="Free",
            high_availability_mode="Disabled",
            storage_size_in_gb=32)
        ```

        ### Preview Feature GeoReplicas)

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-rg",
            location="East US")
        example_mongo_cluster = azure.cosmosdb.MongoCluster("example",
            name="example-mc",
            resource_group_name=example.name,
            location=example.location,
            administrator_username="adminTerraform",
            administrator_password="QAZwsx123",
            shard_count=1,
            compute_tier="M30",
            high_availability_mode="ZoneRedundantPreferred",
            storage_size_in_gb=64,
            preview_features=["GeoReplicas"])
        example_geo_replica = azure.cosmosdb.MongoCluster("example_geo_replica",
            name="example-mc-geo",
            resource_group_name=example.name,
            location="Central US",
            source_server_id=example_mongo_cluster.id,
            source_location=example_mongo_cluster.location,
            create_mode="GeoReplica")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.DocumentDB`: 2024-07-01

        ## Import

        MongoDB Clusters can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:cosmosdb/mongoCluster:MongoCluster example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.DocumentDB/mongoClusters/myMongoCluster
        ```

        :param str resource_name: The name of the resource.
        :param MongoClusterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MongoClusterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 administrator_password: Optional[pulumi.Input[_builtins.str]] = None,
                 administrator_username: Optional[pulumi.Input[_builtins.str]] = None,
                 compute_tier: Optional[pulumi.Input[_builtins.str]] = None,
                 create_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 high_availability_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 preview_features: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 public_network_access: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 shard_count: Optional[pulumi.Input[_builtins.int]] = None,
                 source_location: Optional[pulumi.Input[_builtins.str]] = None,
                 source_server_id: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_size_in_gb: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MongoClusterArgs.__new__(MongoClusterArgs)

            __props__.__dict__["administrator_password"] = None if administrator_password is None else pulumi.Output.secret(administrator_password)
            __props__.__dict__["administrator_username"] = administrator_username
            __props__.__dict__["compute_tier"] = compute_tier
            __props__.__dict__["create_mode"] = create_mode
            __props__.__dict__["high_availability_mode"] = high_availability_mode
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            __props__.__dict__["preview_features"] = preview_features
            __props__.__dict__["public_network_access"] = public_network_access
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["shard_count"] = shard_count
            __props__.__dict__["source_location"] = source_location
            __props__.__dict__["source_server_id"] = source_server_id
            __props__.__dict__["storage_size_in_gb"] = storage_size_in_gb
            __props__.__dict__["tags"] = tags
            __props__.__dict__["version"] = version
            __props__.__dict__["connection_strings"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["administratorPassword", "connectionStrings"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(MongoCluster, __self__).__init__(
            'azure:cosmosdb/mongoCluster:MongoCluster',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            administrator_password: Optional[pulumi.Input[_builtins.str]] = None,
            administrator_username: Optional[pulumi.Input[_builtins.str]] = None,
            compute_tier: Optional[pulumi.Input[_builtins.str]] = None,
            connection_strings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MongoClusterConnectionStringArgs', 'MongoClusterConnectionStringArgsDict']]]]] = None,
            create_mode: Optional[pulumi.Input[_builtins.str]] = None,
            high_availability_mode: Optional[pulumi.Input[_builtins.str]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            preview_features: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            public_network_access: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            shard_count: Optional[pulumi.Input[_builtins.int]] = None,
            source_location: Optional[pulumi.Input[_builtins.str]] = None,
            source_server_id: Optional[pulumi.Input[_builtins.str]] = None,
            storage_size_in_gb: Optional[pulumi.Input[_builtins.int]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            version: Optional[pulumi.Input[_builtins.str]] = None) -> 'MongoCluster':
        """
        Get an existing MongoCluster resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] administrator_password: The Password associated with the `administrator_username` for the MongoDB Cluster.
        :param pulumi.Input[_builtins.str] administrator_username: The administrator username of the MongoDB Cluster. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] compute_tier: The compute tier to assign to the MongoDB Cluster. Possible values are `Free`, `M10`, `M20`, `M25`, `M30`, `M40`, `M50`, `M60`, `M80`, and `M200`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['MongoClusterConnectionStringArgs', 'MongoClusterConnectionStringArgsDict']]]] connection_strings: The list of `connection_strings` blocks as defined below.
        :param pulumi.Input[_builtins.str] create_mode: The creation mode for the MongoDB Cluster. Possibles values are `Default` and `GeoReplica`. Defaults to `Default`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] high_availability_mode: The high availability mode for the MongoDB Cluster. Possibles values are `Disabled` and `ZoneRedundantPreferred`.
        :param pulumi.Input[_builtins.str] location: The supported Azure location where the MongoDB Cluster exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for the MongoDB Cluster. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] preview_features: The preview features that can be enabled on the MongoDB Cluster. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] public_network_access: The Public Network Access setting for the MongoDB Cluster. Possibles values are `Disabled` and `Enabled`. Defaults to `Enabled`.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which to create the MongoDB Cluster. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] shard_count: The Number of shards to provision on the MongoDB Cluster. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] source_location: The location of the source MongoDB Cluster. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] source_server_id: The ID of the replication source MongoDB Cluster. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] storage_size_in_gb: The size of the data disk space for the MongoDB Cluster.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the MongoDB Cluster.
        :param pulumi.Input[_builtins.str] version: The version for the MongoDB Cluster. Possibles values are `5.0`, `6.0` and `7.0`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MongoClusterState.__new__(_MongoClusterState)

        __props__.__dict__["administrator_password"] = administrator_password
        __props__.__dict__["administrator_username"] = administrator_username
        __props__.__dict__["compute_tier"] = compute_tier
        __props__.__dict__["connection_strings"] = connection_strings
        __props__.__dict__["create_mode"] = create_mode
        __props__.__dict__["high_availability_mode"] = high_availability_mode
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["preview_features"] = preview_features
        __props__.__dict__["public_network_access"] = public_network_access
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["shard_count"] = shard_count
        __props__.__dict__["source_location"] = source_location
        __props__.__dict__["source_server_id"] = source_server_id
        __props__.__dict__["storage_size_in_gb"] = storage_size_in_gb
        __props__.__dict__["tags"] = tags
        __props__.__dict__["version"] = version
        return MongoCluster(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="administratorPassword")
    def administrator_password(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The Password associated with the `administrator_username` for the MongoDB Cluster.
        """
        return pulumi.get(self, "administrator_password")

    @_builtins.property
    @pulumi.getter(name="administratorUsername")
    def administrator_username(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The administrator username of the MongoDB Cluster. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "administrator_username")

    @_builtins.property
    @pulumi.getter(name="computeTier")
    def compute_tier(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The compute tier to assign to the MongoDB Cluster. Possible values are `Free`, `M10`, `M20`, `M25`, `M30`, `M40`, `M50`, `M60`, `M80`, and `M200`.
        """
        return pulumi.get(self, "compute_tier")

    @_builtins.property
    @pulumi.getter(name="connectionStrings")
    def connection_strings(self) -> pulumi.Output[Sequence['outputs.MongoClusterConnectionString']]:
        """
        The list of `connection_strings` blocks as defined below.
        """
        return pulumi.get(self, "connection_strings")

    @_builtins.property
    @pulumi.getter(name="createMode")
    def create_mode(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The creation mode for the MongoDB Cluster. Possibles values are `Default` and `GeoReplica`. Defaults to `Default`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "create_mode")

    @_builtins.property
    @pulumi.getter(name="highAvailabilityMode")
    def high_availability_mode(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The high availability mode for the MongoDB Cluster. Possibles values are `Disabled` and `ZoneRedundantPreferred`.
        """
        return pulumi.get(self, "high_availability_mode")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        The supported Azure location where the MongoDB Cluster exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name which should be used for the MongoDB Cluster. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="previewFeatures")
    def preview_features(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        The preview features that can be enabled on the MongoDB Cluster. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "preview_features")

    @_builtins.property
    @pulumi.getter(name="publicNetworkAccess")
    def public_network_access(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The Public Network Access setting for the MongoDB Cluster. Possibles values are `Disabled` and `Enabled`. Defaults to `Enabled`.
        """
        return pulumi.get(self, "public_network_access")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the resource group in which to create the MongoDB Cluster. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter(name="shardCount")
    def shard_count(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The Number of shards to provision on the MongoDB Cluster. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "shard_count")

    @_builtins.property
    @pulumi.getter(name="sourceLocation")
    def source_location(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The location of the source MongoDB Cluster. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "source_location")

    @_builtins.property
    @pulumi.getter(name="sourceServerId")
    def source_server_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the replication source MongoDB Cluster. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "source_server_id")

    @_builtins.property
    @pulumi.getter(name="storageSizeInGb")
    def storage_size_in_gb(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The size of the data disk space for the MongoDB Cluster.
        """
        return pulumi.get(self, "storage_size_in_gb")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags to assign to the MongoDB Cluster.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def version(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The version for the MongoDB Cluster. Possibles values are `5.0`, `6.0` and `7.0`.
        """
        return pulumi.get(self, "version")

