# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SqlContainerArgs', 'SqlContainer']

@pulumi.input_type
class SqlContainerArgs:
    def __init__(__self__, *,
                 account_name: pulumi.Input[_builtins.str],
                 database_name: pulumi.Input[_builtins.str],
                 partition_key_paths: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 resource_group_name: pulumi.Input[_builtins.str],
                 analytical_storage_ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 autoscale_settings: Optional[pulumi.Input['SqlContainerAutoscaleSettingsArgs']] = None,
                 conflict_resolution_policy: Optional[pulumi.Input['SqlContainerConflictResolutionPolicyArgs']] = None,
                 default_ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 indexing_policy: Optional[pulumi.Input['SqlContainerIndexingPolicyArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 partition_key_kind: Optional[pulumi.Input[_builtins.str]] = None,
                 partition_key_version: Optional[pulumi.Input[_builtins.int]] = None,
                 throughput: Optional[pulumi.Input[_builtins.int]] = None,
                 unique_keys: Optional[pulumi.Input[Sequence[pulumi.Input['SqlContainerUniqueKeyArgs']]]] = None):
        """
        The set of arguments for constructing a SqlContainer resource.
        :param pulumi.Input[_builtins.str] account_name: The name of the Cosmos DB Account to create the container within. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] database_name: The name of the Cosmos DB SQL Database to create the container within. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] partition_key_paths: A list of partition key paths. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which the Cosmos DB SQL Container is created. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] analytical_storage_ttl: The default time to live of Analytical Storage for this SQL container. If present and the value is set to `-1`, it is equal to infinity, and items don’t expire by default. If present and the value is set to some number `n` – items will expire `n` seconds after their last modified time.
        :param pulumi.Input['SqlContainerAutoscaleSettingsArgs'] autoscale_settings: An `autoscale_settings` block as defined below. This must be set upon database creation otherwise it cannot be updated without a manual destroy-apply.
               
               > **Note:** Switching between autoscale and manual throughput is not supported via this provider and must be completed via the Azure Portal and refreshed.
        :param pulumi.Input['SqlContainerConflictResolutionPolicyArgs'] conflict_resolution_policy: A `conflict_resolution_policy` blocks as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] default_ttl: The default time to live of SQL container. If missing, items are not expired automatically. If present and the value is set to `-1`, it is equal to infinity, and items don’t expire by default. If present and the value is set to some number `n` – items will expire `n` seconds after their last modified time.
        :param pulumi.Input['SqlContainerIndexingPolicyArgs'] indexing_policy: An `indexing_policy` block as defined below.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Cosmos DB SQL Container. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] partition_key_kind: Define a partition key kind. Possible values are `Hash` and `MultiHash`. Defaults to `Hash`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] partition_key_version: Define a partition key version. Possible values are `1`and `2`. This should be set to `2` in order to use large partition keys.
               
               > **Note:** If `partition_key_version` is not specified when creating a new resource, you can update `partition_key_version` to `1`, updating to `2` forces a new resource to be created.
        :param pulumi.Input[_builtins.int] throughput: The throughput of SQL container (RU/s). Must be set in increments of `100`. The minimum value is `400`. This must be set upon container creation otherwise it cannot be updated without a manual resource destroy-apply.
        :param pulumi.Input[Sequence[pulumi.Input['SqlContainerUniqueKeyArgs']]] unique_keys: One or more `unique_key` blocks as defined below. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "account_name", account_name)
        pulumi.set(__self__, "database_name", database_name)
        pulumi.set(__self__, "partition_key_paths", partition_key_paths)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if analytical_storage_ttl is not None:
            pulumi.set(__self__, "analytical_storage_ttl", analytical_storage_ttl)
        if autoscale_settings is not None:
            pulumi.set(__self__, "autoscale_settings", autoscale_settings)
        if conflict_resolution_policy is not None:
            pulumi.set(__self__, "conflict_resolution_policy", conflict_resolution_policy)
        if default_ttl is not None:
            pulumi.set(__self__, "default_ttl", default_ttl)
        if indexing_policy is not None:
            pulumi.set(__self__, "indexing_policy", indexing_policy)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if partition_key_kind is not None:
            pulumi.set(__self__, "partition_key_kind", partition_key_kind)
        if partition_key_version is not None:
            pulumi.set(__self__, "partition_key_version", partition_key_version)
        if throughput is not None:
            pulumi.set(__self__, "throughput", throughput)
        if unique_keys is not None:
            pulumi.set(__self__, "unique_keys", unique_keys)

    @_builtins.property
    @pulumi.getter(name="accountName")
    def account_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the Cosmos DB Account to create the container within. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "account_name")

    @account_name.setter
    def account_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "account_name", value)

    @_builtins.property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the Cosmos DB SQL Database to create the container within. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "database_name")

    @database_name.setter
    def database_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "database_name", value)

    @_builtins.property
    @pulumi.getter(name="partitionKeyPaths")
    def partition_key_paths(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        A list of partition key paths. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "partition_key_paths")

    @partition_key_paths.setter
    def partition_key_paths(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "partition_key_paths", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the resource group in which the Cosmos DB SQL Container is created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="analyticalStorageTtl")
    def analytical_storage_ttl(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The default time to live of Analytical Storage for this SQL container. If present and the value is set to `-1`, it is equal to infinity, and items don’t expire by default. If present and the value is set to some number `n` – items will expire `n` seconds after their last modified time.
        """
        return pulumi.get(self, "analytical_storage_ttl")

    @analytical_storage_ttl.setter
    def analytical_storage_ttl(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "analytical_storage_ttl", value)

    @_builtins.property
    @pulumi.getter(name="autoscaleSettings")
    def autoscale_settings(self) -> Optional[pulumi.Input['SqlContainerAutoscaleSettingsArgs']]:
        """
        An `autoscale_settings` block as defined below. This must be set upon database creation otherwise it cannot be updated without a manual destroy-apply.

        > **Note:** Switching between autoscale and manual throughput is not supported via this provider and must be completed via the Azure Portal and refreshed.
        """
        return pulumi.get(self, "autoscale_settings")

    @autoscale_settings.setter
    def autoscale_settings(self, value: Optional[pulumi.Input['SqlContainerAutoscaleSettingsArgs']]):
        pulumi.set(self, "autoscale_settings", value)

    @_builtins.property
    @pulumi.getter(name="conflictResolutionPolicy")
    def conflict_resolution_policy(self) -> Optional[pulumi.Input['SqlContainerConflictResolutionPolicyArgs']]:
        """
        A `conflict_resolution_policy` blocks as defined below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "conflict_resolution_policy")

    @conflict_resolution_policy.setter
    def conflict_resolution_policy(self, value: Optional[pulumi.Input['SqlContainerConflictResolutionPolicyArgs']]):
        pulumi.set(self, "conflict_resolution_policy", value)

    @_builtins.property
    @pulumi.getter(name="defaultTtl")
    def default_ttl(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The default time to live of SQL container. If missing, items are not expired automatically. If present and the value is set to `-1`, it is equal to infinity, and items don’t expire by default. If present and the value is set to some number `n` – items will expire `n` seconds after their last modified time.
        """
        return pulumi.get(self, "default_ttl")

    @default_ttl.setter
    def default_ttl(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "default_ttl", value)

    @_builtins.property
    @pulumi.getter(name="indexingPolicy")
    def indexing_policy(self) -> Optional[pulumi.Input['SqlContainerIndexingPolicyArgs']]:
        """
        An `indexing_policy` block as defined below.
        """
        return pulumi.get(self, "indexing_policy")

    @indexing_policy.setter
    def indexing_policy(self, value: Optional[pulumi.Input['SqlContainerIndexingPolicyArgs']]):
        pulumi.set(self, "indexing_policy", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the Cosmos DB SQL Container. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="partitionKeyKind")
    def partition_key_kind(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Define a partition key kind. Possible values are `Hash` and `MultiHash`. Defaults to `Hash`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "partition_key_kind")

    @partition_key_kind.setter
    def partition_key_kind(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "partition_key_kind", value)

    @_builtins.property
    @pulumi.getter(name="partitionKeyVersion")
    def partition_key_version(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Define a partition key version. Possible values are `1`and `2`. This should be set to `2` in order to use large partition keys.

        > **Note:** If `partition_key_version` is not specified when creating a new resource, you can update `partition_key_version` to `1`, updating to `2` forces a new resource to be created.
        """
        return pulumi.get(self, "partition_key_version")

    @partition_key_version.setter
    def partition_key_version(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "partition_key_version", value)

    @_builtins.property
    @pulumi.getter
    def throughput(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The throughput of SQL container (RU/s). Must be set in increments of `100`. The minimum value is `400`. This must be set upon container creation otherwise it cannot be updated without a manual resource destroy-apply.
        """
        return pulumi.get(self, "throughput")

    @throughput.setter
    def throughput(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "throughput", value)

    @_builtins.property
    @pulumi.getter(name="uniqueKeys")
    def unique_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SqlContainerUniqueKeyArgs']]]]:
        """
        One or more `unique_key` blocks as defined below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "unique_keys")

    @unique_keys.setter
    def unique_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SqlContainerUniqueKeyArgs']]]]):
        pulumi.set(self, "unique_keys", value)


@pulumi.input_type
class _SqlContainerState:
    def __init__(__self__, *,
                 account_name: Optional[pulumi.Input[_builtins.str]] = None,
                 analytical_storage_ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 autoscale_settings: Optional[pulumi.Input['SqlContainerAutoscaleSettingsArgs']] = None,
                 conflict_resolution_policy: Optional[pulumi.Input['SqlContainerConflictResolutionPolicyArgs']] = None,
                 database_name: Optional[pulumi.Input[_builtins.str]] = None,
                 default_ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 indexing_policy: Optional[pulumi.Input['SqlContainerIndexingPolicyArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 partition_key_kind: Optional[pulumi.Input[_builtins.str]] = None,
                 partition_key_paths: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 partition_key_version: Optional[pulumi.Input[_builtins.int]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 throughput: Optional[pulumi.Input[_builtins.int]] = None,
                 unique_keys: Optional[pulumi.Input[Sequence[pulumi.Input['SqlContainerUniqueKeyArgs']]]] = None):
        """
        Input properties used for looking up and filtering SqlContainer resources.
        :param pulumi.Input[_builtins.str] account_name: The name of the Cosmos DB Account to create the container within. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] analytical_storage_ttl: The default time to live of Analytical Storage for this SQL container. If present and the value is set to `-1`, it is equal to infinity, and items don’t expire by default. If present and the value is set to some number `n` – items will expire `n` seconds after their last modified time.
        :param pulumi.Input['SqlContainerAutoscaleSettingsArgs'] autoscale_settings: An `autoscale_settings` block as defined below. This must be set upon database creation otherwise it cannot be updated without a manual destroy-apply.
               
               > **Note:** Switching between autoscale and manual throughput is not supported via this provider and must be completed via the Azure Portal and refreshed.
        :param pulumi.Input['SqlContainerConflictResolutionPolicyArgs'] conflict_resolution_policy: A `conflict_resolution_policy` blocks as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] database_name: The name of the Cosmos DB SQL Database to create the container within. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] default_ttl: The default time to live of SQL container. If missing, items are not expired automatically. If present and the value is set to `-1`, it is equal to infinity, and items don’t expire by default. If present and the value is set to some number `n` – items will expire `n` seconds after their last modified time.
        :param pulumi.Input['SqlContainerIndexingPolicyArgs'] indexing_policy: An `indexing_policy` block as defined below.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Cosmos DB SQL Container. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] partition_key_kind: Define a partition key kind. Possible values are `Hash` and `MultiHash`. Defaults to `Hash`. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] partition_key_paths: A list of partition key paths. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] partition_key_version: Define a partition key version. Possible values are `1`and `2`. This should be set to `2` in order to use large partition keys.
               
               > **Note:** If `partition_key_version` is not specified when creating a new resource, you can update `partition_key_version` to `1`, updating to `2` forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which the Cosmos DB SQL Container is created. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] throughput: The throughput of SQL container (RU/s). Must be set in increments of `100`. The minimum value is `400`. This must be set upon container creation otherwise it cannot be updated without a manual resource destroy-apply.
        :param pulumi.Input[Sequence[pulumi.Input['SqlContainerUniqueKeyArgs']]] unique_keys: One or more `unique_key` blocks as defined below. Changing this forces a new resource to be created.
        """
        if account_name is not None:
            pulumi.set(__self__, "account_name", account_name)
        if analytical_storage_ttl is not None:
            pulumi.set(__self__, "analytical_storage_ttl", analytical_storage_ttl)
        if autoscale_settings is not None:
            pulumi.set(__self__, "autoscale_settings", autoscale_settings)
        if conflict_resolution_policy is not None:
            pulumi.set(__self__, "conflict_resolution_policy", conflict_resolution_policy)
        if database_name is not None:
            pulumi.set(__self__, "database_name", database_name)
        if default_ttl is not None:
            pulumi.set(__self__, "default_ttl", default_ttl)
        if indexing_policy is not None:
            pulumi.set(__self__, "indexing_policy", indexing_policy)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if partition_key_kind is not None:
            pulumi.set(__self__, "partition_key_kind", partition_key_kind)
        if partition_key_paths is not None:
            pulumi.set(__self__, "partition_key_paths", partition_key_paths)
        if partition_key_version is not None:
            pulumi.set(__self__, "partition_key_version", partition_key_version)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if throughput is not None:
            pulumi.set(__self__, "throughput", throughput)
        if unique_keys is not None:
            pulumi.set(__self__, "unique_keys", unique_keys)

    @_builtins.property
    @pulumi.getter(name="accountName")
    def account_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Cosmos DB Account to create the container within. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "account_name")

    @account_name.setter
    def account_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_name", value)

    @_builtins.property
    @pulumi.getter(name="analyticalStorageTtl")
    def analytical_storage_ttl(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The default time to live of Analytical Storage for this SQL container. If present and the value is set to `-1`, it is equal to infinity, and items don’t expire by default. If present and the value is set to some number `n` – items will expire `n` seconds after their last modified time.
        """
        return pulumi.get(self, "analytical_storage_ttl")

    @analytical_storage_ttl.setter
    def analytical_storage_ttl(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "analytical_storage_ttl", value)

    @_builtins.property
    @pulumi.getter(name="autoscaleSettings")
    def autoscale_settings(self) -> Optional[pulumi.Input['SqlContainerAutoscaleSettingsArgs']]:
        """
        An `autoscale_settings` block as defined below. This must be set upon database creation otherwise it cannot be updated without a manual destroy-apply.

        > **Note:** Switching between autoscale and manual throughput is not supported via this provider and must be completed via the Azure Portal and refreshed.
        """
        return pulumi.get(self, "autoscale_settings")

    @autoscale_settings.setter
    def autoscale_settings(self, value: Optional[pulumi.Input['SqlContainerAutoscaleSettingsArgs']]):
        pulumi.set(self, "autoscale_settings", value)

    @_builtins.property
    @pulumi.getter(name="conflictResolutionPolicy")
    def conflict_resolution_policy(self) -> Optional[pulumi.Input['SqlContainerConflictResolutionPolicyArgs']]:
        """
        A `conflict_resolution_policy` blocks as defined below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "conflict_resolution_policy")

    @conflict_resolution_policy.setter
    def conflict_resolution_policy(self, value: Optional[pulumi.Input['SqlContainerConflictResolutionPolicyArgs']]):
        pulumi.set(self, "conflict_resolution_policy", value)

    @_builtins.property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Cosmos DB SQL Database to create the container within. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "database_name")

    @database_name.setter
    def database_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "database_name", value)

    @_builtins.property
    @pulumi.getter(name="defaultTtl")
    def default_ttl(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The default time to live of SQL container. If missing, items are not expired automatically. If present and the value is set to `-1`, it is equal to infinity, and items don’t expire by default. If present and the value is set to some number `n` – items will expire `n` seconds after their last modified time.
        """
        return pulumi.get(self, "default_ttl")

    @default_ttl.setter
    def default_ttl(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "default_ttl", value)

    @_builtins.property
    @pulumi.getter(name="indexingPolicy")
    def indexing_policy(self) -> Optional[pulumi.Input['SqlContainerIndexingPolicyArgs']]:
        """
        An `indexing_policy` block as defined below.
        """
        return pulumi.get(self, "indexing_policy")

    @indexing_policy.setter
    def indexing_policy(self, value: Optional[pulumi.Input['SqlContainerIndexingPolicyArgs']]):
        pulumi.set(self, "indexing_policy", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the Cosmos DB SQL Container. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="partitionKeyKind")
    def partition_key_kind(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Define a partition key kind. Possible values are `Hash` and `MultiHash`. Defaults to `Hash`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "partition_key_kind")

    @partition_key_kind.setter
    def partition_key_kind(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "partition_key_kind", value)

    @_builtins.property
    @pulumi.getter(name="partitionKeyPaths")
    def partition_key_paths(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of partition key paths. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "partition_key_paths")

    @partition_key_paths.setter
    def partition_key_paths(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "partition_key_paths", value)

    @_builtins.property
    @pulumi.getter(name="partitionKeyVersion")
    def partition_key_version(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Define a partition key version. Possible values are `1`and `2`. This should be set to `2` in order to use large partition keys.

        > **Note:** If `partition_key_version` is not specified when creating a new resource, you can update `partition_key_version` to `1`, updating to `2` forces a new resource to be created.
        """
        return pulumi.get(self, "partition_key_version")

    @partition_key_version.setter
    def partition_key_version(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "partition_key_version", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the resource group in which the Cosmos DB SQL Container is created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter
    def throughput(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The throughput of SQL container (RU/s). Must be set in increments of `100`. The minimum value is `400`. This must be set upon container creation otherwise it cannot be updated without a manual resource destroy-apply.
        """
        return pulumi.get(self, "throughput")

    @throughput.setter
    def throughput(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "throughput", value)

    @_builtins.property
    @pulumi.getter(name="uniqueKeys")
    def unique_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SqlContainerUniqueKeyArgs']]]]:
        """
        One or more `unique_key` blocks as defined below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "unique_keys")

    @unique_keys.setter
    def unique_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SqlContainerUniqueKeyArgs']]]]):
        pulumi.set(self, "unique_keys", value)


@pulumi.type_token("azure:cosmosdb/sqlContainer:SqlContainer")
class SqlContainer(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_name: Optional[pulumi.Input[_builtins.str]] = None,
                 analytical_storage_ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 autoscale_settings: Optional[pulumi.Input[Union['SqlContainerAutoscaleSettingsArgs', 'SqlContainerAutoscaleSettingsArgsDict']]] = None,
                 conflict_resolution_policy: Optional[pulumi.Input[Union['SqlContainerConflictResolutionPolicyArgs', 'SqlContainerConflictResolutionPolicyArgsDict']]] = None,
                 database_name: Optional[pulumi.Input[_builtins.str]] = None,
                 default_ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 indexing_policy: Optional[pulumi.Input[Union['SqlContainerIndexingPolicyArgs', 'SqlContainerIndexingPolicyArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 partition_key_kind: Optional[pulumi.Input[_builtins.str]] = None,
                 partition_key_paths: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 partition_key_version: Optional[pulumi.Input[_builtins.int]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 throughput: Optional[pulumi.Input[_builtins.int]] = None,
                 unique_keys: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SqlContainerUniqueKeyArgs', 'SqlContainerUniqueKeyArgsDict']]]]] = None,
                 __props__=None):
        """
        Manages a SQL Container within a Cosmos DB Account.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.cosmosdb.get_account(name="tfex-cosmosdb-account",
            resource_group_name="tfex-cosmosdb-account-rg")
        example_sql_database = azure.cosmosdb.SqlDatabase("example",
            name="example-acsd",
            resource_group_name=example.resource_group_name,
            account_name=example.name)
        example_sql_container = azure.cosmosdb.SqlContainer("example",
            name="example-container",
            resource_group_name=example.resource_group_name,
            account_name=example.name,
            database_name=example_sql_database.name,
            partition_key_paths=["/definition/id"],
            partition_key_version=1,
            throughput=400,
            indexing_policy={
                "indexing_mode": "consistent",
                "included_paths": [
                    {
                        "path": "/*",
                    },
                    {
                        "path": "/included/?",
                    },
                ],
                "excluded_paths": [{
                    "path": "/excluded/?",
                }],
            },
            unique_keys=[{
                "paths": [
                    "/definition/idlong",
                    "/definition/idshort",
                ],
            }])
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.DocumentDB`: 2024-08-15

        ## Import

        Cosmos SQL Containers can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:cosmosdb/sqlContainer:SqlContainer example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.DocumentDB/databaseAccounts/account1/sqlDatabases/database1/containers/container1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_name: The name of the Cosmos DB Account to create the container within. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] analytical_storage_ttl: The default time to live of Analytical Storage for this SQL container. If present and the value is set to `-1`, it is equal to infinity, and items don’t expire by default. If present and the value is set to some number `n` – items will expire `n` seconds after their last modified time.
        :param pulumi.Input[Union['SqlContainerAutoscaleSettingsArgs', 'SqlContainerAutoscaleSettingsArgsDict']] autoscale_settings: An `autoscale_settings` block as defined below. This must be set upon database creation otherwise it cannot be updated without a manual destroy-apply.
               
               > **Note:** Switching between autoscale and manual throughput is not supported via this provider and must be completed via the Azure Portal and refreshed.
        :param pulumi.Input[Union['SqlContainerConflictResolutionPolicyArgs', 'SqlContainerConflictResolutionPolicyArgsDict']] conflict_resolution_policy: A `conflict_resolution_policy` blocks as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] database_name: The name of the Cosmos DB SQL Database to create the container within. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] default_ttl: The default time to live of SQL container. If missing, items are not expired automatically. If present and the value is set to `-1`, it is equal to infinity, and items don’t expire by default. If present and the value is set to some number `n` – items will expire `n` seconds after their last modified time.
        :param pulumi.Input[Union['SqlContainerIndexingPolicyArgs', 'SqlContainerIndexingPolicyArgsDict']] indexing_policy: An `indexing_policy` block as defined below.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Cosmos DB SQL Container. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] partition_key_kind: Define a partition key kind. Possible values are `Hash` and `MultiHash`. Defaults to `Hash`. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] partition_key_paths: A list of partition key paths. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] partition_key_version: Define a partition key version. Possible values are `1`and `2`. This should be set to `2` in order to use large partition keys.
               
               > **Note:** If `partition_key_version` is not specified when creating a new resource, you can update `partition_key_version` to `1`, updating to `2` forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which the Cosmos DB SQL Container is created. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] throughput: The throughput of SQL container (RU/s). Must be set in increments of `100`. The minimum value is `400`. This must be set upon container creation otherwise it cannot be updated without a manual resource destroy-apply.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SqlContainerUniqueKeyArgs', 'SqlContainerUniqueKeyArgsDict']]]] unique_keys: One or more `unique_key` blocks as defined below. Changing this forces a new resource to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SqlContainerArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a SQL Container within a Cosmos DB Account.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.cosmosdb.get_account(name="tfex-cosmosdb-account",
            resource_group_name="tfex-cosmosdb-account-rg")
        example_sql_database = azure.cosmosdb.SqlDatabase("example",
            name="example-acsd",
            resource_group_name=example.resource_group_name,
            account_name=example.name)
        example_sql_container = azure.cosmosdb.SqlContainer("example",
            name="example-container",
            resource_group_name=example.resource_group_name,
            account_name=example.name,
            database_name=example_sql_database.name,
            partition_key_paths=["/definition/id"],
            partition_key_version=1,
            throughput=400,
            indexing_policy={
                "indexing_mode": "consistent",
                "included_paths": [
                    {
                        "path": "/*",
                    },
                    {
                        "path": "/included/?",
                    },
                ],
                "excluded_paths": [{
                    "path": "/excluded/?",
                }],
            },
            unique_keys=[{
                "paths": [
                    "/definition/idlong",
                    "/definition/idshort",
                ],
            }])
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.DocumentDB`: 2024-08-15

        ## Import

        Cosmos SQL Containers can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:cosmosdb/sqlContainer:SqlContainer example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.DocumentDB/databaseAccounts/account1/sqlDatabases/database1/containers/container1
        ```

        :param str resource_name: The name of the resource.
        :param SqlContainerArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SqlContainerArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_name: Optional[pulumi.Input[_builtins.str]] = None,
                 analytical_storage_ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 autoscale_settings: Optional[pulumi.Input[Union['SqlContainerAutoscaleSettingsArgs', 'SqlContainerAutoscaleSettingsArgsDict']]] = None,
                 conflict_resolution_policy: Optional[pulumi.Input[Union['SqlContainerConflictResolutionPolicyArgs', 'SqlContainerConflictResolutionPolicyArgsDict']]] = None,
                 database_name: Optional[pulumi.Input[_builtins.str]] = None,
                 default_ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 indexing_policy: Optional[pulumi.Input[Union['SqlContainerIndexingPolicyArgs', 'SqlContainerIndexingPolicyArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 partition_key_kind: Optional[pulumi.Input[_builtins.str]] = None,
                 partition_key_paths: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 partition_key_version: Optional[pulumi.Input[_builtins.int]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 throughput: Optional[pulumi.Input[_builtins.int]] = None,
                 unique_keys: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SqlContainerUniqueKeyArgs', 'SqlContainerUniqueKeyArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SqlContainerArgs.__new__(SqlContainerArgs)

            if account_name is None and not opts.urn:
                raise TypeError("Missing required property 'account_name'")
            __props__.__dict__["account_name"] = account_name
            __props__.__dict__["analytical_storage_ttl"] = analytical_storage_ttl
            __props__.__dict__["autoscale_settings"] = autoscale_settings
            __props__.__dict__["conflict_resolution_policy"] = conflict_resolution_policy
            if database_name is None and not opts.urn:
                raise TypeError("Missing required property 'database_name'")
            __props__.__dict__["database_name"] = database_name
            __props__.__dict__["default_ttl"] = default_ttl
            __props__.__dict__["indexing_policy"] = indexing_policy
            __props__.__dict__["name"] = name
            __props__.__dict__["partition_key_kind"] = partition_key_kind
            if partition_key_paths is None and not opts.urn:
                raise TypeError("Missing required property 'partition_key_paths'")
            __props__.__dict__["partition_key_paths"] = partition_key_paths
            __props__.__dict__["partition_key_version"] = partition_key_version
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["throughput"] = throughput
            __props__.__dict__["unique_keys"] = unique_keys
        super(SqlContainer, __self__).__init__(
            'azure:cosmosdb/sqlContainer:SqlContainer',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_name: Optional[pulumi.Input[_builtins.str]] = None,
            analytical_storage_ttl: Optional[pulumi.Input[_builtins.int]] = None,
            autoscale_settings: Optional[pulumi.Input[Union['SqlContainerAutoscaleSettingsArgs', 'SqlContainerAutoscaleSettingsArgsDict']]] = None,
            conflict_resolution_policy: Optional[pulumi.Input[Union['SqlContainerConflictResolutionPolicyArgs', 'SqlContainerConflictResolutionPolicyArgsDict']]] = None,
            database_name: Optional[pulumi.Input[_builtins.str]] = None,
            default_ttl: Optional[pulumi.Input[_builtins.int]] = None,
            indexing_policy: Optional[pulumi.Input[Union['SqlContainerIndexingPolicyArgs', 'SqlContainerIndexingPolicyArgsDict']]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            partition_key_kind: Optional[pulumi.Input[_builtins.str]] = None,
            partition_key_paths: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            partition_key_version: Optional[pulumi.Input[_builtins.int]] = None,
            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            throughput: Optional[pulumi.Input[_builtins.int]] = None,
            unique_keys: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SqlContainerUniqueKeyArgs', 'SqlContainerUniqueKeyArgsDict']]]]] = None) -> 'SqlContainer':
        """
        Get an existing SqlContainer resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_name: The name of the Cosmos DB Account to create the container within. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] analytical_storage_ttl: The default time to live of Analytical Storage for this SQL container. If present and the value is set to `-1`, it is equal to infinity, and items don’t expire by default. If present and the value is set to some number `n` – items will expire `n` seconds after their last modified time.
        :param pulumi.Input[Union['SqlContainerAutoscaleSettingsArgs', 'SqlContainerAutoscaleSettingsArgsDict']] autoscale_settings: An `autoscale_settings` block as defined below. This must be set upon database creation otherwise it cannot be updated without a manual destroy-apply.
               
               > **Note:** Switching between autoscale and manual throughput is not supported via this provider and must be completed via the Azure Portal and refreshed.
        :param pulumi.Input[Union['SqlContainerConflictResolutionPolicyArgs', 'SqlContainerConflictResolutionPolicyArgsDict']] conflict_resolution_policy: A `conflict_resolution_policy` blocks as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] database_name: The name of the Cosmos DB SQL Database to create the container within. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] default_ttl: The default time to live of SQL container. If missing, items are not expired automatically. If present and the value is set to `-1`, it is equal to infinity, and items don’t expire by default. If present and the value is set to some number `n` – items will expire `n` seconds after their last modified time.
        :param pulumi.Input[Union['SqlContainerIndexingPolicyArgs', 'SqlContainerIndexingPolicyArgsDict']] indexing_policy: An `indexing_policy` block as defined below.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Cosmos DB SQL Container. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] partition_key_kind: Define a partition key kind. Possible values are `Hash` and `MultiHash`. Defaults to `Hash`. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] partition_key_paths: A list of partition key paths. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] partition_key_version: Define a partition key version. Possible values are `1`and `2`. This should be set to `2` in order to use large partition keys.
               
               > **Note:** If `partition_key_version` is not specified when creating a new resource, you can update `partition_key_version` to `1`, updating to `2` forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which the Cosmos DB SQL Container is created. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] throughput: The throughput of SQL container (RU/s). Must be set in increments of `100`. The minimum value is `400`. This must be set upon container creation otherwise it cannot be updated without a manual resource destroy-apply.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SqlContainerUniqueKeyArgs', 'SqlContainerUniqueKeyArgsDict']]]] unique_keys: One or more `unique_key` blocks as defined below. Changing this forces a new resource to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SqlContainerState.__new__(_SqlContainerState)

        __props__.__dict__["account_name"] = account_name
        __props__.__dict__["analytical_storage_ttl"] = analytical_storage_ttl
        __props__.__dict__["autoscale_settings"] = autoscale_settings
        __props__.__dict__["conflict_resolution_policy"] = conflict_resolution_policy
        __props__.__dict__["database_name"] = database_name
        __props__.__dict__["default_ttl"] = default_ttl
        __props__.__dict__["indexing_policy"] = indexing_policy
        __props__.__dict__["name"] = name
        __props__.__dict__["partition_key_kind"] = partition_key_kind
        __props__.__dict__["partition_key_paths"] = partition_key_paths
        __props__.__dict__["partition_key_version"] = partition_key_version
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["throughput"] = throughput
        __props__.__dict__["unique_keys"] = unique_keys
        return SqlContainer(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accountName")
    def account_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Cosmos DB Account to create the container within. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "account_name")

    @_builtins.property
    @pulumi.getter(name="analyticalStorageTtl")
    def analytical_storage_ttl(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The default time to live of Analytical Storage for this SQL container. If present and the value is set to `-1`, it is equal to infinity, and items don’t expire by default. If present and the value is set to some number `n` – items will expire `n` seconds after their last modified time.
        """
        return pulumi.get(self, "analytical_storage_ttl")

    @_builtins.property
    @pulumi.getter(name="autoscaleSettings")
    def autoscale_settings(self) -> pulumi.Output[Optional['outputs.SqlContainerAutoscaleSettings']]:
        """
        An `autoscale_settings` block as defined below. This must be set upon database creation otherwise it cannot be updated without a manual destroy-apply.

        > **Note:** Switching between autoscale and manual throughput is not supported via this provider and must be completed via the Azure Portal and refreshed.
        """
        return pulumi.get(self, "autoscale_settings")

    @_builtins.property
    @pulumi.getter(name="conflictResolutionPolicy")
    def conflict_resolution_policy(self) -> pulumi.Output['outputs.SqlContainerConflictResolutionPolicy']:
        """
        A `conflict_resolution_policy` blocks as defined below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "conflict_resolution_policy")

    @_builtins.property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Cosmos DB SQL Database to create the container within. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "database_name")

    @_builtins.property
    @pulumi.getter(name="defaultTtl")
    def default_ttl(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The default time to live of SQL container. If missing, items are not expired automatically. If present and the value is set to `-1`, it is equal to infinity, and items don’t expire by default. If present and the value is set to some number `n` – items will expire `n` seconds after their last modified time.
        """
        return pulumi.get(self, "default_ttl")

    @_builtins.property
    @pulumi.getter(name="indexingPolicy")
    def indexing_policy(self) -> pulumi.Output['outputs.SqlContainerIndexingPolicy']:
        """
        An `indexing_policy` block as defined below.
        """
        return pulumi.get(self, "indexing_policy")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of the Cosmos DB SQL Container. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="partitionKeyKind")
    def partition_key_kind(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Define a partition key kind. Possible values are `Hash` and `MultiHash`. Defaults to `Hash`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "partition_key_kind")

    @_builtins.property
    @pulumi.getter(name="partitionKeyPaths")
    def partition_key_paths(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        A list of partition key paths. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "partition_key_paths")

    @_builtins.property
    @pulumi.getter(name="partitionKeyVersion")
    def partition_key_version(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Define a partition key version. Possible values are `1`and `2`. This should be set to `2` in order to use large partition keys.

        > **Note:** If `partition_key_version` is not specified when creating a new resource, you can update `partition_key_version` to `1`, updating to `2` forces a new resource to be created.
        """
        return pulumi.get(self, "partition_key_version")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the resource group in which the Cosmos DB SQL Container is created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter
    def throughput(self) -> pulumi.Output[_builtins.int]:
        """
        The throughput of SQL container (RU/s). Must be set in increments of `100`. The minimum value is `400`. This must be set upon container creation otherwise it cannot be updated without a manual resource destroy-apply.
        """
        return pulumi.get(self, "throughput")

    @_builtins.property
    @pulumi.getter(name="uniqueKeys")
    def unique_keys(self) -> pulumi.Output[Optional[Sequence['outputs.SqlContainerUniqueKey']]]:
        """
        One or more `unique_key` blocks as defined below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "unique_keys")

