# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['SqlDedicatedGatewayArgs', 'SqlDedicatedGateway']

@pulumi.input_type
class SqlDedicatedGatewayArgs:
    def __init__(__self__, *,
                 cosmosdb_account_id: pulumi.Input[_builtins.str],
                 instance_count: pulumi.Input[_builtins.int],
                 instance_size: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a SqlDedicatedGateway resource.
        :param pulumi.Input[_builtins.str] cosmosdb_account_id: The resource ID of the CosmosDB Account. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] instance_count: The instance count for the CosmosDB SQL Dedicated Gateway. Possible value is between `1` and `5`.
        :param pulumi.Input[_builtins.str] instance_size: The instance size for the CosmosDB SQL Dedicated Gateway. Changing this forces a new resource to be created. Possible values are `Cosmos.D4s`, `Cosmos.D8s` and `Cosmos.D16s`.
        """
        pulumi.set(__self__, "cosmosdb_account_id", cosmosdb_account_id)
        pulumi.set(__self__, "instance_count", instance_count)
        pulumi.set(__self__, "instance_size", instance_size)

    @_builtins.property
    @pulumi.getter(name="cosmosdbAccountId")
    def cosmosdb_account_id(self) -> pulumi.Input[_builtins.str]:
        """
        The resource ID of the CosmosDB Account. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "cosmosdb_account_id")

    @cosmosdb_account_id.setter
    def cosmosdb_account_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "cosmosdb_account_id", value)

    @_builtins.property
    @pulumi.getter(name="instanceCount")
    def instance_count(self) -> pulumi.Input[_builtins.int]:
        """
        The instance count for the CosmosDB SQL Dedicated Gateway. Possible value is between `1` and `5`.
        """
        return pulumi.get(self, "instance_count")

    @instance_count.setter
    def instance_count(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "instance_count", value)

    @_builtins.property
    @pulumi.getter(name="instanceSize")
    def instance_size(self) -> pulumi.Input[_builtins.str]:
        """
        The instance size for the CosmosDB SQL Dedicated Gateway. Changing this forces a new resource to be created. Possible values are `Cosmos.D4s`, `Cosmos.D8s` and `Cosmos.D16s`.
        """
        return pulumi.get(self, "instance_size")

    @instance_size.setter
    def instance_size(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "instance_size", value)


@pulumi.input_type
class _SqlDedicatedGatewayState:
    def __init__(__self__, *,
                 cosmosdb_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_count: Optional[pulumi.Input[_builtins.int]] = None,
                 instance_size: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering SqlDedicatedGateway resources.
        :param pulumi.Input[_builtins.str] cosmosdb_account_id: The resource ID of the CosmosDB Account. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] instance_count: The instance count for the CosmosDB SQL Dedicated Gateway. Possible value is between `1` and `5`.
        :param pulumi.Input[_builtins.str] instance_size: The instance size for the CosmosDB SQL Dedicated Gateway. Changing this forces a new resource to be created. Possible values are `Cosmos.D4s`, `Cosmos.D8s` and `Cosmos.D16s`.
        """
        if cosmosdb_account_id is not None:
            pulumi.set(__self__, "cosmosdb_account_id", cosmosdb_account_id)
        if instance_count is not None:
            pulumi.set(__self__, "instance_count", instance_count)
        if instance_size is not None:
            pulumi.set(__self__, "instance_size", instance_size)

    @_builtins.property
    @pulumi.getter(name="cosmosdbAccountId")
    def cosmosdb_account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource ID of the CosmosDB Account. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "cosmosdb_account_id")

    @cosmosdb_account_id.setter
    def cosmosdb_account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cosmosdb_account_id", value)

    @_builtins.property
    @pulumi.getter(name="instanceCount")
    def instance_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The instance count for the CosmosDB SQL Dedicated Gateway. Possible value is between `1` and `5`.
        """
        return pulumi.get(self, "instance_count")

    @instance_count.setter
    def instance_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "instance_count", value)

    @_builtins.property
    @pulumi.getter(name="instanceSize")
    def instance_size(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The instance size for the CosmosDB SQL Dedicated Gateway. Changing this forces a new resource to be created. Possible values are `Cosmos.D4s`, `Cosmos.D8s` and `Cosmos.D16s`.
        """
        return pulumi.get(self, "instance_size")

    @instance_size.setter
    def instance_size(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_size", value)


@pulumi.type_token("azure:cosmosdb/sqlDedicatedGateway:SqlDedicatedGateway")
class SqlDedicatedGateway(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cosmosdb_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_count: Optional[pulumi.Input[_builtins.int]] = None,
                 instance_size: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a SQL Dedicated Gateway within a Cosmos DB Account.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resource-group",
            location="West Europe")
        example_account = azure.cosmosdb.Account("example",
            name="example-ca",
            location=example.location,
            resource_group_name=example.name,
            offer_type="Standard",
            kind="GlobalDocumentDB",
            consistency_policy={
                "consistency_level": "BoundedStaleness",
            },
            geo_locations=[{
                "location": example.location,
                "failover_priority": 0,
            }])
        example_sql_dedicated_gateway = azure.cosmosdb.SqlDedicatedGateway("example",
            cosmosdb_account_id=example_account.id,
            instance_count=1,
            instance_size="Cosmos.D4s")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.DocumentDB`: 2022-05-15

        ## Import

        CosmosDB SQL Dedicated Gateways can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:cosmosdb/sqlDedicatedGateway:SqlDedicatedGateway example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resourceGroup1/providers/Microsoft.DocumentDB/databaseAccounts/account1/services/SqlDedicatedGateway
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cosmosdb_account_id: The resource ID of the CosmosDB Account. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] instance_count: The instance count for the CosmosDB SQL Dedicated Gateway. Possible value is between `1` and `5`.
        :param pulumi.Input[_builtins.str] instance_size: The instance size for the CosmosDB SQL Dedicated Gateway. Changing this forces a new resource to be created. Possible values are `Cosmos.D4s`, `Cosmos.D8s` and `Cosmos.D16s`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SqlDedicatedGatewayArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a SQL Dedicated Gateway within a Cosmos DB Account.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resource-group",
            location="West Europe")
        example_account = azure.cosmosdb.Account("example",
            name="example-ca",
            location=example.location,
            resource_group_name=example.name,
            offer_type="Standard",
            kind="GlobalDocumentDB",
            consistency_policy={
                "consistency_level": "BoundedStaleness",
            },
            geo_locations=[{
                "location": example.location,
                "failover_priority": 0,
            }])
        example_sql_dedicated_gateway = azure.cosmosdb.SqlDedicatedGateway("example",
            cosmosdb_account_id=example_account.id,
            instance_count=1,
            instance_size="Cosmos.D4s")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.DocumentDB`: 2022-05-15

        ## Import

        CosmosDB SQL Dedicated Gateways can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:cosmosdb/sqlDedicatedGateway:SqlDedicatedGateway example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resourceGroup1/providers/Microsoft.DocumentDB/databaseAccounts/account1/services/SqlDedicatedGateway
        ```

        :param str resource_name: The name of the resource.
        :param SqlDedicatedGatewayArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SqlDedicatedGatewayArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cosmosdb_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_count: Optional[pulumi.Input[_builtins.int]] = None,
                 instance_size: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SqlDedicatedGatewayArgs.__new__(SqlDedicatedGatewayArgs)

            if cosmosdb_account_id is None and not opts.urn:
                raise TypeError("Missing required property 'cosmosdb_account_id'")
            __props__.__dict__["cosmosdb_account_id"] = cosmosdb_account_id
            if instance_count is None and not opts.urn:
                raise TypeError("Missing required property 'instance_count'")
            __props__.__dict__["instance_count"] = instance_count
            if instance_size is None and not opts.urn:
                raise TypeError("Missing required property 'instance_size'")
            __props__.__dict__["instance_size"] = instance_size
        super(SqlDedicatedGateway, __self__).__init__(
            'azure:cosmosdb/sqlDedicatedGateway:SqlDedicatedGateway',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cosmosdb_account_id: Optional[pulumi.Input[_builtins.str]] = None,
            instance_count: Optional[pulumi.Input[_builtins.int]] = None,
            instance_size: Optional[pulumi.Input[_builtins.str]] = None) -> 'SqlDedicatedGateway':
        """
        Get an existing SqlDedicatedGateway resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cosmosdb_account_id: The resource ID of the CosmosDB Account. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] instance_count: The instance count for the CosmosDB SQL Dedicated Gateway. Possible value is between `1` and `5`.
        :param pulumi.Input[_builtins.str] instance_size: The instance size for the CosmosDB SQL Dedicated Gateway. Changing this forces a new resource to be created. Possible values are `Cosmos.D4s`, `Cosmos.D8s` and `Cosmos.D16s`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SqlDedicatedGatewayState.__new__(_SqlDedicatedGatewayState)

        __props__.__dict__["cosmosdb_account_id"] = cosmosdb_account_id
        __props__.__dict__["instance_count"] = instance_count
        __props__.__dict__["instance_size"] = instance_size
        return SqlDedicatedGateway(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="cosmosdbAccountId")
    def cosmosdb_account_id(self) -> pulumi.Output[_builtins.str]:
        """
        The resource ID of the CosmosDB Account. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "cosmosdb_account_id")

    @_builtins.property
    @pulumi.getter(name="instanceCount")
    def instance_count(self) -> pulumi.Output[_builtins.int]:
        """
        The instance count for the CosmosDB SQL Dedicated Gateway. Possible value is between `1` and `5`.
        """
        return pulumi.get(self, "instance_count")

    @_builtins.property
    @pulumi.getter(name="instanceSize")
    def instance_size(self) -> pulumi.Output[_builtins.str]:
        """
        The instance size for the CosmosDB SQL Dedicated Gateway. Changing this forces a new resource to be created. Possible values are `Cosmos.D4s`, `Cosmos.D8s` and `Cosmos.D16s`.
        """
        return pulumi.get(self, "instance_size")

