# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['AnomalyAlertArgs', 'AnomalyAlert']

@pulumi.input_type
class AnomalyAlertArgs:
    def __init__(__self__, *,
                 display_name: pulumi.Input[_builtins.str],
                 email_addresses: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 email_subject: pulumi.Input[_builtins.str],
                 message: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 notification_email: Optional[pulumi.Input[_builtins.str]] = None,
                 subscription_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a AnomalyAlert resource.
        :param pulumi.Input[_builtins.str] display_name: The display name which should be used for this Cost Anomaly Alert.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] email_addresses: Specifies a list of email addresses which the Anomaly Alerts are send to.
        :param pulumi.Input[_builtins.str] email_subject: The email subject of the Cost Anomaly Alerts. Maximum length of the subject is 70.
        :param pulumi.Input[_builtins.str] message: The message of the Cost Anomaly Alert. Maximum length of the message is 250.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Cost Anomaly Alert. Changing this forces a new resource to be created. The name can contain only lowercase letters, numbers and hyphens.
        :param pulumi.Input[_builtins.str] notification_email: The email address of the point of contact that should get the unsubscribe requests and notification emails.
        :param pulumi.Input[_builtins.str] subscription_id: The ID of the Subscription this Cost Anomaly Alert is scoped to. Changing this forces a new resource to be created. When not supplied this defaults to the subscription configured in the provider.
        """
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "email_addresses", email_addresses)
        pulumi.set(__self__, "email_subject", email_subject)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if notification_email is not None:
            pulumi.set(__self__, "notification_email", notification_email)
        if subscription_id is not None:
            pulumi.set(__self__, "subscription_id", subscription_id)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[_builtins.str]:
        """
        The display name which should be used for this Cost Anomaly Alert.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="emailAddresses")
    def email_addresses(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        Specifies a list of email addresses which the Anomaly Alerts are send to.
        """
        return pulumi.get(self, "email_addresses")

    @email_addresses.setter
    def email_addresses(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "email_addresses", value)

    @_builtins.property
    @pulumi.getter(name="emailSubject")
    def email_subject(self) -> pulumi.Input[_builtins.str]:
        """
        The email subject of the Cost Anomaly Alerts. Maximum length of the subject is 70.
        """
        return pulumi.get(self, "email_subject")

    @email_subject.setter
    def email_subject(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "email_subject", value)

    @_builtins.property
    @pulumi.getter
    def message(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The message of the Cost Anomaly Alert. Maximum length of the message is 250.
        """
        return pulumi.get(self, "message")

    @message.setter
    def message(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "message", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Cost Anomaly Alert. Changing this forces a new resource to be created. The name can contain only lowercase letters, numbers and hyphens.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="notificationEmail")
    def notification_email(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The email address of the point of contact that should get the unsubscribe requests and notification emails.
        """
        return pulumi.get(self, "notification_email")

    @notification_email.setter
    def notification_email(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "notification_email", value)

    @_builtins.property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Subscription this Cost Anomaly Alert is scoped to. Changing this forces a new resource to be created. When not supplied this defaults to the subscription configured in the provider.
        """
        return pulumi.get(self, "subscription_id")

    @subscription_id.setter
    def subscription_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subscription_id", value)


@pulumi.input_type
class _AnomalyAlertState:
    def __init__(__self__, *,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 email_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 email_subject: Optional[pulumi.Input[_builtins.str]] = None,
                 message: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 notification_email: Optional[pulumi.Input[_builtins.str]] = None,
                 subscription_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering AnomalyAlert resources.
        :param pulumi.Input[_builtins.str] display_name: The display name which should be used for this Cost Anomaly Alert.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] email_addresses: Specifies a list of email addresses which the Anomaly Alerts are send to.
        :param pulumi.Input[_builtins.str] email_subject: The email subject of the Cost Anomaly Alerts. Maximum length of the subject is 70.
        :param pulumi.Input[_builtins.str] message: The message of the Cost Anomaly Alert. Maximum length of the message is 250.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Cost Anomaly Alert. Changing this forces a new resource to be created. The name can contain only lowercase letters, numbers and hyphens.
        :param pulumi.Input[_builtins.str] notification_email: The email address of the point of contact that should get the unsubscribe requests and notification emails.
        :param pulumi.Input[_builtins.str] subscription_id: The ID of the Subscription this Cost Anomaly Alert is scoped to. Changing this forces a new resource to be created. When not supplied this defaults to the subscription configured in the provider.
        """
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if email_addresses is not None:
            pulumi.set(__self__, "email_addresses", email_addresses)
        if email_subject is not None:
            pulumi.set(__self__, "email_subject", email_subject)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if notification_email is not None:
            pulumi.set(__self__, "notification_email", notification_email)
        if subscription_id is not None:
            pulumi.set(__self__, "subscription_id", subscription_id)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The display name which should be used for this Cost Anomaly Alert.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="emailAddresses")
    def email_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies a list of email addresses which the Anomaly Alerts are send to.
        """
        return pulumi.get(self, "email_addresses")

    @email_addresses.setter
    def email_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "email_addresses", value)

    @_builtins.property
    @pulumi.getter(name="emailSubject")
    def email_subject(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The email subject of the Cost Anomaly Alerts. Maximum length of the subject is 70.
        """
        return pulumi.get(self, "email_subject")

    @email_subject.setter
    def email_subject(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "email_subject", value)

    @_builtins.property
    @pulumi.getter
    def message(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The message of the Cost Anomaly Alert. Maximum length of the message is 250.
        """
        return pulumi.get(self, "message")

    @message.setter
    def message(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "message", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Cost Anomaly Alert. Changing this forces a new resource to be created. The name can contain only lowercase letters, numbers and hyphens.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="notificationEmail")
    def notification_email(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The email address of the point of contact that should get the unsubscribe requests and notification emails.
        """
        return pulumi.get(self, "notification_email")

    @notification_email.setter
    def notification_email(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "notification_email", value)

    @_builtins.property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Subscription this Cost Anomaly Alert is scoped to. Changing this forces a new resource to be created. When not supplied this defaults to the subscription configured in the provider.
        """
        return pulumi.get(self, "subscription_id")

    @subscription_id.setter
    def subscription_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subscription_id", value)


@pulumi.type_token("azure:costmanagement/anomalyAlert:AnomalyAlert")
class AnomalyAlert(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 email_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 email_subject: Optional[pulumi.Input[_builtins.str]] = None,
                 message: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 notification_email: Optional[pulumi.Input[_builtins.str]] = None,
                 subscription_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a Cost Anomaly Alert.

        > **Note:** Anomaly alerts are sent based on the current access of the rule creator at the time that the email is sent. Learn more [here](https://learn.microsoft.com/en-us/azure/cost-management-billing/understand/analyze-unexpected-charges#create-an-anomaly-alert).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.costmanagement.AnomalyAlert("example",
            name="alertname",
            display_name="Alert DisplayName",
            subscription_id="/subscriptions/00000000-0000-0000-0000-000000000000",
            email_subject="My Test Anomaly Alert",
            email_addresses=["example@test.net"])
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.CostManagement`: 2023-08-01

        ## Import

        Cost Anomaly Alerts can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:costmanagement/anomalyAlert:AnomalyAlert example /subscriptions/00000000-0000-0000-0000-000000000000/providers/Microsoft.CostManagement/scheduledActions/dailyanomalybyresourcegroup
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] display_name: The display name which should be used for this Cost Anomaly Alert.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] email_addresses: Specifies a list of email addresses which the Anomaly Alerts are send to.
        :param pulumi.Input[_builtins.str] email_subject: The email subject of the Cost Anomaly Alerts. Maximum length of the subject is 70.
        :param pulumi.Input[_builtins.str] message: The message of the Cost Anomaly Alert. Maximum length of the message is 250.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Cost Anomaly Alert. Changing this forces a new resource to be created. The name can contain only lowercase letters, numbers and hyphens.
        :param pulumi.Input[_builtins.str] notification_email: The email address of the point of contact that should get the unsubscribe requests and notification emails.
        :param pulumi.Input[_builtins.str] subscription_id: The ID of the Subscription this Cost Anomaly Alert is scoped to. Changing this forces a new resource to be created. When not supplied this defaults to the subscription configured in the provider.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AnomalyAlertArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Cost Anomaly Alert.

        > **Note:** Anomaly alerts are sent based on the current access of the rule creator at the time that the email is sent. Learn more [here](https://learn.microsoft.com/en-us/azure/cost-management-billing/understand/analyze-unexpected-charges#create-an-anomaly-alert).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.costmanagement.AnomalyAlert("example",
            name="alertname",
            display_name="Alert DisplayName",
            subscription_id="/subscriptions/00000000-0000-0000-0000-000000000000",
            email_subject="My Test Anomaly Alert",
            email_addresses=["example@test.net"])
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.CostManagement`: 2023-08-01

        ## Import

        Cost Anomaly Alerts can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:costmanagement/anomalyAlert:AnomalyAlert example /subscriptions/00000000-0000-0000-0000-000000000000/providers/Microsoft.CostManagement/scheduledActions/dailyanomalybyresourcegroup
        ```

        :param str resource_name: The name of the resource.
        :param AnomalyAlertArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AnomalyAlertArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 email_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 email_subject: Optional[pulumi.Input[_builtins.str]] = None,
                 message: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 notification_email: Optional[pulumi.Input[_builtins.str]] = None,
                 subscription_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AnomalyAlertArgs.__new__(AnomalyAlertArgs)

            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            if email_addresses is None and not opts.urn:
                raise TypeError("Missing required property 'email_addresses'")
            __props__.__dict__["email_addresses"] = email_addresses
            if email_subject is None and not opts.urn:
                raise TypeError("Missing required property 'email_subject'")
            __props__.__dict__["email_subject"] = email_subject
            __props__.__dict__["message"] = message
            __props__.__dict__["name"] = name
            __props__.__dict__["notification_email"] = notification_email
            __props__.__dict__["subscription_id"] = subscription_id
        super(AnomalyAlert, __self__).__init__(
            'azure:costmanagement/anomalyAlert:AnomalyAlert',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            email_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            email_subject: Optional[pulumi.Input[_builtins.str]] = None,
            message: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            notification_email: Optional[pulumi.Input[_builtins.str]] = None,
            subscription_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'AnomalyAlert':
        """
        Get an existing AnomalyAlert resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] display_name: The display name which should be used for this Cost Anomaly Alert.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] email_addresses: Specifies a list of email addresses which the Anomaly Alerts are send to.
        :param pulumi.Input[_builtins.str] email_subject: The email subject of the Cost Anomaly Alerts. Maximum length of the subject is 70.
        :param pulumi.Input[_builtins.str] message: The message of the Cost Anomaly Alert. Maximum length of the message is 250.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Cost Anomaly Alert. Changing this forces a new resource to be created. The name can contain only lowercase letters, numbers and hyphens.
        :param pulumi.Input[_builtins.str] notification_email: The email address of the point of contact that should get the unsubscribe requests and notification emails.
        :param pulumi.Input[_builtins.str] subscription_id: The ID of the Subscription this Cost Anomaly Alert is scoped to. Changing this forces a new resource to be created. When not supplied this defaults to the subscription configured in the provider.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AnomalyAlertState.__new__(_AnomalyAlertState)

        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["email_addresses"] = email_addresses
        __props__.__dict__["email_subject"] = email_subject
        __props__.__dict__["message"] = message
        __props__.__dict__["name"] = name
        __props__.__dict__["notification_email"] = notification_email
        __props__.__dict__["subscription_id"] = subscription_id
        return AnomalyAlert(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        """
        The display name which should be used for this Cost Anomaly Alert.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="emailAddresses")
    def email_addresses(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Specifies a list of email addresses which the Anomaly Alerts are send to.
        """
        return pulumi.get(self, "email_addresses")

    @_builtins.property
    @pulumi.getter(name="emailSubject")
    def email_subject(self) -> pulumi.Output[_builtins.str]:
        """
        The email subject of the Cost Anomaly Alerts. Maximum length of the subject is 70.
        """
        return pulumi.get(self, "email_subject")

    @_builtins.property
    @pulumi.getter
    def message(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The message of the Cost Anomaly Alert. Maximum length of the message is 250.
        """
        return pulumi.get(self, "message")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name which should be used for this Cost Anomaly Alert. Changing this forces a new resource to be created. The name can contain only lowercase letters, numbers and hyphens.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="notificationEmail")
    def notification_email(self) -> pulumi.Output[_builtins.str]:
        """
        The email address of the point of contact that should get the unsubscribe requests and notification emails.
        """
        return pulumi.get(self, "notification_email")

    @_builtins.property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Subscription this Cost Anomaly Alert is scoped to. Changing this forces a new resource to be created. When not supplied this defaults to the subscription configured in the provider.
        """
        return pulumi.get(self, "subscription_id")

