# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['GrafanaManagedPrivateEndpointArgs', 'GrafanaManagedPrivateEndpoint']

@pulumi.input_type
class GrafanaManagedPrivateEndpointArgs:
    def __init__(__self__, *,
                 grafana_id: pulumi.Input[_builtins.str],
                 private_link_resource_id: pulumi.Input[_builtins.str],
                 group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 private_link_resource_region: Optional[pulumi.Input[_builtins.str]] = None,
                 private_link_service_url: Optional[pulumi.Input[_builtins.str]] = None,
                 request_message: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a GrafanaManagedPrivateEndpoint resource.
        :param pulumi.Input[_builtins.str] grafana_id: The id of the associated managed Grafana. Changing this forces a new Dashboard Grafana Managed Private Endpoint to be created.
        :param pulumi.Input[_builtins.str] private_link_resource_id: The ID of the resource to which this Dashboard Grafana Managed Private Endpoint will connect. Changing this forces a new Dashboard Grafana Managed Private Endpoint to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] group_ids: Specifies a list of private link group IDs. The value of this will depend on the private link resource to which you are connecting. Changing this forces a new Dashboard Grafana Managed Private Endpoint to be created.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Dashboard Grafana Managed Private Endpoint should exist. Changing this forces a new Dashboard Grafana Managed Private Endpoint to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Dashboard Grafana Managed Private Endpoint. Must be between 2 and 20 alphanumeric characters or dashes, must begin with letter and end with a letter or number. Changing this forces a new Dashboard Grafana Managed Private Endpoint to be created.
        :param pulumi.Input[_builtins.str] private_link_resource_region: The region in which to create the private link. Changing this forces a new Dashboard Grafana Managed Private Endpoint to be created.
        :param pulumi.Input[_builtins.str] private_link_service_url: A domain name for this endpoint to be used within Grafana. Must be just a domain, without schema, and with at least three parts.
        :param pulumi.Input[_builtins.str] request_message: A message to provide in the request which will be seen by approvers.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Dashboard Grafana Managed Private Endpoint.
        """
        pulumi.set(__self__, "grafana_id", grafana_id)
        pulumi.set(__self__, "private_link_resource_id", private_link_resource_id)
        if group_ids is not None:
            pulumi.set(__self__, "group_ids", group_ids)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if private_link_resource_region is not None:
            pulumi.set(__self__, "private_link_resource_region", private_link_resource_region)
        if private_link_service_url is not None:
            pulumi.set(__self__, "private_link_service_url", private_link_service_url)
        if request_message is not None:
            pulumi.set(__self__, "request_message", request_message)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="grafanaId")
    def grafana_id(self) -> pulumi.Input[_builtins.str]:
        """
        The id of the associated managed Grafana. Changing this forces a new Dashboard Grafana Managed Private Endpoint to be created.
        """
        return pulumi.get(self, "grafana_id")

    @grafana_id.setter
    def grafana_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "grafana_id", value)

    @_builtins.property
    @pulumi.getter(name="privateLinkResourceId")
    def private_link_resource_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the resource to which this Dashboard Grafana Managed Private Endpoint will connect. Changing this forces a new Dashboard Grafana Managed Private Endpoint to be created.
        """
        return pulumi.get(self, "private_link_resource_id")

    @private_link_resource_id.setter
    def private_link_resource_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "private_link_resource_id", value)

    @_builtins.property
    @pulumi.getter(name="groupIds")
    def group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies a list of private link group IDs. The value of this will depend on the private link resource to which you are connecting. Changing this forces a new Dashboard Grafana Managed Private Endpoint to be created.
        """
        return pulumi.get(self, "group_ids")

    @group_ids.setter
    def group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "group_ids", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Azure Region where the Dashboard Grafana Managed Private Endpoint should exist. Changing this forces a new Dashboard Grafana Managed Private Endpoint to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Dashboard Grafana Managed Private Endpoint. Must be between 2 and 20 alphanumeric characters or dashes, must begin with letter and end with a letter or number. Changing this forces a new Dashboard Grafana Managed Private Endpoint to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="privateLinkResourceRegion")
    def private_link_resource_region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region in which to create the private link. Changing this forces a new Dashboard Grafana Managed Private Endpoint to be created.
        """
        return pulumi.get(self, "private_link_resource_region")

    @private_link_resource_region.setter
    def private_link_resource_region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_link_resource_region", value)

    @_builtins.property
    @pulumi.getter(name="privateLinkServiceUrl")
    def private_link_service_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A domain name for this endpoint to be used within Grafana. Must be just a domain, without schema, and with at least three parts.
        """
        return pulumi.get(self, "private_link_service_url")

    @private_link_service_url.setter
    def private_link_service_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_link_service_url", value)

    @_builtins.property
    @pulumi.getter(name="requestMessage")
    def request_message(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A message to provide in the request which will be seen by approvers.
        """
        return pulumi.get(self, "request_message")

    @request_message.setter
    def request_message(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "request_message", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the Dashboard Grafana Managed Private Endpoint.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _GrafanaManagedPrivateEndpointState:
    def __init__(__self__, *,
                 grafana_id: Optional[pulumi.Input[_builtins.str]] = None,
                 group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 private_link_resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 private_link_resource_region: Optional[pulumi.Input[_builtins.str]] = None,
                 private_link_service_url: Optional[pulumi.Input[_builtins.str]] = None,
                 request_message: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering GrafanaManagedPrivateEndpoint resources.
        :param pulumi.Input[_builtins.str] grafana_id: The id of the associated managed Grafana. Changing this forces a new Dashboard Grafana Managed Private Endpoint to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] group_ids: Specifies a list of private link group IDs. The value of this will depend on the private link resource to which you are connecting. Changing this forces a new Dashboard Grafana Managed Private Endpoint to be created.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Dashboard Grafana Managed Private Endpoint should exist. Changing this forces a new Dashboard Grafana Managed Private Endpoint to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Dashboard Grafana Managed Private Endpoint. Must be between 2 and 20 alphanumeric characters or dashes, must begin with letter and end with a letter or number. Changing this forces a new Dashboard Grafana Managed Private Endpoint to be created.
        :param pulumi.Input[_builtins.str] private_link_resource_id: The ID of the resource to which this Dashboard Grafana Managed Private Endpoint will connect. Changing this forces a new Dashboard Grafana Managed Private Endpoint to be created.
        :param pulumi.Input[_builtins.str] private_link_resource_region: The region in which to create the private link. Changing this forces a new Dashboard Grafana Managed Private Endpoint to be created.
        :param pulumi.Input[_builtins.str] private_link_service_url: A domain name for this endpoint to be used within Grafana. Must be just a domain, without schema, and with at least three parts.
        :param pulumi.Input[_builtins.str] request_message: A message to provide in the request which will be seen by approvers.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Dashboard Grafana Managed Private Endpoint.
        """
        if grafana_id is not None:
            pulumi.set(__self__, "grafana_id", grafana_id)
        if group_ids is not None:
            pulumi.set(__self__, "group_ids", group_ids)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if private_link_resource_id is not None:
            pulumi.set(__self__, "private_link_resource_id", private_link_resource_id)
        if private_link_resource_region is not None:
            pulumi.set(__self__, "private_link_resource_region", private_link_resource_region)
        if private_link_service_url is not None:
            pulumi.set(__self__, "private_link_service_url", private_link_service_url)
        if request_message is not None:
            pulumi.set(__self__, "request_message", request_message)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="grafanaId")
    def grafana_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The id of the associated managed Grafana. Changing this forces a new Dashboard Grafana Managed Private Endpoint to be created.
        """
        return pulumi.get(self, "grafana_id")

    @grafana_id.setter
    def grafana_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "grafana_id", value)

    @_builtins.property
    @pulumi.getter(name="groupIds")
    def group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies a list of private link group IDs. The value of this will depend on the private link resource to which you are connecting. Changing this forces a new Dashboard Grafana Managed Private Endpoint to be created.
        """
        return pulumi.get(self, "group_ids")

    @group_ids.setter
    def group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "group_ids", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Azure Region where the Dashboard Grafana Managed Private Endpoint should exist. Changing this forces a new Dashboard Grafana Managed Private Endpoint to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Dashboard Grafana Managed Private Endpoint. Must be between 2 and 20 alphanumeric characters or dashes, must begin with letter and end with a letter or number. Changing this forces a new Dashboard Grafana Managed Private Endpoint to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="privateLinkResourceId")
    def private_link_resource_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the resource to which this Dashboard Grafana Managed Private Endpoint will connect. Changing this forces a new Dashboard Grafana Managed Private Endpoint to be created.
        """
        return pulumi.get(self, "private_link_resource_id")

    @private_link_resource_id.setter
    def private_link_resource_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_link_resource_id", value)

    @_builtins.property
    @pulumi.getter(name="privateLinkResourceRegion")
    def private_link_resource_region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region in which to create the private link. Changing this forces a new Dashboard Grafana Managed Private Endpoint to be created.
        """
        return pulumi.get(self, "private_link_resource_region")

    @private_link_resource_region.setter
    def private_link_resource_region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_link_resource_region", value)

    @_builtins.property
    @pulumi.getter(name="privateLinkServiceUrl")
    def private_link_service_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A domain name for this endpoint to be used within Grafana. Must be just a domain, without schema, and with at least three parts.
        """
        return pulumi.get(self, "private_link_service_url")

    @private_link_service_url.setter
    def private_link_service_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_link_service_url", value)

    @_builtins.property
    @pulumi.getter(name="requestMessage")
    def request_message(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A message to provide in the request which will be seen by approvers.
        """
        return pulumi.get(self, "request_message")

    @request_message.setter
    def request_message(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "request_message", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the Dashboard Grafana Managed Private Endpoint.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("azure:dashboard/grafanaManagedPrivateEndpoint:GrafanaManagedPrivateEndpoint")
class GrafanaManagedPrivateEndpoint(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 grafana_id: Optional[pulumi.Input[_builtins.str]] = None,
                 group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 private_link_resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 private_link_resource_region: Optional[pulumi.Input[_builtins.str]] = None,
                 private_link_service_url: Optional[pulumi.Input[_builtins.str]] = None,
                 request_message: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Manages a Dashboard Grafana Managed Private Endpoint.

        > **Note:** This resource will _not_ approve the managed private endpoint connection on the linked resource. This will need to be done manually via Azure CLI, PowerShell, or AzAPI resources. See here for an example that uses AzAPI.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="Canada Central")
        example_workspace = azure.monitoring.Workspace("example",
            name="example-mamw",
            resource_group_name=example.name,
            location=example.location,
            public_network_access_enabled=False)
        example_grafana = azure.dashboard.Grafana("example",
            name="example-dg",
            resource_group_name=example.name,
            location=example.location,
            grafana_major_version="11",
            public_network_access_enabled=False,
            azure_monitor_workspace_integrations=[{
                "resource_id": example_workspace.id,
            }])
        example_grafana_managed_private_endpoint = azure.dashboard.GrafanaManagedPrivateEndpoint("example",
            grafana_id=example_grafana.id,
            name="example-mpe",
            location=example_grafana.location,
            private_link_resource_id=example_workspace.id,
            group_ids=["prometheusMetrics"],
            private_link_resource_region=example_grafana.location)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Dashboard`: 2023-09-01

        ## Import

        Dashboard Grafana Managed Private Endpoint Examples can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:dashboard/grafanaManagedPrivateEndpoint:GrafanaManagedPrivateEndpoint example /subscriptions/12345678-1234-9876-4563-123456789012/resourceGroups/resGroup1/providers/Microsoft.Dashboard/grafana/workspace1/managedPrivateEndpoints/endpoint1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] grafana_id: The id of the associated managed Grafana. Changing this forces a new Dashboard Grafana Managed Private Endpoint to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] group_ids: Specifies a list of private link group IDs. The value of this will depend on the private link resource to which you are connecting. Changing this forces a new Dashboard Grafana Managed Private Endpoint to be created.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Dashboard Grafana Managed Private Endpoint should exist. Changing this forces a new Dashboard Grafana Managed Private Endpoint to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Dashboard Grafana Managed Private Endpoint. Must be between 2 and 20 alphanumeric characters or dashes, must begin with letter and end with a letter or number. Changing this forces a new Dashboard Grafana Managed Private Endpoint to be created.
        :param pulumi.Input[_builtins.str] private_link_resource_id: The ID of the resource to which this Dashboard Grafana Managed Private Endpoint will connect. Changing this forces a new Dashboard Grafana Managed Private Endpoint to be created.
        :param pulumi.Input[_builtins.str] private_link_resource_region: The region in which to create the private link. Changing this forces a new Dashboard Grafana Managed Private Endpoint to be created.
        :param pulumi.Input[_builtins.str] private_link_service_url: A domain name for this endpoint to be used within Grafana. Must be just a domain, without schema, and with at least three parts.
        :param pulumi.Input[_builtins.str] request_message: A message to provide in the request which will be seen by approvers.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Dashboard Grafana Managed Private Endpoint.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: GrafanaManagedPrivateEndpointArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Dashboard Grafana Managed Private Endpoint.

        > **Note:** This resource will _not_ approve the managed private endpoint connection on the linked resource. This will need to be done manually via Azure CLI, PowerShell, or AzAPI resources. See here for an example that uses AzAPI.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="Canada Central")
        example_workspace = azure.monitoring.Workspace("example",
            name="example-mamw",
            resource_group_name=example.name,
            location=example.location,
            public_network_access_enabled=False)
        example_grafana = azure.dashboard.Grafana("example",
            name="example-dg",
            resource_group_name=example.name,
            location=example.location,
            grafana_major_version="11",
            public_network_access_enabled=False,
            azure_monitor_workspace_integrations=[{
                "resource_id": example_workspace.id,
            }])
        example_grafana_managed_private_endpoint = azure.dashboard.GrafanaManagedPrivateEndpoint("example",
            grafana_id=example_grafana.id,
            name="example-mpe",
            location=example_grafana.location,
            private_link_resource_id=example_workspace.id,
            group_ids=["prometheusMetrics"],
            private_link_resource_region=example_grafana.location)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Dashboard`: 2023-09-01

        ## Import

        Dashboard Grafana Managed Private Endpoint Examples can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:dashboard/grafanaManagedPrivateEndpoint:GrafanaManagedPrivateEndpoint example /subscriptions/12345678-1234-9876-4563-123456789012/resourceGroups/resGroup1/providers/Microsoft.Dashboard/grafana/workspace1/managedPrivateEndpoints/endpoint1
        ```

        :param str resource_name: The name of the resource.
        :param GrafanaManagedPrivateEndpointArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GrafanaManagedPrivateEndpointArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 grafana_id: Optional[pulumi.Input[_builtins.str]] = None,
                 group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 private_link_resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 private_link_resource_region: Optional[pulumi.Input[_builtins.str]] = None,
                 private_link_service_url: Optional[pulumi.Input[_builtins.str]] = None,
                 request_message: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GrafanaManagedPrivateEndpointArgs.__new__(GrafanaManagedPrivateEndpointArgs)

            if grafana_id is None and not opts.urn:
                raise TypeError("Missing required property 'grafana_id'")
            __props__.__dict__["grafana_id"] = grafana_id
            __props__.__dict__["group_ids"] = group_ids
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            if private_link_resource_id is None and not opts.urn:
                raise TypeError("Missing required property 'private_link_resource_id'")
            __props__.__dict__["private_link_resource_id"] = private_link_resource_id
            __props__.__dict__["private_link_resource_region"] = private_link_resource_region
            __props__.__dict__["private_link_service_url"] = private_link_service_url
            __props__.__dict__["request_message"] = request_message
            __props__.__dict__["tags"] = tags
        super(GrafanaManagedPrivateEndpoint, __self__).__init__(
            'azure:dashboard/grafanaManagedPrivateEndpoint:GrafanaManagedPrivateEndpoint',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            grafana_id: Optional[pulumi.Input[_builtins.str]] = None,
            group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            private_link_resource_id: Optional[pulumi.Input[_builtins.str]] = None,
            private_link_resource_region: Optional[pulumi.Input[_builtins.str]] = None,
            private_link_service_url: Optional[pulumi.Input[_builtins.str]] = None,
            request_message: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None) -> 'GrafanaManagedPrivateEndpoint':
        """
        Get an existing GrafanaManagedPrivateEndpoint resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] grafana_id: The id of the associated managed Grafana. Changing this forces a new Dashboard Grafana Managed Private Endpoint to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] group_ids: Specifies a list of private link group IDs. The value of this will depend on the private link resource to which you are connecting. Changing this forces a new Dashboard Grafana Managed Private Endpoint to be created.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Dashboard Grafana Managed Private Endpoint should exist. Changing this forces a new Dashboard Grafana Managed Private Endpoint to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Dashboard Grafana Managed Private Endpoint. Must be between 2 and 20 alphanumeric characters or dashes, must begin with letter and end with a letter or number. Changing this forces a new Dashboard Grafana Managed Private Endpoint to be created.
        :param pulumi.Input[_builtins.str] private_link_resource_id: The ID of the resource to which this Dashboard Grafana Managed Private Endpoint will connect. Changing this forces a new Dashboard Grafana Managed Private Endpoint to be created.
        :param pulumi.Input[_builtins.str] private_link_resource_region: The region in which to create the private link. Changing this forces a new Dashboard Grafana Managed Private Endpoint to be created.
        :param pulumi.Input[_builtins.str] private_link_service_url: A domain name for this endpoint to be used within Grafana. Must be just a domain, without schema, and with at least three parts.
        :param pulumi.Input[_builtins.str] request_message: A message to provide in the request which will be seen by approvers.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Dashboard Grafana Managed Private Endpoint.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _GrafanaManagedPrivateEndpointState.__new__(_GrafanaManagedPrivateEndpointState)

        __props__.__dict__["grafana_id"] = grafana_id
        __props__.__dict__["group_ids"] = group_ids
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["private_link_resource_id"] = private_link_resource_id
        __props__.__dict__["private_link_resource_region"] = private_link_resource_region
        __props__.__dict__["private_link_service_url"] = private_link_service_url
        __props__.__dict__["request_message"] = request_message
        __props__.__dict__["tags"] = tags
        return GrafanaManagedPrivateEndpoint(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="grafanaId")
    def grafana_id(self) -> pulumi.Output[_builtins.str]:
        """
        The id of the associated managed Grafana. Changing this forces a new Dashboard Grafana Managed Private Endpoint to be created.
        """
        return pulumi.get(self, "grafana_id")

    @_builtins.property
    @pulumi.getter(name="groupIds")
    def group_ids(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Specifies a list of private link group IDs. The value of this will depend on the private link resource to which you are connecting. Changing this forces a new Dashboard Grafana Managed Private Endpoint to be created.
        """
        return pulumi.get(self, "group_ids")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        The Azure Region where the Dashboard Grafana Managed Private Endpoint should exist. Changing this forces a new Dashboard Grafana Managed Private Endpoint to be created.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name which should be used for this Dashboard Grafana Managed Private Endpoint. Must be between 2 and 20 alphanumeric characters or dashes, must begin with letter and end with a letter or number. Changing this forces a new Dashboard Grafana Managed Private Endpoint to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="privateLinkResourceId")
    def private_link_resource_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the resource to which this Dashboard Grafana Managed Private Endpoint will connect. Changing this forces a new Dashboard Grafana Managed Private Endpoint to be created.
        """
        return pulumi.get(self, "private_link_resource_id")

    @_builtins.property
    @pulumi.getter(name="privateLinkResourceRegion")
    def private_link_resource_region(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The region in which to create the private link. Changing this forces a new Dashboard Grafana Managed Private Endpoint to be created.
        """
        return pulumi.get(self, "private_link_resource_region")

    @_builtins.property
    @pulumi.getter(name="privateLinkServiceUrl")
    def private_link_service_url(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        A domain name for this endpoint to be used within Grafana. Must be just a domain, without schema, and with at least three parts.
        """
        return pulumi.get(self, "private_link_service_url")

    @_builtins.property
    @pulumi.getter(name="requestMessage")
    def request_message(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        A message to provide in the request which will be seen by approvers.
        """
        return pulumi.get(self, "request_message")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags which should be assigned to the Dashboard Grafana Managed Private Endpoint.
        """
        return pulumi.get(self, "tags")

