# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['BackupPolicyDiskArgs', 'BackupPolicyDisk']

@pulumi.input_type
class BackupPolicyDiskArgs:
    def __init__(__self__, *,
                 backup_repeating_time_intervals: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 default_retention_duration: pulumi.Input[_builtins.str],
                 vault_id: pulumi.Input[_builtins.str],
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 retention_rules: Optional[pulumi.Input[Sequence[pulumi.Input['BackupPolicyDiskRetentionRuleArgs']]]] = None,
                 time_zone: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a BackupPolicyDisk resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] backup_repeating_time_intervals: Specifies a list of repeating time interval. It should follow `ISO 8601` repeating time interval . Changing this forces a new Backup Policy Disk to be created.
        :param pulumi.Input[_builtins.str] default_retention_duration: The duration of default retention rule. It should follow `ISO 8601` duration format. Changing this forces a new Backup Policy Disk to be created.
        :param pulumi.Input[_builtins.str] vault_id: The ID of the Backup Vault within which the Backup Policy Disk should exist. Changing this forces a new Backup Policy Disk to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Backup Policy Disk. Changing this forces a new Backup Policy Disk to be created.
        :param pulumi.Input[Sequence[pulumi.Input['BackupPolicyDiskRetentionRuleArgs']]] retention_rules: One or more `retention_rule` blocks as defined below. Changing this forces a new Backup Policy Disk to be created.
        :param pulumi.Input[_builtins.str] time_zone: Specifies the Time Zone which should be used by the backup schedule. Changing this forces a new Backup Policy Disk to be created.
        """
        pulumi.set(__self__, "backup_repeating_time_intervals", backup_repeating_time_intervals)
        pulumi.set(__self__, "default_retention_duration", default_retention_duration)
        pulumi.set(__self__, "vault_id", vault_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if retention_rules is not None:
            pulumi.set(__self__, "retention_rules", retention_rules)
        if time_zone is not None:
            pulumi.set(__self__, "time_zone", time_zone)

    @_builtins.property
    @pulumi.getter(name="backupRepeatingTimeIntervals")
    def backup_repeating_time_intervals(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        Specifies a list of repeating time interval. It should follow `ISO 8601` repeating time interval . Changing this forces a new Backup Policy Disk to be created.
        """
        return pulumi.get(self, "backup_repeating_time_intervals")

    @backup_repeating_time_intervals.setter
    def backup_repeating_time_intervals(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "backup_repeating_time_intervals", value)

    @_builtins.property
    @pulumi.getter(name="defaultRetentionDuration")
    def default_retention_duration(self) -> pulumi.Input[_builtins.str]:
        """
        The duration of default retention rule. It should follow `ISO 8601` duration format. Changing this forces a new Backup Policy Disk to be created.
        """
        return pulumi.get(self, "default_retention_duration")

    @default_retention_duration.setter
    def default_retention_duration(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "default_retention_duration", value)

    @_builtins.property
    @pulumi.getter(name="vaultId")
    def vault_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Backup Vault within which the Backup Policy Disk should exist. Changing this forces a new Backup Policy Disk to be created.
        """
        return pulumi.get(self, "vault_id")

    @vault_id.setter
    def vault_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "vault_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Backup Policy Disk. Changing this forces a new Backup Policy Disk to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="retentionRules")
    def retention_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BackupPolicyDiskRetentionRuleArgs']]]]:
        """
        One or more `retention_rule` blocks as defined below. Changing this forces a new Backup Policy Disk to be created.
        """
        return pulumi.get(self, "retention_rules")

    @retention_rules.setter
    def retention_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BackupPolicyDiskRetentionRuleArgs']]]]):
        pulumi.set(self, "retention_rules", value)

    @_builtins.property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the Time Zone which should be used by the backup schedule. Changing this forces a new Backup Policy Disk to be created.
        """
        return pulumi.get(self, "time_zone")

    @time_zone.setter
    def time_zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_zone", value)


@pulumi.input_type
class _BackupPolicyDiskState:
    def __init__(__self__, *,
                 backup_repeating_time_intervals: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 default_retention_duration: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 retention_rules: Optional[pulumi.Input[Sequence[pulumi.Input['BackupPolicyDiskRetentionRuleArgs']]]] = None,
                 time_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 vault_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering BackupPolicyDisk resources.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] backup_repeating_time_intervals: Specifies a list of repeating time interval. It should follow `ISO 8601` repeating time interval . Changing this forces a new Backup Policy Disk to be created.
        :param pulumi.Input[_builtins.str] default_retention_duration: The duration of default retention rule. It should follow `ISO 8601` duration format. Changing this forces a new Backup Policy Disk to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Backup Policy Disk. Changing this forces a new Backup Policy Disk to be created.
        :param pulumi.Input[Sequence[pulumi.Input['BackupPolicyDiskRetentionRuleArgs']]] retention_rules: One or more `retention_rule` blocks as defined below. Changing this forces a new Backup Policy Disk to be created.
        :param pulumi.Input[_builtins.str] time_zone: Specifies the Time Zone which should be used by the backup schedule. Changing this forces a new Backup Policy Disk to be created.
        :param pulumi.Input[_builtins.str] vault_id: The ID of the Backup Vault within which the Backup Policy Disk should exist. Changing this forces a new Backup Policy Disk to be created.
        """
        if backup_repeating_time_intervals is not None:
            pulumi.set(__self__, "backup_repeating_time_intervals", backup_repeating_time_intervals)
        if default_retention_duration is not None:
            pulumi.set(__self__, "default_retention_duration", default_retention_duration)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if retention_rules is not None:
            pulumi.set(__self__, "retention_rules", retention_rules)
        if time_zone is not None:
            pulumi.set(__self__, "time_zone", time_zone)
        if vault_id is not None:
            pulumi.set(__self__, "vault_id", vault_id)

    @_builtins.property
    @pulumi.getter(name="backupRepeatingTimeIntervals")
    def backup_repeating_time_intervals(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies a list of repeating time interval. It should follow `ISO 8601` repeating time interval . Changing this forces a new Backup Policy Disk to be created.
        """
        return pulumi.get(self, "backup_repeating_time_intervals")

    @backup_repeating_time_intervals.setter
    def backup_repeating_time_intervals(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "backup_repeating_time_intervals", value)

    @_builtins.property
    @pulumi.getter(name="defaultRetentionDuration")
    def default_retention_duration(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The duration of default retention rule. It should follow `ISO 8601` duration format. Changing this forces a new Backup Policy Disk to be created.
        """
        return pulumi.get(self, "default_retention_duration")

    @default_retention_duration.setter
    def default_retention_duration(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_retention_duration", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Backup Policy Disk. Changing this forces a new Backup Policy Disk to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="retentionRules")
    def retention_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BackupPolicyDiskRetentionRuleArgs']]]]:
        """
        One or more `retention_rule` blocks as defined below. Changing this forces a new Backup Policy Disk to be created.
        """
        return pulumi.get(self, "retention_rules")

    @retention_rules.setter
    def retention_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BackupPolicyDiskRetentionRuleArgs']]]]):
        pulumi.set(self, "retention_rules", value)

    @_builtins.property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the Time Zone which should be used by the backup schedule. Changing this forces a new Backup Policy Disk to be created.
        """
        return pulumi.get(self, "time_zone")

    @time_zone.setter
    def time_zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_zone", value)

    @_builtins.property
    @pulumi.getter(name="vaultId")
    def vault_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Backup Vault within which the Backup Policy Disk should exist. Changing this forces a new Backup Policy Disk to be created.
        """
        return pulumi.get(self, "vault_id")

    @vault_id.setter
    def vault_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vault_id", value)


@pulumi.type_token("azure:dataprotection/backupPolicyDisk:BackupPolicyDisk")
class BackupPolicyDisk(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backup_repeating_time_intervals: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 default_retention_duration: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 retention_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['BackupPolicyDiskRetentionRuleArgs', 'BackupPolicyDiskRetentionRuleArgsDict']]]]] = None,
                 time_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 vault_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a Backup Policy Disk.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_backup_vault = azure.dataprotection.BackupVault("example",
            name="example-backup-vault",
            resource_group_name=example.name,
            location=example.location,
            datastore_type="VaultStore",
            redundancy="LocallyRedundant")
        example_backup_policy_disk = azure.dataprotection.BackupPolicyDisk("example",
            name="example-backup-policy",
            vault_id=example_backup_vault.id,
            backup_repeating_time_intervals=["R/2021-05-19T06:33:16+00:00/PT4H"],
            default_retention_duration="P7D",
            time_zone="W. Europe Standard Time",
            retention_rules=[
                {
                    "name": "Daily",
                    "duration": "P7D",
                    "priority": 25,
                    "criteria": {
                        "absolute_criteria": "FirstOfDay",
                    },
                },
                {
                    "name": "Weekly",
                    "duration": "P7D",
                    "priority": 20,
                    "criteria": {
                        "absolute_criteria": "FirstOfWeek",
                    },
                },
            ])
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.DataProtection`: 2024-04-01

        ## Import

        Backup Policy Disks can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:dataprotection/backupPolicyDisk:BackupPolicyDisk example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.DataProtection/backupVaults/vault1/backupPolicies/backupPolicy1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] backup_repeating_time_intervals: Specifies a list of repeating time interval. It should follow `ISO 8601` repeating time interval . Changing this forces a new Backup Policy Disk to be created.
        :param pulumi.Input[_builtins.str] default_retention_duration: The duration of default retention rule. It should follow `ISO 8601` duration format. Changing this forces a new Backup Policy Disk to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Backup Policy Disk. Changing this forces a new Backup Policy Disk to be created.
        :param pulumi.Input[Sequence[pulumi.Input[Union['BackupPolicyDiskRetentionRuleArgs', 'BackupPolicyDiskRetentionRuleArgsDict']]]] retention_rules: One or more `retention_rule` blocks as defined below. Changing this forces a new Backup Policy Disk to be created.
        :param pulumi.Input[_builtins.str] time_zone: Specifies the Time Zone which should be used by the backup schedule. Changing this forces a new Backup Policy Disk to be created.
        :param pulumi.Input[_builtins.str] vault_id: The ID of the Backup Vault within which the Backup Policy Disk should exist. Changing this forces a new Backup Policy Disk to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: BackupPolicyDiskArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Backup Policy Disk.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_backup_vault = azure.dataprotection.BackupVault("example",
            name="example-backup-vault",
            resource_group_name=example.name,
            location=example.location,
            datastore_type="VaultStore",
            redundancy="LocallyRedundant")
        example_backup_policy_disk = azure.dataprotection.BackupPolicyDisk("example",
            name="example-backup-policy",
            vault_id=example_backup_vault.id,
            backup_repeating_time_intervals=["R/2021-05-19T06:33:16+00:00/PT4H"],
            default_retention_duration="P7D",
            time_zone="W. Europe Standard Time",
            retention_rules=[
                {
                    "name": "Daily",
                    "duration": "P7D",
                    "priority": 25,
                    "criteria": {
                        "absolute_criteria": "FirstOfDay",
                    },
                },
                {
                    "name": "Weekly",
                    "duration": "P7D",
                    "priority": 20,
                    "criteria": {
                        "absolute_criteria": "FirstOfWeek",
                    },
                },
            ])
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.DataProtection`: 2024-04-01

        ## Import

        Backup Policy Disks can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:dataprotection/backupPolicyDisk:BackupPolicyDisk example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.DataProtection/backupVaults/vault1/backupPolicies/backupPolicy1
        ```

        :param str resource_name: The name of the resource.
        :param BackupPolicyDiskArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BackupPolicyDiskArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backup_repeating_time_intervals: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 default_retention_duration: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 retention_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['BackupPolicyDiskRetentionRuleArgs', 'BackupPolicyDiskRetentionRuleArgsDict']]]]] = None,
                 time_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 vault_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BackupPolicyDiskArgs.__new__(BackupPolicyDiskArgs)

            if backup_repeating_time_intervals is None and not opts.urn:
                raise TypeError("Missing required property 'backup_repeating_time_intervals'")
            __props__.__dict__["backup_repeating_time_intervals"] = backup_repeating_time_intervals
            if default_retention_duration is None and not opts.urn:
                raise TypeError("Missing required property 'default_retention_duration'")
            __props__.__dict__["default_retention_duration"] = default_retention_duration
            __props__.__dict__["name"] = name
            __props__.__dict__["retention_rules"] = retention_rules
            __props__.__dict__["time_zone"] = time_zone
            if vault_id is None and not opts.urn:
                raise TypeError("Missing required property 'vault_id'")
            __props__.__dict__["vault_id"] = vault_id
        super(BackupPolicyDisk, __self__).__init__(
            'azure:dataprotection/backupPolicyDisk:BackupPolicyDisk',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            backup_repeating_time_intervals: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            default_retention_duration: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            retention_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['BackupPolicyDiskRetentionRuleArgs', 'BackupPolicyDiskRetentionRuleArgsDict']]]]] = None,
            time_zone: Optional[pulumi.Input[_builtins.str]] = None,
            vault_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'BackupPolicyDisk':
        """
        Get an existing BackupPolicyDisk resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] backup_repeating_time_intervals: Specifies a list of repeating time interval. It should follow `ISO 8601` repeating time interval . Changing this forces a new Backup Policy Disk to be created.
        :param pulumi.Input[_builtins.str] default_retention_duration: The duration of default retention rule. It should follow `ISO 8601` duration format. Changing this forces a new Backup Policy Disk to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Backup Policy Disk. Changing this forces a new Backup Policy Disk to be created.
        :param pulumi.Input[Sequence[pulumi.Input[Union['BackupPolicyDiskRetentionRuleArgs', 'BackupPolicyDiskRetentionRuleArgsDict']]]] retention_rules: One or more `retention_rule` blocks as defined below. Changing this forces a new Backup Policy Disk to be created.
        :param pulumi.Input[_builtins.str] time_zone: Specifies the Time Zone which should be used by the backup schedule. Changing this forces a new Backup Policy Disk to be created.
        :param pulumi.Input[_builtins.str] vault_id: The ID of the Backup Vault within which the Backup Policy Disk should exist. Changing this forces a new Backup Policy Disk to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _BackupPolicyDiskState.__new__(_BackupPolicyDiskState)

        __props__.__dict__["backup_repeating_time_intervals"] = backup_repeating_time_intervals
        __props__.__dict__["default_retention_duration"] = default_retention_duration
        __props__.__dict__["name"] = name
        __props__.__dict__["retention_rules"] = retention_rules
        __props__.__dict__["time_zone"] = time_zone
        __props__.__dict__["vault_id"] = vault_id
        return BackupPolicyDisk(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="backupRepeatingTimeIntervals")
    def backup_repeating_time_intervals(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Specifies a list of repeating time interval. It should follow `ISO 8601` repeating time interval . Changing this forces a new Backup Policy Disk to be created.
        """
        return pulumi.get(self, "backup_repeating_time_intervals")

    @_builtins.property
    @pulumi.getter(name="defaultRetentionDuration")
    def default_retention_duration(self) -> pulumi.Output[_builtins.str]:
        """
        The duration of default retention rule. It should follow `ISO 8601` duration format. Changing this forces a new Backup Policy Disk to be created.
        """
        return pulumi.get(self, "default_retention_duration")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name which should be used for this Backup Policy Disk. Changing this forces a new Backup Policy Disk to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="retentionRules")
    def retention_rules(self) -> pulumi.Output[Optional[Sequence['outputs.BackupPolicyDiskRetentionRule']]]:
        """
        One or more `retention_rule` blocks as defined below. Changing this forces a new Backup Policy Disk to be created.
        """
        return pulumi.get(self, "retention_rules")

    @_builtins.property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the Time Zone which should be used by the backup schedule. Changing this forces a new Backup Policy Disk to be created.
        """
        return pulumi.get(self, "time_zone")

    @_builtins.property
    @pulumi.getter(name="vaultId")
    def vault_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Backup Vault within which the Backup Policy Disk should exist. Changing this forces a new Backup Policy Disk to be created.
        """
        return pulumi.get(self, "vault_id")

