# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['BackupVaultCustomerManagedKeyArgs', 'BackupVaultCustomerManagedKey']

@pulumi.input_type
class BackupVaultCustomerManagedKeyArgs:
    def __init__(__self__, *,
                 data_protection_backup_vault_id: pulumi.Input[_builtins.str],
                 key_vault_key_id: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a BackupVaultCustomerManagedKey resource.
        :param pulumi.Input[_builtins.str] data_protection_backup_vault_id: The ID of the Backup Vault. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] key_vault_key_id: The ID of the Key Vault Key which should be used to Encrypt the data in this Backup Vault.
        """
        pulumi.set(__self__, "data_protection_backup_vault_id", data_protection_backup_vault_id)
        pulumi.set(__self__, "key_vault_key_id", key_vault_key_id)

    @_builtins.property
    @pulumi.getter(name="dataProtectionBackupVaultId")
    def data_protection_backup_vault_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Backup Vault. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "data_protection_backup_vault_id")

    @data_protection_backup_vault_id.setter
    def data_protection_backup_vault_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "data_protection_backup_vault_id", value)

    @_builtins.property
    @pulumi.getter(name="keyVaultKeyId")
    def key_vault_key_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Key Vault Key which should be used to Encrypt the data in this Backup Vault.
        """
        return pulumi.get(self, "key_vault_key_id")

    @key_vault_key_id.setter
    def key_vault_key_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "key_vault_key_id", value)


@pulumi.input_type
class _BackupVaultCustomerManagedKeyState:
    def __init__(__self__, *,
                 data_protection_backup_vault_id: Optional[pulumi.Input[_builtins.str]] = None,
                 key_vault_key_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering BackupVaultCustomerManagedKey resources.
        :param pulumi.Input[_builtins.str] data_protection_backup_vault_id: The ID of the Backup Vault. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] key_vault_key_id: The ID of the Key Vault Key which should be used to Encrypt the data in this Backup Vault.
        """
        if data_protection_backup_vault_id is not None:
            pulumi.set(__self__, "data_protection_backup_vault_id", data_protection_backup_vault_id)
        if key_vault_key_id is not None:
            pulumi.set(__self__, "key_vault_key_id", key_vault_key_id)

    @_builtins.property
    @pulumi.getter(name="dataProtectionBackupVaultId")
    def data_protection_backup_vault_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Backup Vault. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "data_protection_backup_vault_id")

    @data_protection_backup_vault_id.setter
    def data_protection_backup_vault_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "data_protection_backup_vault_id", value)

    @_builtins.property
    @pulumi.getter(name="keyVaultKeyId")
    def key_vault_key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Key Vault Key which should be used to Encrypt the data in this Backup Vault.
        """
        return pulumi.get(self, "key_vault_key_id")

    @key_vault_key_id.setter
    def key_vault_key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_vault_key_id", value)


@pulumi.type_token("azure:dataprotection/backupVaultCustomerManagedKey:BackupVaultCustomerManagedKey")
class BackupVaultCustomerManagedKey(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 data_protection_backup_vault_id: Optional[pulumi.Input[_builtins.str]] = None,
                 key_vault_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a Backup Vault Customer Managed Key.

        !> **Note:** It is not possible to remove the Customer Managed Key from the Backup Vault once it's been added. To remove the Customer Managed Key, the parent Data Protection Backup Vault must be deleted and recreated.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_backup_vault = azure.dataprotection.BackupVault("example",
            name="example-backup-vault",
            resource_group_name=example.name,
            location=example.location,
            datastore_type="VaultStore",
            redundancy="LocallyRedundant",
            identity={
                "type": "SystemAssigned",
            })
        current = azure.core.get_client_config()
        example_key_vault = azure.keyvault.KeyVault("example",
            name="example-key-vault",
            location=example.location,
            resource_group_name=example.name,
            enabled_for_disk_encryption=True,
            tenant_id=current.tenant_id,
            soft_delete_retention_days=7,
            purge_protection_enabled=True,
            sku_name="standard",
            access_policies=[
                {
                    "tenant_id": current.tenant_id,
                    "object_id": current.object_id,
                    "key_permissions": [
                        "Create",
                        "Decrypt",
                        "Encrypt",
                        "Delete",
                        "Get",
                        "List",
                        "Purge",
                        "UnwrapKey",
                        "WrapKey",
                        "Verify",
                        "GetRotationPolicy",
                    ],
                    "secret_permissions": ["Set"],
                },
                {
                    "tenant_id": example_backup_vault.identity.tenant_id,
                    "object_id": example_backup_vault.identity.principal_id,
                    "key_permissions": [
                        "Create",
                        "Decrypt",
                        "Encrypt",
                        "Delete",
                        "Get",
                        "List",
                        "Purge",
                        "UnwrapKey",
                        "WrapKey",
                        "Verify",
                        "GetRotationPolicy",
                    ],
                    "secret_permissions": ["Set"],
                },
            ])
        example_key = azure.keyvault.Key("example",
            name="example-key",
            key_vault_id=example_key_vault.id,
            key_type="RSA",
            key_size=2048,
            key_opts=[
                "decrypt",
                "encrypt",
                "sign",
                "unwrapKey",
                "verify",
                "wrapKey",
            ])
        example_backup_vault_customer_managed_key = azure.dataprotection.BackupVaultCustomerManagedKey("example",
            data_protection_backup_vault_id=example_backup_vault.id,
            key_vault_key_id=example_key.id)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.DataProtection`: 2024-04-01

        ## Import

        Backup Vault Customer Managed Keys can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:dataprotection/backupVaultCustomerManagedKey:BackupVaultCustomerManagedKey example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.DataProtection/backupVaults/vault1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] data_protection_backup_vault_id: The ID of the Backup Vault. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] key_vault_key_id: The ID of the Key Vault Key which should be used to Encrypt the data in this Backup Vault.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: BackupVaultCustomerManagedKeyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Backup Vault Customer Managed Key.

        !> **Note:** It is not possible to remove the Customer Managed Key from the Backup Vault once it's been added. To remove the Customer Managed Key, the parent Data Protection Backup Vault must be deleted and recreated.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_backup_vault = azure.dataprotection.BackupVault("example",
            name="example-backup-vault",
            resource_group_name=example.name,
            location=example.location,
            datastore_type="VaultStore",
            redundancy="LocallyRedundant",
            identity={
                "type": "SystemAssigned",
            })
        current = azure.core.get_client_config()
        example_key_vault = azure.keyvault.KeyVault("example",
            name="example-key-vault",
            location=example.location,
            resource_group_name=example.name,
            enabled_for_disk_encryption=True,
            tenant_id=current.tenant_id,
            soft_delete_retention_days=7,
            purge_protection_enabled=True,
            sku_name="standard",
            access_policies=[
                {
                    "tenant_id": current.tenant_id,
                    "object_id": current.object_id,
                    "key_permissions": [
                        "Create",
                        "Decrypt",
                        "Encrypt",
                        "Delete",
                        "Get",
                        "List",
                        "Purge",
                        "UnwrapKey",
                        "WrapKey",
                        "Verify",
                        "GetRotationPolicy",
                    ],
                    "secret_permissions": ["Set"],
                },
                {
                    "tenant_id": example_backup_vault.identity.tenant_id,
                    "object_id": example_backup_vault.identity.principal_id,
                    "key_permissions": [
                        "Create",
                        "Decrypt",
                        "Encrypt",
                        "Delete",
                        "Get",
                        "List",
                        "Purge",
                        "UnwrapKey",
                        "WrapKey",
                        "Verify",
                        "GetRotationPolicy",
                    ],
                    "secret_permissions": ["Set"],
                },
            ])
        example_key = azure.keyvault.Key("example",
            name="example-key",
            key_vault_id=example_key_vault.id,
            key_type="RSA",
            key_size=2048,
            key_opts=[
                "decrypt",
                "encrypt",
                "sign",
                "unwrapKey",
                "verify",
                "wrapKey",
            ])
        example_backup_vault_customer_managed_key = azure.dataprotection.BackupVaultCustomerManagedKey("example",
            data_protection_backup_vault_id=example_backup_vault.id,
            key_vault_key_id=example_key.id)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.DataProtection`: 2024-04-01

        ## Import

        Backup Vault Customer Managed Keys can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:dataprotection/backupVaultCustomerManagedKey:BackupVaultCustomerManagedKey example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.DataProtection/backupVaults/vault1
        ```

        :param str resource_name: The name of the resource.
        :param BackupVaultCustomerManagedKeyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BackupVaultCustomerManagedKeyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 data_protection_backup_vault_id: Optional[pulumi.Input[_builtins.str]] = None,
                 key_vault_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BackupVaultCustomerManagedKeyArgs.__new__(BackupVaultCustomerManagedKeyArgs)

            if data_protection_backup_vault_id is None and not opts.urn:
                raise TypeError("Missing required property 'data_protection_backup_vault_id'")
            __props__.__dict__["data_protection_backup_vault_id"] = data_protection_backup_vault_id
            if key_vault_key_id is None and not opts.urn:
                raise TypeError("Missing required property 'key_vault_key_id'")
            __props__.__dict__["key_vault_key_id"] = key_vault_key_id
        super(BackupVaultCustomerManagedKey, __self__).__init__(
            'azure:dataprotection/backupVaultCustomerManagedKey:BackupVaultCustomerManagedKey',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            data_protection_backup_vault_id: Optional[pulumi.Input[_builtins.str]] = None,
            key_vault_key_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'BackupVaultCustomerManagedKey':
        """
        Get an existing BackupVaultCustomerManagedKey resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] data_protection_backup_vault_id: The ID of the Backup Vault. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] key_vault_key_id: The ID of the Key Vault Key which should be used to Encrypt the data in this Backup Vault.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _BackupVaultCustomerManagedKeyState.__new__(_BackupVaultCustomerManagedKeyState)

        __props__.__dict__["data_protection_backup_vault_id"] = data_protection_backup_vault_id
        __props__.__dict__["key_vault_key_id"] = key_vault_key_id
        return BackupVaultCustomerManagedKey(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="dataProtectionBackupVaultId")
    def data_protection_backup_vault_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Backup Vault. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "data_protection_backup_vault_id")

    @_builtins.property
    @pulumi.getter(name="keyVaultKeyId")
    def key_vault_key_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Key Vault Key which should be used to Encrypt the data in this Backup Vault.
        """
        return pulumi.get(self, "key_vault_key_id")

