# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetBackupVaultResult',
    'AwaitableGetBackupVaultResult',
    'get_backup_vault',
    'get_backup_vault_output',
]

@pulumi.output_type
class GetBackupVaultResult:
    """
    A collection of values returned by getBackupVault.
    """
    def __init__(__self__, datastore_type=None, id=None, identities=None, location=None, name=None, redundancy=None, resource_group_name=None, tags=None):
        if datastore_type and not isinstance(datastore_type, str):
            raise TypeError("Expected argument 'datastore_type' to be a str")
        pulumi.set(__self__, "datastore_type", datastore_type)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if identities and not isinstance(identities, list):
            raise TypeError("Expected argument 'identities' to be a list")
        pulumi.set(__self__, "identities", identities)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if redundancy and not isinstance(redundancy, str):
            raise TypeError("Expected argument 'redundancy' to be a str")
        pulumi.set(__self__, "redundancy", redundancy)
        if resource_group_name and not isinstance(resource_group_name, str):
            raise TypeError("Expected argument 'resource_group_name' to be a str")
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="datastoreType")
    def datastore_type(self) -> _builtins.str:
        """
        Specifies the type of the data store.
        """
        return pulumi.get(self, "datastore_type")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def identities(self) -> Sequence['outputs.GetBackupVaultIdentityResult']:
        """
        A `identity` block as defined below.
        """
        return pulumi.get(self, "identities")

    @_builtins.property
    @pulumi.getter
    def location(self) -> _builtins.str:
        """
        The Azure Region where the Backup Vault exists.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def redundancy(self) -> _builtins.str:
        """
        Specifies the backup storage redundancy.
        """
        return pulumi.get(self, "redundancy")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> _builtins.str:
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        A mapping of tags which are assigned to the Backup Vault.
        """
        return pulumi.get(self, "tags")


class AwaitableGetBackupVaultResult(GetBackupVaultResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetBackupVaultResult(
            datastore_type=self.datastore_type,
            id=self.id,
            identities=self.identities,
            location=self.location,
            name=self.name,
            redundancy=self.redundancy,
            resource_group_name=self.resource_group_name,
            tags=self.tags)


def get_backup_vault(name: Optional[_builtins.str] = None,
                     resource_group_name: Optional[_builtins.str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetBackupVaultResult:
    """
    Use this data source to access information about an existing Backup Vault.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.dataprotection.get_backup_vault(name="existing-backup-vault",
        resource_group_name="existing-resource-group")
    pulumi.export("azurermDataProtectionBackupVaultId", example_azurerm_vpn_gateway["id"])
    pulumi.export("azurermDataProtectionBackupVaultPrincipalId", example.identities[0].principal_id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.DataProtection`: 2024-04-01


    :param _builtins.str name: Specifies the name of the Backup Vault.
    :param _builtins.str resource_group_name: The name of the Resource Group where the Backup Vault exists.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:dataprotection/getBackupVault:getBackupVault', __args__, opts=opts, typ=GetBackupVaultResult).value

    return AwaitableGetBackupVaultResult(
        datastore_type=pulumi.get(__ret__, 'datastore_type'),
        id=pulumi.get(__ret__, 'id'),
        identities=pulumi.get(__ret__, 'identities'),
        location=pulumi.get(__ret__, 'location'),
        name=pulumi.get(__ret__, 'name'),
        redundancy=pulumi.get(__ret__, 'redundancy'),
        resource_group_name=pulumi.get(__ret__, 'resource_group_name'),
        tags=pulumi.get(__ret__, 'tags'))
def get_backup_vault_output(name: Optional[pulumi.Input[_builtins.str]] = None,
                            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetBackupVaultResult]:
    """
    Use this data source to access information about an existing Backup Vault.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.dataprotection.get_backup_vault(name="existing-backup-vault",
        resource_group_name="existing-resource-group")
    pulumi.export("azurermDataProtectionBackupVaultId", example_azurerm_vpn_gateway["id"])
    pulumi.export("azurermDataProtectionBackupVaultPrincipalId", example.identities[0].principal_id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.DataProtection`: 2024-04-01


    :param _builtins.str name: Specifies the name of the Backup Vault.
    :param _builtins.str resource_group_name: The name of the Resource Group where the Backup Vault exists.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:dataprotection/getBackupVault:getBackupVault', __args__, opts=opts, typ=GetBackupVaultResult)
    return __ret__.apply(lambda __response__: GetBackupVaultResult(
        datastore_type=pulumi.get(__response__, 'datastore_type'),
        id=pulumi.get(__response__, 'id'),
        identities=pulumi.get(__response__, 'identities'),
        location=pulumi.get(__response__, 'location'),
        name=pulumi.get(__response__, 'name'),
        redundancy=pulumi.get(__response__, 'redundancy'),
        resource_group_name=pulumi.get(__response__, 'resource_group_name'),
        tags=pulumi.get(__response__, 'tags')))
