# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['EventhubNamespaceDisasterRecoveryConfigArgs', 'EventhubNamespaceDisasterRecoveryConfig']

@pulumi.input_type
class EventhubNamespaceDisasterRecoveryConfigArgs:
    def __init__(__self__, *,
                 namespace_name: pulumi.Input[_builtins.str],
                 partner_namespace_id: pulumi.Input[_builtins.str],
                 resource_group_name: pulumi.Input[_builtins.str],
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a EventhubNamespaceDisasterRecoveryConfig resource.
        :param pulumi.Input[_builtins.str] namespace_name: Specifies the name of the primary EventHub Namespace to replicate. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] partner_namespace_id: The ID of the EventHub Namespace to replicate to.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which the Disaster Recovery Config exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Disaster Recovery Config. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "namespace_name", namespace_name)
        pulumi.set(__self__, "partner_namespace_id", partner_namespace_id)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="namespaceName")
    def namespace_name(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the name of the primary EventHub Namespace to replicate. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "namespace_name")

    @namespace_name.setter
    def namespace_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "namespace_name", value)

    @_builtins.property
    @pulumi.getter(name="partnerNamespaceId")
    def partner_namespace_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the EventHub Namespace to replicate to.
        """
        return pulumi.get(self, "partner_namespace_id")

    @partner_namespace_id.setter
    def partner_namespace_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "partner_namespace_id", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the resource group in which the Disaster Recovery Config exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the Disaster Recovery Config. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _EventhubNamespaceDisasterRecoveryConfigState:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace_name: Optional[pulumi.Input[_builtins.str]] = None,
                 partner_namespace_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering EventhubNamespaceDisasterRecoveryConfig resources.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Disaster Recovery Config. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] namespace_name: Specifies the name of the primary EventHub Namespace to replicate. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] partner_namespace_id: The ID of the EventHub Namespace to replicate to.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which the Disaster Recovery Config exists. Changing this forces a new resource to be created.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if namespace_name is not None:
            pulumi.set(__self__, "namespace_name", namespace_name)
        if partner_namespace_id is not None:
            pulumi.set(__self__, "partner_namespace_id", partner_namespace_id)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the Disaster Recovery Config. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="namespaceName")
    def namespace_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the primary EventHub Namespace to replicate. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "namespace_name")

    @namespace_name.setter
    def namespace_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace_name", value)

    @_builtins.property
    @pulumi.getter(name="partnerNamespaceId")
    def partner_namespace_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the EventHub Namespace to replicate to.
        """
        return pulumi.get(self, "partner_namespace_id")

    @partner_namespace_id.setter
    def partner_namespace_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "partner_namespace_id", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the resource group in which the Disaster Recovery Config exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_name", value)


@pulumi.type_token("azure:eventhub/eventhubNamespaceDisasterRecoveryConfig:EventhubNamespaceDisasterRecoveryConfig")
class EventhubNamespaceDisasterRecoveryConfig(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace_name: Optional[pulumi.Input[_builtins.str]] = None,
                 partner_namespace_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages an Disaster Recovery Config for an Event Hub Namespace.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="eventhub-replication",
            location="West Europe")
        primary = azure.eventhub.EventHubNamespace("primary",
            name="eventhub-primary",
            location=example.location,
            resource_group_name=example.name,
            sku="Standard")
        secondary = azure.eventhub.EventHubNamespace("secondary",
            name="eventhub-secondary",
            location=example.location,
            resource_group_name=example.name,
            sku="Standard")
        example_eventhub_namespace_disaster_recovery_config = azure.eventhub.EventhubNamespaceDisasterRecoveryConfig("example",
            name="replicate-eventhub",
            resource_group_name=example.name,
            namespace_name=primary.name,
            partner_namespace_id=secondary.id)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.EventHub`: 2024-01-01

        ## Import

        EventHubs can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:eventhub/eventhubNamespaceDisasterRecoveryConfig:EventhubNamespaceDisasterRecoveryConfig config1 /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.EventHub/namespaces/namespace1/disasterRecoveryConfigs/config1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Disaster Recovery Config. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] namespace_name: Specifies the name of the primary EventHub Namespace to replicate. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] partner_namespace_id: The ID of the EventHub Namespace to replicate to.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which the Disaster Recovery Config exists. Changing this forces a new resource to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EventhubNamespaceDisasterRecoveryConfigArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an Disaster Recovery Config for an Event Hub Namespace.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="eventhub-replication",
            location="West Europe")
        primary = azure.eventhub.EventHubNamespace("primary",
            name="eventhub-primary",
            location=example.location,
            resource_group_name=example.name,
            sku="Standard")
        secondary = azure.eventhub.EventHubNamespace("secondary",
            name="eventhub-secondary",
            location=example.location,
            resource_group_name=example.name,
            sku="Standard")
        example_eventhub_namespace_disaster_recovery_config = azure.eventhub.EventhubNamespaceDisasterRecoveryConfig("example",
            name="replicate-eventhub",
            resource_group_name=example.name,
            namespace_name=primary.name,
            partner_namespace_id=secondary.id)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.EventHub`: 2024-01-01

        ## Import

        EventHubs can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:eventhub/eventhubNamespaceDisasterRecoveryConfig:EventhubNamespaceDisasterRecoveryConfig config1 /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.EventHub/namespaces/namespace1/disasterRecoveryConfigs/config1
        ```

        :param str resource_name: The name of the resource.
        :param EventhubNamespaceDisasterRecoveryConfigArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EventhubNamespaceDisasterRecoveryConfigArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace_name: Optional[pulumi.Input[_builtins.str]] = None,
                 partner_namespace_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EventhubNamespaceDisasterRecoveryConfigArgs.__new__(EventhubNamespaceDisasterRecoveryConfigArgs)

            __props__.__dict__["name"] = name
            if namespace_name is None and not opts.urn:
                raise TypeError("Missing required property 'namespace_name'")
            __props__.__dict__["namespace_name"] = namespace_name
            if partner_namespace_id is None and not opts.urn:
                raise TypeError("Missing required property 'partner_namespace_id'")
            __props__.__dict__["partner_namespace_id"] = partner_namespace_id
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
        super(EventhubNamespaceDisasterRecoveryConfig, __self__).__init__(
            'azure:eventhub/eventhubNamespaceDisasterRecoveryConfig:EventhubNamespaceDisasterRecoveryConfig',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            namespace_name: Optional[pulumi.Input[_builtins.str]] = None,
            partner_namespace_id: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None) -> 'EventhubNamespaceDisasterRecoveryConfig':
        """
        Get an existing EventhubNamespaceDisasterRecoveryConfig resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Disaster Recovery Config. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] namespace_name: Specifies the name of the primary EventHub Namespace to replicate. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] partner_namespace_id: The ID of the EventHub Namespace to replicate to.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which the Disaster Recovery Config exists. Changing this forces a new resource to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EventhubNamespaceDisasterRecoveryConfigState.__new__(_EventhubNamespaceDisasterRecoveryConfigState)

        __props__.__dict__["name"] = name
        __props__.__dict__["namespace_name"] = namespace_name
        __props__.__dict__["partner_namespace_id"] = partner_namespace_id
        __props__.__dict__["resource_group_name"] = resource_group_name
        return EventhubNamespaceDisasterRecoveryConfig(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of the Disaster Recovery Config. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="namespaceName")
    def namespace_name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of the primary EventHub Namespace to replicate. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "namespace_name")

    @_builtins.property
    @pulumi.getter(name="partnerNamespaceId")
    def partner_namespace_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the EventHub Namespace to replicate to.
        """
        return pulumi.get(self, "partner_namespace_id")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the resource group in which the Disaster Recovery Config exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

