# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'DomainIdentity',
    'DomainInboundIpRule',
    'DomainInputMappingDefaultValues',
    'DomainInputMappingFields',
    'EventGridTopicIdentity',
    'EventGridTopicInboundIpRule',
    'EventGridTopicInputMappingDefaultValues',
    'EventGridTopicInputMappingFields',
    'EventHubCaptureDescription',
    'EventHubCaptureDescriptionDestination',
    'EventHubNamespaceIdentity',
    'EventHubNamespaceNetworkRulesets',
    'EventHubNamespaceNetworkRulesetsIpRule',
    'EventHubNamespaceNetworkRulesetsVirtualNetworkRule',
    'EventSubscriptionAdvancedFilter',
    'EventSubscriptionAdvancedFilterBoolEqual',
    'EventSubscriptionAdvancedFilterIsNotNull',
    'EventSubscriptionAdvancedFilterIsNullOrUndefined',
    'EventSubscriptionAdvancedFilterNumberGreaterThan',
    'EventSubscriptionAdvancedFilterNumberGreaterThanOrEqual',
    'EventSubscriptionAdvancedFilterNumberIn',
    'EventSubscriptionAdvancedFilterNumberInRange',
    'EventSubscriptionAdvancedFilterNumberLessThan',
    'EventSubscriptionAdvancedFilterNumberLessThanOrEqual',
    'EventSubscriptionAdvancedFilterNumberNotIn',
    'EventSubscriptionAdvancedFilterNumberNotInRange',
    'EventSubscriptionAdvancedFilterStringBeginsWith',
    'EventSubscriptionAdvancedFilterStringContain',
    'EventSubscriptionAdvancedFilterStringEndsWith',
    'EventSubscriptionAdvancedFilterStringIn',
    'EventSubscriptionAdvancedFilterStringNotBeginsWith',
    'EventSubscriptionAdvancedFilterStringNotContain',
    'EventSubscriptionAdvancedFilterStringNotEndsWith',
    'EventSubscriptionAdvancedFilterStringNotIn',
    'EventSubscriptionAzureFunctionEndpoint',
    'EventSubscriptionDeadLetterIdentity',
    'EventSubscriptionDeliveryIdentity',
    'EventSubscriptionDeliveryProperty',
    'EventSubscriptionRetryPolicy',
    'EventSubscriptionStorageBlobDeadLetterDestination',
    'EventSubscriptionStorageQueueEndpoint',
    'EventSubscriptionSubjectFilter',
    'EventSubscriptionWebhookEndpoint',
    'NamespaceCustomerManagedKey',
    'NamespaceIdentity',
    'NamespaceNetworkRuleSet',
    'NamespaceNetworkRuleSetNetworkRule',
    'SubscriptionClientScopedSubscription',
    'SubscriptionRuleCorrelationFilter',
]

@pulumi.output_type
class DomainIdentity(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "identityIds":
            suggest = "identity_ids"
        elif key == "principalId":
            suggest = "principal_id"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DomainIdentity. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DomainIdentity.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DomainIdentity.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: _builtins.str,
                 identity_ids: Optional[Sequence[_builtins.str]] = None,
                 principal_id: Optional[_builtins.str] = None,
                 tenant_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str type: Specifies the type of Managed Service Identity that should be configured on this Event Grid Domain. Possible values are `SystemAssigned`, `UserAssigned`.
        :param Sequence[_builtins.str] identity_ids: Specifies a list of User Assigned Managed Identity IDs to be assigned to this Event Grid Domain.
               
               > **Note:** This is required when `type` is set to `UserAssigned`
               
               > **Note:** When `type` is set to `SystemAssigned`, The assigned `principal_id` and `tenant_id` can be retrieved after the Event Grid Domain has been created. More details are available below.
        :param _builtins.str principal_id: The Principal ID associated with this Managed Service Identity.
        :param _builtins.str tenant_id: The Tenant ID associated with this Managed Service Identity.
        """
        pulumi.set(__self__, "type", type)
        if identity_ids is not None:
            pulumi.set(__self__, "identity_ids", identity_ids)
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Specifies the type of Managed Service Identity that should be configured on this Event Grid Domain. Possible values are `SystemAssigned`, `UserAssigned`.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="identityIds")
    def identity_ids(self) -> Optional[Sequence[_builtins.str]]:
        """
        Specifies a list of User Assigned Managed Identity IDs to be assigned to this Event Grid Domain.

        > **Note:** This is required when `type` is set to `UserAssigned`

        > **Note:** When `type` is set to `SystemAssigned`, The assigned `principal_id` and `tenant_id` can be retrieved after the Event Grid Domain has been created. More details are available below.
        """
        return pulumi.get(self, "identity_ids")

    @_builtins.property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[_builtins.str]:
        """
        The Principal ID associated with this Managed Service Identity.
        """
        return pulumi.get(self, "principal_id")

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[_builtins.str]:
        """
        The Tenant ID associated with this Managed Service Identity.
        """
        return pulumi.get(self, "tenant_id")


@pulumi.output_type
class DomainInboundIpRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipMask":
            suggest = "ip_mask"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DomainInboundIpRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DomainInboundIpRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DomainInboundIpRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ip_mask: _builtins.str,
                 action: Optional[_builtins.str] = None):
        """
        :param _builtins.str ip_mask: The IP mask (CIDR) to match on.
        :param _builtins.str action: The action to take when the rule is matched. Possible values are `Allow`. Defaults to `Allow`.
        """
        pulumi.set(__self__, "ip_mask", ip_mask)
        if action is not None:
            pulumi.set(__self__, "action", action)

    @_builtins.property
    @pulumi.getter(name="ipMask")
    def ip_mask(self) -> _builtins.str:
        """
        The IP mask (CIDR) to match on.
        """
        return pulumi.get(self, "ip_mask")

    @_builtins.property
    @pulumi.getter
    def action(self) -> Optional[_builtins.str]:
        """
        The action to take when the rule is matched. Possible values are `Allow`. Defaults to `Allow`.
        """
        return pulumi.get(self, "action")


@pulumi.output_type
class DomainInputMappingDefaultValues(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataVersion":
            suggest = "data_version"
        elif key == "eventType":
            suggest = "event_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DomainInputMappingDefaultValues. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DomainInputMappingDefaultValues.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DomainInputMappingDefaultValues.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data_version: Optional[_builtins.str] = None,
                 event_type: Optional[_builtins.str] = None,
                 subject: Optional[_builtins.str] = None):
        """
        :param _builtins.str data_version: Specifies the default data version of the EventGrid Event to associate with the domain. Changing this forces a new resource to be created.
        :param _builtins.str event_type: Specifies the default event type of the EventGrid Event to associate with the domain. Changing this forces a new resource to be created.
        :param _builtins.str subject: Specifies the default subject of the EventGrid Event to associate with the domain. Changing this forces a new resource to be created.
        """
        if data_version is not None:
            pulumi.set(__self__, "data_version", data_version)
        if event_type is not None:
            pulumi.set(__self__, "event_type", event_type)
        if subject is not None:
            pulumi.set(__self__, "subject", subject)

    @_builtins.property
    @pulumi.getter(name="dataVersion")
    def data_version(self) -> Optional[_builtins.str]:
        """
        Specifies the default data version of the EventGrid Event to associate with the domain. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "data_version")

    @_builtins.property
    @pulumi.getter(name="eventType")
    def event_type(self) -> Optional[_builtins.str]:
        """
        Specifies the default event type of the EventGrid Event to associate with the domain. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "event_type")

    @_builtins.property
    @pulumi.getter
    def subject(self) -> Optional[_builtins.str]:
        """
        Specifies the default subject of the EventGrid Event to associate with the domain. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "subject")


@pulumi.output_type
class DomainInputMappingFields(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataVersion":
            suggest = "data_version"
        elif key == "eventTime":
            suggest = "event_time"
        elif key == "eventType":
            suggest = "event_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DomainInputMappingFields. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DomainInputMappingFields.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DomainInputMappingFields.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data_version: Optional[_builtins.str] = None,
                 event_time: Optional[_builtins.str] = None,
                 event_type: Optional[_builtins.str] = None,
                 id: Optional[_builtins.str] = None,
                 subject: Optional[_builtins.str] = None,
                 topic: Optional[_builtins.str] = None):
        """
        :param _builtins.str data_version: Specifies the data version of the EventGrid Event to associate with the domain. Changing this forces a new resource to be created.
        :param _builtins.str event_time: Specifies the event time of the EventGrid Event to associate with the domain. Changing this forces a new resource to be created.
        :param _builtins.str event_type: Specifies the event type of the EventGrid Event to associate with the domain. Changing this forces a new resource to be created.
        :param _builtins.str id: Specifies the id of the EventGrid Event to associate with the domain. Changing this forces a new resource to be created.
        :param _builtins.str subject: Specifies the subject of the EventGrid Event to associate with the domain. Changing this forces a new resource to be created.
        :param _builtins.str topic: Specifies the topic of the EventGrid Event to associate with the domain. Changing this forces a new resource to be created.
        """
        if data_version is not None:
            pulumi.set(__self__, "data_version", data_version)
        if event_time is not None:
            pulumi.set(__self__, "event_time", event_time)
        if event_type is not None:
            pulumi.set(__self__, "event_type", event_type)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if subject is not None:
            pulumi.set(__self__, "subject", subject)
        if topic is not None:
            pulumi.set(__self__, "topic", topic)

    @_builtins.property
    @pulumi.getter(name="dataVersion")
    def data_version(self) -> Optional[_builtins.str]:
        """
        Specifies the data version of the EventGrid Event to associate with the domain. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "data_version")

    @_builtins.property
    @pulumi.getter(name="eventTime")
    def event_time(self) -> Optional[_builtins.str]:
        """
        Specifies the event time of the EventGrid Event to associate with the domain. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "event_time")

    @_builtins.property
    @pulumi.getter(name="eventType")
    def event_type(self) -> Optional[_builtins.str]:
        """
        Specifies the event type of the EventGrid Event to associate with the domain. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "event_type")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        Specifies the id of the EventGrid Event to associate with the domain. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def subject(self) -> Optional[_builtins.str]:
        """
        Specifies the subject of the EventGrid Event to associate with the domain. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "subject")

    @_builtins.property
    @pulumi.getter
    def topic(self) -> Optional[_builtins.str]:
        """
        Specifies the topic of the EventGrid Event to associate with the domain. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "topic")


@pulumi.output_type
class EventGridTopicIdentity(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "identityIds":
            suggest = "identity_ids"
        elif key == "principalId":
            suggest = "principal_id"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EventGridTopicIdentity. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EventGridTopicIdentity.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EventGridTopicIdentity.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: _builtins.str,
                 identity_ids: Optional[Sequence[_builtins.str]] = None,
                 principal_id: Optional[_builtins.str] = None,
                 tenant_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str type: Specifies the type of Managed Service Identity that should be configured on this Event Grid Topic. Possible values are `SystemAssigned`, `UserAssigned`.
        :param Sequence[_builtins.str] identity_ids: Specifies a list of User Assigned Managed Identity IDs to be assigned to this Event Grid Topic.
               
               > **Note:** This is required when `type` is set to `UserAssigned`
               
               > **Note:** When `type` is set to `SystemAssigned`, The assigned `principal_id` and `tenant_id` can be retrieved after the Event Grid Topic has been created. More details are available below.
        :param _builtins.str principal_id: The Principal ID associated with this Managed Service Identity.
        :param _builtins.str tenant_id: The Tenant ID associated with this Managed Service Identity.
        """
        pulumi.set(__self__, "type", type)
        if identity_ids is not None:
            pulumi.set(__self__, "identity_ids", identity_ids)
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Specifies the type of Managed Service Identity that should be configured on this Event Grid Topic. Possible values are `SystemAssigned`, `UserAssigned`.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="identityIds")
    def identity_ids(self) -> Optional[Sequence[_builtins.str]]:
        """
        Specifies a list of User Assigned Managed Identity IDs to be assigned to this Event Grid Topic.

        > **Note:** This is required when `type` is set to `UserAssigned`

        > **Note:** When `type` is set to `SystemAssigned`, The assigned `principal_id` and `tenant_id` can be retrieved after the Event Grid Topic has been created. More details are available below.
        """
        return pulumi.get(self, "identity_ids")

    @_builtins.property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[_builtins.str]:
        """
        The Principal ID associated with this Managed Service Identity.
        """
        return pulumi.get(self, "principal_id")

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[_builtins.str]:
        """
        The Tenant ID associated with this Managed Service Identity.
        """
        return pulumi.get(self, "tenant_id")


@pulumi.output_type
class EventGridTopicInboundIpRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipMask":
            suggest = "ip_mask"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EventGridTopicInboundIpRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EventGridTopicInboundIpRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EventGridTopicInboundIpRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ip_mask: _builtins.str,
                 action: Optional[_builtins.str] = None):
        """
        :param _builtins.str ip_mask: The IP mask (CIDR) to match on.
        :param _builtins.str action: The action to take when the rule is matched. Possible values are `Allow`. Defaults to `Allow`.
        """
        pulumi.set(__self__, "ip_mask", ip_mask)
        if action is not None:
            pulumi.set(__self__, "action", action)

    @_builtins.property
    @pulumi.getter(name="ipMask")
    def ip_mask(self) -> _builtins.str:
        """
        The IP mask (CIDR) to match on.
        """
        return pulumi.get(self, "ip_mask")

    @_builtins.property
    @pulumi.getter
    def action(self) -> Optional[_builtins.str]:
        """
        The action to take when the rule is matched. Possible values are `Allow`. Defaults to `Allow`.
        """
        return pulumi.get(self, "action")


@pulumi.output_type
class EventGridTopicInputMappingDefaultValues(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataVersion":
            suggest = "data_version"
        elif key == "eventType":
            suggest = "event_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EventGridTopicInputMappingDefaultValues. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EventGridTopicInputMappingDefaultValues.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EventGridTopicInputMappingDefaultValues.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data_version: Optional[_builtins.str] = None,
                 event_type: Optional[_builtins.str] = None,
                 subject: Optional[_builtins.str] = None):
        """
        :param _builtins.str data_version: Specifies the default data version of the EventGrid Event to associate with the domain. Changing this forces a new resource to be created.
        :param _builtins.str event_type: Specifies the default event type of the EventGrid Event to associate with the domain. Changing this forces a new resource to be created.
        :param _builtins.str subject: Specifies the default subject of the EventGrid Event to associate with the domain. Changing this forces a new resource to be created.
        """
        if data_version is not None:
            pulumi.set(__self__, "data_version", data_version)
        if event_type is not None:
            pulumi.set(__self__, "event_type", event_type)
        if subject is not None:
            pulumi.set(__self__, "subject", subject)

    @_builtins.property
    @pulumi.getter(name="dataVersion")
    def data_version(self) -> Optional[_builtins.str]:
        """
        Specifies the default data version of the EventGrid Event to associate with the domain. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "data_version")

    @_builtins.property
    @pulumi.getter(name="eventType")
    def event_type(self) -> Optional[_builtins.str]:
        """
        Specifies the default event type of the EventGrid Event to associate with the domain. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "event_type")

    @_builtins.property
    @pulumi.getter
    def subject(self) -> Optional[_builtins.str]:
        """
        Specifies the default subject of the EventGrid Event to associate with the domain. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "subject")


@pulumi.output_type
class EventGridTopicInputMappingFields(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataVersion":
            suggest = "data_version"
        elif key == "eventTime":
            suggest = "event_time"
        elif key == "eventType":
            suggest = "event_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EventGridTopicInputMappingFields. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EventGridTopicInputMappingFields.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EventGridTopicInputMappingFields.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data_version: Optional[_builtins.str] = None,
                 event_time: Optional[_builtins.str] = None,
                 event_type: Optional[_builtins.str] = None,
                 id: Optional[_builtins.str] = None,
                 subject: Optional[_builtins.str] = None,
                 topic: Optional[_builtins.str] = None):
        """
        :param _builtins.str data_version: Specifies the data version of the EventGrid Event to associate with the domain. Changing this forces a new resource to be created.
        :param _builtins.str event_time: Specifies the event time of the EventGrid Event to associate with the domain. Changing this forces a new resource to be created.
        :param _builtins.str event_type: Specifies the event type of the EventGrid Event to associate with the domain. Changing this forces a new resource to be created.
        :param _builtins.str id: Specifies the id of the EventGrid Event to associate with the domain. Changing this forces a new resource to be created.
        :param _builtins.str subject: Specifies the subject of the EventGrid Event to associate with the domain. Changing this forces a new resource to be created.
        :param _builtins.str topic: Specifies the topic of the EventGrid Event to associate with the domain. Changing this forces a new resource to be created.
        """
        if data_version is not None:
            pulumi.set(__self__, "data_version", data_version)
        if event_time is not None:
            pulumi.set(__self__, "event_time", event_time)
        if event_type is not None:
            pulumi.set(__self__, "event_type", event_type)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if subject is not None:
            pulumi.set(__self__, "subject", subject)
        if topic is not None:
            pulumi.set(__self__, "topic", topic)

    @_builtins.property
    @pulumi.getter(name="dataVersion")
    def data_version(self) -> Optional[_builtins.str]:
        """
        Specifies the data version of the EventGrid Event to associate with the domain. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "data_version")

    @_builtins.property
    @pulumi.getter(name="eventTime")
    def event_time(self) -> Optional[_builtins.str]:
        """
        Specifies the event time of the EventGrid Event to associate with the domain. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "event_time")

    @_builtins.property
    @pulumi.getter(name="eventType")
    def event_type(self) -> Optional[_builtins.str]:
        """
        Specifies the event type of the EventGrid Event to associate with the domain. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "event_type")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        Specifies the id of the EventGrid Event to associate with the domain. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def subject(self) -> Optional[_builtins.str]:
        """
        Specifies the subject of the EventGrid Event to associate with the domain. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "subject")

    @_builtins.property
    @pulumi.getter
    def topic(self) -> Optional[_builtins.str]:
        """
        Specifies the topic of the EventGrid Event to associate with the domain. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "topic")


@pulumi.output_type
class EventHubCaptureDescription(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "intervalInSeconds":
            suggest = "interval_in_seconds"
        elif key == "sizeLimitInBytes":
            suggest = "size_limit_in_bytes"
        elif key == "skipEmptyArchives":
            suggest = "skip_empty_archives"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EventHubCaptureDescription. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EventHubCaptureDescription.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EventHubCaptureDescription.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 destination: 'outputs.EventHubCaptureDescriptionDestination',
                 enabled: _builtins.bool,
                 encoding: _builtins.str,
                 interval_in_seconds: Optional[_builtins.int] = None,
                 size_limit_in_bytes: Optional[_builtins.int] = None,
                 skip_empty_archives: Optional[_builtins.bool] = None):
        """
        :param 'EventHubCaptureDescriptionDestinationArgs' destination: A `destination` block as defined below.
        :param _builtins.bool enabled: Specifies if the Capture Description is Enabled.
        :param _builtins.str encoding: Specifies the Encoding used for the Capture Description. Possible values are `Avro` and `AvroDeflate`.
        :param _builtins.int interval_in_seconds: Specifies the time interval in seconds at which the capture will happen. Values can be between `60` and `900` seconds. Defaults to `300` seconds.
        :param _builtins.int size_limit_in_bytes: Specifies the amount of data built up in your EventHub before a Capture Operation occurs. Value should be between `10485760` and `524288000` bytes. Defaults to `314572800` bytes.
        :param _builtins.bool skip_empty_archives: Specifies if empty files should not be emitted if no events occur during the Capture time window. Defaults to `false`.
        """
        pulumi.set(__self__, "destination", destination)
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "encoding", encoding)
        if interval_in_seconds is not None:
            pulumi.set(__self__, "interval_in_seconds", interval_in_seconds)
        if size_limit_in_bytes is not None:
            pulumi.set(__self__, "size_limit_in_bytes", size_limit_in_bytes)
        if skip_empty_archives is not None:
            pulumi.set(__self__, "skip_empty_archives", skip_empty_archives)

    @_builtins.property
    @pulumi.getter
    def destination(self) -> 'outputs.EventHubCaptureDescriptionDestination':
        """
        A `destination` block as defined below.
        """
        return pulumi.get(self, "destination")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        """
        Specifies if the Capture Description is Enabled.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter
    def encoding(self) -> _builtins.str:
        """
        Specifies the Encoding used for the Capture Description. Possible values are `Avro` and `AvroDeflate`.
        """
        return pulumi.get(self, "encoding")

    @_builtins.property
    @pulumi.getter(name="intervalInSeconds")
    def interval_in_seconds(self) -> Optional[_builtins.int]:
        """
        Specifies the time interval in seconds at which the capture will happen. Values can be between `60` and `900` seconds. Defaults to `300` seconds.
        """
        return pulumi.get(self, "interval_in_seconds")

    @_builtins.property
    @pulumi.getter(name="sizeLimitInBytes")
    def size_limit_in_bytes(self) -> Optional[_builtins.int]:
        """
        Specifies the amount of data built up in your EventHub before a Capture Operation occurs. Value should be between `10485760` and `524288000` bytes. Defaults to `314572800` bytes.
        """
        return pulumi.get(self, "size_limit_in_bytes")

    @_builtins.property
    @pulumi.getter(name="skipEmptyArchives")
    def skip_empty_archives(self) -> Optional[_builtins.bool]:
        """
        Specifies if empty files should not be emitted if no events occur during the Capture time window. Defaults to `false`.
        """
        return pulumi.get(self, "skip_empty_archives")


@pulumi.output_type
class EventHubCaptureDescriptionDestination(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "archiveNameFormat":
            suggest = "archive_name_format"
        elif key == "blobContainerName":
            suggest = "blob_container_name"
        elif key == "storageAccountId":
            suggest = "storage_account_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EventHubCaptureDescriptionDestination. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EventHubCaptureDescriptionDestination.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EventHubCaptureDescriptionDestination.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 archive_name_format: _builtins.str,
                 blob_container_name: _builtins.str,
                 name: _builtins.str,
                 storage_account_id: _builtins.str):
        """
        :param _builtins.str archive_name_format: The Blob naming convention for archiving. e.g. `{Namespace}/{EventHub}/{PartitionId}/{Year}/{Month}/{Day}/{Hour}/{Minute}/{Second}`. Here all the parameters (Namespace,EventHub .. etc) are mandatory irrespective of order
        :param _builtins.str blob_container_name: The name of the Container within the Blob Storage Account where messages should be archived.
        :param _builtins.str name: The Name of the Destination where the capture should take place. At this time the only supported value is `EventHubArchive.AzureBlockBlob`.
               
               > **Note:** At this time it's only possible to Capture EventHub messages to Blob Storage. There's [a Feature Request for the Azure SDK to add support for Capturing messages to Azure Data Lake here](https://github.com/Azure/azure-rest-api-specs/issues/2255).
        :param _builtins.str storage_account_id: The ID of the Blob Storage Account where messages should be archived.
        """
        pulumi.set(__self__, "archive_name_format", archive_name_format)
        pulumi.set(__self__, "blob_container_name", blob_container_name)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "storage_account_id", storage_account_id)

    @_builtins.property
    @pulumi.getter(name="archiveNameFormat")
    def archive_name_format(self) -> _builtins.str:
        """
        The Blob naming convention for archiving. e.g. `{Namespace}/{EventHub}/{PartitionId}/{Year}/{Month}/{Day}/{Hour}/{Minute}/{Second}`. Here all the parameters (Namespace,EventHub .. etc) are mandatory irrespective of order
        """
        return pulumi.get(self, "archive_name_format")

    @_builtins.property
    @pulumi.getter(name="blobContainerName")
    def blob_container_name(self) -> _builtins.str:
        """
        The name of the Container within the Blob Storage Account where messages should be archived.
        """
        return pulumi.get(self, "blob_container_name")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The Name of the Destination where the capture should take place. At this time the only supported value is `EventHubArchive.AzureBlockBlob`.

        > **Note:** At this time it's only possible to Capture EventHub messages to Blob Storage. There's [a Feature Request for the Azure SDK to add support for Capturing messages to Azure Data Lake here](https://github.com/Azure/azure-rest-api-specs/issues/2255).
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="storageAccountId")
    def storage_account_id(self) -> _builtins.str:
        """
        The ID of the Blob Storage Account where messages should be archived.
        """
        return pulumi.get(self, "storage_account_id")


@pulumi.output_type
class EventHubNamespaceIdentity(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "identityIds":
            suggest = "identity_ids"
        elif key == "principalId":
            suggest = "principal_id"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EventHubNamespaceIdentity. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EventHubNamespaceIdentity.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EventHubNamespaceIdentity.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: _builtins.str,
                 identity_ids: Optional[Sequence[_builtins.str]] = None,
                 principal_id: Optional[_builtins.str] = None,
                 tenant_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str type: Specifies the type of Managed Service Identity that should be configured on this Event Hub Namespace. Possible values are `SystemAssigned` or `UserAssigned`.
        :param Sequence[_builtins.str] identity_ids: Specifies a list of User Assigned Managed Identity IDs to be assigned to this EventHub namespace.
               
               > **Note:** This is required when `type` is set to `UserAssigned` or `SystemAssigned, UserAssigned`.
               
               > **Note:** Due to the limitation of the current Azure API, once an EventHub Namespace has been assigned an identity, it cannot be removed.
        :param _builtins.str principal_id: The Principal ID associated with this Managed Service Identity.
        :param _builtins.str tenant_id: The Tenant ID associated with this Managed Service Identity.
        """
        pulumi.set(__self__, "type", type)
        if identity_ids is not None:
            pulumi.set(__self__, "identity_ids", identity_ids)
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Specifies the type of Managed Service Identity that should be configured on this Event Hub Namespace. Possible values are `SystemAssigned` or `UserAssigned`.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="identityIds")
    def identity_ids(self) -> Optional[Sequence[_builtins.str]]:
        """
        Specifies a list of User Assigned Managed Identity IDs to be assigned to this EventHub namespace.

        > **Note:** This is required when `type` is set to `UserAssigned` or `SystemAssigned, UserAssigned`.

        > **Note:** Due to the limitation of the current Azure API, once an EventHub Namespace has been assigned an identity, it cannot be removed.
        """
        return pulumi.get(self, "identity_ids")

    @_builtins.property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[_builtins.str]:
        """
        The Principal ID associated with this Managed Service Identity.
        """
        return pulumi.get(self, "principal_id")

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[_builtins.str]:
        """
        The Tenant ID associated with this Managed Service Identity.
        """
        return pulumi.get(self, "tenant_id")


@pulumi.output_type
class EventHubNamespaceNetworkRulesets(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultAction":
            suggest = "default_action"
        elif key == "ipRules":
            suggest = "ip_rules"
        elif key == "publicNetworkAccessEnabled":
            suggest = "public_network_access_enabled"
        elif key == "trustedServiceAccessEnabled":
            suggest = "trusted_service_access_enabled"
        elif key == "virtualNetworkRules":
            suggest = "virtual_network_rules"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EventHubNamespaceNetworkRulesets. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EventHubNamespaceNetworkRulesets.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EventHubNamespaceNetworkRulesets.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 default_action: _builtins.str,
                 ip_rules: Optional[Sequence['outputs.EventHubNamespaceNetworkRulesetsIpRule']] = None,
                 public_network_access_enabled: Optional[_builtins.bool] = None,
                 trusted_service_access_enabled: Optional[_builtins.bool] = None,
                 virtual_network_rules: Optional[Sequence['outputs.EventHubNamespaceNetworkRulesetsVirtualNetworkRule']] = None):
        """
        :param _builtins.str default_action: The default action to take when a rule is not matched. Possible values are `Allow` and `Deny`.
        :param Sequence['EventHubNamespaceNetworkRulesetsIpRuleArgs'] ip_rules: One or more `ip_rule` blocks as defined below.
        :param _builtins.bool public_network_access_enabled: Is public network access enabled for the EventHub Namespace? Defaults to `true`.
               
               > **Note:** The public network access setting at the network rule sets level should be the same as it's at the namespace level.
        :param _builtins.bool trusted_service_access_enabled: Whether Trusted Microsoft Services are allowed to bypass firewall.
        :param Sequence['EventHubNamespaceNetworkRulesetsVirtualNetworkRuleArgs'] virtual_network_rules: One or more `virtual_network_rule` blocks as defined below.
        """
        pulumi.set(__self__, "default_action", default_action)
        if ip_rules is not None:
            pulumi.set(__self__, "ip_rules", ip_rules)
        if public_network_access_enabled is not None:
            pulumi.set(__self__, "public_network_access_enabled", public_network_access_enabled)
        if trusted_service_access_enabled is not None:
            pulumi.set(__self__, "trusted_service_access_enabled", trusted_service_access_enabled)
        if virtual_network_rules is not None:
            pulumi.set(__self__, "virtual_network_rules", virtual_network_rules)

    @_builtins.property
    @pulumi.getter(name="defaultAction")
    def default_action(self) -> _builtins.str:
        """
        The default action to take when a rule is not matched. Possible values are `Allow` and `Deny`.
        """
        return pulumi.get(self, "default_action")

    @_builtins.property
    @pulumi.getter(name="ipRules")
    def ip_rules(self) -> Optional[Sequence['outputs.EventHubNamespaceNetworkRulesetsIpRule']]:
        """
        One or more `ip_rule` blocks as defined below.
        """
        return pulumi.get(self, "ip_rules")

    @_builtins.property
    @pulumi.getter(name="publicNetworkAccessEnabled")
    def public_network_access_enabled(self) -> Optional[_builtins.bool]:
        """
        Is public network access enabled for the EventHub Namespace? Defaults to `true`.

        > **Note:** The public network access setting at the network rule sets level should be the same as it's at the namespace level.
        """
        return pulumi.get(self, "public_network_access_enabled")

    @_builtins.property
    @pulumi.getter(name="trustedServiceAccessEnabled")
    def trusted_service_access_enabled(self) -> Optional[_builtins.bool]:
        """
        Whether Trusted Microsoft Services are allowed to bypass firewall.
        """
        return pulumi.get(self, "trusted_service_access_enabled")

    @_builtins.property
    @pulumi.getter(name="virtualNetworkRules")
    def virtual_network_rules(self) -> Optional[Sequence['outputs.EventHubNamespaceNetworkRulesetsVirtualNetworkRule']]:
        """
        One or more `virtual_network_rule` blocks as defined below.
        """
        return pulumi.get(self, "virtual_network_rules")


@pulumi.output_type
class EventHubNamespaceNetworkRulesetsIpRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipMask":
            suggest = "ip_mask"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EventHubNamespaceNetworkRulesetsIpRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EventHubNamespaceNetworkRulesetsIpRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EventHubNamespaceNetworkRulesetsIpRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ip_mask: _builtins.str,
                 action: Optional[_builtins.str] = None):
        """
        :param _builtins.str ip_mask: The IP mask to match on.
        :param _builtins.str action: The action to take when the rule is matched. Possible values are `Allow`. Defaults to `Allow`.
        """
        pulumi.set(__self__, "ip_mask", ip_mask)
        if action is not None:
            pulumi.set(__self__, "action", action)

    @_builtins.property
    @pulumi.getter(name="ipMask")
    def ip_mask(self) -> _builtins.str:
        """
        The IP mask to match on.
        """
        return pulumi.get(self, "ip_mask")

    @_builtins.property
    @pulumi.getter
    def action(self) -> Optional[_builtins.str]:
        """
        The action to take when the rule is matched. Possible values are `Allow`. Defaults to `Allow`.
        """
        return pulumi.get(self, "action")


@pulumi.output_type
class EventHubNamespaceNetworkRulesetsVirtualNetworkRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "subnetId":
            suggest = "subnet_id"
        elif key == "ignoreMissingVirtualNetworkServiceEndpoint":
            suggest = "ignore_missing_virtual_network_service_endpoint"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EventHubNamespaceNetworkRulesetsVirtualNetworkRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EventHubNamespaceNetworkRulesetsVirtualNetworkRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EventHubNamespaceNetworkRulesetsVirtualNetworkRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 subnet_id: _builtins.str,
                 ignore_missing_virtual_network_service_endpoint: Optional[_builtins.bool] = None):
        """
        :param _builtins.str subnet_id: The id of the subnet to match on.
        :param _builtins.bool ignore_missing_virtual_network_service_endpoint: Are missing virtual network service endpoints ignored?
        """
        pulumi.set(__self__, "subnet_id", subnet_id)
        if ignore_missing_virtual_network_service_endpoint is not None:
            pulumi.set(__self__, "ignore_missing_virtual_network_service_endpoint", ignore_missing_virtual_network_service_endpoint)

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> _builtins.str:
        """
        The id of the subnet to match on.
        """
        return pulumi.get(self, "subnet_id")

    @_builtins.property
    @pulumi.getter(name="ignoreMissingVirtualNetworkServiceEndpoint")
    def ignore_missing_virtual_network_service_endpoint(self) -> Optional[_builtins.bool]:
        """
        Are missing virtual network service endpoints ignored?
        """
        return pulumi.get(self, "ignore_missing_virtual_network_service_endpoint")


@pulumi.output_type
class EventSubscriptionAdvancedFilter(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "boolEquals":
            suggest = "bool_equals"
        elif key == "isNotNulls":
            suggest = "is_not_nulls"
        elif key == "isNullOrUndefineds":
            suggest = "is_null_or_undefineds"
        elif key == "numberGreaterThanOrEquals":
            suggest = "number_greater_than_or_equals"
        elif key == "numberGreaterThans":
            suggest = "number_greater_thans"
        elif key == "numberInRanges":
            suggest = "number_in_ranges"
        elif key == "numberIns":
            suggest = "number_ins"
        elif key == "numberLessThanOrEquals":
            suggest = "number_less_than_or_equals"
        elif key == "numberLessThans":
            suggest = "number_less_thans"
        elif key == "numberNotInRanges":
            suggest = "number_not_in_ranges"
        elif key == "numberNotIns":
            suggest = "number_not_ins"
        elif key == "stringBeginsWiths":
            suggest = "string_begins_withs"
        elif key == "stringContains":
            suggest = "string_contains"
        elif key == "stringEndsWiths":
            suggest = "string_ends_withs"
        elif key == "stringIns":
            suggest = "string_ins"
        elif key == "stringNotBeginsWiths":
            suggest = "string_not_begins_withs"
        elif key == "stringNotContains":
            suggest = "string_not_contains"
        elif key == "stringNotEndsWiths":
            suggest = "string_not_ends_withs"
        elif key == "stringNotIns":
            suggest = "string_not_ins"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EventSubscriptionAdvancedFilter. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EventSubscriptionAdvancedFilter.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EventSubscriptionAdvancedFilter.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bool_equals: Optional[Sequence['outputs.EventSubscriptionAdvancedFilterBoolEqual']] = None,
                 is_not_nulls: Optional[Sequence['outputs.EventSubscriptionAdvancedFilterIsNotNull']] = None,
                 is_null_or_undefineds: Optional[Sequence['outputs.EventSubscriptionAdvancedFilterIsNullOrUndefined']] = None,
                 number_greater_than_or_equals: Optional[Sequence['outputs.EventSubscriptionAdvancedFilterNumberGreaterThanOrEqual']] = None,
                 number_greater_thans: Optional[Sequence['outputs.EventSubscriptionAdvancedFilterNumberGreaterThan']] = None,
                 number_in_ranges: Optional[Sequence['outputs.EventSubscriptionAdvancedFilterNumberInRange']] = None,
                 number_ins: Optional[Sequence['outputs.EventSubscriptionAdvancedFilterNumberIn']] = None,
                 number_less_than_or_equals: Optional[Sequence['outputs.EventSubscriptionAdvancedFilterNumberLessThanOrEqual']] = None,
                 number_less_thans: Optional[Sequence['outputs.EventSubscriptionAdvancedFilterNumberLessThan']] = None,
                 number_not_in_ranges: Optional[Sequence['outputs.EventSubscriptionAdvancedFilterNumberNotInRange']] = None,
                 number_not_ins: Optional[Sequence['outputs.EventSubscriptionAdvancedFilterNumberNotIn']] = None,
                 string_begins_withs: Optional[Sequence['outputs.EventSubscriptionAdvancedFilterStringBeginsWith']] = None,
                 string_contains: Optional[Sequence['outputs.EventSubscriptionAdvancedFilterStringContain']] = None,
                 string_ends_withs: Optional[Sequence['outputs.EventSubscriptionAdvancedFilterStringEndsWith']] = None,
                 string_ins: Optional[Sequence['outputs.EventSubscriptionAdvancedFilterStringIn']] = None,
                 string_not_begins_withs: Optional[Sequence['outputs.EventSubscriptionAdvancedFilterStringNotBeginsWith']] = None,
                 string_not_contains: Optional[Sequence['outputs.EventSubscriptionAdvancedFilterStringNotContain']] = None,
                 string_not_ends_withs: Optional[Sequence['outputs.EventSubscriptionAdvancedFilterStringNotEndsWith']] = None,
                 string_not_ins: Optional[Sequence['outputs.EventSubscriptionAdvancedFilterStringNotIn']] = None):
        """
        :param Sequence['EventSubscriptionAdvancedFilterBoolEqualArgs'] bool_equals: Compares a value of an event using a single boolean value.
        :param Sequence['EventSubscriptionAdvancedFilterIsNotNullArgs'] is_not_nulls: Evaluates if a value of an event isn't NULL or undefined.
        :param Sequence['EventSubscriptionAdvancedFilterIsNullOrUndefinedArgs'] is_null_or_undefineds: Evaluates if a value of an event is NULL or undefined.
               
               Each nested block consists of a key and a value(s) element.
        :param Sequence['EventSubscriptionAdvancedFilterNumberGreaterThanOrEqualArgs'] number_greater_than_or_equals: Compares a value of an event using a single floating point number.
        :param Sequence['EventSubscriptionAdvancedFilterNumberGreaterThanArgs'] number_greater_thans: Compares a value of an event using a single floating point number.
        :param Sequence['EventSubscriptionAdvancedFilterNumberInRangeArgs'] number_in_ranges: Compares a value of an event using multiple floating point number ranges.
        :param Sequence['EventSubscriptionAdvancedFilterNumberInArgs'] number_ins: Compares a value of an event using multiple floating point numbers.
        :param Sequence['EventSubscriptionAdvancedFilterNumberLessThanOrEqualArgs'] number_less_than_or_equals: Compares a value of an event using a single floating point number.
        :param Sequence['EventSubscriptionAdvancedFilterNumberLessThanArgs'] number_less_thans: Compares a value of an event using a single floating point number.
        :param Sequence['EventSubscriptionAdvancedFilterNumberNotInRangeArgs'] number_not_in_ranges: Compares a value of an event using multiple floating point number ranges.
        :param Sequence['EventSubscriptionAdvancedFilterNumberNotInArgs'] number_not_ins: Compares a value of an event using multiple floating point numbers.
        :param Sequence['EventSubscriptionAdvancedFilterStringBeginsWithArgs'] string_begins_withs: Compares a value of an event using multiple string values.
        :param Sequence['EventSubscriptionAdvancedFilterStringContainArgs'] string_contains: Compares a value of an event using multiple string values.
        :param Sequence['EventSubscriptionAdvancedFilterStringEndsWithArgs'] string_ends_withs: Compares a value of an event using multiple string values.
        :param Sequence['EventSubscriptionAdvancedFilterStringInArgs'] string_ins: Compares a value of an event using multiple string values.
        :param Sequence['EventSubscriptionAdvancedFilterStringNotBeginsWithArgs'] string_not_begins_withs: Compares a value of an event using multiple string values.
        :param Sequence['EventSubscriptionAdvancedFilterStringNotContainArgs'] string_not_contains: Compares a value of an event using multiple string values.
        :param Sequence['EventSubscriptionAdvancedFilterStringNotEndsWithArgs'] string_not_ends_withs: Compares a value of an event using multiple string values.
        :param Sequence['EventSubscriptionAdvancedFilterStringNotInArgs'] string_not_ins: Compares a value of an event using multiple string values.
        """
        if bool_equals is not None:
            pulumi.set(__self__, "bool_equals", bool_equals)
        if is_not_nulls is not None:
            pulumi.set(__self__, "is_not_nulls", is_not_nulls)
        if is_null_or_undefineds is not None:
            pulumi.set(__self__, "is_null_or_undefineds", is_null_or_undefineds)
        if number_greater_than_or_equals is not None:
            pulumi.set(__self__, "number_greater_than_or_equals", number_greater_than_or_equals)
        if number_greater_thans is not None:
            pulumi.set(__self__, "number_greater_thans", number_greater_thans)
        if number_in_ranges is not None:
            pulumi.set(__self__, "number_in_ranges", number_in_ranges)
        if number_ins is not None:
            pulumi.set(__self__, "number_ins", number_ins)
        if number_less_than_or_equals is not None:
            pulumi.set(__self__, "number_less_than_or_equals", number_less_than_or_equals)
        if number_less_thans is not None:
            pulumi.set(__self__, "number_less_thans", number_less_thans)
        if number_not_in_ranges is not None:
            pulumi.set(__self__, "number_not_in_ranges", number_not_in_ranges)
        if number_not_ins is not None:
            pulumi.set(__self__, "number_not_ins", number_not_ins)
        if string_begins_withs is not None:
            pulumi.set(__self__, "string_begins_withs", string_begins_withs)
        if string_contains is not None:
            pulumi.set(__self__, "string_contains", string_contains)
        if string_ends_withs is not None:
            pulumi.set(__self__, "string_ends_withs", string_ends_withs)
        if string_ins is not None:
            pulumi.set(__self__, "string_ins", string_ins)
        if string_not_begins_withs is not None:
            pulumi.set(__self__, "string_not_begins_withs", string_not_begins_withs)
        if string_not_contains is not None:
            pulumi.set(__self__, "string_not_contains", string_not_contains)
        if string_not_ends_withs is not None:
            pulumi.set(__self__, "string_not_ends_withs", string_not_ends_withs)
        if string_not_ins is not None:
            pulumi.set(__self__, "string_not_ins", string_not_ins)

    @_builtins.property
    @pulumi.getter(name="boolEquals")
    def bool_equals(self) -> Optional[Sequence['outputs.EventSubscriptionAdvancedFilterBoolEqual']]:
        """
        Compares a value of an event using a single boolean value.
        """
        return pulumi.get(self, "bool_equals")

    @_builtins.property
    @pulumi.getter(name="isNotNulls")
    def is_not_nulls(self) -> Optional[Sequence['outputs.EventSubscriptionAdvancedFilterIsNotNull']]:
        """
        Evaluates if a value of an event isn't NULL or undefined.
        """
        return pulumi.get(self, "is_not_nulls")

    @_builtins.property
    @pulumi.getter(name="isNullOrUndefineds")
    def is_null_or_undefineds(self) -> Optional[Sequence['outputs.EventSubscriptionAdvancedFilterIsNullOrUndefined']]:
        """
        Evaluates if a value of an event is NULL or undefined.

        Each nested block consists of a key and a value(s) element.
        """
        return pulumi.get(self, "is_null_or_undefineds")

    @_builtins.property
    @pulumi.getter(name="numberGreaterThanOrEquals")
    def number_greater_than_or_equals(self) -> Optional[Sequence['outputs.EventSubscriptionAdvancedFilterNumberGreaterThanOrEqual']]:
        """
        Compares a value of an event using a single floating point number.
        """
        return pulumi.get(self, "number_greater_than_or_equals")

    @_builtins.property
    @pulumi.getter(name="numberGreaterThans")
    def number_greater_thans(self) -> Optional[Sequence['outputs.EventSubscriptionAdvancedFilterNumberGreaterThan']]:
        """
        Compares a value of an event using a single floating point number.
        """
        return pulumi.get(self, "number_greater_thans")

    @_builtins.property
    @pulumi.getter(name="numberInRanges")
    def number_in_ranges(self) -> Optional[Sequence['outputs.EventSubscriptionAdvancedFilterNumberInRange']]:
        """
        Compares a value of an event using multiple floating point number ranges.
        """
        return pulumi.get(self, "number_in_ranges")

    @_builtins.property
    @pulumi.getter(name="numberIns")
    def number_ins(self) -> Optional[Sequence['outputs.EventSubscriptionAdvancedFilterNumberIn']]:
        """
        Compares a value of an event using multiple floating point numbers.
        """
        return pulumi.get(self, "number_ins")

    @_builtins.property
    @pulumi.getter(name="numberLessThanOrEquals")
    def number_less_than_or_equals(self) -> Optional[Sequence['outputs.EventSubscriptionAdvancedFilterNumberLessThanOrEqual']]:
        """
        Compares a value of an event using a single floating point number.
        """
        return pulumi.get(self, "number_less_than_or_equals")

    @_builtins.property
    @pulumi.getter(name="numberLessThans")
    def number_less_thans(self) -> Optional[Sequence['outputs.EventSubscriptionAdvancedFilterNumberLessThan']]:
        """
        Compares a value of an event using a single floating point number.
        """
        return pulumi.get(self, "number_less_thans")

    @_builtins.property
    @pulumi.getter(name="numberNotInRanges")
    def number_not_in_ranges(self) -> Optional[Sequence['outputs.EventSubscriptionAdvancedFilterNumberNotInRange']]:
        """
        Compares a value of an event using multiple floating point number ranges.
        """
        return pulumi.get(self, "number_not_in_ranges")

    @_builtins.property
    @pulumi.getter(name="numberNotIns")
    def number_not_ins(self) -> Optional[Sequence['outputs.EventSubscriptionAdvancedFilterNumberNotIn']]:
        """
        Compares a value of an event using multiple floating point numbers.
        """
        return pulumi.get(self, "number_not_ins")

    @_builtins.property
    @pulumi.getter(name="stringBeginsWiths")
    def string_begins_withs(self) -> Optional[Sequence['outputs.EventSubscriptionAdvancedFilterStringBeginsWith']]:
        """
        Compares a value of an event using multiple string values.
        """
        return pulumi.get(self, "string_begins_withs")

    @_builtins.property
    @pulumi.getter(name="stringContains")
    def string_contains(self) -> Optional[Sequence['outputs.EventSubscriptionAdvancedFilterStringContain']]:
        """
        Compares a value of an event using multiple string values.
        """
        return pulumi.get(self, "string_contains")

    @_builtins.property
    @pulumi.getter(name="stringEndsWiths")
    def string_ends_withs(self) -> Optional[Sequence['outputs.EventSubscriptionAdvancedFilterStringEndsWith']]:
        """
        Compares a value of an event using multiple string values.
        """
        return pulumi.get(self, "string_ends_withs")

    @_builtins.property
    @pulumi.getter(name="stringIns")
    def string_ins(self) -> Optional[Sequence['outputs.EventSubscriptionAdvancedFilterStringIn']]:
        """
        Compares a value of an event using multiple string values.
        """
        return pulumi.get(self, "string_ins")

    @_builtins.property
    @pulumi.getter(name="stringNotBeginsWiths")
    def string_not_begins_withs(self) -> Optional[Sequence['outputs.EventSubscriptionAdvancedFilterStringNotBeginsWith']]:
        """
        Compares a value of an event using multiple string values.
        """
        return pulumi.get(self, "string_not_begins_withs")

    @_builtins.property
    @pulumi.getter(name="stringNotContains")
    def string_not_contains(self) -> Optional[Sequence['outputs.EventSubscriptionAdvancedFilterStringNotContain']]:
        """
        Compares a value of an event using multiple string values.
        """
        return pulumi.get(self, "string_not_contains")

    @_builtins.property
    @pulumi.getter(name="stringNotEndsWiths")
    def string_not_ends_withs(self) -> Optional[Sequence['outputs.EventSubscriptionAdvancedFilterStringNotEndsWith']]:
        """
        Compares a value of an event using multiple string values.
        """
        return pulumi.get(self, "string_not_ends_withs")

    @_builtins.property
    @pulumi.getter(name="stringNotIns")
    def string_not_ins(self) -> Optional[Sequence['outputs.EventSubscriptionAdvancedFilterStringNotIn']]:
        """
        Compares a value of an event using multiple string values.
        """
        return pulumi.get(self, "string_not_ins")


@pulumi.output_type
class EventSubscriptionAdvancedFilterBoolEqual(dict):
    def __init__(__self__, *,
                 key: _builtins.str,
                 value: _builtins.bool):
        """
        :param _builtins.str key: Specifies the field within the event data that you want to use for filtering. Type of the field can be a number, boolean, or string.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def key(self) -> _builtins.str:
        """
        Specifies the field within the event data that you want to use for filtering. Type of the field can be a number, boolean, or string.
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.bool:
        return pulumi.get(self, "value")


@pulumi.output_type
class EventSubscriptionAdvancedFilterIsNotNull(dict):
    def __init__(__self__, *,
                 key: _builtins.str):
        """
        :param _builtins.str key: Specifies the field within the event data that you want to use for filtering. Type of the field can be a number, boolean, or string.
        """
        pulumi.set(__self__, "key", key)

    @_builtins.property
    @pulumi.getter
    def key(self) -> _builtins.str:
        """
        Specifies the field within the event data that you want to use for filtering. Type of the field can be a number, boolean, or string.
        """
        return pulumi.get(self, "key")


@pulumi.output_type
class EventSubscriptionAdvancedFilterIsNullOrUndefined(dict):
    def __init__(__self__, *,
                 key: _builtins.str):
        """
        :param _builtins.str key: Specifies the field within the event data that you want to use for filtering. Type of the field can be a number, boolean, or string.
        """
        pulumi.set(__self__, "key", key)

    @_builtins.property
    @pulumi.getter
    def key(self) -> _builtins.str:
        """
        Specifies the field within the event data that you want to use for filtering. Type of the field can be a number, boolean, or string.
        """
        return pulumi.get(self, "key")


@pulumi.output_type
class EventSubscriptionAdvancedFilterNumberGreaterThan(dict):
    def __init__(__self__, *,
                 key: _builtins.str,
                 value: _builtins.float):
        """
        :param _builtins.str key: Specifies the field within the event data that you want to use for filtering. Type of the field can be a number, boolean, or string.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def key(self) -> _builtins.str:
        """
        Specifies the field within the event data that you want to use for filtering. Type of the field can be a number, boolean, or string.
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.float:
        return pulumi.get(self, "value")


@pulumi.output_type
class EventSubscriptionAdvancedFilterNumberGreaterThanOrEqual(dict):
    def __init__(__self__, *,
                 key: _builtins.str,
                 value: _builtins.float):
        """
        :param _builtins.str key: Specifies the field within the event data that you want to use for filtering. Type of the field can be a number, boolean, or string.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def key(self) -> _builtins.str:
        """
        Specifies the field within the event data that you want to use for filtering. Type of the field can be a number, boolean, or string.
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.float:
        return pulumi.get(self, "value")


@pulumi.output_type
class EventSubscriptionAdvancedFilterNumberIn(dict):
    def __init__(__self__, *,
                 key: _builtins.str,
                 values: Sequence[_builtins.float]):
        """
        :param _builtins.str key: Specifies the field within the event data that you want to use for filtering. Type of the field can be a number, boolean, or string.
        :param Sequence[_builtins.float] values: Specifies an array of values to compare to when using a multiple values operator.
               
               > **Note:** A maximum of total number of advanced filter values allowed on event subscription is 25.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "values", values)

    @_builtins.property
    @pulumi.getter
    def key(self) -> _builtins.str:
        """
        Specifies the field within the event data that you want to use for filtering. Type of the field can be a number, boolean, or string.
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.float]:
        """
        Specifies an array of values to compare to when using a multiple values operator.

        > **Note:** A maximum of total number of advanced filter values allowed on event subscription is 25.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class EventSubscriptionAdvancedFilterNumberInRange(dict):
    def __init__(__self__, *,
                 key: _builtins.str,
                 values: Sequence[Sequence[_builtins.float]]):
        """
        :param _builtins.str key: Specifies the field within the event data that you want to use for filtering. Type of the field can be a number, boolean, or string.
        :param Sequence[Sequence[_builtins.float]] values: Specifies an array of values to compare to when using a multiple values operator.
               
               > **Note:** A maximum of total number of advanced filter values allowed on event subscription is 25.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "values", values)

    @_builtins.property
    @pulumi.getter
    def key(self) -> _builtins.str:
        """
        Specifies the field within the event data that you want to use for filtering. Type of the field can be a number, boolean, or string.
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[Sequence[_builtins.float]]:
        """
        Specifies an array of values to compare to when using a multiple values operator.

        > **Note:** A maximum of total number of advanced filter values allowed on event subscription is 25.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class EventSubscriptionAdvancedFilterNumberLessThan(dict):
    def __init__(__self__, *,
                 key: _builtins.str,
                 value: _builtins.float):
        """
        :param _builtins.str key: Specifies the field within the event data that you want to use for filtering. Type of the field can be a number, boolean, or string.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def key(self) -> _builtins.str:
        """
        Specifies the field within the event data that you want to use for filtering. Type of the field can be a number, boolean, or string.
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.float:
        return pulumi.get(self, "value")


@pulumi.output_type
class EventSubscriptionAdvancedFilterNumberLessThanOrEqual(dict):
    def __init__(__self__, *,
                 key: _builtins.str,
                 value: _builtins.float):
        """
        :param _builtins.str key: Specifies the field within the event data that you want to use for filtering. Type of the field can be a number, boolean, or string.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def key(self) -> _builtins.str:
        """
        Specifies the field within the event data that you want to use for filtering. Type of the field can be a number, boolean, or string.
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.float:
        return pulumi.get(self, "value")


@pulumi.output_type
class EventSubscriptionAdvancedFilterNumberNotIn(dict):
    def __init__(__self__, *,
                 key: _builtins.str,
                 values: Sequence[_builtins.float]):
        """
        :param _builtins.str key: Specifies the field within the event data that you want to use for filtering. Type of the field can be a number, boolean, or string.
        :param Sequence[_builtins.float] values: Specifies an array of values to compare to when using a multiple values operator.
               
               > **Note:** A maximum of total number of advanced filter values allowed on event subscription is 25.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "values", values)

    @_builtins.property
    @pulumi.getter
    def key(self) -> _builtins.str:
        """
        Specifies the field within the event data that you want to use for filtering. Type of the field can be a number, boolean, or string.
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.float]:
        """
        Specifies an array of values to compare to when using a multiple values operator.

        > **Note:** A maximum of total number of advanced filter values allowed on event subscription is 25.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class EventSubscriptionAdvancedFilterNumberNotInRange(dict):
    def __init__(__self__, *,
                 key: _builtins.str,
                 values: Sequence[Sequence[_builtins.float]]):
        """
        :param _builtins.str key: Specifies the field within the event data that you want to use for filtering. Type of the field can be a number, boolean, or string.
        :param Sequence[Sequence[_builtins.float]] values: Specifies an array of values to compare to when using a multiple values operator.
               
               > **Note:** A maximum of total number of advanced filter values allowed on event subscription is 25.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "values", values)

    @_builtins.property
    @pulumi.getter
    def key(self) -> _builtins.str:
        """
        Specifies the field within the event data that you want to use for filtering. Type of the field can be a number, boolean, or string.
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[Sequence[_builtins.float]]:
        """
        Specifies an array of values to compare to when using a multiple values operator.

        > **Note:** A maximum of total number of advanced filter values allowed on event subscription is 25.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class EventSubscriptionAdvancedFilterStringBeginsWith(dict):
    def __init__(__self__, *,
                 key: _builtins.str,
                 values: Sequence[_builtins.str]):
        """
        :param _builtins.str key: Specifies the field within the event data that you want to use for filtering. Type of the field can be a number, boolean, or string.
        :param Sequence[_builtins.str] values: Specifies an array of values to compare to when using a multiple values operator.
               
               > **Note:** A maximum of total number of advanced filter values allowed on event subscription is 25.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "values", values)

    @_builtins.property
    @pulumi.getter
    def key(self) -> _builtins.str:
        """
        Specifies the field within the event data that you want to use for filtering. Type of the field can be a number, boolean, or string.
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        """
        Specifies an array of values to compare to when using a multiple values operator.

        > **Note:** A maximum of total number of advanced filter values allowed on event subscription is 25.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class EventSubscriptionAdvancedFilterStringContain(dict):
    def __init__(__self__, *,
                 key: _builtins.str,
                 values: Sequence[_builtins.str]):
        """
        :param _builtins.str key: Specifies the field within the event data that you want to use for filtering. Type of the field can be a number, boolean, or string.
        :param Sequence[_builtins.str] values: Specifies an array of values to compare to when using a multiple values operator.
               
               > **Note:** A maximum of total number of advanced filter values allowed on event subscription is 25.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "values", values)

    @_builtins.property
    @pulumi.getter
    def key(self) -> _builtins.str:
        """
        Specifies the field within the event data that you want to use for filtering. Type of the field can be a number, boolean, or string.
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        """
        Specifies an array of values to compare to when using a multiple values operator.

        > **Note:** A maximum of total number of advanced filter values allowed on event subscription is 25.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class EventSubscriptionAdvancedFilterStringEndsWith(dict):
    def __init__(__self__, *,
                 key: _builtins.str,
                 values: Sequence[_builtins.str]):
        """
        :param _builtins.str key: Specifies the field within the event data that you want to use for filtering. Type of the field can be a number, boolean, or string.
        :param Sequence[_builtins.str] values: Specifies an array of values to compare to when using a multiple values operator.
               
               > **Note:** A maximum of total number of advanced filter values allowed on event subscription is 25.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "values", values)

    @_builtins.property
    @pulumi.getter
    def key(self) -> _builtins.str:
        """
        Specifies the field within the event data that you want to use for filtering. Type of the field can be a number, boolean, or string.
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        """
        Specifies an array of values to compare to when using a multiple values operator.

        > **Note:** A maximum of total number of advanced filter values allowed on event subscription is 25.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class EventSubscriptionAdvancedFilterStringIn(dict):
    def __init__(__self__, *,
                 key: _builtins.str,
                 values: Sequence[_builtins.str]):
        """
        :param _builtins.str key: Specifies the field within the event data that you want to use for filtering. Type of the field can be a number, boolean, or string.
        :param Sequence[_builtins.str] values: Specifies an array of values to compare to when using a multiple values operator.
               
               > **Note:** A maximum of total number of advanced filter values allowed on event subscription is 25.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "values", values)

    @_builtins.property
    @pulumi.getter
    def key(self) -> _builtins.str:
        """
        Specifies the field within the event data that you want to use for filtering. Type of the field can be a number, boolean, or string.
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        """
        Specifies an array of values to compare to when using a multiple values operator.

        > **Note:** A maximum of total number of advanced filter values allowed on event subscription is 25.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class EventSubscriptionAdvancedFilterStringNotBeginsWith(dict):
    def __init__(__self__, *,
                 key: _builtins.str,
                 values: Sequence[_builtins.str]):
        """
        :param _builtins.str key: Specifies the field within the event data that you want to use for filtering. Type of the field can be a number, boolean, or string.
        :param Sequence[_builtins.str] values: Specifies an array of values to compare to when using a multiple values operator.
               
               > **Note:** A maximum of total number of advanced filter values allowed on event subscription is 25.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "values", values)

    @_builtins.property
    @pulumi.getter
    def key(self) -> _builtins.str:
        """
        Specifies the field within the event data that you want to use for filtering. Type of the field can be a number, boolean, or string.
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        """
        Specifies an array of values to compare to when using a multiple values operator.

        > **Note:** A maximum of total number of advanced filter values allowed on event subscription is 25.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class EventSubscriptionAdvancedFilterStringNotContain(dict):
    def __init__(__self__, *,
                 key: _builtins.str,
                 values: Sequence[_builtins.str]):
        """
        :param _builtins.str key: Specifies the field within the event data that you want to use for filtering. Type of the field can be a number, boolean, or string.
        :param Sequence[_builtins.str] values: Specifies an array of values to compare to when using a multiple values operator.
               
               > **Note:** A maximum of total number of advanced filter values allowed on event subscription is 25.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "values", values)

    @_builtins.property
    @pulumi.getter
    def key(self) -> _builtins.str:
        """
        Specifies the field within the event data that you want to use for filtering. Type of the field can be a number, boolean, or string.
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        """
        Specifies an array of values to compare to when using a multiple values operator.

        > **Note:** A maximum of total number of advanced filter values allowed on event subscription is 25.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class EventSubscriptionAdvancedFilterStringNotEndsWith(dict):
    def __init__(__self__, *,
                 key: _builtins.str,
                 values: Sequence[_builtins.str]):
        """
        :param _builtins.str key: Specifies the field within the event data that you want to use for filtering. Type of the field can be a number, boolean, or string.
        :param Sequence[_builtins.str] values: Specifies an array of values to compare to when using a multiple values operator.
               
               > **Note:** A maximum of total number of advanced filter values allowed on event subscription is 25.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "values", values)

    @_builtins.property
    @pulumi.getter
    def key(self) -> _builtins.str:
        """
        Specifies the field within the event data that you want to use for filtering. Type of the field can be a number, boolean, or string.
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        """
        Specifies an array of values to compare to when using a multiple values operator.

        > **Note:** A maximum of total number of advanced filter values allowed on event subscription is 25.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class EventSubscriptionAdvancedFilterStringNotIn(dict):
    def __init__(__self__, *,
                 key: _builtins.str,
                 values: Sequence[_builtins.str]):
        """
        :param _builtins.str key: Specifies the field within the event data that you want to use for filtering. Type of the field can be a number, boolean, or string.
        :param Sequence[_builtins.str] values: Specifies an array of values to compare to when using a multiple values operator.
               
               > **Note:** A maximum of total number of advanced filter values allowed on event subscription is 25.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "values", values)

    @_builtins.property
    @pulumi.getter
    def key(self) -> _builtins.str:
        """
        Specifies the field within the event data that you want to use for filtering. Type of the field can be a number, boolean, or string.
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        """
        Specifies an array of values to compare to when using a multiple values operator.

        > **Note:** A maximum of total number of advanced filter values allowed on event subscription is 25.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class EventSubscriptionAzureFunctionEndpoint(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "functionId":
            suggest = "function_id"
        elif key == "maxEventsPerBatch":
            suggest = "max_events_per_batch"
        elif key == "preferredBatchSizeInKilobytes":
            suggest = "preferred_batch_size_in_kilobytes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EventSubscriptionAzureFunctionEndpoint. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EventSubscriptionAzureFunctionEndpoint.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EventSubscriptionAzureFunctionEndpoint.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 function_id: _builtins.str,
                 max_events_per_batch: Optional[_builtins.int] = None,
                 preferred_batch_size_in_kilobytes: Optional[_builtins.int] = None):
        """
        :param _builtins.str function_id: Specifies the ID of the Function where the Event Subscription will receive events. This must be the functions ID in format {function_app.id}/functions/{name}.
        :param _builtins.int max_events_per_batch: Maximum number of events per batch.
        :param _builtins.int preferred_batch_size_in_kilobytes: Preferred batch size in Kilobytes.
        """
        pulumi.set(__self__, "function_id", function_id)
        if max_events_per_batch is not None:
            pulumi.set(__self__, "max_events_per_batch", max_events_per_batch)
        if preferred_batch_size_in_kilobytes is not None:
            pulumi.set(__self__, "preferred_batch_size_in_kilobytes", preferred_batch_size_in_kilobytes)

    @_builtins.property
    @pulumi.getter(name="functionId")
    def function_id(self) -> _builtins.str:
        """
        Specifies the ID of the Function where the Event Subscription will receive events. This must be the functions ID in format {function_app.id}/functions/{name}.
        """
        return pulumi.get(self, "function_id")

    @_builtins.property
    @pulumi.getter(name="maxEventsPerBatch")
    def max_events_per_batch(self) -> Optional[_builtins.int]:
        """
        Maximum number of events per batch.
        """
        return pulumi.get(self, "max_events_per_batch")

    @_builtins.property
    @pulumi.getter(name="preferredBatchSizeInKilobytes")
    def preferred_batch_size_in_kilobytes(self) -> Optional[_builtins.int]:
        """
        Preferred batch size in Kilobytes.
        """
        return pulumi.get(self, "preferred_batch_size_in_kilobytes")


@pulumi.output_type
class EventSubscriptionDeadLetterIdentity(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "userAssignedIdentity":
            suggest = "user_assigned_identity"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EventSubscriptionDeadLetterIdentity. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EventSubscriptionDeadLetterIdentity.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EventSubscriptionDeadLetterIdentity.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: _builtins.str,
                 user_assigned_identity: Optional[_builtins.str] = None):
        """
        :param _builtins.str type: Specifies the type of Managed Service Identity that is used for dead lettering. Allowed value is `SystemAssigned`, `UserAssigned`.
        :param _builtins.str user_assigned_identity: The user identity associated with the resource.
        """
        pulumi.set(__self__, "type", type)
        if user_assigned_identity is not None:
            pulumi.set(__self__, "user_assigned_identity", user_assigned_identity)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Specifies the type of Managed Service Identity that is used for dead lettering. Allowed value is `SystemAssigned`, `UserAssigned`.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="userAssignedIdentity")
    def user_assigned_identity(self) -> Optional[_builtins.str]:
        """
        The user identity associated with the resource.
        """
        return pulumi.get(self, "user_assigned_identity")


@pulumi.output_type
class EventSubscriptionDeliveryIdentity(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "userAssignedIdentity":
            suggest = "user_assigned_identity"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EventSubscriptionDeliveryIdentity. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EventSubscriptionDeliveryIdentity.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EventSubscriptionDeliveryIdentity.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: _builtins.str,
                 user_assigned_identity: Optional[_builtins.str] = None):
        """
        :param _builtins.str type: Specifies the type of Managed Service Identity that is used for event delivery. Allowed value is `SystemAssigned`, `UserAssigned`.
        :param _builtins.str user_assigned_identity: The user identity associated with the resource.
        """
        pulumi.set(__self__, "type", type)
        if user_assigned_identity is not None:
            pulumi.set(__self__, "user_assigned_identity", user_assigned_identity)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Specifies the type of Managed Service Identity that is used for event delivery. Allowed value is `SystemAssigned`, `UserAssigned`.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="userAssignedIdentity")
    def user_assigned_identity(self) -> Optional[_builtins.str]:
        """
        The user identity associated with the resource.
        """
        return pulumi.get(self, "user_assigned_identity")


@pulumi.output_type
class EventSubscriptionDeliveryProperty(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "headerName":
            suggest = "header_name"
        elif key == "sourceField":
            suggest = "source_field"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EventSubscriptionDeliveryProperty. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EventSubscriptionDeliveryProperty.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EventSubscriptionDeliveryProperty.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 header_name: _builtins.str,
                 type: _builtins.str,
                 secret: Optional[_builtins.bool] = None,
                 source_field: Optional[_builtins.str] = None,
                 value: Optional[_builtins.str] = None):
        """
        :param _builtins.str header_name: The name of the header to send on to the destination
        :param _builtins.str type: Either `Static` or `Dynamic`
        :param _builtins.bool secret: True if the `value` is a secret and should be protected, otherwise false. If True, then this value won't be returned from Azure API calls
        :param _builtins.str source_field: If the `type` is `Dynamic`, then provide the payload field to be used as the value. Valid source fields differ by subscription type.
        :param _builtins.str value: If the `type` is `Static`, then provide the value to use
        """
        pulumi.set(__self__, "header_name", header_name)
        pulumi.set(__self__, "type", type)
        if secret is not None:
            pulumi.set(__self__, "secret", secret)
        if source_field is not None:
            pulumi.set(__self__, "source_field", source_field)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter(name="headerName")
    def header_name(self) -> _builtins.str:
        """
        The name of the header to send on to the destination
        """
        return pulumi.get(self, "header_name")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Either `Static` or `Dynamic`
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def secret(self) -> Optional[_builtins.bool]:
        """
        True if the `value` is a secret and should be protected, otherwise false. If True, then this value won't be returned from Azure API calls
        """
        return pulumi.get(self, "secret")

    @_builtins.property
    @pulumi.getter(name="sourceField")
    def source_field(self) -> Optional[_builtins.str]:
        """
        If the `type` is `Dynamic`, then provide the payload field to be used as the value. Valid source fields differ by subscription type.
        """
        return pulumi.get(self, "source_field")

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[_builtins.str]:
        """
        If the `type` is `Static`, then provide the value to use
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class EventSubscriptionRetryPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "eventTimeToLive":
            suggest = "event_time_to_live"
        elif key == "maxDeliveryAttempts":
            suggest = "max_delivery_attempts"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EventSubscriptionRetryPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EventSubscriptionRetryPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EventSubscriptionRetryPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 event_time_to_live: _builtins.int,
                 max_delivery_attempts: _builtins.int):
        """
        :param _builtins.int event_time_to_live: Specifies the time to live (in minutes) for events. Supported range is `1` to `1440`. See [official documentation](https://docs.microsoft.com/azure/event-grid/manage-event-delivery#set-retry-policy) for more details.
        :param _builtins.int max_delivery_attempts: Specifies the maximum number of delivery retry attempts for events.
        """
        pulumi.set(__self__, "event_time_to_live", event_time_to_live)
        pulumi.set(__self__, "max_delivery_attempts", max_delivery_attempts)

    @_builtins.property
    @pulumi.getter(name="eventTimeToLive")
    def event_time_to_live(self) -> _builtins.int:
        """
        Specifies the time to live (in minutes) for events. Supported range is `1` to `1440`. See [official documentation](https://docs.microsoft.com/azure/event-grid/manage-event-delivery#set-retry-policy) for more details.
        """
        return pulumi.get(self, "event_time_to_live")

    @_builtins.property
    @pulumi.getter(name="maxDeliveryAttempts")
    def max_delivery_attempts(self) -> _builtins.int:
        """
        Specifies the maximum number of delivery retry attempts for events.
        """
        return pulumi.get(self, "max_delivery_attempts")


@pulumi.output_type
class EventSubscriptionStorageBlobDeadLetterDestination(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "storageAccountId":
            suggest = "storage_account_id"
        elif key == "storageBlobContainerName":
            suggest = "storage_blob_container_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EventSubscriptionStorageBlobDeadLetterDestination. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EventSubscriptionStorageBlobDeadLetterDestination.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EventSubscriptionStorageBlobDeadLetterDestination.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 storage_account_id: _builtins.str,
                 storage_blob_container_name: _builtins.str):
        """
        :param _builtins.str storage_account_id: Specifies the id of the storage account id where the storage blob is located.
        :param _builtins.str storage_blob_container_name: Specifies the name of the Storage blob container that is the destination of the deadletter events.
        """
        pulumi.set(__self__, "storage_account_id", storage_account_id)
        pulumi.set(__self__, "storage_blob_container_name", storage_blob_container_name)

    @_builtins.property
    @pulumi.getter(name="storageAccountId")
    def storage_account_id(self) -> _builtins.str:
        """
        Specifies the id of the storage account id where the storage blob is located.
        """
        return pulumi.get(self, "storage_account_id")

    @_builtins.property
    @pulumi.getter(name="storageBlobContainerName")
    def storage_blob_container_name(self) -> _builtins.str:
        """
        Specifies the name of the Storage blob container that is the destination of the deadletter events.
        """
        return pulumi.get(self, "storage_blob_container_name")


@pulumi.output_type
class EventSubscriptionStorageQueueEndpoint(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "queueName":
            suggest = "queue_name"
        elif key == "storageAccountId":
            suggest = "storage_account_id"
        elif key == "queueMessageTimeToLiveInSeconds":
            suggest = "queue_message_time_to_live_in_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EventSubscriptionStorageQueueEndpoint. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EventSubscriptionStorageQueueEndpoint.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EventSubscriptionStorageQueueEndpoint.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 queue_name: _builtins.str,
                 storage_account_id: _builtins.str,
                 queue_message_time_to_live_in_seconds: Optional[_builtins.int] = None):
        """
        :param _builtins.str queue_name: Specifies the name of the storage queue where the Event Subscription will receive events.
        :param _builtins.str storage_account_id: Specifies the id of the storage account id where the storage queue is located.
        :param _builtins.int queue_message_time_to_live_in_seconds: Storage queue message time to live in seconds.
        """
        pulumi.set(__self__, "queue_name", queue_name)
        pulumi.set(__self__, "storage_account_id", storage_account_id)
        if queue_message_time_to_live_in_seconds is not None:
            pulumi.set(__self__, "queue_message_time_to_live_in_seconds", queue_message_time_to_live_in_seconds)

    @_builtins.property
    @pulumi.getter(name="queueName")
    def queue_name(self) -> _builtins.str:
        """
        Specifies the name of the storage queue where the Event Subscription will receive events.
        """
        return pulumi.get(self, "queue_name")

    @_builtins.property
    @pulumi.getter(name="storageAccountId")
    def storage_account_id(self) -> _builtins.str:
        """
        Specifies the id of the storage account id where the storage queue is located.
        """
        return pulumi.get(self, "storage_account_id")

    @_builtins.property
    @pulumi.getter(name="queueMessageTimeToLiveInSeconds")
    def queue_message_time_to_live_in_seconds(self) -> Optional[_builtins.int]:
        """
        Storage queue message time to live in seconds.
        """
        return pulumi.get(self, "queue_message_time_to_live_in_seconds")


@pulumi.output_type
class EventSubscriptionSubjectFilter(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "caseSensitive":
            suggest = "case_sensitive"
        elif key == "subjectBeginsWith":
            suggest = "subject_begins_with"
        elif key == "subjectEndsWith":
            suggest = "subject_ends_with"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EventSubscriptionSubjectFilter. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EventSubscriptionSubjectFilter.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EventSubscriptionSubjectFilter.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 case_sensitive: Optional[_builtins.bool] = None,
                 subject_begins_with: Optional[_builtins.str] = None,
                 subject_ends_with: Optional[_builtins.str] = None):
        """
        :param _builtins.bool case_sensitive: Specifies if `subject_begins_with` and `subject_ends_with` case sensitive. This value
        :param _builtins.str subject_begins_with: A string to filter events for an event subscription based on a resource path prefix.
        :param _builtins.str subject_ends_with: A string to filter events for an event subscription based on a resource path suffix.
        """
        if case_sensitive is not None:
            pulumi.set(__self__, "case_sensitive", case_sensitive)
        if subject_begins_with is not None:
            pulumi.set(__self__, "subject_begins_with", subject_begins_with)
        if subject_ends_with is not None:
            pulumi.set(__self__, "subject_ends_with", subject_ends_with)

    @_builtins.property
    @pulumi.getter(name="caseSensitive")
    def case_sensitive(self) -> Optional[_builtins.bool]:
        """
        Specifies if `subject_begins_with` and `subject_ends_with` case sensitive. This value
        """
        return pulumi.get(self, "case_sensitive")

    @_builtins.property
    @pulumi.getter(name="subjectBeginsWith")
    def subject_begins_with(self) -> Optional[_builtins.str]:
        """
        A string to filter events for an event subscription based on a resource path prefix.
        """
        return pulumi.get(self, "subject_begins_with")

    @_builtins.property
    @pulumi.getter(name="subjectEndsWith")
    def subject_ends_with(self) -> Optional[_builtins.str]:
        """
        A string to filter events for an event subscription based on a resource path suffix.
        """
        return pulumi.get(self, "subject_ends_with")


@pulumi.output_type
class EventSubscriptionWebhookEndpoint(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "activeDirectoryAppIdOrUri":
            suggest = "active_directory_app_id_or_uri"
        elif key == "activeDirectoryTenantId":
            suggest = "active_directory_tenant_id"
        elif key == "baseUrl":
            suggest = "base_url"
        elif key == "maxEventsPerBatch":
            suggest = "max_events_per_batch"
        elif key == "preferredBatchSizeInKilobytes":
            suggest = "preferred_batch_size_in_kilobytes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EventSubscriptionWebhookEndpoint. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EventSubscriptionWebhookEndpoint.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EventSubscriptionWebhookEndpoint.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 url: _builtins.str,
                 active_directory_app_id_or_uri: Optional[_builtins.str] = None,
                 active_directory_tenant_id: Optional[_builtins.str] = None,
                 base_url: Optional[_builtins.str] = None,
                 max_events_per_batch: Optional[_builtins.int] = None,
                 preferred_batch_size_in_kilobytes: Optional[_builtins.int] = None):
        """
        :param _builtins.str url: Specifies the url of the webhook where the Event Subscription will receive events.
        :param _builtins.str active_directory_app_id_or_uri: The Azure Active Directory Application ID or URI to get the access token that will be included as the bearer token in delivery requests.
        :param _builtins.str active_directory_tenant_id: The Azure Active Directory Tenant ID to get the access token that will be included as the bearer token in delivery requests.
        :param _builtins.str base_url: The base url of the webhook where the Event Subscription will receive events.
        :param _builtins.int max_events_per_batch: Maximum number of events per batch.
        :param _builtins.int preferred_batch_size_in_kilobytes: Preferred batch size in Kilobytes.
        """
        pulumi.set(__self__, "url", url)
        if active_directory_app_id_or_uri is not None:
            pulumi.set(__self__, "active_directory_app_id_or_uri", active_directory_app_id_or_uri)
        if active_directory_tenant_id is not None:
            pulumi.set(__self__, "active_directory_tenant_id", active_directory_tenant_id)
        if base_url is not None:
            pulumi.set(__self__, "base_url", base_url)
        if max_events_per_batch is not None:
            pulumi.set(__self__, "max_events_per_batch", max_events_per_batch)
        if preferred_batch_size_in_kilobytes is not None:
            pulumi.set(__self__, "preferred_batch_size_in_kilobytes", preferred_batch_size_in_kilobytes)

    @_builtins.property
    @pulumi.getter
    def url(self) -> _builtins.str:
        """
        Specifies the url of the webhook where the Event Subscription will receive events.
        """
        return pulumi.get(self, "url")

    @_builtins.property
    @pulumi.getter(name="activeDirectoryAppIdOrUri")
    def active_directory_app_id_or_uri(self) -> Optional[_builtins.str]:
        """
        The Azure Active Directory Application ID or URI to get the access token that will be included as the bearer token in delivery requests.
        """
        return pulumi.get(self, "active_directory_app_id_or_uri")

    @_builtins.property
    @pulumi.getter(name="activeDirectoryTenantId")
    def active_directory_tenant_id(self) -> Optional[_builtins.str]:
        """
        The Azure Active Directory Tenant ID to get the access token that will be included as the bearer token in delivery requests.
        """
        return pulumi.get(self, "active_directory_tenant_id")

    @_builtins.property
    @pulumi.getter(name="baseUrl")
    def base_url(self) -> Optional[_builtins.str]:
        """
        The base url of the webhook where the Event Subscription will receive events.
        """
        return pulumi.get(self, "base_url")

    @_builtins.property
    @pulumi.getter(name="maxEventsPerBatch")
    def max_events_per_batch(self) -> Optional[_builtins.int]:
        """
        Maximum number of events per batch.
        """
        return pulumi.get(self, "max_events_per_batch")

    @_builtins.property
    @pulumi.getter(name="preferredBatchSizeInKilobytes")
    def preferred_batch_size_in_kilobytes(self) -> Optional[_builtins.int]:
        """
        Preferred batch size in Kilobytes.
        """
        return pulumi.get(self, "preferred_batch_size_in_kilobytes")


@pulumi.output_type
class NamespaceCustomerManagedKey(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "identityId":
            suggest = "identity_id"
        elif key == "keyVaultKeyId":
            suggest = "key_vault_key_id"
        elif key == "infrastructureEncryptionEnabled":
            suggest = "infrastructure_encryption_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NamespaceCustomerManagedKey. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NamespaceCustomerManagedKey.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NamespaceCustomerManagedKey.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 identity_id: _builtins.str,
                 key_vault_key_id: _builtins.str,
                 infrastructure_encryption_enabled: Optional[_builtins.bool] = None):
        """
        :param _builtins.str identity_id: The ID of the User Assigned Identity that has access to the key.
        :param _builtins.str key_vault_key_id: The ID of the Key Vault Key which should be used to Encrypt the data in this Service Bus Namespace.
        :param _builtins.bool infrastructure_encryption_enabled: Used to specify whether enable Infrastructure Encryption (Double Encryption). Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "identity_id", identity_id)
        pulumi.set(__self__, "key_vault_key_id", key_vault_key_id)
        if infrastructure_encryption_enabled is not None:
            pulumi.set(__self__, "infrastructure_encryption_enabled", infrastructure_encryption_enabled)

    @_builtins.property
    @pulumi.getter(name="identityId")
    def identity_id(self) -> _builtins.str:
        """
        The ID of the User Assigned Identity that has access to the key.
        """
        return pulumi.get(self, "identity_id")

    @_builtins.property
    @pulumi.getter(name="keyVaultKeyId")
    def key_vault_key_id(self) -> _builtins.str:
        """
        The ID of the Key Vault Key which should be used to Encrypt the data in this Service Bus Namespace.
        """
        return pulumi.get(self, "key_vault_key_id")

    @_builtins.property
    @pulumi.getter(name="infrastructureEncryptionEnabled")
    def infrastructure_encryption_enabled(self) -> Optional[_builtins.bool]:
        """
        Used to specify whether enable Infrastructure Encryption (Double Encryption). Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "infrastructure_encryption_enabled")


@pulumi.output_type
class NamespaceIdentity(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "identityIds":
            suggest = "identity_ids"
        elif key == "principalId":
            suggest = "principal_id"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NamespaceIdentity. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NamespaceIdentity.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NamespaceIdentity.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: _builtins.str,
                 identity_ids: Optional[Sequence[_builtins.str]] = None,
                 principal_id: Optional[_builtins.str] = None,
                 tenant_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str type: Specifies the type of Managed Service Identity that should be configured on this Service Bus Namespace. Possible values are `SystemAssigned`, `UserAssigned`, `SystemAssigned, UserAssigned` (to enable both).
        :param Sequence[_builtins.str] identity_ids: Specifies a list of User Assigned Managed Identity IDs to be assigned to this Service Bus namespace.
               
               > **Note:** This is required when `type` is set to `UserAssigned` or `SystemAssigned, UserAssigned`.
        :param _builtins.str principal_id: The Principal ID for the Service Principal associated with the Managed Service Identity of this Service Bus Namespace.
        :param _builtins.str tenant_id: The Tenant ID for the Service Principal associated with the Managed Service Identity of this Service Bus Namespace.
        """
        pulumi.set(__self__, "type", type)
        if identity_ids is not None:
            pulumi.set(__self__, "identity_ids", identity_ids)
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Specifies the type of Managed Service Identity that should be configured on this Service Bus Namespace. Possible values are `SystemAssigned`, `UserAssigned`, `SystemAssigned, UserAssigned` (to enable both).
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="identityIds")
    def identity_ids(self) -> Optional[Sequence[_builtins.str]]:
        """
        Specifies a list of User Assigned Managed Identity IDs to be assigned to this Service Bus namespace.

        > **Note:** This is required when `type` is set to `UserAssigned` or `SystemAssigned, UserAssigned`.
        """
        return pulumi.get(self, "identity_ids")

    @_builtins.property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[_builtins.str]:
        """
        The Principal ID for the Service Principal associated with the Managed Service Identity of this Service Bus Namespace.
        """
        return pulumi.get(self, "principal_id")

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[_builtins.str]:
        """
        The Tenant ID for the Service Principal associated with the Managed Service Identity of this Service Bus Namespace.
        """
        return pulumi.get(self, "tenant_id")


@pulumi.output_type
class NamespaceNetworkRuleSet(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultAction":
            suggest = "default_action"
        elif key == "ipRules":
            suggest = "ip_rules"
        elif key == "networkRules":
            suggest = "network_rules"
        elif key == "publicNetworkAccessEnabled":
            suggest = "public_network_access_enabled"
        elif key == "trustedServicesAllowed":
            suggest = "trusted_services_allowed"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NamespaceNetworkRuleSet. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NamespaceNetworkRuleSet.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NamespaceNetworkRuleSet.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 default_action: Optional[_builtins.str] = None,
                 ip_rules: Optional[Sequence[_builtins.str]] = None,
                 network_rules: Optional[Sequence['outputs.NamespaceNetworkRuleSetNetworkRule']] = None,
                 public_network_access_enabled: Optional[_builtins.bool] = None,
                 trusted_services_allowed: Optional[_builtins.bool] = None):
        """
        :param _builtins.str default_action: Specifies the default action for the Network Rule Set. Possible values are `Allow` and `Deny`. Defaults to `Allow`.
        :param Sequence[_builtins.str] ip_rules: One or more IP Addresses, or CIDR Blocks which should be able to access the Service Bus Namespace.
        :param Sequence['NamespaceNetworkRuleSetNetworkRuleArgs'] network_rules: One or more `network_rules` blocks as defined below.
        :param _builtins.bool public_network_access_enabled: Whether to allow traffic over public network. Possible values are `true` and `false`. Defaults to `true`.
               
               > **Note:** To disable public network access, you must also configure the property `public_network_access_enabled`.
        :param _builtins.bool trusted_services_allowed: Are Azure Services that are known and trusted for this resource type are allowed to bypass firewall configuration? See [Trusted Microsoft Services](https://github.com/MicrosoftDocs/azure-docs/blob/master/articles/service-bus-messaging/includes/service-bus-trusted-services.md)
        """
        if default_action is not None:
            pulumi.set(__self__, "default_action", default_action)
        if ip_rules is not None:
            pulumi.set(__self__, "ip_rules", ip_rules)
        if network_rules is not None:
            pulumi.set(__self__, "network_rules", network_rules)
        if public_network_access_enabled is not None:
            pulumi.set(__self__, "public_network_access_enabled", public_network_access_enabled)
        if trusted_services_allowed is not None:
            pulumi.set(__self__, "trusted_services_allowed", trusted_services_allowed)

    @_builtins.property
    @pulumi.getter(name="defaultAction")
    def default_action(self) -> Optional[_builtins.str]:
        """
        Specifies the default action for the Network Rule Set. Possible values are `Allow` and `Deny`. Defaults to `Allow`.
        """
        return pulumi.get(self, "default_action")

    @_builtins.property
    @pulumi.getter(name="ipRules")
    def ip_rules(self) -> Optional[Sequence[_builtins.str]]:
        """
        One or more IP Addresses, or CIDR Blocks which should be able to access the Service Bus Namespace.
        """
        return pulumi.get(self, "ip_rules")

    @_builtins.property
    @pulumi.getter(name="networkRules")
    def network_rules(self) -> Optional[Sequence['outputs.NamespaceNetworkRuleSetNetworkRule']]:
        """
        One or more `network_rules` blocks as defined below.
        """
        return pulumi.get(self, "network_rules")

    @_builtins.property
    @pulumi.getter(name="publicNetworkAccessEnabled")
    def public_network_access_enabled(self) -> Optional[_builtins.bool]:
        """
        Whether to allow traffic over public network. Possible values are `true` and `false`. Defaults to `true`.

        > **Note:** To disable public network access, you must also configure the property `public_network_access_enabled`.
        """
        return pulumi.get(self, "public_network_access_enabled")

    @_builtins.property
    @pulumi.getter(name="trustedServicesAllowed")
    def trusted_services_allowed(self) -> Optional[_builtins.bool]:
        """
        Are Azure Services that are known and trusted for this resource type are allowed to bypass firewall configuration? See [Trusted Microsoft Services](https://github.com/MicrosoftDocs/azure-docs/blob/master/articles/service-bus-messaging/includes/service-bus-trusted-services.md)
        """
        return pulumi.get(self, "trusted_services_allowed")


@pulumi.output_type
class NamespaceNetworkRuleSetNetworkRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "subnetId":
            suggest = "subnet_id"
        elif key == "ignoreMissingVnetServiceEndpoint":
            suggest = "ignore_missing_vnet_service_endpoint"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NamespaceNetworkRuleSetNetworkRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NamespaceNetworkRuleSetNetworkRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NamespaceNetworkRuleSetNetworkRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 subnet_id: _builtins.str,
                 ignore_missing_vnet_service_endpoint: Optional[_builtins.bool] = None):
        """
        :param _builtins.str subnet_id: The Subnet ID which should be able to access this Service Bus Namespace.
        :param _builtins.bool ignore_missing_vnet_service_endpoint: Should the Service Bus Namespace Network Rule Set ignore missing Virtual Network Service Endpoint option in the Subnet? Defaults to `false`.
        """
        pulumi.set(__self__, "subnet_id", subnet_id)
        if ignore_missing_vnet_service_endpoint is not None:
            pulumi.set(__self__, "ignore_missing_vnet_service_endpoint", ignore_missing_vnet_service_endpoint)

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> _builtins.str:
        """
        The Subnet ID which should be able to access this Service Bus Namespace.
        """
        return pulumi.get(self, "subnet_id")

    @_builtins.property
    @pulumi.getter(name="ignoreMissingVnetServiceEndpoint")
    def ignore_missing_vnet_service_endpoint(self) -> Optional[_builtins.bool]:
        """
        Should the Service Bus Namespace Network Rule Set ignore missing Virtual Network Service Endpoint option in the Subnet? Defaults to `false`.
        """
        return pulumi.get(self, "ignore_missing_vnet_service_endpoint")


@pulumi.output_type
class SubscriptionClientScopedSubscription(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientId":
            suggest = "client_id"
        elif key == "isClientScopedSubscriptionDurable":
            suggest = "is_client_scoped_subscription_durable"
        elif key == "isClientScopedSubscriptionShareable":
            suggest = "is_client_scoped_subscription_shareable"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SubscriptionClientScopedSubscription. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SubscriptionClientScopedSubscription.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SubscriptionClientScopedSubscription.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_id: Optional[_builtins.str] = None,
                 is_client_scoped_subscription_durable: Optional[_builtins.bool] = None,
                 is_client_scoped_subscription_shareable: Optional[_builtins.bool] = None):
        """
        :param _builtins.str client_id: Specifies the Client ID of the application that created the client-scoped subscription. Changing this forces a new resource to be created.
               
               > **Note:** Client ID can be null or empty, but it must match the client ID set on the JMS client application. From the Azure Service Bus perspective, a null client ID and an empty client id have the same behavior. If the client ID is set to null or empty, it is only accessible to client applications whose client ID is also set to null or empty.
        :param _builtins.bool is_client_scoped_subscription_durable: Whether the client scoped subscription is durable. This property can only be controlled from the application side.
        :param _builtins.bool is_client_scoped_subscription_shareable: Whether the client scoped subscription is shareable. Defaults to `true` Changing this forces a new resource to be created.
        """
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if is_client_scoped_subscription_durable is not None:
            pulumi.set(__self__, "is_client_scoped_subscription_durable", is_client_scoped_subscription_durable)
        if is_client_scoped_subscription_shareable is not None:
            pulumi.set(__self__, "is_client_scoped_subscription_shareable", is_client_scoped_subscription_shareable)

    @_builtins.property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[_builtins.str]:
        """
        Specifies the Client ID of the application that created the client-scoped subscription. Changing this forces a new resource to be created.

        > **Note:** Client ID can be null or empty, but it must match the client ID set on the JMS client application. From the Azure Service Bus perspective, a null client ID and an empty client id have the same behavior. If the client ID is set to null or empty, it is only accessible to client applications whose client ID is also set to null or empty.
        """
        return pulumi.get(self, "client_id")

    @_builtins.property
    @pulumi.getter(name="isClientScopedSubscriptionDurable")
    def is_client_scoped_subscription_durable(self) -> Optional[_builtins.bool]:
        """
        Whether the client scoped subscription is durable. This property can only be controlled from the application side.
        """
        return pulumi.get(self, "is_client_scoped_subscription_durable")

    @_builtins.property
    @pulumi.getter(name="isClientScopedSubscriptionShareable")
    def is_client_scoped_subscription_shareable(self) -> Optional[_builtins.bool]:
        """
        Whether the client scoped subscription is shareable. Defaults to `true` Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "is_client_scoped_subscription_shareable")


@pulumi.output_type
class SubscriptionRuleCorrelationFilter(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "contentType":
            suggest = "content_type"
        elif key == "correlationId":
            suggest = "correlation_id"
        elif key == "messageId":
            suggest = "message_id"
        elif key == "replyTo":
            suggest = "reply_to"
        elif key == "replyToSessionId":
            suggest = "reply_to_session_id"
        elif key == "sessionId":
            suggest = "session_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SubscriptionRuleCorrelationFilter. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SubscriptionRuleCorrelationFilter.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SubscriptionRuleCorrelationFilter.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 content_type: Optional[_builtins.str] = None,
                 correlation_id: Optional[_builtins.str] = None,
                 label: Optional[_builtins.str] = None,
                 message_id: Optional[_builtins.str] = None,
                 properties: Optional[Mapping[str, _builtins.str]] = None,
                 reply_to: Optional[_builtins.str] = None,
                 reply_to_session_id: Optional[_builtins.str] = None,
                 session_id: Optional[_builtins.str] = None,
                 to: Optional[_builtins.str] = None):
        """
        :param _builtins.str content_type: Content type of the message.
        :param _builtins.str correlation_id: Identifier of the correlation.
        :param _builtins.str label: Application specific label.
        :param _builtins.str message_id: Identifier of the message.
        :param Mapping[str, _builtins.str] properties: A list of user defined properties to be included in the filter. Specified as a map of name/value pairs.
               
               > **Note:** When creating a subscription rule of type `CorrelationFilter` at least one property must be set in the `correlation_filter` block.
        :param _builtins.str reply_to: Address of the queue to reply to.
        :param _builtins.str reply_to_session_id: Session identifier to reply to.
        :param _builtins.str session_id: Session identifier.
        :param _builtins.str to: Address to send to.
        """
        if content_type is not None:
            pulumi.set(__self__, "content_type", content_type)
        if correlation_id is not None:
            pulumi.set(__self__, "correlation_id", correlation_id)
        if label is not None:
            pulumi.set(__self__, "label", label)
        if message_id is not None:
            pulumi.set(__self__, "message_id", message_id)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if reply_to is not None:
            pulumi.set(__self__, "reply_to", reply_to)
        if reply_to_session_id is not None:
            pulumi.set(__self__, "reply_to_session_id", reply_to_session_id)
        if session_id is not None:
            pulumi.set(__self__, "session_id", session_id)
        if to is not None:
            pulumi.set(__self__, "to", to)

    @_builtins.property
    @pulumi.getter(name="contentType")
    def content_type(self) -> Optional[_builtins.str]:
        """
        Content type of the message.
        """
        return pulumi.get(self, "content_type")

    @_builtins.property
    @pulumi.getter(name="correlationId")
    def correlation_id(self) -> Optional[_builtins.str]:
        """
        Identifier of the correlation.
        """
        return pulumi.get(self, "correlation_id")

    @_builtins.property
    @pulumi.getter
    def label(self) -> Optional[_builtins.str]:
        """
        Application specific label.
        """
        return pulumi.get(self, "label")

    @_builtins.property
    @pulumi.getter(name="messageId")
    def message_id(self) -> Optional[_builtins.str]:
        """
        Identifier of the message.
        """
        return pulumi.get(self, "message_id")

    @_builtins.property
    @pulumi.getter
    def properties(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        A list of user defined properties to be included in the filter. Specified as a map of name/value pairs.

        > **Note:** When creating a subscription rule of type `CorrelationFilter` at least one property must be set in the `correlation_filter` block.
        """
        return pulumi.get(self, "properties")

    @_builtins.property
    @pulumi.getter(name="replyTo")
    def reply_to(self) -> Optional[_builtins.str]:
        """
        Address of the queue to reply to.
        """
        return pulumi.get(self, "reply_to")

    @_builtins.property
    @pulumi.getter(name="replyToSessionId")
    def reply_to_session_id(self) -> Optional[_builtins.str]:
        """
        Session identifier to reply to.
        """
        return pulumi.get(self, "reply_to_session_id")

    @_builtins.property
    @pulumi.getter(name="sessionId")
    def session_id(self) -> Optional[_builtins.str]:
        """
        Session identifier.
        """
        return pulumi.get(self, "session_id")

    @_builtins.property
    @pulumi.getter
    def to(self) -> Optional[_builtins.str]:
        """
        Address to send to.
        """
        return pulumi.get(self, "to")


