# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['FirewallPolicyArgs', 'FirewallPolicy']

@pulumi.input_type
class FirewallPolicyArgs:
    def __init__(__self__, *,
                 resource_group_name: pulumi.Input[_builtins.str],
                 custom_block_response_body: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_block_response_status_code: Optional[pulumi.Input[_builtins.int]] = None,
                 custom_rules: Optional[pulumi.Input[Sequence[pulumi.Input['FirewallPolicyCustomRuleArgs']]]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 managed_rules: Optional[pulumi.Input[Sequence[pulumi.Input['FirewallPolicyManagedRuleArgs']]]] = None,
                 mode: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 redirect_url: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a FirewallPolicy resource.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] custom_block_response_body: If a `custom_rule` block's action type is `block`, this is the response body. The body must be specified in base64 encoding.
        :param pulumi.Input[_builtins.int] custom_block_response_status_code: If a `custom_rule` block's action type is `block`, this is the response status code. Possible values are `200`, `403`, `405`, `406`, or `429`.
        :param pulumi.Input[Sequence[pulumi.Input['FirewallPolicyCustomRuleArgs']]] custom_rules: One or more `custom_rule` blocks as defined below.
        :param pulumi.Input[_builtins.bool] enabled: Is the policy a enabled state or disabled state. Defaults to `true`.
        :param pulumi.Input[Sequence[pulumi.Input['FirewallPolicyManagedRuleArgs']]] managed_rules: One or more `managed_rule` blocks as defined below.
        :param pulumi.Input[_builtins.str] mode: The firewall policy mode. Possible values are `Detection`, `Prevention`. Defaults to `Prevention`.
        :param pulumi.Input[_builtins.str] name: The name of the policy. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] redirect_url: If action type is redirect, this field represents redirect URL for the client.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the Web Application Firewall Policy.
        """
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if custom_block_response_body is not None:
            pulumi.set(__self__, "custom_block_response_body", custom_block_response_body)
        if custom_block_response_status_code is not None:
            pulumi.set(__self__, "custom_block_response_status_code", custom_block_response_status_code)
        if custom_rules is not None:
            pulumi.set(__self__, "custom_rules", custom_rules)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if managed_rules is not None:
            pulumi.set(__self__, "managed_rules", managed_rules)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if redirect_url is not None:
            pulumi.set(__self__, "redirect_url", redirect_url)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the resource group. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="customBlockResponseBody")
    def custom_block_response_body(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        If a `custom_rule` block's action type is `block`, this is the response body. The body must be specified in base64 encoding.
        """
        return pulumi.get(self, "custom_block_response_body")

    @custom_block_response_body.setter
    def custom_block_response_body(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "custom_block_response_body", value)

    @_builtins.property
    @pulumi.getter(name="customBlockResponseStatusCode")
    def custom_block_response_status_code(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        If a `custom_rule` block's action type is `block`, this is the response status code. Possible values are `200`, `403`, `405`, `406`, or `429`.
        """
        return pulumi.get(self, "custom_block_response_status_code")

    @custom_block_response_status_code.setter
    def custom_block_response_status_code(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "custom_block_response_status_code", value)

    @_builtins.property
    @pulumi.getter(name="customRules")
    def custom_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FirewallPolicyCustomRuleArgs']]]]:
        """
        One or more `custom_rule` blocks as defined below.
        """
        return pulumi.get(self, "custom_rules")

    @custom_rules.setter
    def custom_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FirewallPolicyCustomRuleArgs']]]]):
        pulumi.set(self, "custom_rules", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Is the policy a enabled state or disabled state. Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter(name="managedRules")
    def managed_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FirewallPolicyManagedRuleArgs']]]]:
        """
        One or more `managed_rule` blocks as defined below.
        """
        return pulumi.get(self, "managed_rules")

    @managed_rules.setter
    def managed_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FirewallPolicyManagedRuleArgs']]]]):
        pulumi.set(self, "managed_rules", value)

    @_builtins.property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The firewall policy mode. Possible values are `Detection`, `Prevention`. Defaults to `Prevention`.
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mode", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the policy. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="redirectUrl")
    def redirect_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        If action type is redirect, this field represents redirect URL for the client.
        """
        return pulumi.get(self, "redirect_url")

    @redirect_url.setter
    def redirect_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "redirect_url", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the Web Application Firewall Policy.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _FirewallPolicyState:
    def __init__(__self__, *,
                 custom_block_response_body: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_block_response_status_code: Optional[pulumi.Input[_builtins.int]] = None,
                 custom_rules: Optional[pulumi.Input[Sequence[pulumi.Input['FirewallPolicyCustomRuleArgs']]]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 frontend_endpoint_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 managed_rules: Optional[pulumi.Input[Sequence[pulumi.Input['FirewallPolicyManagedRuleArgs']]]] = None,
                 mode: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 redirect_url: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering FirewallPolicy resources.
        :param pulumi.Input[_builtins.str] custom_block_response_body: If a `custom_rule` block's action type is `block`, this is the response body. The body must be specified in base64 encoding.
        :param pulumi.Input[_builtins.int] custom_block_response_status_code: If a `custom_rule` block's action type is `block`, this is the response status code. Possible values are `200`, `403`, `405`, `406`, or `429`.
        :param pulumi.Input[Sequence[pulumi.Input['FirewallPolicyCustomRuleArgs']]] custom_rules: One or more `custom_rule` blocks as defined below.
        :param pulumi.Input[_builtins.bool] enabled: Is the policy a enabled state or disabled state. Defaults to `true`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] frontend_endpoint_ids: The Frontend Endpoints associated with this Front Door Web Application Firewall policy.
        :param pulumi.Input[_builtins.str] location: The Azure Region where this Front Door Firewall Policy exists.
        :param pulumi.Input[Sequence[pulumi.Input['FirewallPolicyManagedRuleArgs']]] managed_rules: One or more `managed_rule` blocks as defined below.
        :param pulumi.Input[_builtins.str] mode: The firewall policy mode. Possible values are `Detection`, `Prevention`. Defaults to `Prevention`.
        :param pulumi.Input[_builtins.str] name: The name of the policy. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] redirect_url: If action type is redirect, this field represents redirect URL for the client.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the Web Application Firewall Policy.
        """
        if custom_block_response_body is not None:
            pulumi.set(__self__, "custom_block_response_body", custom_block_response_body)
        if custom_block_response_status_code is not None:
            pulumi.set(__self__, "custom_block_response_status_code", custom_block_response_status_code)
        if custom_rules is not None:
            pulumi.set(__self__, "custom_rules", custom_rules)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if frontend_endpoint_ids is not None:
            pulumi.set(__self__, "frontend_endpoint_ids", frontend_endpoint_ids)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if managed_rules is not None:
            pulumi.set(__self__, "managed_rules", managed_rules)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if redirect_url is not None:
            pulumi.set(__self__, "redirect_url", redirect_url)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="customBlockResponseBody")
    def custom_block_response_body(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        If a `custom_rule` block's action type is `block`, this is the response body. The body must be specified in base64 encoding.
        """
        return pulumi.get(self, "custom_block_response_body")

    @custom_block_response_body.setter
    def custom_block_response_body(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "custom_block_response_body", value)

    @_builtins.property
    @pulumi.getter(name="customBlockResponseStatusCode")
    def custom_block_response_status_code(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        If a `custom_rule` block's action type is `block`, this is the response status code. Possible values are `200`, `403`, `405`, `406`, or `429`.
        """
        return pulumi.get(self, "custom_block_response_status_code")

    @custom_block_response_status_code.setter
    def custom_block_response_status_code(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "custom_block_response_status_code", value)

    @_builtins.property
    @pulumi.getter(name="customRules")
    def custom_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FirewallPolicyCustomRuleArgs']]]]:
        """
        One or more `custom_rule` blocks as defined below.
        """
        return pulumi.get(self, "custom_rules")

    @custom_rules.setter
    def custom_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FirewallPolicyCustomRuleArgs']]]]):
        pulumi.set(self, "custom_rules", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Is the policy a enabled state or disabled state. Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter(name="frontendEndpointIds")
    def frontend_endpoint_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The Frontend Endpoints associated with this Front Door Web Application Firewall policy.
        """
        return pulumi.get(self, "frontend_endpoint_ids")

    @frontend_endpoint_ids.setter
    def frontend_endpoint_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "frontend_endpoint_ids", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Azure Region where this Front Door Firewall Policy exists.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="managedRules")
    def managed_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FirewallPolicyManagedRuleArgs']]]]:
        """
        One or more `managed_rule` blocks as defined below.
        """
        return pulumi.get(self, "managed_rules")

    @managed_rules.setter
    def managed_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FirewallPolicyManagedRuleArgs']]]]):
        pulumi.set(self, "managed_rules", value)

    @_builtins.property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The firewall policy mode. Possible values are `Detection`, `Prevention`. Defaults to `Prevention`.
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mode", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the policy. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="redirectUrl")
    def redirect_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        If action type is redirect, this field represents redirect URL for the client.
        """
        return pulumi.get(self, "redirect_url")

    @redirect_url.setter
    def redirect_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "redirect_url", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the resource group. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the Web Application Firewall Policy.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("azure:frontdoor/firewallPolicy:FirewallPolicy")
class FirewallPolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 custom_block_response_body: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_block_response_status_code: Optional[pulumi.Input[_builtins.int]] = None,
                 custom_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FirewallPolicyCustomRuleArgs', 'FirewallPolicyCustomRuleArgsDict']]]]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 managed_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FirewallPolicyManagedRuleArgs', 'FirewallPolicyManagedRuleArgsDict']]]]] = None,
                 mode: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 redirect_url: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        !> **Note:** This deploys an Azure Front Door (classic) resource which has been deprecated and will receive security updates only. Please migrate your existing Azure Front Door (classic) deployments to the new Azure Front Door (standard/premium) resources. For your convenience, the service team has exposed a `Front Door Classic` to `Front Door Standard/Premium` [migration tool](https://learn.microsoft.com/azure/frontdoor/tier-migration) to allow you to migrate your existing `Front Door Classic` instances to the new `Front Door Standard/Premium` product tiers.

        Manages an Azure Front Door (classic) Web Application Firewall Policy instance.

        !> **Note:** Azure rolled out a breaking change on Friday 9th April 2021 which may cause issues with the CDN/FrontDoor resources. More information is available in this GitHub issue - unfortunately this may necessitate a breaking change to the CDN and Front Door resources, more information will be posted in the GitHub issue as the necessary changes are identified.

        !> **Note:** On `1 April 2025`, Azure Front Door (classic) will be retired for the public cloud, existing Azure Front Door (classic) resources must be migrated out of Azure Front Door (classic) to Azure Front Door Standard/Premium before `1 October 2025` to avoid potential disruptions in service.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-rg",
            location="West Europe")
        example_firewall_policy = azure.frontdoor.FirewallPolicy("example",
            name="examplefdwafpolicy",
            resource_group_name=example.name,
            enabled=True,
            mode="Prevention",
            redirect_url="https://www.contoso.com",
            custom_block_response_status_code=403,
            custom_block_response_body="PGh0bWw+CjxoZWFkZXI+PHRpdGxlPkhlbGxvPC90aXRsZT48L2hlYWRlcj4KPGJvZHk+CkhlbGxvIHdvcmxkCjwvYm9keT4KPC9odG1sPg==",
            custom_rules=[
                {
                    "name": "Rule1",
                    "enabled": True,
                    "priority": 1,
                    "rate_limit_duration_in_minutes": 1,
                    "rate_limit_threshold": 10,
                    "type": "MatchRule",
                    "action": "Block",
                    "match_conditions": [{
                        "match_variable": "RemoteAddr",
                        "operator": "IPMatch",
                        "negation_condition": False,
                        "match_values": [
                            "192.168.1.0/24",
                            "10.0.0.0/24",
                        ],
                    }],
                },
                {
                    "name": "Rule2",
                    "enabled": True,
                    "priority": 2,
                    "rate_limit_duration_in_minutes": 1,
                    "rate_limit_threshold": 10,
                    "type": "MatchRule",
                    "action": "Block",
                    "match_conditions": [
                        {
                            "match_variable": "RemoteAddr",
                            "operator": "IPMatch",
                            "negation_condition": False,
                            "match_values": ["192.168.1.0/24"],
                        },
                        {
                            "match_variable": "RequestHeader",
                            "selector": "UserAgent",
                            "operator": "Contains",
                            "negation_condition": False,
                            "match_values": ["windows"],
                            "transforms": [
                                "Lowercase",
                                "Trim",
                            ],
                        },
                    ],
                },
            ],
            managed_rules=[
                {
                    "type": "DefaultRuleSet",
                    "version": "1.0",
                    "exclusions": [{
                        "match_variable": "QueryStringArgNames",
                        "operator": "Equals",
                        "selector": "not_suspicious",
                    }],
                    "overrides": [
                        {
                            "rule_group_name": "PHP",
                            "rules": [{
                                "rule_id": "933100",
                                "enabled": False,
                                "action": "Block",
                            }],
                        },
                        {
                            "rule_group_name": "SQLI",
                            "exclusions": [{
                                "match_variable": "QueryStringArgNames",
                                "operator": "Equals",
                                "selector": "really_not_suspicious",
                            }],
                            "rules": [{
                                "rule_id": "942200",
                                "action": "Block",
                                "exclusions": [{
                                    "match_variable": "QueryStringArgNames",
                                    "operator": "Equals",
                                    "selector": "innocent",
                                }],
                            }],
                        },
                    ],
                },
                {
                    "type": "Microsoft_BotManagerRuleSet",
                    "version": "1.0",
                },
            ])
        ```

        ## Import

        FrontDoor Web Application Firewall Policy can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:frontdoor/firewallPolicy:FirewallPolicy example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/example-rg/providers/Microsoft.Network/frontDoorWebApplicationFirewallPolicies/examplefdwafpolicy
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] custom_block_response_body: If a `custom_rule` block's action type is `block`, this is the response body. The body must be specified in base64 encoding.
        :param pulumi.Input[_builtins.int] custom_block_response_status_code: If a `custom_rule` block's action type is `block`, this is the response status code. Possible values are `200`, `403`, `405`, `406`, or `429`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['FirewallPolicyCustomRuleArgs', 'FirewallPolicyCustomRuleArgsDict']]]] custom_rules: One or more `custom_rule` blocks as defined below.
        :param pulumi.Input[_builtins.bool] enabled: Is the policy a enabled state or disabled state. Defaults to `true`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['FirewallPolicyManagedRuleArgs', 'FirewallPolicyManagedRuleArgsDict']]]] managed_rules: One or more `managed_rule` blocks as defined below.
        :param pulumi.Input[_builtins.str] mode: The firewall policy mode. Possible values are `Detection`, `Prevention`. Defaults to `Prevention`.
        :param pulumi.Input[_builtins.str] name: The name of the policy. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] redirect_url: If action type is redirect, this field represents redirect URL for the client.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the Web Application Firewall Policy.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FirewallPolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        !> **Note:** This deploys an Azure Front Door (classic) resource which has been deprecated and will receive security updates only. Please migrate your existing Azure Front Door (classic) deployments to the new Azure Front Door (standard/premium) resources. For your convenience, the service team has exposed a `Front Door Classic` to `Front Door Standard/Premium` [migration tool](https://learn.microsoft.com/azure/frontdoor/tier-migration) to allow you to migrate your existing `Front Door Classic` instances to the new `Front Door Standard/Premium` product tiers.

        Manages an Azure Front Door (classic) Web Application Firewall Policy instance.

        !> **Note:** Azure rolled out a breaking change on Friday 9th April 2021 which may cause issues with the CDN/FrontDoor resources. More information is available in this GitHub issue - unfortunately this may necessitate a breaking change to the CDN and Front Door resources, more information will be posted in the GitHub issue as the necessary changes are identified.

        !> **Note:** On `1 April 2025`, Azure Front Door (classic) will be retired for the public cloud, existing Azure Front Door (classic) resources must be migrated out of Azure Front Door (classic) to Azure Front Door Standard/Premium before `1 October 2025` to avoid potential disruptions in service.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-rg",
            location="West Europe")
        example_firewall_policy = azure.frontdoor.FirewallPolicy("example",
            name="examplefdwafpolicy",
            resource_group_name=example.name,
            enabled=True,
            mode="Prevention",
            redirect_url="https://www.contoso.com",
            custom_block_response_status_code=403,
            custom_block_response_body="PGh0bWw+CjxoZWFkZXI+PHRpdGxlPkhlbGxvPC90aXRsZT48L2hlYWRlcj4KPGJvZHk+CkhlbGxvIHdvcmxkCjwvYm9keT4KPC9odG1sPg==",
            custom_rules=[
                {
                    "name": "Rule1",
                    "enabled": True,
                    "priority": 1,
                    "rate_limit_duration_in_minutes": 1,
                    "rate_limit_threshold": 10,
                    "type": "MatchRule",
                    "action": "Block",
                    "match_conditions": [{
                        "match_variable": "RemoteAddr",
                        "operator": "IPMatch",
                        "negation_condition": False,
                        "match_values": [
                            "192.168.1.0/24",
                            "10.0.0.0/24",
                        ],
                    }],
                },
                {
                    "name": "Rule2",
                    "enabled": True,
                    "priority": 2,
                    "rate_limit_duration_in_minutes": 1,
                    "rate_limit_threshold": 10,
                    "type": "MatchRule",
                    "action": "Block",
                    "match_conditions": [
                        {
                            "match_variable": "RemoteAddr",
                            "operator": "IPMatch",
                            "negation_condition": False,
                            "match_values": ["192.168.1.0/24"],
                        },
                        {
                            "match_variable": "RequestHeader",
                            "selector": "UserAgent",
                            "operator": "Contains",
                            "negation_condition": False,
                            "match_values": ["windows"],
                            "transforms": [
                                "Lowercase",
                                "Trim",
                            ],
                        },
                    ],
                },
            ],
            managed_rules=[
                {
                    "type": "DefaultRuleSet",
                    "version": "1.0",
                    "exclusions": [{
                        "match_variable": "QueryStringArgNames",
                        "operator": "Equals",
                        "selector": "not_suspicious",
                    }],
                    "overrides": [
                        {
                            "rule_group_name": "PHP",
                            "rules": [{
                                "rule_id": "933100",
                                "enabled": False,
                                "action": "Block",
                            }],
                        },
                        {
                            "rule_group_name": "SQLI",
                            "exclusions": [{
                                "match_variable": "QueryStringArgNames",
                                "operator": "Equals",
                                "selector": "really_not_suspicious",
                            }],
                            "rules": [{
                                "rule_id": "942200",
                                "action": "Block",
                                "exclusions": [{
                                    "match_variable": "QueryStringArgNames",
                                    "operator": "Equals",
                                    "selector": "innocent",
                                }],
                            }],
                        },
                    ],
                },
                {
                    "type": "Microsoft_BotManagerRuleSet",
                    "version": "1.0",
                },
            ])
        ```

        ## Import

        FrontDoor Web Application Firewall Policy can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:frontdoor/firewallPolicy:FirewallPolicy example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/example-rg/providers/Microsoft.Network/frontDoorWebApplicationFirewallPolicies/examplefdwafpolicy
        ```

        :param str resource_name: The name of the resource.
        :param FirewallPolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FirewallPolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 custom_block_response_body: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_block_response_status_code: Optional[pulumi.Input[_builtins.int]] = None,
                 custom_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FirewallPolicyCustomRuleArgs', 'FirewallPolicyCustomRuleArgsDict']]]]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 managed_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FirewallPolicyManagedRuleArgs', 'FirewallPolicyManagedRuleArgsDict']]]]] = None,
                 mode: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 redirect_url: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FirewallPolicyArgs.__new__(FirewallPolicyArgs)

            __props__.__dict__["custom_block_response_body"] = custom_block_response_body
            __props__.__dict__["custom_block_response_status_code"] = custom_block_response_status_code
            __props__.__dict__["custom_rules"] = custom_rules
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["managed_rules"] = managed_rules
            __props__.__dict__["mode"] = mode
            __props__.__dict__["name"] = name
            __props__.__dict__["redirect_url"] = redirect_url
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["tags"] = tags
            __props__.__dict__["frontend_endpoint_ids"] = None
            __props__.__dict__["location"] = None
        super(FirewallPolicy, __self__).__init__(
            'azure:frontdoor/firewallPolicy:FirewallPolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            custom_block_response_body: Optional[pulumi.Input[_builtins.str]] = None,
            custom_block_response_status_code: Optional[pulumi.Input[_builtins.int]] = None,
            custom_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FirewallPolicyCustomRuleArgs', 'FirewallPolicyCustomRuleArgsDict']]]]] = None,
            enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            frontend_endpoint_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            managed_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FirewallPolicyManagedRuleArgs', 'FirewallPolicyManagedRuleArgsDict']]]]] = None,
            mode: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            redirect_url: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None) -> 'FirewallPolicy':
        """
        Get an existing FirewallPolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] custom_block_response_body: If a `custom_rule` block's action type is `block`, this is the response body. The body must be specified in base64 encoding.
        :param pulumi.Input[_builtins.int] custom_block_response_status_code: If a `custom_rule` block's action type is `block`, this is the response status code. Possible values are `200`, `403`, `405`, `406`, or `429`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['FirewallPolicyCustomRuleArgs', 'FirewallPolicyCustomRuleArgsDict']]]] custom_rules: One or more `custom_rule` blocks as defined below.
        :param pulumi.Input[_builtins.bool] enabled: Is the policy a enabled state or disabled state. Defaults to `true`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] frontend_endpoint_ids: The Frontend Endpoints associated with this Front Door Web Application Firewall policy.
        :param pulumi.Input[_builtins.str] location: The Azure Region where this Front Door Firewall Policy exists.
        :param pulumi.Input[Sequence[pulumi.Input[Union['FirewallPolicyManagedRuleArgs', 'FirewallPolicyManagedRuleArgsDict']]]] managed_rules: One or more `managed_rule` blocks as defined below.
        :param pulumi.Input[_builtins.str] mode: The firewall policy mode. Possible values are `Detection`, `Prevention`. Defaults to `Prevention`.
        :param pulumi.Input[_builtins.str] name: The name of the policy. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] redirect_url: If action type is redirect, this field represents redirect URL for the client.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the Web Application Firewall Policy.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FirewallPolicyState.__new__(_FirewallPolicyState)

        __props__.__dict__["custom_block_response_body"] = custom_block_response_body
        __props__.__dict__["custom_block_response_status_code"] = custom_block_response_status_code
        __props__.__dict__["custom_rules"] = custom_rules
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["frontend_endpoint_ids"] = frontend_endpoint_ids
        __props__.__dict__["location"] = location
        __props__.__dict__["managed_rules"] = managed_rules
        __props__.__dict__["mode"] = mode
        __props__.__dict__["name"] = name
        __props__.__dict__["redirect_url"] = redirect_url
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["tags"] = tags
        return FirewallPolicy(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="customBlockResponseBody")
    def custom_block_response_body(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        If a `custom_rule` block's action type is `block`, this is the response body. The body must be specified in base64 encoding.
        """
        return pulumi.get(self, "custom_block_response_body")

    @_builtins.property
    @pulumi.getter(name="customBlockResponseStatusCode")
    def custom_block_response_status_code(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        If a `custom_rule` block's action type is `block`, this is the response status code. Possible values are `200`, `403`, `405`, `406`, or `429`.
        """
        return pulumi.get(self, "custom_block_response_status_code")

    @_builtins.property
    @pulumi.getter(name="customRules")
    def custom_rules(self) -> pulumi.Output[Optional[Sequence['outputs.FirewallPolicyCustomRule']]]:
        """
        One or more `custom_rule` blocks as defined below.
        """
        return pulumi.get(self, "custom_rules")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Is the policy a enabled state or disabled state. Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="frontendEndpointIds")
    def frontend_endpoint_ids(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The Frontend Endpoints associated with this Front Door Web Application Firewall policy.
        """
        return pulumi.get(self, "frontend_endpoint_ids")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        The Azure Region where this Front Door Firewall Policy exists.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter(name="managedRules")
    def managed_rules(self) -> pulumi.Output[Optional[Sequence['outputs.FirewallPolicyManagedRule']]]:
        """
        One or more `managed_rule` blocks as defined below.
        """
        return pulumi.get(self, "managed_rules")

    @_builtins.property
    @pulumi.getter
    def mode(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The firewall policy mode. Possible values are `Detection`, `Prevention`. Defaults to `Prevention`.
        """
        return pulumi.get(self, "mode")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the policy. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="redirectUrl")
    def redirect_url(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        If action type is redirect, this field represents redirect URL for the client.
        """
        return pulumi.get(self, "redirect_url")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the resource group. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags to assign to the Web Application Firewall Policy.
        """
        return pulumi.get(self, "tags")

