# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetClusterResult',
    'AwaitableGetClusterResult',
    'get_cluster',
    'get_cluster_output',
]

@pulumi.output_type
class GetClusterResult:
    """
    A collection of values returned by getCluster.
    """
    def __init__(__self__, cluster_id=None, cluster_version=None, component_versions=None, edge_ssh_endpoint=None, gateways=None, https_endpoint=None, id=None, kafka_rest_proxy_endpoint=None, kind=None, location=None, name=None, resource_group_name=None, ssh_endpoint=None, tags=None, tier=None, tls_min_version=None):
        if cluster_id and not isinstance(cluster_id, str):
            raise TypeError("Expected argument 'cluster_id' to be a str")
        pulumi.set(__self__, "cluster_id", cluster_id)
        if cluster_version and not isinstance(cluster_version, str):
            raise TypeError("Expected argument 'cluster_version' to be a str")
        pulumi.set(__self__, "cluster_version", cluster_version)
        if component_versions and not isinstance(component_versions, dict):
            raise TypeError("Expected argument 'component_versions' to be a dict")
        pulumi.set(__self__, "component_versions", component_versions)
        if edge_ssh_endpoint and not isinstance(edge_ssh_endpoint, str):
            raise TypeError("Expected argument 'edge_ssh_endpoint' to be a str")
        pulumi.set(__self__, "edge_ssh_endpoint", edge_ssh_endpoint)
        if gateways and not isinstance(gateways, list):
            raise TypeError("Expected argument 'gateways' to be a list")
        pulumi.set(__self__, "gateways", gateways)
        if https_endpoint and not isinstance(https_endpoint, str):
            raise TypeError("Expected argument 'https_endpoint' to be a str")
        pulumi.set(__self__, "https_endpoint", https_endpoint)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if kafka_rest_proxy_endpoint and not isinstance(kafka_rest_proxy_endpoint, str):
            raise TypeError("Expected argument 'kafka_rest_proxy_endpoint' to be a str")
        pulumi.set(__self__, "kafka_rest_proxy_endpoint", kafka_rest_proxy_endpoint)
        if kind and not isinstance(kind, str):
            raise TypeError("Expected argument 'kind' to be a str")
        pulumi.set(__self__, "kind", kind)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if resource_group_name and not isinstance(resource_group_name, str):
            raise TypeError("Expected argument 'resource_group_name' to be a str")
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if ssh_endpoint and not isinstance(ssh_endpoint, str):
            raise TypeError("Expected argument 'ssh_endpoint' to be a str")
        pulumi.set(__self__, "ssh_endpoint", ssh_endpoint)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if tier and not isinstance(tier, str):
            raise TypeError("Expected argument 'tier' to be a str")
        pulumi.set(__self__, "tier", tier)
        if tls_min_version and not isinstance(tls_min_version, str):
            raise TypeError("Expected argument 'tls_min_version' to be a str")
        pulumi.set(__self__, "tls_min_version", tls_min_version)

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> _builtins.str:
        """
        The HDInsight Cluster ID.
        """
        return pulumi.get(self, "cluster_id")

    @_builtins.property
    @pulumi.getter(name="clusterVersion")
    def cluster_version(self) -> _builtins.str:
        """
        The version of HDInsights which is used on this HDInsight Cluster.
        """
        return pulumi.get(self, "cluster_version")

    @_builtins.property
    @pulumi.getter(name="componentVersions")
    def component_versions(self) -> Mapping[str, _builtins.str]:
        """
        A map of versions of software used on this HDInsights Cluster.
        """
        return pulumi.get(self, "component_versions")

    @_builtins.property
    @pulumi.getter(name="edgeSshEndpoint")
    def edge_ssh_endpoint(self) -> _builtins.str:
        """
        The SSH Endpoint of the Edge Node for this HDInsight Cluster, if an Edge Node exists.
        """
        return pulumi.get(self, "edge_ssh_endpoint")

    @_builtins.property
    @pulumi.getter
    def gateways(self) -> Sequence['outputs.GetClusterGatewayResult']:
        """
        A `gateway` block as defined below.
        """
        return pulumi.get(self, "gateways")

    @_builtins.property
    @pulumi.getter(name="httpsEndpoint")
    def https_endpoint(self) -> _builtins.str:
        """
        The HTTPS Endpoint for this HDInsight Cluster.
        """
        return pulumi.get(self, "https_endpoint")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="kafkaRestProxyEndpoint")
    def kafka_rest_proxy_endpoint(self) -> _builtins.str:
        """
        The Kafka Rest Proxy Endpoint for this HDInsight Cluster.
        """
        return pulumi.get(self, "kafka_rest_proxy_endpoint")

    @_builtins.property
    @pulumi.getter
    def kind(self) -> _builtins.str:
        """
        The kind of HDInsight Cluster this is, such as a Spark or Storm cluster.
        """
        return pulumi.get(self, "kind")

    @_builtins.property
    @pulumi.getter
    def location(self) -> _builtins.str:
        """
        The Azure Region in which this HDInsight Cluster exists.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The HDInsight Cluster name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> _builtins.str:
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter(name="sshEndpoint")
    def ssh_endpoint(self) -> _builtins.str:
        """
        The SSH Endpoint for this HDInsight Cluster.
        """
        return pulumi.get(self, "ssh_endpoint")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        A map of tags assigned to the HDInsight Cluster.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def tier(self) -> _builtins.str:
        """
        The SKU / Tier of this HDInsight Cluster.
        """
        return pulumi.get(self, "tier")

    @_builtins.property
    @pulumi.getter(name="tlsMinVersion")
    def tls_min_version(self) -> _builtins.str:
        """
        The minimal supported TLS version.
        """
        return pulumi.get(self, "tls_min_version")


class AwaitableGetClusterResult(GetClusterResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetClusterResult(
            cluster_id=self.cluster_id,
            cluster_version=self.cluster_version,
            component_versions=self.component_versions,
            edge_ssh_endpoint=self.edge_ssh_endpoint,
            gateways=self.gateways,
            https_endpoint=self.https_endpoint,
            id=self.id,
            kafka_rest_proxy_endpoint=self.kafka_rest_proxy_endpoint,
            kind=self.kind,
            location=self.location,
            name=self.name,
            resource_group_name=self.resource_group_name,
            ssh_endpoint=self.ssh_endpoint,
            tags=self.tags,
            tier=self.tier,
            tls_min_version=self.tls_min_version)


def get_cluster(name: Optional[_builtins.str] = None,
                resource_group_name: Optional[_builtins.str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetClusterResult:
    """
    Use this data source to access information about an existing HDInsight Cluster.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.hdinsight.get_cluster(name="example",
        resource_group_name="example-resources")
    pulumi.export("httpsEndpoint", example.https_endpoint)
    pulumi.export("clusterId", example.cluster_id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.HDInsight`: 2021-06-01


    :param _builtins.str name: Specifies the name of this HDInsight Cluster.
    :param _builtins.str resource_group_name: Specifies the name of the Resource Group in which this HDInsight Cluster exists.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:hdinsight/getCluster:getCluster', __args__, opts=opts, typ=GetClusterResult).value

    return AwaitableGetClusterResult(
        cluster_id=pulumi.get(__ret__, 'cluster_id'),
        cluster_version=pulumi.get(__ret__, 'cluster_version'),
        component_versions=pulumi.get(__ret__, 'component_versions'),
        edge_ssh_endpoint=pulumi.get(__ret__, 'edge_ssh_endpoint'),
        gateways=pulumi.get(__ret__, 'gateways'),
        https_endpoint=pulumi.get(__ret__, 'https_endpoint'),
        id=pulumi.get(__ret__, 'id'),
        kafka_rest_proxy_endpoint=pulumi.get(__ret__, 'kafka_rest_proxy_endpoint'),
        kind=pulumi.get(__ret__, 'kind'),
        location=pulumi.get(__ret__, 'location'),
        name=pulumi.get(__ret__, 'name'),
        resource_group_name=pulumi.get(__ret__, 'resource_group_name'),
        ssh_endpoint=pulumi.get(__ret__, 'ssh_endpoint'),
        tags=pulumi.get(__ret__, 'tags'),
        tier=pulumi.get(__ret__, 'tier'),
        tls_min_version=pulumi.get(__ret__, 'tls_min_version'))
def get_cluster_output(name: Optional[pulumi.Input[_builtins.str]] = None,
                       resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetClusterResult]:
    """
    Use this data source to access information about an existing HDInsight Cluster.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.hdinsight.get_cluster(name="example",
        resource_group_name="example-resources")
    pulumi.export("httpsEndpoint", example.https_endpoint)
    pulumi.export("clusterId", example.cluster_id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.HDInsight`: 2021-06-01


    :param _builtins.str name: Specifies the name of this HDInsight Cluster.
    :param _builtins.str resource_group_name: Specifies the name of the Resource Group in which this HDInsight Cluster exists.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:hdinsight/getCluster:getCluster', __args__, opts=opts, typ=GetClusterResult)
    return __ret__.apply(lambda __response__: GetClusterResult(
        cluster_id=pulumi.get(__response__, 'cluster_id'),
        cluster_version=pulumi.get(__response__, 'cluster_version'),
        component_versions=pulumi.get(__response__, 'component_versions'),
        edge_ssh_endpoint=pulumi.get(__response__, 'edge_ssh_endpoint'),
        gateways=pulumi.get(__response__, 'gateways'),
        https_endpoint=pulumi.get(__response__, 'https_endpoint'),
        id=pulumi.get(__response__, 'id'),
        kafka_rest_proxy_endpoint=pulumi.get(__response__, 'kafka_rest_proxy_endpoint'),
        kind=pulumi.get(__response__, 'kind'),
        location=pulumi.get(__response__, 'location'),
        name=pulumi.get(__response__, 'name'),
        resource_group_name=pulumi.get(__response__, 'resource_group_name'),
        ssh_endpoint=pulumi.get(__response__, 'ssh_endpoint'),
        tags=pulumi.get(__response__, 'tags'),
        tier=pulumi.get(__response__, 'tier'),
        tls_min_version=pulumi.get(__response__, 'tls_min_version')))
