# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetMedtechServiceResult',
    'AwaitableGetMedtechServiceResult',
    'get_medtech_service',
    'get_medtech_service_output',
]

@pulumi.output_type
class GetMedtechServiceResult:
    """
    A collection of values returned by getMedtechService.
    """
    def __init__(__self__, device_mapping_json=None, eventhub_consumer_group_name=None, eventhub_name=None, eventhub_namespace_name=None, id=None, identities=None, name=None, workspace_id=None):
        if device_mapping_json and not isinstance(device_mapping_json, str):
            raise TypeError("Expected argument 'device_mapping_json' to be a str")
        pulumi.set(__self__, "device_mapping_json", device_mapping_json)
        if eventhub_consumer_group_name and not isinstance(eventhub_consumer_group_name, str):
            raise TypeError("Expected argument 'eventhub_consumer_group_name' to be a str")
        pulumi.set(__self__, "eventhub_consumer_group_name", eventhub_consumer_group_name)
        if eventhub_name and not isinstance(eventhub_name, str):
            raise TypeError("Expected argument 'eventhub_name' to be a str")
        pulumi.set(__self__, "eventhub_name", eventhub_name)
        if eventhub_namespace_name and not isinstance(eventhub_namespace_name, str):
            raise TypeError("Expected argument 'eventhub_namespace_name' to be a str")
        pulumi.set(__self__, "eventhub_namespace_name", eventhub_namespace_name)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if identities and not isinstance(identities, list):
            raise TypeError("Expected argument 'identities' to be a list")
        pulumi.set(__self__, "identities", identities)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if workspace_id and not isinstance(workspace_id, str):
            raise TypeError("Expected argument 'workspace_id' to be a str")
        pulumi.set(__self__, "workspace_id", workspace_id)

    @_builtins.property
    @pulumi.getter(name="deviceMappingJson")
    def device_mapping_json(self) -> _builtins.str:
        """
        The Device Mappings of the Med Tech Service.
        """
        return pulumi.get(self, "device_mapping_json")

    @_builtins.property
    @pulumi.getter(name="eventhubConsumerGroupName")
    def eventhub_consumer_group_name(self) -> _builtins.str:
        """
        The Consumer Group of the Event Hub of the Healthcare Med Tech Service.
        """
        return pulumi.get(self, "eventhub_consumer_group_name")

    @_builtins.property
    @pulumi.getter(name="eventhubName")
    def eventhub_name(self) -> _builtins.str:
        """
        The name of the Event Hub of the Healthcare Med Tech Service.
        """
        return pulumi.get(self, "eventhub_name")

    @_builtins.property
    @pulumi.getter(name="eventhubNamespaceName")
    def eventhub_namespace_name(self) -> _builtins.str:
        """
        The namespace name of the Event Hub of the Healthcare Med Tech Service.
        """
        return pulumi.get(self, "eventhub_namespace_name")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def identities(self) -> Sequence['outputs.GetMedtechServiceIdentityResult']:
        """
        The `identity` block as defined below.
        """
        return pulumi.get(self, "identities")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> _builtins.str:
        return pulumi.get(self, "workspace_id")


class AwaitableGetMedtechServiceResult(GetMedtechServiceResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetMedtechServiceResult(
            device_mapping_json=self.device_mapping_json,
            eventhub_consumer_group_name=self.eventhub_consumer_group_name,
            eventhub_name=self.eventhub_name,
            eventhub_namespace_name=self.eventhub_namespace_name,
            id=self.id,
            identities=self.identities,
            name=self.name,
            workspace_id=self.workspace_id)


def get_medtech_service(name: Optional[_builtins.str] = None,
                        workspace_id: Optional[_builtins.str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetMedtechServiceResult:
    """
    Use this data source to access information about an existing Healthcare Med Tech Service

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.healthcare.get_medtech_service(name="tfexmedtech",
        workspace_id="tfexwks")
    pulumi.export("azurermHealthcareMedtechServiceId", example.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.HealthcareApis`: 2022-12-01


    :param _builtins.str name: The name of the Healthcare Med Tech Service.
    :param _builtins.str workspace_id: The id of the Healthcare Workspace in which the Healthcare Med Tech Service exists.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['workspaceId'] = workspace_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:healthcare/getMedtechService:getMedtechService', __args__, opts=opts, typ=GetMedtechServiceResult).value

    return AwaitableGetMedtechServiceResult(
        device_mapping_json=pulumi.get(__ret__, 'device_mapping_json'),
        eventhub_consumer_group_name=pulumi.get(__ret__, 'eventhub_consumer_group_name'),
        eventhub_name=pulumi.get(__ret__, 'eventhub_name'),
        eventhub_namespace_name=pulumi.get(__ret__, 'eventhub_namespace_name'),
        id=pulumi.get(__ret__, 'id'),
        identities=pulumi.get(__ret__, 'identities'),
        name=pulumi.get(__ret__, 'name'),
        workspace_id=pulumi.get(__ret__, 'workspace_id'))
def get_medtech_service_output(name: Optional[pulumi.Input[_builtins.str]] = None,
                               workspace_id: Optional[pulumi.Input[_builtins.str]] = None,
                               opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetMedtechServiceResult]:
    """
    Use this data source to access information about an existing Healthcare Med Tech Service

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.healthcare.get_medtech_service(name="tfexmedtech",
        workspace_id="tfexwks")
    pulumi.export("azurermHealthcareMedtechServiceId", example.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.HealthcareApis`: 2022-12-01


    :param _builtins.str name: The name of the Healthcare Med Tech Service.
    :param _builtins.str workspace_id: The id of the Healthcare Workspace in which the Healthcare Med Tech Service exists.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['workspaceId'] = workspace_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:healthcare/getMedtechService:getMedtechService', __args__, opts=opts, typ=GetMedtechServiceResult)
    return __ret__.apply(lambda __response__: GetMedtechServiceResult(
        device_mapping_json=pulumi.get(__response__, 'device_mapping_json'),
        eventhub_consumer_group_name=pulumi.get(__response__, 'eventhub_consumer_group_name'),
        eventhub_name=pulumi.get(__response__, 'eventhub_name'),
        eventhub_namespace_name=pulumi.get(__response__, 'eventhub_namespace_name'),
        id=pulumi.get(__response__, 'id'),
        identities=pulumi.get(__response__, 'identities'),
        name=pulumi.get(__response__, 'name'),
        workspace_id=pulumi.get(__response__, 'workspace_id')))
