# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CacheNfsTargetArgs', 'CacheNfsTarget']

@pulumi.input_type
class CacheNfsTargetArgs:
    def __init__(__self__, *,
                 cache_name: pulumi.Input[_builtins.str],
                 namespace_junctions: pulumi.Input[Sequence[pulumi.Input['CacheNfsTargetNamespaceJunctionArgs']]],
                 resource_group_name: pulumi.Input[_builtins.str],
                 target_host_name: pulumi.Input[_builtins.str],
                 usage_model: pulumi.Input[_builtins.str],
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 verification_timer_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 write_back_timer_in_seconds: Optional[pulumi.Input[_builtins.int]] = None):
        """
        The set of arguments for constructing a CacheNfsTarget resource.
        :param pulumi.Input[_builtins.str] cache_name: The name HPC Cache, which the HPC Cache NFS Target will be added to. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input['CacheNfsTargetNamespaceJunctionArgs']]] namespace_junctions: Can be specified multiple times to define multiple `namespace_junction`. Each `namespace_junction` block supports fields documented below.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group in which to create the HPC Cache NFS Target. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] target_host_name: The IP address or fully qualified domain name (FQDN) of the HPC Cache NFS target. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] usage_model: The type of usage of the HPC Cache NFS Target. Possible values are: `READ_HEAVY_INFREQ`, `READ_HEAVY_CHECK_180`, `READ_ONLY`, `READ_WRITE`, `WRITE_WORKLOAD_15`, `WRITE_AROUND`, `WRITE_WORKLOAD_CHECK_30`, `WRITE_WORKLOAD_CHECK_60` and `WRITE_WORKLOAD_CLOUDWS`.
        :param pulumi.Input[_builtins.str] name: The name of the HPC Cache NFS Target. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] verification_timer_in_seconds: The amount of time the cache waits before it checks the back-end storage for file updates. Possible values are between `1` and `31536000`.
        :param pulumi.Input[_builtins.int] write_back_timer_in_seconds: The amount of time the cache waits after the last file change before it copies the changed file to back-end storage. Possible values are between `1` and `31536000`.
        """
        pulumi.set(__self__, "cache_name", cache_name)
        pulumi.set(__self__, "namespace_junctions", namespace_junctions)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "target_host_name", target_host_name)
        pulumi.set(__self__, "usage_model", usage_model)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if verification_timer_in_seconds is not None:
            pulumi.set(__self__, "verification_timer_in_seconds", verification_timer_in_seconds)
        if write_back_timer_in_seconds is not None:
            pulumi.set(__self__, "write_back_timer_in_seconds", write_back_timer_in_seconds)

    @_builtins.property
    @pulumi.getter(name="cacheName")
    def cache_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name HPC Cache, which the HPC Cache NFS Target will be added to. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "cache_name")

    @cache_name.setter
    def cache_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "cache_name", value)

    @_builtins.property
    @pulumi.getter(name="namespaceJunctions")
    def namespace_junctions(self) -> pulumi.Input[Sequence[pulumi.Input['CacheNfsTargetNamespaceJunctionArgs']]]:
        """
        Can be specified multiple times to define multiple `namespace_junction`. Each `namespace_junction` block supports fields documented below.
        """
        return pulumi.get(self, "namespace_junctions")

    @namespace_junctions.setter
    def namespace_junctions(self, value: pulumi.Input[Sequence[pulumi.Input['CacheNfsTargetNamespaceJunctionArgs']]]):
        pulumi.set(self, "namespace_junctions", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the Resource Group in which to create the HPC Cache NFS Target. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="targetHostName")
    def target_host_name(self) -> pulumi.Input[_builtins.str]:
        """
        The IP address or fully qualified domain name (FQDN) of the HPC Cache NFS target. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "target_host_name")

    @target_host_name.setter
    def target_host_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "target_host_name", value)

    @_builtins.property
    @pulumi.getter(name="usageModel")
    def usage_model(self) -> pulumi.Input[_builtins.str]:
        """
        The type of usage of the HPC Cache NFS Target. Possible values are: `READ_HEAVY_INFREQ`, `READ_HEAVY_CHECK_180`, `READ_ONLY`, `READ_WRITE`, `WRITE_WORKLOAD_15`, `WRITE_AROUND`, `WRITE_WORKLOAD_CHECK_30`, `WRITE_WORKLOAD_CHECK_60` and `WRITE_WORKLOAD_CLOUDWS`.
        """
        return pulumi.get(self, "usage_model")

    @usage_model.setter
    def usage_model(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "usage_model", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the HPC Cache NFS Target. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="verificationTimerInSeconds")
    def verification_timer_in_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The amount of time the cache waits before it checks the back-end storage for file updates. Possible values are between `1` and `31536000`.
        """
        return pulumi.get(self, "verification_timer_in_seconds")

    @verification_timer_in_seconds.setter
    def verification_timer_in_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "verification_timer_in_seconds", value)

    @_builtins.property
    @pulumi.getter(name="writeBackTimerInSeconds")
    def write_back_timer_in_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The amount of time the cache waits after the last file change before it copies the changed file to back-end storage. Possible values are between `1` and `31536000`.
        """
        return pulumi.get(self, "write_back_timer_in_seconds")

    @write_back_timer_in_seconds.setter
    def write_back_timer_in_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "write_back_timer_in_seconds", value)


@pulumi.input_type
class _CacheNfsTargetState:
    def __init__(__self__, *,
                 cache_name: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace_junctions: Optional[pulumi.Input[Sequence[pulumi.Input['CacheNfsTargetNamespaceJunctionArgs']]]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 target_host_name: Optional[pulumi.Input[_builtins.str]] = None,
                 usage_model: Optional[pulumi.Input[_builtins.str]] = None,
                 verification_timer_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 write_back_timer_in_seconds: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering CacheNfsTarget resources.
        :param pulumi.Input[_builtins.str] cache_name: The name HPC Cache, which the HPC Cache NFS Target will be added to. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name of the HPC Cache NFS Target. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input['CacheNfsTargetNamespaceJunctionArgs']]] namespace_junctions: Can be specified multiple times to define multiple `namespace_junction`. Each `namespace_junction` block supports fields documented below.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group in which to create the HPC Cache NFS Target. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] target_host_name: The IP address or fully qualified domain name (FQDN) of the HPC Cache NFS target. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] usage_model: The type of usage of the HPC Cache NFS Target. Possible values are: `READ_HEAVY_INFREQ`, `READ_HEAVY_CHECK_180`, `READ_ONLY`, `READ_WRITE`, `WRITE_WORKLOAD_15`, `WRITE_AROUND`, `WRITE_WORKLOAD_CHECK_30`, `WRITE_WORKLOAD_CHECK_60` and `WRITE_WORKLOAD_CLOUDWS`.
        :param pulumi.Input[_builtins.int] verification_timer_in_seconds: The amount of time the cache waits before it checks the back-end storage for file updates. Possible values are between `1` and `31536000`.
        :param pulumi.Input[_builtins.int] write_back_timer_in_seconds: The amount of time the cache waits after the last file change before it copies the changed file to back-end storage. Possible values are between `1` and `31536000`.
        """
        if cache_name is not None:
            pulumi.set(__self__, "cache_name", cache_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if namespace_junctions is not None:
            pulumi.set(__self__, "namespace_junctions", namespace_junctions)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if target_host_name is not None:
            pulumi.set(__self__, "target_host_name", target_host_name)
        if usage_model is not None:
            pulumi.set(__self__, "usage_model", usage_model)
        if verification_timer_in_seconds is not None:
            pulumi.set(__self__, "verification_timer_in_seconds", verification_timer_in_seconds)
        if write_back_timer_in_seconds is not None:
            pulumi.set(__self__, "write_back_timer_in_seconds", write_back_timer_in_seconds)

    @_builtins.property
    @pulumi.getter(name="cacheName")
    def cache_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name HPC Cache, which the HPC Cache NFS Target will be added to. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "cache_name")

    @cache_name.setter
    def cache_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cache_name", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the HPC Cache NFS Target. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="namespaceJunctions")
    def namespace_junctions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CacheNfsTargetNamespaceJunctionArgs']]]]:
        """
        Can be specified multiple times to define multiple `namespace_junction`. Each `namespace_junction` block supports fields documented below.
        """
        return pulumi.get(self, "namespace_junctions")

    @namespace_junctions.setter
    def namespace_junctions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CacheNfsTargetNamespaceJunctionArgs']]]]):
        pulumi.set(self, "namespace_junctions", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Resource Group in which to create the HPC Cache NFS Target. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="targetHostName")
    def target_host_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IP address or fully qualified domain name (FQDN) of the HPC Cache NFS target. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "target_host_name")

    @target_host_name.setter
    def target_host_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "target_host_name", value)

    @_builtins.property
    @pulumi.getter(name="usageModel")
    def usage_model(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of usage of the HPC Cache NFS Target. Possible values are: `READ_HEAVY_INFREQ`, `READ_HEAVY_CHECK_180`, `READ_ONLY`, `READ_WRITE`, `WRITE_WORKLOAD_15`, `WRITE_AROUND`, `WRITE_WORKLOAD_CHECK_30`, `WRITE_WORKLOAD_CHECK_60` and `WRITE_WORKLOAD_CLOUDWS`.
        """
        return pulumi.get(self, "usage_model")

    @usage_model.setter
    def usage_model(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "usage_model", value)

    @_builtins.property
    @pulumi.getter(name="verificationTimerInSeconds")
    def verification_timer_in_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The amount of time the cache waits before it checks the back-end storage for file updates. Possible values are between `1` and `31536000`.
        """
        return pulumi.get(self, "verification_timer_in_seconds")

    @verification_timer_in_seconds.setter
    def verification_timer_in_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "verification_timer_in_seconds", value)

    @_builtins.property
    @pulumi.getter(name="writeBackTimerInSeconds")
    def write_back_timer_in_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The amount of time the cache waits after the last file change before it copies the changed file to back-end storage. Possible values are between `1` and `31536000`.
        """
        return pulumi.get(self, "write_back_timer_in_seconds")

    @write_back_timer_in_seconds.setter
    def write_back_timer_in_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "write_back_timer_in_seconds", value)


@pulumi.type_token("azure:hpc/cacheNfsTarget:CacheNfsTarget")
class CacheNfsTarget(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cache_name: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace_junctions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CacheNfsTargetNamespaceJunctionArgs', 'CacheNfsTargetNamespaceJunctionArgsDict']]]]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 target_host_name: Optional[pulumi.Input[_builtins.str]] = None,
                 usage_model: Optional[pulumi.Input[_builtins.str]] = None,
                 verification_timer_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 write_back_timer_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        Manages a NFS Target within a HPC Cache.

        !> **Note:** The `hpc.CacheNfsTarget` resource has been deprecated because the service is retiring on 2025-09-30. This resource will be removed in v5.0 of the AzureRM Provider. See https://aka.ms/hpccacheretirement for more information.

        > **Note:** By request of the service team the provider no longer automatically registering the `Microsoft.StorageCache` Resource Provider for this resource. To register it you can run `az provider register --namespace 'Microsoft.StorageCache'`.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure
        import pulumi_std as std

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_virtual_network = azure.network.VirtualNetwork("example",
            name="examplevn",
            address_spaces=["10.0.0.0/16"],
            location=example.location,
            resource_group_name=example.name)
        example_hpc = azure.network.Subnet("example_hpc",
            name="examplesubnethpc",
            resource_group_name=example.name,
            virtual_network_name=example_virtual_network.name,
            address_prefixes=["10.0.1.0/24"])
        example_cache = azure.hpc.Cache("example",
            name="examplehpccache",
            resource_group_name=example.name,
            location=example.location,
            cache_size_in_gb=3072,
            subnet_id=example_hpc.id,
            sku_name="Standard_2G")
        example_vm = azure.network.Subnet("example_vm",
            name="examplesubnetvm",
            resource_group_name=example.name,
            virtual_network_name=example_virtual_network.name,
            address_prefixes=["10.0.2.0/24"])
        example_network_interface = azure.network.NetworkInterface("example",
            name="examplenic",
            location=example.location,
            resource_group_name=example.name,
            ip_configurations=[{
                "name": "internal",
                "subnet_id": example_vm.id,
                "private_ip_address_allocation": "Dynamic",
            }])
        custom_data = \"\"\"#!/bin/bash
        sudo -i 
        apt-get install -y nfs-kernel-server
        mkdir -p /export/a/1
        mkdir -p /export/a/2
        mkdir -p /export/b
        cat << EOF > /etc/exports
        /export/a *(rw,fsid=0,insecure,no_subtree_check,async)
        /export/b *(rw,fsid=0,insecure,no_subtree_check,async)
        EOF
        systemctl start nfs-server
        exportfs -arv
        \"\"\"
        example_linux_virtual_machine = azure.compute.LinuxVirtualMachine("example",
            name="examplevm",
            resource_group_name=example.name,
            location=example.location,
            size="Standard_F2",
            admin_username="adminuser",
            network_interface_ids=[example_network_interface.id],
            admin_ssh_keys=[{
                "username": "adminuser",
                "public_key": std.file(input="~/.ssh/id_rsa.pub").result,
            }],
            os_disk={
                "caching": "ReadWrite",
                "storage_account_type": "Standard_LRS",
            },
            source_image_reference={
                "publisher": "Canonical",
                "offer": "0001-com-ubuntu-server-jammy",
                "sku": "22_04-lts",
                "version": "latest",
            },
            custom_data=std.base64encode(input=custom_data).result)
        example_cache_nfs_target = azure.hpc.CacheNfsTarget("example",
            name="examplehpcnfstarget",
            resource_group_name=example.name,
            cache_name=example_cache.name,
            target_host_name=example_linux_virtual_machine.private_ip_address,
            usage_model="READ_HEAVY_INFREQ",
            namespace_junctions=[
                {
                    "namespace_path": "/nfs/a1",
                    "nfs_export": "/export/a",
                    "target_path": "1",
                },
                {
                    "namespace_path": "/nfs/b",
                    "nfs_export": "/export/b",
                },
            ])
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.StorageCache`: 2023-05-01

        ## Import

        NFS Target within a HPC Cache can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:hpc/cacheNfsTarget:CacheNfsTarget example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.StorageCache/caches/cache1/storageTargets/target1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cache_name: The name HPC Cache, which the HPC Cache NFS Target will be added to. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name of the HPC Cache NFS Target. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CacheNfsTargetNamespaceJunctionArgs', 'CacheNfsTargetNamespaceJunctionArgsDict']]]] namespace_junctions: Can be specified multiple times to define multiple `namespace_junction`. Each `namespace_junction` block supports fields documented below.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group in which to create the HPC Cache NFS Target. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] target_host_name: The IP address or fully qualified domain name (FQDN) of the HPC Cache NFS target. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] usage_model: The type of usage of the HPC Cache NFS Target. Possible values are: `READ_HEAVY_INFREQ`, `READ_HEAVY_CHECK_180`, `READ_ONLY`, `READ_WRITE`, `WRITE_WORKLOAD_15`, `WRITE_AROUND`, `WRITE_WORKLOAD_CHECK_30`, `WRITE_WORKLOAD_CHECK_60` and `WRITE_WORKLOAD_CLOUDWS`.
        :param pulumi.Input[_builtins.int] verification_timer_in_seconds: The amount of time the cache waits before it checks the back-end storage for file updates. Possible values are between `1` and `31536000`.
        :param pulumi.Input[_builtins.int] write_back_timer_in_seconds: The amount of time the cache waits after the last file change before it copies the changed file to back-end storage. Possible values are between `1` and `31536000`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CacheNfsTargetArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a NFS Target within a HPC Cache.

        !> **Note:** The `hpc.CacheNfsTarget` resource has been deprecated because the service is retiring on 2025-09-30. This resource will be removed in v5.0 of the AzureRM Provider. See https://aka.ms/hpccacheretirement for more information.

        > **Note:** By request of the service team the provider no longer automatically registering the `Microsoft.StorageCache` Resource Provider for this resource. To register it you can run `az provider register --namespace 'Microsoft.StorageCache'`.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure
        import pulumi_std as std

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_virtual_network = azure.network.VirtualNetwork("example",
            name="examplevn",
            address_spaces=["10.0.0.0/16"],
            location=example.location,
            resource_group_name=example.name)
        example_hpc = azure.network.Subnet("example_hpc",
            name="examplesubnethpc",
            resource_group_name=example.name,
            virtual_network_name=example_virtual_network.name,
            address_prefixes=["10.0.1.0/24"])
        example_cache = azure.hpc.Cache("example",
            name="examplehpccache",
            resource_group_name=example.name,
            location=example.location,
            cache_size_in_gb=3072,
            subnet_id=example_hpc.id,
            sku_name="Standard_2G")
        example_vm = azure.network.Subnet("example_vm",
            name="examplesubnetvm",
            resource_group_name=example.name,
            virtual_network_name=example_virtual_network.name,
            address_prefixes=["10.0.2.0/24"])
        example_network_interface = azure.network.NetworkInterface("example",
            name="examplenic",
            location=example.location,
            resource_group_name=example.name,
            ip_configurations=[{
                "name": "internal",
                "subnet_id": example_vm.id,
                "private_ip_address_allocation": "Dynamic",
            }])
        custom_data = \"\"\"#!/bin/bash
        sudo -i 
        apt-get install -y nfs-kernel-server
        mkdir -p /export/a/1
        mkdir -p /export/a/2
        mkdir -p /export/b
        cat << EOF > /etc/exports
        /export/a *(rw,fsid=0,insecure,no_subtree_check,async)
        /export/b *(rw,fsid=0,insecure,no_subtree_check,async)
        EOF
        systemctl start nfs-server
        exportfs -arv
        \"\"\"
        example_linux_virtual_machine = azure.compute.LinuxVirtualMachine("example",
            name="examplevm",
            resource_group_name=example.name,
            location=example.location,
            size="Standard_F2",
            admin_username="adminuser",
            network_interface_ids=[example_network_interface.id],
            admin_ssh_keys=[{
                "username": "adminuser",
                "public_key": std.file(input="~/.ssh/id_rsa.pub").result,
            }],
            os_disk={
                "caching": "ReadWrite",
                "storage_account_type": "Standard_LRS",
            },
            source_image_reference={
                "publisher": "Canonical",
                "offer": "0001-com-ubuntu-server-jammy",
                "sku": "22_04-lts",
                "version": "latest",
            },
            custom_data=std.base64encode(input=custom_data).result)
        example_cache_nfs_target = azure.hpc.CacheNfsTarget("example",
            name="examplehpcnfstarget",
            resource_group_name=example.name,
            cache_name=example_cache.name,
            target_host_name=example_linux_virtual_machine.private_ip_address,
            usage_model="READ_HEAVY_INFREQ",
            namespace_junctions=[
                {
                    "namespace_path": "/nfs/a1",
                    "nfs_export": "/export/a",
                    "target_path": "1",
                },
                {
                    "namespace_path": "/nfs/b",
                    "nfs_export": "/export/b",
                },
            ])
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.StorageCache`: 2023-05-01

        ## Import

        NFS Target within a HPC Cache can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:hpc/cacheNfsTarget:CacheNfsTarget example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.StorageCache/caches/cache1/storageTargets/target1
        ```

        :param str resource_name: The name of the resource.
        :param CacheNfsTargetArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CacheNfsTargetArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cache_name: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace_junctions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CacheNfsTargetNamespaceJunctionArgs', 'CacheNfsTargetNamespaceJunctionArgsDict']]]]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 target_host_name: Optional[pulumi.Input[_builtins.str]] = None,
                 usage_model: Optional[pulumi.Input[_builtins.str]] = None,
                 verification_timer_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 write_back_timer_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CacheNfsTargetArgs.__new__(CacheNfsTargetArgs)

            if cache_name is None and not opts.urn:
                raise TypeError("Missing required property 'cache_name'")
            __props__.__dict__["cache_name"] = cache_name
            __props__.__dict__["name"] = name
            if namespace_junctions is None and not opts.urn:
                raise TypeError("Missing required property 'namespace_junctions'")
            __props__.__dict__["namespace_junctions"] = namespace_junctions
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            if target_host_name is None and not opts.urn:
                raise TypeError("Missing required property 'target_host_name'")
            __props__.__dict__["target_host_name"] = target_host_name
            if usage_model is None and not opts.urn:
                raise TypeError("Missing required property 'usage_model'")
            __props__.__dict__["usage_model"] = usage_model
            __props__.__dict__["verification_timer_in_seconds"] = verification_timer_in_seconds
            __props__.__dict__["write_back_timer_in_seconds"] = write_back_timer_in_seconds
        super(CacheNfsTarget, __self__).__init__(
            'azure:hpc/cacheNfsTarget:CacheNfsTarget',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cache_name: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            namespace_junctions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CacheNfsTargetNamespaceJunctionArgs', 'CacheNfsTargetNamespaceJunctionArgsDict']]]]] = None,
            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            target_host_name: Optional[pulumi.Input[_builtins.str]] = None,
            usage_model: Optional[pulumi.Input[_builtins.str]] = None,
            verification_timer_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
            write_back_timer_in_seconds: Optional[pulumi.Input[_builtins.int]] = None) -> 'CacheNfsTarget':
        """
        Get an existing CacheNfsTarget resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cache_name: The name HPC Cache, which the HPC Cache NFS Target will be added to. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name of the HPC Cache NFS Target. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CacheNfsTargetNamespaceJunctionArgs', 'CacheNfsTargetNamespaceJunctionArgsDict']]]] namespace_junctions: Can be specified multiple times to define multiple `namespace_junction`. Each `namespace_junction` block supports fields documented below.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group in which to create the HPC Cache NFS Target. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] target_host_name: The IP address or fully qualified domain name (FQDN) of the HPC Cache NFS target. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] usage_model: The type of usage of the HPC Cache NFS Target. Possible values are: `READ_HEAVY_INFREQ`, `READ_HEAVY_CHECK_180`, `READ_ONLY`, `READ_WRITE`, `WRITE_WORKLOAD_15`, `WRITE_AROUND`, `WRITE_WORKLOAD_CHECK_30`, `WRITE_WORKLOAD_CHECK_60` and `WRITE_WORKLOAD_CLOUDWS`.
        :param pulumi.Input[_builtins.int] verification_timer_in_seconds: The amount of time the cache waits before it checks the back-end storage for file updates. Possible values are between `1` and `31536000`.
        :param pulumi.Input[_builtins.int] write_back_timer_in_seconds: The amount of time the cache waits after the last file change before it copies the changed file to back-end storage. Possible values are between `1` and `31536000`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CacheNfsTargetState.__new__(_CacheNfsTargetState)

        __props__.__dict__["cache_name"] = cache_name
        __props__.__dict__["name"] = name
        __props__.__dict__["namespace_junctions"] = namespace_junctions
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["target_host_name"] = target_host_name
        __props__.__dict__["usage_model"] = usage_model
        __props__.__dict__["verification_timer_in_seconds"] = verification_timer_in_seconds
        __props__.__dict__["write_back_timer_in_seconds"] = write_back_timer_in_seconds
        return CacheNfsTarget(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="cacheName")
    def cache_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name HPC Cache, which the HPC Cache NFS Target will be added to. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "cache_name")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the HPC Cache NFS Target. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="namespaceJunctions")
    def namespace_junctions(self) -> pulumi.Output[Sequence['outputs.CacheNfsTargetNamespaceJunction']]:
        """
        Can be specified multiple times to define multiple `namespace_junction`. Each `namespace_junction` block supports fields documented below.
        """
        return pulumi.get(self, "namespace_junctions")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Resource Group in which to create the HPC Cache NFS Target. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter(name="targetHostName")
    def target_host_name(self) -> pulumi.Output[_builtins.str]:
        """
        The IP address or fully qualified domain name (FQDN) of the HPC Cache NFS target. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "target_host_name")

    @_builtins.property
    @pulumi.getter(name="usageModel")
    def usage_model(self) -> pulumi.Output[_builtins.str]:
        """
        The type of usage of the HPC Cache NFS Target. Possible values are: `READ_HEAVY_INFREQ`, `READ_HEAVY_CHECK_180`, `READ_ONLY`, `READ_WRITE`, `WRITE_WORKLOAD_15`, `WRITE_AROUND`, `WRITE_WORKLOAD_CHECK_30`, `WRITE_WORKLOAD_CHECK_60` and `WRITE_WORKLOAD_CLOUDWS`.
        """
        return pulumi.get(self, "usage_model")

    @_builtins.property
    @pulumi.getter(name="verificationTimerInSeconds")
    def verification_timer_in_seconds(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The amount of time the cache waits before it checks the back-end storage for file updates. Possible values are between `1` and `31536000`.
        """
        return pulumi.get(self, "verification_timer_in_seconds")

    @_builtins.property
    @pulumi.getter(name="writeBackTimerInSeconds")
    def write_back_timer_in_seconds(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The amount of time the cache waits after the last file change before it copies the changed file to back-end storage. Possible values are between `1` and `31536000`.
        """
        return pulumi.get(self, "write_back_timer_in_seconds")

