# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['EventGridDataConnectionArgs', 'EventGridDataConnection']

@pulumi.input_type
class EventGridDataConnectionArgs:
    def __init__(__self__, *,
                 cluster_name: pulumi.Input[_builtins.str],
                 database_name: pulumi.Input[_builtins.str],
                 eventhub_consumer_group_name: pulumi.Input[_builtins.str],
                 eventhub_id: pulumi.Input[_builtins.str],
                 resource_group_name: pulumi.Input[_builtins.str],
                 storage_account_id: pulumi.Input[_builtins.str],
                 blob_storage_event_type: Optional[pulumi.Input[_builtins.str]] = None,
                 data_format: Optional[pulumi.Input[_builtins.str]] = None,
                 database_routing_type: Optional[pulumi.Input[_builtins.str]] = None,
                 eventgrid_event_subscription_id: Optional[pulumi.Input[_builtins.str]] = None,
                 eventgrid_resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 managed_identity_id: Optional[pulumi.Input[_builtins.str]] = None,
                 managed_identity_resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 mapping_rule_name: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 skip_first_record: Optional[pulumi.Input[_builtins.bool]] = None,
                 table_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a EventGridDataConnection resource.
        :param pulumi.Input[_builtins.str] cluster_name: Specifies the name of the Kusto Cluster this data connection will be added to. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] database_name: Specifies the name of the Kusto Database this data connection will be added to. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] eventhub_consumer_group_name: Specifies the Event Hub consumer group this data connection will use for ingestion. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] eventhub_id: Specifies the resource id of the Event Hub this data connection will use for ingestion. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: Specifies the Resource Group where the Kusto Database should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] storage_account_id: Specifies the resource id of the Storage Account this data connection will use for ingestion. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] blob_storage_event_type: Specifies the blob storage event type that needs to be processed. Possible Values are `Microsoft.Storage.BlobCreated` and `Microsoft.Storage.BlobRenamed`. Defaults to `Microsoft.Storage.BlobCreated`.
        :param pulumi.Input[_builtins.str] data_format: Specifies the data format of the EventHub messages. Allowed values: `APACHEAVRO`, `AVRO`, `CSV`, `JSON`, `MULTIJSON`, `ORC`, `PARQUET`, `PSV`, `RAW`, `SCSV`, `SINGLEJSON`, `SOHSV`, `TSV`, `TSVE`, `TXT` and `W3CLOGFILE`.
        :param pulumi.Input[_builtins.str] database_routing_type: Indication for database routing information from the data connection, by default only database routing information is allowed. Allowed values: `Single`, `Multi`. Changing this forces a new resource to be created. Defaults to `Single`.
        :param pulumi.Input[_builtins.str] eventgrid_event_subscription_id: The resource ID of the event grid that is subscribed to the storage account events.
        :param pulumi.Input[_builtins.str] location: The location where the Kusto Database should be created. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] managed_identity_id: Empty for non-managed identity based data connection. For system assigned identity, provide cluster resource Id. For user assigned identity (UAI) provide the UAI resource Id.
        :param pulumi.Input[_builtins.str] mapping_rule_name: Specifies the mapping rule used for the message ingestion. Mapping rule must exist before resource is created.
        :param pulumi.Input[_builtins.str] name: The name of the Kusto Event Grid Data Connection to create. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] skip_first_record: is the first record of every file ignored? Defaults to `false`.
        :param pulumi.Input[_builtins.str] table_name: Specifies the target table name used for the message ingestion. Table must exist before resource is created.
        """
        pulumi.set(__self__, "cluster_name", cluster_name)
        pulumi.set(__self__, "database_name", database_name)
        pulumi.set(__self__, "eventhub_consumer_group_name", eventhub_consumer_group_name)
        pulumi.set(__self__, "eventhub_id", eventhub_id)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "storage_account_id", storage_account_id)
        if blob_storage_event_type is not None:
            pulumi.set(__self__, "blob_storage_event_type", blob_storage_event_type)
        if data_format is not None:
            pulumi.set(__self__, "data_format", data_format)
        if database_routing_type is not None:
            pulumi.set(__self__, "database_routing_type", database_routing_type)
        if eventgrid_event_subscription_id is not None:
            pulumi.set(__self__, "eventgrid_event_subscription_id", eventgrid_event_subscription_id)
        if eventgrid_resource_id is not None:
            warnings.warn("""`eventgrid_resource_id` has been deprecated in favour of the `eventgrid_event_subscription_id` property and will be removed in v5.0 of the AzureRM Provider.""", DeprecationWarning)
            pulumi.log.warn("""eventgrid_resource_id is deprecated: `eventgrid_resource_id` has been deprecated in favour of the `eventgrid_event_subscription_id` property and will be removed in v5.0 of the AzureRM Provider.""")
        if eventgrid_resource_id is not None:
            pulumi.set(__self__, "eventgrid_resource_id", eventgrid_resource_id)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if managed_identity_id is not None:
            pulumi.set(__self__, "managed_identity_id", managed_identity_id)
        if managed_identity_resource_id is not None:
            warnings.warn("""`managed_identity_resource_id` has been deprecated in favour of the `managed_identity_id` property and will be removed in v5.0 of the AzureRM Provider.""", DeprecationWarning)
            pulumi.log.warn("""managed_identity_resource_id is deprecated: `managed_identity_resource_id` has been deprecated in favour of the `managed_identity_id` property and will be removed in v5.0 of the AzureRM Provider.""")
        if managed_identity_resource_id is not None:
            pulumi.set(__self__, "managed_identity_resource_id", managed_identity_resource_id)
        if mapping_rule_name is not None:
            pulumi.set(__self__, "mapping_rule_name", mapping_rule_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if skip_first_record is not None:
            pulumi.set(__self__, "skip_first_record", skip_first_record)
        if table_name is not None:
            pulumi.set(__self__, "table_name", table_name)

    @_builtins.property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the name of the Kusto Cluster this data connection will be added to. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "cluster_name")

    @cluster_name.setter
    def cluster_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "cluster_name", value)

    @_builtins.property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the name of the Kusto Database this data connection will be added to. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "database_name")

    @database_name.setter
    def database_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "database_name", value)

    @_builtins.property
    @pulumi.getter(name="eventhubConsumerGroupName")
    def eventhub_consumer_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the Event Hub consumer group this data connection will use for ingestion. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "eventhub_consumer_group_name")

    @eventhub_consumer_group_name.setter
    def eventhub_consumer_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "eventhub_consumer_group_name", value)

    @_builtins.property
    @pulumi.getter(name="eventhubId")
    def eventhub_id(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the resource id of the Event Hub this data connection will use for ingestion. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "eventhub_id")

    @eventhub_id.setter
    def eventhub_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "eventhub_id", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the Resource Group where the Kusto Database should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="storageAccountId")
    def storage_account_id(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the resource id of the Storage Account this data connection will use for ingestion. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "storage_account_id")

    @storage_account_id.setter
    def storage_account_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "storage_account_id", value)

    @_builtins.property
    @pulumi.getter(name="blobStorageEventType")
    def blob_storage_event_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the blob storage event type that needs to be processed. Possible Values are `Microsoft.Storage.BlobCreated` and `Microsoft.Storage.BlobRenamed`. Defaults to `Microsoft.Storage.BlobCreated`.
        """
        return pulumi.get(self, "blob_storage_event_type")

    @blob_storage_event_type.setter
    def blob_storage_event_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "blob_storage_event_type", value)

    @_builtins.property
    @pulumi.getter(name="dataFormat")
    def data_format(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the data format of the EventHub messages. Allowed values: `APACHEAVRO`, `AVRO`, `CSV`, `JSON`, `MULTIJSON`, `ORC`, `PARQUET`, `PSV`, `RAW`, `SCSV`, `SINGLEJSON`, `SOHSV`, `TSV`, `TSVE`, `TXT` and `W3CLOGFILE`.
        """
        return pulumi.get(self, "data_format")

    @data_format.setter
    def data_format(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "data_format", value)

    @_builtins.property
    @pulumi.getter(name="databaseRoutingType")
    def database_routing_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indication for database routing information from the data connection, by default only database routing information is allowed. Allowed values: `Single`, `Multi`. Changing this forces a new resource to be created. Defaults to `Single`.
        """
        return pulumi.get(self, "database_routing_type")

    @database_routing_type.setter
    def database_routing_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "database_routing_type", value)

    @_builtins.property
    @pulumi.getter(name="eventgridEventSubscriptionId")
    def eventgrid_event_subscription_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource ID of the event grid that is subscribed to the storage account events.
        """
        return pulumi.get(self, "eventgrid_event_subscription_id")

    @eventgrid_event_subscription_id.setter
    def eventgrid_event_subscription_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "eventgrid_event_subscription_id", value)

    @_builtins.property
    @pulumi.getter(name="eventgridResourceId")
    @_utilities.deprecated("""`eventgrid_resource_id` has been deprecated in favour of the `eventgrid_event_subscription_id` property and will be removed in v5.0 of the AzureRM Provider.""")
    def eventgrid_resource_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "eventgrid_resource_id")

    @eventgrid_resource_id.setter
    def eventgrid_resource_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "eventgrid_resource_id", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The location where the Kusto Database should be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="managedIdentityId")
    def managed_identity_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Empty for non-managed identity based data connection. For system assigned identity, provide cluster resource Id. For user assigned identity (UAI) provide the UAI resource Id.
        """
        return pulumi.get(self, "managed_identity_id")

    @managed_identity_id.setter
    def managed_identity_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "managed_identity_id", value)

    @_builtins.property
    @pulumi.getter(name="managedIdentityResourceId")
    @_utilities.deprecated("""`managed_identity_resource_id` has been deprecated in favour of the `managed_identity_id` property and will be removed in v5.0 of the AzureRM Provider.""")
    def managed_identity_resource_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "managed_identity_resource_id")

    @managed_identity_resource_id.setter
    def managed_identity_resource_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "managed_identity_resource_id", value)

    @_builtins.property
    @pulumi.getter(name="mappingRuleName")
    def mapping_rule_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the mapping rule used for the message ingestion. Mapping rule must exist before resource is created.
        """
        return pulumi.get(self, "mapping_rule_name")

    @mapping_rule_name.setter
    def mapping_rule_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mapping_rule_name", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Kusto Event Grid Data Connection to create. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="skipFirstRecord")
    def skip_first_record(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        is the first record of every file ignored? Defaults to `false`.
        """
        return pulumi.get(self, "skip_first_record")

    @skip_first_record.setter
    def skip_first_record(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "skip_first_record", value)

    @_builtins.property
    @pulumi.getter(name="tableName")
    def table_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the target table name used for the message ingestion. Table must exist before resource is created.
        """
        return pulumi.get(self, "table_name")

    @table_name.setter
    def table_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "table_name", value)


@pulumi.input_type
class _EventGridDataConnectionState:
    def __init__(__self__, *,
                 blob_storage_event_type: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_name: Optional[pulumi.Input[_builtins.str]] = None,
                 data_format: Optional[pulumi.Input[_builtins.str]] = None,
                 database_name: Optional[pulumi.Input[_builtins.str]] = None,
                 database_routing_type: Optional[pulumi.Input[_builtins.str]] = None,
                 eventgrid_event_subscription_id: Optional[pulumi.Input[_builtins.str]] = None,
                 eventgrid_resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 eventhub_consumer_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 eventhub_id: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 managed_identity_id: Optional[pulumi.Input[_builtins.str]] = None,
                 managed_identity_resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 mapping_rule_name: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 skip_first_record: Optional[pulumi.Input[_builtins.bool]] = None,
                 storage_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 table_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering EventGridDataConnection resources.
        :param pulumi.Input[_builtins.str] blob_storage_event_type: Specifies the blob storage event type that needs to be processed. Possible Values are `Microsoft.Storage.BlobCreated` and `Microsoft.Storage.BlobRenamed`. Defaults to `Microsoft.Storage.BlobCreated`.
        :param pulumi.Input[_builtins.str] cluster_name: Specifies the name of the Kusto Cluster this data connection will be added to. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] data_format: Specifies the data format of the EventHub messages. Allowed values: `APACHEAVRO`, `AVRO`, `CSV`, `JSON`, `MULTIJSON`, `ORC`, `PARQUET`, `PSV`, `RAW`, `SCSV`, `SINGLEJSON`, `SOHSV`, `TSV`, `TSVE`, `TXT` and `W3CLOGFILE`.
        :param pulumi.Input[_builtins.str] database_name: Specifies the name of the Kusto Database this data connection will be added to. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] database_routing_type: Indication for database routing information from the data connection, by default only database routing information is allowed. Allowed values: `Single`, `Multi`. Changing this forces a new resource to be created. Defaults to `Single`.
        :param pulumi.Input[_builtins.str] eventgrid_event_subscription_id: The resource ID of the event grid that is subscribed to the storage account events.
        :param pulumi.Input[_builtins.str] eventhub_consumer_group_name: Specifies the Event Hub consumer group this data connection will use for ingestion. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] eventhub_id: Specifies the resource id of the Event Hub this data connection will use for ingestion. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] location: The location where the Kusto Database should be created. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] managed_identity_id: Empty for non-managed identity based data connection. For system assigned identity, provide cluster resource Id. For user assigned identity (UAI) provide the UAI resource Id.
        :param pulumi.Input[_builtins.str] mapping_rule_name: Specifies the mapping rule used for the message ingestion. Mapping rule must exist before resource is created.
        :param pulumi.Input[_builtins.str] name: The name of the Kusto Event Grid Data Connection to create. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: Specifies the Resource Group where the Kusto Database should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] skip_first_record: is the first record of every file ignored? Defaults to `false`.
        :param pulumi.Input[_builtins.str] storage_account_id: Specifies the resource id of the Storage Account this data connection will use for ingestion. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] table_name: Specifies the target table name used for the message ingestion. Table must exist before resource is created.
        """
        if blob_storage_event_type is not None:
            pulumi.set(__self__, "blob_storage_event_type", blob_storage_event_type)
        if cluster_name is not None:
            pulumi.set(__self__, "cluster_name", cluster_name)
        if data_format is not None:
            pulumi.set(__self__, "data_format", data_format)
        if database_name is not None:
            pulumi.set(__self__, "database_name", database_name)
        if database_routing_type is not None:
            pulumi.set(__self__, "database_routing_type", database_routing_type)
        if eventgrid_event_subscription_id is not None:
            pulumi.set(__self__, "eventgrid_event_subscription_id", eventgrid_event_subscription_id)
        if eventgrid_resource_id is not None:
            warnings.warn("""`eventgrid_resource_id` has been deprecated in favour of the `eventgrid_event_subscription_id` property and will be removed in v5.0 of the AzureRM Provider.""", DeprecationWarning)
            pulumi.log.warn("""eventgrid_resource_id is deprecated: `eventgrid_resource_id` has been deprecated in favour of the `eventgrid_event_subscription_id` property and will be removed in v5.0 of the AzureRM Provider.""")
        if eventgrid_resource_id is not None:
            pulumi.set(__self__, "eventgrid_resource_id", eventgrid_resource_id)
        if eventhub_consumer_group_name is not None:
            pulumi.set(__self__, "eventhub_consumer_group_name", eventhub_consumer_group_name)
        if eventhub_id is not None:
            pulumi.set(__self__, "eventhub_id", eventhub_id)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if managed_identity_id is not None:
            pulumi.set(__self__, "managed_identity_id", managed_identity_id)
        if managed_identity_resource_id is not None:
            warnings.warn("""`managed_identity_resource_id` has been deprecated in favour of the `managed_identity_id` property and will be removed in v5.0 of the AzureRM Provider.""", DeprecationWarning)
            pulumi.log.warn("""managed_identity_resource_id is deprecated: `managed_identity_resource_id` has been deprecated in favour of the `managed_identity_id` property and will be removed in v5.0 of the AzureRM Provider.""")
        if managed_identity_resource_id is not None:
            pulumi.set(__self__, "managed_identity_resource_id", managed_identity_resource_id)
        if mapping_rule_name is not None:
            pulumi.set(__self__, "mapping_rule_name", mapping_rule_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if skip_first_record is not None:
            pulumi.set(__self__, "skip_first_record", skip_first_record)
        if storage_account_id is not None:
            pulumi.set(__self__, "storage_account_id", storage_account_id)
        if table_name is not None:
            pulumi.set(__self__, "table_name", table_name)

    @_builtins.property
    @pulumi.getter(name="blobStorageEventType")
    def blob_storage_event_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the blob storage event type that needs to be processed. Possible Values are `Microsoft.Storage.BlobCreated` and `Microsoft.Storage.BlobRenamed`. Defaults to `Microsoft.Storage.BlobCreated`.
        """
        return pulumi.get(self, "blob_storage_event_type")

    @blob_storage_event_type.setter
    def blob_storage_event_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "blob_storage_event_type", value)

    @_builtins.property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the Kusto Cluster this data connection will be added to. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "cluster_name")

    @cluster_name.setter
    def cluster_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_name", value)

    @_builtins.property
    @pulumi.getter(name="dataFormat")
    def data_format(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the data format of the EventHub messages. Allowed values: `APACHEAVRO`, `AVRO`, `CSV`, `JSON`, `MULTIJSON`, `ORC`, `PARQUET`, `PSV`, `RAW`, `SCSV`, `SINGLEJSON`, `SOHSV`, `TSV`, `TSVE`, `TXT` and `W3CLOGFILE`.
        """
        return pulumi.get(self, "data_format")

    @data_format.setter
    def data_format(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "data_format", value)

    @_builtins.property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the Kusto Database this data connection will be added to. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "database_name")

    @database_name.setter
    def database_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "database_name", value)

    @_builtins.property
    @pulumi.getter(name="databaseRoutingType")
    def database_routing_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indication for database routing information from the data connection, by default only database routing information is allowed. Allowed values: `Single`, `Multi`. Changing this forces a new resource to be created. Defaults to `Single`.
        """
        return pulumi.get(self, "database_routing_type")

    @database_routing_type.setter
    def database_routing_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "database_routing_type", value)

    @_builtins.property
    @pulumi.getter(name="eventgridEventSubscriptionId")
    def eventgrid_event_subscription_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource ID of the event grid that is subscribed to the storage account events.
        """
        return pulumi.get(self, "eventgrid_event_subscription_id")

    @eventgrid_event_subscription_id.setter
    def eventgrid_event_subscription_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "eventgrid_event_subscription_id", value)

    @_builtins.property
    @pulumi.getter(name="eventgridResourceId")
    @_utilities.deprecated("""`eventgrid_resource_id` has been deprecated in favour of the `eventgrid_event_subscription_id` property and will be removed in v5.0 of the AzureRM Provider.""")
    def eventgrid_resource_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "eventgrid_resource_id")

    @eventgrid_resource_id.setter
    def eventgrid_resource_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "eventgrid_resource_id", value)

    @_builtins.property
    @pulumi.getter(name="eventhubConsumerGroupName")
    def eventhub_consumer_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the Event Hub consumer group this data connection will use for ingestion. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "eventhub_consumer_group_name")

    @eventhub_consumer_group_name.setter
    def eventhub_consumer_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "eventhub_consumer_group_name", value)

    @_builtins.property
    @pulumi.getter(name="eventhubId")
    def eventhub_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the resource id of the Event Hub this data connection will use for ingestion. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "eventhub_id")

    @eventhub_id.setter
    def eventhub_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "eventhub_id", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The location where the Kusto Database should be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="managedIdentityId")
    def managed_identity_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Empty for non-managed identity based data connection. For system assigned identity, provide cluster resource Id. For user assigned identity (UAI) provide the UAI resource Id.
        """
        return pulumi.get(self, "managed_identity_id")

    @managed_identity_id.setter
    def managed_identity_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "managed_identity_id", value)

    @_builtins.property
    @pulumi.getter(name="managedIdentityResourceId")
    @_utilities.deprecated("""`managed_identity_resource_id` has been deprecated in favour of the `managed_identity_id` property and will be removed in v5.0 of the AzureRM Provider.""")
    def managed_identity_resource_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "managed_identity_resource_id")

    @managed_identity_resource_id.setter
    def managed_identity_resource_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "managed_identity_resource_id", value)

    @_builtins.property
    @pulumi.getter(name="mappingRuleName")
    def mapping_rule_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the mapping rule used for the message ingestion. Mapping rule must exist before resource is created.
        """
        return pulumi.get(self, "mapping_rule_name")

    @mapping_rule_name.setter
    def mapping_rule_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mapping_rule_name", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Kusto Event Grid Data Connection to create. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the Resource Group where the Kusto Database should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="skipFirstRecord")
    def skip_first_record(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        is the first record of every file ignored? Defaults to `false`.
        """
        return pulumi.get(self, "skip_first_record")

    @skip_first_record.setter
    def skip_first_record(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "skip_first_record", value)

    @_builtins.property
    @pulumi.getter(name="storageAccountId")
    def storage_account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the resource id of the Storage Account this data connection will use for ingestion. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "storage_account_id")

    @storage_account_id.setter
    def storage_account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_account_id", value)

    @_builtins.property
    @pulumi.getter(name="tableName")
    def table_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the target table name used for the message ingestion. Table must exist before resource is created.
        """
        return pulumi.get(self, "table_name")

    @table_name.setter
    def table_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "table_name", value)


@pulumi.type_token("azure:kusto/eventGridDataConnection:EventGridDataConnection")
class EventGridDataConnection(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 blob_storage_event_type: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_name: Optional[pulumi.Input[_builtins.str]] = None,
                 data_format: Optional[pulumi.Input[_builtins.str]] = None,
                 database_name: Optional[pulumi.Input[_builtins.str]] = None,
                 database_routing_type: Optional[pulumi.Input[_builtins.str]] = None,
                 eventgrid_event_subscription_id: Optional[pulumi.Input[_builtins.str]] = None,
                 eventgrid_resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 eventhub_consumer_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 eventhub_id: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 managed_identity_id: Optional[pulumi.Input[_builtins.str]] = None,
                 managed_identity_resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 mapping_rule_name: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 skip_first_record: Optional[pulumi.Input[_builtins.bool]] = None,
                 storage_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 table_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a Kusto (also known as Azure Data Explorer) Event Grid Data Connection

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_cluster = azure.kusto.Cluster("example",
            name="examplekustocluster",
            location=example.location,
            resource_group_name=example.name,
            sku={
                "name": "Standard_D13_v2",
                "capacity": 2,
            })
        example_database = azure.kusto.Database("example",
            name="example-kusto-database",
            resource_group_name=example.name,
            location=example.location,
            cluster_name=example_cluster.name,
            hot_cache_period="P7D",
            soft_delete_period="P31D")
        example_account = azure.storage.Account("example",
            name="storageaccountname",
            resource_group_name=example.name,
            location=example.location,
            account_tier="Standard",
            account_replication_type="GRS")
        example_event_hub_namespace = azure.eventhub.EventHubNamespace("example",
            name="eventhubnamespace-example",
            location=example.location,
            resource_group_name=example.name,
            sku="Standard")
        example_event_hub = azure.eventhub.EventHub("example",
            name="eventhub-example",
            namespace_name=example_event_hub_namespace.name,
            resource_group_name=example.name,
            partition_count=1,
            message_retention=1)
        example_consumer_group = azure.eventhub.ConsumerGroup("example",
            name="consumergroup-example",
            namespace_name=example_event_hub_namespace.name,
            eventhub_name=example_event_hub.name,
            resource_group_name=example.name)
        example_event_subscription = azure.eventgrid.EventSubscription("example",
            name="eventgrid-example",
            scope=example_account.id,
            eventhub_endpoint_id=example_event_hub.id,
            event_delivery_schema="EventGridSchema",
            included_event_types=[
                "Microsoft.Storage.BlobCreated",
                "Microsoft.Storage.BlobRenamed",
            ],
            retry_policy={
                "event_time_to_live": 144,
                "max_delivery_attempts": 10,
            })
        example_event_grid_data_connection = azure.kusto.EventGridDataConnection("example",
            name="my-kusto-eventgrid-data-connection",
            resource_group_name=example.name,
            location=example.location,
            cluster_name=example_cluster.name,
            database_name=example_database.name,
            storage_account_id=example_account.id,
            eventhub_id=example_event_hub.id,
            eventhub_consumer_group_name=example_consumer_group.name,
            table_name="my-table",
            mapping_rule_name="my-table-mapping",
            data_format="JSON",
            opts = pulumi.ResourceOptions(depends_on=[example_event_subscription]))
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Kusto`: 2024-04-13

        ## Import

        Kusto Event Grid Data Connections can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:kusto/eventGridDataConnection:EventGridDataConnection example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.Kusto/clusters/cluster1/databases/database1/dataConnections/dataConnection1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] blob_storage_event_type: Specifies the blob storage event type that needs to be processed. Possible Values are `Microsoft.Storage.BlobCreated` and `Microsoft.Storage.BlobRenamed`. Defaults to `Microsoft.Storage.BlobCreated`.
        :param pulumi.Input[_builtins.str] cluster_name: Specifies the name of the Kusto Cluster this data connection will be added to. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] data_format: Specifies the data format of the EventHub messages. Allowed values: `APACHEAVRO`, `AVRO`, `CSV`, `JSON`, `MULTIJSON`, `ORC`, `PARQUET`, `PSV`, `RAW`, `SCSV`, `SINGLEJSON`, `SOHSV`, `TSV`, `TSVE`, `TXT` and `W3CLOGFILE`.
        :param pulumi.Input[_builtins.str] database_name: Specifies the name of the Kusto Database this data connection will be added to. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] database_routing_type: Indication for database routing information from the data connection, by default only database routing information is allowed. Allowed values: `Single`, `Multi`. Changing this forces a new resource to be created. Defaults to `Single`.
        :param pulumi.Input[_builtins.str] eventgrid_event_subscription_id: The resource ID of the event grid that is subscribed to the storage account events.
        :param pulumi.Input[_builtins.str] eventhub_consumer_group_name: Specifies the Event Hub consumer group this data connection will use for ingestion. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] eventhub_id: Specifies the resource id of the Event Hub this data connection will use for ingestion. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] location: The location where the Kusto Database should be created. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] managed_identity_id: Empty for non-managed identity based data connection. For system assigned identity, provide cluster resource Id. For user assigned identity (UAI) provide the UAI resource Id.
        :param pulumi.Input[_builtins.str] mapping_rule_name: Specifies the mapping rule used for the message ingestion. Mapping rule must exist before resource is created.
        :param pulumi.Input[_builtins.str] name: The name of the Kusto Event Grid Data Connection to create. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: Specifies the Resource Group where the Kusto Database should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] skip_first_record: is the first record of every file ignored? Defaults to `false`.
        :param pulumi.Input[_builtins.str] storage_account_id: Specifies the resource id of the Storage Account this data connection will use for ingestion. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] table_name: Specifies the target table name used for the message ingestion. Table must exist before resource is created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EventGridDataConnectionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Kusto (also known as Azure Data Explorer) Event Grid Data Connection

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_cluster = azure.kusto.Cluster("example",
            name="examplekustocluster",
            location=example.location,
            resource_group_name=example.name,
            sku={
                "name": "Standard_D13_v2",
                "capacity": 2,
            })
        example_database = azure.kusto.Database("example",
            name="example-kusto-database",
            resource_group_name=example.name,
            location=example.location,
            cluster_name=example_cluster.name,
            hot_cache_period="P7D",
            soft_delete_period="P31D")
        example_account = azure.storage.Account("example",
            name="storageaccountname",
            resource_group_name=example.name,
            location=example.location,
            account_tier="Standard",
            account_replication_type="GRS")
        example_event_hub_namespace = azure.eventhub.EventHubNamespace("example",
            name="eventhubnamespace-example",
            location=example.location,
            resource_group_name=example.name,
            sku="Standard")
        example_event_hub = azure.eventhub.EventHub("example",
            name="eventhub-example",
            namespace_name=example_event_hub_namespace.name,
            resource_group_name=example.name,
            partition_count=1,
            message_retention=1)
        example_consumer_group = azure.eventhub.ConsumerGroup("example",
            name="consumergroup-example",
            namespace_name=example_event_hub_namespace.name,
            eventhub_name=example_event_hub.name,
            resource_group_name=example.name)
        example_event_subscription = azure.eventgrid.EventSubscription("example",
            name="eventgrid-example",
            scope=example_account.id,
            eventhub_endpoint_id=example_event_hub.id,
            event_delivery_schema="EventGridSchema",
            included_event_types=[
                "Microsoft.Storage.BlobCreated",
                "Microsoft.Storage.BlobRenamed",
            ],
            retry_policy={
                "event_time_to_live": 144,
                "max_delivery_attempts": 10,
            })
        example_event_grid_data_connection = azure.kusto.EventGridDataConnection("example",
            name="my-kusto-eventgrid-data-connection",
            resource_group_name=example.name,
            location=example.location,
            cluster_name=example_cluster.name,
            database_name=example_database.name,
            storage_account_id=example_account.id,
            eventhub_id=example_event_hub.id,
            eventhub_consumer_group_name=example_consumer_group.name,
            table_name="my-table",
            mapping_rule_name="my-table-mapping",
            data_format="JSON",
            opts = pulumi.ResourceOptions(depends_on=[example_event_subscription]))
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Kusto`: 2024-04-13

        ## Import

        Kusto Event Grid Data Connections can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:kusto/eventGridDataConnection:EventGridDataConnection example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.Kusto/clusters/cluster1/databases/database1/dataConnections/dataConnection1
        ```

        :param str resource_name: The name of the resource.
        :param EventGridDataConnectionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EventGridDataConnectionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 blob_storage_event_type: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_name: Optional[pulumi.Input[_builtins.str]] = None,
                 data_format: Optional[pulumi.Input[_builtins.str]] = None,
                 database_name: Optional[pulumi.Input[_builtins.str]] = None,
                 database_routing_type: Optional[pulumi.Input[_builtins.str]] = None,
                 eventgrid_event_subscription_id: Optional[pulumi.Input[_builtins.str]] = None,
                 eventgrid_resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 eventhub_consumer_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 eventhub_id: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 managed_identity_id: Optional[pulumi.Input[_builtins.str]] = None,
                 managed_identity_resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 mapping_rule_name: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 skip_first_record: Optional[pulumi.Input[_builtins.bool]] = None,
                 storage_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 table_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EventGridDataConnectionArgs.__new__(EventGridDataConnectionArgs)

            __props__.__dict__["blob_storage_event_type"] = blob_storage_event_type
            if cluster_name is None and not opts.urn:
                raise TypeError("Missing required property 'cluster_name'")
            __props__.__dict__["cluster_name"] = cluster_name
            __props__.__dict__["data_format"] = data_format
            if database_name is None and not opts.urn:
                raise TypeError("Missing required property 'database_name'")
            __props__.__dict__["database_name"] = database_name
            __props__.__dict__["database_routing_type"] = database_routing_type
            __props__.__dict__["eventgrid_event_subscription_id"] = eventgrid_event_subscription_id
            __props__.__dict__["eventgrid_resource_id"] = eventgrid_resource_id
            if eventhub_consumer_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'eventhub_consumer_group_name'")
            __props__.__dict__["eventhub_consumer_group_name"] = eventhub_consumer_group_name
            if eventhub_id is None and not opts.urn:
                raise TypeError("Missing required property 'eventhub_id'")
            __props__.__dict__["eventhub_id"] = eventhub_id
            __props__.__dict__["location"] = location
            __props__.__dict__["managed_identity_id"] = managed_identity_id
            __props__.__dict__["managed_identity_resource_id"] = managed_identity_resource_id
            __props__.__dict__["mapping_rule_name"] = mapping_rule_name
            __props__.__dict__["name"] = name
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["skip_first_record"] = skip_first_record
            if storage_account_id is None and not opts.urn:
                raise TypeError("Missing required property 'storage_account_id'")
            __props__.__dict__["storage_account_id"] = storage_account_id
            __props__.__dict__["table_name"] = table_name
        super(EventGridDataConnection, __self__).__init__(
            'azure:kusto/eventGridDataConnection:EventGridDataConnection',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            blob_storage_event_type: Optional[pulumi.Input[_builtins.str]] = None,
            cluster_name: Optional[pulumi.Input[_builtins.str]] = None,
            data_format: Optional[pulumi.Input[_builtins.str]] = None,
            database_name: Optional[pulumi.Input[_builtins.str]] = None,
            database_routing_type: Optional[pulumi.Input[_builtins.str]] = None,
            eventgrid_event_subscription_id: Optional[pulumi.Input[_builtins.str]] = None,
            eventgrid_resource_id: Optional[pulumi.Input[_builtins.str]] = None,
            eventhub_consumer_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            eventhub_id: Optional[pulumi.Input[_builtins.str]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            managed_identity_id: Optional[pulumi.Input[_builtins.str]] = None,
            managed_identity_resource_id: Optional[pulumi.Input[_builtins.str]] = None,
            mapping_rule_name: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            skip_first_record: Optional[pulumi.Input[_builtins.bool]] = None,
            storage_account_id: Optional[pulumi.Input[_builtins.str]] = None,
            table_name: Optional[pulumi.Input[_builtins.str]] = None) -> 'EventGridDataConnection':
        """
        Get an existing EventGridDataConnection resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] blob_storage_event_type: Specifies the blob storage event type that needs to be processed. Possible Values are `Microsoft.Storage.BlobCreated` and `Microsoft.Storage.BlobRenamed`. Defaults to `Microsoft.Storage.BlobCreated`.
        :param pulumi.Input[_builtins.str] cluster_name: Specifies the name of the Kusto Cluster this data connection will be added to. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] data_format: Specifies the data format of the EventHub messages. Allowed values: `APACHEAVRO`, `AVRO`, `CSV`, `JSON`, `MULTIJSON`, `ORC`, `PARQUET`, `PSV`, `RAW`, `SCSV`, `SINGLEJSON`, `SOHSV`, `TSV`, `TSVE`, `TXT` and `W3CLOGFILE`.
        :param pulumi.Input[_builtins.str] database_name: Specifies the name of the Kusto Database this data connection will be added to. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] database_routing_type: Indication for database routing information from the data connection, by default only database routing information is allowed. Allowed values: `Single`, `Multi`. Changing this forces a new resource to be created. Defaults to `Single`.
        :param pulumi.Input[_builtins.str] eventgrid_event_subscription_id: The resource ID of the event grid that is subscribed to the storage account events.
        :param pulumi.Input[_builtins.str] eventhub_consumer_group_name: Specifies the Event Hub consumer group this data connection will use for ingestion. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] eventhub_id: Specifies the resource id of the Event Hub this data connection will use for ingestion. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] location: The location where the Kusto Database should be created. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] managed_identity_id: Empty for non-managed identity based data connection. For system assigned identity, provide cluster resource Id. For user assigned identity (UAI) provide the UAI resource Id.
        :param pulumi.Input[_builtins.str] mapping_rule_name: Specifies the mapping rule used for the message ingestion. Mapping rule must exist before resource is created.
        :param pulumi.Input[_builtins.str] name: The name of the Kusto Event Grid Data Connection to create. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: Specifies the Resource Group where the Kusto Database should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] skip_first_record: is the first record of every file ignored? Defaults to `false`.
        :param pulumi.Input[_builtins.str] storage_account_id: Specifies the resource id of the Storage Account this data connection will use for ingestion. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] table_name: Specifies the target table name used for the message ingestion. Table must exist before resource is created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EventGridDataConnectionState.__new__(_EventGridDataConnectionState)

        __props__.__dict__["blob_storage_event_type"] = blob_storage_event_type
        __props__.__dict__["cluster_name"] = cluster_name
        __props__.__dict__["data_format"] = data_format
        __props__.__dict__["database_name"] = database_name
        __props__.__dict__["database_routing_type"] = database_routing_type
        __props__.__dict__["eventgrid_event_subscription_id"] = eventgrid_event_subscription_id
        __props__.__dict__["eventgrid_resource_id"] = eventgrid_resource_id
        __props__.__dict__["eventhub_consumer_group_name"] = eventhub_consumer_group_name
        __props__.__dict__["eventhub_id"] = eventhub_id
        __props__.__dict__["location"] = location
        __props__.__dict__["managed_identity_id"] = managed_identity_id
        __props__.__dict__["managed_identity_resource_id"] = managed_identity_resource_id
        __props__.__dict__["mapping_rule_name"] = mapping_rule_name
        __props__.__dict__["name"] = name
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["skip_first_record"] = skip_first_record
        __props__.__dict__["storage_account_id"] = storage_account_id
        __props__.__dict__["table_name"] = table_name
        return EventGridDataConnection(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="blobStorageEventType")
    def blob_storage_event_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the blob storage event type that needs to be processed. Possible Values are `Microsoft.Storage.BlobCreated` and `Microsoft.Storage.BlobRenamed`. Defaults to `Microsoft.Storage.BlobCreated`.
        """
        return pulumi.get(self, "blob_storage_event_type")

    @_builtins.property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of the Kusto Cluster this data connection will be added to. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "cluster_name")

    @_builtins.property
    @pulumi.getter(name="dataFormat")
    def data_format(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the data format of the EventHub messages. Allowed values: `APACHEAVRO`, `AVRO`, `CSV`, `JSON`, `MULTIJSON`, `ORC`, `PARQUET`, `PSV`, `RAW`, `SCSV`, `SINGLEJSON`, `SOHSV`, `TSV`, `TSVE`, `TXT` and `W3CLOGFILE`.
        """
        return pulumi.get(self, "data_format")

    @_builtins.property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of the Kusto Database this data connection will be added to. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "database_name")

    @_builtins.property
    @pulumi.getter(name="databaseRoutingType")
    def database_routing_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Indication for database routing information from the data connection, by default only database routing information is allowed. Allowed values: `Single`, `Multi`. Changing this forces a new resource to be created. Defaults to `Single`.
        """
        return pulumi.get(self, "database_routing_type")

    @_builtins.property
    @pulumi.getter(name="eventgridEventSubscriptionId")
    def eventgrid_event_subscription_id(self) -> pulumi.Output[_builtins.str]:
        """
        The resource ID of the event grid that is subscribed to the storage account events.
        """
        return pulumi.get(self, "eventgrid_event_subscription_id")

    @_builtins.property
    @pulumi.getter(name="eventgridResourceId")
    @_utilities.deprecated("""`eventgrid_resource_id` has been deprecated in favour of the `eventgrid_event_subscription_id` property and will be removed in v5.0 of the AzureRM Provider.""")
    def eventgrid_resource_id(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "eventgrid_resource_id")

    @_builtins.property
    @pulumi.getter(name="eventhubConsumerGroupName")
    def eventhub_consumer_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the Event Hub consumer group this data connection will use for ingestion. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "eventhub_consumer_group_name")

    @_builtins.property
    @pulumi.getter(name="eventhubId")
    def eventhub_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the resource id of the Event Hub this data connection will use for ingestion. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "eventhub_id")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        The location where the Kusto Database should be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter(name="managedIdentityId")
    def managed_identity_id(self) -> pulumi.Output[_builtins.str]:
        """
        Empty for non-managed identity based data connection. For system assigned identity, provide cluster resource Id. For user assigned identity (UAI) provide the UAI resource Id.
        """
        return pulumi.get(self, "managed_identity_id")

    @_builtins.property
    @pulumi.getter(name="managedIdentityResourceId")
    @_utilities.deprecated("""`managed_identity_resource_id` has been deprecated in favour of the `managed_identity_id` property and will be removed in v5.0 of the AzureRM Provider.""")
    def managed_identity_resource_id(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "managed_identity_resource_id")

    @_builtins.property
    @pulumi.getter(name="mappingRuleName")
    def mapping_rule_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the mapping rule used for the message ingestion. Mapping rule must exist before resource is created.
        """
        return pulumi.get(self, "mapping_rule_name")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Kusto Event Grid Data Connection to create. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the Resource Group where the Kusto Database should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter(name="skipFirstRecord")
    def skip_first_record(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        is the first record of every file ignored? Defaults to `false`.
        """
        return pulumi.get(self, "skip_first_record")

    @_builtins.property
    @pulumi.getter(name="storageAccountId")
    def storage_account_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the resource id of the Storage Account this data connection will use for ingestion. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "storage_account_id")

    @_builtins.property
    @pulumi.getter(name="tableName")
    def table_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the target table name used for the message ingestion. Table must exist before resource is created.
        """
        return pulumi.get(self, "table_name")

