# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ScriptArgs', 'Script']

@pulumi.input_type
class ScriptArgs:
    def __init__(__self__, *,
                 database_id: pulumi.Input[_builtins.str],
                 continue_on_errors_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 force_an_update_when_value_changed: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 sas_token: Optional[pulumi.Input[_builtins.str]] = None,
                 script_content: Optional[pulumi.Input[_builtins.str]] = None,
                 url: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Script resource.
        :param pulumi.Input[_builtins.str] database_id: The ID of the Kusto Database. Changing this forces a new Kusto Script to be created.
        :param pulumi.Input[_builtins.bool] continue_on_errors_enabled: Flag that indicates whether to continue if one of the command fails.
        :param pulumi.Input[_builtins.str] force_an_update_when_value_changed: A unique string. If changed the script will be applied again.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Kusto Script. Changing this forces a new Kusto Script to be created.
        :param pulumi.Input[_builtins.str] sas_token: The SAS token used to access the script. Must be provided when using scriptUrl property. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] script_content: The script content. This property should be used when the script is provide inline and not through file in a SA. Must not be used together with `url` and `sas_token` properties. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] url: The url to the KQL script blob file. Must not be used together with scriptContent property. Please reference [this documentation](https://docs.microsoft.com/azure/data-explorer/database-script) that describes the commands that are allowed in the script.
        """
        pulumi.set(__self__, "database_id", database_id)
        if continue_on_errors_enabled is not None:
            pulumi.set(__self__, "continue_on_errors_enabled", continue_on_errors_enabled)
        if force_an_update_when_value_changed is not None:
            pulumi.set(__self__, "force_an_update_when_value_changed", force_an_update_when_value_changed)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if sas_token is not None:
            pulumi.set(__self__, "sas_token", sas_token)
        if script_content is not None:
            pulumi.set(__self__, "script_content", script_content)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @_builtins.property
    @pulumi.getter(name="databaseId")
    def database_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Kusto Database. Changing this forces a new Kusto Script to be created.
        """
        return pulumi.get(self, "database_id")

    @database_id.setter
    def database_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "database_id", value)

    @_builtins.property
    @pulumi.getter(name="continueOnErrorsEnabled")
    def continue_on_errors_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Flag that indicates whether to continue if one of the command fails.
        """
        return pulumi.get(self, "continue_on_errors_enabled")

    @continue_on_errors_enabled.setter
    def continue_on_errors_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "continue_on_errors_enabled", value)

    @_builtins.property
    @pulumi.getter(name="forceAnUpdateWhenValueChanged")
    def force_an_update_when_value_changed(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A unique string. If changed the script will be applied again.
        """
        return pulumi.get(self, "force_an_update_when_value_changed")

    @force_an_update_when_value_changed.setter
    def force_an_update_when_value_changed(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "force_an_update_when_value_changed", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Kusto Script. Changing this forces a new Kusto Script to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="sasToken")
    def sas_token(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The SAS token used to access the script. Must be provided when using scriptUrl property. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "sas_token")

    @sas_token.setter
    def sas_token(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sas_token", value)

    @_builtins.property
    @pulumi.getter(name="scriptContent")
    def script_content(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The script content. This property should be used when the script is provide inline and not through file in a SA. Must not be used together with `url` and `sas_token` properties. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "script_content")

    @script_content.setter
    def script_content(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "script_content", value)

    @_builtins.property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The url to the KQL script blob file. Must not be used together with scriptContent property. Please reference [this documentation](https://docs.microsoft.com/azure/data-explorer/database-script) that describes the commands that are allowed in the script.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "url", value)


@pulumi.input_type
class _ScriptState:
    def __init__(__self__, *,
                 continue_on_errors_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 database_id: Optional[pulumi.Input[_builtins.str]] = None,
                 force_an_update_when_value_changed: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 sas_token: Optional[pulumi.Input[_builtins.str]] = None,
                 script_content: Optional[pulumi.Input[_builtins.str]] = None,
                 url: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Script resources.
        :param pulumi.Input[_builtins.bool] continue_on_errors_enabled: Flag that indicates whether to continue if one of the command fails.
        :param pulumi.Input[_builtins.str] database_id: The ID of the Kusto Database. Changing this forces a new Kusto Script to be created.
        :param pulumi.Input[_builtins.str] force_an_update_when_value_changed: A unique string. If changed the script will be applied again.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Kusto Script. Changing this forces a new Kusto Script to be created.
        :param pulumi.Input[_builtins.str] sas_token: The SAS token used to access the script. Must be provided when using scriptUrl property. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] script_content: The script content. This property should be used when the script is provide inline and not through file in a SA. Must not be used together with `url` and `sas_token` properties. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] url: The url to the KQL script blob file. Must not be used together with scriptContent property. Please reference [this documentation](https://docs.microsoft.com/azure/data-explorer/database-script) that describes the commands that are allowed in the script.
        """
        if continue_on_errors_enabled is not None:
            pulumi.set(__self__, "continue_on_errors_enabled", continue_on_errors_enabled)
        if database_id is not None:
            pulumi.set(__self__, "database_id", database_id)
        if force_an_update_when_value_changed is not None:
            pulumi.set(__self__, "force_an_update_when_value_changed", force_an_update_when_value_changed)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if sas_token is not None:
            pulumi.set(__self__, "sas_token", sas_token)
        if script_content is not None:
            pulumi.set(__self__, "script_content", script_content)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @_builtins.property
    @pulumi.getter(name="continueOnErrorsEnabled")
    def continue_on_errors_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Flag that indicates whether to continue if one of the command fails.
        """
        return pulumi.get(self, "continue_on_errors_enabled")

    @continue_on_errors_enabled.setter
    def continue_on_errors_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "continue_on_errors_enabled", value)

    @_builtins.property
    @pulumi.getter(name="databaseId")
    def database_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Kusto Database. Changing this forces a new Kusto Script to be created.
        """
        return pulumi.get(self, "database_id")

    @database_id.setter
    def database_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "database_id", value)

    @_builtins.property
    @pulumi.getter(name="forceAnUpdateWhenValueChanged")
    def force_an_update_when_value_changed(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A unique string. If changed the script will be applied again.
        """
        return pulumi.get(self, "force_an_update_when_value_changed")

    @force_an_update_when_value_changed.setter
    def force_an_update_when_value_changed(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "force_an_update_when_value_changed", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Kusto Script. Changing this forces a new Kusto Script to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="sasToken")
    def sas_token(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The SAS token used to access the script. Must be provided when using scriptUrl property. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "sas_token")

    @sas_token.setter
    def sas_token(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sas_token", value)

    @_builtins.property
    @pulumi.getter(name="scriptContent")
    def script_content(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The script content. This property should be used when the script is provide inline and not through file in a SA. Must not be used together with `url` and `sas_token` properties. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "script_content")

    @script_content.setter
    def script_content(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "script_content", value)

    @_builtins.property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The url to the KQL script blob file. Must not be used together with scriptContent property. Please reference [this documentation](https://docs.microsoft.com/azure/data-explorer/database-script) that describes the commands that are allowed in the script.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "url", value)


@pulumi.type_token("azure:kusto/script:Script")
class Script(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 continue_on_errors_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 database_id: Optional[pulumi.Input[_builtins.str]] = None,
                 force_an_update_when_value_changed: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 sas_token: Optional[pulumi.Input[_builtins.str]] = None,
                 script_content: Optional[pulumi.Input[_builtins.str]] = None,
                 url: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a Kusto Script.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example_resource_group = azure.core.ResourceGroup("example",
            name="example",
            location="West Europe")
        example_cluster = azure.kusto.Cluster("example",
            name="example",
            location=example_resource_group.location,
            resource_group_name=example_resource_group.name,
            sku={
                "name": "Dev(No SLA)_Standard_D11_v2",
                "capacity": 1,
            })
        example_database = azure.kusto.Database("example",
            name="example",
            resource_group_name=example_resource_group.name,
            location=example_resource_group.location,
            cluster_name=example_cluster.name)
        example_account = azure.storage.Account("example",
            name="example",
            resource_group_name=example_resource_group.name,
            location=example_resource_group.location,
            account_tier="Standard",
            account_replication_type="LRS")
        example_container = azure.storage.Container("example",
            name="setup-files",
            storage_account_name=example_account.name,
            container_access_type="private")
        example_blob = azure.storage.Blob("example",
            name="script.txt",
            storage_account_name=example_account.name,
            storage_container_name=example_container.name,
            type="Block",
            source_content=".create table MyTable (Level:string, Timestamp:datetime, UserId:string, TraceId:string, Message:string, ProcessId:int32)")
        example = azure.storage.get_account_blob_container_sas_output(connection_string=example_account.primary_connection_string,
            container_name=example_container.name,
            https_only=True,
            start="2017-03-21",
            expiry="2022-03-21",
            permissions={
                "read": True,
                "add": False,
                "create": False,
                "write": True,
                "delete": False,
                "list": True,
            })
        example_script = azure.kusto.Script("example",
            name="example",
            database_id=example_database.id,
            url=example_blob.id,
            sas_token=example.sas,
            continue_on_errors_enabled=True,
            force_an_update_when_value_changed="first")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Kusto`: 2024-04-13

        ## Import

        Kusto Scripts can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:kusto/script:Script example /subscriptions/12345678-1234-9876-4563-123456789012/resourceGroups/resGroup1/providers/Microsoft.Kusto/clusters/cluster1/databases/database1/scripts/script1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] continue_on_errors_enabled: Flag that indicates whether to continue if one of the command fails.
        :param pulumi.Input[_builtins.str] database_id: The ID of the Kusto Database. Changing this forces a new Kusto Script to be created.
        :param pulumi.Input[_builtins.str] force_an_update_when_value_changed: A unique string. If changed the script will be applied again.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Kusto Script. Changing this forces a new Kusto Script to be created.
        :param pulumi.Input[_builtins.str] sas_token: The SAS token used to access the script. Must be provided when using scriptUrl property. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] script_content: The script content. This property should be used when the script is provide inline and not through file in a SA. Must not be used together with `url` and `sas_token` properties. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] url: The url to the KQL script blob file. Must not be used together with scriptContent property. Please reference [this documentation](https://docs.microsoft.com/azure/data-explorer/database-script) that describes the commands that are allowed in the script.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ScriptArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Kusto Script.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example_resource_group = azure.core.ResourceGroup("example",
            name="example",
            location="West Europe")
        example_cluster = azure.kusto.Cluster("example",
            name="example",
            location=example_resource_group.location,
            resource_group_name=example_resource_group.name,
            sku={
                "name": "Dev(No SLA)_Standard_D11_v2",
                "capacity": 1,
            })
        example_database = azure.kusto.Database("example",
            name="example",
            resource_group_name=example_resource_group.name,
            location=example_resource_group.location,
            cluster_name=example_cluster.name)
        example_account = azure.storage.Account("example",
            name="example",
            resource_group_name=example_resource_group.name,
            location=example_resource_group.location,
            account_tier="Standard",
            account_replication_type="LRS")
        example_container = azure.storage.Container("example",
            name="setup-files",
            storage_account_name=example_account.name,
            container_access_type="private")
        example_blob = azure.storage.Blob("example",
            name="script.txt",
            storage_account_name=example_account.name,
            storage_container_name=example_container.name,
            type="Block",
            source_content=".create table MyTable (Level:string, Timestamp:datetime, UserId:string, TraceId:string, Message:string, ProcessId:int32)")
        example = azure.storage.get_account_blob_container_sas_output(connection_string=example_account.primary_connection_string,
            container_name=example_container.name,
            https_only=True,
            start="2017-03-21",
            expiry="2022-03-21",
            permissions={
                "read": True,
                "add": False,
                "create": False,
                "write": True,
                "delete": False,
                "list": True,
            })
        example_script = azure.kusto.Script("example",
            name="example",
            database_id=example_database.id,
            url=example_blob.id,
            sas_token=example.sas,
            continue_on_errors_enabled=True,
            force_an_update_when_value_changed="first")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Kusto`: 2024-04-13

        ## Import

        Kusto Scripts can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:kusto/script:Script example /subscriptions/12345678-1234-9876-4563-123456789012/resourceGroups/resGroup1/providers/Microsoft.Kusto/clusters/cluster1/databases/database1/scripts/script1
        ```

        :param str resource_name: The name of the resource.
        :param ScriptArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ScriptArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 continue_on_errors_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 database_id: Optional[pulumi.Input[_builtins.str]] = None,
                 force_an_update_when_value_changed: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 sas_token: Optional[pulumi.Input[_builtins.str]] = None,
                 script_content: Optional[pulumi.Input[_builtins.str]] = None,
                 url: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ScriptArgs.__new__(ScriptArgs)

            __props__.__dict__["continue_on_errors_enabled"] = continue_on_errors_enabled
            if database_id is None and not opts.urn:
                raise TypeError("Missing required property 'database_id'")
            __props__.__dict__["database_id"] = database_id
            __props__.__dict__["force_an_update_when_value_changed"] = force_an_update_when_value_changed
            __props__.__dict__["name"] = name
            __props__.__dict__["sas_token"] = None if sas_token is None else pulumi.Output.secret(sas_token)
            __props__.__dict__["script_content"] = None if script_content is None else pulumi.Output.secret(script_content)
            __props__.__dict__["url"] = url
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["sasToken", "scriptContent"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Script, __self__).__init__(
            'azure:kusto/script:Script',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            continue_on_errors_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            database_id: Optional[pulumi.Input[_builtins.str]] = None,
            force_an_update_when_value_changed: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            sas_token: Optional[pulumi.Input[_builtins.str]] = None,
            script_content: Optional[pulumi.Input[_builtins.str]] = None,
            url: Optional[pulumi.Input[_builtins.str]] = None) -> 'Script':
        """
        Get an existing Script resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] continue_on_errors_enabled: Flag that indicates whether to continue if one of the command fails.
        :param pulumi.Input[_builtins.str] database_id: The ID of the Kusto Database. Changing this forces a new Kusto Script to be created.
        :param pulumi.Input[_builtins.str] force_an_update_when_value_changed: A unique string. If changed the script will be applied again.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Kusto Script. Changing this forces a new Kusto Script to be created.
        :param pulumi.Input[_builtins.str] sas_token: The SAS token used to access the script. Must be provided when using scriptUrl property. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] script_content: The script content. This property should be used when the script is provide inline and not through file in a SA. Must not be used together with `url` and `sas_token` properties. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] url: The url to the KQL script blob file. Must not be used together with scriptContent property. Please reference [this documentation](https://docs.microsoft.com/azure/data-explorer/database-script) that describes the commands that are allowed in the script.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ScriptState.__new__(_ScriptState)

        __props__.__dict__["continue_on_errors_enabled"] = continue_on_errors_enabled
        __props__.__dict__["database_id"] = database_id
        __props__.__dict__["force_an_update_when_value_changed"] = force_an_update_when_value_changed
        __props__.__dict__["name"] = name
        __props__.__dict__["sas_token"] = sas_token
        __props__.__dict__["script_content"] = script_content
        __props__.__dict__["url"] = url
        return Script(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="continueOnErrorsEnabled")
    def continue_on_errors_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Flag that indicates whether to continue if one of the command fails.
        """
        return pulumi.get(self, "continue_on_errors_enabled")

    @_builtins.property
    @pulumi.getter(name="databaseId")
    def database_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Kusto Database. Changing this forces a new Kusto Script to be created.
        """
        return pulumi.get(self, "database_id")

    @_builtins.property
    @pulumi.getter(name="forceAnUpdateWhenValueChanged")
    def force_an_update_when_value_changed(self) -> pulumi.Output[_builtins.str]:
        """
        A unique string. If changed the script will be applied again.
        """
        return pulumi.get(self, "force_an_update_when_value_changed")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name which should be used for this Kusto Script. Changing this forces a new Kusto Script to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="sasToken")
    def sas_token(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The SAS token used to access the script. Must be provided when using scriptUrl property. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "sas_token")

    @_builtins.property
    @pulumi.getter(name="scriptContent")
    def script_content(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The script content. This property should be used when the script is provide inline and not through file in a SA. Must not be used together with `url` and `sas_token` properties. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "script_content")

    @_builtins.property
    @pulumi.getter
    def url(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The url to the KQL script blob file. Must not be used together with scriptContent property. Please reference [this documentation](https://docs.microsoft.com/azure/data-explorer/database-script) that describes the commands that are allowed in the script.
        """
        return pulumi.get(self, "url")

