# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['BackendAddressPoolArgs', 'BackendAddressPool']

@pulumi.input_type
class BackendAddressPoolArgs:
    def __init__(__self__, *,
                 loadbalancer_id: pulumi.Input[_builtins.str],
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 synchronous_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 tunnel_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input['BackendAddressPoolTunnelInterfaceArgs']]]] = None,
                 virtual_network_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a BackendAddressPool resource.
        :param pulumi.Input[_builtins.str] loadbalancer_id: The ID of the Load Balancer in which to create the Backend Address Pool. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Backend Address Pool. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] synchronous_mode: The backend address synchronous mode for the Backend Address Pool. Possible values are `Automatic` and `Manual`. This is required with `virtual_network_id`. Changing this forces a new resource to be created.
               
               > **Note:** The `synchronous_mode` can set only for Load Balancer with `Standard` SKU.
        :param pulumi.Input[Sequence[pulumi.Input['BackendAddressPoolTunnelInterfaceArgs']]] tunnel_interfaces: One or more `tunnel_interface` blocks as defined below.
        :param pulumi.Input[_builtins.str] virtual_network_id: The ID of the Virtual Network within which the Backend Address Pool should exist.
        """
        pulumi.set(__self__, "loadbalancer_id", loadbalancer_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if synchronous_mode is not None:
            pulumi.set(__self__, "synchronous_mode", synchronous_mode)
        if tunnel_interfaces is not None:
            pulumi.set(__self__, "tunnel_interfaces", tunnel_interfaces)
        if virtual_network_id is not None:
            pulumi.set(__self__, "virtual_network_id", virtual_network_id)

    @_builtins.property
    @pulumi.getter(name="loadbalancerId")
    def loadbalancer_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Load Balancer in which to create the Backend Address Pool. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "loadbalancer_id")

    @loadbalancer_id.setter
    def loadbalancer_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "loadbalancer_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the Backend Address Pool. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="synchronousMode")
    def synchronous_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The backend address synchronous mode for the Backend Address Pool. Possible values are `Automatic` and `Manual`. This is required with `virtual_network_id`. Changing this forces a new resource to be created.

        > **Note:** The `synchronous_mode` can set only for Load Balancer with `Standard` SKU.
        """
        return pulumi.get(self, "synchronous_mode")

    @synchronous_mode.setter
    def synchronous_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "synchronous_mode", value)

    @_builtins.property
    @pulumi.getter(name="tunnelInterfaces")
    def tunnel_interfaces(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BackendAddressPoolTunnelInterfaceArgs']]]]:
        """
        One or more `tunnel_interface` blocks as defined below.
        """
        return pulumi.get(self, "tunnel_interfaces")

    @tunnel_interfaces.setter
    def tunnel_interfaces(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BackendAddressPoolTunnelInterfaceArgs']]]]):
        pulumi.set(self, "tunnel_interfaces", value)

    @_builtins.property
    @pulumi.getter(name="virtualNetworkId")
    def virtual_network_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Virtual Network within which the Backend Address Pool should exist.
        """
        return pulumi.get(self, "virtual_network_id")

    @virtual_network_id.setter
    def virtual_network_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "virtual_network_id", value)


@pulumi.input_type
class _BackendAddressPoolState:
    def __init__(__self__, *,
                 backend_ip_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 inbound_nat_rules: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 load_balancing_rules: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 loadbalancer_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 outbound_rules: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 synchronous_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 tunnel_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input['BackendAddressPoolTunnelInterfaceArgs']]]] = None,
                 virtual_network_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering BackendAddressPool resources.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] backend_ip_configurations: The Backend IP Configurations associated with this Backend Address Pool.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] inbound_nat_rules: An array of the Load Balancing Inbound NAT Rules associated with this Backend Address Pool.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] load_balancing_rules: The Load Balancing Rules associated with this Backend Address Pool.
        :param pulumi.Input[_builtins.str] loadbalancer_id: The ID of the Load Balancer in which to create the Backend Address Pool. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Backend Address Pool. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] outbound_rules: An array of the Load Balancing Outbound Rules associated with this Backend Address Pool.
        :param pulumi.Input[_builtins.str] synchronous_mode: The backend address synchronous mode for the Backend Address Pool. Possible values are `Automatic` and `Manual`. This is required with `virtual_network_id`. Changing this forces a new resource to be created.
               
               > **Note:** The `synchronous_mode` can set only for Load Balancer with `Standard` SKU.
        :param pulumi.Input[Sequence[pulumi.Input['BackendAddressPoolTunnelInterfaceArgs']]] tunnel_interfaces: One or more `tunnel_interface` blocks as defined below.
        :param pulumi.Input[_builtins.str] virtual_network_id: The ID of the Virtual Network within which the Backend Address Pool should exist.
        """
        if backend_ip_configurations is not None:
            pulumi.set(__self__, "backend_ip_configurations", backend_ip_configurations)
        if inbound_nat_rules is not None:
            pulumi.set(__self__, "inbound_nat_rules", inbound_nat_rules)
        if load_balancing_rules is not None:
            pulumi.set(__self__, "load_balancing_rules", load_balancing_rules)
        if loadbalancer_id is not None:
            pulumi.set(__self__, "loadbalancer_id", loadbalancer_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if outbound_rules is not None:
            pulumi.set(__self__, "outbound_rules", outbound_rules)
        if synchronous_mode is not None:
            pulumi.set(__self__, "synchronous_mode", synchronous_mode)
        if tunnel_interfaces is not None:
            pulumi.set(__self__, "tunnel_interfaces", tunnel_interfaces)
        if virtual_network_id is not None:
            pulumi.set(__self__, "virtual_network_id", virtual_network_id)

    @_builtins.property
    @pulumi.getter(name="backendIpConfigurations")
    def backend_ip_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The Backend IP Configurations associated with this Backend Address Pool.
        """
        return pulumi.get(self, "backend_ip_configurations")

    @backend_ip_configurations.setter
    def backend_ip_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "backend_ip_configurations", value)

    @_builtins.property
    @pulumi.getter(name="inboundNatRules")
    def inbound_nat_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        An array of the Load Balancing Inbound NAT Rules associated with this Backend Address Pool.
        """
        return pulumi.get(self, "inbound_nat_rules")

    @inbound_nat_rules.setter
    def inbound_nat_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "inbound_nat_rules", value)

    @_builtins.property
    @pulumi.getter(name="loadBalancingRules")
    def load_balancing_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The Load Balancing Rules associated with this Backend Address Pool.
        """
        return pulumi.get(self, "load_balancing_rules")

    @load_balancing_rules.setter
    def load_balancing_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "load_balancing_rules", value)

    @_builtins.property
    @pulumi.getter(name="loadbalancerId")
    def loadbalancer_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Load Balancer in which to create the Backend Address Pool. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "loadbalancer_id")

    @loadbalancer_id.setter
    def loadbalancer_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "loadbalancer_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the Backend Address Pool. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="outboundRules")
    def outbound_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        An array of the Load Balancing Outbound Rules associated with this Backend Address Pool.
        """
        return pulumi.get(self, "outbound_rules")

    @outbound_rules.setter
    def outbound_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "outbound_rules", value)

    @_builtins.property
    @pulumi.getter(name="synchronousMode")
    def synchronous_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The backend address synchronous mode for the Backend Address Pool. Possible values are `Automatic` and `Manual`. This is required with `virtual_network_id`. Changing this forces a new resource to be created.

        > **Note:** The `synchronous_mode` can set only for Load Balancer with `Standard` SKU.
        """
        return pulumi.get(self, "synchronous_mode")

    @synchronous_mode.setter
    def synchronous_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "synchronous_mode", value)

    @_builtins.property
    @pulumi.getter(name="tunnelInterfaces")
    def tunnel_interfaces(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BackendAddressPoolTunnelInterfaceArgs']]]]:
        """
        One or more `tunnel_interface` blocks as defined below.
        """
        return pulumi.get(self, "tunnel_interfaces")

    @tunnel_interfaces.setter
    def tunnel_interfaces(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BackendAddressPoolTunnelInterfaceArgs']]]]):
        pulumi.set(self, "tunnel_interfaces", value)

    @_builtins.property
    @pulumi.getter(name="virtualNetworkId")
    def virtual_network_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Virtual Network within which the Backend Address Pool should exist.
        """
        return pulumi.get(self, "virtual_network_id")

    @virtual_network_id.setter
    def virtual_network_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "virtual_network_id", value)


@pulumi.type_token("azure:lb/backendAddressPool:BackendAddressPool")
class BackendAddressPool(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 loadbalancer_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 synchronous_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 tunnel_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input[Union['BackendAddressPoolTunnelInterfaceArgs', 'BackendAddressPoolTunnelInterfaceArgsDict']]]]] = None,
                 virtual_network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a Load Balancer Backend Address Pool.

        > **Note:** When using this resource, the Load Balancer needs to have a FrontEnd IP Configuration Attached

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="LoadBalancerRG",
            location="West Europe")
        example_public_ip = azure.network.PublicIp("example",
            name="PublicIPForLB",
            location=example.location,
            resource_group_name=example.name,
            allocation_method="Static")
        example_load_balancer = azure.lb.LoadBalancer("example",
            name="TestLoadBalancer",
            location=example.location,
            resource_group_name=example.name,
            frontend_ip_configurations=[{
                "name": "PublicIPAddress",
                "public_ip_address_id": example_public_ip.id,
            }])
        example_backend_address_pool = azure.lb.BackendAddressPool("example",
            loadbalancer_id=example_load_balancer.id,
            name="BackEndAddressPool")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Network`: 2023-09-01

        ## Import

        Load Balancer Backend Address Pools can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:lb/backendAddressPool:BackendAddressPool example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.Network/loadBalancers/lb1/backendAddressPools/pool1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] loadbalancer_id: The ID of the Load Balancer in which to create the Backend Address Pool. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Backend Address Pool. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] synchronous_mode: The backend address synchronous mode for the Backend Address Pool. Possible values are `Automatic` and `Manual`. This is required with `virtual_network_id`. Changing this forces a new resource to be created.
               
               > **Note:** The `synchronous_mode` can set only for Load Balancer with `Standard` SKU.
        :param pulumi.Input[Sequence[pulumi.Input[Union['BackendAddressPoolTunnelInterfaceArgs', 'BackendAddressPoolTunnelInterfaceArgsDict']]]] tunnel_interfaces: One or more `tunnel_interface` blocks as defined below.
        :param pulumi.Input[_builtins.str] virtual_network_id: The ID of the Virtual Network within which the Backend Address Pool should exist.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: BackendAddressPoolArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Load Balancer Backend Address Pool.

        > **Note:** When using this resource, the Load Balancer needs to have a FrontEnd IP Configuration Attached

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="LoadBalancerRG",
            location="West Europe")
        example_public_ip = azure.network.PublicIp("example",
            name="PublicIPForLB",
            location=example.location,
            resource_group_name=example.name,
            allocation_method="Static")
        example_load_balancer = azure.lb.LoadBalancer("example",
            name="TestLoadBalancer",
            location=example.location,
            resource_group_name=example.name,
            frontend_ip_configurations=[{
                "name": "PublicIPAddress",
                "public_ip_address_id": example_public_ip.id,
            }])
        example_backend_address_pool = azure.lb.BackendAddressPool("example",
            loadbalancer_id=example_load_balancer.id,
            name="BackEndAddressPool")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Network`: 2023-09-01

        ## Import

        Load Balancer Backend Address Pools can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:lb/backendAddressPool:BackendAddressPool example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.Network/loadBalancers/lb1/backendAddressPools/pool1
        ```

        :param str resource_name: The name of the resource.
        :param BackendAddressPoolArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BackendAddressPoolArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 loadbalancer_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 synchronous_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 tunnel_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input[Union['BackendAddressPoolTunnelInterfaceArgs', 'BackendAddressPoolTunnelInterfaceArgsDict']]]]] = None,
                 virtual_network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BackendAddressPoolArgs.__new__(BackendAddressPoolArgs)

            if loadbalancer_id is None and not opts.urn:
                raise TypeError("Missing required property 'loadbalancer_id'")
            __props__.__dict__["loadbalancer_id"] = loadbalancer_id
            __props__.__dict__["name"] = name
            __props__.__dict__["synchronous_mode"] = synchronous_mode
            __props__.__dict__["tunnel_interfaces"] = tunnel_interfaces
            __props__.__dict__["virtual_network_id"] = virtual_network_id
            __props__.__dict__["backend_ip_configurations"] = None
            __props__.__dict__["inbound_nat_rules"] = None
            __props__.__dict__["load_balancing_rules"] = None
            __props__.__dict__["outbound_rules"] = None
        super(BackendAddressPool, __self__).__init__(
            'azure:lb/backendAddressPool:BackendAddressPool',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            backend_ip_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            inbound_nat_rules: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            load_balancing_rules: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            loadbalancer_id: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            outbound_rules: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            synchronous_mode: Optional[pulumi.Input[_builtins.str]] = None,
            tunnel_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input[Union['BackendAddressPoolTunnelInterfaceArgs', 'BackendAddressPoolTunnelInterfaceArgsDict']]]]] = None,
            virtual_network_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'BackendAddressPool':
        """
        Get an existing BackendAddressPool resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] backend_ip_configurations: The Backend IP Configurations associated with this Backend Address Pool.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] inbound_nat_rules: An array of the Load Balancing Inbound NAT Rules associated with this Backend Address Pool.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] load_balancing_rules: The Load Balancing Rules associated with this Backend Address Pool.
        :param pulumi.Input[_builtins.str] loadbalancer_id: The ID of the Load Balancer in which to create the Backend Address Pool. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Backend Address Pool. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] outbound_rules: An array of the Load Balancing Outbound Rules associated with this Backend Address Pool.
        :param pulumi.Input[_builtins.str] synchronous_mode: The backend address synchronous mode for the Backend Address Pool. Possible values are `Automatic` and `Manual`. This is required with `virtual_network_id`. Changing this forces a new resource to be created.
               
               > **Note:** The `synchronous_mode` can set only for Load Balancer with `Standard` SKU.
        :param pulumi.Input[Sequence[pulumi.Input[Union['BackendAddressPoolTunnelInterfaceArgs', 'BackendAddressPoolTunnelInterfaceArgsDict']]]] tunnel_interfaces: One or more `tunnel_interface` blocks as defined below.
        :param pulumi.Input[_builtins.str] virtual_network_id: The ID of the Virtual Network within which the Backend Address Pool should exist.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _BackendAddressPoolState.__new__(_BackendAddressPoolState)

        __props__.__dict__["backend_ip_configurations"] = backend_ip_configurations
        __props__.__dict__["inbound_nat_rules"] = inbound_nat_rules
        __props__.__dict__["load_balancing_rules"] = load_balancing_rules
        __props__.__dict__["loadbalancer_id"] = loadbalancer_id
        __props__.__dict__["name"] = name
        __props__.__dict__["outbound_rules"] = outbound_rules
        __props__.__dict__["synchronous_mode"] = synchronous_mode
        __props__.__dict__["tunnel_interfaces"] = tunnel_interfaces
        __props__.__dict__["virtual_network_id"] = virtual_network_id
        return BackendAddressPool(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="backendIpConfigurations")
    def backend_ip_configurations(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The Backend IP Configurations associated with this Backend Address Pool.
        """
        return pulumi.get(self, "backend_ip_configurations")

    @_builtins.property
    @pulumi.getter(name="inboundNatRules")
    def inbound_nat_rules(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        An array of the Load Balancing Inbound NAT Rules associated with this Backend Address Pool.
        """
        return pulumi.get(self, "inbound_nat_rules")

    @_builtins.property
    @pulumi.getter(name="loadBalancingRules")
    def load_balancing_rules(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The Load Balancing Rules associated with this Backend Address Pool.
        """
        return pulumi.get(self, "load_balancing_rules")

    @_builtins.property
    @pulumi.getter(name="loadbalancerId")
    def loadbalancer_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Load Balancer in which to create the Backend Address Pool. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "loadbalancer_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of the Backend Address Pool. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="outboundRules")
    def outbound_rules(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        An array of the Load Balancing Outbound Rules associated with this Backend Address Pool.
        """
        return pulumi.get(self, "outbound_rules")

    @_builtins.property
    @pulumi.getter(name="synchronousMode")
    def synchronous_mode(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The backend address synchronous mode for the Backend Address Pool. Possible values are `Automatic` and `Manual`. This is required with `virtual_network_id`. Changing this forces a new resource to be created.

        > **Note:** The `synchronous_mode` can set only for Load Balancer with `Standard` SKU.
        """
        return pulumi.get(self, "synchronous_mode")

    @_builtins.property
    @pulumi.getter(name="tunnelInterfaces")
    def tunnel_interfaces(self) -> pulumi.Output[Optional[Sequence['outputs.BackendAddressPoolTunnelInterface']]]:
        """
        One or more `tunnel_interface` blocks as defined below.
        """
        return pulumi.get(self, "tunnel_interfaces")

    @_builtins.property
    @pulumi.getter(name="virtualNetworkId")
    def virtual_network_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the Virtual Network within which the Backend Address Pool should exist.
        """
        return pulumi.get(self, "virtual_network_id")

