# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetLBRuleResult',
    'AwaitableGetLBRuleResult',
    'get_lb_rule',
    'get_lb_rule_output',
]

@pulumi.output_type
class GetLBRuleResult:
    """
    A collection of values returned by getLBRule.
    """
    def __init__(__self__, backend_address_pool_id=None, backend_port=None, disable_outbound_snat=None, enable_floating_ip=None, enable_tcp_reset=None, frontend_ip_configuration_name=None, frontend_port=None, id=None, idle_timeout_in_minutes=None, load_distribution=None, loadbalancer_id=None, name=None, probe_id=None, protocol=None):
        if backend_address_pool_id and not isinstance(backend_address_pool_id, str):
            raise TypeError("Expected argument 'backend_address_pool_id' to be a str")
        pulumi.set(__self__, "backend_address_pool_id", backend_address_pool_id)
        if backend_port and not isinstance(backend_port, int):
            raise TypeError("Expected argument 'backend_port' to be a int")
        pulumi.set(__self__, "backend_port", backend_port)
        if disable_outbound_snat and not isinstance(disable_outbound_snat, bool):
            raise TypeError("Expected argument 'disable_outbound_snat' to be a bool")
        pulumi.set(__self__, "disable_outbound_snat", disable_outbound_snat)
        if enable_floating_ip and not isinstance(enable_floating_ip, bool):
            raise TypeError("Expected argument 'enable_floating_ip' to be a bool")
        pulumi.set(__self__, "enable_floating_ip", enable_floating_ip)
        if enable_tcp_reset and not isinstance(enable_tcp_reset, bool):
            raise TypeError("Expected argument 'enable_tcp_reset' to be a bool")
        pulumi.set(__self__, "enable_tcp_reset", enable_tcp_reset)
        if frontend_ip_configuration_name and not isinstance(frontend_ip_configuration_name, str):
            raise TypeError("Expected argument 'frontend_ip_configuration_name' to be a str")
        pulumi.set(__self__, "frontend_ip_configuration_name", frontend_ip_configuration_name)
        if frontend_port and not isinstance(frontend_port, int):
            raise TypeError("Expected argument 'frontend_port' to be a int")
        pulumi.set(__self__, "frontend_port", frontend_port)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if idle_timeout_in_minutes and not isinstance(idle_timeout_in_minutes, int):
            raise TypeError("Expected argument 'idle_timeout_in_minutes' to be a int")
        pulumi.set(__self__, "idle_timeout_in_minutes", idle_timeout_in_minutes)
        if load_distribution and not isinstance(load_distribution, str):
            raise TypeError("Expected argument 'load_distribution' to be a str")
        pulumi.set(__self__, "load_distribution", load_distribution)
        if loadbalancer_id and not isinstance(loadbalancer_id, str):
            raise TypeError("Expected argument 'loadbalancer_id' to be a str")
        pulumi.set(__self__, "loadbalancer_id", loadbalancer_id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if probe_id and not isinstance(probe_id, str):
            raise TypeError("Expected argument 'probe_id' to be a str")
        pulumi.set(__self__, "probe_id", probe_id)
        if protocol and not isinstance(protocol, str):
            raise TypeError("Expected argument 'protocol' to be a str")
        pulumi.set(__self__, "protocol", protocol)

    @_builtins.property
    @pulumi.getter(name="backendAddressPoolId")
    def backend_address_pool_id(self) -> _builtins.str:
        """
        A reference to a Backend Address Pool over which this Load Balancing Rule operates.
        """
        return pulumi.get(self, "backend_address_pool_id")

    @_builtins.property
    @pulumi.getter(name="backendPort")
    def backend_port(self) -> _builtins.int:
        """
        The port used for internal connections on the endpoint.
        """
        return pulumi.get(self, "backend_port")

    @_builtins.property
    @pulumi.getter(name="disableOutboundSnat")
    def disable_outbound_snat(self) -> _builtins.bool:
        """
        If outbound SNAT is enabled for this Load Balancer Rule.
        """
        return pulumi.get(self, "disable_outbound_snat")

    @_builtins.property
    @pulumi.getter(name="enableFloatingIp")
    def enable_floating_ip(self) -> _builtins.bool:
        """
        If Floating IPs are enabled for this Load Balancer Rule
        """
        return pulumi.get(self, "enable_floating_ip")

    @_builtins.property
    @pulumi.getter(name="enableTcpReset")
    def enable_tcp_reset(self) -> _builtins.bool:
        """
        If TCP Reset is enabled for this Load Balancer Rule.
        """
        return pulumi.get(self, "enable_tcp_reset")

    @_builtins.property
    @pulumi.getter(name="frontendIpConfigurationName")
    def frontend_ip_configuration_name(self) -> _builtins.str:
        """
        The name of the frontend IP configuration to which the rule is associated.
        """
        return pulumi.get(self, "frontend_ip_configuration_name")

    @_builtins.property
    @pulumi.getter(name="frontendPort")
    def frontend_port(self) -> _builtins.int:
        """
        The port for the external endpoint.
        """
        return pulumi.get(self, "frontend_port")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="idleTimeoutInMinutes")
    def idle_timeout_in_minutes(self) -> _builtins.int:
        """
        Specifies the idle timeout in minutes for TCP connections.
        """
        return pulumi.get(self, "idle_timeout_in_minutes")

    @_builtins.property
    @pulumi.getter(name="loadDistribution")
    def load_distribution(self) -> _builtins.str:
        """
        Specifies the load balancing distribution type used by the Load Balancer.
        """
        return pulumi.get(self, "load_distribution")

    @_builtins.property
    @pulumi.getter(name="loadbalancerId")
    def loadbalancer_id(self) -> _builtins.str:
        return pulumi.get(self, "loadbalancer_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="probeId")
    def probe_id(self) -> _builtins.str:
        """
        A reference to a Probe used by this Load Balancing Rule.
        """
        return pulumi.get(self, "probe_id")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> _builtins.str:
        """
        The transport protocol for the external endpoint.
        """
        return pulumi.get(self, "protocol")


class AwaitableGetLBRuleResult(GetLBRuleResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetLBRuleResult(
            backend_address_pool_id=self.backend_address_pool_id,
            backend_port=self.backend_port,
            disable_outbound_snat=self.disable_outbound_snat,
            enable_floating_ip=self.enable_floating_ip,
            enable_tcp_reset=self.enable_tcp_reset,
            frontend_ip_configuration_name=self.frontend_ip_configuration_name,
            frontend_port=self.frontend_port,
            id=self.id,
            idle_timeout_in_minutes=self.idle_timeout_in_minutes,
            load_distribution=self.load_distribution,
            loadbalancer_id=self.loadbalancer_id,
            name=self.name,
            probe_id=self.probe_id,
            protocol=self.protocol)


def get_lb_rule(loadbalancer_id: Optional[_builtins.str] = None,
                name: Optional[_builtins.str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetLBRuleResult:
    """
    Use this data source to access information about an existing Load Balancer Rule.


    :param _builtins.str loadbalancer_id: The ID of the Load Balancer Rule.
    :param _builtins.str name: The name of this Load Balancer Rule.
    """
    __args__ = dict()
    __args__['loadbalancerId'] = loadbalancer_id
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:lb/getLBRule:getLBRule', __args__, opts=opts, typ=GetLBRuleResult).value

    return AwaitableGetLBRuleResult(
        backend_address_pool_id=pulumi.get(__ret__, 'backend_address_pool_id'),
        backend_port=pulumi.get(__ret__, 'backend_port'),
        disable_outbound_snat=pulumi.get(__ret__, 'disable_outbound_snat'),
        enable_floating_ip=pulumi.get(__ret__, 'enable_floating_ip'),
        enable_tcp_reset=pulumi.get(__ret__, 'enable_tcp_reset'),
        frontend_ip_configuration_name=pulumi.get(__ret__, 'frontend_ip_configuration_name'),
        frontend_port=pulumi.get(__ret__, 'frontend_port'),
        id=pulumi.get(__ret__, 'id'),
        idle_timeout_in_minutes=pulumi.get(__ret__, 'idle_timeout_in_minutes'),
        load_distribution=pulumi.get(__ret__, 'load_distribution'),
        loadbalancer_id=pulumi.get(__ret__, 'loadbalancer_id'),
        name=pulumi.get(__ret__, 'name'),
        probe_id=pulumi.get(__ret__, 'probe_id'),
        protocol=pulumi.get(__ret__, 'protocol'))
def get_lb_rule_output(loadbalancer_id: Optional[pulumi.Input[_builtins.str]] = None,
                       name: Optional[pulumi.Input[_builtins.str]] = None,
                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetLBRuleResult]:
    """
    Use this data source to access information about an existing Load Balancer Rule.


    :param _builtins.str loadbalancer_id: The ID of the Load Balancer Rule.
    :param _builtins.str name: The name of this Load Balancer Rule.
    """
    __args__ = dict()
    __args__['loadbalancerId'] = loadbalancer_id
    __args__['name'] = name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:lb/getLBRule:getLBRule', __args__, opts=opts, typ=GetLBRuleResult)
    return __ret__.apply(lambda __response__: GetLBRuleResult(
        backend_address_pool_id=pulumi.get(__response__, 'backend_address_pool_id'),
        backend_port=pulumi.get(__response__, 'backend_port'),
        disable_outbound_snat=pulumi.get(__response__, 'disable_outbound_snat'),
        enable_floating_ip=pulumi.get(__response__, 'enable_floating_ip'),
        enable_tcp_reset=pulumi.get(__response__, 'enable_tcp_reset'),
        frontend_ip_configuration_name=pulumi.get(__response__, 'frontend_ip_configuration_name'),
        frontend_port=pulumi.get(__response__, 'frontend_port'),
        id=pulumi.get(__response__, 'id'),
        idle_timeout_in_minutes=pulumi.get(__response__, 'idle_timeout_in_minutes'),
        load_distribution=pulumi.get(__response__, 'load_distribution'),
        loadbalancer_id=pulumi.get(__response__, 'loadbalancer_id'),
        name=pulumi.get(__response__, 'name'),
        probe_id=pulumi.get(__response__, 'probe_id'),
        protocol=pulumi.get(__response__, 'protocol')))
