# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ActionCustomArgs', 'ActionCustom']

@pulumi.input_type
class ActionCustomArgs:
    def __init__(__self__, *,
                 body: pulumi.Input[_builtins.str],
                 logic_app_id: pulumi.Input[_builtins.str],
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a ActionCustom resource.
        :param pulumi.Input[_builtins.str] body: Specifies the JSON Blob defining the Body of this Custom Action.
        :param pulumi.Input[_builtins.str] logic_app_id: Specifies the ID of the Logic App Workflow. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the HTTP Action to be created within the Logic App Workflow. Changing this forces a new resource to be created.
               
               > **NOTE:** This name must be unique across all Actions within the Logic App Workflow.
        """
        pulumi.set(__self__, "body", body)
        pulumi.set(__self__, "logic_app_id", logic_app_id)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def body(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the JSON Blob defining the Body of this Custom Action.
        """
        return pulumi.get(self, "body")

    @body.setter
    def body(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "body", value)

    @_builtins.property
    @pulumi.getter(name="logicAppId")
    def logic_app_id(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the ID of the Logic App Workflow. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "logic_app_id")

    @logic_app_id.setter
    def logic_app_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "logic_app_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the HTTP Action to be created within the Logic App Workflow. Changing this forces a new resource to be created.

        > **NOTE:** This name must be unique across all Actions within the Logic App Workflow.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _ActionCustomState:
    def __init__(__self__, *,
                 body: Optional[pulumi.Input[_builtins.str]] = None,
                 logic_app_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ActionCustom resources.
        :param pulumi.Input[_builtins.str] body: Specifies the JSON Blob defining the Body of this Custom Action.
        :param pulumi.Input[_builtins.str] logic_app_id: Specifies the ID of the Logic App Workflow. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the HTTP Action to be created within the Logic App Workflow. Changing this forces a new resource to be created.
               
               > **NOTE:** This name must be unique across all Actions within the Logic App Workflow.
        """
        if body is not None:
            pulumi.set(__self__, "body", body)
        if logic_app_id is not None:
            pulumi.set(__self__, "logic_app_id", logic_app_id)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def body(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the JSON Blob defining the Body of this Custom Action.
        """
        return pulumi.get(self, "body")

    @body.setter
    def body(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "body", value)

    @_builtins.property
    @pulumi.getter(name="logicAppId")
    def logic_app_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the ID of the Logic App Workflow. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "logic_app_id")

    @logic_app_id.setter
    def logic_app_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "logic_app_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the HTTP Action to be created within the Logic App Workflow. Changing this forces a new resource to be created.

        > **NOTE:** This name must be unique across all Actions within the Logic App Workflow.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.type_token("azure:logicapps/actionCustom:ActionCustom")
class ActionCustom(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 body: Optional[pulumi.Input[_builtins.str]] = None,
                 logic_app_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a Custom Action within a Logic App Workflow

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="workflow-resources",
            location="West Europe")
        example_workflow = azure.logicapps.Workflow("example",
            name="workflow1",
            location=example.location,
            resource_group_name=example.name)
        example_action_custom = azure.logicapps.ActionCustom("example",
            name="example-action",
            logic_app_id=example_workflow.id,
            body=\"\"\"{
            "description": "A variable to configure the auto expiration age in days. Configured in negative number. Default is -30 (30 days old).",
            "inputs": {
                "variables": [
                    {
                        "name": "ExpirationAgeInDays",
                        "type": "Integer",
                        "value": -30
                    }
                ]
            },
            "runAfter": {},
            "type": "InitializeVariable"
        }
        \"\"\")
        ```

        ## Import

        Logic App Custom Actions can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:logicapps/actionCustom:ActionCustom custom1 /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.Logic/workflows/workflow1/actions/custom1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] body: Specifies the JSON Blob defining the Body of this Custom Action.
        :param pulumi.Input[_builtins.str] logic_app_id: Specifies the ID of the Logic App Workflow. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the HTTP Action to be created within the Logic App Workflow. Changing this forces a new resource to be created.
               
               > **NOTE:** This name must be unique across all Actions within the Logic App Workflow.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ActionCustomArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Custom Action within a Logic App Workflow

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="workflow-resources",
            location="West Europe")
        example_workflow = azure.logicapps.Workflow("example",
            name="workflow1",
            location=example.location,
            resource_group_name=example.name)
        example_action_custom = azure.logicapps.ActionCustom("example",
            name="example-action",
            logic_app_id=example_workflow.id,
            body=\"\"\"{
            "description": "A variable to configure the auto expiration age in days. Configured in negative number. Default is -30 (30 days old).",
            "inputs": {
                "variables": [
                    {
                        "name": "ExpirationAgeInDays",
                        "type": "Integer",
                        "value": -30
                    }
                ]
            },
            "runAfter": {},
            "type": "InitializeVariable"
        }
        \"\"\")
        ```

        ## Import

        Logic App Custom Actions can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:logicapps/actionCustom:ActionCustom custom1 /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.Logic/workflows/workflow1/actions/custom1
        ```

        :param str resource_name: The name of the resource.
        :param ActionCustomArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ActionCustomArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 body: Optional[pulumi.Input[_builtins.str]] = None,
                 logic_app_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ActionCustomArgs.__new__(ActionCustomArgs)

            if body is None and not opts.urn:
                raise TypeError("Missing required property 'body'")
            __props__.__dict__["body"] = body
            if logic_app_id is None and not opts.urn:
                raise TypeError("Missing required property 'logic_app_id'")
            __props__.__dict__["logic_app_id"] = logic_app_id
            __props__.__dict__["name"] = name
        super(ActionCustom, __self__).__init__(
            'azure:logicapps/actionCustom:ActionCustom',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            body: Optional[pulumi.Input[_builtins.str]] = None,
            logic_app_id: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None) -> 'ActionCustom':
        """
        Get an existing ActionCustom resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] body: Specifies the JSON Blob defining the Body of this Custom Action.
        :param pulumi.Input[_builtins.str] logic_app_id: Specifies the ID of the Logic App Workflow. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the HTTP Action to be created within the Logic App Workflow. Changing this forces a new resource to be created.
               
               > **NOTE:** This name must be unique across all Actions within the Logic App Workflow.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ActionCustomState.__new__(_ActionCustomState)

        __props__.__dict__["body"] = body
        __props__.__dict__["logic_app_id"] = logic_app_id
        __props__.__dict__["name"] = name
        return ActionCustom(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def body(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the JSON Blob defining the Body of this Custom Action.
        """
        return pulumi.get(self, "body")

    @_builtins.property
    @pulumi.getter(name="logicAppId")
    def logic_app_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the ID of the Logic App Workflow. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "logic_app_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of the HTTP Action to be created within the Logic App Workflow. Changing this forces a new resource to be created.

        > **NOTE:** This name must be unique across all Actions within the Logic App Workflow.
        """
        return pulumi.get(self, "name")

