# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetNetworkDataNetworkResult',
    'AwaitableGetNetworkDataNetworkResult',
    'get_network_data_network',
    'get_network_data_network_output',
]

@pulumi.output_type
class GetNetworkDataNetworkResult:
    """
    A collection of values returned by getNetworkDataNetwork.
    """
    def __init__(__self__, description=None, id=None, location=None, mobile_network_id=None, name=None, tags=None):
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if mobile_network_id and not isinstance(mobile_network_id, str):
            raise TypeError("Expected argument 'mobile_network_id' to be a str")
        pulumi.set(__self__, "mobile_network_id", mobile_network_id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description for this Mobile Network Data Network.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def location(self) -> _builtins.str:
        """
        The Azure Region where the Mobile Network Data Network exists.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter(name="mobileNetworkId")
    def mobile_network_id(self) -> _builtins.str:
        return pulumi.get(self, "mobile_network_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        A mapping of tags which should be assigned to the Mobile Network Data Network.
        """
        return pulumi.get(self, "tags")


class AwaitableGetNetworkDataNetworkResult(GetNetworkDataNetworkResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetNetworkDataNetworkResult(
            description=self.description,
            id=self.id,
            location=self.location,
            mobile_network_id=self.mobile_network_id,
            name=self.name,
            tags=self.tags)


def get_network_data_network(mobile_network_id: Optional[_builtins.str] = None,
                             name: Optional[_builtins.str] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetNetworkDataNetworkResult:
    """
    Get information about a Mobile Network Data Network.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.mobile.get_network(name="example-mn",
        resource_group_name="example-rg")
    example_get_network_data_network = azure.mobile.get_network_data_network(name="example-mndn",
        mobile_network_id=example.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.MobileNetwork`: 2022-11-01


    :param _builtins.str mobile_network_id: Specifies the ID of the Mobile Network.
    :param _builtins.str name: Specifies the name which should be used for this Mobile Network Data Network.
    """
    __args__ = dict()
    __args__['mobileNetworkId'] = mobile_network_id
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:mobile/getNetworkDataNetwork:getNetworkDataNetwork', __args__, opts=opts, typ=GetNetworkDataNetworkResult).value

    return AwaitableGetNetworkDataNetworkResult(
        description=pulumi.get(__ret__, 'description'),
        id=pulumi.get(__ret__, 'id'),
        location=pulumi.get(__ret__, 'location'),
        mobile_network_id=pulumi.get(__ret__, 'mobile_network_id'),
        name=pulumi.get(__ret__, 'name'),
        tags=pulumi.get(__ret__, 'tags'))
def get_network_data_network_output(mobile_network_id: Optional[pulumi.Input[_builtins.str]] = None,
                                    name: Optional[pulumi.Input[_builtins.str]] = None,
                                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetNetworkDataNetworkResult]:
    """
    Get information about a Mobile Network Data Network.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.mobile.get_network(name="example-mn",
        resource_group_name="example-rg")
    example_get_network_data_network = azure.mobile.get_network_data_network(name="example-mndn",
        mobile_network_id=example.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.MobileNetwork`: 2022-11-01


    :param _builtins.str mobile_network_id: Specifies the ID of the Mobile Network.
    :param _builtins.str name: Specifies the name which should be used for this Mobile Network Data Network.
    """
    __args__ = dict()
    __args__['mobileNetworkId'] = mobile_network_id
    __args__['name'] = name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:mobile/getNetworkDataNetwork:getNetworkDataNetwork', __args__, opts=opts, typ=GetNetworkDataNetworkResult)
    return __ret__.apply(lambda __response__: GetNetworkDataNetworkResult(
        description=pulumi.get(__response__, 'description'),
        id=pulumi.get(__response__, 'id'),
        location=pulumi.get(__response__, 'location'),
        mobile_network_id=pulumi.get(__response__, 'mobile_network_id'),
        name=pulumi.get(__response__, 'name'),
        tags=pulumi.get(__response__, 'tags')))
