# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetNetworkSimResult',
    'AwaitableGetNetworkSimResult',
    'get_network_sim',
    'get_network_sim_output',
]

@pulumi.output_type
class GetNetworkSimResult:
    """
    A collection of values returned by getNetworkSim.
    """
    def __init__(__self__, device_type=None, id=None, integrated_circuit_card_identifier=None, international_mobile_subscriber_identity=None, mobile_network_sim_group_id=None, name=None, sim_policy_id=None, sim_state=None, static_ip_configurations=None, vendor_key_fingerprint=None, vendor_name=None):
        if device_type and not isinstance(device_type, str):
            raise TypeError("Expected argument 'device_type' to be a str")
        pulumi.set(__self__, "device_type", device_type)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if integrated_circuit_card_identifier and not isinstance(integrated_circuit_card_identifier, str):
            raise TypeError("Expected argument 'integrated_circuit_card_identifier' to be a str")
        pulumi.set(__self__, "integrated_circuit_card_identifier", integrated_circuit_card_identifier)
        if international_mobile_subscriber_identity and not isinstance(international_mobile_subscriber_identity, str):
            raise TypeError("Expected argument 'international_mobile_subscriber_identity' to be a str")
        pulumi.set(__self__, "international_mobile_subscriber_identity", international_mobile_subscriber_identity)
        if mobile_network_sim_group_id and not isinstance(mobile_network_sim_group_id, str):
            raise TypeError("Expected argument 'mobile_network_sim_group_id' to be a str")
        pulumi.set(__self__, "mobile_network_sim_group_id", mobile_network_sim_group_id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if sim_policy_id and not isinstance(sim_policy_id, str):
            raise TypeError("Expected argument 'sim_policy_id' to be a str")
        pulumi.set(__self__, "sim_policy_id", sim_policy_id)
        if sim_state and not isinstance(sim_state, str):
            raise TypeError("Expected argument 'sim_state' to be a str")
        pulumi.set(__self__, "sim_state", sim_state)
        if static_ip_configurations and not isinstance(static_ip_configurations, list):
            raise TypeError("Expected argument 'static_ip_configurations' to be a list")
        pulumi.set(__self__, "static_ip_configurations", static_ip_configurations)
        if vendor_key_fingerprint and not isinstance(vendor_key_fingerprint, str):
            raise TypeError("Expected argument 'vendor_key_fingerprint' to be a str")
        pulumi.set(__self__, "vendor_key_fingerprint", vendor_key_fingerprint)
        if vendor_name and not isinstance(vendor_name, str):
            raise TypeError("Expected argument 'vendor_name' to be a str")
        pulumi.set(__self__, "vendor_name", vendor_name)

    @_builtins.property
    @pulumi.getter(name="deviceType")
    def device_type(self) -> _builtins.str:
        """
        The device type this SIM is associated with.
        """
        return pulumi.get(self, "device_type")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="integratedCircuitCardIdentifier")
    def integrated_circuit_card_identifier(self) -> _builtins.str:
        """
        The integrated circuit card ID (ICCID) for the SIM.
        """
        return pulumi.get(self, "integrated_circuit_card_identifier")

    @_builtins.property
    @pulumi.getter(name="internationalMobileSubscriberIdentity")
    def international_mobile_subscriber_identity(self) -> _builtins.str:
        """
        The international mobile subscriber identity (IMSI) for the SIM.
        """
        return pulumi.get(self, "international_mobile_subscriber_identity")

    @_builtins.property
    @pulumi.getter(name="mobileNetworkSimGroupId")
    def mobile_network_sim_group_id(self) -> _builtins.str:
        return pulumi.get(self, "mobile_network_sim_group_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="simPolicyId")
    def sim_policy_id(self) -> _builtins.str:
        """
        The ID of SIM policy used by this SIM.
        """
        return pulumi.get(self, "sim_policy_id")

    @_builtins.property
    @pulumi.getter(name="simState")
    def sim_state(self) -> _builtins.str:
        """
        The state of the SIM resource.
        """
        return pulumi.get(self, "sim_state")

    @_builtins.property
    @pulumi.getter(name="staticIpConfigurations")
    def static_ip_configurations(self) -> Sequence['outputs.GetNetworkSimStaticIpConfigurationResult']:
        """
        A `static_ip_configuration` block as defined below.
        """
        return pulumi.get(self, "static_ip_configurations")

    @_builtins.property
    @pulumi.getter(name="vendorKeyFingerprint")
    def vendor_key_fingerprint(self) -> _builtins.str:
        """
        The public key fingerprint of the SIM vendor who provided this SIM.
        """
        return pulumi.get(self, "vendor_key_fingerprint")

    @_builtins.property
    @pulumi.getter(name="vendorName")
    def vendor_name(self) -> _builtins.str:
        """
        The name of the SIM vendor who provided this SIM, if any.
        """
        return pulumi.get(self, "vendor_name")


class AwaitableGetNetworkSimResult(GetNetworkSimResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetNetworkSimResult(
            device_type=self.device_type,
            id=self.id,
            integrated_circuit_card_identifier=self.integrated_circuit_card_identifier,
            international_mobile_subscriber_identity=self.international_mobile_subscriber_identity,
            mobile_network_sim_group_id=self.mobile_network_sim_group_id,
            name=self.name,
            sim_policy_id=self.sim_policy_id,
            sim_state=self.sim_state,
            static_ip_configurations=self.static_ip_configurations,
            vendor_key_fingerprint=self.vendor_key_fingerprint,
            vendor_name=self.vendor_name)


def get_network_sim(mobile_network_sim_group_id: Optional[_builtins.str] = None,
                    name: Optional[_builtins.str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetNetworkSimResult:
    """
    Get information about a Mobile Network Sim.


    :param _builtins.str mobile_network_sim_group_id: The ID of the Mobile Network which the Mobile Network Sim belongs to.
    :param _builtins.str name: The name which should be used for this Mobile Network Sim.
    """
    __args__ = dict()
    __args__['mobileNetworkSimGroupId'] = mobile_network_sim_group_id
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:mobile/getNetworkSim:getNetworkSim', __args__, opts=opts, typ=GetNetworkSimResult).value

    return AwaitableGetNetworkSimResult(
        device_type=pulumi.get(__ret__, 'device_type'),
        id=pulumi.get(__ret__, 'id'),
        integrated_circuit_card_identifier=pulumi.get(__ret__, 'integrated_circuit_card_identifier'),
        international_mobile_subscriber_identity=pulumi.get(__ret__, 'international_mobile_subscriber_identity'),
        mobile_network_sim_group_id=pulumi.get(__ret__, 'mobile_network_sim_group_id'),
        name=pulumi.get(__ret__, 'name'),
        sim_policy_id=pulumi.get(__ret__, 'sim_policy_id'),
        sim_state=pulumi.get(__ret__, 'sim_state'),
        static_ip_configurations=pulumi.get(__ret__, 'static_ip_configurations'),
        vendor_key_fingerprint=pulumi.get(__ret__, 'vendor_key_fingerprint'),
        vendor_name=pulumi.get(__ret__, 'vendor_name'))
def get_network_sim_output(mobile_network_sim_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                           name: Optional[pulumi.Input[_builtins.str]] = None,
                           opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetNetworkSimResult]:
    """
    Get information about a Mobile Network Sim.


    :param _builtins.str mobile_network_sim_group_id: The ID of the Mobile Network which the Mobile Network Sim belongs to.
    :param _builtins.str name: The name which should be used for this Mobile Network Sim.
    """
    __args__ = dict()
    __args__['mobileNetworkSimGroupId'] = mobile_network_sim_group_id
    __args__['name'] = name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:mobile/getNetworkSim:getNetworkSim', __args__, opts=opts, typ=GetNetworkSimResult)
    return __ret__.apply(lambda __response__: GetNetworkSimResult(
        device_type=pulumi.get(__response__, 'device_type'),
        id=pulumi.get(__response__, 'id'),
        integrated_circuit_card_identifier=pulumi.get(__response__, 'integrated_circuit_card_identifier'),
        international_mobile_subscriber_identity=pulumi.get(__response__, 'international_mobile_subscriber_identity'),
        mobile_network_sim_group_id=pulumi.get(__response__, 'mobile_network_sim_group_id'),
        name=pulumi.get(__response__, 'name'),
        sim_policy_id=pulumi.get(__response__, 'sim_policy_id'),
        sim_state=pulumi.get(__response__, 'sim_state'),
        static_ip_configurations=pulumi.get(__response__, 'static_ip_configurations'),
        vendor_key_fingerprint=pulumi.get(__response__, 'vendor_key_fingerprint'),
        vendor_name=pulumi.get(__response__, 'vendor_name')))
