# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['PrivateLinkScopedServiceArgs', 'PrivateLinkScopedService']

@pulumi.input_type
class PrivateLinkScopedServiceArgs:
    def __init__(__self__, *,
                 linked_resource_id: pulumi.Input[_builtins.str],
                 resource_group_name: pulumi.Input[_builtins.str],
                 scope_name: pulumi.Input[_builtins.str],
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a PrivateLinkScopedService resource.
        :param pulumi.Input[_builtins.str] linked_resource_id: The ID of the linked resource. It must be the Log Analytics workspace or the Application Insights component or the Data Collection endpoint. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the Azure Monitor Private Link Scoped Service should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] scope_name: The name of the Azure Monitor Private Link Scope. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name of the Azure Monitor Private Link Scoped Service. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "linked_resource_id", linked_resource_id)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "scope_name", scope_name)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="linkedResourceId")
    def linked_resource_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the linked resource. It must be the Log Analytics workspace or the Application Insights component or the Data Collection endpoint. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "linked_resource_id")

    @linked_resource_id.setter
    def linked_resource_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "linked_resource_id", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the Resource Group where the Azure Monitor Private Link Scoped Service should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="scopeName")
    def scope_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the Azure Monitor Private Link Scope. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "scope_name")

    @scope_name.setter
    def scope_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "scope_name", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Azure Monitor Private Link Scoped Service. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _PrivateLinkScopedServiceState:
    def __init__(__self__, *,
                 linked_resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 scope_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering PrivateLinkScopedService resources.
        :param pulumi.Input[_builtins.str] linked_resource_id: The ID of the linked resource. It must be the Log Analytics workspace or the Application Insights component or the Data Collection endpoint. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name of the Azure Monitor Private Link Scoped Service. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the Azure Monitor Private Link Scoped Service should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] scope_name: The name of the Azure Monitor Private Link Scope. Changing this forces a new resource to be created.
        """
        if linked_resource_id is not None:
            pulumi.set(__self__, "linked_resource_id", linked_resource_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if scope_name is not None:
            pulumi.set(__self__, "scope_name", scope_name)

    @_builtins.property
    @pulumi.getter(name="linkedResourceId")
    def linked_resource_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the linked resource. It must be the Log Analytics workspace or the Application Insights component or the Data Collection endpoint. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "linked_resource_id")

    @linked_resource_id.setter
    def linked_resource_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "linked_resource_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Azure Monitor Private Link Scoped Service. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Resource Group where the Azure Monitor Private Link Scoped Service should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="scopeName")
    def scope_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Azure Monitor Private Link Scope. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "scope_name")

    @scope_name.setter
    def scope_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "scope_name", value)


@pulumi.type_token("azure:monitoring/privateLinkScopedService:PrivateLinkScopedService")
class PrivateLinkScopedService(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 linked_resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 scope_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages an Azure Monitor Private Link Scoped Service.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_insights = azure.appinsights.Insights("example",
            name="example-appinsights",
            location=example.location,
            resource_group_name=example.name,
            application_type="web")
        example_private_link_scope = azure.monitoring.PrivateLinkScope("example",
            name="example-ampls",
            resource_group_name=example.name)
        example_private_link_scoped_service = azure.monitoring.PrivateLinkScopedService("example",
            name="example-amplsservice",
            resource_group_name=example.name,
            scope_name=example_private_link_scope.name,
            linked_resource_id=example_insights.id)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Insights`: 2019-10-17-preview

        ## Import

        Azure Monitor Private Link Scoped Services can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:monitoring/privateLinkScopedService:PrivateLinkScopedService example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.Insights/privateLinkScopes/pls1/scopedResources/sr1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] linked_resource_id: The ID of the linked resource. It must be the Log Analytics workspace or the Application Insights component or the Data Collection endpoint. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name of the Azure Monitor Private Link Scoped Service. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the Azure Monitor Private Link Scoped Service should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] scope_name: The name of the Azure Monitor Private Link Scope. Changing this forces a new resource to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PrivateLinkScopedServiceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an Azure Monitor Private Link Scoped Service.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_insights = azure.appinsights.Insights("example",
            name="example-appinsights",
            location=example.location,
            resource_group_name=example.name,
            application_type="web")
        example_private_link_scope = azure.monitoring.PrivateLinkScope("example",
            name="example-ampls",
            resource_group_name=example.name)
        example_private_link_scoped_service = azure.monitoring.PrivateLinkScopedService("example",
            name="example-amplsservice",
            resource_group_name=example.name,
            scope_name=example_private_link_scope.name,
            linked_resource_id=example_insights.id)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Insights`: 2019-10-17-preview

        ## Import

        Azure Monitor Private Link Scoped Services can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:monitoring/privateLinkScopedService:PrivateLinkScopedService example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.Insights/privateLinkScopes/pls1/scopedResources/sr1
        ```

        :param str resource_name: The name of the resource.
        :param PrivateLinkScopedServiceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PrivateLinkScopedServiceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 linked_resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 scope_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PrivateLinkScopedServiceArgs.__new__(PrivateLinkScopedServiceArgs)

            if linked_resource_id is None and not opts.urn:
                raise TypeError("Missing required property 'linked_resource_id'")
            __props__.__dict__["linked_resource_id"] = linked_resource_id
            __props__.__dict__["name"] = name
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            if scope_name is None and not opts.urn:
                raise TypeError("Missing required property 'scope_name'")
            __props__.__dict__["scope_name"] = scope_name
        super(PrivateLinkScopedService, __self__).__init__(
            'azure:monitoring/privateLinkScopedService:PrivateLinkScopedService',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            linked_resource_id: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            scope_name: Optional[pulumi.Input[_builtins.str]] = None) -> 'PrivateLinkScopedService':
        """
        Get an existing PrivateLinkScopedService resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] linked_resource_id: The ID of the linked resource. It must be the Log Analytics workspace or the Application Insights component or the Data Collection endpoint. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name of the Azure Monitor Private Link Scoped Service. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the Azure Monitor Private Link Scoped Service should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] scope_name: The name of the Azure Monitor Private Link Scope. Changing this forces a new resource to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PrivateLinkScopedServiceState.__new__(_PrivateLinkScopedServiceState)

        __props__.__dict__["linked_resource_id"] = linked_resource_id
        __props__.__dict__["name"] = name
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["scope_name"] = scope_name
        return PrivateLinkScopedService(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="linkedResourceId")
    def linked_resource_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the linked resource. It must be the Log Analytics workspace or the Application Insights component or the Data Collection endpoint. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "linked_resource_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Azure Monitor Private Link Scoped Service. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Resource Group where the Azure Monitor Private Link Scoped Service should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter(name="scopeName")
    def scope_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Azure Monitor Private Link Scope. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "scope_name")

