# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ScheduledQueryRulesAlertV2Args', 'ScheduledQueryRulesAlertV2']

@pulumi.input_type
class ScheduledQueryRulesAlertV2Args:
    def __init__(__self__, *,
                 criterias: pulumi.Input[Sequence[pulumi.Input['ScheduledQueryRulesAlertV2CriteriaArgs']]],
                 evaluation_frequency: pulumi.Input[_builtins.str],
                 resource_group_name: pulumi.Input[_builtins.str],
                 scopes: pulumi.Input[_builtins.str],
                 severity: pulumi.Input[_builtins.int],
                 window_duration: pulumi.Input[_builtins.str],
                 action: Optional[pulumi.Input['ScheduledQueryRulesAlertV2ActionArgs']] = None,
                 auto_mitigation_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 identity: Optional[pulumi.Input['ScheduledQueryRulesAlertV2IdentityArgs']] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 mute_actions_after_alert_duration: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 query_time_range_override: Optional[pulumi.Input[_builtins.str]] = None,
                 skip_query_validation: Optional[pulumi.Input[_builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 target_resource_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 workspace_alerts_storage_enabled: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a ScheduledQueryRulesAlertV2 resource.
        :param pulumi.Input[Sequence[pulumi.Input['ScheduledQueryRulesAlertV2CriteriaArgs']]] criterias: A `criteria` block as defined below.
        :param pulumi.Input[_builtins.str] evaluation_frequency: How often the scheduled query rule is evaluated, represented in ISO 8601 duration format. Possible values are `PT1M`, `PT5M`, `PT10M`, `PT15M`, `PT30M`, `PT45M`, `PT1H`, `PT2H`, `PT3H`, `PT4H`, `PT5H`, `PT6H`, `P1D`.
               
               > **Note:** `evaluation_frequency` cannot be greater than the query look back which is `window_duration`*`number_of_evaluation_periods`.
               
               > **Note:** `evaluation_frequency` cannot be greater than the `mute_actions_after_alert_duration`.
        :param pulumi.Input[_builtins.str] resource_group_name: Specifies the name of the Resource Group where the Monitor Scheduled Query Rule should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] scopes: Specifies the list of resource IDs that this scheduled query rule is scoped to. Changing this forces a new resource to be created. Currently, the API supports exactly 1 resource ID in the scopes list.
        :param pulumi.Input[_builtins.int] severity: Severity of the alert. Should be an integer between 0 and 4. Value of 0 is severest.
        :param pulumi.Input[_builtins.str] window_duration: Specifies the period of time in ISO 8601 duration format on which the Scheduled Query Rule will be executed (bin size). If `evaluation_frequency` is `PT1M`, possible values are `PT1M`, `PT5M`, `PT10M`, `PT15M`, `PT30M`, `PT45M`, `PT1H`, `PT2H`, `PT3H`, `PT4H`, `PT5H`, and `PT6H`. Otherwise, possible values are `PT5M`, `PT10M`, `PT15M`, `PT30M`, `PT45M`, `PT1H`, `PT2H`, `PT3H`, `PT4H`, `PT5H`, `PT6H`, `P1D`, and `P2D`.
        :param pulumi.Input['ScheduledQueryRulesAlertV2ActionArgs'] action: An `action` block as defined below.
        :param pulumi.Input[_builtins.bool] auto_mitigation_enabled: Specifies the flag that indicates whether the alert should be automatically resolved or not. Value should be `true` or `false`. The default is `false`.
        :param pulumi.Input[_builtins.str] description: Specifies the description of the scheduled query rule.
        :param pulumi.Input[_builtins.str] display_name: Specifies the display name of the alert rule.
        :param pulumi.Input[_builtins.bool] enabled: Specifies the flag which indicates whether this scheduled query rule is enabled. Value should be `true` or `false`. Defaults to `true`.
        :param pulumi.Input['ScheduledQueryRulesAlertV2IdentityArgs'] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.str] location: Specifies the Azure Region where the Monitor Scheduled Query Rule should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] mute_actions_after_alert_duration: Mute actions for the chosen period of time in ISO 8601 duration format after the alert is fired. Possible values are `PT5M`, `PT10M`, `PT15M`, `PT30M`, `PT45M`, `PT1H`, `PT2H`, `PT3H`, `PT4H`, `PT5H`, `PT6H`, `P1D` and `P2D`.
               
               > **Note:** `auto_mitigation_enabled` and `mute_actions_after_alert_duration` are mutually exclusive and cannot both be set.
        :param pulumi.Input[_builtins.str] name: Specifies the name which should be used for this Monitor Scheduled Query Rule. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] query_time_range_override: Set this if the alert evaluation period is different from the query time range. If not specified, the value is `window_duration`*`number_of_evaluation_periods`. Possible values are `PT5M`, `PT10M`, `PT15M`, `PT20M`, `PT30M`, `PT45M`, `PT1H`, `PT2H`, `PT3H`, `PT4H`, `PT5H`, `PT6H`, `P1D` and `P2D`.
               
               > **Note:** `query_time_range_override` cannot be less than the query look back which is `window_duration`*`number_of_evaluation_periods`.
        :param pulumi.Input[_builtins.bool] skip_query_validation: Specifies the flag which indicates whether the provided query should be validated or not. The default is false.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Monitor Scheduled Query Rule.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] target_resource_types: List of resource type of the target resource(s) on which the alert is created/updated. For example if the scope is a resource group and targetResourceTypes is `Microsoft.Compute/virtualMachines`, then a different alert will be fired for each virtual machine in the resource group which meet the alert criteria.
        :param pulumi.Input[_builtins.bool] workspace_alerts_storage_enabled: Specifies the flag which indicates whether this scheduled query rule check if storage is configured. Value should be `true` or `false`. The default is `false`.
        """
        pulumi.set(__self__, "criterias", criterias)
        pulumi.set(__self__, "evaluation_frequency", evaluation_frequency)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "scopes", scopes)
        pulumi.set(__self__, "severity", severity)
        pulumi.set(__self__, "window_duration", window_duration)
        if action is not None:
            pulumi.set(__self__, "action", action)
        if auto_mitigation_enabled is not None:
            pulumi.set(__self__, "auto_mitigation_enabled", auto_mitigation_enabled)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if mute_actions_after_alert_duration is not None:
            pulumi.set(__self__, "mute_actions_after_alert_duration", mute_actions_after_alert_duration)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if query_time_range_override is not None:
            pulumi.set(__self__, "query_time_range_override", query_time_range_override)
        if skip_query_validation is not None:
            pulumi.set(__self__, "skip_query_validation", skip_query_validation)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if target_resource_types is not None:
            pulumi.set(__self__, "target_resource_types", target_resource_types)
        if workspace_alerts_storage_enabled is not None:
            pulumi.set(__self__, "workspace_alerts_storage_enabled", workspace_alerts_storage_enabled)

    @_builtins.property
    @pulumi.getter
    def criterias(self) -> pulumi.Input[Sequence[pulumi.Input['ScheduledQueryRulesAlertV2CriteriaArgs']]]:
        """
        A `criteria` block as defined below.
        """
        return pulumi.get(self, "criterias")

    @criterias.setter
    def criterias(self, value: pulumi.Input[Sequence[pulumi.Input['ScheduledQueryRulesAlertV2CriteriaArgs']]]):
        pulumi.set(self, "criterias", value)

    @_builtins.property
    @pulumi.getter(name="evaluationFrequency")
    def evaluation_frequency(self) -> pulumi.Input[_builtins.str]:
        """
        How often the scheduled query rule is evaluated, represented in ISO 8601 duration format. Possible values are `PT1M`, `PT5M`, `PT10M`, `PT15M`, `PT30M`, `PT45M`, `PT1H`, `PT2H`, `PT3H`, `PT4H`, `PT5H`, `PT6H`, `P1D`.

        > **Note:** `evaluation_frequency` cannot be greater than the query look back which is `window_duration`*`number_of_evaluation_periods`.

        > **Note:** `evaluation_frequency` cannot be greater than the `mute_actions_after_alert_duration`.
        """
        return pulumi.get(self, "evaluation_frequency")

    @evaluation_frequency.setter
    def evaluation_frequency(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "evaluation_frequency", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the name of the Resource Group where the Monitor Scheduled Query Rule should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter
    def scopes(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the list of resource IDs that this scheduled query rule is scoped to. Changing this forces a new resource to be created. Currently, the API supports exactly 1 resource ID in the scopes list.
        """
        return pulumi.get(self, "scopes")

    @scopes.setter
    def scopes(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "scopes", value)

    @_builtins.property
    @pulumi.getter
    def severity(self) -> pulumi.Input[_builtins.int]:
        """
        Severity of the alert. Should be an integer between 0 and 4. Value of 0 is severest.
        """
        return pulumi.get(self, "severity")

    @severity.setter
    def severity(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "severity", value)

    @_builtins.property
    @pulumi.getter(name="windowDuration")
    def window_duration(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the period of time in ISO 8601 duration format on which the Scheduled Query Rule will be executed (bin size). If `evaluation_frequency` is `PT1M`, possible values are `PT1M`, `PT5M`, `PT10M`, `PT15M`, `PT30M`, `PT45M`, `PT1H`, `PT2H`, `PT3H`, `PT4H`, `PT5H`, and `PT6H`. Otherwise, possible values are `PT5M`, `PT10M`, `PT15M`, `PT30M`, `PT45M`, `PT1H`, `PT2H`, `PT3H`, `PT4H`, `PT5H`, `PT6H`, `P1D`, and `P2D`.
        """
        return pulumi.get(self, "window_duration")

    @window_duration.setter
    def window_duration(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "window_duration", value)

    @_builtins.property
    @pulumi.getter
    def action(self) -> Optional[pulumi.Input['ScheduledQueryRulesAlertV2ActionArgs']]:
        """
        An `action` block as defined below.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: Optional[pulumi.Input['ScheduledQueryRulesAlertV2ActionArgs']]):
        pulumi.set(self, "action", value)

    @_builtins.property
    @pulumi.getter(name="autoMitigationEnabled")
    def auto_mitigation_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies the flag that indicates whether the alert should be automatically resolved or not. Value should be `true` or `false`. The default is `false`.
        """
        return pulumi.get(self, "auto_mitigation_enabled")

    @auto_mitigation_enabled.setter
    def auto_mitigation_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_mitigation_enabled", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the description of the scheduled query rule.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the display name of the alert rule.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies the flag which indicates whether this scheduled query rule is enabled. Value should be `true` or `false`. Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['ScheduledQueryRulesAlertV2IdentityArgs']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['ScheduledQueryRulesAlertV2IdentityArgs']]):
        pulumi.set(self, "identity", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the Azure Region where the Monitor Scheduled Query Rule should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="muteActionsAfterAlertDuration")
    def mute_actions_after_alert_duration(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Mute actions for the chosen period of time in ISO 8601 duration format after the alert is fired. Possible values are `PT5M`, `PT10M`, `PT15M`, `PT30M`, `PT45M`, `PT1H`, `PT2H`, `PT3H`, `PT4H`, `PT5H`, `PT6H`, `P1D` and `P2D`.

        > **Note:** `auto_mitigation_enabled` and `mute_actions_after_alert_duration` are mutually exclusive and cannot both be set.
        """
        return pulumi.get(self, "mute_actions_after_alert_duration")

    @mute_actions_after_alert_duration.setter
    def mute_actions_after_alert_duration(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mute_actions_after_alert_duration", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name which should be used for this Monitor Scheduled Query Rule. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="queryTimeRangeOverride")
    def query_time_range_override(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Set this if the alert evaluation period is different from the query time range. If not specified, the value is `window_duration`*`number_of_evaluation_periods`. Possible values are `PT5M`, `PT10M`, `PT15M`, `PT20M`, `PT30M`, `PT45M`, `PT1H`, `PT2H`, `PT3H`, `PT4H`, `PT5H`, `PT6H`, `P1D` and `P2D`.

        > **Note:** `query_time_range_override` cannot be less than the query look back which is `window_duration`*`number_of_evaluation_periods`.
        """
        return pulumi.get(self, "query_time_range_override")

    @query_time_range_override.setter
    def query_time_range_override(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "query_time_range_override", value)

    @_builtins.property
    @pulumi.getter(name="skipQueryValidation")
    def skip_query_validation(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies the flag which indicates whether the provided query should be validated or not. The default is false.
        """
        return pulumi.get(self, "skip_query_validation")

    @skip_query_validation.setter
    def skip_query_validation(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "skip_query_validation", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the Monitor Scheduled Query Rule.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="targetResourceTypes")
    def target_resource_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of resource type of the target resource(s) on which the alert is created/updated. For example if the scope is a resource group and targetResourceTypes is `Microsoft.Compute/virtualMachines`, then a different alert will be fired for each virtual machine in the resource group which meet the alert criteria.
        """
        return pulumi.get(self, "target_resource_types")

    @target_resource_types.setter
    def target_resource_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "target_resource_types", value)

    @_builtins.property
    @pulumi.getter(name="workspaceAlertsStorageEnabled")
    def workspace_alerts_storage_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies the flag which indicates whether this scheduled query rule check if storage is configured. Value should be `true` or `false`. The default is `false`.
        """
        return pulumi.get(self, "workspace_alerts_storage_enabled")

    @workspace_alerts_storage_enabled.setter
    def workspace_alerts_storage_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "workspace_alerts_storage_enabled", value)


@pulumi.input_type
class _ScheduledQueryRulesAlertV2State:
    def __init__(__self__, *,
                 action: Optional[pulumi.Input['ScheduledQueryRulesAlertV2ActionArgs']] = None,
                 auto_mitigation_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 created_with_api_version: Optional[pulumi.Input[_builtins.str]] = None,
                 criterias: Optional[pulumi.Input[Sequence[pulumi.Input['ScheduledQueryRulesAlertV2CriteriaArgs']]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 evaluation_frequency: Optional[pulumi.Input[_builtins.str]] = None,
                 identity: Optional[pulumi.Input['ScheduledQueryRulesAlertV2IdentityArgs']] = None,
                 is_a_legacy_log_analytics_rule: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_workspace_alerts_storage_configured: Optional[pulumi.Input[_builtins.bool]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 mute_actions_after_alert_duration: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 query_time_range_override: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 scopes: Optional[pulumi.Input[_builtins.str]] = None,
                 severity: Optional[pulumi.Input[_builtins.int]] = None,
                 skip_query_validation: Optional[pulumi.Input[_builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 target_resource_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 window_duration: Optional[pulumi.Input[_builtins.str]] = None,
                 workspace_alerts_storage_enabled: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        Input properties used for looking up and filtering ScheduledQueryRulesAlertV2 resources.
        :param pulumi.Input['ScheduledQueryRulesAlertV2ActionArgs'] action: An `action` block as defined below.
        :param pulumi.Input[_builtins.bool] auto_mitigation_enabled: Specifies the flag that indicates whether the alert should be automatically resolved or not. Value should be `true` or `false`. The default is `false`.
        :param pulumi.Input[_builtins.str] created_with_api_version: The api-version used when creating this alert rule.
        :param pulumi.Input[Sequence[pulumi.Input['ScheduledQueryRulesAlertV2CriteriaArgs']]] criterias: A `criteria` block as defined below.
        :param pulumi.Input[_builtins.str] description: Specifies the description of the scheduled query rule.
        :param pulumi.Input[_builtins.str] display_name: Specifies the display name of the alert rule.
        :param pulumi.Input[_builtins.bool] enabled: Specifies the flag which indicates whether this scheduled query rule is enabled. Value should be `true` or `false`. Defaults to `true`.
        :param pulumi.Input[_builtins.str] evaluation_frequency: How often the scheduled query rule is evaluated, represented in ISO 8601 duration format. Possible values are `PT1M`, `PT5M`, `PT10M`, `PT15M`, `PT30M`, `PT45M`, `PT1H`, `PT2H`, `PT3H`, `PT4H`, `PT5H`, `PT6H`, `P1D`.
               
               > **Note:** `evaluation_frequency` cannot be greater than the query look back which is `window_duration`*`number_of_evaluation_periods`.
               
               > **Note:** `evaluation_frequency` cannot be greater than the `mute_actions_after_alert_duration`.
        :param pulumi.Input['ScheduledQueryRulesAlertV2IdentityArgs'] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.bool] is_a_legacy_log_analytics_rule: True if this alert rule is a legacy Log Analytic Rule.
        :param pulumi.Input[_builtins.bool] is_workspace_alerts_storage_configured: The flag indicates whether this Scheduled Query Rule has been configured to be stored in the customer's storage.
        :param pulumi.Input[_builtins.str] location: Specifies the Azure Region where the Monitor Scheduled Query Rule should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] mute_actions_after_alert_duration: Mute actions for the chosen period of time in ISO 8601 duration format after the alert is fired. Possible values are `PT5M`, `PT10M`, `PT15M`, `PT30M`, `PT45M`, `PT1H`, `PT2H`, `PT3H`, `PT4H`, `PT5H`, `PT6H`, `P1D` and `P2D`.
               
               > **Note:** `auto_mitigation_enabled` and `mute_actions_after_alert_duration` are mutually exclusive and cannot both be set.
        :param pulumi.Input[_builtins.str] name: Specifies the name which should be used for this Monitor Scheduled Query Rule. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] query_time_range_override: Set this if the alert evaluation period is different from the query time range. If not specified, the value is `window_duration`*`number_of_evaluation_periods`. Possible values are `PT5M`, `PT10M`, `PT15M`, `PT20M`, `PT30M`, `PT45M`, `PT1H`, `PT2H`, `PT3H`, `PT4H`, `PT5H`, `PT6H`, `P1D` and `P2D`.
               
               > **Note:** `query_time_range_override` cannot be less than the query look back which is `window_duration`*`number_of_evaluation_periods`.
        :param pulumi.Input[_builtins.str] resource_group_name: Specifies the name of the Resource Group where the Monitor Scheduled Query Rule should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] scopes: Specifies the list of resource IDs that this scheduled query rule is scoped to. Changing this forces a new resource to be created. Currently, the API supports exactly 1 resource ID in the scopes list.
        :param pulumi.Input[_builtins.int] severity: Severity of the alert. Should be an integer between 0 and 4. Value of 0 is severest.
        :param pulumi.Input[_builtins.bool] skip_query_validation: Specifies the flag which indicates whether the provided query should be validated or not. The default is false.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Monitor Scheduled Query Rule.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] target_resource_types: List of resource type of the target resource(s) on which the alert is created/updated. For example if the scope is a resource group and targetResourceTypes is `Microsoft.Compute/virtualMachines`, then a different alert will be fired for each virtual machine in the resource group which meet the alert criteria.
        :param pulumi.Input[_builtins.str] window_duration: Specifies the period of time in ISO 8601 duration format on which the Scheduled Query Rule will be executed (bin size). If `evaluation_frequency` is `PT1M`, possible values are `PT1M`, `PT5M`, `PT10M`, `PT15M`, `PT30M`, `PT45M`, `PT1H`, `PT2H`, `PT3H`, `PT4H`, `PT5H`, and `PT6H`. Otherwise, possible values are `PT5M`, `PT10M`, `PT15M`, `PT30M`, `PT45M`, `PT1H`, `PT2H`, `PT3H`, `PT4H`, `PT5H`, `PT6H`, `P1D`, and `P2D`.
        :param pulumi.Input[_builtins.bool] workspace_alerts_storage_enabled: Specifies the flag which indicates whether this scheduled query rule check if storage is configured. Value should be `true` or `false`. The default is `false`.
        """
        if action is not None:
            pulumi.set(__self__, "action", action)
        if auto_mitigation_enabled is not None:
            pulumi.set(__self__, "auto_mitigation_enabled", auto_mitigation_enabled)
        if created_with_api_version is not None:
            pulumi.set(__self__, "created_with_api_version", created_with_api_version)
        if criterias is not None:
            pulumi.set(__self__, "criterias", criterias)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if evaluation_frequency is not None:
            pulumi.set(__self__, "evaluation_frequency", evaluation_frequency)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if is_a_legacy_log_analytics_rule is not None:
            pulumi.set(__self__, "is_a_legacy_log_analytics_rule", is_a_legacy_log_analytics_rule)
        if is_workspace_alerts_storage_configured is not None:
            pulumi.set(__self__, "is_workspace_alerts_storage_configured", is_workspace_alerts_storage_configured)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if mute_actions_after_alert_duration is not None:
            pulumi.set(__self__, "mute_actions_after_alert_duration", mute_actions_after_alert_duration)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if query_time_range_override is not None:
            pulumi.set(__self__, "query_time_range_override", query_time_range_override)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if scopes is not None:
            pulumi.set(__self__, "scopes", scopes)
        if severity is not None:
            pulumi.set(__self__, "severity", severity)
        if skip_query_validation is not None:
            pulumi.set(__self__, "skip_query_validation", skip_query_validation)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if target_resource_types is not None:
            pulumi.set(__self__, "target_resource_types", target_resource_types)
        if window_duration is not None:
            pulumi.set(__self__, "window_duration", window_duration)
        if workspace_alerts_storage_enabled is not None:
            pulumi.set(__self__, "workspace_alerts_storage_enabled", workspace_alerts_storage_enabled)

    @_builtins.property
    @pulumi.getter
    def action(self) -> Optional[pulumi.Input['ScheduledQueryRulesAlertV2ActionArgs']]:
        """
        An `action` block as defined below.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: Optional[pulumi.Input['ScheduledQueryRulesAlertV2ActionArgs']]):
        pulumi.set(self, "action", value)

    @_builtins.property
    @pulumi.getter(name="autoMitigationEnabled")
    def auto_mitigation_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies the flag that indicates whether the alert should be automatically resolved or not. Value should be `true` or `false`. The default is `false`.
        """
        return pulumi.get(self, "auto_mitigation_enabled")

    @auto_mitigation_enabled.setter
    def auto_mitigation_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_mitigation_enabled", value)

    @_builtins.property
    @pulumi.getter(name="createdWithApiVersion")
    def created_with_api_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The api-version used when creating this alert rule.
        """
        return pulumi.get(self, "created_with_api_version")

    @created_with_api_version.setter
    def created_with_api_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_with_api_version", value)

    @_builtins.property
    @pulumi.getter
    def criterias(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ScheduledQueryRulesAlertV2CriteriaArgs']]]]:
        """
        A `criteria` block as defined below.
        """
        return pulumi.get(self, "criterias")

    @criterias.setter
    def criterias(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ScheduledQueryRulesAlertV2CriteriaArgs']]]]):
        pulumi.set(self, "criterias", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the description of the scheduled query rule.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the display name of the alert rule.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies the flag which indicates whether this scheduled query rule is enabled. Value should be `true` or `false`. Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter(name="evaluationFrequency")
    def evaluation_frequency(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        How often the scheduled query rule is evaluated, represented in ISO 8601 duration format. Possible values are `PT1M`, `PT5M`, `PT10M`, `PT15M`, `PT30M`, `PT45M`, `PT1H`, `PT2H`, `PT3H`, `PT4H`, `PT5H`, `PT6H`, `P1D`.

        > **Note:** `evaluation_frequency` cannot be greater than the query look back which is `window_duration`*`number_of_evaluation_periods`.

        > **Note:** `evaluation_frequency` cannot be greater than the `mute_actions_after_alert_duration`.
        """
        return pulumi.get(self, "evaluation_frequency")

    @evaluation_frequency.setter
    def evaluation_frequency(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "evaluation_frequency", value)

    @_builtins.property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['ScheduledQueryRulesAlertV2IdentityArgs']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['ScheduledQueryRulesAlertV2IdentityArgs']]):
        pulumi.set(self, "identity", value)

    @_builtins.property
    @pulumi.getter(name="isALegacyLogAnalyticsRule")
    def is_a_legacy_log_analytics_rule(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        True if this alert rule is a legacy Log Analytic Rule.
        """
        return pulumi.get(self, "is_a_legacy_log_analytics_rule")

    @is_a_legacy_log_analytics_rule.setter
    def is_a_legacy_log_analytics_rule(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_a_legacy_log_analytics_rule", value)

    @_builtins.property
    @pulumi.getter(name="isWorkspaceAlertsStorageConfigured")
    def is_workspace_alerts_storage_configured(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        The flag indicates whether this Scheduled Query Rule has been configured to be stored in the customer's storage.
        """
        return pulumi.get(self, "is_workspace_alerts_storage_configured")

    @is_workspace_alerts_storage_configured.setter
    def is_workspace_alerts_storage_configured(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_workspace_alerts_storage_configured", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the Azure Region where the Monitor Scheduled Query Rule should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="muteActionsAfterAlertDuration")
    def mute_actions_after_alert_duration(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Mute actions for the chosen period of time in ISO 8601 duration format after the alert is fired. Possible values are `PT5M`, `PT10M`, `PT15M`, `PT30M`, `PT45M`, `PT1H`, `PT2H`, `PT3H`, `PT4H`, `PT5H`, `PT6H`, `P1D` and `P2D`.

        > **Note:** `auto_mitigation_enabled` and `mute_actions_after_alert_duration` are mutually exclusive and cannot both be set.
        """
        return pulumi.get(self, "mute_actions_after_alert_duration")

    @mute_actions_after_alert_duration.setter
    def mute_actions_after_alert_duration(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mute_actions_after_alert_duration", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name which should be used for this Monitor Scheduled Query Rule. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="queryTimeRangeOverride")
    def query_time_range_override(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Set this if the alert evaluation period is different from the query time range. If not specified, the value is `window_duration`*`number_of_evaluation_periods`. Possible values are `PT5M`, `PT10M`, `PT15M`, `PT20M`, `PT30M`, `PT45M`, `PT1H`, `PT2H`, `PT3H`, `PT4H`, `PT5H`, `PT6H`, `P1D` and `P2D`.

        > **Note:** `query_time_range_override` cannot be less than the query look back which is `window_duration`*`number_of_evaluation_periods`.
        """
        return pulumi.get(self, "query_time_range_override")

    @query_time_range_override.setter
    def query_time_range_override(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "query_time_range_override", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the Resource Group where the Monitor Scheduled Query Rule should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter
    def scopes(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the list of resource IDs that this scheduled query rule is scoped to. Changing this forces a new resource to be created. Currently, the API supports exactly 1 resource ID in the scopes list.
        """
        return pulumi.get(self, "scopes")

    @scopes.setter
    def scopes(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "scopes", value)

    @_builtins.property
    @pulumi.getter
    def severity(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Severity of the alert. Should be an integer between 0 and 4. Value of 0 is severest.
        """
        return pulumi.get(self, "severity")

    @severity.setter
    def severity(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "severity", value)

    @_builtins.property
    @pulumi.getter(name="skipQueryValidation")
    def skip_query_validation(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies the flag which indicates whether the provided query should be validated or not. The default is false.
        """
        return pulumi.get(self, "skip_query_validation")

    @skip_query_validation.setter
    def skip_query_validation(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "skip_query_validation", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the Monitor Scheduled Query Rule.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="targetResourceTypes")
    def target_resource_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of resource type of the target resource(s) on which the alert is created/updated. For example if the scope is a resource group and targetResourceTypes is `Microsoft.Compute/virtualMachines`, then a different alert will be fired for each virtual machine in the resource group which meet the alert criteria.
        """
        return pulumi.get(self, "target_resource_types")

    @target_resource_types.setter
    def target_resource_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "target_resource_types", value)

    @_builtins.property
    @pulumi.getter(name="windowDuration")
    def window_duration(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the period of time in ISO 8601 duration format on which the Scheduled Query Rule will be executed (bin size). If `evaluation_frequency` is `PT1M`, possible values are `PT1M`, `PT5M`, `PT10M`, `PT15M`, `PT30M`, `PT45M`, `PT1H`, `PT2H`, `PT3H`, `PT4H`, `PT5H`, and `PT6H`. Otherwise, possible values are `PT5M`, `PT10M`, `PT15M`, `PT30M`, `PT45M`, `PT1H`, `PT2H`, `PT3H`, `PT4H`, `PT5H`, `PT6H`, `P1D`, and `P2D`.
        """
        return pulumi.get(self, "window_duration")

    @window_duration.setter
    def window_duration(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "window_duration", value)

    @_builtins.property
    @pulumi.getter(name="workspaceAlertsStorageEnabled")
    def workspace_alerts_storage_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies the flag which indicates whether this scheduled query rule check if storage is configured. Value should be `true` or `false`. The default is `false`.
        """
        return pulumi.get(self, "workspace_alerts_storage_enabled")

    @workspace_alerts_storage_enabled.setter
    def workspace_alerts_storage_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "workspace_alerts_storage_enabled", value)


@pulumi.type_token("azure:monitoring/scheduledQueryRulesAlertV2:ScheduledQueryRulesAlertV2")
class ScheduledQueryRulesAlertV2(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action: Optional[pulumi.Input[Union['ScheduledQueryRulesAlertV2ActionArgs', 'ScheduledQueryRulesAlertV2ActionArgsDict']]] = None,
                 auto_mitigation_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 criterias: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ScheduledQueryRulesAlertV2CriteriaArgs', 'ScheduledQueryRulesAlertV2CriteriaArgsDict']]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 evaluation_frequency: Optional[pulumi.Input[_builtins.str]] = None,
                 identity: Optional[pulumi.Input[Union['ScheduledQueryRulesAlertV2IdentityArgs', 'ScheduledQueryRulesAlertV2IdentityArgsDict']]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 mute_actions_after_alert_duration: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 query_time_range_override: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 scopes: Optional[pulumi.Input[_builtins.str]] = None,
                 severity: Optional[pulumi.Input[_builtins.int]] = None,
                 skip_query_validation: Optional[pulumi.Input[_builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 target_resource_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 window_duration: Optional[pulumi.Input[_builtins.str]] = None,
                 workspace_alerts_storage_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        """
        Manages an AlertingAction Scheduled Query Rules Version 2 resource within Azure Monitor

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_insights = azure.appinsights.Insights("example",
            name="example-ai",
            location=example.location,
            resource_group_name=example.name,
            application_type="web")
        example_action_group = azure.monitoring.ActionGroup("example",
            name="example-mag",
            resource_group_name=example.name,
            short_name="test mag")
        example_user_assigned_identity = azure.authorization.UserAssignedIdentity("example",
            name="example-uai",
            location=example.location,
            resource_group_name=example.name)
        example_assignment = azure.authorization.Assignment("example",
            scope=example_insights.id,
            role_definition_name="Reader",
            principal_id=example_user_assigned_identity.principal_id)
        example_scheduled_query_rules_alert_v2 = azure.monitoring.ScheduledQueryRulesAlertV2("example",
            name="example-msqrv2",
            resource_group_name=example.name,
            location=example.location,
            evaluation_frequency="PT10M",
            window_duration="PT10M",
            scopes=example_insights.id,
            severity=4,
            criterias=[{
                "query": \"\"\"requests
          | summarize CountByCountry=count() by client_CountryOrRegion
        \"\"\",
                "time_aggregation_method": "Maximum",
                "threshold": 17.5,
                "operator": "LessThan",
                "resource_id_column": "client_CountryOrRegion",
                "metric_measure_column": "CountByCountry",
                "dimensions": [{
                    "name": "client_CountryOrRegion",
                    "operator": "Exclude",
                    "values": ["123"],
                }],
                "failing_periods": {
                    "minimum_failing_periods_to_trigger_alert": 1,
                    "number_of_evaluation_periods": 1,
                },
            }],
            auto_mitigation_enabled=True,
            workspace_alerts_storage_enabled=False,
            description="example sqr",
            display_name="example-sqr",
            enabled=True,
            query_time_range_override="PT1H",
            skip_query_validation=True,
            action={
                "action_groups": [example_action_group.id],
                "custom_properties": {
                    "key": "value",
                    "key2": "value2",
                },
            },
            identity={
                "type": "UserAssigned",
                "identity_ids": [example_user_assigned_identity.id],
            },
            tags={
                "key": "value",
                "key2": "value2",
            },
            opts = pulumi.ResourceOptions(depends_on=[example_assignment]))
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Insights`: 2023-03-15-preview

        ## Import

        Monitor Scheduled Query Rule Alert can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:monitoring/scheduledQueryRulesAlertV2:ScheduledQueryRulesAlertV2 example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resourceGroup1/providers/Microsoft.Insights/scheduledQueryRules/rule1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ScheduledQueryRulesAlertV2ActionArgs', 'ScheduledQueryRulesAlertV2ActionArgsDict']] action: An `action` block as defined below.
        :param pulumi.Input[_builtins.bool] auto_mitigation_enabled: Specifies the flag that indicates whether the alert should be automatically resolved or not. Value should be `true` or `false`. The default is `false`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ScheduledQueryRulesAlertV2CriteriaArgs', 'ScheduledQueryRulesAlertV2CriteriaArgsDict']]]] criterias: A `criteria` block as defined below.
        :param pulumi.Input[_builtins.str] description: Specifies the description of the scheduled query rule.
        :param pulumi.Input[_builtins.str] display_name: Specifies the display name of the alert rule.
        :param pulumi.Input[_builtins.bool] enabled: Specifies the flag which indicates whether this scheduled query rule is enabled. Value should be `true` or `false`. Defaults to `true`.
        :param pulumi.Input[_builtins.str] evaluation_frequency: How often the scheduled query rule is evaluated, represented in ISO 8601 duration format. Possible values are `PT1M`, `PT5M`, `PT10M`, `PT15M`, `PT30M`, `PT45M`, `PT1H`, `PT2H`, `PT3H`, `PT4H`, `PT5H`, `PT6H`, `P1D`.
               
               > **Note:** `evaluation_frequency` cannot be greater than the query look back which is `window_duration`*`number_of_evaluation_periods`.
               
               > **Note:** `evaluation_frequency` cannot be greater than the `mute_actions_after_alert_duration`.
        :param pulumi.Input[Union['ScheduledQueryRulesAlertV2IdentityArgs', 'ScheduledQueryRulesAlertV2IdentityArgsDict']] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.str] location: Specifies the Azure Region where the Monitor Scheduled Query Rule should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] mute_actions_after_alert_duration: Mute actions for the chosen period of time in ISO 8601 duration format after the alert is fired. Possible values are `PT5M`, `PT10M`, `PT15M`, `PT30M`, `PT45M`, `PT1H`, `PT2H`, `PT3H`, `PT4H`, `PT5H`, `PT6H`, `P1D` and `P2D`.
               
               > **Note:** `auto_mitigation_enabled` and `mute_actions_after_alert_duration` are mutually exclusive and cannot both be set.
        :param pulumi.Input[_builtins.str] name: Specifies the name which should be used for this Monitor Scheduled Query Rule. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] query_time_range_override: Set this if the alert evaluation period is different from the query time range. If not specified, the value is `window_duration`*`number_of_evaluation_periods`. Possible values are `PT5M`, `PT10M`, `PT15M`, `PT20M`, `PT30M`, `PT45M`, `PT1H`, `PT2H`, `PT3H`, `PT4H`, `PT5H`, `PT6H`, `P1D` and `P2D`.
               
               > **Note:** `query_time_range_override` cannot be less than the query look back which is `window_duration`*`number_of_evaluation_periods`.
        :param pulumi.Input[_builtins.str] resource_group_name: Specifies the name of the Resource Group where the Monitor Scheduled Query Rule should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] scopes: Specifies the list of resource IDs that this scheduled query rule is scoped to. Changing this forces a new resource to be created. Currently, the API supports exactly 1 resource ID in the scopes list.
        :param pulumi.Input[_builtins.int] severity: Severity of the alert. Should be an integer between 0 and 4. Value of 0 is severest.
        :param pulumi.Input[_builtins.bool] skip_query_validation: Specifies the flag which indicates whether the provided query should be validated or not. The default is false.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Monitor Scheduled Query Rule.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] target_resource_types: List of resource type of the target resource(s) on which the alert is created/updated. For example if the scope is a resource group and targetResourceTypes is `Microsoft.Compute/virtualMachines`, then a different alert will be fired for each virtual machine in the resource group which meet the alert criteria.
        :param pulumi.Input[_builtins.str] window_duration: Specifies the period of time in ISO 8601 duration format on which the Scheduled Query Rule will be executed (bin size). If `evaluation_frequency` is `PT1M`, possible values are `PT1M`, `PT5M`, `PT10M`, `PT15M`, `PT30M`, `PT45M`, `PT1H`, `PT2H`, `PT3H`, `PT4H`, `PT5H`, and `PT6H`. Otherwise, possible values are `PT5M`, `PT10M`, `PT15M`, `PT30M`, `PT45M`, `PT1H`, `PT2H`, `PT3H`, `PT4H`, `PT5H`, `PT6H`, `P1D`, and `P2D`.
        :param pulumi.Input[_builtins.bool] workspace_alerts_storage_enabled: Specifies the flag which indicates whether this scheduled query rule check if storage is configured. Value should be `true` or `false`. The default is `false`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ScheduledQueryRulesAlertV2Args,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an AlertingAction Scheduled Query Rules Version 2 resource within Azure Monitor

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_insights = azure.appinsights.Insights("example",
            name="example-ai",
            location=example.location,
            resource_group_name=example.name,
            application_type="web")
        example_action_group = azure.monitoring.ActionGroup("example",
            name="example-mag",
            resource_group_name=example.name,
            short_name="test mag")
        example_user_assigned_identity = azure.authorization.UserAssignedIdentity("example",
            name="example-uai",
            location=example.location,
            resource_group_name=example.name)
        example_assignment = azure.authorization.Assignment("example",
            scope=example_insights.id,
            role_definition_name="Reader",
            principal_id=example_user_assigned_identity.principal_id)
        example_scheduled_query_rules_alert_v2 = azure.monitoring.ScheduledQueryRulesAlertV2("example",
            name="example-msqrv2",
            resource_group_name=example.name,
            location=example.location,
            evaluation_frequency="PT10M",
            window_duration="PT10M",
            scopes=example_insights.id,
            severity=4,
            criterias=[{
                "query": \"\"\"requests
          | summarize CountByCountry=count() by client_CountryOrRegion
        \"\"\",
                "time_aggregation_method": "Maximum",
                "threshold": 17.5,
                "operator": "LessThan",
                "resource_id_column": "client_CountryOrRegion",
                "metric_measure_column": "CountByCountry",
                "dimensions": [{
                    "name": "client_CountryOrRegion",
                    "operator": "Exclude",
                    "values": ["123"],
                }],
                "failing_periods": {
                    "minimum_failing_periods_to_trigger_alert": 1,
                    "number_of_evaluation_periods": 1,
                },
            }],
            auto_mitigation_enabled=True,
            workspace_alerts_storage_enabled=False,
            description="example sqr",
            display_name="example-sqr",
            enabled=True,
            query_time_range_override="PT1H",
            skip_query_validation=True,
            action={
                "action_groups": [example_action_group.id],
                "custom_properties": {
                    "key": "value",
                    "key2": "value2",
                },
            },
            identity={
                "type": "UserAssigned",
                "identity_ids": [example_user_assigned_identity.id],
            },
            tags={
                "key": "value",
                "key2": "value2",
            },
            opts = pulumi.ResourceOptions(depends_on=[example_assignment]))
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Insights`: 2023-03-15-preview

        ## Import

        Monitor Scheduled Query Rule Alert can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:monitoring/scheduledQueryRulesAlertV2:ScheduledQueryRulesAlertV2 example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resourceGroup1/providers/Microsoft.Insights/scheduledQueryRules/rule1
        ```

        :param str resource_name: The name of the resource.
        :param ScheduledQueryRulesAlertV2Args args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ScheduledQueryRulesAlertV2Args, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action: Optional[pulumi.Input[Union['ScheduledQueryRulesAlertV2ActionArgs', 'ScheduledQueryRulesAlertV2ActionArgsDict']]] = None,
                 auto_mitigation_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 criterias: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ScheduledQueryRulesAlertV2CriteriaArgs', 'ScheduledQueryRulesAlertV2CriteriaArgsDict']]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 evaluation_frequency: Optional[pulumi.Input[_builtins.str]] = None,
                 identity: Optional[pulumi.Input[Union['ScheduledQueryRulesAlertV2IdentityArgs', 'ScheduledQueryRulesAlertV2IdentityArgsDict']]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 mute_actions_after_alert_duration: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 query_time_range_override: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 scopes: Optional[pulumi.Input[_builtins.str]] = None,
                 severity: Optional[pulumi.Input[_builtins.int]] = None,
                 skip_query_validation: Optional[pulumi.Input[_builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 target_resource_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 window_duration: Optional[pulumi.Input[_builtins.str]] = None,
                 workspace_alerts_storage_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ScheduledQueryRulesAlertV2Args.__new__(ScheduledQueryRulesAlertV2Args)

            __props__.__dict__["action"] = action
            __props__.__dict__["auto_mitigation_enabled"] = auto_mitigation_enabled
            if criterias is None and not opts.urn:
                raise TypeError("Missing required property 'criterias'")
            __props__.__dict__["criterias"] = criterias
            __props__.__dict__["description"] = description
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["enabled"] = enabled
            if evaluation_frequency is None and not opts.urn:
                raise TypeError("Missing required property 'evaluation_frequency'")
            __props__.__dict__["evaluation_frequency"] = evaluation_frequency
            __props__.__dict__["identity"] = identity
            __props__.__dict__["location"] = location
            __props__.__dict__["mute_actions_after_alert_duration"] = mute_actions_after_alert_duration
            __props__.__dict__["name"] = name
            __props__.__dict__["query_time_range_override"] = query_time_range_override
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            if scopes is None and not opts.urn:
                raise TypeError("Missing required property 'scopes'")
            __props__.__dict__["scopes"] = scopes
            if severity is None and not opts.urn:
                raise TypeError("Missing required property 'severity'")
            __props__.__dict__["severity"] = severity
            __props__.__dict__["skip_query_validation"] = skip_query_validation
            __props__.__dict__["tags"] = tags
            __props__.__dict__["target_resource_types"] = target_resource_types
            if window_duration is None and not opts.urn:
                raise TypeError("Missing required property 'window_duration'")
            __props__.__dict__["window_duration"] = window_duration
            __props__.__dict__["workspace_alerts_storage_enabled"] = workspace_alerts_storage_enabled
            __props__.__dict__["created_with_api_version"] = None
            __props__.__dict__["is_a_legacy_log_analytics_rule"] = None
            __props__.__dict__["is_workspace_alerts_storage_configured"] = None
        super(ScheduledQueryRulesAlertV2, __self__).__init__(
            'azure:monitoring/scheduledQueryRulesAlertV2:ScheduledQueryRulesAlertV2',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            action: Optional[pulumi.Input[Union['ScheduledQueryRulesAlertV2ActionArgs', 'ScheduledQueryRulesAlertV2ActionArgsDict']]] = None,
            auto_mitigation_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            created_with_api_version: Optional[pulumi.Input[_builtins.str]] = None,
            criterias: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ScheduledQueryRulesAlertV2CriteriaArgs', 'ScheduledQueryRulesAlertV2CriteriaArgsDict']]]]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            evaluation_frequency: Optional[pulumi.Input[_builtins.str]] = None,
            identity: Optional[pulumi.Input[Union['ScheduledQueryRulesAlertV2IdentityArgs', 'ScheduledQueryRulesAlertV2IdentityArgsDict']]] = None,
            is_a_legacy_log_analytics_rule: Optional[pulumi.Input[_builtins.bool]] = None,
            is_workspace_alerts_storage_configured: Optional[pulumi.Input[_builtins.bool]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            mute_actions_after_alert_duration: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            query_time_range_override: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            scopes: Optional[pulumi.Input[_builtins.str]] = None,
            severity: Optional[pulumi.Input[_builtins.int]] = None,
            skip_query_validation: Optional[pulumi.Input[_builtins.bool]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            target_resource_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            window_duration: Optional[pulumi.Input[_builtins.str]] = None,
            workspace_alerts_storage_enabled: Optional[pulumi.Input[_builtins.bool]] = None) -> 'ScheduledQueryRulesAlertV2':
        """
        Get an existing ScheduledQueryRulesAlertV2 resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ScheduledQueryRulesAlertV2ActionArgs', 'ScheduledQueryRulesAlertV2ActionArgsDict']] action: An `action` block as defined below.
        :param pulumi.Input[_builtins.bool] auto_mitigation_enabled: Specifies the flag that indicates whether the alert should be automatically resolved or not. Value should be `true` or `false`. The default is `false`.
        :param pulumi.Input[_builtins.str] created_with_api_version: The api-version used when creating this alert rule.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ScheduledQueryRulesAlertV2CriteriaArgs', 'ScheduledQueryRulesAlertV2CriteriaArgsDict']]]] criterias: A `criteria` block as defined below.
        :param pulumi.Input[_builtins.str] description: Specifies the description of the scheduled query rule.
        :param pulumi.Input[_builtins.str] display_name: Specifies the display name of the alert rule.
        :param pulumi.Input[_builtins.bool] enabled: Specifies the flag which indicates whether this scheduled query rule is enabled. Value should be `true` or `false`. Defaults to `true`.
        :param pulumi.Input[_builtins.str] evaluation_frequency: How often the scheduled query rule is evaluated, represented in ISO 8601 duration format. Possible values are `PT1M`, `PT5M`, `PT10M`, `PT15M`, `PT30M`, `PT45M`, `PT1H`, `PT2H`, `PT3H`, `PT4H`, `PT5H`, `PT6H`, `P1D`.
               
               > **Note:** `evaluation_frequency` cannot be greater than the query look back which is `window_duration`*`number_of_evaluation_periods`.
               
               > **Note:** `evaluation_frequency` cannot be greater than the `mute_actions_after_alert_duration`.
        :param pulumi.Input[Union['ScheduledQueryRulesAlertV2IdentityArgs', 'ScheduledQueryRulesAlertV2IdentityArgsDict']] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.bool] is_a_legacy_log_analytics_rule: True if this alert rule is a legacy Log Analytic Rule.
        :param pulumi.Input[_builtins.bool] is_workspace_alerts_storage_configured: The flag indicates whether this Scheduled Query Rule has been configured to be stored in the customer's storage.
        :param pulumi.Input[_builtins.str] location: Specifies the Azure Region where the Monitor Scheduled Query Rule should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] mute_actions_after_alert_duration: Mute actions for the chosen period of time in ISO 8601 duration format after the alert is fired. Possible values are `PT5M`, `PT10M`, `PT15M`, `PT30M`, `PT45M`, `PT1H`, `PT2H`, `PT3H`, `PT4H`, `PT5H`, `PT6H`, `P1D` and `P2D`.
               
               > **Note:** `auto_mitigation_enabled` and `mute_actions_after_alert_duration` are mutually exclusive and cannot both be set.
        :param pulumi.Input[_builtins.str] name: Specifies the name which should be used for this Monitor Scheduled Query Rule. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] query_time_range_override: Set this if the alert evaluation period is different from the query time range. If not specified, the value is `window_duration`*`number_of_evaluation_periods`. Possible values are `PT5M`, `PT10M`, `PT15M`, `PT20M`, `PT30M`, `PT45M`, `PT1H`, `PT2H`, `PT3H`, `PT4H`, `PT5H`, `PT6H`, `P1D` and `P2D`.
               
               > **Note:** `query_time_range_override` cannot be less than the query look back which is `window_duration`*`number_of_evaluation_periods`.
        :param pulumi.Input[_builtins.str] resource_group_name: Specifies the name of the Resource Group where the Monitor Scheduled Query Rule should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] scopes: Specifies the list of resource IDs that this scheduled query rule is scoped to. Changing this forces a new resource to be created. Currently, the API supports exactly 1 resource ID in the scopes list.
        :param pulumi.Input[_builtins.int] severity: Severity of the alert. Should be an integer between 0 and 4. Value of 0 is severest.
        :param pulumi.Input[_builtins.bool] skip_query_validation: Specifies the flag which indicates whether the provided query should be validated or not. The default is false.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Monitor Scheduled Query Rule.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] target_resource_types: List of resource type of the target resource(s) on which the alert is created/updated. For example if the scope is a resource group and targetResourceTypes is `Microsoft.Compute/virtualMachines`, then a different alert will be fired for each virtual machine in the resource group which meet the alert criteria.
        :param pulumi.Input[_builtins.str] window_duration: Specifies the period of time in ISO 8601 duration format on which the Scheduled Query Rule will be executed (bin size). If `evaluation_frequency` is `PT1M`, possible values are `PT1M`, `PT5M`, `PT10M`, `PT15M`, `PT30M`, `PT45M`, `PT1H`, `PT2H`, `PT3H`, `PT4H`, `PT5H`, and `PT6H`. Otherwise, possible values are `PT5M`, `PT10M`, `PT15M`, `PT30M`, `PT45M`, `PT1H`, `PT2H`, `PT3H`, `PT4H`, `PT5H`, `PT6H`, `P1D`, and `P2D`.
        :param pulumi.Input[_builtins.bool] workspace_alerts_storage_enabled: Specifies the flag which indicates whether this scheduled query rule check if storage is configured. Value should be `true` or `false`. The default is `false`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ScheduledQueryRulesAlertV2State.__new__(_ScheduledQueryRulesAlertV2State)

        __props__.__dict__["action"] = action
        __props__.__dict__["auto_mitigation_enabled"] = auto_mitigation_enabled
        __props__.__dict__["created_with_api_version"] = created_with_api_version
        __props__.__dict__["criterias"] = criterias
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["evaluation_frequency"] = evaluation_frequency
        __props__.__dict__["identity"] = identity
        __props__.__dict__["is_a_legacy_log_analytics_rule"] = is_a_legacy_log_analytics_rule
        __props__.__dict__["is_workspace_alerts_storage_configured"] = is_workspace_alerts_storage_configured
        __props__.__dict__["location"] = location
        __props__.__dict__["mute_actions_after_alert_duration"] = mute_actions_after_alert_duration
        __props__.__dict__["name"] = name
        __props__.__dict__["query_time_range_override"] = query_time_range_override
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["scopes"] = scopes
        __props__.__dict__["severity"] = severity
        __props__.__dict__["skip_query_validation"] = skip_query_validation
        __props__.__dict__["tags"] = tags
        __props__.__dict__["target_resource_types"] = target_resource_types
        __props__.__dict__["window_duration"] = window_duration
        __props__.__dict__["workspace_alerts_storage_enabled"] = workspace_alerts_storage_enabled
        return ScheduledQueryRulesAlertV2(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def action(self) -> pulumi.Output[Optional['outputs.ScheduledQueryRulesAlertV2Action']]:
        """
        An `action` block as defined below.
        """
        return pulumi.get(self, "action")

    @_builtins.property
    @pulumi.getter(name="autoMitigationEnabled")
    def auto_mitigation_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies the flag that indicates whether the alert should be automatically resolved or not. Value should be `true` or `false`. The default is `false`.
        """
        return pulumi.get(self, "auto_mitigation_enabled")

    @_builtins.property
    @pulumi.getter(name="createdWithApiVersion")
    def created_with_api_version(self) -> pulumi.Output[_builtins.str]:
        """
        The api-version used when creating this alert rule.
        """
        return pulumi.get(self, "created_with_api_version")

    @_builtins.property
    @pulumi.getter
    def criterias(self) -> pulumi.Output[Sequence['outputs.ScheduledQueryRulesAlertV2Criteria']]:
        """
        A `criteria` block as defined below.
        """
        return pulumi.get(self, "criterias")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the description of the scheduled query rule.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the display name of the alert rule.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies the flag which indicates whether this scheduled query rule is enabled. Value should be `true` or `false`. Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="evaluationFrequency")
    def evaluation_frequency(self) -> pulumi.Output[_builtins.str]:
        """
        How often the scheduled query rule is evaluated, represented in ISO 8601 duration format. Possible values are `PT1M`, `PT5M`, `PT10M`, `PT15M`, `PT30M`, `PT45M`, `PT1H`, `PT2H`, `PT3H`, `PT4H`, `PT5H`, `PT6H`, `P1D`.

        > **Note:** `evaluation_frequency` cannot be greater than the query look back which is `window_duration`*`number_of_evaluation_periods`.

        > **Note:** `evaluation_frequency` cannot be greater than the `mute_actions_after_alert_duration`.
        """
        return pulumi.get(self, "evaluation_frequency")

    @_builtins.property
    @pulumi.getter
    def identity(self) -> pulumi.Output[Optional['outputs.ScheduledQueryRulesAlertV2Identity']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @_builtins.property
    @pulumi.getter(name="isALegacyLogAnalyticsRule")
    def is_a_legacy_log_analytics_rule(self) -> pulumi.Output[_builtins.bool]:
        """
        True if this alert rule is a legacy Log Analytic Rule.
        """
        return pulumi.get(self, "is_a_legacy_log_analytics_rule")

    @_builtins.property
    @pulumi.getter(name="isWorkspaceAlertsStorageConfigured")
    def is_workspace_alerts_storage_configured(self) -> pulumi.Output[_builtins.bool]:
        """
        The flag indicates whether this Scheduled Query Rule has been configured to be stored in the customer's storage.
        """
        return pulumi.get(self, "is_workspace_alerts_storage_configured")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the Azure Region where the Monitor Scheduled Query Rule should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter(name="muteActionsAfterAlertDuration")
    def mute_actions_after_alert_duration(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Mute actions for the chosen period of time in ISO 8601 duration format after the alert is fired. Possible values are `PT5M`, `PT10M`, `PT15M`, `PT30M`, `PT45M`, `PT1H`, `PT2H`, `PT3H`, `PT4H`, `PT5H`, `PT6H`, `P1D` and `P2D`.

        > **Note:** `auto_mitigation_enabled` and `mute_actions_after_alert_duration` are mutually exclusive and cannot both be set.
        """
        return pulumi.get(self, "mute_actions_after_alert_duration")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name which should be used for this Monitor Scheduled Query Rule. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="queryTimeRangeOverride")
    def query_time_range_override(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Set this if the alert evaluation period is different from the query time range. If not specified, the value is `window_duration`*`number_of_evaluation_periods`. Possible values are `PT5M`, `PT10M`, `PT15M`, `PT20M`, `PT30M`, `PT45M`, `PT1H`, `PT2H`, `PT3H`, `PT4H`, `PT5H`, `PT6H`, `P1D` and `P2D`.

        > **Note:** `query_time_range_override` cannot be less than the query look back which is `window_duration`*`number_of_evaluation_periods`.
        """
        return pulumi.get(self, "query_time_range_override")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of the Resource Group where the Monitor Scheduled Query Rule should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter
    def scopes(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the list of resource IDs that this scheduled query rule is scoped to. Changing this forces a new resource to be created. Currently, the API supports exactly 1 resource ID in the scopes list.
        """
        return pulumi.get(self, "scopes")

    @_builtins.property
    @pulumi.getter
    def severity(self) -> pulumi.Output[_builtins.int]:
        """
        Severity of the alert. Should be an integer between 0 and 4. Value of 0 is severest.
        """
        return pulumi.get(self, "severity")

    @_builtins.property
    @pulumi.getter(name="skipQueryValidation")
    def skip_query_validation(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies the flag which indicates whether the provided query should be validated or not. The default is false.
        """
        return pulumi.get(self, "skip_query_validation")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags which should be assigned to the Monitor Scheduled Query Rule.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="targetResourceTypes")
    def target_resource_types(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of resource type of the target resource(s) on which the alert is created/updated. For example if the scope is a resource group and targetResourceTypes is `Microsoft.Compute/virtualMachines`, then a different alert will be fired for each virtual machine in the resource group which meet the alert criteria.
        """
        return pulumi.get(self, "target_resource_types")

    @_builtins.property
    @pulumi.getter(name="windowDuration")
    def window_duration(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the period of time in ISO 8601 duration format on which the Scheduled Query Rule will be executed (bin size). If `evaluation_frequency` is `PT1M`, possible values are `PT1M`, `PT5M`, `PT10M`, `PT15M`, `PT30M`, `PT45M`, `PT1H`, `PT2H`, `PT3H`, `PT4H`, `PT5H`, and `PT6H`. Otherwise, possible values are `PT5M`, `PT10M`, `PT15M`, `PT30M`, `PT45M`, `PT1H`, `PT2H`, `PT3H`, `PT4H`, `PT5H`, `PT6H`, `P1D`, and `P2D`.
        """
        return pulumi.get(self, "window_duration")

    @_builtins.property
    @pulumi.getter(name="workspaceAlertsStorageEnabled")
    def workspace_alerts_storage_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies the flag which indicates whether this scheduled query rule check if storage is configured. Value should be `true` or `false`. The default is `false`.
        """
        return pulumi.get(self, "workspace_alerts_storage_enabled")

