# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'DatabaseIdentityArgs',
    'DatabaseIdentityArgsDict',
    'DatabaseImportArgs',
    'DatabaseImportArgsDict',
    'DatabaseLongTermRetentionPolicyArgs',
    'DatabaseLongTermRetentionPolicyArgsDict',
    'DatabaseShortTermRetentionPolicyArgs',
    'DatabaseShortTermRetentionPolicyArgsDict',
    'DatabaseThreatDetectionPolicyArgs',
    'DatabaseThreatDetectionPolicyArgsDict',
    'DatabaseVulnerabilityAssessmentRuleBaselineBaselineResultArgs',
    'DatabaseVulnerabilityAssessmentRuleBaselineBaselineResultArgsDict',
    'ElasticPoolPerDatabaseSettingsArgs',
    'ElasticPoolPerDatabaseSettingsArgsDict',
    'ElasticPoolSkuArgs',
    'ElasticPoolSkuArgsDict',
    'FailoverGroupPartnerServerArgs',
    'FailoverGroupPartnerServerArgsDict',
    'FailoverGroupReadWriteEndpointFailoverPolicyArgs',
    'FailoverGroupReadWriteEndpointFailoverPolicyArgsDict',
    'JobAgentIdentityArgs',
    'JobAgentIdentityArgsDict',
    'JobStepOutputTargetArgs',
    'JobStepOutputTargetArgsDict',
    'JobTargetGroupJobTargetArgs',
    'JobTargetGroupJobTargetArgsDict',
    'ManagedDatabaseLongTermRetentionPolicyArgs',
    'ManagedDatabaseLongTermRetentionPolicyArgsDict',
    'ManagedDatabasePointInTimeRestoreArgs',
    'ManagedDatabasePointInTimeRestoreArgsDict',
    'ManagedInstanceAzureActiveDirectoryAdministratorArgs',
    'ManagedInstanceAzureActiveDirectoryAdministratorArgsDict',
    'ManagedInstanceFailoverGroupPartnerRegionArgs',
    'ManagedInstanceFailoverGroupPartnerRegionArgsDict',
    'ManagedInstanceFailoverGroupReadWriteEndpointFailoverPolicyArgs',
    'ManagedInstanceFailoverGroupReadWriteEndpointFailoverPolicyArgsDict',
    'ManagedInstanceIdentityArgs',
    'ManagedInstanceIdentityArgsDict',
    'ManagedInstanceVulnerabilityAssessmentRecurringScansArgs',
    'ManagedInstanceVulnerabilityAssessmentRecurringScansArgsDict',
    'ServerAzureadAdministratorArgs',
    'ServerAzureadAdministratorArgsDict',
    'ServerIdentityArgs',
    'ServerIdentityArgsDict',
    'ServerVulnerabilityAssessmentRecurringScansArgs',
    'ServerVulnerabilityAssessmentRecurringScansArgsDict',
    'VirtualMachineAssessmentArgs',
    'VirtualMachineAssessmentArgsDict',
    'VirtualMachineAssessmentScheduleArgs',
    'VirtualMachineAssessmentScheduleArgsDict',
    'VirtualMachineAutoBackupArgs',
    'VirtualMachineAutoBackupArgsDict',
    'VirtualMachineAutoBackupManualScheduleArgs',
    'VirtualMachineAutoBackupManualScheduleArgsDict',
    'VirtualMachineAutoPatchingArgs',
    'VirtualMachineAutoPatchingArgsDict',
    'VirtualMachineAvailabilityGroupListenerLoadBalancerConfigurationArgs',
    'VirtualMachineAvailabilityGroupListenerLoadBalancerConfigurationArgsDict',
    'VirtualMachineAvailabilityGroupListenerMultiSubnetIpConfigurationArgs',
    'VirtualMachineAvailabilityGroupListenerMultiSubnetIpConfigurationArgsDict',
    'VirtualMachineAvailabilityGroupListenerReplicaArgs',
    'VirtualMachineAvailabilityGroupListenerReplicaArgsDict',
    'VirtualMachineGroupWsfcDomainProfileArgs',
    'VirtualMachineGroupWsfcDomainProfileArgsDict',
    'VirtualMachineKeyVaultCredentialArgs',
    'VirtualMachineKeyVaultCredentialArgsDict',
    'VirtualMachineSqlInstanceArgs',
    'VirtualMachineSqlInstanceArgsDict',
    'VirtualMachineStorageConfigurationArgs',
    'VirtualMachineStorageConfigurationArgsDict',
    'VirtualMachineStorageConfigurationDataSettingsArgs',
    'VirtualMachineStorageConfigurationDataSettingsArgsDict',
    'VirtualMachineStorageConfigurationLogSettingsArgs',
    'VirtualMachineStorageConfigurationLogSettingsArgsDict',
    'VirtualMachineStorageConfigurationTempDbSettingsArgs',
    'VirtualMachineStorageConfigurationTempDbSettingsArgsDict',
    'VirtualMachineWsfcDomainCredentialArgs',
    'VirtualMachineWsfcDomainCredentialArgsDict',
]

MYPY = False

if not MYPY:
    class DatabaseIdentityArgsDict(TypedDict):
        identity_ids: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]
        """
        Specifies a list of User Assigned Managed Identity IDs to be assigned to this SQL Database.
        """
        type: pulumi.Input[_builtins.str]
        """
        Specifies the type of Managed Service Identity that should be configured on this SQL Database. Possible value is `UserAssigned`.
        """
elif False:
    DatabaseIdentityArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DatabaseIdentityArgs:
    def __init__(__self__, *,
                 identity_ids: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 type: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] identity_ids: Specifies a list of User Assigned Managed Identity IDs to be assigned to this SQL Database.
        :param pulumi.Input[_builtins.str] type: Specifies the type of Managed Service Identity that should be configured on this SQL Database. Possible value is `UserAssigned`.
        """
        pulumi.set(__self__, "identity_ids", identity_ids)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="identityIds")
    def identity_ids(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        Specifies a list of User Assigned Managed Identity IDs to be assigned to this SQL Database.
        """
        return pulumi.get(self, "identity_ids")

    @identity_ids.setter
    def identity_ids(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "identity_ids", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the type of Managed Service Identity that should be configured on this SQL Database. Possible value is `UserAssigned`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)


if not MYPY:
    class DatabaseImportArgsDict(TypedDict):
        administrator_login: pulumi.Input[_builtins.str]
        """
        Specifies the name of the SQL administrator.
        """
        administrator_login_password: pulumi.Input[_builtins.str]
        """
        Specifies the password of the SQL administrator.
        """
        authentication_type: pulumi.Input[_builtins.str]
        """
        Specifies the type of authentication used to access the server. Valid values are `SQL` or `ADPassword`.
        """
        storage_key: pulumi.Input[_builtins.str]
        """
        Specifies the access key for the storage account.
        """
        storage_key_type: pulumi.Input[_builtins.str]
        """
        Specifies the type of access key for the storage account. Valid values are `StorageAccessKey` or `SharedAccessKey`.
        """
        storage_uri: pulumi.Input[_builtins.str]
        """
        Specifies the blob URI of the .bacpac file.
        """
        storage_account_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The resource id for the storage account used to store BACPAC file. If set, private endpoint connection will be created for the storage account. Must match storage account used for storage_uri parameter.
        """
elif False:
    DatabaseImportArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DatabaseImportArgs:
    def __init__(__self__, *,
                 administrator_login: pulumi.Input[_builtins.str],
                 administrator_login_password: pulumi.Input[_builtins.str],
                 authentication_type: pulumi.Input[_builtins.str],
                 storage_key: pulumi.Input[_builtins.str],
                 storage_key_type: pulumi.Input[_builtins.str],
                 storage_uri: pulumi.Input[_builtins.str],
                 storage_account_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] administrator_login: Specifies the name of the SQL administrator.
        :param pulumi.Input[_builtins.str] administrator_login_password: Specifies the password of the SQL administrator.
        :param pulumi.Input[_builtins.str] authentication_type: Specifies the type of authentication used to access the server. Valid values are `SQL` or `ADPassword`.
        :param pulumi.Input[_builtins.str] storage_key: Specifies the access key for the storage account.
        :param pulumi.Input[_builtins.str] storage_key_type: Specifies the type of access key for the storage account. Valid values are `StorageAccessKey` or `SharedAccessKey`.
        :param pulumi.Input[_builtins.str] storage_uri: Specifies the blob URI of the .bacpac file.
        :param pulumi.Input[_builtins.str] storage_account_id: The resource id for the storage account used to store BACPAC file. If set, private endpoint connection will be created for the storage account. Must match storage account used for storage_uri parameter.
        """
        pulumi.set(__self__, "administrator_login", administrator_login)
        pulumi.set(__self__, "administrator_login_password", administrator_login_password)
        pulumi.set(__self__, "authentication_type", authentication_type)
        pulumi.set(__self__, "storage_key", storage_key)
        pulumi.set(__self__, "storage_key_type", storage_key_type)
        pulumi.set(__self__, "storage_uri", storage_uri)
        if storage_account_id is not None:
            pulumi.set(__self__, "storage_account_id", storage_account_id)

    @_builtins.property
    @pulumi.getter(name="administratorLogin")
    def administrator_login(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the name of the SQL administrator.
        """
        return pulumi.get(self, "administrator_login")

    @administrator_login.setter
    def administrator_login(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "administrator_login", value)

    @_builtins.property
    @pulumi.getter(name="administratorLoginPassword")
    def administrator_login_password(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the password of the SQL administrator.
        """
        return pulumi.get(self, "administrator_login_password")

    @administrator_login_password.setter
    def administrator_login_password(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "administrator_login_password", value)

    @_builtins.property
    @pulumi.getter(name="authenticationType")
    def authentication_type(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the type of authentication used to access the server. Valid values are `SQL` or `ADPassword`.
        """
        return pulumi.get(self, "authentication_type")

    @authentication_type.setter
    def authentication_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "authentication_type", value)

    @_builtins.property
    @pulumi.getter(name="storageKey")
    def storage_key(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the access key for the storage account.
        """
        return pulumi.get(self, "storage_key")

    @storage_key.setter
    def storage_key(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "storage_key", value)

    @_builtins.property
    @pulumi.getter(name="storageKeyType")
    def storage_key_type(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the type of access key for the storage account. Valid values are `StorageAccessKey` or `SharedAccessKey`.
        """
        return pulumi.get(self, "storage_key_type")

    @storage_key_type.setter
    def storage_key_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "storage_key_type", value)

    @_builtins.property
    @pulumi.getter(name="storageUri")
    def storage_uri(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the blob URI of the .bacpac file.
        """
        return pulumi.get(self, "storage_uri")

    @storage_uri.setter
    def storage_uri(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "storage_uri", value)

    @_builtins.property
    @pulumi.getter(name="storageAccountId")
    def storage_account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource id for the storage account used to store BACPAC file. If set, private endpoint connection will be created for the storage account. Must match storage account used for storage_uri parameter.
        """
        return pulumi.get(self, "storage_account_id")

    @storage_account_id.setter
    def storage_account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_account_id", value)


if not MYPY:
    class DatabaseLongTermRetentionPolicyArgsDict(TypedDict):
        immutable_backups_enabled: NotRequired[pulumi.Input[_builtins.bool]]
        monthly_retention: NotRequired[pulumi.Input[_builtins.str]]
        """
        The monthly retention policy for an LTR backup in an ISO 8601 format. Valid value is between 1 to 120 months. e.g. `P1Y`, `P1M`, `P4W` or `P30D`. Defaults to `PT0S`.
        """
        week_of_year: NotRequired[pulumi.Input[_builtins.int]]
        """
        The week of year to take the yearly backup. Value has to be between `1` and `52`.
        """
        weekly_retention: NotRequired[pulumi.Input[_builtins.str]]
        """
        The weekly retention policy for an LTR backup in an ISO 8601 format. Valid value is between 1 to 520 weeks. e.g. `P1Y`, `P1M`, `P1W` or `P7D`. Defaults to `PT0S`.
        """
        yearly_retention: NotRequired[pulumi.Input[_builtins.str]]
        """
        The yearly retention policy for an LTR backup in an ISO 8601 format. Valid value is between 1 to 10 years. e.g. `P1Y`, `P12M`, `P52W` or `P365D`. Defaults to `PT0S`.
        """
elif False:
    DatabaseLongTermRetentionPolicyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DatabaseLongTermRetentionPolicyArgs:
    def __init__(__self__, *,
                 immutable_backups_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 monthly_retention: Optional[pulumi.Input[_builtins.str]] = None,
                 week_of_year: Optional[pulumi.Input[_builtins.int]] = None,
                 weekly_retention: Optional[pulumi.Input[_builtins.str]] = None,
                 yearly_retention: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] monthly_retention: The monthly retention policy for an LTR backup in an ISO 8601 format. Valid value is between 1 to 120 months. e.g. `P1Y`, `P1M`, `P4W` or `P30D`. Defaults to `PT0S`.
        :param pulumi.Input[_builtins.int] week_of_year: The week of year to take the yearly backup. Value has to be between `1` and `52`.
        :param pulumi.Input[_builtins.str] weekly_retention: The weekly retention policy for an LTR backup in an ISO 8601 format. Valid value is between 1 to 520 weeks. e.g. `P1Y`, `P1M`, `P1W` or `P7D`. Defaults to `PT0S`.
        :param pulumi.Input[_builtins.str] yearly_retention: The yearly retention policy for an LTR backup in an ISO 8601 format. Valid value is between 1 to 10 years. e.g. `P1Y`, `P12M`, `P52W` or `P365D`. Defaults to `PT0S`.
        """
        if immutable_backups_enabled is not None:
            pulumi.set(__self__, "immutable_backups_enabled", immutable_backups_enabled)
        if monthly_retention is not None:
            pulumi.set(__self__, "monthly_retention", monthly_retention)
        if week_of_year is not None:
            pulumi.set(__self__, "week_of_year", week_of_year)
        if weekly_retention is not None:
            pulumi.set(__self__, "weekly_retention", weekly_retention)
        if yearly_retention is not None:
            pulumi.set(__self__, "yearly_retention", yearly_retention)

    @_builtins.property
    @pulumi.getter(name="immutableBackupsEnabled")
    def immutable_backups_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "immutable_backups_enabled")

    @immutable_backups_enabled.setter
    def immutable_backups_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "immutable_backups_enabled", value)

    @_builtins.property
    @pulumi.getter(name="monthlyRetention")
    def monthly_retention(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The monthly retention policy for an LTR backup in an ISO 8601 format. Valid value is between 1 to 120 months. e.g. `P1Y`, `P1M`, `P4W` or `P30D`. Defaults to `PT0S`.
        """
        return pulumi.get(self, "monthly_retention")

    @monthly_retention.setter
    def monthly_retention(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "monthly_retention", value)

    @_builtins.property
    @pulumi.getter(name="weekOfYear")
    def week_of_year(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The week of year to take the yearly backup. Value has to be between `1` and `52`.
        """
        return pulumi.get(self, "week_of_year")

    @week_of_year.setter
    def week_of_year(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "week_of_year", value)

    @_builtins.property
    @pulumi.getter(name="weeklyRetention")
    def weekly_retention(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The weekly retention policy for an LTR backup in an ISO 8601 format. Valid value is between 1 to 520 weeks. e.g. `P1Y`, `P1M`, `P1W` or `P7D`. Defaults to `PT0S`.
        """
        return pulumi.get(self, "weekly_retention")

    @weekly_retention.setter
    def weekly_retention(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "weekly_retention", value)

    @_builtins.property
    @pulumi.getter(name="yearlyRetention")
    def yearly_retention(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The yearly retention policy for an LTR backup in an ISO 8601 format. Valid value is between 1 to 10 years. e.g. `P1Y`, `P12M`, `P52W` or `P365D`. Defaults to `PT0S`.
        """
        return pulumi.get(self, "yearly_retention")

    @yearly_retention.setter
    def yearly_retention(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "yearly_retention", value)


if not MYPY:
    class DatabaseShortTermRetentionPolicyArgsDict(TypedDict):
        retention_days: pulumi.Input[_builtins.int]
        """
        Point In Time Restore configuration. Value has to be between `1` and `35`.
        """
        backup_interval_in_hours: NotRequired[pulumi.Input[_builtins.int]]
        """
        The hours between each differential backup. This is only applicable to live databases but not dropped databases. Value has to be `12` or `24`. Defaults to `12` hours.
        """
elif False:
    DatabaseShortTermRetentionPolicyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DatabaseShortTermRetentionPolicyArgs:
    def __init__(__self__, *,
                 retention_days: pulumi.Input[_builtins.int],
                 backup_interval_in_hours: Optional[pulumi.Input[_builtins.int]] = None):
        """
        :param pulumi.Input[_builtins.int] retention_days: Point In Time Restore configuration. Value has to be between `1` and `35`.
        :param pulumi.Input[_builtins.int] backup_interval_in_hours: The hours between each differential backup. This is only applicable to live databases but not dropped databases. Value has to be `12` or `24`. Defaults to `12` hours.
        """
        pulumi.set(__self__, "retention_days", retention_days)
        if backup_interval_in_hours is not None:
            pulumi.set(__self__, "backup_interval_in_hours", backup_interval_in_hours)

    @_builtins.property
    @pulumi.getter(name="retentionDays")
    def retention_days(self) -> pulumi.Input[_builtins.int]:
        """
        Point In Time Restore configuration. Value has to be between `1` and `35`.
        """
        return pulumi.get(self, "retention_days")

    @retention_days.setter
    def retention_days(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "retention_days", value)

    @_builtins.property
    @pulumi.getter(name="backupIntervalInHours")
    def backup_interval_in_hours(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The hours between each differential backup. This is only applicable to live databases but not dropped databases. Value has to be `12` or `24`. Defaults to `12` hours.
        """
        return pulumi.get(self, "backup_interval_in_hours")

    @backup_interval_in_hours.setter
    def backup_interval_in_hours(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "backup_interval_in_hours", value)


if not MYPY:
    class DatabaseThreatDetectionPolicyArgsDict(TypedDict):
        disabled_alerts: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        Specifies a list of alerts which should be disabled. Possible values include `Access_Anomaly`, `Sql_Injection` and `Sql_Injection_Vulnerability`.
        """
        email_account_admins: NotRequired[pulumi.Input[_builtins.str]]
        """
        Should the account administrators be emailed when this alert is triggered? Possible values are `Enabled` or `Disabled`. Defaults to `Disabled`.
        """
        email_addresses: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        A list of email addresses which alerts should be sent to.
        """
        retention_days: NotRequired[pulumi.Input[_builtins.int]]
        """
        Specifies the number of days to keep in the Threat Detection audit logs.
        """
        state: NotRequired[pulumi.Input[_builtins.str]]
        """
        The State of the Policy. Possible values are `Enabled` or `Disabled`. Defaults to `Disabled`.
        """
        storage_account_access_key: NotRequired[pulumi.Input[_builtins.str]]
        """
        Specifies the identifier key of the Threat Detection audit storage account. Required if `state` is `Enabled`.
        """
        storage_endpoint: NotRequired[pulumi.Input[_builtins.str]]
        """
        Specifies the blob storage endpoint (e.g. <https://example.blob.core.windows.net>). This blob storage will hold all Threat Detection audit logs. Required if `state` is `Enabled`.
        """
elif False:
    DatabaseThreatDetectionPolicyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DatabaseThreatDetectionPolicyArgs:
    def __init__(__self__, *,
                 disabled_alerts: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 email_account_admins: Optional[pulumi.Input[_builtins.str]] = None,
                 email_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 retention_days: Optional[pulumi.Input[_builtins.int]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_account_access_key: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_endpoint: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] disabled_alerts: Specifies a list of alerts which should be disabled. Possible values include `Access_Anomaly`, `Sql_Injection` and `Sql_Injection_Vulnerability`.
        :param pulumi.Input[_builtins.str] email_account_admins: Should the account administrators be emailed when this alert is triggered? Possible values are `Enabled` or `Disabled`. Defaults to `Disabled`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] email_addresses: A list of email addresses which alerts should be sent to.
        :param pulumi.Input[_builtins.int] retention_days: Specifies the number of days to keep in the Threat Detection audit logs.
        :param pulumi.Input[_builtins.str] state: The State of the Policy. Possible values are `Enabled` or `Disabled`. Defaults to `Disabled`.
        :param pulumi.Input[_builtins.str] storage_account_access_key: Specifies the identifier key of the Threat Detection audit storage account. Required if `state` is `Enabled`.
        :param pulumi.Input[_builtins.str] storage_endpoint: Specifies the blob storage endpoint (e.g. <https://example.blob.core.windows.net>). This blob storage will hold all Threat Detection audit logs. Required if `state` is `Enabled`.
        """
        if disabled_alerts is not None:
            pulumi.set(__self__, "disabled_alerts", disabled_alerts)
        if email_account_admins is not None:
            pulumi.set(__self__, "email_account_admins", email_account_admins)
        if email_addresses is not None:
            pulumi.set(__self__, "email_addresses", email_addresses)
        if retention_days is not None:
            pulumi.set(__self__, "retention_days", retention_days)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if storage_account_access_key is not None:
            pulumi.set(__self__, "storage_account_access_key", storage_account_access_key)
        if storage_endpoint is not None:
            pulumi.set(__self__, "storage_endpoint", storage_endpoint)

    @_builtins.property
    @pulumi.getter(name="disabledAlerts")
    def disabled_alerts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies a list of alerts which should be disabled. Possible values include `Access_Anomaly`, `Sql_Injection` and `Sql_Injection_Vulnerability`.
        """
        return pulumi.get(self, "disabled_alerts")

    @disabled_alerts.setter
    def disabled_alerts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "disabled_alerts", value)

    @_builtins.property
    @pulumi.getter(name="emailAccountAdmins")
    def email_account_admins(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Should the account administrators be emailed when this alert is triggered? Possible values are `Enabled` or `Disabled`. Defaults to `Disabled`.
        """
        return pulumi.get(self, "email_account_admins")

    @email_account_admins.setter
    def email_account_admins(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "email_account_admins", value)

    @_builtins.property
    @pulumi.getter(name="emailAddresses")
    def email_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of email addresses which alerts should be sent to.
        """
        return pulumi.get(self, "email_addresses")

    @email_addresses.setter
    def email_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "email_addresses", value)

    @_builtins.property
    @pulumi.getter(name="retentionDays")
    def retention_days(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the number of days to keep in the Threat Detection audit logs.
        """
        return pulumi.get(self, "retention_days")

    @retention_days.setter
    def retention_days(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "retention_days", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The State of the Policy. Possible values are `Enabled` or `Disabled`. Defaults to `Disabled`.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter(name="storageAccountAccessKey")
    def storage_account_access_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the identifier key of the Threat Detection audit storage account. Required if `state` is `Enabled`.
        """
        return pulumi.get(self, "storage_account_access_key")

    @storage_account_access_key.setter
    def storage_account_access_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_account_access_key", value)

    @_builtins.property
    @pulumi.getter(name="storageEndpoint")
    def storage_endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the blob storage endpoint (e.g. <https://example.blob.core.windows.net>). This blob storage will hold all Threat Detection audit logs. Required if `state` is `Enabled`.
        """
        return pulumi.get(self, "storage_endpoint")

    @storage_endpoint.setter
    def storage_endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_endpoint", value)


if not MYPY:
    class DatabaseVulnerabilityAssessmentRuleBaselineBaselineResultArgsDict(TypedDict):
        results: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]
        """
        A list representing a result of the baseline.
        """
elif False:
    DatabaseVulnerabilityAssessmentRuleBaselineBaselineResultArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DatabaseVulnerabilityAssessmentRuleBaselineBaselineResultArgs:
    def __init__(__self__, *,
                 results: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        """
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] results: A list representing a result of the baseline.
        """
        pulumi.set(__self__, "results", results)

    @_builtins.property
    @pulumi.getter
    def results(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        A list representing a result of the baseline.
        """
        return pulumi.get(self, "results")

    @results.setter
    def results(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "results", value)


if not MYPY:
    class ElasticPoolPerDatabaseSettingsArgsDict(TypedDict):
        max_capacity: pulumi.Input[_builtins.float]
        """
        The maximum capacity any one database can consume.
        """
        min_capacity: pulumi.Input[_builtins.float]
        """
        The minimum capacity all databases are guaranteed.
        """
elif False:
    ElasticPoolPerDatabaseSettingsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ElasticPoolPerDatabaseSettingsArgs:
    def __init__(__self__, *,
                 max_capacity: pulumi.Input[_builtins.float],
                 min_capacity: pulumi.Input[_builtins.float]):
        """
        :param pulumi.Input[_builtins.float] max_capacity: The maximum capacity any one database can consume.
        :param pulumi.Input[_builtins.float] min_capacity: The minimum capacity all databases are guaranteed.
        """
        pulumi.set(__self__, "max_capacity", max_capacity)
        pulumi.set(__self__, "min_capacity", min_capacity)

    @_builtins.property
    @pulumi.getter(name="maxCapacity")
    def max_capacity(self) -> pulumi.Input[_builtins.float]:
        """
        The maximum capacity any one database can consume.
        """
        return pulumi.get(self, "max_capacity")

    @max_capacity.setter
    def max_capacity(self, value: pulumi.Input[_builtins.float]):
        pulumi.set(self, "max_capacity", value)

    @_builtins.property
    @pulumi.getter(name="minCapacity")
    def min_capacity(self) -> pulumi.Input[_builtins.float]:
        """
        The minimum capacity all databases are guaranteed.
        """
        return pulumi.get(self, "min_capacity")

    @min_capacity.setter
    def min_capacity(self, value: pulumi.Input[_builtins.float]):
        pulumi.set(self, "min_capacity", value)


if not MYPY:
    class ElasticPoolSkuArgsDict(TypedDict):
        capacity: pulumi.Input[_builtins.int]
        """
        The scale up/out capacity, representing server's compute units. For more information see the documentation for your Elasticpool configuration: [vCore-based](https://docs.microsoft.com/azure/sql-database/sql-database-vcore-resource-limits-elastic-pools) or [DTU-based](https://docs.microsoft.com/azure/sql-database/sql-database-dtu-resource-limits-elastic-pools).
        """
        name: pulumi.Input[_builtins.str]
        """
        Specifies the SKU Name for this Elasticpool. The name of the SKU, will be either `vCore` based or `DTU` based. Possible `DTU` based values are `BasicPool`, `StandardPool`, `PremiumPool` while possible `vCore` based values are `GP_Gen4`, `GP_Gen5`, `GP_Fsv2`, `GP_DC`, `BC_Gen4`, `BC_Gen5`, `BC_DC`, `HS_PRMS`, `HS_MOPRMS`, or `HS_Gen5`.
        """
        tier: pulumi.Input[_builtins.str]
        """
        The tier of the particular SKU. Possible values are `GeneralPurpose`, `BusinessCritical`, `Basic`, `Standard`, `Premium`, or `HyperScale`. For more information see the documentation for your Elasticpool configuration: [vCore-based](https://docs.microsoft.com/azure/sql-database/sql-database-vcore-resource-limits-elastic-pools) or [DTU-based](https://docs.microsoft.com/azure/sql-database/sql-database-dtu-resource-limits-elastic-pools).
        """
        family: NotRequired[pulumi.Input[_builtins.str]]
        """
        The `family` of hardware `Gen4`, `Gen5`, `Fsv2`, `MOPRMS`, `PRMS`, or `DC`.
        """
elif False:
    ElasticPoolSkuArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ElasticPoolSkuArgs:
    def __init__(__self__, *,
                 capacity: pulumi.Input[_builtins.int],
                 name: pulumi.Input[_builtins.str],
                 tier: pulumi.Input[_builtins.str],
                 family: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.int] capacity: The scale up/out capacity, representing server's compute units. For more information see the documentation for your Elasticpool configuration: [vCore-based](https://docs.microsoft.com/azure/sql-database/sql-database-vcore-resource-limits-elastic-pools) or [DTU-based](https://docs.microsoft.com/azure/sql-database/sql-database-dtu-resource-limits-elastic-pools).
        :param pulumi.Input[_builtins.str] name: Specifies the SKU Name for this Elasticpool. The name of the SKU, will be either `vCore` based or `DTU` based. Possible `DTU` based values are `BasicPool`, `StandardPool`, `PremiumPool` while possible `vCore` based values are `GP_Gen4`, `GP_Gen5`, `GP_Fsv2`, `GP_DC`, `BC_Gen4`, `BC_Gen5`, `BC_DC`, `HS_PRMS`, `HS_MOPRMS`, or `HS_Gen5`.
        :param pulumi.Input[_builtins.str] tier: The tier of the particular SKU. Possible values are `GeneralPurpose`, `BusinessCritical`, `Basic`, `Standard`, `Premium`, or `HyperScale`. For more information see the documentation for your Elasticpool configuration: [vCore-based](https://docs.microsoft.com/azure/sql-database/sql-database-vcore-resource-limits-elastic-pools) or [DTU-based](https://docs.microsoft.com/azure/sql-database/sql-database-dtu-resource-limits-elastic-pools).
        :param pulumi.Input[_builtins.str] family: The `family` of hardware `Gen4`, `Gen5`, `Fsv2`, `MOPRMS`, `PRMS`, or `DC`.
        """
        pulumi.set(__self__, "capacity", capacity)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "tier", tier)
        if family is not None:
            pulumi.set(__self__, "family", family)

    @_builtins.property
    @pulumi.getter
    def capacity(self) -> pulumi.Input[_builtins.int]:
        """
        The scale up/out capacity, representing server's compute units. For more information see the documentation for your Elasticpool configuration: [vCore-based](https://docs.microsoft.com/azure/sql-database/sql-database-vcore-resource-limits-elastic-pools) or [DTU-based](https://docs.microsoft.com/azure/sql-database/sql-database-dtu-resource-limits-elastic-pools).
        """
        return pulumi.get(self, "capacity")

    @capacity.setter
    def capacity(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "capacity", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the SKU Name for this Elasticpool. The name of the SKU, will be either `vCore` based or `DTU` based. Possible `DTU` based values are `BasicPool`, `StandardPool`, `PremiumPool` while possible `vCore` based values are `GP_Gen4`, `GP_Gen5`, `GP_Fsv2`, `GP_DC`, `BC_Gen4`, `BC_Gen5`, `BC_DC`, `HS_PRMS`, `HS_MOPRMS`, or `HS_Gen5`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def tier(self) -> pulumi.Input[_builtins.str]:
        """
        The tier of the particular SKU. Possible values are `GeneralPurpose`, `BusinessCritical`, `Basic`, `Standard`, `Premium`, or `HyperScale`. For more information see the documentation for your Elasticpool configuration: [vCore-based](https://docs.microsoft.com/azure/sql-database/sql-database-vcore-resource-limits-elastic-pools) or [DTU-based](https://docs.microsoft.com/azure/sql-database/sql-database-dtu-resource-limits-elastic-pools).
        """
        return pulumi.get(self, "tier")

    @tier.setter
    def tier(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "tier", value)

    @_builtins.property
    @pulumi.getter
    def family(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The `family` of hardware `Gen4`, `Gen5`, `Fsv2`, `MOPRMS`, `PRMS`, or `DC`.
        """
        return pulumi.get(self, "family")

    @family.setter
    def family(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "family", value)


if not MYPY:
    class FailoverGroupPartnerServerArgsDict(TypedDict):
        id: pulumi.Input[_builtins.str]
        """
        The ID of a partner SQL server to include in the failover group.
        """
        location: NotRequired[pulumi.Input[_builtins.str]]
        """
        The location of the partner server.
        """
        role: NotRequired[pulumi.Input[_builtins.str]]
        """
        The replication role of the partner server. Possible values include `Primary` or `Secondary`.
        """
elif False:
    FailoverGroupPartnerServerArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class FailoverGroupPartnerServerArgs:
    def __init__(__self__, *,
                 id: pulumi.Input[_builtins.str],
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 role: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] id: The ID of a partner SQL server to include in the failover group.
        :param pulumi.Input[_builtins.str] location: The location of the partner server.
        :param pulumi.Input[_builtins.str] role: The replication role of the partner server. Possible values include `Primary` or `Secondary`.
        """
        pulumi.set(__self__, "id", id)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if role is not None:
            pulumi.set(__self__, "role", role)

    @_builtins.property
    @pulumi.getter
    def id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of a partner SQL server to include in the failover group.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "id", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The location of the partner server.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def role(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The replication role of the partner server. Possible values include `Primary` or `Secondary`.
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "role", value)


if not MYPY:
    class FailoverGroupReadWriteEndpointFailoverPolicyArgsDict(TypedDict):
        mode: pulumi.Input[_builtins.str]
        """
        The failover policy of the read-write endpoint for the failover group. Possible values are `Automatic` or `Manual`.
        """
        grace_minutes: NotRequired[pulumi.Input[_builtins.int]]
        """
        The grace period in minutes, before failover with data loss is attempted for the read-write endpoint. Required when `mode` is `Automatic`.
        """
elif False:
    FailoverGroupReadWriteEndpointFailoverPolicyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class FailoverGroupReadWriteEndpointFailoverPolicyArgs:
    def __init__(__self__, *,
                 mode: pulumi.Input[_builtins.str],
                 grace_minutes: Optional[pulumi.Input[_builtins.int]] = None):
        """
        :param pulumi.Input[_builtins.str] mode: The failover policy of the read-write endpoint for the failover group. Possible values are `Automatic` or `Manual`.
        :param pulumi.Input[_builtins.int] grace_minutes: The grace period in minutes, before failover with data loss is attempted for the read-write endpoint. Required when `mode` is `Automatic`.
        """
        pulumi.set(__self__, "mode", mode)
        if grace_minutes is not None:
            pulumi.set(__self__, "grace_minutes", grace_minutes)

    @_builtins.property
    @pulumi.getter
    def mode(self) -> pulumi.Input[_builtins.str]:
        """
        The failover policy of the read-write endpoint for the failover group. Possible values are `Automatic` or `Manual`.
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "mode", value)

    @_builtins.property
    @pulumi.getter(name="graceMinutes")
    def grace_minutes(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The grace period in minutes, before failover with data loss is attempted for the read-write endpoint. Required when `mode` is `Automatic`.
        """
        return pulumi.get(self, "grace_minutes")

    @grace_minutes.setter
    def grace_minutes(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "grace_minutes", value)


if not MYPY:
    class JobAgentIdentityArgsDict(TypedDict):
        identity_ids: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]
        """
        Specifies a list of User Assigned Managed Identity IDs to assign to this Elastic Job Agent.
        """
        type: pulumi.Input[_builtins.str]
        """
        Specifies the type of Managed Service Identity that should be configured on this Elastic Job Agent. Currently only `UserAssigned` is supported.
        """
elif False:
    JobAgentIdentityArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class JobAgentIdentityArgs:
    def __init__(__self__, *,
                 identity_ids: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 type: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] identity_ids: Specifies a list of User Assigned Managed Identity IDs to assign to this Elastic Job Agent.
        :param pulumi.Input[_builtins.str] type: Specifies the type of Managed Service Identity that should be configured on this Elastic Job Agent. Currently only `UserAssigned` is supported.
        """
        pulumi.set(__self__, "identity_ids", identity_ids)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="identityIds")
    def identity_ids(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        Specifies a list of User Assigned Managed Identity IDs to assign to this Elastic Job Agent.
        """
        return pulumi.get(self, "identity_ids")

    @identity_ids.setter
    def identity_ids(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "identity_ids", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the type of Managed Service Identity that should be configured on this Elastic Job Agent. Currently only `UserAssigned` is supported.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)


if not MYPY:
    class JobStepOutputTargetArgsDict(TypedDict):
        job_credential_id: pulumi.Input[_builtins.str]
        """
        The ID of the Elastic Job Credential to use when connecting to the output destination.
        """
        mssql_database_id: pulumi.Input[_builtins.str]
        """
        The ID of the output database.
        """
        table_name: pulumi.Input[_builtins.str]
        """
        The name of the output table.
        """
        schema_name: NotRequired[pulumi.Input[_builtins.str]]
        """
        The name of the output schema. Defaults to `dbo`.
        """
elif False:
    JobStepOutputTargetArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class JobStepOutputTargetArgs:
    def __init__(__self__, *,
                 job_credential_id: pulumi.Input[_builtins.str],
                 mssql_database_id: pulumi.Input[_builtins.str],
                 table_name: pulumi.Input[_builtins.str],
                 schema_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] job_credential_id: The ID of the Elastic Job Credential to use when connecting to the output destination.
        :param pulumi.Input[_builtins.str] mssql_database_id: The ID of the output database.
        :param pulumi.Input[_builtins.str] table_name: The name of the output table.
        :param pulumi.Input[_builtins.str] schema_name: The name of the output schema. Defaults to `dbo`.
        """
        pulumi.set(__self__, "job_credential_id", job_credential_id)
        pulumi.set(__self__, "mssql_database_id", mssql_database_id)
        pulumi.set(__self__, "table_name", table_name)
        if schema_name is not None:
            pulumi.set(__self__, "schema_name", schema_name)

    @_builtins.property
    @pulumi.getter(name="jobCredentialId")
    def job_credential_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Elastic Job Credential to use when connecting to the output destination.
        """
        return pulumi.get(self, "job_credential_id")

    @job_credential_id.setter
    def job_credential_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "job_credential_id", value)

    @_builtins.property
    @pulumi.getter(name="mssqlDatabaseId")
    def mssql_database_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the output database.
        """
        return pulumi.get(self, "mssql_database_id")

    @mssql_database_id.setter
    def mssql_database_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "mssql_database_id", value)

    @_builtins.property
    @pulumi.getter(name="tableName")
    def table_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the output table.
        """
        return pulumi.get(self, "table_name")

    @table_name.setter
    def table_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "table_name", value)

    @_builtins.property
    @pulumi.getter(name="schemaName")
    def schema_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the output schema. Defaults to `dbo`.
        """
        return pulumi.get(self, "schema_name")

    @schema_name.setter
    def schema_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "schema_name", value)


if not MYPY:
    class JobTargetGroupJobTargetArgsDict(TypedDict):
        server_name: pulumi.Input[_builtins.str]
        """
        The name of the MS SQL Server.
        """
        database_name: NotRequired[pulumi.Input[_builtins.str]]
        """
        The name of the MS SQL Database.

        > **Note:** This cannot be set in combination with `elastic_pool_name`.
        """
        elastic_pool_name: NotRequired[pulumi.Input[_builtins.str]]
        """
        The name of the MS SQL Elastic Pool.

        > **Note:** This cannot be set in combination with `database_name`.
        """
        job_credential_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The ID of the job credential to use during execution of jobs.

        > **Note:** This is required when `membership_type` is `Include`, unless `database_name` is set.
        """
        membership_type: NotRequired[pulumi.Input[_builtins.str]]
        """
        The membership type for this job target. Possible values are `Include` and `Exclude`. Defaults to `Include`.
        """
        type: NotRequired[pulumi.Input[_builtins.str]]
        """
        The job target type. This value is computed based on `server_name`, `database_name`, and `elastic_pool_name`.
        """
elif False:
    JobTargetGroupJobTargetArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class JobTargetGroupJobTargetArgs:
    def __init__(__self__, *,
                 server_name: pulumi.Input[_builtins.str],
                 database_name: Optional[pulumi.Input[_builtins.str]] = None,
                 elastic_pool_name: Optional[pulumi.Input[_builtins.str]] = None,
                 job_credential_id: Optional[pulumi.Input[_builtins.str]] = None,
                 membership_type: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] server_name: The name of the MS SQL Server.
        :param pulumi.Input[_builtins.str] database_name: The name of the MS SQL Database.
               
               > **Note:** This cannot be set in combination with `elastic_pool_name`.
        :param pulumi.Input[_builtins.str] elastic_pool_name: The name of the MS SQL Elastic Pool.
               
               > **Note:** This cannot be set in combination with `database_name`.
        :param pulumi.Input[_builtins.str] job_credential_id: The ID of the job credential to use during execution of jobs.
               
               > **Note:** This is required when `membership_type` is `Include`, unless `database_name` is set.
        :param pulumi.Input[_builtins.str] membership_type: The membership type for this job target. Possible values are `Include` and `Exclude`. Defaults to `Include`.
        :param pulumi.Input[_builtins.str] type: The job target type. This value is computed based on `server_name`, `database_name`, and `elastic_pool_name`.
        """
        pulumi.set(__self__, "server_name", server_name)
        if database_name is not None:
            pulumi.set(__self__, "database_name", database_name)
        if elastic_pool_name is not None:
            pulumi.set(__self__, "elastic_pool_name", elastic_pool_name)
        if job_credential_id is not None:
            pulumi.set(__self__, "job_credential_id", job_credential_id)
        if membership_type is not None:
            pulumi.set(__self__, "membership_type", membership_type)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="serverName")
    def server_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the MS SQL Server.
        """
        return pulumi.get(self, "server_name")

    @server_name.setter
    def server_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "server_name", value)

    @_builtins.property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the MS SQL Database.

        > **Note:** This cannot be set in combination with `elastic_pool_name`.
        """
        return pulumi.get(self, "database_name")

    @database_name.setter
    def database_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "database_name", value)

    @_builtins.property
    @pulumi.getter(name="elasticPoolName")
    def elastic_pool_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the MS SQL Elastic Pool.

        > **Note:** This cannot be set in combination with `database_name`.
        """
        return pulumi.get(self, "elastic_pool_name")

    @elastic_pool_name.setter
    def elastic_pool_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "elastic_pool_name", value)

    @_builtins.property
    @pulumi.getter(name="jobCredentialId")
    def job_credential_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the job credential to use during execution of jobs.

        > **Note:** This is required when `membership_type` is `Include`, unless `database_name` is set.
        """
        return pulumi.get(self, "job_credential_id")

    @job_credential_id.setter
    def job_credential_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "job_credential_id", value)

    @_builtins.property
    @pulumi.getter(name="membershipType")
    def membership_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The membership type for this job target. Possible values are `Include` and `Exclude`. Defaults to `Include`.
        """
        return pulumi.get(self, "membership_type")

    @membership_type.setter
    def membership_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "membership_type", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The job target type. This value is computed based on `server_name`, `database_name`, and `elastic_pool_name`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


if not MYPY:
    class ManagedDatabaseLongTermRetentionPolicyArgsDict(TypedDict):
        immutable_backups_enabled: NotRequired[pulumi.Input[_builtins.bool]]
        monthly_retention: NotRequired[pulumi.Input[_builtins.str]]
        """
        The monthly retention policy for an LTR backup in an ISO 8601 format. Valid value is between 1 to 120 months. e.g. `P1Y`, `P1M`, `P4W` or `P30D`. Defaults to `PT0S`.
        """
        week_of_year: NotRequired[pulumi.Input[_builtins.int]]
        """
        The week of year to take the yearly backup. Value has to be between `1` and `52`.
        """
        weekly_retention: NotRequired[pulumi.Input[_builtins.str]]
        """
        The weekly retention policy for an LTR backup in an ISO 8601 format. Valid value is between 1 to 520 weeks. e.g. `P1Y`, `P1M`, `P1W` or `P7D`. Defaults to `PT0S`.
        """
        yearly_retention: NotRequired[pulumi.Input[_builtins.str]]
        """
        The yearly retention policy for an LTR backup in an ISO 8601 format. Valid value is between 1 to 10 years. e.g. `P1Y`, `P12M`, `P52W` or `P365D`. Defaults to `PT0S`.
        """
elif False:
    ManagedDatabaseLongTermRetentionPolicyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ManagedDatabaseLongTermRetentionPolicyArgs:
    def __init__(__self__, *,
                 immutable_backups_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 monthly_retention: Optional[pulumi.Input[_builtins.str]] = None,
                 week_of_year: Optional[pulumi.Input[_builtins.int]] = None,
                 weekly_retention: Optional[pulumi.Input[_builtins.str]] = None,
                 yearly_retention: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] monthly_retention: The monthly retention policy for an LTR backup in an ISO 8601 format. Valid value is between 1 to 120 months. e.g. `P1Y`, `P1M`, `P4W` or `P30D`. Defaults to `PT0S`.
        :param pulumi.Input[_builtins.int] week_of_year: The week of year to take the yearly backup. Value has to be between `1` and `52`.
        :param pulumi.Input[_builtins.str] weekly_retention: The weekly retention policy for an LTR backup in an ISO 8601 format. Valid value is between 1 to 520 weeks. e.g. `P1Y`, `P1M`, `P1W` or `P7D`. Defaults to `PT0S`.
        :param pulumi.Input[_builtins.str] yearly_retention: The yearly retention policy for an LTR backup in an ISO 8601 format. Valid value is between 1 to 10 years. e.g. `P1Y`, `P12M`, `P52W` or `P365D`. Defaults to `PT0S`.
        """
        if immutable_backups_enabled is not None:
            pulumi.set(__self__, "immutable_backups_enabled", immutable_backups_enabled)
        if monthly_retention is not None:
            pulumi.set(__self__, "monthly_retention", monthly_retention)
        if week_of_year is not None:
            pulumi.set(__self__, "week_of_year", week_of_year)
        if weekly_retention is not None:
            pulumi.set(__self__, "weekly_retention", weekly_retention)
        if yearly_retention is not None:
            pulumi.set(__self__, "yearly_retention", yearly_retention)

    @_builtins.property
    @pulumi.getter(name="immutableBackupsEnabled")
    def immutable_backups_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "immutable_backups_enabled")

    @immutable_backups_enabled.setter
    def immutable_backups_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "immutable_backups_enabled", value)

    @_builtins.property
    @pulumi.getter(name="monthlyRetention")
    def monthly_retention(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The monthly retention policy for an LTR backup in an ISO 8601 format. Valid value is between 1 to 120 months. e.g. `P1Y`, `P1M`, `P4W` or `P30D`. Defaults to `PT0S`.
        """
        return pulumi.get(self, "monthly_retention")

    @monthly_retention.setter
    def monthly_retention(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "monthly_retention", value)

    @_builtins.property
    @pulumi.getter(name="weekOfYear")
    def week_of_year(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The week of year to take the yearly backup. Value has to be between `1` and `52`.
        """
        return pulumi.get(self, "week_of_year")

    @week_of_year.setter
    def week_of_year(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "week_of_year", value)

    @_builtins.property
    @pulumi.getter(name="weeklyRetention")
    def weekly_retention(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The weekly retention policy for an LTR backup in an ISO 8601 format. Valid value is between 1 to 520 weeks. e.g. `P1Y`, `P1M`, `P1W` or `P7D`. Defaults to `PT0S`.
        """
        return pulumi.get(self, "weekly_retention")

    @weekly_retention.setter
    def weekly_retention(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "weekly_retention", value)

    @_builtins.property
    @pulumi.getter(name="yearlyRetention")
    def yearly_retention(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The yearly retention policy for an LTR backup in an ISO 8601 format. Valid value is between 1 to 10 years. e.g. `P1Y`, `P12M`, `P52W` or `P365D`. Defaults to `PT0S`.
        """
        return pulumi.get(self, "yearly_retention")

    @yearly_retention.setter
    def yearly_retention(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "yearly_retention", value)


if not MYPY:
    class ManagedDatabasePointInTimeRestoreArgsDict(TypedDict):
        restore_point_in_time: pulumi.Input[_builtins.str]
        """
        The point in time for the restore from `source_database_id`. Changing this forces a new resource to be created.
        """
        source_database_id: pulumi.Input[_builtins.str]
        """
        The source database id that will be used to restore from. Changing this forces a new resource to be created.
        """
elif False:
    ManagedDatabasePointInTimeRestoreArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ManagedDatabasePointInTimeRestoreArgs:
    def __init__(__self__, *,
                 restore_point_in_time: pulumi.Input[_builtins.str],
                 source_database_id: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input[_builtins.str] restore_point_in_time: The point in time for the restore from `source_database_id`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] source_database_id: The source database id that will be used to restore from. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "restore_point_in_time", restore_point_in_time)
        pulumi.set(__self__, "source_database_id", source_database_id)

    @_builtins.property
    @pulumi.getter(name="restorePointInTime")
    def restore_point_in_time(self) -> pulumi.Input[_builtins.str]:
        """
        The point in time for the restore from `source_database_id`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "restore_point_in_time")

    @restore_point_in_time.setter
    def restore_point_in_time(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "restore_point_in_time", value)

    @_builtins.property
    @pulumi.getter(name="sourceDatabaseId")
    def source_database_id(self) -> pulumi.Input[_builtins.str]:
        """
        The source database id that will be used to restore from. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "source_database_id")

    @source_database_id.setter
    def source_database_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "source_database_id", value)


if not MYPY:
    class ManagedInstanceAzureActiveDirectoryAdministratorArgsDict(TypedDict):
        login_username: pulumi.Input[_builtins.str]
        """
        The login username of the Azure AD Administrator of this SQL Managed Instance.
        """
        object_id: pulumi.Input[_builtins.str]
        """
        The object id of the Azure AD Administrator of this SQL Managed Instance.
        """
        principal_type: pulumi.Input[_builtins.str]
        """
        The principal type of the Azure AD Administrator of this SQL Managed Instance. Possible values are `Application`, `Group`, `User`.
        """
        azuread_authentication_only_enabled: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Specifies whether only Azure AD authentication can be used to log in to this SQL Managed Instance. When `true`, the `administrator_login` and `administrator_login_password` properties can be omitted. Defaults to `false`.
        """
        tenant_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The tenant id of the Azure AD Administrator of this SQL Managed Instance. Should be specified if the Azure AD Administrator is homed in a different tenant to the SQL Managed Instance.
        """
elif False:
    ManagedInstanceAzureActiveDirectoryAdministratorArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ManagedInstanceAzureActiveDirectoryAdministratorArgs:
    def __init__(__self__, *,
                 login_username: pulumi.Input[_builtins.str],
                 object_id: pulumi.Input[_builtins.str],
                 principal_type: pulumi.Input[_builtins.str],
                 azuread_authentication_only_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 tenant_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] login_username: The login username of the Azure AD Administrator of this SQL Managed Instance.
        :param pulumi.Input[_builtins.str] object_id: The object id of the Azure AD Administrator of this SQL Managed Instance.
        :param pulumi.Input[_builtins.str] principal_type: The principal type of the Azure AD Administrator of this SQL Managed Instance. Possible values are `Application`, `Group`, `User`.
        :param pulumi.Input[_builtins.bool] azuread_authentication_only_enabled: Specifies whether only Azure AD authentication can be used to log in to this SQL Managed Instance. When `true`, the `administrator_login` and `administrator_login_password` properties can be omitted. Defaults to `false`.
        :param pulumi.Input[_builtins.str] tenant_id: The tenant id of the Azure AD Administrator of this SQL Managed Instance. Should be specified if the Azure AD Administrator is homed in a different tenant to the SQL Managed Instance.
        """
        pulumi.set(__self__, "login_username", login_username)
        pulumi.set(__self__, "object_id", object_id)
        pulumi.set(__self__, "principal_type", principal_type)
        if azuread_authentication_only_enabled is not None:
            pulumi.set(__self__, "azuread_authentication_only_enabled", azuread_authentication_only_enabled)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @_builtins.property
    @pulumi.getter(name="loginUsername")
    def login_username(self) -> pulumi.Input[_builtins.str]:
        """
        The login username of the Azure AD Administrator of this SQL Managed Instance.
        """
        return pulumi.get(self, "login_username")

    @login_username.setter
    def login_username(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "login_username", value)

    @_builtins.property
    @pulumi.getter(name="objectId")
    def object_id(self) -> pulumi.Input[_builtins.str]:
        """
        The object id of the Azure AD Administrator of this SQL Managed Instance.
        """
        return pulumi.get(self, "object_id")

    @object_id.setter
    def object_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "object_id", value)

    @_builtins.property
    @pulumi.getter(name="principalType")
    def principal_type(self) -> pulumi.Input[_builtins.str]:
        """
        The principal type of the Azure AD Administrator of this SQL Managed Instance. Possible values are `Application`, `Group`, `User`.
        """
        return pulumi.get(self, "principal_type")

    @principal_type.setter
    def principal_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "principal_type", value)

    @_builtins.property
    @pulumi.getter(name="azureadAuthenticationOnlyEnabled")
    def azuread_authentication_only_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether only Azure AD authentication can be used to log in to this SQL Managed Instance. When `true`, the `administrator_login` and `administrator_login_password` properties can be omitted. Defaults to `false`.
        """
        return pulumi.get(self, "azuread_authentication_only_enabled")

    @azuread_authentication_only_enabled.setter
    def azuread_authentication_only_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "azuread_authentication_only_enabled", value)

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The tenant id of the Azure AD Administrator of this SQL Managed Instance. Should be specified if the Azure AD Administrator is homed in a different tenant to the SQL Managed Instance.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tenant_id", value)


if not MYPY:
    class ManagedInstanceFailoverGroupPartnerRegionArgsDict(TypedDict):
        location: NotRequired[pulumi.Input[_builtins.str]]
        """
        The Azure Region where the Managed Instance Failover Group should exist. Changing this forces a new resource to be created.
        """
        role: NotRequired[pulumi.Input[_builtins.str]]
        """
        The partner replication role of the Managed Instance Failover Group.
        """
elif False:
    ManagedInstanceFailoverGroupPartnerRegionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ManagedInstanceFailoverGroupPartnerRegionArgs:
    def __init__(__self__, *,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 role: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Managed Instance Failover Group should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] role: The partner replication role of the Managed Instance Failover Group.
        """
        if location is not None:
            pulumi.set(__self__, "location", location)
        if role is not None:
            pulumi.set(__self__, "role", role)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Azure Region where the Managed Instance Failover Group should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def role(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The partner replication role of the Managed Instance Failover Group.
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "role", value)


if not MYPY:
    class ManagedInstanceFailoverGroupReadWriteEndpointFailoverPolicyArgsDict(TypedDict):
        mode: pulumi.Input[_builtins.str]
        """
        The failover mode. Possible values are `Automatic` or `Manual`.
        """
        grace_minutes: NotRequired[pulumi.Input[_builtins.int]]
        """
        Applies only if `mode` is `Automatic`. The grace period in minutes before failover with data loss is attempted.
        """
elif False:
    ManagedInstanceFailoverGroupReadWriteEndpointFailoverPolicyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ManagedInstanceFailoverGroupReadWriteEndpointFailoverPolicyArgs:
    def __init__(__self__, *,
                 mode: pulumi.Input[_builtins.str],
                 grace_minutes: Optional[pulumi.Input[_builtins.int]] = None):
        """
        :param pulumi.Input[_builtins.str] mode: The failover mode. Possible values are `Automatic` or `Manual`.
        :param pulumi.Input[_builtins.int] grace_minutes: Applies only if `mode` is `Automatic`. The grace period in minutes before failover with data loss is attempted.
        """
        pulumi.set(__self__, "mode", mode)
        if grace_minutes is not None:
            pulumi.set(__self__, "grace_minutes", grace_minutes)

    @_builtins.property
    @pulumi.getter
    def mode(self) -> pulumi.Input[_builtins.str]:
        """
        The failover mode. Possible values are `Automatic` or `Manual`.
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "mode", value)

    @_builtins.property
    @pulumi.getter(name="graceMinutes")
    def grace_minutes(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Applies only if `mode` is `Automatic`. The grace period in minutes before failover with data loss is attempted.
        """
        return pulumi.get(self, "grace_minutes")

    @grace_minutes.setter
    def grace_minutes(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "grace_minutes", value)


if not MYPY:
    class ManagedInstanceIdentityArgsDict(TypedDict):
        type: pulumi.Input[_builtins.str]
        """
        Specifies the type of Managed Service Identity that should be configured on this SQL Managed Instance. Possible values are `SystemAssigned`, `UserAssigned`, `SystemAssigned, UserAssigned`.
        """
        identity_ids: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        Specifies a list of User Assigned Managed Identity IDs to be assigned to this SQL Managed Instance. Required when `type` includes `UserAssigned`.

        > **Note:** The assigned `principal_id` and `tenant_id` can be retrieved after the identity `type` has been set to `SystemAssigned` and SQL Managed Instance has been created.
        """
        principal_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The Principal ID for the Service Principal associated with the Identity of this SQL Managed Instance.
        """
        tenant_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The Tenant ID for the Service Principal associated with the Identity of this SQL Managed Instance.
        """
elif False:
    ManagedInstanceIdentityArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ManagedInstanceIdentityArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[_builtins.str],
                 identity_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 principal_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tenant_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] type: Specifies the type of Managed Service Identity that should be configured on this SQL Managed Instance. Possible values are `SystemAssigned`, `UserAssigned`, `SystemAssigned, UserAssigned`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] identity_ids: Specifies a list of User Assigned Managed Identity IDs to be assigned to this SQL Managed Instance. Required when `type` includes `UserAssigned`.
               
               > **Note:** The assigned `principal_id` and `tenant_id` can be retrieved after the identity `type` has been set to `SystemAssigned` and SQL Managed Instance has been created.
        :param pulumi.Input[_builtins.str] principal_id: The Principal ID for the Service Principal associated with the Identity of this SQL Managed Instance.
        :param pulumi.Input[_builtins.str] tenant_id: The Tenant ID for the Service Principal associated with the Identity of this SQL Managed Instance.
        """
        pulumi.set(__self__, "type", type)
        if identity_ids is not None:
            pulumi.set(__self__, "identity_ids", identity_ids)
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the type of Managed Service Identity that should be configured on this SQL Managed Instance. Possible values are `SystemAssigned`, `UserAssigned`, `SystemAssigned, UserAssigned`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="identityIds")
    def identity_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies a list of User Assigned Managed Identity IDs to be assigned to this SQL Managed Instance. Required when `type` includes `UserAssigned`.

        > **Note:** The assigned `principal_id` and `tenant_id` can be retrieved after the identity `type` has been set to `SystemAssigned` and SQL Managed Instance has been created.
        """
        return pulumi.get(self, "identity_ids")

    @identity_ids.setter
    def identity_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "identity_ids", value)

    @_builtins.property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Principal ID for the Service Principal associated with the Identity of this SQL Managed Instance.
        """
        return pulumi.get(self, "principal_id")

    @principal_id.setter
    def principal_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "principal_id", value)

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Tenant ID for the Service Principal associated with the Identity of this SQL Managed Instance.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tenant_id", value)


if not MYPY:
    class ManagedInstanceVulnerabilityAssessmentRecurringScansArgsDict(TypedDict):
        email_subscription_admins: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Boolean flag which specifies if the schedule scan notification will be sent to the subscription administrators. Defaults to `true`.
        """
        emails: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        Specifies an array of e-mail addresses to which the scan notification is sent.
        """
        enabled: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Boolean flag which specifies if recurring scans is enabled or disabled. Defaults to `false`.
        """
elif False:
    ManagedInstanceVulnerabilityAssessmentRecurringScansArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ManagedInstanceVulnerabilityAssessmentRecurringScansArgs:
    def __init__(__self__, *,
                 email_subscription_admins: Optional[pulumi.Input[_builtins.bool]] = None,
                 emails: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        :param pulumi.Input[_builtins.bool] email_subscription_admins: Boolean flag which specifies if the schedule scan notification will be sent to the subscription administrators. Defaults to `true`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] emails: Specifies an array of e-mail addresses to which the scan notification is sent.
        :param pulumi.Input[_builtins.bool] enabled: Boolean flag which specifies if recurring scans is enabled or disabled. Defaults to `false`.
        """
        if email_subscription_admins is not None:
            pulumi.set(__self__, "email_subscription_admins", email_subscription_admins)
        if emails is not None:
            pulumi.set(__self__, "emails", emails)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @_builtins.property
    @pulumi.getter(name="emailSubscriptionAdmins")
    def email_subscription_admins(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Boolean flag which specifies if the schedule scan notification will be sent to the subscription administrators. Defaults to `true`.
        """
        return pulumi.get(self, "email_subscription_admins")

    @email_subscription_admins.setter
    def email_subscription_admins(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "email_subscription_admins", value)

    @_builtins.property
    @pulumi.getter
    def emails(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies an array of e-mail addresses to which the scan notification is sent.
        """
        return pulumi.get(self, "emails")

    @emails.setter
    def emails(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "emails", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Boolean flag which specifies if recurring scans is enabled or disabled. Defaults to `false`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)


if not MYPY:
    class ServerAzureadAdministratorArgsDict(TypedDict):
        login_username: pulumi.Input[_builtins.str]
        """
        The login username of the Azure AD Administrator of this SQL Server.
        """
        object_id: pulumi.Input[_builtins.str]
        """
        The object id of the Azure AD Administrator of this SQL Server.
        """
        azuread_authentication_only: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Specifies whether only AD Users and administrators (e.g. `azuread_administrator[0].login_username`) can be used to login, or also local database users (e.g. `administrator_login`). When `true`, the `administrator_login` and `administrator_login_password` properties can be omitted.
        """
        tenant_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The tenant id of the Azure AD Administrator of this SQL Server.
        """
elif False:
    ServerAzureadAdministratorArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ServerAzureadAdministratorArgs:
    def __init__(__self__, *,
                 login_username: pulumi.Input[_builtins.str],
                 object_id: pulumi.Input[_builtins.str],
                 azuread_authentication_only: Optional[pulumi.Input[_builtins.bool]] = None,
                 tenant_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] login_username: The login username of the Azure AD Administrator of this SQL Server.
        :param pulumi.Input[_builtins.str] object_id: The object id of the Azure AD Administrator of this SQL Server.
        :param pulumi.Input[_builtins.bool] azuread_authentication_only: Specifies whether only AD Users and administrators (e.g. `azuread_administrator[0].login_username`) can be used to login, or also local database users (e.g. `administrator_login`). When `true`, the `administrator_login` and `administrator_login_password` properties can be omitted.
        :param pulumi.Input[_builtins.str] tenant_id: The tenant id of the Azure AD Administrator of this SQL Server.
        """
        pulumi.set(__self__, "login_username", login_username)
        pulumi.set(__self__, "object_id", object_id)
        if azuread_authentication_only is not None:
            pulumi.set(__self__, "azuread_authentication_only", azuread_authentication_only)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @_builtins.property
    @pulumi.getter(name="loginUsername")
    def login_username(self) -> pulumi.Input[_builtins.str]:
        """
        The login username of the Azure AD Administrator of this SQL Server.
        """
        return pulumi.get(self, "login_username")

    @login_username.setter
    def login_username(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "login_username", value)

    @_builtins.property
    @pulumi.getter(name="objectId")
    def object_id(self) -> pulumi.Input[_builtins.str]:
        """
        The object id of the Azure AD Administrator of this SQL Server.
        """
        return pulumi.get(self, "object_id")

    @object_id.setter
    def object_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "object_id", value)

    @_builtins.property
    @pulumi.getter(name="azureadAuthenticationOnly")
    def azuread_authentication_only(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether only AD Users and administrators (e.g. `azuread_administrator[0].login_username`) can be used to login, or also local database users (e.g. `administrator_login`). When `true`, the `administrator_login` and `administrator_login_password` properties can be omitted.
        """
        return pulumi.get(self, "azuread_authentication_only")

    @azuread_authentication_only.setter
    def azuread_authentication_only(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "azuread_authentication_only", value)

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The tenant id of the Azure AD Administrator of this SQL Server.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tenant_id", value)


if not MYPY:
    class ServerIdentityArgsDict(TypedDict):
        type: pulumi.Input[_builtins.str]
        """
        Specifies the type of Managed Service Identity that should be configured on this SQL Server. Possible values are `SystemAssigned`, `UserAssigned`, `SystemAssigned, UserAssigned` (to enable both).
        """
        identity_ids: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        Specifies a list of User Assigned Managed Identity IDs to be assigned to this SQL Server.

        > **Note:** This is required when `type` is set to `UserAssigned`

        > **Note:** When `type` is set to `SystemAssigned`, the assigned `principal_id` and `tenant_id` can be retrieved after the Microsoft SQL Server has been created. More details are available below.
        """
        principal_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The Principal ID for the Service Principal associated with the Identity of this SQL Server.
        """
        tenant_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The Tenant ID for the Service Principal associated with the Identity of this SQL Server.
        """
elif False:
    ServerIdentityArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ServerIdentityArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[_builtins.str],
                 identity_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 principal_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tenant_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] type: Specifies the type of Managed Service Identity that should be configured on this SQL Server. Possible values are `SystemAssigned`, `UserAssigned`, `SystemAssigned, UserAssigned` (to enable both).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] identity_ids: Specifies a list of User Assigned Managed Identity IDs to be assigned to this SQL Server.
               
               > **Note:** This is required when `type` is set to `UserAssigned`
               
               > **Note:** When `type` is set to `SystemAssigned`, the assigned `principal_id` and `tenant_id` can be retrieved after the Microsoft SQL Server has been created. More details are available below.
        :param pulumi.Input[_builtins.str] principal_id: The Principal ID for the Service Principal associated with the Identity of this SQL Server.
        :param pulumi.Input[_builtins.str] tenant_id: The Tenant ID for the Service Principal associated with the Identity of this SQL Server.
        """
        pulumi.set(__self__, "type", type)
        if identity_ids is not None:
            pulumi.set(__self__, "identity_ids", identity_ids)
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the type of Managed Service Identity that should be configured on this SQL Server. Possible values are `SystemAssigned`, `UserAssigned`, `SystemAssigned, UserAssigned` (to enable both).
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="identityIds")
    def identity_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies a list of User Assigned Managed Identity IDs to be assigned to this SQL Server.

        > **Note:** This is required when `type` is set to `UserAssigned`

        > **Note:** When `type` is set to `SystemAssigned`, the assigned `principal_id` and `tenant_id` can be retrieved after the Microsoft SQL Server has been created. More details are available below.
        """
        return pulumi.get(self, "identity_ids")

    @identity_ids.setter
    def identity_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "identity_ids", value)

    @_builtins.property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Principal ID for the Service Principal associated with the Identity of this SQL Server.
        """
        return pulumi.get(self, "principal_id")

    @principal_id.setter
    def principal_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "principal_id", value)

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Tenant ID for the Service Principal associated with the Identity of this SQL Server.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tenant_id", value)


if not MYPY:
    class ServerVulnerabilityAssessmentRecurringScansArgsDict(TypedDict):
        email_subscription_admins: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Boolean flag which specifies if the schedule scan notification will be sent to the subscription administrators. Defaults to `false`.
        """
        emails: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        Specifies an array of email addresses to which the scan notification is sent.
        """
        enabled: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Boolean flag which specifies if recurring scans is enabled or disabled. Defaults to `false`.
        """
elif False:
    ServerVulnerabilityAssessmentRecurringScansArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ServerVulnerabilityAssessmentRecurringScansArgs:
    def __init__(__self__, *,
                 email_subscription_admins: Optional[pulumi.Input[_builtins.bool]] = None,
                 emails: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        :param pulumi.Input[_builtins.bool] email_subscription_admins: Boolean flag which specifies if the schedule scan notification will be sent to the subscription administrators. Defaults to `false`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] emails: Specifies an array of email addresses to which the scan notification is sent.
        :param pulumi.Input[_builtins.bool] enabled: Boolean flag which specifies if recurring scans is enabled or disabled. Defaults to `false`.
        """
        if email_subscription_admins is not None:
            pulumi.set(__self__, "email_subscription_admins", email_subscription_admins)
        if emails is not None:
            pulumi.set(__self__, "emails", emails)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @_builtins.property
    @pulumi.getter(name="emailSubscriptionAdmins")
    def email_subscription_admins(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Boolean flag which specifies if the schedule scan notification will be sent to the subscription administrators. Defaults to `false`.
        """
        return pulumi.get(self, "email_subscription_admins")

    @email_subscription_admins.setter
    def email_subscription_admins(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "email_subscription_admins", value)

    @_builtins.property
    @pulumi.getter
    def emails(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies an array of email addresses to which the scan notification is sent.
        """
        return pulumi.get(self, "emails")

    @emails.setter
    def emails(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "emails", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Boolean flag which specifies if recurring scans is enabled or disabled. Defaults to `false`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)


if not MYPY:
    class VirtualMachineAssessmentArgsDict(TypedDict):
        enabled: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Should Assessment be enabled? Defaults to `true`.
        """
        run_immediately: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Should Assessment be run immediately? Defaults to `false`.
        """
        schedule: NotRequired[pulumi.Input['VirtualMachineAssessmentScheduleArgsDict']]
        """
        An `schedule` block as defined below.
        """
elif False:
    VirtualMachineAssessmentArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class VirtualMachineAssessmentArgs:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 run_immediately: Optional[pulumi.Input[_builtins.bool]] = None,
                 schedule: Optional[pulumi.Input['VirtualMachineAssessmentScheduleArgs']] = None):
        """
        :param pulumi.Input[_builtins.bool] enabled: Should Assessment be enabled? Defaults to `true`.
        :param pulumi.Input[_builtins.bool] run_immediately: Should Assessment be run immediately? Defaults to `false`.
        :param pulumi.Input['VirtualMachineAssessmentScheduleArgs'] schedule: An `schedule` block as defined below.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if run_immediately is not None:
            pulumi.set(__self__, "run_immediately", run_immediately)
        if schedule is not None:
            pulumi.set(__self__, "schedule", schedule)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should Assessment be enabled? Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter(name="runImmediately")
    def run_immediately(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should Assessment be run immediately? Defaults to `false`.
        """
        return pulumi.get(self, "run_immediately")

    @run_immediately.setter
    def run_immediately(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "run_immediately", value)

    @_builtins.property
    @pulumi.getter
    def schedule(self) -> Optional[pulumi.Input['VirtualMachineAssessmentScheduleArgs']]:
        """
        An `schedule` block as defined below.
        """
        return pulumi.get(self, "schedule")

    @schedule.setter
    def schedule(self, value: Optional[pulumi.Input['VirtualMachineAssessmentScheduleArgs']]):
        pulumi.set(self, "schedule", value)


if not MYPY:
    class VirtualMachineAssessmentScheduleArgsDict(TypedDict):
        day_of_week: pulumi.Input[_builtins.str]
        """
        What day of the week the assessment will be run. Possible values are `Friday`, `Monday`, `Saturday`, `Sunday`, `Thursday`, `Tuesday` and `Wednesday`.
        """
        start_time: pulumi.Input[_builtins.str]
        """
        What time the assessment will be run. Must be in the format `HH:mm`.
        """
        monthly_occurrence: NotRequired[pulumi.Input[_builtins.int]]
        """
        How many months between assessment runs. Valid values are between `1` and `5`.

        > **Note:** Either one of `weekly_interval` or `monthly_occurrence` must be specified.
        """
        weekly_interval: NotRequired[pulumi.Input[_builtins.int]]
        """
        How many weeks between assessment runs. Valid values are between `1` and `6`.
        """
elif False:
    VirtualMachineAssessmentScheduleArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class VirtualMachineAssessmentScheduleArgs:
    def __init__(__self__, *,
                 day_of_week: pulumi.Input[_builtins.str],
                 start_time: pulumi.Input[_builtins.str],
                 monthly_occurrence: Optional[pulumi.Input[_builtins.int]] = None,
                 weekly_interval: Optional[pulumi.Input[_builtins.int]] = None):
        """
        :param pulumi.Input[_builtins.str] day_of_week: What day of the week the assessment will be run. Possible values are `Friday`, `Monday`, `Saturday`, `Sunday`, `Thursday`, `Tuesday` and `Wednesday`.
        :param pulumi.Input[_builtins.str] start_time: What time the assessment will be run. Must be in the format `HH:mm`.
        :param pulumi.Input[_builtins.int] monthly_occurrence: How many months between assessment runs. Valid values are between `1` and `5`.
               
               > **Note:** Either one of `weekly_interval` or `monthly_occurrence` must be specified.
        :param pulumi.Input[_builtins.int] weekly_interval: How many weeks between assessment runs. Valid values are between `1` and `6`.
        """
        pulumi.set(__self__, "day_of_week", day_of_week)
        pulumi.set(__self__, "start_time", start_time)
        if monthly_occurrence is not None:
            pulumi.set(__self__, "monthly_occurrence", monthly_occurrence)
        if weekly_interval is not None:
            pulumi.set(__self__, "weekly_interval", weekly_interval)

    @_builtins.property
    @pulumi.getter(name="dayOfWeek")
    def day_of_week(self) -> pulumi.Input[_builtins.str]:
        """
        What day of the week the assessment will be run. Possible values are `Friday`, `Monday`, `Saturday`, `Sunday`, `Thursday`, `Tuesday` and `Wednesday`.
        """
        return pulumi.get(self, "day_of_week")

    @day_of_week.setter
    def day_of_week(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "day_of_week", value)

    @_builtins.property
    @pulumi.getter(name="startTime")
    def start_time(self) -> pulumi.Input[_builtins.str]:
        """
        What time the assessment will be run. Must be in the format `HH:mm`.
        """
        return pulumi.get(self, "start_time")

    @start_time.setter
    def start_time(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "start_time", value)

    @_builtins.property
    @pulumi.getter(name="monthlyOccurrence")
    def monthly_occurrence(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        How many months between assessment runs. Valid values are between `1` and `5`.

        > **Note:** Either one of `weekly_interval` or `monthly_occurrence` must be specified.
        """
        return pulumi.get(self, "monthly_occurrence")

    @monthly_occurrence.setter
    def monthly_occurrence(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "monthly_occurrence", value)

    @_builtins.property
    @pulumi.getter(name="weeklyInterval")
    def weekly_interval(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        How many weeks between assessment runs. Valid values are between `1` and `6`.
        """
        return pulumi.get(self, "weekly_interval")

    @weekly_interval.setter
    def weekly_interval(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "weekly_interval", value)


if not MYPY:
    class VirtualMachineAutoBackupArgsDict(TypedDict):
        retention_period_in_days: pulumi.Input[_builtins.int]
        """
        Retention period of backups, in days. Valid values are from `1` to `30`.
        """
        storage_account_access_key: pulumi.Input[_builtins.str]
        """
        Access key for the storage account where backups will be kept.
        """
        storage_blob_endpoint: pulumi.Input[_builtins.str]
        """
        Blob endpoint for the storage account where backups will be kept.
        """
        encryption_enabled: NotRequired[pulumi.Input[_builtins.bool]]
        encryption_password: NotRequired[pulumi.Input[_builtins.str]]
        """
        Encryption password to use. Setting a password will enable encryption.
        """
        manual_schedule: NotRequired[pulumi.Input['VirtualMachineAutoBackupManualScheduleArgsDict']]
        """
        A `manual_schedule` block as documented below. When this block is present, the schedule type is set to `Manual`. Without this block, the schedule type is set to `Automated`.
        """
        system_databases_backup_enabled: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Include or exclude system databases from auto backup.
        """
elif False:
    VirtualMachineAutoBackupArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class VirtualMachineAutoBackupArgs:
    def __init__(__self__, *,
                 retention_period_in_days: pulumi.Input[_builtins.int],
                 storage_account_access_key: pulumi.Input[_builtins.str],
                 storage_blob_endpoint: pulumi.Input[_builtins.str],
                 encryption_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 encryption_password: Optional[pulumi.Input[_builtins.str]] = None,
                 manual_schedule: Optional[pulumi.Input['VirtualMachineAutoBackupManualScheduleArgs']] = None,
                 system_databases_backup_enabled: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        :param pulumi.Input[_builtins.int] retention_period_in_days: Retention period of backups, in days. Valid values are from `1` to `30`.
        :param pulumi.Input[_builtins.str] storage_account_access_key: Access key for the storage account where backups will be kept.
        :param pulumi.Input[_builtins.str] storage_blob_endpoint: Blob endpoint for the storage account where backups will be kept.
        :param pulumi.Input[_builtins.str] encryption_password: Encryption password to use. Setting a password will enable encryption.
        :param pulumi.Input['VirtualMachineAutoBackupManualScheduleArgs'] manual_schedule: A `manual_schedule` block as documented below. When this block is present, the schedule type is set to `Manual`. Without this block, the schedule type is set to `Automated`.
        :param pulumi.Input[_builtins.bool] system_databases_backup_enabled: Include or exclude system databases from auto backup.
        """
        pulumi.set(__self__, "retention_period_in_days", retention_period_in_days)
        pulumi.set(__self__, "storage_account_access_key", storage_account_access_key)
        pulumi.set(__self__, "storage_blob_endpoint", storage_blob_endpoint)
        if encryption_enabled is not None:
            warnings.warn("""`encryption_enabled` has been deprecated and will be removed in v5.0 of the AzureRM Provider. Encryption is enabled when `encryption_password` is set; otherwise disabled.""", DeprecationWarning)
            pulumi.log.warn("""encryption_enabled is deprecated: `encryption_enabled` has been deprecated and will be removed in v5.0 of the AzureRM Provider. Encryption is enabled when `encryption_password` is set; otherwise disabled.""")
        if encryption_enabled is not None:
            pulumi.set(__self__, "encryption_enabled", encryption_enabled)
        if encryption_password is not None:
            pulumi.set(__self__, "encryption_password", encryption_password)
        if manual_schedule is not None:
            pulumi.set(__self__, "manual_schedule", manual_schedule)
        if system_databases_backup_enabled is not None:
            pulumi.set(__self__, "system_databases_backup_enabled", system_databases_backup_enabled)

    @_builtins.property
    @pulumi.getter(name="retentionPeriodInDays")
    def retention_period_in_days(self) -> pulumi.Input[_builtins.int]:
        """
        Retention period of backups, in days. Valid values are from `1` to `30`.
        """
        return pulumi.get(self, "retention_period_in_days")

    @retention_period_in_days.setter
    def retention_period_in_days(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "retention_period_in_days", value)

    @_builtins.property
    @pulumi.getter(name="storageAccountAccessKey")
    def storage_account_access_key(self) -> pulumi.Input[_builtins.str]:
        """
        Access key for the storage account where backups will be kept.
        """
        return pulumi.get(self, "storage_account_access_key")

    @storage_account_access_key.setter
    def storage_account_access_key(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "storage_account_access_key", value)

    @_builtins.property
    @pulumi.getter(name="storageBlobEndpoint")
    def storage_blob_endpoint(self) -> pulumi.Input[_builtins.str]:
        """
        Blob endpoint for the storage account where backups will be kept.
        """
        return pulumi.get(self, "storage_blob_endpoint")

    @storage_blob_endpoint.setter
    def storage_blob_endpoint(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "storage_blob_endpoint", value)

    @_builtins.property
    @pulumi.getter(name="encryptionEnabled")
    @_utilities.deprecated("""`encryption_enabled` has been deprecated and will be removed in v5.0 of the AzureRM Provider. Encryption is enabled when `encryption_password` is set; otherwise disabled.""")
    def encryption_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "encryption_enabled")

    @encryption_enabled.setter
    def encryption_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "encryption_enabled", value)

    @_builtins.property
    @pulumi.getter(name="encryptionPassword")
    def encryption_password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Encryption password to use. Setting a password will enable encryption.
        """
        return pulumi.get(self, "encryption_password")

    @encryption_password.setter
    def encryption_password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "encryption_password", value)

    @_builtins.property
    @pulumi.getter(name="manualSchedule")
    def manual_schedule(self) -> Optional[pulumi.Input['VirtualMachineAutoBackupManualScheduleArgs']]:
        """
        A `manual_schedule` block as documented below. When this block is present, the schedule type is set to `Manual`. Without this block, the schedule type is set to `Automated`.
        """
        return pulumi.get(self, "manual_schedule")

    @manual_schedule.setter
    def manual_schedule(self, value: Optional[pulumi.Input['VirtualMachineAutoBackupManualScheduleArgs']]):
        pulumi.set(self, "manual_schedule", value)

    @_builtins.property
    @pulumi.getter(name="systemDatabasesBackupEnabled")
    def system_databases_backup_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Include or exclude system databases from auto backup.
        """
        return pulumi.get(self, "system_databases_backup_enabled")

    @system_databases_backup_enabled.setter
    def system_databases_backup_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "system_databases_backup_enabled", value)


if not MYPY:
    class VirtualMachineAutoBackupManualScheduleArgsDict(TypedDict):
        full_backup_frequency: pulumi.Input[_builtins.str]
        """
        Frequency of full backups. Valid values include `Daily` or `Weekly`.
        """
        full_backup_start_hour: pulumi.Input[_builtins.int]
        """
        Start hour of a given day during which full backups can take place. Valid values are from `0` to `23`.
        """
        full_backup_window_in_hours: pulumi.Input[_builtins.int]
        """
        Duration of the time window of a given day during which full backups can take place, in hours. Valid values are between `1` and `23`.
        """
        log_backup_frequency_in_minutes: pulumi.Input[_builtins.int]
        """
        Frequency of log backups, in minutes. Valid values are from `5` to `60`.
        """
        days_of_weeks: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        A list of days on which backup can take place. Possible values are `Monday`, `Tuesday`, `Wednesday`, `Thursday`, `Friday`, `Saturday` and `Sunday`

        > **Note:** `days_of_week` can only be specified when `manual_schedule` is set to `Weekly`
        """
elif False:
    VirtualMachineAutoBackupManualScheduleArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class VirtualMachineAutoBackupManualScheduleArgs:
    def __init__(__self__, *,
                 full_backup_frequency: pulumi.Input[_builtins.str],
                 full_backup_start_hour: pulumi.Input[_builtins.int],
                 full_backup_window_in_hours: pulumi.Input[_builtins.int],
                 log_backup_frequency_in_minutes: pulumi.Input[_builtins.int],
                 days_of_weeks: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        :param pulumi.Input[_builtins.str] full_backup_frequency: Frequency of full backups. Valid values include `Daily` or `Weekly`.
        :param pulumi.Input[_builtins.int] full_backup_start_hour: Start hour of a given day during which full backups can take place. Valid values are from `0` to `23`.
        :param pulumi.Input[_builtins.int] full_backup_window_in_hours: Duration of the time window of a given day during which full backups can take place, in hours. Valid values are between `1` and `23`.
        :param pulumi.Input[_builtins.int] log_backup_frequency_in_minutes: Frequency of log backups, in minutes. Valid values are from `5` to `60`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] days_of_weeks: A list of days on which backup can take place. Possible values are `Monday`, `Tuesday`, `Wednesday`, `Thursday`, `Friday`, `Saturday` and `Sunday`
               
               > **Note:** `days_of_week` can only be specified when `manual_schedule` is set to `Weekly`
        """
        pulumi.set(__self__, "full_backup_frequency", full_backup_frequency)
        pulumi.set(__self__, "full_backup_start_hour", full_backup_start_hour)
        pulumi.set(__self__, "full_backup_window_in_hours", full_backup_window_in_hours)
        pulumi.set(__self__, "log_backup_frequency_in_minutes", log_backup_frequency_in_minutes)
        if days_of_weeks is not None:
            pulumi.set(__self__, "days_of_weeks", days_of_weeks)

    @_builtins.property
    @pulumi.getter(name="fullBackupFrequency")
    def full_backup_frequency(self) -> pulumi.Input[_builtins.str]:
        """
        Frequency of full backups. Valid values include `Daily` or `Weekly`.
        """
        return pulumi.get(self, "full_backup_frequency")

    @full_backup_frequency.setter
    def full_backup_frequency(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "full_backup_frequency", value)

    @_builtins.property
    @pulumi.getter(name="fullBackupStartHour")
    def full_backup_start_hour(self) -> pulumi.Input[_builtins.int]:
        """
        Start hour of a given day during which full backups can take place. Valid values are from `0` to `23`.
        """
        return pulumi.get(self, "full_backup_start_hour")

    @full_backup_start_hour.setter
    def full_backup_start_hour(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "full_backup_start_hour", value)

    @_builtins.property
    @pulumi.getter(name="fullBackupWindowInHours")
    def full_backup_window_in_hours(self) -> pulumi.Input[_builtins.int]:
        """
        Duration of the time window of a given day during which full backups can take place, in hours. Valid values are between `1` and `23`.
        """
        return pulumi.get(self, "full_backup_window_in_hours")

    @full_backup_window_in_hours.setter
    def full_backup_window_in_hours(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "full_backup_window_in_hours", value)

    @_builtins.property
    @pulumi.getter(name="logBackupFrequencyInMinutes")
    def log_backup_frequency_in_minutes(self) -> pulumi.Input[_builtins.int]:
        """
        Frequency of log backups, in minutes. Valid values are from `5` to `60`.
        """
        return pulumi.get(self, "log_backup_frequency_in_minutes")

    @log_backup_frequency_in_minutes.setter
    def log_backup_frequency_in_minutes(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "log_backup_frequency_in_minutes", value)

    @_builtins.property
    @pulumi.getter(name="daysOfWeeks")
    def days_of_weeks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of days on which backup can take place. Possible values are `Monday`, `Tuesday`, `Wednesday`, `Thursday`, `Friday`, `Saturday` and `Sunday`

        > **Note:** `days_of_week` can only be specified when `manual_schedule` is set to `Weekly`
        """
        return pulumi.get(self, "days_of_weeks")

    @days_of_weeks.setter
    def days_of_weeks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "days_of_weeks", value)


if not MYPY:
    class VirtualMachineAutoPatchingArgsDict(TypedDict):
        day_of_week: pulumi.Input[_builtins.str]
        """
        The day of week to apply the patch on. Possible values are `Monday`, `Tuesday`, `Wednesday`, `Thursday`, `Friday`, `Saturday` and `Sunday`.
        """
        maintenance_window_duration_in_minutes: pulumi.Input[_builtins.int]
        """
        The size of the Maintenance Window in minutes.
        """
        maintenance_window_starting_hour: pulumi.Input[_builtins.int]
        """
        The Hour, in the Virtual Machine Time-Zone when the patching maintenance window should begin.
        """
elif False:
    VirtualMachineAutoPatchingArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class VirtualMachineAutoPatchingArgs:
    def __init__(__self__, *,
                 day_of_week: pulumi.Input[_builtins.str],
                 maintenance_window_duration_in_minutes: pulumi.Input[_builtins.int],
                 maintenance_window_starting_hour: pulumi.Input[_builtins.int]):
        """
        :param pulumi.Input[_builtins.str] day_of_week: The day of week to apply the patch on. Possible values are `Monday`, `Tuesday`, `Wednesday`, `Thursday`, `Friday`, `Saturday` and `Sunday`.
        :param pulumi.Input[_builtins.int] maintenance_window_duration_in_minutes: The size of the Maintenance Window in minutes.
        :param pulumi.Input[_builtins.int] maintenance_window_starting_hour: The Hour, in the Virtual Machine Time-Zone when the patching maintenance window should begin.
        """
        pulumi.set(__self__, "day_of_week", day_of_week)
        pulumi.set(__self__, "maintenance_window_duration_in_minutes", maintenance_window_duration_in_minutes)
        pulumi.set(__self__, "maintenance_window_starting_hour", maintenance_window_starting_hour)

    @_builtins.property
    @pulumi.getter(name="dayOfWeek")
    def day_of_week(self) -> pulumi.Input[_builtins.str]:
        """
        The day of week to apply the patch on. Possible values are `Monday`, `Tuesday`, `Wednesday`, `Thursday`, `Friday`, `Saturday` and `Sunday`.
        """
        return pulumi.get(self, "day_of_week")

    @day_of_week.setter
    def day_of_week(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "day_of_week", value)

    @_builtins.property
    @pulumi.getter(name="maintenanceWindowDurationInMinutes")
    def maintenance_window_duration_in_minutes(self) -> pulumi.Input[_builtins.int]:
        """
        The size of the Maintenance Window in minutes.
        """
        return pulumi.get(self, "maintenance_window_duration_in_minutes")

    @maintenance_window_duration_in_minutes.setter
    def maintenance_window_duration_in_minutes(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "maintenance_window_duration_in_minutes", value)

    @_builtins.property
    @pulumi.getter(name="maintenanceWindowStartingHour")
    def maintenance_window_starting_hour(self) -> pulumi.Input[_builtins.int]:
        """
        The Hour, in the Virtual Machine Time-Zone when the patching maintenance window should begin.
        """
        return pulumi.get(self, "maintenance_window_starting_hour")

    @maintenance_window_starting_hour.setter
    def maintenance_window_starting_hour(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "maintenance_window_starting_hour", value)


if not MYPY:
    class VirtualMachineAvailabilityGroupListenerLoadBalancerConfigurationArgsDict(TypedDict):
        load_balancer_id: pulumi.Input[_builtins.str]
        """
        The ID of the Load Balancer. Changing this forces a new resource to be created.
        """
        private_ip_address: pulumi.Input[_builtins.str]
        """
        The private IP Address of the listener. Changing this forces a new resource to be created.
        """
        probe_port: pulumi.Input[_builtins.int]
        """
        The probe port of the listener. Changing this forces a new resource to be created.
        """
        sql_virtual_machine_ids: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]
        """
        Specifies a list of SQL Virtual Machine IDs. Changing this forces a new resource to be created.
        """
        subnet_id: pulumi.Input[_builtins.str]
        """
        The ID of the Subnet to create the listener. Changing this forces a new resource to be created.

        > **Note:** `sql_virtual_machine_ids` should match with the SQL Virtual Machines specified in `replica`.
        """
elif False:
    VirtualMachineAvailabilityGroupListenerLoadBalancerConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class VirtualMachineAvailabilityGroupListenerLoadBalancerConfigurationArgs:
    def __init__(__self__, *,
                 load_balancer_id: pulumi.Input[_builtins.str],
                 private_ip_address: pulumi.Input[_builtins.str],
                 probe_port: pulumi.Input[_builtins.int],
                 sql_virtual_machine_ids: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 subnet_id: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input[_builtins.str] load_balancer_id: The ID of the Load Balancer. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] private_ip_address: The private IP Address of the listener. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] probe_port: The probe port of the listener. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] sql_virtual_machine_ids: Specifies a list of SQL Virtual Machine IDs. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] subnet_id: The ID of the Subnet to create the listener. Changing this forces a new resource to be created.
               
               > **Note:** `sql_virtual_machine_ids` should match with the SQL Virtual Machines specified in `replica`.
        """
        pulumi.set(__self__, "load_balancer_id", load_balancer_id)
        pulumi.set(__self__, "private_ip_address", private_ip_address)
        pulumi.set(__self__, "probe_port", probe_port)
        pulumi.set(__self__, "sql_virtual_machine_ids", sql_virtual_machine_ids)
        pulumi.set(__self__, "subnet_id", subnet_id)

    @_builtins.property
    @pulumi.getter(name="loadBalancerId")
    def load_balancer_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Load Balancer. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "load_balancer_id")

    @load_balancer_id.setter
    def load_balancer_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "load_balancer_id", value)

    @_builtins.property
    @pulumi.getter(name="privateIpAddress")
    def private_ip_address(self) -> pulumi.Input[_builtins.str]:
        """
        The private IP Address of the listener. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "private_ip_address")

    @private_ip_address.setter
    def private_ip_address(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "private_ip_address", value)

    @_builtins.property
    @pulumi.getter(name="probePort")
    def probe_port(self) -> pulumi.Input[_builtins.int]:
        """
        The probe port of the listener. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "probe_port")

    @probe_port.setter
    def probe_port(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "probe_port", value)

    @_builtins.property
    @pulumi.getter(name="sqlVirtualMachineIds")
    def sql_virtual_machine_ids(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        Specifies a list of SQL Virtual Machine IDs. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "sql_virtual_machine_ids")

    @sql_virtual_machine_ids.setter
    def sql_virtual_machine_ids(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "sql_virtual_machine_ids", value)

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Subnet to create the listener. Changing this forces a new resource to be created.

        > **Note:** `sql_virtual_machine_ids` should match with the SQL Virtual Machines specified in `replica`.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "subnet_id", value)


if not MYPY:
    class VirtualMachineAvailabilityGroupListenerMultiSubnetIpConfigurationArgsDict(TypedDict):
        private_ip_address: pulumi.Input[_builtins.str]
        """
        The private IP Address of the listener. Changing this forces a new resource to be created.
        """
        sql_virtual_machine_id: pulumi.Input[_builtins.str]
        """
        The ID of the Sql Virtual Machine. Changing this forces a new resource to be created.
        """
        subnet_id: pulumi.Input[_builtins.str]
        """
        The ID of the Subnet to create the listener. Changing this forces a new resource to be created.

        > **Note:** `sql_virtual_machine_id` should match with the SQL Virtual Machines specified in `replica`.
        """
elif False:
    VirtualMachineAvailabilityGroupListenerMultiSubnetIpConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class VirtualMachineAvailabilityGroupListenerMultiSubnetIpConfigurationArgs:
    def __init__(__self__, *,
                 private_ip_address: pulumi.Input[_builtins.str],
                 sql_virtual_machine_id: pulumi.Input[_builtins.str],
                 subnet_id: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input[_builtins.str] private_ip_address: The private IP Address of the listener. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] sql_virtual_machine_id: The ID of the Sql Virtual Machine. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] subnet_id: The ID of the Subnet to create the listener. Changing this forces a new resource to be created.
               
               > **Note:** `sql_virtual_machine_id` should match with the SQL Virtual Machines specified in `replica`.
        """
        pulumi.set(__self__, "private_ip_address", private_ip_address)
        pulumi.set(__self__, "sql_virtual_machine_id", sql_virtual_machine_id)
        pulumi.set(__self__, "subnet_id", subnet_id)

    @_builtins.property
    @pulumi.getter(name="privateIpAddress")
    def private_ip_address(self) -> pulumi.Input[_builtins.str]:
        """
        The private IP Address of the listener. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "private_ip_address")

    @private_ip_address.setter
    def private_ip_address(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "private_ip_address", value)

    @_builtins.property
    @pulumi.getter(name="sqlVirtualMachineId")
    def sql_virtual_machine_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Sql Virtual Machine. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "sql_virtual_machine_id")

    @sql_virtual_machine_id.setter
    def sql_virtual_machine_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "sql_virtual_machine_id", value)

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Subnet to create the listener. Changing this forces a new resource to be created.

        > **Note:** `sql_virtual_machine_id` should match with the SQL Virtual Machines specified in `replica`.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "subnet_id", value)


if not MYPY:
    class VirtualMachineAvailabilityGroupListenerReplicaArgsDict(TypedDict):
        commit: pulumi.Input[_builtins.str]
        """
        The replica commit mode for the availability group. Possible values are `Synchronous_Commit` and `Asynchronous_Commit`. Changing this forces a new resource to be created.
        """
        failover_mode: pulumi.Input[_builtins.str]
        """
        The replica failover mode for the availability group. Possible values are `Manual` and `Automatic`. Changing this forces a new resource to be created.
        """
        readable_secondary: pulumi.Input[_builtins.str]
        """
        The replica readable secondary mode for the availability group. Possible values are `No`, `Read_Only` and `All`. Changing this forces a new resource to be created.
        """
        role: pulumi.Input[_builtins.str]
        """
        The replica role for the availability group. Possible values are `Primary` and `Secondary`. Changing this forces a new resource to be created.
        """
        sql_virtual_machine_id: pulumi.Input[_builtins.str]
        """
        The ID of the SQL Virtual Machine. Changing this forces a new resource to be created.
        """
elif False:
    VirtualMachineAvailabilityGroupListenerReplicaArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class VirtualMachineAvailabilityGroupListenerReplicaArgs:
    def __init__(__self__, *,
                 commit: pulumi.Input[_builtins.str],
                 failover_mode: pulumi.Input[_builtins.str],
                 readable_secondary: pulumi.Input[_builtins.str],
                 role: pulumi.Input[_builtins.str],
                 sql_virtual_machine_id: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input[_builtins.str] commit: The replica commit mode for the availability group. Possible values are `Synchronous_Commit` and `Asynchronous_Commit`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] failover_mode: The replica failover mode for the availability group. Possible values are `Manual` and `Automatic`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] readable_secondary: The replica readable secondary mode for the availability group. Possible values are `No`, `Read_Only` and `All`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] role: The replica role for the availability group. Possible values are `Primary` and `Secondary`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] sql_virtual_machine_id: The ID of the SQL Virtual Machine. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "commit", commit)
        pulumi.set(__self__, "failover_mode", failover_mode)
        pulumi.set(__self__, "readable_secondary", readable_secondary)
        pulumi.set(__self__, "role", role)
        pulumi.set(__self__, "sql_virtual_machine_id", sql_virtual_machine_id)

    @_builtins.property
    @pulumi.getter
    def commit(self) -> pulumi.Input[_builtins.str]:
        """
        The replica commit mode for the availability group. Possible values are `Synchronous_Commit` and `Asynchronous_Commit`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "commit")

    @commit.setter
    def commit(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "commit", value)

    @_builtins.property
    @pulumi.getter(name="failoverMode")
    def failover_mode(self) -> pulumi.Input[_builtins.str]:
        """
        The replica failover mode for the availability group. Possible values are `Manual` and `Automatic`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "failover_mode")

    @failover_mode.setter
    def failover_mode(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "failover_mode", value)

    @_builtins.property
    @pulumi.getter(name="readableSecondary")
    def readable_secondary(self) -> pulumi.Input[_builtins.str]:
        """
        The replica readable secondary mode for the availability group. Possible values are `No`, `Read_Only` and `All`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "readable_secondary")

    @readable_secondary.setter
    def readable_secondary(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "readable_secondary", value)

    @_builtins.property
    @pulumi.getter
    def role(self) -> pulumi.Input[_builtins.str]:
        """
        The replica role for the availability group. Possible values are `Primary` and `Secondary`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "role", value)

    @_builtins.property
    @pulumi.getter(name="sqlVirtualMachineId")
    def sql_virtual_machine_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the SQL Virtual Machine. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "sql_virtual_machine_id")

    @sql_virtual_machine_id.setter
    def sql_virtual_machine_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "sql_virtual_machine_id", value)


if not MYPY:
    class VirtualMachineGroupWsfcDomainProfileArgsDict(TypedDict):
        cluster_subnet_type: pulumi.Input[_builtins.str]
        """
        The subnet type of the SQL Virtual Machine cluster. Possible values are `MultiSubnet` and `SingleSubnet`. Changing this forces a new resource to be created.
        """
        fqdn: pulumi.Input[_builtins.str]
        """
        The fully qualified name of the domain. Changing this forces a new resource to be created.
        """
        cluster_bootstrap_account_name: NotRequired[pulumi.Input[_builtins.str]]
        """
        The account name used for creating cluster. Changing this forces a new resource to be created.
        """
        cluster_operator_account_name: NotRequired[pulumi.Input[_builtins.str]]
        """
        The account name used for operating cluster. Changing this forces a new resource to be created.
        """
        organizational_unit_path: NotRequired[pulumi.Input[_builtins.str]]
        """
        The organizational Unit path in which the nodes and cluster will be present. Changing this forces a new resource to be created.
        """
        sql_service_account_name: NotRequired[pulumi.Input[_builtins.str]]
        """
        The account name under which SQL service will run on all participating SQL virtual machines in the cluster. Changing this forces a new resource to be created.
        """
        storage_account_primary_key: NotRequired[pulumi.Input[_builtins.str]]
        """
        The primary key of the Storage Account.
        """
        storage_account_url: NotRequired[pulumi.Input[_builtins.str]]
        """
        The SAS URL to the Storage Container of the witness storage account. Changing this forces a new resource to be created.
        """
elif False:
    VirtualMachineGroupWsfcDomainProfileArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class VirtualMachineGroupWsfcDomainProfileArgs:
    def __init__(__self__, *,
                 cluster_subnet_type: pulumi.Input[_builtins.str],
                 fqdn: pulumi.Input[_builtins.str],
                 cluster_bootstrap_account_name: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_operator_account_name: Optional[pulumi.Input[_builtins.str]] = None,
                 organizational_unit_path: Optional[pulumi.Input[_builtins.str]] = None,
                 sql_service_account_name: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_account_primary_key: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_account_url: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] cluster_subnet_type: The subnet type of the SQL Virtual Machine cluster. Possible values are `MultiSubnet` and `SingleSubnet`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] fqdn: The fully qualified name of the domain. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] cluster_bootstrap_account_name: The account name used for creating cluster. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] cluster_operator_account_name: The account name used for operating cluster. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] organizational_unit_path: The organizational Unit path in which the nodes and cluster will be present. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] sql_service_account_name: The account name under which SQL service will run on all participating SQL virtual machines in the cluster. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] storage_account_primary_key: The primary key of the Storage Account.
        :param pulumi.Input[_builtins.str] storage_account_url: The SAS URL to the Storage Container of the witness storage account. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "cluster_subnet_type", cluster_subnet_type)
        pulumi.set(__self__, "fqdn", fqdn)
        if cluster_bootstrap_account_name is not None:
            pulumi.set(__self__, "cluster_bootstrap_account_name", cluster_bootstrap_account_name)
        if cluster_operator_account_name is not None:
            pulumi.set(__self__, "cluster_operator_account_name", cluster_operator_account_name)
        if organizational_unit_path is not None:
            pulumi.set(__self__, "organizational_unit_path", organizational_unit_path)
        if sql_service_account_name is not None:
            pulumi.set(__self__, "sql_service_account_name", sql_service_account_name)
        if storage_account_primary_key is not None:
            pulumi.set(__self__, "storage_account_primary_key", storage_account_primary_key)
        if storage_account_url is not None:
            pulumi.set(__self__, "storage_account_url", storage_account_url)

    @_builtins.property
    @pulumi.getter(name="clusterSubnetType")
    def cluster_subnet_type(self) -> pulumi.Input[_builtins.str]:
        """
        The subnet type of the SQL Virtual Machine cluster. Possible values are `MultiSubnet` and `SingleSubnet`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "cluster_subnet_type")

    @cluster_subnet_type.setter
    def cluster_subnet_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "cluster_subnet_type", value)

    @_builtins.property
    @pulumi.getter
    def fqdn(self) -> pulumi.Input[_builtins.str]:
        """
        The fully qualified name of the domain. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "fqdn")

    @fqdn.setter
    def fqdn(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "fqdn", value)

    @_builtins.property
    @pulumi.getter(name="clusterBootstrapAccountName")
    def cluster_bootstrap_account_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The account name used for creating cluster. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "cluster_bootstrap_account_name")

    @cluster_bootstrap_account_name.setter
    def cluster_bootstrap_account_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_bootstrap_account_name", value)

    @_builtins.property
    @pulumi.getter(name="clusterOperatorAccountName")
    def cluster_operator_account_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The account name used for operating cluster. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "cluster_operator_account_name")

    @cluster_operator_account_name.setter
    def cluster_operator_account_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_operator_account_name", value)

    @_builtins.property
    @pulumi.getter(name="organizationalUnitPath")
    def organizational_unit_path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The organizational Unit path in which the nodes and cluster will be present. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "organizational_unit_path")

    @organizational_unit_path.setter
    def organizational_unit_path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "organizational_unit_path", value)

    @_builtins.property
    @pulumi.getter(name="sqlServiceAccountName")
    def sql_service_account_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The account name under which SQL service will run on all participating SQL virtual machines in the cluster. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "sql_service_account_name")

    @sql_service_account_name.setter
    def sql_service_account_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sql_service_account_name", value)

    @_builtins.property
    @pulumi.getter(name="storageAccountPrimaryKey")
    def storage_account_primary_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The primary key of the Storage Account.
        """
        return pulumi.get(self, "storage_account_primary_key")

    @storage_account_primary_key.setter
    def storage_account_primary_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_account_primary_key", value)

    @_builtins.property
    @pulumi.getter(name="storageAccountUrl")
    def storage_account_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The SAS URL to the Storage Container of the witness storage account. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "storage_account_url")

    @storage_account_url.setter
    def storage_account_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_account_url", value)


if not MYPY:
    class VirtualMachineKeyVaultCredentialArgsDict(TypedDict):
        key_vault_url: pulumi.Input[_builtins.str]
        """
        The Azure Key Vault url. Changing this forces a new resource to be created.
        """
        name: pulumi.Input[_builtins.str]
        """
        The credential name.
        """
        service_principal_name: pulumi.Input[_builtins.str]
        """
        The service principal name to access key vault. Changing this forces a new resource to be created.
        """
        service_principal_secret: pulumi.Input[_builtins.str]
        """
        The service principal name secret to access key vault. Changing this forces a new resource to be created.
        """
elif False:
    VirtualMachineKeyVaultCredentialArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class VirtualMachineKeyVaultCredentialArgs:
    def __init__(__self__, *,
                 key_vault_url: pulumi.Input[_builtins.str],
                 name: pulumi.Input[_builtins.str],
                 service_principal_name: pulumi.Input[_builtins.str],
                 service_principal_secret: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input[_builtins.str] key_vault_url: The Azure Key Vault url. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The credential name.
        :param pulumi.Input[_builtins.str] service_principal_name: The service principal name to access key vault. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] service_principal_secret: The service principal name secret to access key vault. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "key_vault_url", key_vault_url)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "service_principal_name", service_principal_name)
        pulumi.set(__self__, "service_principal_secret", service_principal_secret)

    @_builtins.property
    @pulumi.getter(name="keyVaultUrl")
    def key_vault_url(self) -> pulumi.Input[_builtins.str]:
        """
        The Azure Key Vault url. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "key_vault_url")

    @key_vault_url.setter
    def key_vault_url(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "key_vault_url", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        The credential name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="servicePrincipalName")
    def service_principal_name(self) -> pulumi.Input[_builtins.str]:
        """
        The service principal name to access key vault. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "service_principal_name")

    @service_principal_name.setter
    def service_principal_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "service_principal_name", value)

    @_builtins.property
    @pulumi.getter(name="servicePrincipalSecret")
    def service_principal_secret(self) -> pulumi.Input[_builtins.str]:
        """
        The service principal name secret to access key vault. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "service_principal_secret")

    @service_principal_secret.setter
    def service_principal_secret(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "service_principal_secret", value)


if not MYPY:
    class VirtualMachineSqlInstanceArgsDict(TypedDict):
        adhoc_workloads_optimization_enabled: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Specifies if the SQL Server is optimized for adhoc workloads. Possible values are `true` and `false`. Defaults to `false`.
        """
        collation: NotRequired[pulumi.Input[_builtins.str]]
        """
        Collation of the SQL Server. Defaults to `SQL_Latin1_General_CP1_CI_AS`. Changing this forces a new resource to be created.
        """
        instant_file_initialization_enabled: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Specifies if Instant File Initialization is enabled for the SQL Server. Possible values are `true` and `false`. Defaults to `false`. Changing this forces a new resource to be created.
        """
        lock_pages_in_memory_enabled: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Specifies if Lock Pages in Memory is enabled for the SQL Server. Possible values are `true` and `false`. Defaults to `false`. Changing this forces a new resource to be created.
        """
        max_dop: NotRequired[pulumi.Input[_builtins.int]]
        """
        Maximum Degree of Parallelism of the SQL Server. Possible values are between `0` and `32767`. Defaults to `0`.
        """
        max_server_memory_mb: NotRequired[pulumi.Input[_builtins.int]]
        """
        Maximum amount memory that SQL Server Memory Manager can allocate to the SQL Server process. Possible values are between `128` and `2147483647` Defaults to `2147483647`.
        """
        min_server_memory_mb: NotRequired[pulumi.Input[_builtins.int]]
        """
        Minimum amount memory that SQL Server Memory Manager can allocate to the SQL Server process. Possible values are between `0` and `2147483647` Defaults to `0`.

        > **Note:** `max_server_memory_mb` must be greater than or equal to `min_server_memory_mb`
        """
elif False:
    VirtualMachineSqlInstanceArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class VirtualMachineSqlInstanceArgs:
    def __init__(__self__, *,
                 adhoc_workloads_optimization_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 collation: Optional[pulumi.Input[_builtins.str]] = None,
                 instant_file_initialization_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 lock_pages_in_memory_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 max_dop: Optional[pulumi.Input[_builtins.int]] = None,
                 max_server_memory_mb: Optional[pulumi.Input[_builtins.int]] = None,
                 min_server_memory_mb: Optional[pulumi.Input[_builtins.int]] = None):
        """
        :param pulumi.Input[_builtins.bool] adhoc_workloads_optimization_enabled: Specifies if the SQL Server is optimized for adhoc workloads. Possible values are `true` and `false`. Defaults to `false`.
        :param pulumi.Input[_builtins.str] collation: Collation of the SQL Server. Defaults to `SQL_Latin1_General_CP1_CI_AS`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] instant_file_initialization_enabled: Specifies if Instant File Initialization is enabled for the SQL Server. Possible values are `true` and `false`. Defaults to `false`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] lock_pages_in_memory_enabled: Specifies if Lock Pages in Memory is enabled for the SQL Server. Possible values are `true` and `false`. Defaults to `false`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] max_dop: Maximum Degree of Parallelism of the SQL Server. Possible values are between `0` and `32767`. Defaults to `0`.
        :param pulumi.Input[_builtins.int] max_server_memory_mb: Maximum amount memory that SQL Server Memory Manager can allocate to the SQL Server process. Possible values are between `128` and `2147483647` Defaults to `2147483647`.
        :param pulumi.Input[_builtins.int] min_server_memory_mb: Minimum amount memory that SQL Server Memory Manager can allocate to the SQL Server process. Possible values are between `0` and `2147483647` Defaults to `0`.
               
               > **Note:** `max_server_memory_mb` must be greater than or equal to `min_server_memory_mb`
        """
        if adhoc_workloads_optimization_enabled is not None:
            pulumi.set(__self__, "adhoc_workloads_optimization_enabled", adhoc_workloads_optimization_enabled)
        if collation is not None:
            pulumi.set(__self__, "collation", collation)
        if instant_file_initialization_enabled is not None:
            pulumi.set(__self__, "instant_file_initialization_enabled", instant_file_initialization_enabled)
        if lock_pages_in_memory_enabled is not None:
            pulumi.set(__self__, "lock_pages_in_memory_enabled", lock_pages_in_memory_enabled)
        if max_dop is not None:
            pulumi.set(__self__, "max_dop", max_dop)
        if max_server_memory_mb is not None:
            pulumi.set(__self__, "max_server_memory_mb", max_server_memory_mb)
        if min_server_memory_mb is not None:
            pulumi.set(__self__, "min_server_memory_mb", min_server_memory_mb)

    @_builtins.property
    @pulumi.getter(name="adhocWorkloadsOptimizationEnabled")
    def adhoc_workloads_optimization_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies if the SQL Server is optimized for adhoc workloads. Possible values are `true` and `false`. Defaults to `false`.
        """
        return pulumi.get(self, "adhoc_workloads_optimization_enabled")

    @adhoc_workloads_optimization_enabled.setter
    def adhoc_workloads_optimization_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "adhoc_workloads_optimization_enabled", value)

    @_builtins.property
    @pulumi.getter
    def collation(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Collation of the SQL Server. Defaults to `SQL_Latin1_General_CP1_CI_AS`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "collation")

    @collation.setter
    def collation(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "collation", value)

    @_builtins.property
    @pulumi.getter(name="instantFileInitializationEnabled")
    def instant_file_initialization_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies if Instant File Initialization is enabled for the SQL Server. Possible values are `true` and `false`. Defaults to `false`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "instant_file_initialization_enabled")

    @instant_file_initialization_enabled.setter
    def instant_file_initialization_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "instant_file_initialization_enabled", value)

    @_builtins.property
    @pulumi.getter(name="lockPagesInMemoryEnabled")
    def lock_pages_in_memory_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies if Lock Pages in Memory is enabled for the SQL Server. Possible values are `true` and `false`. Defaults to `false`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "lock_pages_in_memory_enabled")

    @lock_pages_in_memory_enabled.setter
    def lock_pages_in_memory_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "lock_pages_in_memory_enabled", value)

    @_builtins.property
    @pulumi.getter(name="maxDop")
    def max_dop(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Maximum Degree of Parallelism of the SQL Server. Possible values are between `0` and `32767`. Defaults to `0`.
        """
        return pulumi.get(self, "max_dop")

    @max_dop.setter
    def max_dop(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_dop", value)

    @_builtins.property
    @pulumi.getter(name="maxServerMemoryMb")
    def max_server_memory_mb(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Maximum amount memory that SQL Server Memory Manager can allocate to the SQL Server process. Possible values are between `128` and `2147483647` Defaults to `2147483647`.
        """
        return pulumi.get(self, "max_server_memory_mb")

    @max_server_memory_mb.setter
    def max_server_memory_mb(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_server_memory_mb", value)

    @_builtins.property
    @pulumi.getter(name="minServerMemoryMb")
    def min_server_memory_mb(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Minimum amount memory that SQL Server Memory Manager can allocate to the SQL Server process. Possible values are between `0` and `2147483647` Defaults to `0`.

        > **Note:** `max_server_memory_mb` must be greater than or equal to `min_server_memory_mb`
        """
        return pulumi.get(self, "min_server_memory_mb")

    @min_server_memory_mb.setter
    def min_server_memory_mb(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "min_server_memory_mb", value)


if not MYPY:
    class VirtualMachineStorageConfigurationArgsDict(TypedDict):
        disk_type: pulumi.Input[_builtins.str]
        """
        The type of disk configuration to apply to the SQL Server. Valid values include `NEW`, `EXTEND`, or `ADD`.
        """
        storage_workload_type: pulumi.Input[_builtins.str]
        """
        The type of storage workload. Valid values include `GENERAL`, `OLTP`, or `DW`.
        """
        data_settings: NotRequired[pulumi.Input['VirtualMachineStorageConfigurationDataSettingsArgsDict']]
        """
        A `storage_settings` block as defined below.
        """
        log_settings: NotRequired[pulumi.Input['VirtualMachineStorageConfigurationLogSettingsArgsDict']]
        """
        A `storage_settings` block as defined below.
        """
        system_db_on_data_disk_enabled: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Specifies whether to set system databases (except tempDb) location to newly created data storage. Possible values are `true` and `false`. Defaults to `false`.
        """
        temp_db_settings: NotRequired[pulumi.Input['VirtualMachineStorageConfigurationTempDbSettingsArgsDict']]
        """
        An `temp_db_settings` block as defined below.
        """
elif False:
    VirtualMachineStorageConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class VirtualMachineStorageConfigurationArgs:
    def __init__(__self__, *,
                 disk_type: pulumi.Input[_builtins.str],
                 storage_workload_type: pulumi.Input[_builtins.str],
                 data_settings: Optional[pulumi.Input['VirtualMachineStorageConfigurationDataSettingsArgs']] = None,
                 log_settings: Optional[pulumi.Input['VirtualMachineStorageConfigurationLogSettingsArgs']] = None,
                 system_db_on_data_disk_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 temp_db_settings: Optional[pulumi.Input['VirtualMachineStorageConfigurationTempDbSettingsArgs']] = None):
        """
        :param pulumi.Input[_builtins.str] disk_type: The type of disk configuration to apply to the SQL Server. Valid values include `NEW`, `EXTEND`, or `ADD`.
        :param pulumi.Input[_builtins.str] storage_workload_type: The type of storage workload. Valid values include `GENERAL`, `OLTP`, or `DW`.
        :param pulumi.Input['VirtualMachineStorageConfigurationDataSettingsArgs'] data_settings: A `storage_settings` block as defined below.
        :param pulumi.Input['VirtualMachineStorageConfigurationLogSettingsArgs'] log_settings: A `storage_settings` block as defined below.
        :param pulumi.Input[_builtins.bool] system_db_on_data_disk_enabled: Specifies whether to set system databases (except tempDb) location to newly created data storage. Possible values are `true` and `false`. Defaults to `false`.
        :param pulumi.Input['VirtualMachineStorageConfigurationTempDbSettingsArgs'] temp_db_settings: An `temp_db_settings` block as defined below.
        """
        pulumi.set(__self__, "disk_type", disk_type)
        pulumi.set(__self__, "storage_workload_type", storage_workload_type)
        if data_settings is not None:
            pulumi.set(__self__, "data_settings", data_settings)
        if log_settings is not None:
            pulumi.set(__self__, "log_settings", log_settings)
        if system_db_on_data_disk_enabled is not None:
            pulumi.set(__self__, "system_db_on_data_disk_enabled", system_db_on_data_disk_enabled)
        if temp_db_settings is not None:
            pulumi.set(__self__, "temp_db_settings", temp_db_settings)

    @_builtins.property
    @pulumi.getter(name="diskType")
    def disk_type(self) -> pulumi.Input[_builtins.str]:
        """
        The type of disk configuration to apply to the SQL Server. Valid values include `NEW`, `EXTEND`, or `ADD`.
        """
        return pulumi.get(self, "disk_type")

    @disk_type.setter
    def disk_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "disk_type", value)

    @_builtins.property
    @pulumi.getter(name="storageWorkloadType")
    def storage_workload_type(self) -> pulumi.Input[_builtins.str]:
        """
        The type of storage workload. Valid values include `GENERAL`, `OLTP`, or `DW`.
        """
        return pulumi.get(self, "storage_workload_type")

    @storage_workload_type.setter
    def storage_workload_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "storage_workload_type", value)

    @_builtins.property
    @pulumi.getter(name="dataSettings")
    def data_settings(self) -> Optional[pulumi.Input['VirtualMachineStorageConfigurationDataSettingsArgs']]:
        """
        A `storage_settings` block as defined below.
        """
        return pulumi.get(self, "data_settings")

    @data_settings.setter
    def data_settings(self, value: Optional[pulumi.Input['VirtualMachineStorageConfigurationDataSettingsArgs']]):
        pulumi.set(self, "data_settings", value)

    @_builtins.property
    @pulumi.getter(name="logSettings")
    def log_settings(self) -> Optional[pulumi.Input['VirtualMachineStorageConfigurationLogSettingsArgs']]:
        """
        A `storage_settings` block as defined below.
        """
        return pulumi.get(self, "log_settings")

    @log_settings.setter
    def log_settings(self, value: Optional[pulumi.Input['VirtualMachineStorageConfigurationLogSettingsArgs']]):
        pulumi.set(self, "log_settings", value)

    @_builtins.property
    @pulumi.getter(name="systemDbOnDataDiskEnabled")
    def system_db_on_data_disk_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to set system databases (except tempDb) location to newly created data storage. Possible values are `true` and `false`. Defaults to `false`.
        """
        return pulumi.get(self, "system_db_on_data_disk_enabled")

    @system_db_on_data_disk_enabled.setter
    def system_db_on_data_disk_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "system_db_on_data_disk_enabled", value)

    @_builtins.property
    @pulumi.getter(name="tempDbSettings")
    def temp_db_settings(self) -> Optional[pulumi.Input['VirtualMachineStorageConfigurationTempDbSettingsArgs']]:
        """
        An `temp_db_settings` block as defined below.
        """
        return pulumi.get(self, "temp_db_settings")

    @temp_db_settings.setter
    def temp_db_settings(self, value: Optional[pulumi.Input['VirtualMachineStorageConfigurationTempDbSettingsArgs']]):
        pulumi.set(self, "temp_db_settings", value)


if not MYPY:
    class VirtualMachineStorageConfigurationDataSettingsArgsDict(TypedDict):
        default_file_path: pulumi.Input[_builtins.str]
        luns: pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]
elif False:
    VirtualMachineStorageConfigurationDataSettingsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class VirtualMachineStorageConfigurationDataSettingsArgs:
    def __init__(__self__, *,
                 default_file_path: pulumi.Input[_builtins.str],
                 luns: pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]):
        pulumi.set(__self__, "default_file_path", default_file_path)
        pulumi.set(__self__, "luns", luns)

    @_builtins.property
    @pulumi.getter(name="defaultFilePath")
    def default_file_path(self) -> pulumi.Input[_builtins.str]:
        return pulumi.get(self, "default_file_path")

    @default_file_path.setter
    def default_file_path(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "default_file_path", value)

    @_builtins.property
    @pulumi.getter
    def luns(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]:
        return pulumi.get(self, "luns")

    @luns.setter
    def luns(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]):
        pulumi.set(self, "luns", value)


if not MYPY:
    class VirtualMachineStorageConfigurationLogSettingsArgsDict(TypedDict):
        default_file_path: pulumi.Input[_builtins.str]
        luns: pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]
elif False:
    VirtualMachineStorageConfigurationLogSettingsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class VirtualMachineStorageConfigurationLogSettingsArgs:
    def __init__(__self__, *,
                 default_file_path: pulumi.Input[_builtins.str],
                 luns: pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]):
        pulumi.set(__self__, "default_file_path", default_file_path)
        pulumi.set(__self__, "luns", luns)

    @_builtins.property
    @pulumi.getter(name="defaultFilePath")
    def default_file_path(self) -> pulumi.Input[_builtins.str]:
        return pulumi.get(self, "default_file_path")

    @default_file_path.setter
    def default_file_path(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "default_file_path", value)

    @_builtins.property
    @pulumi.getter
    def luns(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]:
        return pulumi.get(self, "luns")

    @luns.setter
    def luns(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]):
        pulumi.set(self, "luns", value)


if not MYPY:
    class VirtualMachineStorageConfigurationTempDbSettingsArgsDict(TypedDict):
        default_file_path: pulumi.Input[_builtins.str]
        """
        The SQL Server default path
        """
        luns: pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]
        """
        A list of Logical Unit Numbers for the disks.
        """
        data_file_count: NotRequired[pulumi.Input[_builtins.int]]
        """
        The SQL Server default file count. This value defaults to `8`
        """
        data_file_growth_in_mb: NotRequired[pulumi.Input[_builtins.int]]
        """
        The SQL Server default file size - This value defaults to `512`
        """
        data_file_size_mb: NotRequired[pulumi.Input[_builtins.int]]
        """
        The SQL Server default file size - This value defaults to `256`
        """
        log_file_growth_mb: NotRequired[pulumi.Input[_builtins.int]]
        """
        The SQL Server default file size - This value defaults to `512`
        """
        log_file_size_mb: NotRequired[pulumi.Input[_builtins.int]]
        """
        The SQL Server default file size - This value defaults to `256`
        """
elif False:
    VirtualMachineStorageConfigurationTempDbSettingsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class VirtualMachineStorageConfigurationTempDbSettingsArgs:
    def __init__(__self__, *,
                 default_file_path: pulumi.Input[_builtins.str],
                 luns: pulumi.Input[Sequence[pulumi.Input[_builtins.int]]],
                 data_file_count: Optional[pulumi.Input[_builtins.int]] = None,
                 data_file_growth_in_mb: Optional[pulumi.Input[_builtins.int]] = None,
                 data_file_size_mb: Optional[pulumi.Input[_builtins.int]] = None,
                 log_file_growth_mb: Optional[pulumi.Input[_builtins.int]] = None,
                 log_file_size_mb: Optional[pulumi.Input[_builtins.int]] = None):
        """
        :param pulumi.Input[_builtins.str] default_file_path: The SQL Server default path
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.int]]] luns: A list of Logical Unit Numbers for the disks.
        :param pulumi.Input[_builtins.int] data_file_count: The SQL Server default file count. This value defaults to `8`
        :param pulumi.Input[_builtins.int] data_file_growth_in_mb: The SQL Server default file size - This value defaults to `512`
        :param pulumi.Input[_builtins.int] data_file_size_mb: The SQL Server default file size - This value defaults to `256`
        :param pulumi.Input[_builtins.int] log_file_growth_mb: The SQL Server default file size - This value defaults to `512`
        :param pulumi.Input[_builtins.int] log_file_size_mb: The SQL Server default file size - This value defaults to `256`
        """
        pulumi.set(__self__, "default_file_path", default_file_path)
        pulumi.set(__self__, "luns", luns)
        if data_file_count is not None:
            pulumi.set(__self__, "data_file_count", data_file_count)
        if data_file_growth_in_mb is not None:
            pulumi.set(__self__, "data_file_growth_in_mb", data_file_growth_in_mb)
        if data_file_size_mb is not None:
            pulumi.set(__self__, "data_file_size_mb", data_file_size_mb)
        if log_file_growth_mb is not None:
            pulumi.set(__self__, "log_file_growth_mb", log_file_growth_mb)
        if log_file_size_mb is not None:
            pulumi.set(__self__, "log_file_size_mb", log_file_size_mb)

    @_builtins.property
    @pulumi.getter(name="defaultFilePath")
    def default_file_path(self) -> pulumi.Input[_builtins.str]:
        """
        The SQL Server default path
        """
        return pulumi.get(self, "default_file_path")

    @default_file_path.setter
    def default_file_path(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "default_file_path", value)

    @_builtins.property
    @pulumi.getter
    def luns(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]:
        """
        A list of Logical Unit Numbers for the disks.
        """
        return pulumi.get(self, "luns")

    @luns.setter
    def luns(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]):
        pulumi.set(self, "luns", value)

    @_builtins.property
    @pulumi.getter(name="dataFileCount")
    def data_file_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The SQL Server default file count. This value defaults to `8`
        """
        return pulumi.get(self, "data_file_count")

    @data_file_count.setter
    def data_file_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "data_file_count", value)

    @_builtins.property
    @pulumi.getter(name="dataFileGrowthInMb")
    def data_file_growth_in_mb(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The SQL Server default file size - This value defaults to `512`
        """
        return pulumi.get(self, "data_file_growth_in_mb")

    @data_file_growth_in_mb.setter
    def data_file_growth_in_mb(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "data_file_growth_in_mb", value)

    @_builtins.property
    @pulumi.getter(name="dataFileSizeMb")
    def data_file_size_mb(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The SQL Server default file size - This value defaults to `256`
        """
        return pulumi.get(self, "data_file_size_mb")

    @data_file_size_mb.setter
    def data_file_size_mb(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "data_file_size_mb", value)

    @_builtins.property
    @pulumi.getter(name="logFileGrowthMb")
    def log_file_growth_mb(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The SQL Server default file size - This value defaults to `512`
        """
        return pulumi.get(self, "log_file_growth_mb")

    @log_file_growth_mb.setter
    def log_file_growth_mb(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "log_file_growth_mb", value)

    @_builtins.property
    @pulumi.getter(name="logFileSizeMb")
    def log_file_size_mb(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The SQL Server default file size - This value defaults to `256`
        """
        return pulumi.get(self, "log_file_size_mb")

    @log_file_size_mb.setter
    def log_file_size_mb(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "log_file_size_mb", value)


if not MYPY:
    class VirtualMachineWsfcDomainCredentialArgsDict(TypedDict):
        cluster_bootstrap_account_password: pulumi.Input[_builtins.str]
        """
        The account password used for creating cluster.
        """
        cluster_operator_account_password: pulumi.Input[_builtins.str]
        """
        The account password used for operating cluster.
        """
        sql_service_account_password: pulumi.Input[_builtins.str]
        """
        The account password under which SQL service will run on all participating SQL virtual machines in the cluster.
        """
elif False:
    VirtualMachineWsfcDomainCredentialArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class VirtualMachineWsfcDomainCredentialArgs:
    def __init__(__self__, *,
                 cluster_bootstrap_account_password: pulumi.Input[_builtins.str],
                 cluster_operator_account_password: pulumi.Input[_builtins.str],
                 sql_service_account_password: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input[_builtins.str] cluster_bootstrap_account_password: The account password used for creating cluster.
        :param pulumi.Input[_builtins.str] cluster_operator_account_password: The account password used for operating cluster.
        :param pulumi.Input[_builtins.str] sql_service_account_password: The account password under which SQL service will run on all participating SQL virtual machines in the cluster.
        """
        pulumi.set(__self__, "cluster_bootstrap_account_password", cluster_bootstrap_account_password)
        pulumi.set(__self__, "cluster_operator_account_password", cluster_operator_account_password)
        pulumi.set(__self__, "sql_service_account_password", sql_service_account_password)

    @_builtins.property
    @pulumi.getter(name="clusterBootstrapAccountPassword")
    def cluster_bootstrap_account_password(self) -> pulumi.Input[_builtins.str]:
        """
        The account password used for creating cluster.
        """
        return pulumi.get(self, "cluster_bootstrap_account_password")

    @cluster_bootstrap_account_password.setter
    def cluster_bootstrap_account_password(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "cluster_bootstrap_account_password", value)

    @_builtins.property
    @pulumi.getter(name="clusterOperatorAccountPassword")
    def cluster_operator_account_password(self) -> pulumi.Input[_builtins.str]:
        """
        The account password used for operating cluster.
        """
        return pulumi.get(self, "cluster_operator_account_password")

    @cluster_operator_account_password.setter
    def cluster_operator_account_password(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "cluster_operator_account_password", value)

    @_builtins.property
    @pulumi.getter(name="sqlServiceAccountPassword")
    def sql_service_account_password(self) -> pulumi.Input[_builtins.str]:
        """
        The account password under which SQL service will run on all participating SQL virtual machines in the cluster.
        """
        return pulumi.get(self, "sql_service_account_password")

    @sql_service_account_password.setter
    def sql_service_account_password(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "sql_service_account_password", value)


