# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ManagedInstanceArgs', 'ManagedInstance']

@pulumi.input_type
class ManagedInstanceArgs:
    def __init__(__self__, *,
                 license_type: pulumi.Input[_builtins.str],
                 resource_group_name: pulumi.Input[_builtins.str],
                 sku_name: pulumi.Input[_builtins.str],
                 storage_size_in_gb: pulumi.Input[_builtins.int],
                 subnet_id: pulumi.Input[_builtins.str],
                 vcores: pulumi.Input[_builtins.int],
                 administrator_login: Optional[pulumi.Input[_builtins.str]] = None,
                 administrator_login_password: Optional[pulumi.Input[_builtins.str]] = None,
                 azure_active_directory_administrator: Optional[pulumi.Input['ManagedInstanceAzureActiveDirectoryAdministratorArgs']] = None,
                 collation: Optional[pulumi.Input[_builtins.str]] = None,
                 database_format: Optional[pulumi.Input[_builtins.str]] = None,
                 dns_zone_partner_id: Optional[pulumi.Input[_builtins.str]] = None,
                 hybrid_secondary_usage: Optional[pulumi.Input[_builtins.str]] = None,
                 identity: Optional[pulumi.Input['ManagedInstanceIdentityArgs']] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 maintenance_configuration_name: Optional[pulumi.Input[_builtins.str]] = None,
                 minimum_tls_version: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 proxy_override: Optional[pulumi.Input[_builtins.str]] = None,
                 public_data_endpoint_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 service_principal_type: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_account_type: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 timezone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_redundant_enabled: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a ManagedInstance resource.
        :param pulumi.Input[_builtins.str] license_type: What type of license the Managed Instance will use. Possible values are `LicenseIncluded` and `BasePrice`.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which to create the SQL Managed Instance. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] sku_name: Specifies the SKU Name for the SQL Managed Instance. Valid values include `GP_Gen4`, `GP_Gen5`, `GP_Gen8IM`, `GP_Gen8IH`, `BC_Gen4`, `BC_Gen5`, `BC_Gen8IM` or `BC_Gen8IH`.
        :param pulumi.Input[_builtins.int] storage_size_in_gb: Maximum storage space for the SQL Managed instance. This should be a multiple of 32 (GB).
        :param pulumi.Input[_builtins.str] subnet_id: The subnet resource id that the SQL Managed Instance will be associated with.
        :param pulumi.Input[_builtins.int] vcores: Number of cores that should be assigned to the SQL Managed Instance. Values can be `8`, `16`, or `24` for Gen4 SKUs, or `4`, `6`, `8`, `10`, `12`, `16`, `20`, `24`, `32`, `40`, `48`, `56`, `64`, `80`, `96` or `128` for Gen5 SKUs.
        :param pulumi.Input[_builtins.str] administrator_login: The administrator login name for the new SQL Managed Instance. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] administrator_login_password: The password associated with the `administrator_login` user. Needs to comply with Azure's [Password Policy](https://msdn.microsoft.com/library/ms161959.aspx)
        :param pulumi.Input['ManagedInstanceAzureActiveDirectoryAdministratorArgs'] azure_active_directory_administrator: An `azure_active_directory_administrator` block as defined below.
        :param pulumi.Input[_builtins.str] collation: Specifies how the SQL Managed Instance will be collated. Default value is `SQL_Latin1_General_CP1_CI_AS`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] database_format: Specifies the internal format of the SQL Managed Instance databases specific to the SQL engine version. Possible values are `AlwaysUpToDate` and `SQLServer2022`. Defaults to `SQLServer2022`.
               
               > **Note:** Changing `database_format` from `AlwaysUpToDate` to `SQLServer2022` forces a new SQL Managed Instance to be created.
        :param pulumi.Input[_builtins.str] dns_zone_partner_id: The ID of the SQL Managed Instance which will share the DNS zone. This is a prerequisite for creating an `azurerm_sql_managed_instance_failover_group`. Setting this after creation forces a new resource to be created.
        :param pulumi.Input[_builtins.str] hybrid_secondary_usage: Specifies the hybrid secondary usage for disaster recovery of the SQL Managed Instance. Possible values are `Active` and `Passive`. Defaults to `Active`.
        :param pulumi.Input['ManagedInstanceIdentityArgs'] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.str] location: Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] maintenance_configuration_name: The name of the Public Maintenance Configuration window to apply to the SQL Managed Instance. Valid values include `SQL_Default` or an Azure Location in the format `SQL_{Location}_MI_{Size}`(for example `SQL_EastUS_MI_1`). Defaults to `SQL_Default`.
        :param pulumi.Input[_builtins.str] minimum_tls_version: The Minimum TLS Version. Default value is `1.2` Valid values include `1.0`, `1.1`, `1.2`.
               
               > **Note:** Azure Services will require TLS 1.2+ by August 2025, please see this [announcement](https://azure.microsoft.com/en-us/updates/v2/update-retirement-tls1-0-tls1-1-versions-azure-services/) for more.
        :param pulumi.Input[_builtins.str] name: The name of the SQL Managed Instance. This needs to be globally unique within Azure. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] proxy_override: Specifies how the SQL Managed Instance will be accessed. Default value is `Default`. Valid values include `Default`, `Proxy`, and `Redirect`.
        :param pulumi.Input[_builtins.bool] public_data_endpoint_enabled: Is the public data endpoint enabled? Default value is `false`.
        :param pulumi.Input[_builtins.str] service_principal_type: The service principal type. The only possible value is `SystemAssigned`.
        :param pulumi.Input[_builtins.str] storage_account_type: Specifies the storage account type used to store backups for this database. Possible values are `GRS`, `GZRS`, `LRS`, and `ZRS`. Defaults to `GRS`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.str] timezone_id: The TimeZone ID that the SQL Managed Instance will be operating in. Default value is `UTC`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] zone_redundant_enabled: Specifies whether or not the SQL Managed Instance is zone redundant. Defaults to `false`.
        """
        pulumi.set(__self__, "license_type", license_type)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "sku_name", sku_name)
        pulumi.set(__self__, "storage_size_in_gb", storage_size_in_gb)
        pulumi.set(__self__, "subnet_id", subnet_id)
        pulumi.set(__self__, "vcores", vcores)
        if administrator_login is not None:
            pulumi.set(__self__, "administrator_login", administrator_login)
        if administrator_login_password is not None:
            pulumi.set(__self__, "administrator_login_password", administrator_login_password)
        if azure_active_directory_administrator is not None:
            pulumi.set(__self__, "azure_active_directory_administrator", azure_active_directory_administrator)
        if collation is not None:
            pulumi.set(__self__, "collation", collation)
        if database_format is not None:
            pulumi.set(__self__, "database_format", database_format)
        if dns_zone_partner_id is not None:
            pulumi.set(__self__, "dns_zone_partner_id", dns_zone_partner_id)
        if hybrid_secondary_usage is not None:
            pulumi.set(__self__, "hybrid_secondary_usage", hybrid_secondary_usage)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if maintenance_configuration_name is not None:
            pulumi.set(__self__, "maintenance_configuration_name", maintenance_configuration_name)
        if minimum_tls_version is not None:
            pulumi.set(__self__, "minimum_tls_version", minimum_tls_version)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if proxy_override is not None:
            pulumi.set(__self__, "proxy_override", proxy_override)
        if public_data_endpoint_enabled is not None:
            pulumi.set(__self__, "public_data_endpoint_enabled", public_data_endpoint_enabled)
        if service_principal_type is not None:
            pulumi.set(__self__, "service_principal_type", service_principal_type)
        if storage_account_type is not None:
            pulumi.set(__self__, "storage_account_type", storage_account_type)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if timezone_id is not None:
            pulumi.set(__self__, "timezone_id", timezone_id)
        if zone_redundant_enabled is not None:
            pulumi.set(__self__, "zone_redundant_enabled", zone_redundant_enabled)

    @_builtins.property
    @pulumi.getter(name="licenseType")
    def license_type(self) -> pulumi.Input[_builtins.str]:
        """
        What type of license the Managed Instance will use. Possible values are `LicenseIncluded` and `BasePrice`.
        """
        return pulumi.get(self, "license_type")

    @license_type.setter
    def license_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "license_type", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the resource group in which to create the SQL Managed Instance. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="skuName")
    def sku_name(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the SKU Name for the SQL Managed Instance. Valid values include `GP_Gen4`, `GP_Gen5`, `GP_Gen8IM`, `GP_Gen8IH`, `BC_Gen4`, `BC_Gen5`, `BC_Gen8IM` or `BC_Gen8IH`.
        """
        return pulumi.get(self, "sku_name")

    @sku_name.setter
    def sku_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "sku_name", value)

    @_builtins.property
    @pulumi.getter(name="storageSizeInGb")
    def storage_size_in_gb(self) -> pulumi.Input[_builtins.int]:
        """
        Maximum storage space for the SQL Managed instance. This should be a multiple of 32 (GB).
        """
        return pulumi.get(self, "storage_size_in_gb")

    @storage_size_in_gb.setter
    def storage_size_in_gb(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "storage_size_in_gb", value)

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Input[_builtins.str]:
        """
        The subnet resource id that the SQL Managed Instance will be associated with.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "subnet_id", value)

    @_builtins.property
    @pulumi.getter
    def vcores(self) -> pulumi.Input[_builtins.int]:
        """
        Number of cores that should be assigned to the SQL Managed Instance. Values can be `8`, `16`, or `24` for Gen4 SKUs, or `4`, `6`, `8`, `10`, `12`, `16`, `20`, `24`, `32`, `40`, `48`, `56`, `64`, `80`, `96` or `128` for Gen5 SKUs.
        """
        return pulumi.get(self, "vcores")

    @vcores.setter
    def vcores(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "vcores", value)

    @_builtins.property
    @pulumi.getter(name="administratorLogin")
    def administrator_login(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The administrator login name for the new SQL Managed Instance. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "administrator_login")

    @administrator_login.setter
    def administrator_login(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "administrator_login", value)

    @_builtins.property
    @pulumi.getter(name="administratorLoginPassword")
    def administrator_login_password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The password associated with the `administrator_login` user. Needs to comply with Azure's [Password Policy](https://msdn.microsoft.com/library/ms161959.aspx)
        """
        return pulumi.get(self, "administrator_login_password")

    @administrator_login_password.setter
    def administrator_login_password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "administrator_login_password", value)

    @_builtins.property
    @pulumi.getter(name="azureActiveDirectoryAdministrator")
    def azure_active_directory_administrator(self) -> Optional[pulumi.Input['ManagedInstanceAzureActiveDirectoryAdministratorArgs']]:
        """
        An `azure_active_directory_administrator` block as defined below.
        """
        return pulumi.get(self, "azure_active_directory_administrator")

    @azure_active_directory_administrator.setter
    def azure_active_directory_administrator(self, value: Optional[pulumi.Input['ManagedInstanceAzureActiveDirectoryAdministratorArgs']]):
        pulumi.set(self, "azure_active_directory_administrator", value)

    @_builtins.property
    @pulumi.getter
    def collation(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies how the SQL Managed Instance will be collated. Default value is `SQL_Latin1_General_CP1_CI_AS`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "collation")

    @collation.setter
    def collation(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "collation", value)

    @_builtins.property
    @pulumi.getter(name="databaseFormat")
    def database_format(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the internal format of the SQL Managed Instance databases specific to the SQL engine version. Possible values are `AlwaysUpToDate` and `SQLServer2022`. Defaults to `SQLServer2022`.

        > **Note:** Changing `database_format` from `AlwaysUpToDate` to `SQLServer2022` forces a new SQL Managed Instance to be created.
        """
        return pulumi.get(self, "database_format")

    @database_format.setter
    def database_format(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "database_format", value)

    @_builtins.property
    @pulumi.getter(name="dnsZonePartnerId")
    def dns_zone_partner_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the SQL Managed Instance which will share the DNS zone. This is a prerequisite for creating an `azurerm_sql_managed_instance_failover_group`. Setting this after creation forces a new resource to be created.
        """
        return pulumi.get(self, "dns_zone_partner_id")

    @dns_zone_partner_id.setter
    def dns_zone_partner_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dns_zone_partner_id", value)

    @_builtins.property
    @pulumi.getter(name="hybridSecondaryUsage")
    def hybrid_secondary_usage(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the hybrid secondary usage for disaster recovery of the SQL Managed Instance. Possible values are `Active` and `Passive`. Defaults to `Active`.
        """
        return pulumi.get(self, "hybrid_secondary_usage")

    @hybrid_secondary_usage.setter
    def hybrid_secondary_usage(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "hybrid_secondary_usage", value)

    @_builtins.property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['ManagedInstanceIdentityArgs']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['ManagedInstanceIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="maintenanceConfigurationName")
    def maintenance_configuration_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Public Maintenance Configuration window to apply to the SQL Managed Instance. Valid values include `SQL_Default` or an Azure Location in the format `SQL_{Location}_MI_{Size}`(for example `SQL_EastUS_MI_1`). Defaults to `SQL_Default`.
        """
        return pulumi.get(self, "maintenance_configuration_name")

    @maintenance_configuration_name.setter
    def maintenance_configuration_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "maintenance_configuration_name", value)

    @_builtins.property
    @pulumi.getter(name="minimumTlsVersion")
    def minimum_tls_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Minimum TLS Version. Default value is `1.2` Valid values include `1.0`, `1.1`, `1.2`.

        > **Note:** Azure Services will require TLS 1.2+ by August 2025, please see this [announcement](https://azure.microsoft.com/en-us/updates/v2/update-retirement-tls1-0-tls1-1-versions-azure-services/) for more.
        """
        return pulumi.get(self, "minimum_tls_version")

    @minimum_tls_version.setter
    def minimum_tls_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "minimum_tls_version", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the SQL Managed Instance. This needs to be globally unique within Azure. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="proxyOverride")
    def proxy_override(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies how the SQL Managed Instance will be accessed. Default value is `Default`. Valid values include `Default`, `Proxy`, and `Redirect`.
        """
        return pulumi.get(self, "proxy_override")

    @proxy_override.setter
    def proxy_override(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "proxy_override", value)

    @_builtins.property
    @pulumi.getter(name="publicDataEndpointEnabled")
    def public_data_endpoint_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Is the public data endpoint enabled? Default value is `false`.
        """
        return pulumi.get(self, "public_data_endpoint_enabled")

    @public_data_endpoint_enabled.setter
    def public_data_endpoint_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "public_data_endpoint_enabled", value)

    @_builtins.property
    @pulumi.getter(name="servicePrincipalType")
    def service_principal_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The service principal type. The only possible value is `SystemAssigned`.
        """
        return pulumi.get(self, "service_principal_type")

    @service_principal_type.setter
    def service_principal_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_principal_type", value)

    @_builtins.property
    @pulumi.getter(name="storageAccountType")
    def storage_account_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the storage account type used to store backups for this database. Possible values are `GRS`, `GZRS`, `LRS`, and `ZRS`. Defaults to `GRS`.
        """
        return pulumi.get(self, "storage_account_type")

    @storage_account_type.setter
    def storage_account_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_account_type", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="timezoneId")
    def timezone_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The TimeZone ID that the SQL Managed Instance will be operating in. Default value is `UTC`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "timezone_id")

    @timezone_id.setter
    def timezone_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "timezone_id", value)

    @_builtins.property
    @pulumi.getter(name="zoneRedundantEnabled")
    def zone_redundant_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether or not the SQL Managed Instance is zone redundant. Defaults to `false`.
        """
        return pulumi.get(self, "zone_redundant_enabled")

    @zone_redundant_enabled.setter
    def zone_redundant_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "zone_redundant_enabled", value)


@pulumi.input_type
class _ManagedInstanceState:
    def __init__(__self__, *,
                 administrator_login: Optional[pulumi.Input[_builtins.str]] = None,
                 administrator_login_password: Optional[pulumi.Input[_builtins.str]] = None,
                 azure_active_directory_administrator: Optional[pulumi.Input['ManagedInstanceAzureActiveDirectoryAdministratorArgs']] = None,
                 collation: Optional[pulumi.Input[_builtins.str]] = None,
                 database_format: Optional[pulumi.Input[_builtins.str]] = None,
                 dns_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 dns_zone_partner_id: Optional[pulumi.Input[_builtins.str]] = None,
                 fqdn: Optional[pulumi.Input[_builtins.str]] = None,
                 hybrid_secondary_usage: Optional[pulumi.Input[_builtins.str]] = None,
                 identity: Optional[pulumi.Input['ManagedInstanceIdentityArgs']] = None,
                 license_type: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 maintenance_configuration_name: Optional[pulumi.Input[_builtins.str]] = None,
                 minimum_tls_version: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 proxy_override: Optional[pulumi.Input[_builtins.str]] = None,
                 public_data_endpoint_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 service_principal_type: Optional[pulumi.Input[_builtins.str]] = None,
                 sku_name: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_account_type: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_size_in_gb: Optional[pulumi.Input[_builtins.int]] = None,
                 subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 timezone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vcores: Optional[pulumi.Input[_builtins.int]] = None,
                 zone_redundant_enabled: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        Input properties used for looking up and filtering ManagedInstance resources.
        :param pulumi.Input[_builtins.str] administrator_login: The administrator login name for the new SQL Managed Instance. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] administrator_login_password: The password associated with the `administrator_login` user. Needs to comply with Azure's [Password Policy](https://msdn.microsoft.com/library/ms161959.aspx)
        :param pulumi.Input['ManagedInstanceAzureActiveDirectoryAdministratorArgs'] azure_active_directory_administrator: An `azure_active_directory_administrator` block as defined below.
        :param pulumi.Input[_builtins.str] collation: Specifies how the SQL Managed Instance will be collated. Default value is `SQL_Latin1_General_CP1_CI_AS`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] database_format: Specifies the internal format of the SQL Managed Instance databases specific to the SQL engine version. Possible values are `AlwaysUpToDate` and `SQLServer2022`. Defaults to `SQLServer2022`.
               
               > **Note:** Changing `database_format` from `AlwaysUpToDate` to `SQLServer2022` forces a new SQL Managed Instance to be created.
        :param pulumi.Input[_builtins.str] dns_zone: The Dns Zone where the SQL Managed Instance is located.
        :param pulumi.Input[_builtins.str] dns_zone_partner_id: The ID of the SQL Managed Instance which will share the DNS zone. This is a prerequisite for creating an `azurerm_sql_managed_instance_failover_group`. Setting this after creation forces a new resource to be created.
        :param pulumi.Input[_builtins.str] fqdn: The fully qualified domain name of the Azure Managed SQL Instance
        :param pulumi.Input[_builtins.str] hybrid_secondary_usage: Specifies the hybrid secondary usage for disaster recovery of the SQL Managed Instance. Possible values are `Active` and `Passive`. Defaults to `Active`.
        :param pulumi.Input['ManagedInstanceIdentityArgs'] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.str] license_type: What type of license the Managed Instance will use. Possible values are `LicenseIncluded` and `BasePrice`.
        :param pulumi.Input[_builtins.str] location: Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] maintenance_configuration_name: The name of the Public Maintenance Configuration window to apply to the SQL Managed Instance. Valid values include `SQL_Default` or an Azure Location in the format `SQL_{Location}_MI_{Size}`(for example `SQL_EastUS_MI_1`). Defaults to `SQL_Default`.
        :param pulumi.Input[_builtins.str] minimum_tls_version: The Minimum TLS Version. Default value is `1.2` Valid values include `1.0`, `1.1`, `1.2`.
               
               > **Note:** Azure Services will require TLS 1.2+ by August 2025, please see this [announcement](https://azure.microsoft.com/en-us/updates/v2/update-retirement-tls1-0-tls1-1-versions-azure-services/) for more.
        :param pulumi.Input[_builtins.str] name: The name of the SQL Managed Instance. This needs to be globally unique within Azure. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] proxy_override: Specifies how the SQL Managed Instance will be accessed. Default value is `Default`. Valid values include `Default`, `Proxy`, and `Redirect`.
        :param pulumi.Input[_builtins.bool] public_data_endpoint_enabled: Is the public data endpoint enabled? Default value is `false`.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which to create the SQL Managed Instance. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] service_principal_type: The service principal type. The only possible value is `SystemAssigned`.
        :param pulumi.Input[_builtins.str] sku_name: Specifies the SKU Name for the SQL Managed Instance. Valid values include `GP_Gen4`, `GP_Gen5`, `GP_Gen8IM`, `GP_Gen8IH`, `BC_Gen4`, `BC_Gen5`, `BC_Gen8IM` or `BC_Gen8IH`.
        :param pulumi.Input[_builtins.str] storage_account_type: Specifies the storage account type used to store backups for this database. Possible values are `GRS`, `GZRS`, `LRS`, and `ZRS`. Defaults to `GRS`.
        :param pulumi.Input[_builtins.int] storage_size_in_gb: Maximum storage space for the SQL Managed instance. This should be a multiple of 32 (GB).
        :param pulumi.Input[_builtins.str] subnet_id: The subnet resource id that the SQL Managed Instance will be associated with.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.str] timezone_id: The TimeZone ID that the SQL Managed Instance will be operating in. Default value is `UTC`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] vcores: Number of cores that should be assigned to the SQL Managed Instance. Values can be `8`, `16`, or `24` for Gen4 SKUs, or `4`, `6`, `8`, `10`, `12`, `16`, `20`, `24`, `32`, `40`, `48`, `56`, `64`, `80`, `96` or `128` for Gen5 SKUs.
        :param pulumi.Input[_builtins.bool] zone_redundant_enabled: Specifies whether or not the SQL Managed Instance is zone redundant. Defaults to `false`.
        """
        if administrator_login is not None:
            pulumi.set(__self__, "administrator_login", administrator_login)
        if administrator_login_password is not None:
            pulumi.set(__self__, "administrator_login_password", administrator_login_password)
        if azure_active_directory_administrator is not None:
            pulumi.set(__self__, "azure_active_directory_administrator", azure_active_directory_administrator)
        if collation is not None:
            pulumi.set(__self__, "collation", collation)
        if database_format is not None:
            pulumi.set(__self__, "database_format", database_format)
        if dns_zone is not None:
            pulumi.set(__self__, "dns_zone", dns_zone)
        if dns_zone_partner_id is not None:
            pulumi.set(__self__, "dns_zone_partner_id", dns_zone_partner_id)
        if fqdn is not None:
            pulumi.set(__self__, "fqdn", fqdn)
        if hybrid_secondary_usage is not None:
            pulumi.set(__self__, "hybrid_secondary_usage", hybrid_secondary_usage)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if license_type is not None:
            pulumi.set(__self__, "license_type", license_type)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if maintenance_configuration_name is not None:
            pulumi.set(__self__, "maintenance_configuration_name", maintenance_configuration_name)
        if minimum_tls_version is not None:
            pulumi.set(__self__, "minimum_tls_version", minimum_tls_version)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if proxy_override is not None:
            pulumi.set(__self__, "proxy_override", proxy_override)
        if public_data_endpoint_enabled is not None:
            pulumi.set(__self__, "public_data_endpoint_enabled", public_data_endpoint_enabled)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if service_principal_type is not None:
            pulumi.set(__self__, "service_principal_type", service_principal_type)
        if sku_name is not None:
            pulumi.set(__self__, "sku_name", sku_name)
        if storage_account_type is not None:
            pulumi.set(__self__, "storage_account_type", storage_account_type)
        if storage_size_in_gb is not None:
            pulumi.set(__self__, "storage_size_in_gb", storage_size_in_gb)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if timezone_id is not None:
            pulumi.set(__self__, "timezone_id", timezone_id)
        if vcores is not None:
            pulumi.set(__self__, "vcores", vcores)
        if zone_redundant_enabled is not None:
            pulumi.set(__self__, "zone_redundant_enabled", zone_redundant_enabled)

    @_builtins.property
    @pulumi.getter(name="administratorLogin")
    def administrator_login(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The administrator login name for the new SQL Managed Instance. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "administrator_login")

    @administrator_login.setter
    def administrator_login(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "administrator_login", value)

    @_builtins.property
    @pulumi.getter(name="administratorLoginPassword")
    def administrator_login_password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The password associated with the `administrator_login` user. Needs to comply with Azure's [Password Policy](https://msdn.microsoft.com/library/ms161959.aspx)
        """
        return pulumi.get(self, "administrator_login_password")

    @administrator_login_password.setter
    def administrator_login_password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "administrator_login_password", value)

    @_builtins.property
    @pulumi.getter(name="azureActiveDirectoryAdministrator")
    def azure_active_directory_administrator(self) -> Optional[pulumi.Input['ManagedInstanceAzureActiveDirectoryAdministratorArgs']]:
        """
        An `azure_active_directory_administrator` block as defined below.
        """
        return pulumi.get(self, "azure_active_directory_administrator")

    @azure_active_directory_administrator.setter
    def azure_active_directory_administrator(self, value: Optional[pulumi.Input['ManagedInstanceAzureActiveDirectoryAdministratorArgs']]):
        pulumi.set(self, "azure_active_directory_administrator", value)

    @_builtins.property
    @pulumi.getter
    def collation(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies how the SQL Managed Instance will be collated. Default value is `SQL_Latin1_General_CP1_CI_AS`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "collation")

    @collation.setter
    def collation(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "collation", value)

    @_builtins.property
    @pulumi.getter(name="databaseFormat")
    def database_format(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the internal format of the SQL Managed Instance databases specific to the SQL engine version. Possible values are `AlwaysUpToDate` and `SQLServer2022`. Defaults to `SQLServer2022`.

        > **Note:** Changing `database_format` from `AlwaysUpToDate` to `SQLServer2022` forces a new SQL Managed Instance to be created.
        """
        return pulumi.get(self, "database_format")

    @database_format.setter
    def database_format(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "database_format", value)

    @_builtins.property
    @pulumi.getter(name="dnsZone")
    def dns_zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Dns Zone where the SQL Managed Instance is located.
        """
        return pulumi.get(self, "dns_zone")

    @dns_zone.setter
    def dns_zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dns_zone", value)

    @_builtins.property
    @pulumi.getter(name="dnsZonePartnerId")
    def dns_zone_partner_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the SQL Managed Instance which will share the DNS zone. This is a prerequisite for creating an `azurerm_sql_managed_instance_failover_group`. Setting this after creation forces a new resource to be created.
        """
        return pulumi.get(self, "dns_zone_partner_id")

    @dns_zone_partner_id.setter
    def dns_zone_partner_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dns_zone_partner_id", value)

    @_builtins.property
    @pulumi.getter
    def fqdn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The fully qualified domain name of the Azure Managed SQL Instance
        """
        return pulumi.get(self, "fqdn")

    @fqdn.setter
    def fqdn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "fqdn", value)

    @_builtins.property
    @pulumi.getter(name="hybridSecondaryUsage")
    def hybrid_secondary_usage(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the hybrid secondary usage for disaster recovery of the SQL Managed Instance. Possible values are `Active` and `Passive`. Defaults to `Active`.
        """
        return pulumi.get(self, "hybrid_secondary_usage")

    @hybrid_secondary_usage.setter
    def hybrid_secondary_usage(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "hybrid_secondary_usage", value)

    @_builtins.property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['ManagedInstanceIdentityArgs']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['ManagedInstanceIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @_builtins.property
    @pulumi.getter(name="licenseType")
    def license_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        What type of license the Managed Instance will use. Possible values are `LicenseIncluded` and `BasePrice`.
        """
        return pulumi.get(self, "license_type")

    @license_type.setter
    def license_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "license_type", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="maintenanceConfigurationName")
    def maintenance_configuration_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Public Maintenance Configuration window to apply to the SQL Managed Instance. Valid values include `SQL_Default` or an Azure Location in the format `SQL_{Location}_MI_{Size}`(for example `SQL_EastUS_MI_1`). Defaults to `SQL_Default`.
        """
        return pulumi.get(self, "maintenance_configuration_name")

    @maintenance_configuration_name.setter
    def maintenance_configuration_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "maintenance_configuration_name", value)

    @_builtins.property
    @pulumi.getter(name="minimumTlsVersion")
    def minimum_tls_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Minimum TLS Version. Default value is `1.2` Valid values include `1.0`, `1.1`, `1.2`.

        > **Note:** Azure Services will require TLS 1.2+ by August 2025, please see this [announcement](https://azure.microsoft.com/en-us/updates/v2/update-retirement-tls1-0-tls1-1-versions-azure-services/) for more.
        """
        return pulumi.get(self, "minimum_tls_version")

    @minimum_tls_version.setter
    def minimum_tls_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "minimum_tls_version", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the SQL Managed Instance. This needs to be globally unique within Azure. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="proxyOverride")
    def proxy_override(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies how the SQL Managed Instance will be accessed. Default value is `Default`. Valid values include `Default`, `Proxy`, and `Redirect`.
        """
        return pulumi.get(self, "proxy_override")

    @proxy_override.setter
    def proxy_override(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "proxy_override", value)

    @_builtins.property
    @pulumi.getter(name="publicDataEndpointEnabled")
    def public_data_endpoint_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Is the public data endpoint enabled? Default value is `false`.
        """
        return pulumi.get(self, "public_data_endpoint_enabled")

    @public_data_endpoint_enabled.setter
    def public_data_endpoint_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "public_data_endpoint_enabled", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the resource group in which to create the SQL Managed Instance. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="servicePrincipalType")
    def service_principal_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The service principal type. The only possible value is `SystemAssigned`.
        """
        return pulumi.get(self, "service_principal_type")

    @service_principal_type.setter
    def service_principal_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_principal_type", value)

    @_builtins.property
    @pulumi.getter(name="skuName")
    def sku_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the SKU Name for the SQL Managed Instance. Valid values include `GP_Gen4`, `GP_Gen5`, `GP_Gen8IM`, `GP_Gen8IH`, `BC_Gen4`, `BC_Gen5`, `BC_Gen8IM` or `BC_Gen8IH`.
        """
        return pulumi.get(self, "sku_name")

    @sku_name.setter
    def sku_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sku_name", value)

    @_builtins.property
    @pulumi.getter(name="storageAccountType")
    def storage_account_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the storage account type used to store backups for this database. Possible values are `GRS`, `GZRS`, `LRS`, and `ZRS`. Defaults to `GRS`.
        """
        return pulumi.get(self, "storage_account_type")

    @storage_account_type.setter
    def storage_account_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_account_type", value)

    @_builtins.property
    @pulumi.getter(name="storageSizeInGb")
    def storage_size_in_gb(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Maximum storage space for the SQL Managed instance. This should be a multiple of 32 (GB).
        """
        return pulumi.get(self, "storage_size_in_gb")

    @storage_size_in_gb.setter
    def storage_size_in_gb(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "storage_size_in_gb", value)

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The subnet resource id that the SQL Managed Instance will be associated with.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subnet_id", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="timezoneId")
    def timezone_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The TimeZone ID that the SQL Managed Instance will be operating in. Default value is `UTC`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "timezone_id")

    @timezone_id.setter
    def timezone_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "timezone_id", value)

    @_builtins.property
    @pulumi.getter
    def vcores(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of cores that should be assigned to the SQL Managed Instance. Values can be `8`, `16`, or `24` for Gen4 SKUs, or `4`, `6`, `8`, `10`, `12`, `16`, `20`, `24`, `32`, `40`, `48`, `56`, `64`, `80`, `96` or `128` for Gen5 SKUs.
        """
        return pulumi.get(self, "vcores")

    @vcores.setter
    def vcores(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "vcores", value)

    @_builtins.property
    @pulumi.getter(name="zoneRedundantEnabled")
    def zone_redundant_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether or not the SQL Managed Instance is zone redundant. Defaults to `false`.
        """
        return pulumi.get(self, "zone_redundant_enabled")

    @zone_redundant_enabled.setter
    def zone_redundant_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "zone_redundant_enabled", value)


@pulumi.type_token("azure:mssql/managedInstance:ManagedInstance")
class ManagedInstance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 administrator_login: Optional[pulumi.Input[_builtins.str]] = None,
                 administrator_login_password: Optional[pulumi.Input[_builtins.str]] = None,
                 azure_active_directory_administrator: Optional[pulumi.Input[Union['ManagedInstanceAzureActiveDirectoryAdministratorArgs', 'ManagedInstanceAzureActiveDirectoryAdministratorArgsDict']]] = None,
                 collation: Optional[pulumi.Input[_builtins.str]] = None,
                 database_format: Optional[pulumi.Input[_builtins.str]] = None,
                 dns_zone_partner_id: Optional[pulumi.Input[_builtins.str]] = None,
                 hybrid_secondary_usage: Optional[pulumi.Input[_builtins.str]] = None,
                 identity: Optional[pulumi.Input[Union['ManagedInstanceIdentityArgs', 'ManagedInstanceIdentityArgsDict']]] = None,
                 license_type: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 maintenance_configuration_name: Optional[pulumi.Input[_builtins.str]] = None,
                 minimum_tls_version: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 proxy_override: Optional[pulumi.Input[_builtins.str]] = None,
                 public_data_endpoint_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 service_principal_type: Optional[pulumi.Input[_builtins.str]] = None,
                 sku_name: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_account_type: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_size_in_gb: Optional[pulumi.Input[_builtins.int]] = None,
                 subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 timezone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vcores: Optional[pulumi.Input[_builtins.int]] = None,
                 zone_redundant_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        """
        Manages a Microsoft SQL Azure Managed Instance.

        > **Note:** All arguments including the administrator login and password will be stored in the raw state as plain-text. [Read more about sensitive data in state](https://www.terraform.io/docs/state/sensitive-data.html).

        > **Note:** SQL Managed Instance needs permission to read Azure Active Directory when configuring the AAD administrator. [Read more about provisioning AAD administrators](https://learn.microsoft.com/en-us/azure/azure-sql/database/authentication-aad-configure?view=azuresql#provision-azure-ad-admin-sql-managed-instance).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="database-rg",
            location="West Europe")
        example_network_security_group = azure.network.NetworkSecurityGroup("example",
            name="mi-security-group",
            location=example.location,
            resource_group_name=example.name)
        allow_management_inbound = azure.network.NetworkSecurityRule("allow_management_inbound",
            name="allow_management_inbound",
            priority=106,
            direction="Inbound",
            access="Allow",
            protocol="Tcp",
            source_port_range="*",
            destination_port_ranges=[
                "9000",
                "9003",
                "1438",
                "1440",
                "1452",
            ],
            source_address_prefix="*",
            destination_address_prefix="*",
            resource_group_name=example.name,
            network_security_group_name=example_network_security_group.name)
        allow_misubnet_inbound = azure.network.NetworkSecurityRule("allow_misubnet_inbound",
            name="allow_misubnet_inbound",
            priority=200,
            direction="Inbound",
            access="Allow",
            protocol="*",
            source_port_range="*",
            destination_port_range="*",
            source_address_prefix="10.0.0.0/24",
            destination_address_prefix="*",
            resource_group_name=example.name,
            network_security_group_name=example_network_security_group.name)
        allow_health_probe_inbound = azure.network.NetworkSecurityRule("allow_health_probe_inbound",
            name="allow_health_probe_inbound",
            priority=300,
            direction="Inbound",
            access="Allow",
            protocol="*",
            source_port_range="*",
            destination_port_range="*",
            source_address_prefix="AzureLoadBalancer",
            destination_address_prefix="*",
            resource_group_name=example.name,
            network_security_group_name=example_network_security_group.name)
        allow_tds_inbound = azure.network.NetworkSecurityRule("allow_tds_inbound",
            name="allow_tds_inbound",
            priority=1000,
            direction="Inbound",
            access="Allow",
            protocol="Tcp",
            source_port_range="*",
            destination_port_range="1433",
            source_address_prefix="VirtualNetwork",
            destination_address_prefix="*",
            resource_group_name=example.name,
            network_security_group_name=example_network_security_group.name)
        deny_all_inbound = azure.network.NetworkSecurityRule("deny_all_inbound",
            name="deny_all_inbound",
            priority=4096,
            direction="Inbound",
            access="Deny",
            protocol="*",
            source_port_range="*",
            destination_port_range="*",
            source_address_prefix="*",
            destination_address_prefix="*",
            resource_group_name=example.name,
            network_security_group_name=example_network_security_group.name)
        allow_management_outbound = azure.network.NetworkSecurityRule("allow_management_outbound",
            name="allow_management_outbound",
            priority=102,
            direction="Outbound",
            access="Allow",
            protocol="Tcp",
            source_port_range="*",
            destination_port_ranges=[
                "80",
                "443",
                "12000",
            ],
            source_address_prefix="*",
            destination_address_prefix="*",
            resource_group_name=example.name,
            network_security_group_name=example_network_security_group.name)
        allow_misubnet_outbound = azure.network.NetworkSecurityRule("allow_misubnet_outbound",
            name="allow_misubnet_outbound",
            priority=200,
            direction="Outbound",
            access="Allow",
            protocol="*",
            source_port_range="*",
            destination_port_range="*",
            source_address_prefix="10.0.0.0/24",
            destination_address_prefix="*",
            resource_group_name=example.name,
            network_security_group_name=example_network_security_group.name)
        deny_all_outbound = azure.network.NetworkSecurityRule("deny_all_outbound",
            name="deny_all_outbound",
            priority=4096,
            direction="Outbound",
            access="Deny",
            protocol="*",
            source_port_range="*",
            destination_port_range="*",
            source_address_prefix="*",
            destination_address_prefix="*",
            resource_group_name=example.name,
            network_security_group_name=example_network_security_group.name)
        example_virtual_network = azure.network.VirtualNetwork("example",
            name="vnet-mi",
            resource_group_name=example.name,
            address_spaces=["10.0.0.0/16"],
            location=example.location)
        example_subnet = azure.network.Subnet("example",
            name="subnet-mi",
            resource_group_name=example.name,
            virtual_network_name=example_virtual_network.name,
            address_prefixes=["10.0.0.0/24"],
            delegations=[{
                "name": "managedinstancedelegation",
                "service_delegation": {
                    "name": "Microsoft.Sql/managedInstances",
                    "actions": [
                        "Microsoft.Network/virtualNetworks/subnets/join/action",
                        "Microsoft.Network/virtualNetworks/subnets/prepareNetworkPolicies/action",
                        "Microsoft.Network/virtualNetworks/subnets/unprepareNetworkPolicies/action",
                    ],
                },
            }])
        example_subnet_network_security_group_association = azure.network.SubnetNetworkSecurityGroupAssociation("example",
            subnet_id=example_subnet.id,
            network_security_group_id=example_network_security_group.id)
        example_route_table = azure.network.RouteTable("example",
            name="routetable-mi",
            location=example.location,
            resource_group_name=example.name,
            bgp_route_propagation_enabled=True,
            opts = pulumi.ResourceOptions(depends_on=[example_subnet]))
        example_subnet_route_table_association = azure.network.SubnetRouteTableAssociation("example",
            subnet_id=example_subnet.id,
            route_table_id=example_route_table.id)
        example_managed_instance = azure.mssql.ManagedInstance("example",
            name="managedsqlinstance",
            resource_group_name=example.name,
            location=example.location,
            license_type="BasePrice",
            sku_name="GP_Gen5",
            storage_size_in_gb=32,
            subnet_id=example_subnet.id,
            vcores=4,
            administrator_login="mradministrator",
            administrator_login_password="thisIsDog11",
            opts = pulumi.ResourceOptions(depends_on=[
                    example_subnet_network_security_group_association,
                    example_subnet_route_table_association,
                ]))
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Sql`: 2023-08-01-preview

        ## Import

        Microsoft SQL Managed Instances can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:mssql/managedInstance:ManagedInstance example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myresourcegroup/providers/Microsoft.Sql/managedInstances/myserver
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] administrator_login: The administrator login name for the new SQL Managed Instance. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] administrator_login_password: The password associated with the `administrator_login` user. Needs to comply with Azure's [Password Policy](https://msdn.microsoft.com/library/ms161959.aspx)
        :param pulumi.Input[Union['ManagedInstanceAzureActiveDirectoryAdministratorArgs', 'ManagedInstanceAzureActiveDirectoryAdministratorArgsDict']] azure_active_directory_administrator: An `azure_active_directory_administrator` block as defined below.
        :param pulumi.Input[_builtins.str] collation: Specifies how the SQL Managed Instance will be collated. Default value is `SQL_Latin1_General_CP1_CI_AS`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] database_format: Specifies the internal format of the SQL Managed Instance databases specific to the SQL engine version. Possible values are `AlwaysUpToDate` and `SQLServer2022`. Defaults to `SQLServer2022`.
               
               > **Note:** Changing `database_format` from `AlwaysUpToDate` to `SQLServer2022` forces a new SQL Managed Instance to be created.
        :param pulumi.Input[_builtins.str] dns_zone_partner_id: The ID of the SQL Managed Instance which will share the DNS zone. This is a prerequisite for creating an `azurerm_sql_managed_instance_failover_group`. Setting this after creation forces a new resource to be created.
        :param pulumi.Input[_builtins.str] hybrid_secondary_usage: Specifies the hybrid secondary usage for disaster recovery of the SQL Managed Instance. Possible values are `Active` and `Passive`. Defaults to `Active`.
        :param pulumi.Input[Union['ManagedInstanceIdentityArgs', 'ManagedInstanceIdentityArgsDict']] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.str] license_type: What type of license the Managed Instance will use. Possible values are `LicenseIncluded` and `BasePrice`.
        :param pulumi.Input[_builtins.str] location: Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] maintenance_configuration_name: The name of the Public Maintenance Configuration window to apply to the SQL Managed Instance. Valid values include `SQL_Default` or an Azure Location in the format `SQL_{Location}_MI_{Size}`(for example `SQL_EastUS_MI_1`). Defaults to `SQL_Default`.
        :param pulumi.Input[_builtins.str] minimum_tls_version: The Minimum TLS Version. Default value is `1.2` Valid values include `1.0`, `1.1`, `1.2`.
               
               > **Note:** Azure Services will require TLS 1.2+ by August 2025, please see this [announcement](https://azure.microsoft.com/en-us/updates/v2/update-retirement-tls1-0-tls1-1-versions-azure-services/) for more.
        :param pulumi.Input[_builtins.str] name: The name of the SQL Managed Instance. This needs to be globally unique within Azure. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] proxy_override: Specifies how the SQL Managed Instance will be accessed. Default value is `Default`. Valid values include `Default`, `Proxy`, and `Redirect`.
        :param pulumi.Input[_builtins.bool] public_data_endpoint_enabled: Is the public data endpoint enabled? Default value is `false`.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which to create the SQL Managed Instance. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] service_principal_type: The service principal type. The only possible value is `SystemAssigned`.
        :param pulumi.Input[_builtins.str] sku_name: Specifies the SKU Name for the SQL Managed Instance. Valid values include `GP_Gen4`, `GP_Gen5`, `GP_Gen8IM`, `GP_Gen8IH`, `BC_Gen4`, `BC_Gen5`, `BC_Gen8IM` or `BC_Gen8IH`.
        :param pulumi.Input[_builtins.str] storage_account_type: Specifies the storage account type used to store backups for this database. Possible values are `GRS`, `GZRS`, `LRS`, and `ZRS`. Defaults to `GRS`.
        :param pulumi.Input[_builtins.int] storage_size_in_gb: Maximum storage space for the SQL Managed instance. This should be a multiple of 32 (GB).
        :param pulumi.Input[_builtins.str] subnet_id: The subnet resource id that the SQL Managed Instance will be associated with.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.str] timezone_id: The TimeZone ID that the SQL Managed Instance will be operating in. Default value is `UTC`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] vcores: Number of cores that should be assigned to the SQL Managed Instance. Values can be `8`, `16`, or `24` for Gen4 SKUs, or `4`, `6`, `8`, `10`, `12`, `16`, `20`, `24`, `32`, `40`, `48`, `56`, `64`, `80`, `96` or `128` for Gen5 SKUs.
        :param pulumi.Input[_builtins.bool] zone_redundant_enabled: Specifies whether or not the SQL Managed Instance is zone redundant. Defaults to `false`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ManagedInstanceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Microsoft SQL Azure Managed Instance.

        > **Note:** All arguments including the administrator login and password will be stored in the raw state as plain-text. [Read more about sensitive data in state](https://www.terraform.io/docs/state/sensitive-data.html).

        > **Note:** SQL Managed Instance needs permission to read Azure Active Directory when configuring the AAD administrator. [Read more about provisioning AAD administrators](https://learn.microsoft.com/en-us/azure/azure-sql/database/authentication-aad-configure?view=azuresql#provision-azure-ad-admin-sql-managed-instance).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="database-rg",
            location="West Europe")
        example_network_security_group = azure.network.NetworkSecurityGroup("example",
            name="mi-security-group",
            location=example.location,
            resource_group_name=example.name)
        allow_management_inbound = azure.network.NetworkSecurityRule("allow_management_inbound",
            name="allow_management_inbound",
            priority=106,
            direction="Inbound",
            access="Allow",
            protocol="Tcp",
            source_port_range="*",
            destination_port_ranges=[
                "9000",
                "9003",
                "1438",
                "1440",
                "1452",
            ],
            source_address_prefix="*",
            destination_address_prefix="*",
            resource_group_name=example.name,
            network_security_group_name=example_network_security_group.name)
        allow_misubnet_inbound = azure.network.NetworkSecurityRule("allow_misubnet_inbound",
            name="allow_misubnet_inbound",
            priority=200,
            direction="Inbound",
            access="Allow",
            protocol="*",
            source_port_range="*",
            destination_port_range="*",
            source_address_prefix="10.0.0.0/24",
            destination_address_prefix="*",
            resource_group_name=example.name,
            network_security_group_name=example_network_security_group.name)
        allow_health_probe_inbound = azure.network.NetworkSecurityRule("allow_health_probe_inbound",
            name="allow_health_probe_inbound",
            priority=300,
            direction="Inbound",
            access="Allow",
            protocol="*",
            source_port_range="*",
            destination_port_range="*",
            source_address_prefix="AzureLoadBalancer",
            destination_address_prefix="*",
            resource_group_name=example.name,
            network_security_group_name=example_network_security_group.name)
        allow_tds_inbound = azure.network.NetworkSecurityRule("allow_tds_inbound",
            name="allow_tds_inbound",
            priority=1000,
            direction="Inbound",
            access="Allow",
            protocol="Tcp",
            source_port_range="*",
            destination_port_range="1433",
            source_address_prefix="VirtualNetwork",
            destination_address_prefix="*",
            resource_group_name=example.name,
            network_security_group_name=example_network_security_group.name)
        deny_all_inbound = azure.network.NetworkSecurityRule("deny_all_inbound",
            name="deny_all_inbound",
            priority=4096,
            direction="Inbound",
            access="Deny",
            protocol="*",
            source_port_range="*",
            destination_port_range="*",
            source_address_prefix="*",
            destination_address_prefix="*",
            resource_group_name=example.name,
            network_security_group_name=example_network_security_group.name)
        allow_management_outbound = azure.network.NetworkSecurityRule("allow_management_outbound",
            name="allow_management_outbound",
            priority=102,
            direction="Outbound",
            access="Allow",
            protocol="Tcp",
            source_port_range="*",
            destination_port_ranges=[
                "80",
                "443",
                "12000",
            ],
            source_address_prefix="*",
            destination_address_prefix="*",
            resource_group_name=example.name,
            network_security_group_name=example_network_security_group.name)
        allow_misubnet_outbound = azure.network.NetworkSecurityRule("allow_misubnet_outbound",
            name="allow_misubnet_outbound",
            priority=200,
            direction="Outbound",
            access="Allow",
            protocol="*",
            source_port_range="*",
            destination_port_range="*",
            source_address_prefix="10.0.0.0/24",
            destination_address_prefix="*",
            resource_group_name=example.name,
            network_security_group_name=example_network_security_group.name)
        deny_all_outbound = azure.network.NetworkSecurityRule("deny_all_outbound",
            name="deny_all_outbound",
            priority=4096,
            direction="Outbound",
            access="Deny",
            protocol="*",
            source_port_range="*",
            destination_port_range="*",
            source_address_prefix="*",
            destination_address_prefix="*",
            resource_group_name=example.name,
            network_security_group_name=example_network_security_group.name)
        example_virtual_network = azure.network.VirtualNetwork("example",
            name="vnet-mi",
            resource_group_name=example.name,
            address_spaces=["10.0.0.0/16"],
            location=example.location)
        example_subnet = azure.network.Subnet("example",
            name="subnet-mi",
            resource_group_name=example.name,
            virtual_network_name=example_virtual_network.name,
            address_prefixes=["10.0.0.0/24"],
            delegations=[{
                "name": "managedinstancedelegation",
                "service_delegation": {
                    "name": "Microsoft.Sql/managedInstances",
                    "actions": [
                        "Microsoft.Network/virtualNetworks/subnets/join/action",
                        "Microsoft.Network/virtualNetworks/subnets/prepareNetworkPolicies/action",
                        "Microsoft.Network/virtualNetworks/subnets/unprepareNetworkPolicies/action",
                    ],
                },
            }])
        example_subnet_network_security_group_association = azure.network.SubnetNetworkSecurityGroupAssociation("example",
            subnet_id=example_subnet.id,
            network_security_group_id=example_network_security_group.id)
        example_route_table = azure.network.RouteTable("example",
            name="routetable-mi",
            location=example.location,
            resource_group_name=example.name,
            bgp_route_propagation_enabled=True,
            opts = pulumi.ResourceOptions(depends_on=[example_subnet]))
        example_subnet_route_table_association = azure.network.SubnetRouteTableAssociation("example",
            subnet_id=example_subnet.id,
            route_table_id=example_route_table.id)
        example_managed_instance = azure.mssql.ManagedInstance("example",
            name="managedsqlinstance",
            resource_group_name=example.name,
            location=example.location,
            license_type="BasePrice",
            sku_name="GP_Gen5",
            storage_size_in_gb=32,
            subnet_id=example_subnet.id,
            vcores=4,
            administrator_login="mradministrator",
            administrator_login_password="thisIsDog11",
            opts = pulumi.ResourceOptions(depends_on=[
                    example_subnet_network_security_group_association,
                    example_subnet_route_table_association,
                ]))
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Sql`: 2023-08-01-preview

        ## Import

        Microsoft SQL Managed Instances can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:mssql/managedInstance:ManagedInstance example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myresourcegroup/providers/Microsoft.Sql/managedInstances/myserver
        ```

        :param str resource_name: The name of the resource.
        :param ManagedInstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ManagedInstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 administrator_login: Optional[pulumi.Input[_builtins.str]] = None,
                 administrator_login_password: Optional[pulumi.Input[_builtins.str]] = None,
                 azure_active_directory_administrator: Optional[pulumi.Input[Union['ManagedInstanceAzureActiveDirectoryAdministratorArgs', 'ManagedInstanceAzureActiveDirectoryAdministratorArgsDict']]] = None,
                 collation: Optional[pulumi.Input[_builtins.str]] = None,
                 database_format: Optional[pulumi.Input[_builtins.str]] = None,
                 dns_zone_partner_id: Optional[pulumi.Input[_builtins.str]] = None,
                 hybrid_secondary_usage: Optional[pulumi.Input[_builtins.str]] = None,
                 identity: Optional[pulumi.Input[Union['ManagedInstanceIdentityArgs', 'ManagedInstanceIdentityArgsDict']]] = None,
                 license_type: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 maintenance_configuration_name: Optional[pulumi.Input[_builtins.str]] = None,
                 minimum_tls_version: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 proxy_override: Optional[pulumi.Input[_builtins.str]] = None,
                 public_data_endpoint_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 service_principal_type: Optional[pulumi.Input[_builtins.str]] = None,
                 sku_name: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_account_type: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_size_in_gb: Optional[pulumi.Input[_builtins.int]] = None,
                 subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 timezone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vcores: Optional[pulumi.Input[_builtins.int]] = None,
                 zone_redundant_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ManagedInstanceArgs.__new__(ManagedInstanceArgs)

            __props__.__dict__["administrator_login"] = administrator_login
            __props__.__dict__["administrator_login_password"] = None if administrator_login_password is None else pulumi.Output.secret(administrator_login_password)
            __props__.__dict__["azure_active_directory_administrator"] = azure_active_directory_administrator
            __props__.__dict__["collation"] = collation
            __props__.__dict__["database_format"] = database_format
            __props__.__dict__["dns_zone_partner_id"] = dns_zone_partner_id
            __props__.__dict__["hybrid_secondary_usage"] = hybrid_secondary_usage
            __props__.__dict__["identity"] = identity
            if license_type is None and not opts.urn:
                raise TypeError("Missing required property 'license_type'")
            __props__.__dict__["license_type"] = license_type
            __props__.__dict__["location"] = location
            __props__.__dict__["maintenance_configuration_name"] = maintenance_configuration_name
            __props__.__dict__["minimum_tls_version"] = minimum_tls_version
            __props__.__dict__["name"] = name
            __props__.__dict__["proxy_override"] = proxy_override
            __props__.__dict__["public_data_endpoint_enabled"] = public_data_endpoint_enabled
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["service_principal_type"] = service_principal_type
            if sku_name is None and not opts.urn:
                raise TypeError("Missing required property 'sku_name'")
            __props__.__dict__["sku_name"] = sku_name
            __props__.__dict__["storage_account_type"] = storage_account_type
            if storage_size_in_gb is None and not opts.urn:
                raise TypeError("Missing required property 'storage_size_in_gb'")
            __props__.__dict__["storage_size_in_gb"] = storage_size_in_gb
            if subnet_id is None and not opts.urn:
                raise TypeError("Missing required property 'subnet_id'")
            __props__.__dict__["subnet_id"] = subnet_id
            __props__.__dict__["tags"] = tags
            __props__.__dict__["timezone_id"] = timezone_id
            if vcores is None and not opts.urn:
                raise TypeError("Missing required property 'vcores'")
            __props__.__dict__["vcores"] = vcores
            __props__.__dict__["zone_redundant_enabled"] = zone_redundant_enabled
            __props__.__dict__["dns_zone"] = None
            __props__.__dict__["fqdn"] = None
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="azure:sql/managedInstance:ManagedInstance")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["administratorLoginPassword"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(ManagedInstance, __self__).__init__(
            'azure:mssql/managedInstance:ManagedInstance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            administrator_login: Optional[pulumi.Input[_builtins.str]] = None,
            administrator_login_password: Optional[pulumi.Input[_builtins.str]] = None,
            azure_active_directory_administrator: Optional[pulumi.Input[Union['ManagedInstanceAzureActiveDirectoryAdministratorArgs', 'ManagedInstanceAzureActiveDirectoryAdministratorArgsDict']]] = None,
            collation: Optional[pulumi.Input[_builtins.str]] = None,
            database_format: Optional[pulumi.Input[_builtins.str]] = None,
            dns_zone: Optional[pulumi.Input[_builtins.str]] = None,
            dns_zone_partner_id: Optional[pulumi.Input[_builtins.str]] = None,
            fqdn: Optional[pulumi.Input[_builtins.str]] = None,
            hybrid_secondary_usage: Optional[pulumi.Input[_builtins.str]] = None,
            identity: Optional[pulumi.Input[Union['ManagedInstanceIdentityArgs', 'ManagedInstanceIdentityArgsDict']]] = None,
            license_type: Optional[pulumi.Input[_builtins.str]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            maintenance_configuration_name: Optional[pulumi.Input[_builtins.str]] = None,
            minimum_tls_version: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            proxy_override: Optional[pulumi.Input[_builtins.str]] = None,
            public_data_endpoint_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            service_principal_type: Optional[pulumi.Input[_builtins.str]] = None,
            sku_name: Optional[pulumi.Input[_builtins.str]] = None,
            storage_account_type: Optional[pulumi.Input[_builtins.str]] = None,
            storage_size_in_gb: Optional[pulumi.Input[_builtins.int]] = None,
            subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            timezone_id: Optional[pulumi.Input[_builtins.str]] = None,
            vcores: Optional[pulumi.Input[_builtins.int]] = None,
            zone_redundant_enabled: Optional[pulumi.Input[_builtins.bool]] = None) -> 'ManagedInstance':
        """
        Get an existing ManagedInstance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] administrator_login: The administrator login name for the new SQL Managed Instance. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] administrator_login_password: The password associated with the `administrator_login` user. Needs to comply with Azure's [Password Policy](https://msdn.microsoft.com/library/ms161959.aspx)
        :param pulumi.Input[Union['ManagedInstanceAzureActiveDirectoryAdministratorArgs', 'ManagedInstanceAzureActiveDirectoryAdministratorArgsDict']] azure_active_directory_administrator: An `azure_active_directory_administrator` block as defined below.
        :param pulumi.Input[_builtins.str] collation: Specifies how the SQL Managed Instance will be collated. Default value is `SQL_Latin1_General_CP1_CI_AS`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] database_format: Specifies the internal format of the SQL Managed Instance databases specific to the SQL engine version. Possible values are `AlwaysUpToDate` and `SQLServer2022`. Defaults to `SQLServer2022`.
               
               > **Note:** Changing `database_format` from `AlwaysUpToDate` to `SQLServer2022` forces a new SQL Managed Instance to be created.
        :param pulumi.Input[_builtins.str] dns_zone: The Dns Zone where the SQL Managed Instance is located.
        :param pulumi.Input[_builtins.str] dns_zone_partner_id: The ID of the SQL Managed Instance which will share the DNS zone. This is a prerequisite for creating an `azurerm_sql_managed_instance_failover_group`. Setting this after creation forces a new resource to be created.
        :param pulumi.Input[_builtins.str] fqdn: The fully qualified domain name of the Azure Managed SQL Instance
        :param pulumi.Input[_builtins.str] hybrid_secondary_usage: Specifies the hybrid secondary usage for disaster recovery of the SQL Managed Instance. Possible values are `Active` and `Passive`. Defaults to `Active`.
        :param pulumi.Input[Union['ManagedInstanceIdentityArgs', 'ManagedInstanceIdentityArgsDict']] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.str] license_type: What type of license the Managed Instance will use. Possible values are `LicenseIncluded` and `BasePrice`.
        :param pulumi.Input[_builtins.str] location: Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] maintenance_configuration_name: The name of the Public Maintenance Configuration window to apply to the SQL Managed Instance. Valid values include `SQL_Default` or an Azure Location in the format `SQL_{Location}_MI_{Size}`(for example `SQL_EastUS_MI_1`). Defaults to `SQL_Default`.
        :param pulumi.Input[_builtins.str] minimum_tls_version: The Minimum TLS Version. Default value is `1.2` Valid values include `1.0`, `1.1`, `1.2`.
               
               > **Note:** Azure Services will require TLS 1.2+ by August 2025, please see this [announcement](https://azure.microsoft.com/en-us/updates/v2/update-retirement-tls1-0-tls1-1-versions-azure-services/) for more.
        :param pulumi.Input[_builtins.str] name: The name of the SQL Managed Instance. This needs to be globally unique within Azure. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] proxy_override: Specifies how the SQL Managed Instance will be accessed. Default value is `Default`. Valid values include `Default`, `Proxy`, and `Redirect`.
        :param pulumi.Input[_builtins.bool] public_data_endpoint_enabled: Is the public data endpoint enabled? Default value is `false`.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which to create the SQL Managed Instance. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] service_principal_type: The service principal type. The only possible value is `SystemAssigned`.
        :param pulumi.Input[_builtins.str] sku_name: Specifies the SKU Name for the SQL Managed Instance. Valid values include `GP_Gen4`, `GP_Gen5`, `GP_Gen8IM`, `GP_Gen8IH`, `BC_Gen4`, `BC_Gen5`, `BC_Gen8IM` or `BC_Gen8IH`.
        :param pulumi.Input[_builtins.str] storage_account_type: Specifies the storage account type used to store backups for this database. Possible values are `GRS`, `GZRS`, `LRS`, and `ZRS`. Defaults to `GRS`.
        :param pulumi.Input[_builtins.int] storage_size_in_gb: Maximum storage space for the SQL Managed instance. This should be a multiple of 32 (GB).
        :param pulumi.Input[_builtins.str] subnet_id: The subnet resource id that the SQL Managed Instance will be associated with.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.str] timezone_id: The TimeZone ID that the SQL Managed Instance will be operating in. Default value is `UTC`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] vcores: Number of cores that should be assigned to the SQL Managed Instance. Values can be `8`, `16`, or `24` for Gen4 SKUs, or `4`, `6`, `8`, `10`, `12`, `16`, `20`, `24`, `32`, `40`, `48`, `56`, `64`, `80`, `96` or `128` for Gen5 SKUs.
        :param pulumi.Input[_builtins.bool] zone_redundant_enabled: Specifies whether or not the SQL Managed Instance is zone redundant. Defaults to `false`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ManagedInstanceState.__new__(_ManagedInstanceState)

        __props__.__dict__["administrator_login"] = administrator_login
        __props__.__dict__["administrator_login_password"] = administrator_login_password
        __props__.__dict__["azure_active_directory_administrator"] = azure_active_directory_administrator
        __props__.__dict__["collation"] = collation
        __props__.__dict__["database_format"] = database_format
        __props__.__dict__["dns_zone"] = dns_zone
        __props__.__dict__["dns_zone_partner_id"] = dns_zone_partner_id
        __props__.__dict__["fqdn"] = fqdn
        __props__.__dict__["hybrid_secondary_usage"] = hybrid_secondary_usage
        __props__.__dict__["identity"] = identity
        __props__.__dict__["license_type"] = license_type
        __props__.__dict__["location"] = location
        __props__.__dict__["maintenance_configuration_name"] = maintenance_configuration_name
        __props__.__dict__["minimum_tls_version"] = minimum_tls_version
        __props__.__dict__["name"] = name
        __props__.__dict__["proxy_override"] = proxy_override
        __props__.__dict__["public_data_endpoint_enabled"] = public_data_endpoint_enabled
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["service_principal_type"] = service_principal_type
        __props__.__dict__["sku_name"] = sku_name
        __props__.__dict__["storage_account_type"] = storage_account_type
        __props__.__dict__["storage_size_in_gb"] = storage_size_in_gb
        __props__.__dict__["subnet_id"] = subnet_id
        __props__.__dict__["tags"] = tags
        __props__.__dict__["timezone_id"] = timezone_id
        __props__.__dict__["vcores"] = vcores
        __props__.__dict__["zone_redundant_enabled"] = zone_redundant_enabled
        return ManagedInstance(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="administratorLogin")
    def administrator_login(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The administrator login name for the new SQL Managed Instance. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "administrator_login")

    @_builtins.property
    @pulumi.getter(name="administratorLoginPassword")
    def administrator_login_password(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The password associated with the `administrator_login` user. Needs to comply with Azure's [Password Policy](https://msdn.microsoft.com/library/ms161959.aspx)
        """
        return pulumi.get(self, "administrator_login_password")

    @_builtins.property
    @pulumi.getter(name="azureActiveDirectoryAdministrator")
    def azure_active_directory_administrator(self) -> pulumi.Output[Optional['outputs.ManagedInstanceAzureActiveDirectoryAdministrator']]:
        """
        An `azure_active_directory_administrator` block as defined below.
        """
        return pulumi.get(self, "azure_active_directory_administrator")

    @_builtins.property
    @pulumi.getter
    def collation(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies how the SQL Managed Instance will be collated. Default value is `SQL_Latin1_General_CP1_CI_AS`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "collation")

    @_builtins.property
    @pulumi.getter(name="databaseFormat")
    def database_format(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the internal format of the SQL Managed Instance databases specific to the SQL engine version. Possible values are `AlwaysUpToDate` and `SQLServer2022`. Defaults to `SQLServer2022`.

        > **Note:** Changing `database_format` from `AlwaysUpToDate` to `SQLServer2022` forces a new SQL Managed Instance to be created.
        """
        return pulumi.get(self, "database_format")

    @_builtins.property
    @pulumi.getter(name="dnsZone")
    def dns_zone(self) -> pulumi.Output[_builtins.str]:
        """
        The Dns Zone where the SQL Managed Instance is located.
        """
        return pulumi.get(self, "dns_zone")

    @_builtins.property
    @pulumi.getter(name="dnsZonePartnerId")
    def dns_zone_partner_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the SQL Managed Instance which will share the DNS zone. This is a prerequisite for creating an `azurerm_sql_managed_instance_failover_group`. Setting this after creation forces a new resource to be created.
        """
        return pulumi.get(self, "dns_zone_partner_id")

    @_builtins.property
    @pulumi.getter
    def fqdn(self) -> pulumi.Output[_builtins.str]:
        """
        The fully qualified domain name of the Azure Managed SQL Instance
        """
        return pulumi.get(self, "fqdn")

    @_builtins.property
    @pulumi.getter(name="hybridSecondaryUsage")
    def hybrid_secondary_usage(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the hybrid secondary usage for disaster recovery of the SQL Managed Instance. Possible values are `Active` and `Passive`. Defaults to `Active`.
        """
        return pulumi.get(self, "hybrid_secondary_usage")

    @_builtins.property
    @pulumi.getter
    def identity(self) -> pulumi.Output[Optional['outputs.ManagedInstanceIdentity']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @_builtins.property
    @pulumi.getter(name="licenseType")
    def license_type(self) -> pulumi.Output[_builtins.str]:
        """
        What type of license the Managed Instance will use. Possible values are `LicenseIncluded` and `BasePrice`.
        """
        return pulumi.get(self, "license_type")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter(name="maintenanceConfigurationName")
    def maintenance_configuration_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The name of the Public Maintenance Configuration window to apply to the SQL Managed Instance. Valid values include `SQL_Default` or an Azure Location in the format `SQL_{Location}_MI_{Size}`(for example `SQL_EastUS_MI_1`). Defaults to `SQL_Default`.
        """
        return pulumi.get(self, "maintenance_configuration_name")

    @_builtins.property
    @pulumi.getter(name="minimumTlsVersion")
    def minimum_tls_version(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The Minimum TLS Version. Default value is `1.2` Valid values include `1.0`, `1.1`, `1.2`.

        > **Note:** Azure Services will require TLS 1.2+ by August 2025, please see this [announcement](https://azure.microsoft.com/en-us/updates/v2/update-retirement-tls1-0-tls1-1-versions-azure-services/) for more.
        """
        return pulumi.get(self, "minimum_tls_version")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the SQL Managed Instance. This needs to be globally unique within Azure. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="proxyOverride")
    def proxy_override(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies how the SQL Managed Instance will be accessed. Default value is `Default`. Valid values include `Default`, `Proxy`, and `Redirect`.
        """
        return pulumi.get(self, "proxy_override")

    @_builtins.property
    @pulumi.getter(name="publicDataEndpointEnabled")
    def public_data_endpoint_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Is the public data endpoint enabled? Default value is `false`.
        """
        return pulumi.get(self, "public_data_endpoint_enabled")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the resource group in which to create the SQL Managed Instance. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter(name="servicePrincipalType")
    def service_principal_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The service principal type. The only possible value is `SystemAssigned`.
        """
        return pulumi.get(self, "service_principal_type")

    @_builtins.property
    @pulumi.getter(name="skuName")
    def sku_name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the SKU Name for the SQL Managed Instance. Valid values include `GP_Gen4`, `GP_Gen5`, `GP_Gen8IM`, `GP_Gen8IH`, `BC_Gen4`, `BC_Gen5`, `BC_Gen8IM` or `BC_Gen8IH`.
        """
        return pulumi.get(self, "sku_name")

    @_builtins.property
    @pulumi.getter(name="storageAccountType")
    def storage_account_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the storage account type used to store backups for this database. Possible values are `GRS`, `GZRS`, `LRS`, and `ZRS`. Defaults to `GRS`.
        """
        return pulumi.get(self, "storage_account_type")

    @_builtins.property
    @pulumi.getter(name="storageSizeInGb")
    def storage_size_in_gb(self) -> pulumi.Output[_builtins.int]:
        """
        Maximum storage space for the SQL Managed instance. This should be a multiple of 32 (GB).
        """
        return pulumi.get(self, "storage_size_in_gb")

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Output[_builtins.str]:
        """
        The subnet resource id that the SQL Managed Instance will be associated with.
        """
        return pulumi.get(self, "subnet_id")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="timezoneId")
    def timezone_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The TimeZone ID that the SQL Managed Instance will be operating in. Default value is `UTC`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "timezone_id")

    @_builtins.property
    @pulumi.getter
    def vcores(self) -> pulumi.Output[_builtins.int]:
        """
        Number of cores that should be assigned to the SQL Managed Instance. Values can be `8`, `16`, or `24` for Gen4 SKUs, or `4`, `6`, `8`, `10`, `12`, `16`, `20`, `24`, `32`, `40`, `48`, `56`, `64`, `80`, `96` or `128` for Gen5 SKUs.
        """
        return pulumi.get(self, "vcores")

    @_builtins.property
    @pulumi.getter(name="zoneRedundantEnabled")
    def zone_redundant_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether or not the SQL Managed Instance is zone redundant. Defaults to `false`.
        """
        return pulumi.get(self, "zone_redundant_enabled")

