# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ManagedInstanceFailoverGroupArgs', 'ManagedInstanceFailoverGroup']

@pulumi.input_type
class ManagedInstanceFailoverGroupArgs:
    def __init__(__self__, *,
                 managed_instance_id: pulumi.Input[_builtins.str],
                 partner_managed_instance_id: pulumi.Input[_builtins.str],
                 read_write_endpoint_failover_policy: pulumi.Input['ManagedInstanceFailoverGroupReadWriteEndpointFailoverPolicyArgs'],
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 readonly_endpoint_failover_policy_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 secondary_type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a ManagedInstanceFailoverGroup resource.
        :param pulumi.Input[_builtins.str] managed_instance_id: The ID of the Azure SQL Managed Instance which will be replicated using a Managed Instance Failover Group. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] partner_managed_instance_id: The ID of the Azure SQL Managed Instance which will be replicated to. Changing this forces a new resource to be created.
        :param pulumi.Input['ManagedInstanceFailoverGroupReadWriteEndpointFailoverPolicyArgs'] read_write_endpoint_failover_policy: A `read_write_endpoint_failover_policy` block as defined below.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Managed Instance Failover Group should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Managed Instance Failover Group. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] readonly_endpoint_failover_policy_enabled: Failover policy for the read-only endpoint. Defaults to `true`.
        :param pulumi.Input[_builtins.str] secondary_type: The type of the secondary Managed Instance. Possible values are `Geo`, `Standby`. Defaults to `Geo`.
        """
        pulumi.set(__self__, "managed_instance_id", managed_instance_id)
        pulumi.set(__self__, "partner_managed_instance_id", partner_managed_instance_id)
        pulumi.set(__self__, "read_write_endpoint_failover_policy", read_write_endpoint_failover_policy)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if readonly_endpoint_failover_policy_enabled is not None:
            pulumi.set(__self__, "readonly_endpoint_failover_policy_enabled", readonly_endpoint_failover_policy_enabled)
        if secondary_type is not None:
            pulumi.set(__self__, "secondary_type", secondary_type)

    @_builtins.property
    @pulumi.getter(name="managedInstanceId")
    def managed_instance_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Azure SQL Managed Instance which will be replicated using a Managed Instance Failover Group. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "managed_instance_id")

    @managed_instance_id.setter
    def managed_instance_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "managed_instance_id", value)

    @_builtins.property
    @pulumi.getter(name="partnerManagedInstanceId")
    def partner_managed_instance_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Azure SQL Managed Instance which will be replicated to. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "partner_managed_instance_id")

    @partner_managed_instance_id.setter
    def partner_managed_instance_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "partner_managed_instance_id", value)

    @_builtins.property
    @pulumi.getter(name="readWriteEndpointFailoverPolicy")
    def read_write_endpoint_failover_policy(self) -> pulumi.Input['ManagedInstanceFailoverGroupReadWriteEndpointFailoverPolicyArgs']:
        """
        A `read_write_endpoint_failover_policy` block as defined below.
        """
        return pulumi.get(self, "read_write_endpoint_failover_policy")

    @read_write_endpoint_failover_policy.setter
    def read_write_endpoint_failover_policy(self, value: pulumi.Input['ManagedInstanceFailoverGroupReadWriteEndpointFailoverPolicyArgs']):
        pulumi.set(self, "read_write_endpoint_failover_policy", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Azure Region where the Managed Instance Failover Group should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Managed Instance Failover Group. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="readonlyEndpointFailoverPolicyEnabled")
    def readonly_endpoint_failover_policy_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Failover policy for the read-only endpoint. Defaults to `true`.
        """
        return pulumi.get(self, "readonly_endpoint_failover_policy_enabled")

    @readonly_endpoint_failover_policy_enabled.setter
    def readonly_endpoint_failover_policy_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "readonly_endpoint_failover_policy_enabled", value)

    @_builtins.property
    @pulumi.getter(name="secondaryType")
    def secondary_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the secondary Managed Instance. Possible values are `Geo`, `Standby`. Defaults to `Geo`.
        """
        return pulumi.get(self, "secondary_type")

    @secondary_type.setter
    def secondary_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "secondary_type", value)


@pulumi.input_type
class _ManagedInstanceFailoverGroupState:
    def __init__(__self__, *,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 managed_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 partner_managed_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 partner_regions: Optional[pulumi.Input[Sequence[pulumi.Input['ManagedInstanceFailoverGroupPartnerRegionArgs']]]] = None,
                 read_write_endpoint_failover_policy: Optional[pulumi.Input['ManagedInstanceFailoverGroupReadWriteEndpointFailoverPolicyArgs']] = None,
                 readonly_endpoint_failover_policy_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 role: Optional[pulumi.Input[_builtins.str]] = None,
                 secondary_type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ManagedInstanceFailoverGroup resources.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Managed Instance Failover Group should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] managed_instance_id: The ID of the Azure SQL Managed Instance which will be replicated using a Managed Instance Failover Group. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Managed Instance Failover Group. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] partner_managed_instance_id: The ID of the Azure SQL Managed Instance which will be replicated to. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input['ManagedInstanceFailoverGroupPartnerRegionArgs']]] partner_regions: A `partner_region` block as defined below.
        :param pulumi.Input['ManagedInstanceFailoverGroupReadWriteEndpointFailoverPolicyArgs'] read_write_endpoint_failover_policy: A `read_write_endpoint_failover_policy` block as defined below.
        :param pulumi.Input[_builtins.bool] readonly_endpoint_failover_policy_enabled: Failover policy for the read-only endpoint. Defaults to `true`.
        :param pulumi.Input[_builtins.str] role: The partner replication role of the Managed Instance Failover Group.
        :param pulumi.Input[_builtins.str] secondary_type: The type of the secondary Managed Instance. Possible values are `Geo`, `Standby`. Defaults to `Geo`.
        """
        if location is not None:
            pulumi.set(__self__, "location", location)
        if managed_instance_id is not None:
            pulumi.set(__self__, "managed_instance_id", managed_instance_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if partner_managed_instance_id is not None:
            pulumi.set(__self__, "partner_managed_instance_id", partner_managed_instance_id)
        if partner_regions is not None:
            pulumi.set(__self__, "partner_regions", partner_regions)
        if read_write_endpoint_failover_policy is not None:
            pulumi.set(__self__, "read_write_endpoint_failover_policy", read_write_endpoint_failover_policy)
        if readonly_endpoint_failover_policy_enabled is not None:
            pulumi.set(__self__, "readonly_endpoint_failover_policy_enabled", readonly_endpoint_failover_policy_enabled)
        if role is not None:
            pulumi.set(__self__, "role", role)
        if secondary_type is not None:
            pulumi.set(__self__, "secondary_type", secondary_type)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Azure Region where the Managed Instance Failover Group should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="managedInstanceId")
    def managed_instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Azure SQL Managed Instance which will be replicated using a Managed Instance Failover Group. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "managed_instance_id")

    @managed_instance_id.setter
    def managed_instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "managed_instance_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Managed Instance Failover Group. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="partnerManagedInstanceId")
    def partner_managed_instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Azure SQL Managed Instance which will be replicated to. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "partner_managed_instance_id")

    @partner_managed_instance_id.setter
    def partner_managed_instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "partner_managed_instance_id", value)

    @_builtins.property
    @pulumi.getter(name="partnerRegions")
    def partner_regions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ManagedInstanceFailoverGroupPartnerRegionArgs']]]]:
        """
        A `partner_region` block as defined below.
        """
        return pulumi.get(self, "partner_regions")

    @partner_regions.setter
    def partner_regions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ManagedInstanceFailoverGroupPartnerRegionArgs']]]]):
        pulumi.set(self, "partner_regions", value)

    @_builtins.property
    @pulumi.getter(name="readWriteEndpointFailoverPolicy")
    def read_write_endpoint_failover_policy(self) -> Optional[pulumi.Input['ManagedInstanceFailoverGroupReadWriteEndpointFailoverPolicyArgs']]:
        """
        A `read_write_endpoint_failover_policy` block as defined below.
        """
        return pulumi.get(self, "read_write_endpoint_failover_policy")

    @read_write_endpoint_failover_policy.setter
    def read_write_endpoint_failover_policy(self, value: Optional[pulumi.Input['ManagedInstanceFailoverGroupReadWriteEndpointFailoverPolicyArgs']]):
        pulumi.set(self, "read_write_endpoint_failover_policy", value)

    @_builtins.property
    @pulumi.getter(name="readonlyEndpointFailoverPolicyEnabled")
    def readonly_endpoint_failover_policy_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Failover policy for the read-only endpoint. Defaults to `true`.
        """
        return pulumi.get(self, "readonly_endpoint_failover_policy_enabled")

    @readonly_endpoint_failover_policy_enabled.setter
    def readonly_endpoint_failover_policy_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "readonly_endpoint_failover_policy_enabled", value)

    @_builtins.property
    @pulumi.getter
    def role(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The partner replication role of the Managed Instance Failover Group.
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "role", value)

    @_builtins.property
    @pulumi.getter(name="secondaryType")
    def secondary_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the secondary Managed Instance. Possible values are `Geo`, `Standby`. Defaults to `Geo`.
        """
        return pulumi.get(self, "secondary_type")

    @secondary_type.setter
    def secondary_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "secondary_type", value)


@pulumi.type_token("azure:mssql/managedInstanceFailoverGroup:ManagedInstanceFailoverGroup")
class ManagedInstanceFailoverGroup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 managed_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 partner_managed_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 read_write_endpoint_failover_policy: Optional[pulumi.Input[Union['ManagedInstanceFailoverGroupReadWriteEndpointFailoverPolicyArgs', 'ManagedInstanceFailoverGroupReadWriteEndpointFailoverPolicyArgsDict']]] = None,
                 readonly_endpoint_failover_policy_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 secondary_type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages an Azure SQL Managed Instance Failover Group.

        ## Example Usage

        > **Note:** For a more complete example, see the `./examples/sql-azure/managed_instance_failover_group` directory within the GitHub Repository.

        ```python
        import pulumi
        import pulumi_azure as azure

        name = "mymssqlmitest"
        primary_name = f"{name}-primary"
        primary_location = "West Europe"
        failover_name = f"{name}-failover"
        failover_location = "North Europe"
        ## Primary SQL Managed Instance
        primary = azure.core.ResourceGroup("primary",
            name=primary_name,
            location=primary_location)
        example_zone = azure.privatedns.Zone("example",
            name=f"{name}.private",
            resource_group_name=primary.name)
        primary_virtual_network = azure.network.VirtualNetwork("primary",
            name=primary_name,
            location=primary.location,
            resource_group_name=primary.name,
            address_spaces=["10.0.0.0/16"])
        primary_zone_virtual_network_link = azure.privatedns.ZoneVirtualNetworkLink("primary",
            name="primary-link",
            resource_group_name=primary.name,
            private_dns_zone_name=example_zone.name,
            virtual_network_id=primary_virtual_network.id)
        primary_subnet = azure.network.Subnet("primary",
            name=primary_name,
            resource_group_name=primary.name,
            virtual_network_name=primary_virtual_network.name,
            address_prefixes=["10.0.1.0/24"],
            delegations=[{
                "name": "delegation",
                "service_delegation": {
                    "actions": [
                        "Microsoft.Network/virtualNetworks/subnets/join/action",
                        "Microsoft.Network/virtualNetworks/subnets/prepareNetworkPolicies/action",
                        "Microsoft.Network/virtualNetworks/subnets/unprepareNetworkPolicies/action",
                    ],
                    "name": "Microsoft.Sql/managedInstances",
                },
            }])
        primary_network_security_group = azure.network.NetworkSecurityGroup("primary",
            name=primary_name,
            location=primary.location,
            resource_group_name=primary.name)
        primary_subnet_network_security_group_association = azure.network.SubnetNetworkSecurityGroupAssociation("primary",
            subnet_id=primary_subnet.id,
            network_security_group_id=primary_network_security_group.id)
        primary_route_table = azure.network.RouteTable("primary",
            name=primary_name,
            location=primary.location,
            resource_group_name=primary.name)
        primary_subnet_route_table_association = azure.network.SubnetRouteTableAssociation("primary",
            subnet_id=primary_subnet.id,
            route_table_id=primary_route_table.id)
        primary_managed_instance = azure.mssql.ManagedInstance("primary",
            name=primary_name,
            resource_group_name=primary.name,
            location=primary.location,
            administrator_login="mradministrator",
            administrator_login_password="thisIsDog11",
            license_type="BasePrice",
            subnet_id=primary_subnet.id,
            sku_name="GP_Gen5",
            vcores=4,
            storage_size_in_gb=32,
            opts = pulumi.ResourceOptions(depends_on=[
                    primary_subnet_network_security_group_association,
                    primary_subnet_route_table_association,
                ]))
        ## Secondary (Fail-over) SQL Managed Instance
        failover = azure.core.ResourceGroup("failover",
            name=failover_name,
            location=failover_location)
        failover_virtual_network = azure.network.VirtualNetwork("failover",
            name=failover_name,
            location=failover.location,
            resource_group_name=failover.name,
            address_spaces=["10.1.0.0/16"])
        failover_zone_virtual_network_link = azure.privatedns.ZoneVirtualNetworkLink("failover",
            name="failover-link",
            resource_group_name=example_zone.resource_group_name,
            private_dns_zone_name=example_zone.name,
            virtual_network_id=failover_virtual_network.id)
        failover_subnet = azure.network.Subnet("failover",
            name="ManagedInstance",
            resource_group_name=failover.name,
            virtual_network_name=failover_virtual_network.name,
            address_prefixes=["10.1.1.0/24"],
            delegations=[{
                "name": "delegation",
                "service_delegation": {
                    "actions": [
                        "Microsoft.Network/virtualNetworks/subnets/join/action",
                        "Microsoft.Network/virtualNetworks/subnets/prepareNetworkPolicies/action",
                        "Microsoft.Network/virtualNetworks/subnets/unprepareNetworkPolicies/action",
                    ],
                    "name": "Microsoft.Sql/managedInstances",
                },
            }])
        failover_network_security_group = azure.network.NetworkSecurityGroup("failover",
            name=failover_name,
            location=failover.location,
            resource_group_name=failover.name)
        failover_subnet_network_security_group_association = azure.network.SubnetNetworkSecurityGroupAssociation("failover",
            subnet_id=failover_subnet.id,
            network_security_group_id=failover_network_security_group.id)
        failover_route_table = azure.network.RouteTable("failover",
            name=failover_name,
            location=failover.location,
            resource_group_name=failover.name)
        failover_subnet_route_table_association = azure.network.SubnetRouteTableAssociation("failover",
            subnet_id=failover_subnet.id,
            route_table_id=failover_route_table.id)
        failover_managed_instance = azure.mssql.ManagedInstance("failover",
            name=failover_name,
            resource_group_name=failover.name,
            location=failover.location,
            administrator_login="mradministrator",
            administrator_login_password="thisIsDog11",
            license_type="BasePrice",
            subnet_id=failover_subnet.id,
            sku_name="GP_Gen5",
            vcores=4,
            storage_size_in_gb=32,
            dns_zone_partner_id=primary_managed_instance.id,
            opts = pulumi.ResourceOptions(depends_on=[
                    failover_subnet_network_security_group_association,
                    failover_subnet_route_table_association,
                ]))
        example = azure.mssql.ManagedInstanceFailoverGroup("example",
            name="example-failover-group",
            location=primary_managed_instance.location,
            managed_instance_id=primary_managed_instance.id,
            partner_managed_instance_id=failover_managed_instance.id,
            secondary_type="Geo",
            read_write_endpoint_failover_policy={
                "mode": "Automatic",
                "grace_minutes": 60,
            },
            opts = pulumi.ResourceOptions(depends_on=[
                    primary_zone_virtual_network_link,
                    failover_zone_virtual_network_link,
                ]))
        primary_to_failover = azure.network.VirtualNetworkPeering("primary_to_failover",
            name="primary-to-failover",
            remote_virtual_network_id=failover_virtual_network.id,
            resource_group_name=primary.name,
            virtual_network_name=primary_virtual_network.name)
        default = azure.network.Subnet("default",
            name="default",
            resource_group_name=failover.name,
            virtual_network_name=failover_virtual_network.name,
            address_prefixes=["10.1.0.0/24"])
        failover_to_primary = azure.network.VirtualNetworkPeering("failover_to_primary",
            name="failover-to-primary",
            remote_virtual_network_id=primary_virtual_network.id,
            resource_group_name=failover.name,
            virtual_network_name=failover_virtual_network.name)
        ```

        > **Note:** There are many prerequisites that must be in place before creating the failover group. To see them all, refer to [Configure a failover group for Azure SQL Managed Instance](https://learn.microsoft.com/en-us/azure/azure-sql/managed-instance/failover-group-configure-sql-mi).

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Sql`: 2023-08-01-preview

        ## Import

        SQL Instance Failover Groups can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:mssql/managedInstanceFailoverGroup:ManagedInstanceFailoverGroup example /subscriptions/12345678-1234-9876-4563-123456789012/resourceGroups/resGroup1/providers/Microsoft.Sql/locations/Location/instanceFailoverGroups/failoverGroup1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Managed Instance Failover Group should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] managed_instance_id: The ID of the Azure SQL Managed Instance which will be replicated using a Managed Instance Failover Group. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Managed Instance Failover Group. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] partner_managed_instance_id: The ID of the Azure SQL Managed Instance which will be replicated to. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['ManagedInstanceFailoverGroupReadWriteEndpointFailoverPolicyArgs', 'ManagedInstanceFailoverGroupReadWriteEndpointFailoverPolicyArgsDict']] read_write_endpoint_failover_policy: A `read_write_endpoint_failover_policy` block as defined below.
        :param pulumi.Input[_builtins.bool] readonly_endpoint_failover_policy_enabled: Failover policy for the read-only endpoint. Defaults to `true`.
        :param pulumi.Input[_builtins.str] secondary_type: The type of the secondary Managed Instance. Possible values are `Geo`, `Standby`. Defaults to `Geo`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ManagedInstanceFailoverGroupArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an Azure SQL Managed Instance Failover Group.

        ## Example Usage

        > **Note:** For a more complete example, see the `./examples/sql-azure/managed_instance_failover_group` directory within the GitHub Repository.

        ```python
        import pulumi
        import pulumi_azure as azure

        name = "mymssqlmitest"
        primary_name = f"{name}-primary"
        primary_location = "West Europe"
        failover_name = f"{name}-failover"
        failover_location = "North Europe"
        ## Primary SQL Managed Instance
        primary = azure.core.ResourceGroup("primary",
            name=primary_name,
            location=primary_location)
        example_zone = azure.privatedns.Zone("example",
            name=f"{name}.private",
            resource_group_name=primary.name)
        primary_virtual_network = azure.network.VirtualNetwork("primary",
            name=primary_name,
            location=primary.location,
            resource_group_name=primary.name,
            address_spaces=["10.0.0.0/16"])
        primary_zone_virtual_network_link = azure.privatedns.ZoneVirtualNetworkLink("primary",
            name="primary-link",
            resource_group_name=primary.name,
            private_dns_zone_name=example_zone.name,
            virtual_network_id=primary_virtual_network.id)
        primary_subnet = azure.network.Subnet("primary",
            name=primary_name,
            resource_group_name=primary.name,
            virtual_network_name=primary_virtual_network.name,
            address_prefixes=["10.0.1.0/24"],
            delegations=[{
                "name": "delegation",
                "service_delegation": {
                    "actions": [
                        "Microsoft.Network/virtualNetworks/subnets/join/action",
                        "Microsoft.Network/virtualNetworks/subnets/prepareNetworkPolicies/action",
                        "Microsoft.Network/virtualNetworks/subnets/unprepareNetworkPolicies/action",
                    ],
                    "name": "Microsoft.Sql/managedInstances",
                },
            }])
        primary_network_security_group = azure.network.NetworkSecurityGroup("primary",
            name=primary_name,
            location=primary.location,
            resource_group_name=primary.name)
        primary_subnet_network_security_group_association = azure.network.SubnetNetworkSecurityGroupAssociation("primary",
            subnet_id=primary_subnet.id,
            network_security_group_id=primary_network_security_group.id)
        primary_route_table = azure.network.RouteTable("primary",
            name=primary_name,
            location=primary.location,
            resource_group_name=primary.name)
        primary_subnet_route_table_association = azure.network.SubnetRouteTableAssociation("primary",
            subnet_id=primary_subnet.id,
            route_table_id=primary_route_table.id)
        primary_managed_instance = azure.mssql.ManagedInstance("primary",
            name=primary_name,
            resource_group_name=primary.name,
            location=primary.location,
            administrator_login="mradministrator",
            administrator_login_password="thisIsDog11",
            license_type="BasePrice",
            subnet_id=primary_subnet.id,
            sku_name="GP_Gen5",
            vcores=4,
            storage_size_in_gb=32,
            opts = pulumi.ResourceOptions(depends_on=[
                    primary_subnet_network_security_group_association,
                    primary_subnet_route_table_association,
                ]))
        ## Secondary (Fail-over) SQL Managed Instance
        failover = azure.core.ResourceGroup("failover",
            name=failover_name,
            location=failover_location)
        failover_virtual_network = azure.network.VirtualNetwork("failover",
            name=failover_name,
            location=failover.location,
            resource_group_name=failover.name,
            address_spaces=["10.1.0.0/16"])
        failover_zone_virtual_network_link = azure.privatedns.ZoneVirtualNetworkLink("failover",
            name="failover-link",
            resource_group_name=example_zone.resource_group_name,
            private_dns_zone_name=example_zone.name,
            virtual_network_id=failover_virtual_network.id)
        failover_subnet = azure.network.Subnet("failover",
            name="ManagedInstance",
            resource_group_name=failover.name,
            virtual_network_name=failover_virtual_network.name,
            address_prefixes=["10.1.1.0/24"],
            delegations=[{
                "name": "delegation",
                "service_delegation": {
                    "actions": [
                        "Microsoft.Network/virtualNetworks/subnets/join/action",
                        "Microsoft.Network/virtualNetworks/subnets/prepareNetworkPolicies/action",
                        "Microsoft.Network/virtualNetworks/subnets/unprepareNetworkPolicies/action",
                    ],
                    "name": "Microsoft.Sql/managedInstances",
                },
            }])
        failover_network_security_group = azure.network.NetworkSecurityGroup("failover",
            name=failover_name,
            location=failover.location,
            resource_group_name=failover.name)
        failover_subnet_network_security_group_association = azure.network.SubnetNetworkSecurityGroupAssociation("failover",
            subnet_id=failover_subnet.id,
            network_security_group_id=failover_network_security_group.id)
        failover_route_table = azure.network.RouteTable("failover",
            name=failover_name,
            location=failover.location,
            resource_group_name=failover.name)
        failover_subnet_route_table_association = azure.network.SubnetRouteTableAssociation("failover",
            subnet_id=failover_subnet.id,
            route_table_id=failover_route_table.id)
        failover_managed_instance = azure.mssql.ManagedInstance("failover",
            name=failover_name,
            resource_group_name=failover.name,
            location=failover.location,
            administrator_login="mradministrator",
            administrator_login_password="thisIsDog11",
            license_type="BasePrice",
            subnet_id=failover_subnet.id,
            sku_name="GP_Gen5",
            vcores=4,
            storage_size_in_gb=32,
            dns_zone_partner_id=primary_managed_instance.id,
            opts = pulumi.ResourceOptions(depends_on=[
                    failover_subnet_network_security_group_association,
                    failover_subnet_route_table_association,
                ]))
        example = azure.mssql.ManagedInstanceFailoverGroup("example",
            name="example-failover-group",
            location=primary_managed_instance.location,
            managed_instance_id=primary_managed_instance.id,
            partner_managed_instance_id=failover_managed_instance.id,
            secondary_type="Geo",
            read_write_endpoint_failover_policy={
                "mode": "Automatic",
                "grace_minutes": 60,
            },
            opts = pulumi.ResourceOptions(depends_on=[
                    primary_zone_virtual_network_link,
                    failover_zone_virtual_network_link,
                ]))
        primary_to_failover = azure.network.VirtualNetworkPeering("primary_to_failover",
            name="primary-to-failover",
            remote_virtual_network_id=failover_virtual_network.id,
            resource_group_name=primary.name,
            virtual_network_name=primary_virtual_network.name)
        default = azure.network.Subnet("default",
            name="default",
            resource_group_name=failover.name,
            virtual_network_name=failover_virtual_network.name,
            address_prefixes=["10.1.0.0/24"])
        failover_to_primary = azure.network.VirtualNetworkPeering("failover_to_primary",
            name="failover-to-primary",
            remote_virtual_network_id=primary_virtual_network.id,
            resource_group_name=failover.name,
            virtual_network_name=failover_virtual_network.name)
        ```

        > **Note:** There are many prerequisites that must be in place before creating the failover group. To see them all, refer to [Configure a failover group for Azure SQL Managed Instance](https://learn.microsoft.com/en-us/azure/azure-sql/managed-instance/failover-group-configure-sql-mi).

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Sql`: 2023-08-01-preview

        ## Import

        SQL Instance Failover Groups can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:mssql/managedInstanceFailoverGroup:ManagedInstanceFailoverGroup example /subscriptions/12345678-1234-9876-4563-123456789012/resourceGroups/resGroup1/providers/Microsoft.Sql/locations/Location/instanceFailoverGroups/failoverGroup1
        ```

        :param str resource_name: The name of the resource.
        :param ManagedInstanceFailoverGroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ManagedInstanceFailoverGroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 managed_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 partner_managed_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 read_write_endpoint_failover_policy: Optional[pulumi.Input[Union['ManagedInstanceFailoverGroupReadWriteEndpointFailoverPolicyArgs', 'ManagedInstanceFailoverGroupReadWriteEndpointFailoverPolicyArgsDict']]] = None,
                 readonly_endpoint_failover_policy_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 secondary_type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ManagedInstanceFailoverGroupArgs.__new__(ManagedInstanceFailoverGroupArgs)

            __props__.__dict__["location"] = location
            if managed_instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'managed_instance_id'")
            __props__.__dict__["managed_instance_id"] = managed_instance_id
            __props__.__dict__["name"] = name
            if partner_managed_instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'partner_managed_instance_id'")
            __props__.__dict__["partner_managed_instance_id"] = partner_managed_instance_id
            if read_write_endpoint_failover_policy is None and not opts.urn:
                raise TypeError("Missing required property 'read_write_endpoint_failover_policy'")
            __props__.__dict__["read_write_endpoint_failover_policy"] = read_write_endpoint_failover_policy
            __props__.__dict__["readonly_endpoint_failover_policy_enabled"] = readonly_endpoint_failover_policy_enabled
            __props__.__dict__["secondary_type"] = secondary_type
            __props__.__dict__["partner_regions"] = None
            __props__.__dict__["role"] = None
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="azure:sql/managedInstanceFailoverGroup:ManagedInstanceFailoverGroup")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        super(ManagedInstanceFailoverGroup, __self__).__init__(
            'azure:mssql/managedInstanceFailoverGroup:ManagedInstanceFailoverGroup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            managed_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            partner_managed_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            partner_regions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ManagedInstanceFailoverGroupPartnerRegionArgs', 'ManagedInstanceFailoverGroupPartnerRegionArgsDict']]]]] = None,
            read_write_endpoint_failover_policy: Optional[pulumi.Input[Union['ManagedInstanceFailoverGroupReadWriteEndpointFailoverPolicyArgs', 'ManagedInstanceFailoverGroupReadWriteEndpointFailoverPolicyArgsDict']]] = None,
            readonly_endpoint_failover_policy_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            role: Optional[pulumi.Input[_builtins.str]] = None,
            secondary_type: Optional[pulumi.Input[_builtins.str]] = None) -> 'ManagedInstanceFailoverGroup':
        """
        Get an existing ManagedInstanceFailoverGroup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Managed Instance Failover Group should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] managed_instance_id: The ID of the Azure SQL Managed Instance which will be replicated using a Managed Instance Failover Group. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Managed Instance Failover Group. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] partner_managed_instance_id: The ID of the Azure SQL Managed Instance which will be replicated to. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ManagedInstanceFailoverGroupPartnerRegionArgs', 'ManagedInstanceFailoverGroupPartnerRegionArgsDict']]]] partner_regions: A `partner_region` block as defined below.
        :param pulumi.Input[Union['ManagedInstanceFailoverGroupReadWriteEndpointFailoverPolicyArgs', 'ManagedInstanceFailoverGroupReadWriteEndpointFailoverPolicyArgsDict']] read_write_endpoint_failover_policy: A `read_write_endpoint_failover_policy` block as defined below.
        :param pulumi.Input[_builtins.bool] readonly_endpoint_failover_policy_enabled: Failover policy for the read-only endpoint. Defaults to `true`.
        :param pulumi.Input[_builtins.str] role: The partner replication role of the Managed Instance Failover Group.
        :param pulumi.Input[_builtins.str] secondary_type: The type of the secondary Managed Instance. Possible values are `Geo`, `Standby`. Defaults to `Geo`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ManagedInstanceFailoverGroupState.__new__(_ManagedInstanceFailoverGroupState)

        __props__.__dict__["location"] = location
        __props__.__dict__["managed_instance_id"] = managed_instance_id
        __props__.__dict__["name"] = name
        __props__.__dict__["partner_managed_instance_id"] = partner_managed_instance_id
        __props__.__dict__["partner_regions"] = partner_regions
        __props__.__dict__["read_write_endpoint_failover_policy"] = read_write_endpoint_failover_policy
        __props__.__dict__["readonly_endpoint_failover_policy_enabled"] = readonly_endpoint_failover_policy_enabled
        __props__.__dict__["role"] = role
        __props__.__dict__["secondary_type"] = secondary_type
        return ManagedInstanceFailoverGroup(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        The Azure Region where the Managed Instance Failover Group should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter(name="managedInstanceId")
    def managed_instance_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Azure SQL Managed Instance which will be replicated using a Managed Instance Failover Group. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "managed_instance_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name which should be used for this Managed Instance Failover Group. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="partnerManagedInstanceId")
    def partner_managed_instance_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Azure SQL Managed Instance which will be replicated to. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "partner_managed_instance_id")

    @_builtins.property
    @pulumi.getter(name="partnerRegions")
    def partner_regions(self) -> pulumi.Output[Sequence['outputs.ManagedInstanceFailoverGroupPartnerRegion']]:
        """
        A `partner_region` block as defined below.
        """
        return pulumi.get(self, "partner_regions")

    @_builtins.property
    @pulumi.getter(name="readWriteEndpointFailoverPolicy")
    def read_write_endpoint_failover_policy(self) -> pulumi.Output['outputs.ManagedInstanceFailoverGroupReadWriteEndpointFailoverPolicy']:
        """
        A `read_write_endpoint_failover_policy` block as defined below.
        """
        return pulumi.get(self, "read_write_endpoint_failover_policy")

    @_builtins.property
    @pulumi.getter(name="readonlyEndpointFailoverPolicyEnabled")
    def readonly_endpoint_failover_policy_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Failover policy for the read-only endpoint. Defaults to `true`.
        """
        return pulumi.get(self, "readonly_endpoint_failover_policy_enabled")

    @_builtins.property
    @pulumi.getter
    def role(self) -> pulumi.Output[_builtins.str]:
        """
        The partner replication role of the Managed Instance Failover Group.
        """
        return pulumi.get(self, "role")

    @_builtins.property
    @pulumi.getter(name="secondaryType")
    def secondary_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The type of the secondary Managed Instance. Possible values are `Geo`, `Standby`. Defaults to `Geo`.
        """
        return pulumi.get(self, "secondary_type")

