# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ManagedInstanceSecurityAlertPolicyArgs', 'ManagedInstanceSecurityAlertPolicy']

@pulumi.input_type
class ManagedInstanceSecurityAlertPolicyArgs:
    def __init__(__self__, *,
                 managed_instance_name: pulumi.Input[_builtins.str],
                 resource_group_name: pulumi.Input[_builtins.str],
                 disabled_alerts: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 email_account_admins_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 email_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 retention_days: Optional[pulumi.Input[_builtins.int]] = None,
                 storage_account_access_key: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_endpoint: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a ManagedInstanceSecurityAlertPolicy resource.
        :param pulumi.Input[_builtins.str] managed_instance_name: Specifies the name of the MS SQL Managed Instance. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group that contains the MS SQL Managed Instance. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] disabled_alerts: Specifies an array of alerts that are disabled. Possible values are `Sql_Injection`, `Sql_Injection_Vulnerability`, `Access_Anomaly`, `Data_Exfiltration`, `Unsafe_Action` and `Brute_Force`.
        :param pulumi.Input[_builtins.bool] email_account_admins_enabled: Boolean flag which specifies if the alert is sent to the account administrators or not. Defaults to `false`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] email_addresses: Specifies an array of email addresses to which the alert is sent.
        :param pulumi.Input[_builtins.bool] enabled: Specifies the state of the Security Alert Policy, whether it is enabled or disabled. Possible values are `true`, `false`.
        :param pulumi.Input[_builtins.int] retention_days: Specifies the number of days to keep in the Threat Detection audit logs. Defaults to `0`.
        :param pulumi.Input[_builtins.str] storage_account_access_key: Specifies the identifier key of the Threat Detection audit storage account. This is mandatory when you use `storage_endpoint` to specify a storage account blob endpoint.
               
               > **Note:** Please note that storage accounts configured with `shared_access_key_enabled = false` cannot be used to configure `mssql.ManagedInstanceSecurityAlertPolicy` with `storage_endpoint` for now.
        :param pulumi.Input[_builtins.str] storage_endpoint: Specifies the blob storage endpoint (e.g. https://example.blob.core.windows.net). This blob storage will hold all Threat Detection audit logs.
        """
        pulumi.set(__self__, "managed_instance_name", managed_instance_name)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if disabled_alerts is not None:
            pulumi.set(__self__, "disabled_alerts", disabled_alerts)
        if email_account_admins_enabled is not None:
            pulumi.set(__self__, "email_account_admins_enabled", email_account_admins_enabled)
        if email_addresses is not None:
            pulumi.set(__self__, "email_addresses", email_addresses)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if retention_days is not None:
            pulumi.set(__self__, "retention_days", retention_days)
        if storage_account_access_key is not None:
            pulumi.set(__self__, "storage_account_access_key", storage_account_access_key)
        if storage_endpoint is not None:
            pulumi.set(__self__, "storage_endpoint", storage_endpoint)

    @_builtins.property
    @pulumi.getter(name="managedInstanceName")
    def managed_instance_name(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the name of the MS SQL Managed Instance. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "managed_instance_name")

    @managed_instance_name.setter
    def managed_instance_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "managed_instance_name", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the resource group that contains the MS SQL Managed Instance. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="disabledAlerts")
    def disabled_alerts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies an array of alerts that are disabled. Possible values are `Sql_Injection`, `Sql_Injection_Vulnerability`, `Access_Anomaly`, `Data_Exfiltration`, `Unsafe_Action` and `Brute_Force`.
        """
        return pulumi.get(self, "disabled_alerts")

    @disabled_alerts.setter
    def disabled_alerts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "disabled_alerts", value)

    @_builtins.property
    @pulumi.getter(name="emailAccountAdminsEnabled")
    def email_account_admins_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Boolean flag which specifies if the alert is sent to the account administrators or not. Defaults to `false`.
        """
        return pulumi.get(self, "email_account_admins_enabled")

    @email_account_admins_enabled.setter
    def email_account_admins_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "email_account_admins_enabled", value)

    @_builtins.property
    @pulumi.getter(name="emailAddresses")
    def email_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies an array of email addresses to which the alert is sent.
        """
        return pulumi.get(self, "email_addresses")

    @email_addresses.setter
    def email_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "email_addresses", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies the state of the Security Alert Policy, whether it is enabled or disabled. Possible values are `true`, `false`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter(name="retentionDays")
    def retention_days(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the number of days to keep in the Threat Detection audit logs. Defaults to `0`.
        """
        return pulumi.get(self, "retention_days")

    @retention_days.setter
    def retention_days(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "retention_days", value)

    @_builtins.property
    @pulumi.getter(name="storageAccountAccessKey")
    def storage_account_access_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the identifier key of the Threat Detection audit storage account. This is mandatory when you use `storage_endpoint` to specify a storage account blob endpoint.

        > **Note:** Please note that storage accounts configured with `shared_access_key_enabled = false` cannot be used to configure `mssql.ManagedInstanceSecurityAlertPolicy` with `storage_endpoint` for now.
        """
        return pulumi.get(self, "storage_account_access_key")

    @storage_account_access_key.setter
    def storage_account_access_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_account_access_key", value)

    @_builtins.property
    @pulumi.getter(name="storageEndpoint")
    def storage_endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the blob storage endpoint (e.g. https://example.blob.core.windows.net). This blob storage will hold all Threat Detection audit logs.
        """
        return pulumi.get(self, "storage_endpoint")

    @storage_endpoint.setter
    def storage_endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_endpoint", value)


@pulumi.input_type
class _ManagedInstanceSecurityAlertPolicyState:
    def __init__(__self__, *,
                 disabled_alerts: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 email_account_admins_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 email_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 managed_instance_name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 retention_days: Optional[pulumi.Input[_builtins.int]] = None,
                 storage_account_access_key: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_endpoint: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ManagedInstanceSecurityAlertPolicy resources.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] disabled_alerts: Specifies an array of alerts that are disabled. Possible values are `Sql_Injection`, `Sql_Injection_Vulnerability`, `Access_Anomaly`, `Data_Exfiltration`, `Unsafe_Action` and `Brute_Force`.
        :param pulumi.Input[_builtins.bool] email_account_admins_enabled: Boolean flag which specifies if the alert is sent to the account administrators or not. Defaults to `false`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] email_addresses: Specifies an array of email addresses to which the alert is sent.
        :param pulumi.Input[_builtins.bool] enabled: Specifies the state of the Security Alert Policy, whether it is enabled or disabled. Possible values are `true`, `false`.
        :param pulumi.Input[_builtins.str] managed_instance_name: Specifies the name of the MS SQL Managed Instance. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group that contains the MS SQL Managed Instance. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] retention_days: Specifies the number of days to keep in the Threat Detection audit logs. Defaults to `0`.
        :param pulumi.Input[_builtins.str] storage_account_access_key: Specifies the identifier key of the Threat Detection audit storage account. This is mandatory when you use `storage_endpoint` to specify a storage account blob endpoint.
               
               > **Note:** Please note that storage accounts configured with `shared_access_key_enabled = false` cannot be used to configure `mssql.ManagedInstanceSecurityAlertPolicy` with `storage_endpoint` for now.
        :param pulumi.Input[_builtins.str] storage_endpoint: Specifies the blob storage endpoint (e.g. https://example.blob.core.windows.net). This blob storage will hold all Threat Detection audit logs.
        """
        if disabled_alerts is not None:
            pulumi.set(__self__, "disabled_alerts", disabled_alerts)
        if email_account_admins_enabled is not None:
            pulumi.set(__self__, "email_account_admins_enabled", email_account_admins_enabled)
        if email_addresses is not None:
            pulumi.set(__self__, "email_addresses", email_addresses)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if managed_instance_name is not None:
            pulumi.set(__self__, "managed_instance_name", managed_instance_name)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if retention_days is not None:
            pulumi.set(__self__, "retention_days", retention_days)
        if storage_account_access_key is not None:
            pulumi.set(__self__, "storage_account_access_key", storage_account_access_key)
        if storage_endpoint is not None:
            pulumi.set(__self__, "storage_endpoint", storage_endpoint)

    @_builtins.property
    @pulumi.getter(name="disabledAlerts")
    def disabled_alerts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies an array of alerts that are disabled. Possible values are `Sql_Injection`, `Sql_Injection_Vulnerability`, `Access_Anomaly`, `Data_Exfiltration`, `Unsafe_Action` and `Brute_Force`.
        """
        return pulumi.get(self, "disabled_alerts")

    @disabled_alerts.setter
    def disabled_alerts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "disabled_alerts", value)

    @_builtins.property
    @pulumi.getter(name="emailAccountAdminsEnabled")
    def email_account_admins_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Boolean flag which specifies if the alert is sent to the account administrators or not. Defaults to `false`.
        """
        return pulumi.get(self, "email_account_admins_enabled")

    @email_account_admins_enabled.setter
    def email_account_admins_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "email_account_admins_enabled", value)

    @_builtins.property
    @pulumi.getter(name="emailAddresses")
    def email_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies an array of email addresses to which the alert is sent.
        """
        return pulumi.get(self, "email_addresses")

    @email_addresses.setter
    def email_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "email_addresses", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies the state of the Security Alert Policy, whether it is enabled or disabled. Possible values are `true`, `false`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter(name="managedInstanceName")
    def managed_instance_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the MS SQL Managed Instance. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "managed_instance_name")

    @managed_instance_name.setter
    def managed_instance_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "managed_instance_name", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the resource group that contains the MS SQL Managed Instance. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="retentionDays")
    def retention_days(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the number of days to keep in the Threat Detection audit logs. Defaults to `0`.
        """
        return pulumi.get(self, "retention_days")

    @retention_days.setter
    def retention_days(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "retention_days", value)

    @_builtins.property
    @pulumi.getter(name="storageAccountAccessKey")
    def storage_account_access_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the identifier key of the Threat Detection audit storage account. This is mandatory when you use `storage_endpoint` to specify a storage account blob endpoint.

        > **Note:** Please note that storage accounts configured with `shared_access_key_enabled = false` cannot be used to configure `mssql.ManagedInstanceSecurityAlertPolicy` with `storage_endpoint` for now.
        """
        return pulumi.get(self, "storage_account_access_key")

    @storage_account_access_key.setter
    def storage_account_access_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_account_access_key", value)

    @_builtins.property
    @pulumi.getter(name="storageEndpoint")
    def storage_endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the blob storage endpoint (e.g. https://example.blob.core.windows.net). This blob storage will hold all Threat Detection audit logs.
        """
        return pulumi.get(self, "storage_endpoint")

    @storage_endpoint.setter
    def storage_endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_endpoint", value)


@pulumi.type_token("azure:mssql/managedInstanceSecurityAlertPolicy:ManagedInstanceSecurityAlertPolicy")
class ManagedInstanceSecurityAlertPolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 disabled_alerts: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 email_account_admins_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 email_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 managed_instance_name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 retention_days: Optional[pulumi.Input[_builtins.int]] = None,
                 storage_account_access_key: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a Security Alert Policy for an MS SQL Managed Instance.

        ## Import

        MS SQL Managed Instance Security Alert Policy can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:mssql/managedInstanceSecurityAlertPolicy:ManagedInstanceSecurityAlertPolicy example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/acceptanceTestResourceGroup1/providers/Microsoft.Sql/managedInstances/instance1/securityAlertPolicies/Default
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] disabled_alerts: Specifies an array of alerts that are disabled. Possible values are `Sql_Injection`, `Sql_Injection_Vulnerability`, `Access_Anomaly`, `Data_Exfiltration`, `Unsafe_Action` and `Brute_Force`.
        :param pulumi.Input[_builtins.bool] email_account_admins_enabled: Boolean flag which specifies if the alert is sent to the account administrators or not. Defaults to `false`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] email_addresses: Specifies an array of email addresses to which the alert is sent.
        :param pulumi.Input[_builtins.bool] enabled: Specifies the state of the Security Alert Policy, whether it is enabled or disabled. Possible values are `true`, `false`.
        :param pulumi.Input[_builtins.str] managed_instance_name: Specifies the name of the MS SQL Managed Instance. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group that contains the MS SQL Managed Instance. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] retention_days: Specifies the number of days to keep in the Threat Detection audit logs. Defaults to `0`.
        :param pulumi.Input[_builtins.str] storage_account_access_key: Specifies the identifier key of the Threat Detection audit storage account. This is mandatory when you use `storage_endpoint` to specify a storage account blob endpoint.
               
               > **Note:** Please note that storage accounts configured with `shared_access_key_enabled = false` cannot be used to configure `mssql.ManagedInstanceSecurityAlertPolicy` with `storage_endpoint` for now.
        :param pulumi.Input[_builtins.str] storage_endpoint: Specifies the blob storage endpoint (e.g. https://example.blob.core.windows.net). This blob storage will hold all Threat Detection audit logs.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ManagedInstanceSecurityAlertPolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Security Alert Policy for an MS SQL Managed Instance.

        ## Import

        MS SQL Managed Instance Security Alert Policy can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:mssql/managedInstanceSecurityAlertPolicy:ManagedInstanceSecurityAlertPolicy example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/acceptanceTestResourceGroup1/providers/Microsoft.Sql/managedInstances/instance1/securityAlertPolicies/Default
        ```

        :param str resource_name: The name of the resource.
        :param ManagedInstanceSecurityAlertPolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ManagedInstanceSecurityAlertPolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 disabled_alerts: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 email_account_admins_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 email_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 managed_instance_name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 retention_days: Optional[pulumi.Input[_builtins.int]] = None,
                 storage_account_access_key: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ManagedInstanceSecurityAlertPolicyArgs.__new__(ManagedInstanceSecurityAlertPolicyArgs)

            __props__.__dict__["disabled_alerts"] = disabled_alerts
            __props__.__dict__["email_account_admins_enabled"] = email_account_admins_enabled
            __props__.__dict__["email_addresses"] = email_addresses
            __props__.__dict__["enabled"] = enabled
            if managed_instance_name is None and not opts.urn:
                raise TypeError("Missing required property 'managed_instance_name'")
            __props__.__dict__["managed_instance_name"] = managed_instance_name
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["retention_days"] = retention_days
            __props__.__dict__["storage_account_access_key"] = None if storage_account_access_key is None else pulumi.Output.secret(storage_account_access_key)
            __props__.__dict__["storage_endpoint"] = storage_endpoint
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["storageAccountAccessKey"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(ManagedInstanceSecurityAlertPolicy, __self__).__init__(
            'azure:mssql/managedInstanceSecurityAlertPolicy:ManagedInstanceSecurityAlertPolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            disabled_alerts: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            email_account_admins_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            email_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            managed_instance_name: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            retention_days: Optional[pulumi.Input[_builtins.int]] = None,
            storage_account_access_key: Optional[pulumi.Input[_builtins.str]] = None,
            storage_endpoint: Optional[pulumi.Input[_builtins.str]] = None) -> 'ManagedInstanceSecurityAlertPolicy':
        """
        Get an existing ManagedInstanceSecurityAlertPolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] disabled_alerts: Specifies an array of alerts that are disabled. Possible values are `Sql_Injection`, `Sql_Injection_Vulnerability`, `Access_Anomaly`, `Data_Exfiltration`, `Unsafe_Action` and `Brute_Force`.
        :param pulumi.Input[_builtins.bool] email_account_admins_enabled: Boolean flag which specifies if the alert is sent to the account administrators or not. Defaults to `false`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] email_addresses: Specifies an array of email addresses to which the alert is sent.
        :param pulumi.Input[_builtins.bool] enabled: Specifies the state of the Security Alert Policy, whether it is enabled or disabled. Possible values are `true`, `false`.
        :param pulumi.Input[_builtins.str] managed_instance_name: Specifies the name of the MS SQL Managed Instance. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group that contains the MS SQL Managed Instance. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] retention_days: Specifies the number of days to keep in the Threat Detection audit logs. Defaults to `0`.
        :param pulumi.Input[_builtins.str] storage_account_access_key: Specifies the identifier key of the Threat Detection audit storage account. This is mandatory when you use `storage_endpoint` to specify a storage account blob endpoint.
               
               > **Note:** Please note that storage accounts configured with `shared_access_key_enabled = false` cannot be used to configure `mssql.ManagedInstanceSecurityAlertPolicy` with `storage_endpoint` for now.
        :param pulumi.Input[_builtins.str] storage_endpoint: Specifies the blob storage endpoint (e.g. https://example.blob.core.windows.net). This blob storage will hold all Threat Detection audit logs.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ManagedInstanceSecurityAlertPolicyState.__new__(_ManagedInstanceSecurityAlertPolicyState)

        __props__.__dict__["disabled_alerts"] = disabled_alerts
        __props__.__dict__["email_account_admins_enabled"] = email_account_admins_enabled
        __props__.__dict__["email_addresses"] = email_addresses
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["managed_instance_name"] = managed_instance_name
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["retention_days"] = retention_days
        __props__.__dict__["storage_account_access_key"] = storage_account_access_key
        __props__.__dict__["storage_endpoint"] = storage_endpoint
        return ManagedInstanceSecurityAlertPolicy(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="disabledAlerts")
    def disabled_alerts(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Specifies an array of alerts that are disabled. Possible values are `Sql_Injection`, `Sql_Injection_Vulnerability`, `Access_Anomaly`, `Data_Exfiltration`, `Unsafe_Action` and `Brute_Force`.
        """
        return pulumi.get(self, "disabled_alerts")

    @_builtins.property
    @pulumi.getter(name="emailAccountAdminsEnabled")
    def email_account_admins_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Boolean flag which specifies if the alert is sent to the account administrators or not. Defaults to `false`.
        """
        return pulumi.get(self, "email_account_admins_enabled")

    @_builtins.property
    @pulumi.getter(name="emailAddresses")
    def email_addresses(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Specifies an array of email addresses to which the alert is sent.
        """
        return pulumi.get(self, "email_addresses")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies the state of the Security Alert Policy, whether it is enabled or disabled. Possible values are `true`, `false`.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="managedInstanceName")
    def managed_instance_name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of the MS SQL Managed Instance. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "managed_instance_name")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the resource group that contains the MS SQL Managed Instance. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter(name="retentionDays")
    def retention_days(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Specifies the number of days to keep in the Threat Detection audit logs. Defaults to `0`.
        """
        return pulumi.get(self, "retention_days")

    @_builtins.property
    @pulumi.getter(name="storageAccountAccessKey")
    def storage_account_access_key(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the identifier key of the Threat Detection audit storage account. This is mandatory when you use `storage_endpoint` to specify a storage account blob endpoint.

        > **Note:** Please note that storage accounts configured with `shared_access_key_enabled = false` cannot be used to configure `mssql.ManagedInstanceSecurityAlertPolicy` with `storage_endpoint` for now.
        """
        return pulumi.get(self, "storage_account_access_key")

    @_builtins.property
    @pulumi.getter(name="storageEndpoint")
    def storage_endpoint(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the blob storage endpoint (e.g. https://example.blob.core.windows.net). This blob storage will hold all Threat Detection audit logs.
        """
        return pulumi.get(self, "storage_endpoint")

