# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ManagedInstanceVulnerabilityAssessmentArgs', 'ManagedInstanceVulnerabilityAssessment']

@pulumi.input_type
class ManagedInstanceVulnerabilityAssessmentArgs:
    def __init__(__self__, *,
                 managed_instance_id: pulumi.Input[_builtins.str],
                 storage_container_path: pulumi.Input[_builtins.str],
                 recurring_scans: Optional[pulumi.Input['ManagedInstanceVulnerabilityAssessmentRecurringScansArgs']] = None,
                 storage_account_access_key: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_container_sas_key: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a ManagedInstanceVulnerabilityAssessment resource.
        :param pulumi.Input[_builtins.str] managed_instance_id: The id of the MS SQL Managed Instance. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] storage_container_path: A blob storage container path to hold the scan results (e.g. <https://myStorage.blob.core.windows.net/VaScans/>).
        :param pulumi.Input['ManagedInstanceVulnerabilityAssessmentRecurringScansArgs'] recurring_scans: The recurring scans settings. The `recurring_scans` block supports fields documented below.
        :param pulumi.Input[_builtins.str] storage_account_access_key: Specifies the identifier key of the storage account for vulnerability assessment scan results. If `storage_container_sas_key` isn't specified, `storage_account_access_key` is required.
               
               > **Note:** The `storage_account_access_key` only applies if the storage account is not behind a virtual network or a firewall.
        :param pulumi.Input[_builtins.str] storage_container_sas_key: A shared access signature (SAS Key) that has write access to the blob container specified in `storage_container_path` parameter. If `storage_account_access_key` isn't specified, `storage_container_sas_key` is required.
               
               > **Note:** The `storage_container_sas_key` only applies if the storage account is not behind a virtual network or a firewall.
        """
        pulumi.set(__self__, "managed_instance_id", managed_instance_id)
        pulumi.set(__self__, "storage_container_path", storage_container_path)
        if recurring_scans is not None:
            pulumi.set(__self__, "recurring_scans", recurring_scans)
        if storage_account_access_key is not None:
            pulumi.set(__self__, "storage_account_access_key", storage_account_access_key)
        if storage_container_sas_key is not None:
            pulumi.set(__self__, "storage_container_sas_key", storage_container_sas_key)

    @_builtins.property
    @pulumi.getter(name="managedInstanceId")
    def managed_instance_id(self) -> pulumi.Input[_builtins.str]:
        """
        The id of the MS SQL Managed Instance. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "managed_instance_id")

    @managed_instance_id.setter
    def managed_instance_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "managed_instance_id", value)

    @_builtins.property
    @pulumi.getter(name="storageContainerPath")
    def storage_container_path(self) -> pulumi.Input[_builtins.str]:
        """
        A blob storage container path to hold the scan results (e.g. <https://myStorage.blob.core.windows.net/VaScans/>).
        """
        return pulumi.get(self, "storage_container_path")

    @storage_container_path.setter
    def storage_container_path(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "storage_container_path", value)

    @_builtins.property
    @pulumi.getter(name="recurringScans")
    def recurring_scans(self) -> Optional[pulumi.Input['ManagedInstanceVulnerabilityAssessmentRecurringScansArgs']]:
        """
        The recurring scans settings. The `recurring_scans` block supports fields documented below.
        """
        return pulumi.get(self, "recurring_scans")

    @recurring_scans.setter
    def recurring_scans(self, value: Optional[pulumi.Input['ManagedInstanceVulnerabilityAssessmentRecurringScansArgs']]):
        pulumi.set(self, "recurring_scans", value)

    @_builtins.property
    @pulumi.getter(name="storageAccountAccessKey")
    def storage_account_access_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the identifier key of the storage account for vulnerability assessment scan results. If `storage_container_sas_key` isn't specified, `storage_account_access_key` is required.

        > **Note:** The `storage_account_access_key` only applies if the storage account is not behind a virtual network or a firewall.
        """
        return pulumi.get(self, "storage_account_access_key")

    @storage_account_access_key.setter
    def storage_account_access_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_account_access_key", value)

    @_builtins.property
    @pulumi.getter(name="storageContainerSasKey")
    def storage_container_sas_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A shared access signature (SAS Key) that has write access to the blob container specified in `storage_container_path` parameter. If `storage_account_access_key` isn't specified, `storage_container_sas_key` is required.

        > **Note:** The `storage_container_sas_key` only applies if the storage account is not behind a virtual network or a firewall.
        """
        return pulumi.get(self, "storage_container_sas_key")

    @storage_container_sas_key.setter
    def storage_container_sas_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_container_sas_key", value)


@pulumi.input_type
class _ManagedInstanceVulnerabilityAssessmentState:
    def __init__(__self__, *,
                 managed_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 recurring_scans: Optional[pulumi.Input['ManagedInstanceVulnerabilityAssessmentRecurringScansArgs']] = None,
                 storage_account_access_key: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_container_path: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_container_sas_key: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ManagedInstanceVulnerabilityAssessment resources.
        :param pulumi.Input[_builtins.str] managed_instance_id: The id of the MS SQL Managed Instance. Changing this forces a new resource to be created.
        :param pulumi.Input['ManagedInstanceVulnerabilityAssessmentRecurringScansArgs'] recurring_scans: The recurring scans settings. The `recurring_scans` block supports fields documented below.
        :param pulumi.Input[_builtins.str] storage_account_access_key: Specifies the identifier key of the storage account for vulnerability assessment scan results. If `storage_container_sas_key` isn't specified, `storage_account_access_key` is required.
               
               > **Note:** The `storage_account_access_key` only applies if the storage account is not behind a virtual network or a firewall.
        :param pulumi.Input[_builtins.str] storage_container_path: A blob storage container path to hold the scan results (e.g. <https://myStorage.blob.core.windows.net/VaScans/>).
        :param pulumi.Input[_builtins.str] storage_container_sas_key: A shared access signature (SAS Key) that has write access to the blob container specified in `storage_container_path` parameter. If `storage_account_access_key` isn't specified, `storage_container_sas_key` is required.
               
               > **Note:** The `storage_container_sas_key` only applies if the storage account is not behind a virtual network or a firewall.
        """
        if managed_instance_id is not None:
            pulumi.set(__self__, "managed_instance_id", managed_instance_id)
        if recurring_scans is not None:
            pulumi.set(__self__, "recurring_scans", recurring_scans)
        if storage_account_access_key is not None:
            pulumi.set(__self__, "storage_account_access_key", storage_account_access_key)
        if storage_container_path is not None:
            pulumi.set(__self__, "storage_container_path", storage_container_path)
        if storage_container_sas_key is not None:
            pulumi.set(__self__, "storage_container_sas_key", storage_container_sas_key)

    @_builtins.property
    @pulumi.getter(name="managedInstanceId")
    def managed_instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The id of the MS SQL Managed Instance. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "managed_instance_id")

    @managed_instance_id.setter
    def managed_instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "managed_instance_id", value)

    @_builtins.property
    @pulumi.getter(name="recurringScans")
    def recurring_scans(self) -> Optional[pulumi.Input['ManagedInstanceVulnerabilityAssessmentRecurringScansArgs']]:
        """
        The recurring scans settings. The `recurring_scans` block supports fields documented below.
        """
        return pulumi.get(self, "recurring_scans")

    @recurring_scans.setter
    def recurring_scans(self, value: Optional[pulumi.Input['ManagedInstanceVulnerabilityAssessmentRecurringScansArgs']]):
        pulumi.set(self, "recurring_scans", value)

    @_builtins.property
    @pulumi.getter(name="storageAccountAccessKey")
    def storage_account_access_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the identifier key of the storage account for vulnerability assessment scan results. If `storage_container_sas_key` isn't specified, `storage_account_access_key` is required.

        > **Note:** The `storage_account_access_key` only applies if the storage account is not behind a virtual network or a firewall.
        """
        return pulumi.get(self, "storage_account_access_key")

    @storage_account_access_key.setter
    def storage_account_access_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_account_access_key", value)

    @_builtins.property
    @pulumi.getter(name="storageContainerPath")
    def storage_container_path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A blob storage container path to hold the scan results (e.g. <https://myStorage.blob.core.windows.net/VaScans/>).
        """
        return pulumi.get(self, "storage_container_path")

    @storage_container_path.setter
    def storage_container_path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_container_path", value)

    @_builtins.property
    @pulumi.getter(name="storageContainerSasKey")
    def storage_container_sas_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A shared access signature (SAS Key) that has write access to the blob container specified in `storage_container_path` parameter. If `storage_account_access_key` isn't specified, `storage_container_sas_key` is required.

        > **Note:** The `storage_container_sas_key` only applies if the storage account is not behind a virtual network or a firewall.
        """
        return pulumi.get(self, "storage_container_sas_key")

    @storage_container_sas_key.setter
    def storage_container_sas_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_container_sas_key", value)


@pulumi.type_token("azure:mssql/managedInstanceVulnerabilityAssessment:ManagedInstanceVulnerabilityAssessment")
class ManagedInstanceVulnerabilityAssessment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 managed_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 recurring_scans: Optional[pulumi.Input[Union['ManagedInstanceVulnerabilityAssessmentRecurringScansArgs', 'ManagedInstanceVulnerabilityAssessmentRecurringScansArgsDict']]] = None,
                 storage_account_access_key: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_container_path: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_container_sas_key: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages the Vulnerability Assessment for an MS Managed Instance.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_virtual_network = azure.network.VirtualNetwork("example",
            name="example",
            location=example.location,
            resource_group_name=example.name,
            address_spaces=["10.0.0.0/16"])
        example_subnet = azure.network.Subnet("example",
            name="example",
            resource_group_name=example.name,
            virtual_network_name=example_virtual_network.name,
            address_prefixes=["10.0.2.0/24"])
        example_managed_instance = azure.mssql.ManagedInstance("example",
            name="exampleinstance",
            resource_group_name=example.name,
            location=example.location,
            license_type="BasePrice",
            sku_name="GP_Gen5",
            storage_size_in_gb=32,
            subnet_id=example_subnet.id,
            vcores=4,
            administrator_login="missadministrator",
            administrator_login_password="NCC-1701-D")
        example_account = azure.storage.Account("example",
            name="accteststorageaccount",
            resource_group_name=example.name,
            location=example.location,
            account_tier="Standard",
            account_replication_type="GRS")
        example_container = azure.storage.Container("example",
            name="accteststoragecontainer",
            storage_account_name=example_account.name,
            container_access_type="private")
        example_managed_instance_security_alert_policy = azure.mssql.ManagedInstanceSecurityAlertPolicy("example",
            resource_group_name=test_azurerm_resource_group["name"],
            managed_instance_name=test["name"],
            enabled=True,
            storage_endpoint=test_azurerm_storage_account["primaryBlobEndpoint"],
            storage_account_access_key=test_azurerm_storage_account["primaryAccessKey"],
            retention_days=30)
        example_managed_instance_vulnerability_assessment = azure.mssql.ManagedInstanceVulnerabilityAssessment("example",
            managed_instance_id=example_managed_instance.id,
            storage_container_path=pulumi.Output.all(
                primary_blob_endpoint=example_account.primary_blob_endpoint,
                name=example_container.name
        ).apply(lambda resolved_outputs: f"{resolved_outputs['primary_blob_endpoint']}{resolved_outputs['name']}/")
        ,
            storage_account_access_key=example_account.primary_access_key,
            recurring_scans={
                "enabled": True,
                "email_subscription_admins": True,
                "emails": [
                    "email@example1.com",
                    "email@example2.com",
                ],
            },
            opts = pulumi.ResourceOptions(depends_on=[example_managed_instance_security_alert_policy]))
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Sql`: 2023-08-01-preview

        ## Import

        The Vulnerability Assessment can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:mssql/managedInstanceVulnerabilityAssessment:ManagedInstanceVulnerabilityAssessment example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/acceptanceTestResourceGroup1/providers/Microsoft.Sql/managedInstances/instance1/vulnerabilityAssessments/Default
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] managed_instance_id: The id of the MS SQL Managed Instance. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['ManagedInstanceVulnerabilityAssessmentRecurringScansArgs', 'ManagedInstanceVulnerabilityAssessmentRecurringScansArgsDict']] recurring_scans: The recurring scans settings. The `recurring_scans` block supports fields documented below.
        :param pulumi.Input[_builtins.str] storage_account_access_key: Specifies the identifier key of the storage account for vulnerability assessment scan results. If `storage_container_sas_key` isn't specified, `storage_account_access_key` is required.
               
               > **Note:** The `storage_account_access_key` only applies if the storage account is not behind a virtual network or a firewall.
        :param pulumi.Input[_builtins.str] storage_container_path: A blob storage container path to hold the scan results (e.g. <https://myStorage.blob.core.windows.net/VaScans/>).
        :param pulumi.Input[_builtins.str] storage_container_sas_key: A shared access signature (SAS Key) that has write access to the blob container specified in `storage_container_path` parameter. If `storage_account_access_key` isn't specified, `storage_container_sas_key` is required.
               
               > **Note:** The `storage_container_sas_key` only applies if the storage account is not behind a virtual network or a firewall.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ManagedInstanceVulnerabilityAssessmentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages the Vulnerability Assessment for an MS Managed Instance.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_virtual_network = azure.network.VirtualNetwork("example",
            name="example",
            location=example.location,
            resource_group_name=example.name,
            address_spaces=["10.0.0.0/16"])
        example_subnet = azure.network.Subnet("example",
            name="example",
            resource_group_name=example.name,
            virtual_network_name=example_virtual_network.name,
            address_prefixes=["10.0.2.0/24"])
        example_managed_instance = azure.mssql.ManagedInstance("example",
            name="exampleinstance",
            resource_group_name=example.name,
            location=example.location,
            license_type="BasePrice",
            sku_name="GP_Gen5",
            storage_size_in_gb=32,
            subnet_id=example_subnet.id,
            vcores=4,
            administrator_login="missadministrator",
            administrator_login_password="NCC-1701-D")
        example_account = azure.storage.Account("example",
            name="accteststorageaccount",
            resource_group_name=example.name,
            location=example.location,
            account_tier="Standard",
            account_replication_type="GRS")
        example_container = azure.storage.Container("example",
            name="accteststoragecontainer",
            storage_account_name=example_account.name,
            container_access_type="private")
        example_managed_instance_security_alert_policy = azure.mssql.ManagedInstanceSecurityAlertPolicy("example",
            resource_group_name=test_azurerm_resource_group["name"],
            managed_instance_name=test["name"],
            enabled=True,
            storage_endpoint=test_azurerm_storage_account["primaryBlobEndpoint"],
            storage_account_access_key=test_azurerm_storage_account["primaryAccessKey"],
            retention_days=30)
        example_managed_instance_vulnerability_assessment = azure.mssql.ManagedInstanceVulnerabilityAssessment("example",
            managed_instance_id=example_managed_instance.id,
            storage_container_path=pulumi.Output.all(
                primary_blob_endpoint=example_account.primary_blob_endpoint,
                name=example_container.name
        ).apply(lambda resolved_outputs: f"{resolved_outputs['primary_blob_endpoint']}{resolved_outputs['name']}/")
        ,
            storage_account_access_key=example_account.primary_access_key,
            recurring_scans={
                "enabled": True,
                "email_subscription_admins": True,
                "emails": [
                    "email@example1.com",
                    "email@example2.com",
                ],
            },
            opts = pulumi.ResourceOptions(depends_on=[example_managed_instance_security_alert_policy]))
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Sql`: 2023-08-01-preview

        ## Import

        The Vulnerability Assessment can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:mssql/managedInstanceVulnerabilityAssessment:ManagedInstanceVulnerabilityAssessment example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/acceptanceTestResourceGroup1/providers/Microsoft.Sql/managedInstances/instance1/vulnerabilityAssessments/Default
        ```

        :param str resource_name: The name of the resource.
        :param ManagedInstanceVulnerabilityAssessmentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ManagedInstanceVulnerabilityAssessmentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 managed_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 recurring_scans: Optional[pulumi.Input[Union['ManagedInstanceVulnerabilityAssessmentRecurringScansArgs', 'ManagedInstanceVulnerabilityAssessmentRecurringScansArgsDict']]] = None,
                 storage_account_access_key: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_container_path: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_container_sas_key: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ManagedInstanceVulnerabilityAssessmentArgs.__new__(ManagedInstanceVulnerabilityAssessmentArgs)

            if managed_instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'managed_instance_id'")
            __props__.__dict__["managed_instance_id"] = managed_instance_id
            __props__.__dict__["recurring_scans"] = recurring_scans
            __props__.__dict__["storage_account_access_key"] = None if storage_account_access_key is None else pulumi.Output.secret(storage_account_access_key)
            if storage_container_path is None and not opts.urn:
                raise TypeError("Missing required property 'storage_container_path'")
            __props__.__dict__["storage_container_path"] = storage_container_path
            __props__.__dict__["storage_container_sas_key"] = None if storage_container_sas_key is None else pulumi.Output.secret(storage_container_sas_key)
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["storageAccountAccessKey", "storageContainerSasKey"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(ManagedInstanceVulnerabilityAssessment, __self__).__init__(
            'azure:mssql/managedInstanceVulnerabilityAssessment:ManagedInstanceVulnerabilityAssessment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            managed_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            recurring_scans: Optional[pulumi.Input[Union['ManagedInstanceVulnerabilityAssessmentRecurringScansArgs', 'ManagedInstanceVulnerabilityAssessmentRecurringScansArgsDict']]] = None,
            storage_account_access_key: Optional[pulumi.Input[_builtins.str]] = None,
            storage_container_path: Optional[pulumi.Input[_builtins.str]] = None,
            storage_container_sas_key: Optional[pulumi.Input[_builtins.str]] = None) -> 'ManagedInstanceVulnerabilityAssessment':
        """
        Get an existing ManagedInstanceVulnerabilityAssessment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] managed_instance_id: The id of the MS SQL Managed Instance. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['ManagedInstanceVulnerabilityAssessmentRecurringScansArgs', 'ManagedInstanceVulnerabilityAssessmentRecurringScansArgsDict']] recurring_scans: The recurring scans settings. The `recurring_scans` block supports fields documented below.
        :param pulumi.Input[_builtins.str] storage_account_access_key: Specifies the identifier key of the storage account for vulnerability assessment scan results. If `storage_container_sas_key` isn't specified, `storage_account_access_key` is required.
               
               > **Note:** The `storage_account_access_key` only applies if the storage account is not behind a virtual network or a firewall.
        :param pulumi.Input[_builtins.str] storage_container_path: A blob storage container path to hold the scan results (e.g. <https://myStorage.blob.core.windows.net/VaScans/>).
        :param pulumi.Input[_builtins.str] storage_container_sas_key: A shared access signature (SAS Key) that has write access to the blob container specified in `storage_container_path` parameter. If `storage_account_access_key` isn't specified, `storage_container_sas_key` is required.
               
               > **Note:** The `storage_container_sas_key` only applies if the storage account is not behind a virtual network or a firewall.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ManagedInstanceVulnerabilityAssessmentState.__new__(_ManagedInstanceVulnerabilityAssessmentState)

        __props__.__dict__["managed_instance_id"] = managed_instance_id
        __props__.__dict__["recurring_scans"] = recurring_scans
        __props__.__dict__["storage_account_access_key"] = storage_account_access_key
        __props__.__dict__["storage_container_path"] = storage_container_path
        __props__.__dict__["storage_container_sas_key"] = storage_container_sas_key
        return ManagedInstanceVulnerabilityAssessment(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="managedInstanceId")
    def managed_instance_id(self) -> pulumi.Output[_builtins.str]:
        """
        The id of the MS SQL Managed Instance. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "managed_instance_id")

    @_builtins.property
    @pulumi.getter(name="recurringScans")
    def recurring_scans(self) -> pulumi.Output['outputs.ManagedInstanceVulnerabilityAssessmentRecurringScans']:
        """
        The recurring scans settings. The `recurring_scans` block supports fields documented below.
        """
        return pulumi.get(self, "recurring_scans")

    @_builtins.property
    @pulumi.getter(name="storageAccountAccessKey")
    def storage_account_access_key(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the identifier key of the storage account for vulnerability assessment scan results. If `storage_container_sas_key` isn't specified, `storage_account_access_key` is required.

        > **Note:** The `storage_account_access_key` only applies if the storage account is not behind a virtual network or a firewall.
        """
        return pulumi.get(self, "storage_account_access_key")

    @_builtins.property
    @pulumi.getter(name="storageContainerPath")
    def storage_container_path(self) -> pulumi.Output[_builtins.str]:
        """
        A blob storage container path to hold the scan results (e.g. <https://myStorage.blob.core.windows.net/VaScans/>).
        """
        return pulumi.get(self, "storage_container_path")

    @_builtins.property
    @pulumi.getter(name="storageContainerSasKey")
    def storage_container_sas_key(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        A shared access signature (SAS Key) that has write access to the blob container specified in `storage_container_path` parameter. If `storage_account_access_key` isn't specified, `storage_container_sas_key` is required.

        > **Note:** The `storage_container_sas_key` only applies if the storage account is not behind a virtual network or a firewall.
        """
        return pulumi.get(self, "storage_container_sas_key")

