# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetVolumeGroupSapHanaResult',
    'AwaitableGetVolumeGroupSapHanaResult',
    'get_volume_group_sap_hana',
    'get_volume_group_sap_hana_output',
]

@pulumi.output_type
class GetVolumeGroupSapHanaResult:
    """
    A collection of values returned by getVolumeGroupSapHana.
    """
    def __init__(__self__, account_name=None, application_identifier=None, group_description=None, id=None, location=None, name=None, resource_group_name=None, volumes=None):
        if account_name and not isinstance(account_name, str):
            raise TypeError("Expected argument 'account_name' to be a str")
        pulumi.set(__self__, "account_name", account_name)
        if application_identifier and not isinstance(application_identifier, str):
            raise TypeError("Expected argument 'application_identifier' to be a str")
        pulumi.set(__self__, "application_identifier", application_identifier)
        if group_description and not isinstance(group_description, str):
            raise TypeError("Expected argument 'group_description' to be a str")
        pulumi.set(__self__, "group_description", group_description)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if resource_group_name and not isinstance(resource_group_name, str):
            raise TypeError("Expected argument 'resource_group_name' to be a str")
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if volumes and not isinstance(volumes, list):
            raise TypeError("Expected argument 'volumes' to be a list")
        pulumi.set(__self__, "volumes", volumes)

    @_builtins.property
    @pulumi.getter(name="accountName")
    def account_name(self) -> _builtins.str:
        return pulumi.get(self, "account_name")

    @_builtins.property
    @pulumi.getter(name="applicationIdentifier")
    def application_identifier(self) -> _builtins.str:
        """
        The application identifier.
        """
        return pulumi.get(self, "application_identifier")

    @_builtins.property
    @pulumi.getter(name="groupDescription")
    def group_description(self) -> _builtins.str:
        """
        Volume group description.
        """
        return pulumi.get(self, "group_description")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def location(self) -> _builtins.str:
        """
        The Azure Region where the Application Volume Group exists.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of this volume.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> _builtins.str:
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter
    def volumes(self) -> Sequence['outputs.GetVolumeGroupSapHanaVolumeResult']:
        """
        A `volume` block as defined below.
        """
        return pulumi.get(self, "volumes")


class AwaitableGetVolumeGroupSapHanaResult(GetVolumeGroupSapHanaResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetVolumeGroupSapHanaResult(
            account_name=self.account_name,
            application_identifier=self.application_identifier,
            group_description=self.group_description,
            id=self.id,
            location=self.location,
            name=self.name,
            resource_group_name=self.resource_group_name,
            volumes=self.volumes)


def get_volume_group_sap_hana(account_name: Optional[_builtins.str] = None,
                              name: Optional[_builtins.str] = None,
                              resource_group_name: Optional[_builtins.str] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetVolumeGroupSapHanaResult:
    """
    Use this data source to access information about an existing Application Volume Group for SAP HANA application.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.netapp.get_volume_group_sap_hana(name="existing application volume group name",
        resource_group_name="resource group name where the account and volume group belong to",
        account_name="existing account where the application volume group belong to")
    pulumi.export("id", example.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.NetApp`: 2025-01-01


    :param _builtins.str account_name: Name of the account where the application volume group belong to.
    :param _builtins.str name: The name of this Application Volume Group for SAP HANA application.
    :param _builtins.str resource_group_name: The name of the Resource Group where the Application Volume Group exists.
    """
    __args__ = dict()
    __args__['accountName'] = account_name
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:netapp/getVolumeGroupSapHana:getVolumeGroupSapHana', __args__, opts=opts, typ=GetVolumeGroupSapHanaResult).value

    return AwaitableGetVolumeGroupSapHanaResult(
        account_name=pulumi.get(__ret__, 'account_name'),
        application_identifier=pulumi.get(__ret__, 'application_identifier'),
        group_description=pulumi.get(__ret__, 'group_description'),
        id=pulumi.get(__ret__, 'id'),
        location=pulumi.get(__ret__, 'location'),
        name=pulumi.get(__ret__, 'name'),
        resource_group_name=pulumi.get(__ret__, 'resource_group_name'),
        volumes=pulumi.get(__ret__, 'volumes'))
def get_volume_group_sap_hana_output(account_name: Optional[pulumi.Input[_builtins.str]] = None,
                                     name: Optional[pulumi.Input[_builtins.str]] = None,
                                     resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetVolumeGroupSapHanaResult]:
    """
    Use this data source to access information about an existing Application Volume Group for SAP HANA application.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.netapp.get_volume_group_sap_hana(name="existing application volume group name",
        resource_group_name="resource group name where the account and volume group belong to",
        account_name="existing account where the application volume group belong to")
    pulumi.export("id", example.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.NetApp`: 2025-01-01


    :param _builtins.str account_name: Name of the account where the application volume group belong to.
    :param _builtins.str name: The name of this Application Volume Group for SAP HANA application.
    :param _builtins.str resource_group_name: The name of the Resource Group where the Application Volume Group exists.
    """
    __args__ = dict()
    __args__['accountName'] = account_name
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:netapp/getVolumeGroupSapHana:getVolumeGroupSapHana', __args__, opts=opts, typ=GetVolumeGroupSapHanaResult)
    return __ret__.apply(lambda __response__: GetVolumeGroupSapHanaResult(
        account_name=pulumi.get(__response__, 'account_name'),
        application_identifier=pulumi.get(__response__, 'application_identifier'),
        group_description=pulumi.get(__response__, 'group_description'),
        id=pulumi.get(__response__, 'id'),
        location=pulumi.get(__response__, 'location'),
        name=pulumi.get(__response__, 'name'),
        resource_group_name=pulumi.get(__response__, 'resource_group_name'),
        volumes=pulumi.get(__response__, 'volumes')))
