# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['PoolArgs', 'Pool']

@pulumi.input_type
class PoolArgs:
    def __init__(__self__, *,
                 account_name: pulumi.Input[_builtins.str],
                 resource_group_name: pulumi.Input[_builtins.str],
                 service_level: pulumi.Input[_builtins.str],
                 size_in_tb: pulumi.Input[_builtins.int],
                 cool_access_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 encryption_type: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 qos_type: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a Pool resource.
        :param pulumi.Input[_builtins.str] account_name: The name of the NetApp account in which the NetApp Pool should be created. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group where the NetApp Pool should be created. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] service_level: The service level of the file system. Valid values include `Premium`, `Standard`, and `Ultra`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] size_in_tb: Provisioned size of the pool in TB. Value must be between `1` and `2048`.
               
               > **Note:** `2` TB capacity pool sizing is currently in preview. You can only take advantage of the `2` TB minimum if all the volumes in the capacity pool are using `Standard` network features. If any volume is using `Basic` network features, the minimum size is `4` TB. Please see the product [documentation](https://learn.microsoft.com/azure/azure-netapp-files/azure-netapp-files-set-up-capacity-pool) for more information.
               
               > **Note:** The maximum `size_in_tb` is goverened by regional quotas. You may request additional capacity from Azure, currently up to `2048`.
        :param pulumi.Input[_builtins.bool] cool_access_enabled: Whether the NetApp Pool can hold cool access enabled volumes. Defaults to `false`.
               
               > **Note:** Disabling `cool_access_enabled` is not allowed and forces a new resource to be created.
        :param pulumi.Input[_builtins.str] encryption_type: The encryption type of the pool. Valid values include `Single`, and `Double`. Defaults to `Single`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] location: Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name of the NetApp Pool. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] qos_type: QoS Type of the pool. Valid values include `Auto` or `Manual`. Defaults to `Auto`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        """
        pulumi.set(__self__, "account_name", account_name)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "service_level", service_level)
        pulumi.set(__self__, "size_in_tb", size_in_tb)
        if cool_access_enabled is not None:
            pulumi.set(__self__, "cool_access_enabled", cool_access_enabled)
        if encryption_type is not None:
            pulumi.set(__self__, "encryption_type", encryption_type)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if qos_type is not None:
            pulumi.set(__self__, "qos_type", qos_type)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="accountName")
    def account_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the NetApp account in which the NetApp Pool should be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "account_name")

    @account_name.setter
    def account_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "account_name", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the resource group where the NetApp Pool should be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="serviceLevel")
    def service_level(self) -> pulumi.Input[_builtins.str]:
        """
        The service level of the file system. Valid values include `Premium`, `Standard`, and `Ultra`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "service_level")

    @service_level.setter
    def service_level(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "service_level", value)

    @_builtins.property
    @pulumi.getter(name="sizeInTb")
    def size_in_tb(self) -> pulumi.Input[_builtins.int]:
        """
        Provisioned size of the pool in TB. Value must be between `1` and `2048`.

        > **Note:** `2` TB capacity pool sizing is currently in preview. You can only take advantage of the `2` TB minimum if all the volumes in the capacity pool are using `Standard` network features. If any volume is using `Basic` network features, the minimum size is `4` TB. Please see the product [documentation](https://learn.microsoft.com/azure/azure-netapp-files/azure-netapp-files-set-up-capacity-pool) for more information.

        > **Note:** The maximum `size_in_tb` is goverened by regional quotas. You may request additional capacity from Azure, currently up to `2048`.
        """
        return pulumi.get(self, "size_in_tb")

    @size_in_tb.setter
    def size_in_tb(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "size_in_tb", value)

    @_builtins.property
    @pulumi.getter(name="coolAccessEnabled")
    def cool_access_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the NetApp Pool can hold cool access enabled volumes. Defaults to `false`.

        > **Note:** Disabling `cool_access_enabled` is not allowed and forces a new resource to be created.
        """
        return pulumi.get(self, "cool_access_enabled")

    @cool_access_enabled.setter
    def cool_access_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "cool_access_enabled", value)

    @_builtins.property
    @pulumi.getter(name="encryptionType")
    def encryption_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The encryption type of the pool. Valid values include `Single`, and `Double`. Defaults to `Single`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "encryption_type")

    @encryption_type.setter
    def encryption_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "encryption_type", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the NetApp Pool. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="qosType")
    def qos_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        QoS Type of the pool. Valid values include `Auto` or `Manual`. Defaults to `Auto`.
        """
        return pulumi.get(self, "qos_type")

    @qos_type.setter
    def qos_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "qos_type", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _PoolState:
    def __init__(__self__, *,
                 account_name: Optional[pulumi.Input[_builtins.str]] = None,
                 cool_access_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 encryption_type: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 qos_type: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 service_level: Optional[pulumi.Input[_builtins.str]] = None,
                 size_in_tb: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering Pool resources.
        :param pulumi.Input[_builtins.str] account_name: The name of the NetApp account in which the NetApp Pool should be created. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] cool_access_enabled: Whether the NetApp Pool can hold cool access enabled volumes. Defaults to `false`.
               
               > **Note:** Disabling `cool_access_enabled` is not allowed and forces a new resource to be created.
        :param pulumi.Input[_builtins.str] encryption_type: The encryption type of the pool. Valid values include `Single`, and `Double`. Defaults to `Single`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] location: Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name of the NetApp Pool. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] qos_type: QoS Type of the pool. Valid values include `Auto` or `Manual`. Defaults to `Auto`.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group where the NetApp Pool should be created. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] service_level: The service level of the file system. Valid values include `Premium`, `Standard`, and `Ultra`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] size_in_tb: Provisioned size of the pool in TB. Value must be between `1` and `2048`.
               
               > **Note:** `2` TB capacity pool sizing is currently in preview. You can only take advantage of the `2` TB minimum if all the volumes in the capacity pool are using `Standard` network features. If any volume is using `Basic` network features, the minimum size is `4` TB. Please see the product [documentation](https://learn.microsoft.com/azure/azure-netapp-files/azure-netapp-files-set-up-capacity-pool) for more information.
               
               > **Note:** The maximum `size_in_tb` is goverened by regional quotas. You may request additional capacity from Azure, currently up to `2048`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        """
        if account_name is not None:
            pulumi.set(__self__, "account_name", account_name)
        if cool_access_enabled is not None:
            pulumi.set(__self__, "cool_access_enabled", cool_access_enabled)
        if encryption_type is not None:
            pulumi.set(__self__, "encryption_type", encryption_type)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if qos_type is not None:
            pulumi.set(__self__, "qos_type", qos_type)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if service_level is not None:
            pulumi.set(__self__, "service_level", service_level)
        if size_in_tb is not None:
            pulumi.set(__self__, "size_in_tb", size_in_tb)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="accountName")
    def account_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the NetApp account in which the NetApp Pool should be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "account_name")

    @account_name.setter
    def account_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_name", value)

    @_builtins.property
    @pulumi.getter(name="coolAccessEnabled")
    def cool_access_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the NetApp Pool can hold cool access enabled volumes. Defaults to `false`.

        > **Note:** Disabling `cool_access_enabled` is not allowed and forces a new resource to be created.
        """
        return pulumi.get(self, "cool_access_enabled")

    @cool_access_enabled.setter
    def cool_access_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "cool_access_enabled", value)

    @_builtins.property
    @pulumi.getter(name="encryptionType")
    def encryption_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The encryption type of the pool. Valid values include `Single`, and `Double`. Defaults to `Single`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "encryption_type")

    @encryption_type.setter
    def encryption_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "encryption_type", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the NetApp Pool. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="qosType")
    def qos_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        QoS Type of the pool. Valid values include `Auto` or `Manual`. Defaults to `Auto`.
        """
        return pulumi.get(self, "qos_type")

    @qos_type.setter
    def qos_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "qos_type", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the resource group where the NetApp Pool should be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="serviceLevel")
    def service_level(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The service level of the file system. Valid values include `Premium`, `Standard`, and `Ultra`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "service_level")

    @service_level.setter
    def service_level(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_level", value)

    @_builtins.property
    @pulumi.getter(name="sizeInTb")
    def size_in_tb(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Provisioned size of the pool in TB. Value must be between `1` and `2048`.

        > **Note:** `2` TB capacity pool sizing is currently in preview. You can only take advantage of the `2` TB minimum if all the volumes in the capacity pool are using `Standard` network features. If any volume is using `Basic` network features, the minimum size is `4` TB. Please see the product [documentation](https://learn.microsoft.com/azure/azure-netapp-files/azure-netapp-files-set-up-capacity-pool) for more information.

        > **Note:** The maximum `size_in_tb` is goverened by regional quotas. You may request additional capacity from Azure, currently up to `2048`.
        """
        return pulumi.get(self, "size_in_tb")

    @size_in_tb.setter
    def size_in_tb(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "size_in_tb", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("azure:netapp/pool:Pool")
class Pool(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_name: Optional[pulumi.Input[_builtins.str]] = None,
                 cool_access_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 encryption_type: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 qos_type: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 service_level: Optional[pulumi.Input[_builtins.str]] = None,
                 size_in_tb: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Manages a Pool within a NetApp Account.

        ## NetApp Pool Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_account = azure.netapp.Account("example",
            name="example-netappaccount",
            location=example.location,
            resource_group_name=example.name)
        example_pool = azure.netapp.Pool("example",
            name="example-netapppool",
            account_name=example_account.name,
            location=example.location,
            resource_group_name=example.name,
            service_level="Premium",
            size_in_tb=4)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.NetApp`: 2025-01-01

        ## Import

        NetApp Pool can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:netapp/pool:Pool example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.NetApp/netAppAccounts/account1/capacityPools/pool1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_name: The name of the NetApp account in which the NetApp Pool should be created. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] cool_access_enabled: Whether the NetApp Pool can hold cool access enabled volumes. Defaults to `false`.
               
               > **Note:** Disabling `cool_access_enabled` is not allowed and forces a new resource to be created.
        :param pulumi.Input[_builtins.str] encryption_type: The encryption type of the pool. Valid values include `Single`, and `Double`. Defaults to `Single`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] location: Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name of the NetApp Pool. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] qos_type: QoS Type of the pool. Valid values include `Auto` or `Manual`. Defaults to `Auto`.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group where the NetApp Pool should be created. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] service_level: The service level of the file system. Valid values include `Premium`, `Standard`, and `Ultra`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] size_in_tb: Provisioned size of the pool in TB. Value must be between `1` and `2048`.
               
               > **Note:** `2` TB capacity pool sizing is currently in preview. You can only take advantage of the `2` TB minimum if all the volumes in the capacity pool are using `Standard` network features. If any volume is using `Basic` network features, the minimum size is `4` TB. Please see the product [documentation](https://learn.microsoft.com/azure/azure-netapp-files/azure-netapp-files-set-up-capacity-pool) for more information.
               
               > **Note:** The maximum `size_in_tb` is goverened by regional quotas. You may request additional capacity from Azure, currently up to `2048`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PoolArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Pool within a NetApp Account.

        ## NetApp Pool Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_account = azure.netapp.Account("example",
            name="example-netappaccount",
            location=example.location,
            resource_group_name=example.name)
        example_pool = azure.netapp.Pool("example",
            name="example-netapppool",
            account_name=example_account.name,
            location=example.location,
            resource_group_name=example.name,
            service_level="Premium",
            size_in_tb=4)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.NetApp`: 2025-01-01

        ## Import

        NetApp Pool can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:netapp/pool:Pool example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.NetApp/netAppAccounts/account1/capacityPools/pool1
        ```

        :param str resource_name: The name of the resource.
        :param PoolArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PoolArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_name: Optional[pulumi.Input[_builtins.str]] = None,
                 cool_access_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 encryption_type: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 qos_type: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 service_level: Optional[pulumi.Input[_builtins.str]] = None,
                 size_in_tb: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PoolArgs.__new__(PoolArgs)

            if account_name is None and not opts.urn:
                raise TypeError("Missing required property 'account_name'")
            __props__.__dict__["account_name"] = account_name
            __props__.__dict__["cool_access_enabled"] = cool_access_enabled
            __props__.__dict__["encryption_type"] = encryption_type
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            __props__.__dict__["qos_type"] = qos_type
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            if service_level is None and not opts.urn:
                raise TypeError("Missing required property 'service_level'")
            __props__.__dict__["service_level"] = service_level
            if size_in_tb is None and not opts.urn:
                raise TypeError("Missing required property 'size_in_tb'")
            __props__.__dict__["size_in_tb"] = size_in_tb
            __props__.__dict__["tags"] = tags
        super(Pool, __self__).__init__(
            'azure:netapp/pool:Pool',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_name: Optional[pulumi.Input[_builtins.str]] = None,
            cool_access_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            encryption_type: Optional[pulumi.Input[_builtins.str]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            qos_type: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            service_level: Optional[pulumi.Input[_builtins.str]] = None,
            size_in_tb: Optional[pulumi.Input[_builtins.int]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None) -> 'Pool':
        """
        Get an existing Pool resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_name: The name of the NetApp account in which the NetApp Pool should be created. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] cool_access_enabled: Whether the NetApp Pool can hold cool access enabled volumes. Defaults to `false`.
               
               > **Note:** Disabling `cool_access_enabled` is not allowed and forces a new resource to be created.
        :param pulumi.Input[_builtins.str] encryption_type: The encryption type of the pool. Valid values include `Single`, and `Double`. Defaults to `Single`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] location: Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name of the NetApp Pool. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] qos_type: QoS Type of the pool. Valid values include `Auto` or `Manual`. Defaults to `Auto`.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group where the NetApp Pool should be created. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] service_level: The service level of the file system. Valid values include `Premium`, `Standard`, and `Ultra`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] size_in_tb: Provisioned size of the pool in TB. Value must be between `1` and `2048`.
               
               > **Note:** `2` TB capacity pool sizing is currently in preview. You can only take advantage of the `2` TB minimum if all the volumes in the capacity pool are using `Standard` network features. If any volume is using `Basic` network features, the minimum size is `4` TB. Please see the product [documentation](https://learn.microsoft.com/azure/azure-netapp-files/azure-netapp-files-set-up-capacity-pool) for more information.
               
               > **Note:** The maximum `size_in_tb` is goverened by regional quotas. You may request additional capacity from Azure, currently up to `2048`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PoolState.__new__(_PoolState)

        __props__.__dict__["account_name"] = account_name
        __props__.__dict__["cool_access_enabled"] = cool_access_enabled
        __props__.__dict__["encryption_type"] = encryption_type
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["qos_type"] = qos_type
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["service_level"] = service_level
        __props__.__dict__["size_in_tb"] = size_in_tb
        __props__.__dict__["tags"] = tags
        return Pool(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accountName")
    def account_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the NetApp account in which the NetApp Pool should be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "account_name")

    @_builtins.property
    @pulumi.getter(name="coolAccessEnabled")
    def cool_access_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether the NetApp Pool can hold cool access enabled volumes. Defaults to `false`.

        > **Note:** Disabling `cool_access_enabled` is not allowed and forces a new resource to be created.
        """
        return pulumi.get(self, "cool_access_enabled")

    @_builtins.property
    @pulumi.getter(name="encryptionType")
    def encryption_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The encryption type of the pool. Valid values include `Single`, and `Double`. Defaults to `Single`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "encryption_type")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the NetApp Pool. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="qosType")
    def qos_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        QoS Type of the pool. Valid values include `Auto` or `Manual`. Defaults to `Auto`.
        """
        return pulumi.get(self, "qos_type")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the resource group where the NetApp Pool should be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter(name="serviceLevel")
    def service_level(self) -> pulumi.Output[_builtins.str]:
        """
        The service level of the file system. Valid values include `Premium`, `Standard`, and `Ultra`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "service_level")

    @_builtins.property
    @pulumi.getter(name="sizeInTb")
    def size_in_tb(self) -> pulumi.Output[_builtins.int]:
        """
        Provisioned size of the pool in TB. Value must be between `1` and `2048`.

        > **Note:** `2` TB capacity pool sizing is currently in preview. You can only take advantage of the `2` TB minimum if all the volumes in the capacity pool are using `Standard` network features. If any volume is using `Basic` network features, the minimum size is `4` TB. Please see the product [documentation](https://learn.microsoft.com/azure/azure-netapp-files/azure-netapp-files-set-up-capacity-pool) for more information.

        > **Note:** The maximum `size_in_tb` is goverened by regional quotas. You may request additional capacity from Azure, currently up to `2048`.
        """
        return pulumi.get(self, "size_in_tb")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

