# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ExpressRoutePortAuthorizationArgs', 'ExpressRoutePortAuthorization']

@pulumi.input_type
class ExpressRoutePortAuthorizationArgs:
    def __init__(__self__, *,
                 express_route_port_name: pulumi.Input[_builtins.str],
                 resource_group_name: pulumi.Input[_builtins.str],
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a ExpressRoutePortAuthorization resource.
        :param pulumi.Input[_builtins.str] express_route_port_name: The name of the Express Route Port in which to create the Authorization. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which to create the ExpressRoute Port. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name of the ExpressRoute Port. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "express_route_port_name", express_route_port_name)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="expressRoutePortName")
    def express_route_port_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the Express Route Port in which to create the Authorization. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "express_route_port_name")

    @express_route_port_name.setter
    def express_route_port_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "express_route_port_name", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the resource group in which to create the ExpressRoute Port. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the ExpressRoute Port. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _ExpressRoutePortAuthorizationState:
    def __init__(__self__, *,
                 authorization_key: Optional[pulumi.Input[_builtins.str]] = None,
                 authorization_use_status: Optional[pulumi.Input[_builtins.str]] = None,
                 express_route_port_name: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ExpressRoutePortAuthorization resources.
        :param pulumi.Input[_builtins.str] authorization_key: The Authorization Key.
        :param pulumi.Input[_builtins.str] authorization_use_status: The authorization use status.
        :param pulumi.Input[_builtins.str] express_route_port_name: The name of the Express Route Port in which to create the Authorization. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name of the ExpressRoute Port. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which to create the ExpressRoute Port. Changing this forces a new resource to be created.
        """
        if authorization_key is not None:
            pulumi.set(__self__, "authorization_key", authorization_key)
        if authorization_use_status is not None:
            pulumi.set(__self__, "authorization_use_status", authorization_use_status)
        if express_route_port_name is not None:
            pulumi.set(__self__, "express_route_port_name", express_route_port_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)

    @_builtins.property
    @pulumi.getter(name="authorizationKey")
    def authorization_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Authorization Key.
        """
        return pulumi.get(self, "authorization_key")

    @authorization_key.setter
    def authorization_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "authorization_key", value)

    @_builtins.property
    @pulumi.getter(name="authorizationUseStatus")
    def authorization_use_status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The authorization use status.
        """
        return pulumi.get(self, "authorization_use_status")

    @authorization_use_status.setter
    def authorization_use_status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "authorization_use_status", value)

    @_builtins.property
    @pulumi.getter(name="expressRoutePortName")
    def express_route_port_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Express Route Port in which to create the Authorization. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "express_route_port_name")

    @express_route_port_name.setter
    def express_route_port_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "express_route_port_name", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the ExpressRoute Port. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the resource group in which to create the ExpressRoute Port. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_name", value)


@pulumi.type_token("azure:network/expressRoutePortAuthorization:ExpressRoutePortAuthorization")
class ExpressRoutePortAuthorization(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 express_route_port_name: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages an ExpressRoute Port Authorization.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="exprtTest",
            location="West Europe")
        example_express_route_port = azure.network.ExpressRoutePort("example",
            name="port1",
            resource_group_name=example.name,
            location=example.location,
            peering_location="Airtel-Chennai-CLS",
            bandwidth_in_gbps=10,
            encapsulation="Dot1Q")
        example_express_route_port_authorization = azure.network.ExpressRoutePortAuthorization("example",
            name="exampleERCAuth",
            express_route_port_name=example_express_route_port.name,
            resource_group_name=example.name)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Network`: 2024-05-01

        ## Import

        ExpressRoute Port Authorizations can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:network/expressRoutePortAuthorization:ExpressRoutePortAuthorization auth1 /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.Network/expressRoutePorts/myExpressPort/authorizations/auth1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] express_route_port_name: The name of the Express Route Port in which to create the Authorization. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name of the ExpressRoute Port. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which to create the ExpressRoute Port. Changing this forces a new resource to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ExpressRoutePortAuthorizationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an ExpressRoute Port Authorization.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="exprtTest",
            location="West Europe")
        example_express_route_port = azure.network.ExpressRoutePort("example",
            name="port1",
            resource_group_name=example.name,
            location=example.location,
            peering_location="Airtel-Chennai-CLS",
            bandwidth_in_gbps=10,
            encapsulation="Dot1Q")
        example_express_route_port_authorization = azure.network.ExpressRoutePortAuthorization("example",
            name="exampleERCAuth",
            express_route_port_name=example_express_route_port.name,
            resource_group_name=example.name)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Network`: 2024-05-01

        ## Import

        ExpressRoute Port Authorizations can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:network/expressRoutePortAuthorization:ExpressRoutePortAuthorization auth1 /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.Network/expressRoutePorts/myExpressPort/authorizations/auth1
        ```

        :param str resource_name: The name of the resource.
        :param ExpressRoutePortAuthorizationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ExpressRoutePortAuthorizationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 express_route_port_name: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ExpressRoutePortAuthorizationArgs.__new__(ExpressRoutePortAuthorizationArgs)

            if express_route_port_name is None and not opts.urn:
                raise TypeError("Missing required property 'express_route_port_name'")
            __props__.__dict__["express_route_port_name"] = express_route_port_name
            __props__.__dict__["name"] = name
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["authorization_key"] = None
            __props__.__dict__["authorization_use_status"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["authorizationKey"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(ExpressRoutePortAuthorization, __self__).__init__(
            'azure:network/expressRoutePortAuthorization:ExpressRoutePortAuthorization',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            authorization_key: Optional[pulumi.Input[_builtins.str]] = None,
            authorization_use_status: Optional[pulumi.Input[_builtins.str]] = None,
            express_route_port_name: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None) -> 'ExpressRoutePortAuthorization':
        """
        Get an existing ExpressRoutePortAuthorization resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] authorization_key: The Authorization Key.
        :param pulumi.Input[_builtins.str] authorization_use_status: The authorization use status.
        :param pulumi.Input[_builtins.str] express_route_port_name: The name of the Express Route Port in which to create the Authorization. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name of the ExpressRoute Port. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which to create the ExpressRoute Port. Changing this forces a new resource to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ExpressRoutePortAuthorizationState.__new__(_ExpressRoutePortAuthorizationState)

        __props__.__dict__["authorization_key"] = authorization_key
        __props__.__dict__["authorization_use_status"] = authorization_use_status
        __props__.__dict__["express_route_port_name"] = express_route_port_name
        __props__.__dict__["name"] = name
        __props__.__dict__["resource_group_name"] = resource_group_name
        return ExpressRoutePortAuthorization(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="authorizationKey")
    def authorization_key(self) -> pulumi.Output[_builtins.str]:
        """
        The Authorization Key.
        """
        return pulumi.get(self, "authorization_key")

    @_builtins.property
    @pulumi.getter(name="authorizationUseStatus")
    def authorization_use_status(self) -> pulumi.Output[_builtins.str]:
        """
        The authorization use status.
        """
        return pulumi.get(self, "authorization_use_status")

    @_builtins.property
    @pulumi.getter(name="expressRoutePortName")
    def express_route_port_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Express Route Port in which to create the Authorization. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "express_route_port_name")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the ExpressRoute Port. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the resource group in which to create the ExpressRoute Port. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

