# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['NetworkInterfaceArgs', 'NetworkInterface']

@pulumi.input_type
class NetworkInterfaceArgs:
    def __init__(__self__, *,
                 ip_configurations: pulumi.Input[Sequence[pulumi.Input['NetworkInterfaceIpConfigurationArgs']]],
                 resource_group_name: pulumi.Input[_builtins.str],
                 accelerated_networking_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 auxiliary_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 auxiliary_sku: Optional[pulumi.Input[_builtins.str]] = None,
                 dns_servers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 edge_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 internal_dns_name_label: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_forwarding_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a NetworkInterface resource.
        :param pulumi.Input[Sequence[pulumi.Input['NetworkInterfaceIpConfigurationArgs']]] ip_configurations: One or more `ip_configuration` blocks as defined below.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group in which to create the Network Interface. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] accelerated_networking_enabled: Should Accelerated Networking be enabled? Defaults to `false`.
               
               > **Note:** Only certain Virtual Machine sizes are supported for Accelerated Networking - [more information can be found in this document](https://docs.microsoft.com/azure/virtual-network/create-vm-accelerated-networking-cli).
               
               > **Note:** To use Accelerated Networking in an Availability Set, the Availability Set must be deployed onto an Accelerated Networking enabled cluster.
        :param pulumi.Input[_builtins.str] auxiliary_mode: Specifies the auxiliary mode used to enable network high-performance feature on Network Virtual Appliances (NVAs). This feature offers competitive performance in Connections Per Second (CPS) optimization, along with improvements to handling large amounts of simultaneous connections. Possible values are `AcceleratedConnections`, `Floating`, `MaxConnections` and `None`.
               
               > **Note:** `auxiliary_mode` is in **Preview** and requires that the preview is enabled - [more information can be found in the Azure documentation](https://learn.microsoft.com/azure/networking/nva-accelerated-connections#prerequisites).
        :param pulumi.Input[_builtins.str] auxiliary_sku: Specifies the SKU used for the network high-performance feature on Network Virtual Appliances (NVAs). Possible values are `A8`, `A4`, `A1`, `A2` and `None`.
               
               > **Note:** `auxiliary_sku` is in **Preview** and requires that the preview is enabled - [more information can be found in the Azure documentation](https://learn.microsoft.com/azure/networking/nva-accelerated-connections#prerequisites).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] dns_servers: A list of IP Addresses defining the DNS Servers which should be used for this Network Interface.
               
               > **Note:** Configuring DNS Servers on the Network Interface will override the DNS Servers defined on the Virtual Network.
        :param pulumi.Input[_builtins.str] edge_zone: Specifies the Edge Zone within the Azure Region where this Network Interface should exist. Changing this forces a new Network Interface to be created.
        :param pulumi.Input[_builtins.str] internal_dns_name_label: The (relative) DNS Name used for internal communications between Virtual Machines in the same Virtual Network.
        :param pulumi.Input[_builtins.bool] ip_forwarding_enabled: Should IP Forwarding be enabled? Defaults to `false`.
        :param pulumi.Input[_builtins.str] location: The location where the Network Interface should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name of the Network Interface. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        """
        pulumi.set(__self__, "ip_configurations", ip_configurations)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if accelerated_networking_enabled is not None:
            pulumi.set(__self__, "accelerated_networking_enabled", accelerated_networking_enabled)
        if auxiliary_mode is not None:
            pulumi.set(__self__, "auxiliary_mode", auxiliary_mode)
        if auxiliary_sku is not None:
            pulumi.set(__self__, "auxiliary_sku", auxiliary_sku)
        if dns_servers is not None:
            pulumi.set(__self__, "dns_servers", dns_servers)
        if edge_zone is not None:
            pulumi.set(__self__, "edge_zone", edge_zone)
        if internal_dns_name_label is not None:
            pulumi.set(__self__, "internal_dns_name_label", internal_dns_name_label)
        if ip_forwarding_enabled is not None:
            pulumi.set(__self__, "ip_forwarding_enabled", ip_forwarding_enabled)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="ipConfigurations")
    def ip_configurations(self) -> pulumi.Input[Sequence[pulumi.Input['NetworkInterfaceIpConfigurationArgs']]]:
        """
        One or more `ip_configuration` blocks as defined below.
        """
        return pulumi.get(self, "ip_configurations")

    @ip_configurations.setter
    def ip_configurations(self, value: pulumi.Input[Sequence[pulumi.Input['NetworkInterfaceIpConfigurationArgs']]]):
        pulumi.set(self, "ip_configurations", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the Resource Group in which to create the Network Interface. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="acceleratedNetworkingEnabled")
    def accelerated_networking_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should Accelerated Networking be enabled? Defaults to `false`.

        > **Note:** Only certain Virtual Machine sizes are supported for Accelerated Networking - [more information can be found in this document](https://docs.microsoft.com/azure/virtual-network/create-vm-accelerated-networking-cli).

        > **Note:** To use Accelerated Networking in an Availability Set, the Availability Set must be deployed onto an Accelerated Networking enabled cluster.
        """
        return pulumi.get(self, "accelerated_networking_enabled")

    @accelerated_networking_enabled.setter
    def accelerated_networking_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "accelerated_networking_enabled", value)

    @_builtins.property
    @pulumi.getter(name="auxiliaryMode")
    def auxiliary_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the auxiliary mode used to enable network high-performance feature on Network Virtual Appliances (NVAs). This feature offers competitive performance in Connections Per Second (CPS) optimization, along with improvements to handling large amounts of simultaneous connections. Possible values are `AcceleratedConnections`, `Floating`, `MaxConnections` and `None`.

        > **Note:** `auxiliary_mode` is in **Preview** and requires that the preview is enabled - [more information can be found in the Azure documentation](https://learn.microsoft.com/azure/networking/nva-accelerated-connections#prerequisites).
        """
        return pulumi.get(self, "auxiliary_mode")

    @auxiliary_mode.setter
    def auxiliary_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auxiliary_mode", value)

    @_builtins.property
    @pulumi.getter(name="auxiliarySku")
    def auxiliary_sku(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the SKU used for the network high-performance feature on Network Virtual Appliances (NVAs). Possible values are `A8`, `A4`, `A1`, `A2` and `None`.

        > **Note:** `auxiliary_sku` is in **Preview** and requires that the preview is enabled - [more information can be found in the Azure documentation](https://learn.microsoft.com/azure/networking/nva-accelerated-connections#prerequisites).
        """
        return pulumi.get(self, "auxiliary_sku")

    @auxiliary_sku.setter
    def auxiliary_sku(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auxiliary_sku", value)

    @_builtins.property
    @pulumi.getter(name="dnsServers")
    def dns_servers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of IP Addresses defining the DNS Servers which should be used for this Network Interface.

        > **Note:** Configuring DNS Servers on the Network Interface will override the DNS Servers defined on the Virtual Network.
        """
        return pulumi.get(self, "dns_servers")

    @dns_servers.setter
    def dns_servers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "dns_servers", value)

    @_builtins.property
    @pulumi.getter(name="edgeZone")
    def edge_zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the Edge Zone within the Azure Region where this Network Interface should exist. Changing this forces a new Network Interface to be created.
        """
        return pulumi.get(self, "edge_zone")

    @edge_zone.setter
    def edge_zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "edge_zone", value)

    @_builtins.property
    @pulumi.getter(name="internalDnsNameLabel")
    def internal_dns_name_label(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The (relative) DNS Name used for internal communications between Virtual Machines in the same Virtual Network.
        """
        return pulumi.get(self, "internal_dns_name_label")

    @internal_dns_name_label.setter
    def internal_dns_name_label(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "internal_dns_name_label", value)

    @_builtins.property
    @pulumi.getter(name="ipForwardingEnabled")
    def ip_forwarding_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should IP Forwarding be enabled? Defaults to `false`.
        """
        return pulumi.get(self, "ip_forwarding_enabled")

    @ip_forwarding_enabled.setter
    def ip_forwarding_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ip_forwarding_enabled", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The location where the Network Interface should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Network Interface. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _NetworkInterfaceState:
    def __init__(__self__, *,
                 accelerated_networking_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 applied_dns_servers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 auxiliary_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 auxiliary_sku: Optional[pulumi.Input[_builtins.str]] = None,
                 dns_servers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 edge_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 internal_dns_name_label: Optional[pulumi.Input[_builtins.str]] = None,
                 internal_domain_name_suffix: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkInterfaceIpConfigurationArgs']]]] = None,
                 ip_forwarding_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 mac_address: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 private_ip_address: Optional[pulumi.Input[_builtins.str]] = None,
                 private_ip_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 virtual_machine_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering NetworkInterface resources.
        :param pulumi.Input[_builtins.bool] accelerated_networking_enabled: Should Accelerated Networking be enabled? Defaults to `false`.
               
               > **Note:** Only certain Virtual Machine sizes are supported for Accelerated Networking - [more information can be found in this document](https://docs.microsoft.com/azure/virtual-network/create-vm-accelerated-networking-cli).
               
               > **Note:** To use Accelerated Networking in an Availability Set, the Availability Set must be deployed onto an Accelerated Networking enabled cluster.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] applied_dns_servers: If the Virtual Machine using this Network Interface is part of an Availability Set, then this list will have the union of all DNS servers from all Network Interfaces that are part of the Availability Set.
        :param pulumi.Input[_builtins.str] auxiliary_mode: Specifies the auxiliary mode used to enable network high-performance feature on Network Virtual Appliances (NVAs). This feature offers competitive performance in Connections Per Second (CPS) optimization, along with improvements to handling large amounts of simultaneous connections. Possible values are `AcceleratedConnections`, `Floating`, `MaxConnections` and `None`.
               
               > **Note:** `auxiliary_mode` is in **Preview** and requires that the preview is enabled - [more information can be found in the Azure documentation](https://learn.microsoft.com/azure/networking/nva-accelerated-connections#prerequisites).
        :param pulumi.Input[_builtins.str] auxiliary_sku: Specifies the SKU used for the network high-performance feature on Network Virtual Appliances (NVAs). Possible values are `A8`, `A4`, `A1`, `A2` and `None`.
               
               > **Note:** `auxiliary_sku` is in **Preview** and requires that the preview is enabled - [more information can be found in the Azure documentation](https://learn.microsoft.com/azure/networking/nva-accelerated-connections#prerequisites).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] dns_servers: A list of IP Addresses defining the DNS Servers which should be used for this Network Interface.
               
               > **Note:** Configuring DNS Servers on the Network Interface will override the DNS Servers defined on the Virtual Network.
        :param pulumi.Input[_builtins.str] edge_zone: Specifies the Edge Zone within the Azure Region where this Network Interface should exist. Changing this forces a new Network Interface to be created.
        :param pulumi.Input[_builtins.str] internal_dns_name_label: The (relative) DNS Name used for internal communications between Virtual Machines in the same Virtual Network.
        :param pulumi.Input[_builtins.str] internal_domain_name_suffix: Even if `internal_dns_name_label` is not specified, a DNS entry is created for the primary NIC of the VM. This DNS name can be constructed by concatenating the VM name with the value of `internal_domain_name_suffix`.
        :param pulumi.Input[Sequence[pulumi.Input['NetworkInterfaceIpConfigurationArgs']]] ip_configurations: One or more `ip_configuration` blocks as defined below.
        :param pulumi.Input[_builtins.bool] ip_forwarding_enabled: Should IP Forwarding be enabled? Defaults to `false`.
        :param pulumi.Input[_builtins.str] location: The location where the Network Interface should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] mac_address: The Media Access Control (MAC) Address of the Network Interface.
        :param pulumi.Input[_builtins.str] name: The name of the Network Interface. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] private_ip_address: The first private IP address of the network interface.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] private_ip_addresses: The private IP addresses of the network interface.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group in which to create the Network Interface. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.str] virtual_machine_id: The ID of the Virtual Machine which this Network Interface is connected to.
        """
        if accelerated_networking_enabled is not None:
            pulumi.set(__self__, "accelerated_networking_enabled", accelerated_networking_enabled)
        if applied_dns_servers is not None:
            pulumi.set(__self__, "applied_dns_servers", applied_dns_servers)
        if auxiliary_mode is not None:
            pulumi.set(__self__, "auxiliary_mode", auxiliary_mode)
        if auxiliary_sku is not None:
            pulumi.set(__self__, "auxiliary_sku", auxiliary_sku)
        if dns_servers is not None:
            pulumi.set(__self__, "dns_servers", dns_servers)
        if edge_zone is not None:
            pulumi.set(__self__, "edge_zone", edge_zone)
        if internal_dns_name_label is not None:
            pulumi.set(__self__, "internal_dns_name_label", internal_dns_name_label)
        if internal_domain_name_suffix is not None:
            pulumi.set(__self__, "internal_domain_name_suffix", internal_domain_name_suffix)
        if ip_configurations is not None:
            pulumi.set(__self__, "ip_configurations", ip_configurations)
        if ip_forwarding_enabled is not None:
            pulumi.set(__self__, "ip_forwarding_enabled", ip_forwarding_enabled)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if mac_address is not None:
            pulumi.set(__self__, "mac_address", mac_address)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if private_ip_address is not None:
            pulumi.set(__self__, "private_ip_address", private_ip_address)
        if private_ip_addresses is not None:
            pulumi.set(__self__, "private_ip_addresses", private_ip_addresses)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if virtual_machine_id is not None:
            pulumi.set(__self__, "virtual_machine_id", virtual_machine_id)

    @_builtins.property
    @pulumi.getter(name="acceleratedNetworkingEnabled")
    def accelerated_networking_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should Accelerated Networking be enabled? Defaults to `false`.

        > **Note:** Only certain Virtual Machine sizes are supported for Accelerated Networking - [more information can be found in this document](https://docs.microsoft.com/azure/virtual-network/create-vm-accelerated-networking-cli).

        > **Note:** To use Accelerated Networking in an Availability Set, the Availability Set must be deployed onto an Accelerated Networking enabled cluster.
        """
        return pulumi.get(self, "accelerated_networking_enabled")

    @accelerated_networking_enabled.setter
    def accelerated_networking_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "accelerated_networking_enabled", value)

    @_builtins.property
    @pulumi.getter(name="appliedDnsServers")
    def applied_dns_servers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        If the Virtual Machine using this Network Interface is part of an Availability Set, then this list will have the union of all DNS servers from all Network Interfaces that are part of the Availability Set.
        """
        return pulumi.get(self, "applied_dns_servers")

    @applied_dns_servers.setter
    def applied_dns_servers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "applied_dns_servers", value)

    @_builtins.property
    @pulumi.getter(name="auxiliaryMode")
    def auxiliary_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the auxiliary mode used to enable network high-performance feature on Network Virtual Appliances (NVAs). This feature offers competitive performance in Connections Per Second (CPS) optimization, along with improvements to handling large amounts of simultaneous connections. Possible values are `AcceleratedConnections`, `Floating`, `MaxConnections` and `None`.

        > **Note:** `auxiliary_mode` is in **Preview** and requires that the preview is enabled - [more information can be found in the Azure documentation](https://learn.microsoft.com/azure/networking/nva-accelerated-connections#prerequisites).
        """
        return pulumi.get(self, "auxiliary_mode")

    @auxiliary_mode.setter
    def auxiliary_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auxiliary_mode", value)

    @_builtins.property
    @pulumi.getter(name="auxiliarySku")
    def auxiliary_sku(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the SKU used for the network high-performance feature on Network Virtual Appliances (NVAs). Possible values are `A8`, `A4`, `A1`, `A2` and `None`.

        > **Note:** `auxiliary_sku` is in **Preview** and requires that the preview is enabled - [more information can be found in the Azure documentation](https://learn.microsoft.com/azure/networking/nva-accelerated-connections#prerequisites).
        """
        return pulumi.get(self, "auxiliary_sku")

    @auxiliary_sku.setter
    def auxiliary_sku(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auxiliary_sku", value)

    @_builtins.property
    @pulumi.getter(name="dnsServers")
    def dns_servers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of IP Addresses defining the DNS Servers which should be used for this Network Interface.

        > **Note:** Configuring DNS Servers on the Network Interface will override the DNS Servers defined on the Virtual Network.
        """
        return pulumi.get(self, "dns_servers")

    @dns_servers.setter
    def dns_servers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "dns_servers", value)

    @_builtins.property
    @pulumi.getter(name="edgeZone")
    def edge_zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the Edge Zone within the Azure Region where this Network Interface should exist. Changing this forces a new Network Interface to be created.
        """
        return pulumi.get(self, "edge_zone")

    @edge_zone.setter
    def edge_zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "edge_zone", value)

    @_builtins.property
    @pulumi.getter(name="internalDnsNameLabel")
    def internal_dns_name_label(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The (relative) DNS Name used for internal communications between Virtual Machines in the same Virtual Network.
        """
        return pulumi.get(self, "internal_dns_name_label")

    @internal_dns_name_label.setter
    def internal_dns_name_label(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "internal_dns_name_label", value)

    @_builtins.property
    @pulumi.getter(name="internalDomainNameSuffix")
    def internal_domain_name_suffix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Even if `internal_dns_name_label` is not specified, a DNS entry is created for the primary NIC of the VM. This DNS name can be constructed by concatenating the VM name with the value of `internal_domain_name_suffix`.
        """
        return pulumi.get(self, "internal_domain_name_suffix")

    @internal_domain_name_suffix.setter
    def internal_domain_name_suffix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "internal_domain_name_suffix", value)

    @_builtins.property
    @pulumi.getter(name="ipConfigurations")
    def ip_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NetworkInterfaceIpConfigurationArgs']]]]:
        """
        One or more `ip_configuration` blocks as defined below.
        """
        return pulumi.get(self, "ip_configurations")

    @ip_configurations.setter
    def ip_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkInterfaceIpConfigurationArgs']]]]):
        pulumi.set(self, "ip_configurations", value)

    @_builtins.property
    @pulumi.getter(name="ipForwardingEnabled")
    def ip_forwarding_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should IP Forwarding be enabled? Defaults to `false`.
        """
        return pulumi.get(self, "ip_forwarding_enabled")

    @ip_forwarding_enabled.setter
    def ip_forwarding_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ip_forwarding_enabled", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The location where the Network Interface should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="macAddress")
    def mac_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Media Access Control (MAC) Address of the Network Interface.
        """
        return pulumi.get(self, "mac_address")

    @mac_address.setter
    def mac_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mac_address", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Network Interface. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="privateIpAddress")
    def private_ip_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The first private IP address of the network interface.
        """
        return pulumi.get(self, "private_ip_address")

    @private_ip_address.setter
    def private_ip_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_ip_address", value)

    @_builtins.property
    @pulumi.getter(name="privateIpAddresses")
    def private_ip_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The private IP addresses of the network interface.
        """
        return pulumi.get(self, "private_ip_addresses")

    @private_ip_addresses.setter
    def private_ip_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "private_ip_addresses", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Resource Group in which to create the Network Interface. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="virtualMachineId")
    def virtual_machine_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Virtual Machine which this Network Interface is connected to.
        """
        return pulumi.get(self, "virtual_machine_id")

    @virtual_machine_id.setter
    def virtual_machine_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "virtual_machine_id", value)


@pulumi.type_token("azure:network/networkInterface:NetworkInterface")
class NetworkInterface(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 accelerated_networking_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 auxiliary_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 auxiliary_sku: Optional[pulumi.Input[_builtins.str]] = None,
                 dns_servers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 edge_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 internal_dns_name_label: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NetworkInterfaceIpConfigurationArgs', 'NetworkInterfaceIpConfigurationArgsDict']]]]] = None,
                 ip_forwarding_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Manages a Network Interface.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_virtual_network = azure.network.VirtualNetwork("example",
            name="example-network",
            address_spaces=["10.0.0.0/16"],
            location=example.location,
            resource_group_name=example.name)
        example_subnet = azure.network.Subnet("example",
            name="internal",
            resource_group_name=example.name,
            virtual_network_name=example_virtual_network.name,
            address_prefixes=["10.0.2.0/24"])
        example_network_interface = azure.network.NetworkInterface("example",
            name="example-nic",
            location=example.location,
            resource_group_name=example.name,
            ip_configurations=[{
                "name": "internal",
                "subnet_id": example_subnet.id,
                "private_ip_address_allocation": "Dynamic",
            }])
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Network`: 2024-05-01

        ## Import

        Network Interfaces can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:network/networkInterface:NetworkInterface example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.Network/networkInterfaces/nic1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] accelerated_networking_enabled: Should Accelerated Networking be enabled? Defaults to `false`.
               
               > **Note:** Only certain Virtual Machine sizes are supported for Accelerated Networking - [more information can be found in this document](https://docs.microsoft.com/azure/virtual-network/create-vm-accelerated-networking-cli).
               
               > **Note:** To use Accelerated Networking in an Availability Set, the Availability Set must be deployed onto an Accelerated Networking enabled cluster.
        :param pulumi.Input[_builtins.str] auxiliary_mode: Specifies the auxiliary mode used to enable network high-performance feature on Network Virtual Appliances (NVAs). This feature offers competitive performance in Connections Per Second (CPS) optimization, along with improvements to handling large amounts of simultaneous connections. Possible values are `AcceleratedConnections`, `Floating`, `MaxConnections` and `None`.
               
               > **Note:** `auxiliary_mode` is in **Preview** and requires that the preview is enabled - [more information can be found in the Azure documentation](https://learn.microsoft.com/azure/networking/nva-accelerated-connections#prerequisites).
        :param pulumi.Input[_builtins.str] auxiliary_sku: Specifies the SKU used for the network high-performance feature on Network Virtual Appliances (NVAs). Possible values are `A8`, `A4`, `A1`, `A2` and `None`.
               
               > **Note:** `auxiliary_sku` is in **Preview** and requires that the preview is enabled - [more information can be found in the Azure documentation](https://learn.microsoft.com/azure/networking/nva-accelerated-connections#prerequisites).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] dns_servers: A list of IP Addresses defining the DNS Servers which should be used for this Network Interface.
               
               > **Note:** Configuring DNS Servers on the Network Interface will override the DNS Servers defined on the Virtual Network.
        :param pulumi.Input[_builtins.str] edge_zone: Specifies the Edge Zone within the Azure Region where this Network Interface should exist. Changing this forces a new Network Interface to be created.
        :param pulumi.Input[_builtins.str] internal_dns_name_label: The (relative) DNS Name used for internal communications between Virtual Machines in the same Virtual Network.
        :param pulumi.Input[Sequence[pulumi.Input[Union['NetworkInterfaceIpConfigurationArgs', 'NetworkInterfaceIpConfigurationArgsDict']]]] ip_configurations: One or more `ip_configuration` blocks as defined below.
        :param pulumi.Input[_builtins.bool] ip_forwarding_enabled: Should IP Forwarding be enabled? Defaults to `false`.
        :param pulumi.Input[_builtins.str] location: The location where the Network Interface should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name of the Network Interface. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group in which to create the Network Interface. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NetworkInterfaceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Network Interface.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_virtual_network = azure.network.VirtualNetwork("example",
            name="example-network",
            address_spaces=["10.0.0.0/16"],
            location=example.location,
            resource_group_name=example.name)
        example_subnet = azure.network.Subnet("example",
            name="internal",
            resource_group_name=example.name,
            virtual_network_name=example_virtual_network.name,
            address_prefixes=["10.0.2.0/24"])
        example_network_interface = azure.network.NetworkInterface("example",
            name="example-nic",
            location=example.location,
            resource_group_name=example.name,
            ip_configurations=[{
                "name": "internal",
                "subnet_id": example_subnet.id,
                "private_ip_address_allocation": "Dynamic",
            }])
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Network`: 2024-05-01

        ## Import

        Network Interfaces can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:network/networkInterface:NetworkInterface example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.Network/networkInterfaces/nic1
        ```

        :param str resource_name: The name of the resource.
        :param NetworkInterfaceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NetworkInterfaceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 accelerated_networking_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 auxiliary_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 auxiliary_sku: Optional[pulumi.Input[_builtins.str]] = None,
                 dns_servers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 edge_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 internal_dns_name_label: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NetworkInterfaceIpConfigurationArgs', 'NetworkInterfaceIpConfigurationArgsDict']]]]] = None,
                 ip_forwarding_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NetworkInterfaceArgs.__new__(NetworkInterfaceArgs)

            __props__.__dict__["accelerated_networking_enabled"] = accelerated_networking_enabled
            __props__.__dict__["auxiliary_mode"] = auxiliary_mode
            __props__.__dict__["auxiliary_sku"] = auxiliary_sku
            __props__.__dict__["dns_servers"] = dns_servers
            __props__.__dict__["edge_zone"] = edge_zone
            __props__.__dict__["internal_dns_name_label"] = internal_dns_name_label
            if ip_configurations is None and not opts.urn:
                raise TypeError("Missing required property 'ip_configurations'")
            __props__.__dict__["ip_configurations"] = ip_configurations
            __props__.__dict__["ip_forwarding_enabled"] = ip_forwarding_enabled
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["tags"] = tags
            __props__.__dict__["applied_dns_servers"] = None
            __props__.__dict__["internal_domain_name_suffix"] = None
            __props__.__dict__["mac_address"] = None
            __props__.__dict__["private_ip_address"] = None
            __props__.__dict__["private_ip_addresses"] = None
            __props__.__dict__["virtual_machine_id"] = None
        super(NetworkInterface, __self__).__init__(
            'azure:network/networkInterface:NetworkInterface',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            accelerated_networking_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            applied_dns_servers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            auxiliary_mode: Optional[pulumi.Input[_builtins.str]] = None,
            auxiliary_sku: Optional[pulumi.Input[_builtins.str]] = None,
            dns_servers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            edge_zone: Optional[pulumi.Input[_builtins.str]] = None,
            internal_dns_name_label: Optional[pulumi.Input[_builtins.str]] = None,
            internal_domain_name_suffix: Optional[pulumi.Input[_builtins.str]] = None,
            ip_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NetworkInterfaceIpConfigurationArgs', 'NetworkInterfaceIpConfigurationArgsDict']]]]] = None,
            ip_forwarding_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            mac_address: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            private_ip_address: Optional[pulumi.Input[_builtins.str]] = None,
            private_ip_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            virtual_machine_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'NetworkInterface':
        """
        Get an existing NetworkInterface resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] accelerated_networking_enabled: Should Accelerated Networking be enabled? Defaults to `false`.
               
               > **Note:** Only certain Virtual Machine sizes are supported for Accelerated Networking - [more information can be found in this document](https://docs.microsoft.com/azure/virtual-network/create-vm-accelerated-networking-cli).
               
               > **Note:** To use Accelerated Networking in an Availability Set, the Availability Set must be deployed onto an Accelerated Networking enabled cluster.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] applied_dns_servers: If the Virtual Machine using this Network Interface is part of an Availability Set, then this list will have the union of all DNS servers from all Network Interfaces that are part of the Availability Set.
        :param pulumi.Input[_builtins.str] auxiliary_mode: Specifies the auxiliary mode used to enable network high-performance feature on Network Virtual Appliances (NVAs). This feature offers competitive performance in Connections Per Second (CPS) optimization, along with improvements to handling large amounts of simultaneous connections. Possible values are `AcceleratedConnections`, `Floating`, `MaxConnections` and `None`.
               
               > **Note:** `auxiliary_mode` is in **Preview** and requires that the preview is enabled - [more information can be found in the Azure documentation](https://learn.microsoft.com/azure/networking/nva-accelerated-connections#prerequisites).
        :param pulumi.Input[_builtins.str] auxiliary_sku: Specifies the SKU used for the network high-performance feature on Network Virtual Appliances (NVAs). Possible values are `A8`, `A4`, `A1`, `A2` and `None`.
               
               > **Note:** `auxiliary_sku` is in **Preview** and requires that the preview is enabled - [more information can be found in the Azure documentation](https://learn.microsoft.com/azure/networking/nva-accelerated-connections#prerequisites).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] dns_servers: A list of IP Addresses defining the DNS Servers which should be used for this Network Interface.
               
               > **Note:** Configuring DNS Servers on the Network Interface will override the DNS Servers defined on the Virtual Network.
        :param pulumi.Input[_builtins.str] edge_zone: Specifies the Edge Zone within the Azure Region where this Network Interface should exist. Changing this forces a new Network Interface to be created.
        :param pulumi.Input[_builtins.str] internal_dns_name_label: The (relative) DNS Name used for internal communications between Virtual Machines in the same Virtual Network.
        :param pulumi.Input[_builtins.str] internal_domain_name_suffix: Even if `internal_dns_name_label` is not specified, a DNS entry is created for the primary NIC of the VM. This DNS name can be constructed by concatenating the VM name with the value of `internal_domain_name_suffix`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['NetworkInterfaceIpConfigurationArgs', 'NetworkInterfaceIpConfigurationArgsDict']]]] ip_configurations: One or more `ip_configuration` blocks as defined below.
        :param pulumi.Input[_builtins.bool] ip_forwarding_enabled: Should IP Forwarding be enabled? Defaults to `false`.
        :param pulumi.Input[_builtins.str] location: The location where the Network Interface should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] mac_address: The Media Access Control (MAC) Address of the Network Interface.
        :param pulumi.Input[_builtins.str] name: The name of the Network Interface. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] private_ip_address: The first private IP address of the network interface.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] private_ip_addresses: The private IP addresses of the network interface.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group in which to create the Network Interface. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.str] virtual_machine_id: The ID of the Virtual Machine which this Network Interface is connected to.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NetworkInterfaceState.__new__(_NetworkInterfaceState)

        __props__.__dict__["accelerated_networking_enabled"] = accelerated_networking_enabled
        __props__.__dict__["applied_dns_servers"] = applied_dns_servers
        __props__.__dict__["auxiliary_mode"] = auxiliary_mode
        __props__.__dict__["auxiliary_sku"] = auxiliary_sku
        __props__.__dict__["dns_servers"] = dns_servers
        __props__.__dict__["edge_zone"] = edge_zone
        __props__.__dict__["internal_dns_name_label"] = internal_dns_name_label
        __props__.__dict__["internal_domain_name_suffix"] = internal_domain_name_suffix
        __props__.__dict__["ip_configurations"] = ip_configurations
        __props__.__dict__["ip_forwarding_enabled"] = ip_forwarding_enabled
        __props__.__dict__["location"] = location
        __props__.__dict__["mac_address"] = mac_address
        __props__.__dict__["name"] = name
        __props__.__dict__["private_ip_address"] = private_ip_address
        __props__.__dict__["private_ip_addresses"] = private_ip_addresses
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["tags"] = tags
        __props__.__dict__["virtual_machine_id"] = virtual_machine_id
        return NetworkInterface(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="acceleratedNetworkingEnabled")
    def accelerated_networking_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Should Accelerated Networking be enabled? Defaults to `false`.

        > **Note:** Only certain Virtual Machine sizes are supported for Accelerated Networking - [more information can be found in this document](https://docs.microsoft.com/azure/virtual-network/create-vm-accelerated-networking-cli).

        > **Note:** To use Accelerated Networking in an Availability Set, the Availability Set must be deployed onto an Accelerated Networking enabled cluster.
        """
        return pulumi.get(self, "accelerated_networking_enabled")

    @_builtins.property
    @pulumi.getter(name="appliedDnsServers")
    def applied_dns_servers(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        If the Virtual Machine using this Network Interface is part of an Availability Set, then this list will have the union of all DNS servers from all Network Interfaces that are part of the Availability Set.
        """
        return pulumi.get(self, "applied_dns_servers")

    @_builtins.property
    @pulumi.getter(name="auxiliaryMode")
    def auxiliary_mode(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the auxiliary mode used to enable network high-performance feature on Network Virtual Appliances (NVAs). This feature offers competitive performance in Connections Per Second (CPS) optimization, along with improvements to handling large amounts of simultaneous connections. Possible values are `AcceleratedConnections`, `Floating`, `MaxConnections` and `None`.

        > **Note:** `auxiliary_mode` is in **Preview** and requires that the preview is enabled - [more information can be found in the Azure documentation](https://learn.microsoft.com/azure/networking/nva-accelerated-connections#prerequisites).
        """
        return pulumi.get(self, "auxiliary_mode")

    @_builtins.property
    @pulumi.getter(name="auxiliarySku")
    def auxiliary_sku(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the SKU used for the network high-performance feature on Network Virtual Appliances (NVAs). Possible values are `A8`, `A4`, `A1`, `A2` and `None`.

        > **Note:** `auxiliary_sku` is in **Preview** and requires that the preview is enabled - [more information can be found in the Azure documentation](https://learn.microsoft.com/azure/networking/nva-accelerated-connections#prerequisites).
        """
        return pulumi.get(self, "auxiliary_sku")

    @_builtins.property
    @pulumi.getter(name="dnsServers")
    def dns_servers(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        A list of IP Addresses defining the DNS Servers which should be used for this Network Interface.

        > **Note:** Configuring DNS Servers on the Network Interface will override the DNS Servers defined on the Virtual Network.
        """
        return pulumi.get(self, "dns_servers")

    @_builtins.property
    @pulumi.getter(name="edgeZone")
    def edge_zone(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the Edge Zone within the Azure Region where this Network Interface should exist. Changing this forces a new Network Interface to be created.
        """
        return pulumi.get(self, "edge_zone")

    @_builtins.property
    @pulumi.getter(name="internalDnsNameLabel")
    def internal_dns_name_label(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The (relative) DNS Name used for internal communications between Virtual Machines in the same Virtual Network.
        """
        return pulumi.get(self, "internal_dns_name_label")

    @_builtins.property
    @pulumi.getter(name="internalDomainNameSuffix")
    def internal_domain_name_suffix(self) -> pulumi.Output[_builtins.str]:
        """
        Even if `internal_dns_name_label` is not specified, a DNS entry is created for the primary NIC of the VM. This DNS name can be constructed by concatenating the VM name with the value of `internal_domain_name_suffix`.
        """
        return pulumi.get(self, "internal_domain_name_suffix")

    @_builtins.property
    @pulumi.getter(name="ipConfigurations")
    def ip_configurations(self) -> pulumi.Output[Sequence['outputs.NetworkInterfaceIpConfiguration']]:
        """
        One or more `ip_configuration` blocks as defined below.
        """
        return pulumi.get(self, "ip_configurations")

    @_builtins.property
    @pulumi.getter(name="ipForwardingEnabled")
    def ip_forwarding_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Should IP Forwarding be enabled? Defaults to `false`.
        """
        return pulumi.get(self, "ip_forwarding_enabled")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        The location where the Network Interface should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter(name="macAddress")
    def mac_address(self) -> pulumi.Output[_builtins.str]:
        """
        The Media Access Control (MAC) Address of the Network Interface.
        """
        return pulumi.get(self, "mac_address")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Network Interface. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="privateIpAddress")
    def private_ip_address(self) -> pulumi.Output[_builtins.str]:
        """
        The first private IP address of the network interface.
        """
        return pulumi.get(self, "private_ip_address")

    @_builtins.property
    @pulumi.getter(name="privateIpAddresses")
    def private_ip_addresses(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The private IP addresses of the network interface.
        """
        return pulumi.get(self, "private_ip_addresses")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Resource Group in which to create the Network Interface. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="virtualMachineId")
    def virtual_machine_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Virtual Machine which this Network Interface is connected to.
        """
        return pulumi.get(self, "virtual_machine_id")

