# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['RoutingIntentArgs', 'RoutingIntent']

@pulumi.input_type
class RoutingIntentArgs:
    def __init__(__self__, *,
                 routing_policies: pulumi.Input[Sequence[pulumi.Input['RoutingIntentRoutingPolicyArgs']]],
                 virtual_hub_id: pulumi.Input[_builtins.str],
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a RoutingIntent resource.
        :param pulumi.Input[Sequence[pulumi.Input['RoutingIntentRoutingPolicyArgs']]] routing_policies: One or more `routing_policy` blocks as defined below.
        :param pulumi.Input[_builtins.str] virtual_hub_id: The resource ID of the Virtual Hub. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Virtual Hub Routing Intent. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "routing_policies", routing_policies)
        pulumi.set(__self__, "virtual_hub_id", virtual_hub_id)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="routingPolicies")
    def routing_policies(self) -> pulumi.Input[Sequence[pulumi.Input['RoutingIntentRoutingPolicyArgs']]]:
        """
        One or more `routing_policy` blocks as defined below.
        """
        return pulumi.get(self, "routing_policies")

    @routing_policies.setter
    def routing_policies(self, value: pulumi.Input[Sequence[pulumi.Input['RoutingIntentRoutingPolicyArgs']]]):
        pulumi.set(self, "routing_policies", value)

    @_builtins.property
    @pulumi.getter(name="virtualHubId")
    def virtual_hub_id(self) -> pulumi.Input[_builtins.str]:
        """
        The resource ID of the Virtual Hub. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "virtual_hub_id")

    @virtual_hub_id.setter
    def virtual_hub_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "virtual_hub_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Virtual Hub Routing Intent. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _RoutingIntentState:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 routing_policies: Optional[pulumi.Input[Sequence[pulumi.Input['RoutingIntentRoutingPolicyArgs']]]] = None,
                 virtual_hub_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering RoutingIntent resources.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Virtual Hub Routing Intent. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input['RoutingIntentRoutingPolicyArgs']]] routing_policies: One or more `routing_policy` blocks as defined below.
        :param pulumi.Input[_builtins.str] virtual_hub_id: The resource ID of the Virtual Hub. Changing this forces a new resource to be created.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if routing_policies is not None:
            pulumi.set(__self__, "routing_policies", routing_policies)
        if virtual_hub_id is not None:
            pulumi.set(__self__, "virtual_hub_id", virtual_hub_id)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Virtual Hub Routing Intent. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="routingPolicies")
    def routing_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RoutingIntentRoutingPolicyArgs']]]]:
        """
        One or more `routing_policy` blocks as defined below.
        """
        return pulumi.get(self, "routing_policies")

    @routing_policies.setter
    def routing_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RoutingIntentRoutingPolicyArgs']]]]):
        pulumi.set(self, "routing_policies", value)

    @_builtins.property
    @pulumi.getter(name="virtualHubId")
    def virtual_hub_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource ID of the Virtual Hub. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "virtual_hub_id")

    @virtual_hub_id.setter
    def virtual_hub_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "virtual_hub_id", value)


@pulumi.type_token("azure:network/routingIntent:RoutingIntent")
class RoutingIntent(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 routing_policies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RoutingIntentRoutingPolicyArgs', 'RoutingIntentRoutingPolicyArgsDict']]]]] = None,
                 virtual_hub_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a Virtual Hub Routing Intent.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_virtual_wan = azure.network.VirtualWan("example",
            name="example-vwan",
            resource_group_name=example.name,
            location=example.location)
        example_virtual_hub = azure.network.VirtualHub("example",
            name="example-vhub",
            resource_group_name=example.name,
            location=example.location,
            virtual_wan_id=example_virtual_wan.id,
            address_prefix="10.0.1.0/24")
        example_firewall = azure.network.Firewall("example",
            name="example-fw",
            location=example.location,
            resource_group_name=example.name,
            sku_name="AZFW_Hub",
            sku_tier="Standard",
            virtual_hub={
                "virtual_hub_id": example_virtual_hub.id,
                "public_ip_count": 1,
            })
        example_routing_intent = azure.network.RoutingIntent("example",
            name="example-routingintent",
            virtual_hub_id=example_virtual_hub.id,
            routing_policies=[{
                "name": "InternetTrafficPolicy",
                "destinations": ["Internet"],
                "next_hop": example_firewall.id,
            }])
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Network`: 2024-05-01

        ## Import

        Virtual Hub Routing Intents can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:network/routingIntent:RoutingIntent example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resourceGroup1/providers/Microsoft.Network/virtualHubs/virtualHub1/routingIntent/routingIntent1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Virtual Hub Routing Intent. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[Union['RoutingIntentRoutingPolicyArgs', 'RoutingIntentRoutingPolicyArgsDict']]]] routing_policies: One or more `routing_policy` blocks as defined below.
        :param pulumi.Input[_builtins.str] virtual_hub_id: The resource ID of the Virtual Hub. Changing this forces a new resource to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RoutingIntentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Virtual Hub Routing Intent.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_virtual_wan = azure.network.VirtualWan("example",
            name="example-vwan",
            resource_group_name=example.name,
            location=example.location)
        example_virtual_hub = azure.network.VirtualHub("example",
            name="example-vhub",
            resource_group_name=example.name,
            location=example.location,
            virtual_wan_id=example_virtual_wan.id,
            address_prefix="10.0.1.0/24")
        example_firewall = azure.network.Firewall("example",
            name="example-fw",
            location=example.location,
            resource_group_name=example.name,
            sku_name="AZFW_Hub",
            sku_tier="Standard",
            virtual_hub={
                "virtual_hub_id": example_virtual_hub.id,
                "public_ip_count": 1,
            })
        example_routing_intent = azure.network.RoutingIntent("example",
            name="example-routingintent",
            virtual_hub_id=example_virtual_hub.id,
            routing_policies=[{
                "name": "InternetTrafficPolicy",
                "destinations": ["Internet"],
                "next_hop": example_firewall.id,
            }])
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Network`: 2024-05-01

        ## Import

        Virtual Hub Routing Intents can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:network/routingIntent:RoutingIntent example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resourceGroup1/providers/Microsoft.Network/virtualHubs/virtualHub1/routingIntent/routingIntent1
        ```

        :param str resource_name: The name of the resource.
        :param RoutingIntentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RoutingIntentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 routing_policies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RoutingIntentRoutingPolicyArgs', 'RoutingIntentRoutingPolicyArgsDict']]]]] = None,
                 virtual_hub_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RoutingIntentArgs.__new__(RoutingIntentArgs)

            __props__.__dict__["name"] = name
            if routing_policies is None and not opts.urn:
                raise TypeError("Missing required property 'routing_policies'")
            __props__.__dict__["routing_policies"] = routing_policies
            if virtual_hub_id is None and not opts.urn:
                raise TypeError("Missing required property 'virtual_hub_id'")
            __props__.__dict__["virtual_hub_id"] = virtual_hub_id
        super(RoutingIntent, __self__).__init__(
            'azure:network/routingIntent:RoutingIntent',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            routing_policies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RoutingIntentRoutingPolicyArgs', 'RoutingIntentRoutingPolicyArgsDict']]]]] = None,
            virtual_hub_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'RoutingIntent':
        """
        Get an existing RoutingIntent resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Virtual Hub Routing Intent. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[Union['RoutingIntentRoutingPolicyArgs', 'RoutingIntentRoutingPolicyArgsDict']]]] routing_policies: One or more `routing_policy` blocks as defined below.
        :param pulumi.Input[_builtins.str] virtual_hub_id: The resource ID of the Virtual Hub. Changing this forces a new resource to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RoutingIntentState.__new__(_RoutingIntentState)

        __props__.__dict__["name"] = name
        __props__.__dict__["routing_policies"] = routing_policies
        __props__.__dict__["virtual_hub_id"] = virtual_hub_id
        return RoutingIntent(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name which should be used for this Virtual Hub Routing Intent. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="routingPolicies")
    def routing_policies(self) -> pulumi.Output[Sequence['outputs.RoutingIntentRoutingPolicy']]:
        """
        One or more `routing_policy` blocks as defined below.
        """
        return pulumi.get(self, "routing_policies")

    @_builtins.property
    @pulumi.getter(name="virtualHubId")
    def virtual_hub_id(self) -> pulumi.Output[_builtins.str]:
        """
        The resource ID of the Virtual Hub. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "virtual_hub_id")

