# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['TrafficManagerAzureEndpointArgs', 'TrafficManagerAzureEndpoint']

@pulumi.input_type
class TrafficManagerAzureEndpointArgs:
    def __init__(__self__, *,
                 profile_id: pulumi.Input[_builtins.str],
                 target_resource_id: pulumi.Input[_builtins.str],
                 always_serve_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 custom_headers: Optional[pulumi.Input[Sequence[pulumi.Input['TrafficManagerAzureEndpointCustomHeaderArgs']]]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 geo_mappings: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 priority: Optional[pulumi.Input[_builtins.int]] = None,
                 subnets: Optional[pulumi.Input[Sequence[pulumi.Input['TrafficManagerAzureEndpointSubnetArgs']]]] = None,
                 weight: Optional[pulumi.Input[_builtins.int]] = None):
        """
        The set of arguments for constructing a TrafficManagerAzureEndpoint resource.
        :param pulumi.Input[_builtins.str] profile_id: The ID of the Traffic Manager Profile that this Azure Endpoint should be created within. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] target_resource_id: The ID of the Azure Resource which should be used as a target.
        :param pulumi.Input[_builtins.bool] always_serve_enabled: If Always Serve is enabled, probing for endpoint health will be disabled and endpoints will be included in the traffic routing method. Defaults to `false`.
        :param pulumi.Input[Sequence[pulumi.Input['TrafficManagerAzureEndpointCustomHeaderArgs']]] custom_headers: One or more `custom_header` blocks as defined below.
        :param pulumi.Input[_builtins.bool] enabled: Is the endpoint enabled? Defaults to `true`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] geo_mappings: A list of Geographic Regions used to distribute traffic, such as `WORLD`, `UK` or `DE`. The same location can't be specified in two endpoints. [See the Geographic Hierarchies documentation for more information](https://docs.microsoft.com/rest/api/trafficmanager/geographichierarchies/getdefault).
        :param pulumi.Input[_builtins.str] name: The name of the Azure Endpoint. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] priority: Specifies the priority of this Endpoint, this must be specified for Profiles using the `Priority` traffic routing method. Supports values between 1 and 1000, with no Endpoints sharing the same value. If omitted the value will be computed in order of creation.
        :param pulumi.Input[Sequence[pulumi.Input['TrafficManagerAzureEndpointSubnetArgs']]] subnets: One or more `subnet` blocks as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] weight: Specifies how much traffic should be distributed to this endpoint, this must be specified for Profiles using the Weighted traffic routing method. Valid values are between `1` and `1000`. Defaults to `1`.
        """
        pulumi.set(__self__, "profile_id", profile_id)
        pulumi.set(__self__, "target_resource_id", target_resource_id)
        if always_serve_enabled is not None:
            pulumi.set(__self__, "always_serve_enabled", always_serve_enabled)
        if custom_headers is not None:
            pulumi.set(__self__, "custom_headers", custom_headers)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if geo_mappings is not None:
            pulumi.set(__self__, "geo_mappings", geo_mappings)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if subnets is not None:
            pulumi.set(__self__, "subnets", subnets)
        if weight is not None:
            pulumi.set(__self__, "weight", weight)

    @_builtins.property
    @pulumi.getter(name="profileId")
    def profile_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Traffic Manager Profile that this Azure Endpoint should be created within. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "profile_id")

    @profile_id.setter
    def profile_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "profile_id", value)

    @_builtins.property
    @pulumi.getter(name="targetResourceId")
    def target_resource_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Azure Resource which should be used as a target.
        """
        return pulumi.get(self, "target_resource_id")

    @target_resource_id.setter
    def target_resource_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "target_resource_id", value)

    @_builtins.property
    @pulumi.getter(name="alwaysServeEnabled")
    def always_serve_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If Always Serve is enabled, probing for endpoint health will be disabled and endpoints will be included in the traffic routing method. Defaults to `false`.
        """
        return pulumi.get(self, "always_serve_enabled")

    @always_serve_enabled.setter
    def always_serve_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "always_serve_enabled", value)

    @_builtins.property
    @pulumi.getter(name="customHeaders")
    def custom_headers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TrafficManagerAzureEndpointCustomHeaderArgs']]]]:
        """
        One or more `custom_header` blocks as defined below.
        """
        return pulumi.get(self, "custom_headers")

    @custom_headers.setter
    def custom_headers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TrafficManagerAzureEndpointCustomHeaderArgs']]]]):
        pulumi.set(self, "custom_headers", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Is the endpoint enabled? Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter(name="geoMappings")
    def geo_mappings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of Geographic Regions used to distribute traffic, such as `WORLD`, `UK` or `DE`. The same location can't be specified in two endpoints. [See the Geographic Hierarchies documentation for more information](https://docs.microsoft.com/rest/api/trafficmanager/geographichierarchies/getdefault).
        """
        return pulumi.get(self, "geo_mappings")

    @geo_mappings.setter
    def geo_mappings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "geo_mappings", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Azure Endpoint. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the priority of this Endpoint, this must be specified for Profiles using the `Priority` traffic routing method. Supports values between 1 and 1000, with no Endpoints sharing the same value. If omitted the value will be computed in order of creation.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "priority", value)

    @_builtins.property
    @pulumi.getter
    def subnets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TrafficManagerAzureEndpointSubnetArgs']]]]:
        """
        One or more `subnet` blocks as defined below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "subnets")

    @subnets.setter
    def subnets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TrafficManagerAzureEndpointSubnetArgs']]]]):
        pulumi.set(self, "subnets", value)

    @_builtins.property
    @pulumi.getter
    def weight(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies how much traffic should be distributed to this endpoint, this must be specified for Profiles using the Weighted traffic routing method. Valid values are between `1` and `1000`. Defaults to `1`.
        """
        return pulumi.get(self, "weight")

    @weight.setter
    def weight(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "weight", value)


@pulumi.input_type
class _TrafficManagerAzureEndpointState:
    def __init__(__self__, *,
                 always_serve_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 custom_headers: Optional[pulumi.Input[Sequence[pulumi.Input['TrafficManagerAzureEndpointCustomHeaderArgs']]]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 geo_mappings: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 priority: Optional[pulumi.Input[_builtins.int]] = None,
                 profile_id: Optional[pulumi.Input[_builtins.str]] = None,
                 subnets: Optional[pulumi.Input[Sequence[pulumi.Input['TrafficManagerAzureEndpointSubnetArgs']]]] = None,
                 target_resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 weight: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering TrafficManagerAzureEndpoint resources.
        :param pulumi.Input[_builtins.bool] always_serve_enabled: If Always Serve is enabled, probing for endpoint health will be disabled and endpoints will be included in the traffic routing method. Defaults to `false`.
        :param pulumi.Input[Sequence[pulumi.Input['TrafficManagerAzureEndpointCustomHeaderArgs']]] custom_headers: One or more `custom_header` blocks as defined below.
        :param pulumi.Input[_builtins.bool] enabled: Is the endpoint enabled? Defaults to `true`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] geo_mappings: A list of Geographic Regions used to distribute traffic, such as `WORLD`, `UK` or `DE`. The same location can't be specified in two endpoints. [See the Geographic Hierarchies documentation for more information](https://docs.microsoft.com/rest/api/trafficmanager/geographichierarchies/getdefault).
        :param pulumi.Input[_builtins.str] name: The name of the Azure Endpoint. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] priority: Specifies the priority of this Endpoint, this must be specified for Profiles using the `Priority` traffic routing method. Supports values between 1 and 1000, with no Endpoints sharing the same value. If omitted the value will be computed in order of creation.
        :param pulumi.Input[_builtins.str] profile_id: The ID of the Traffic Manager Profile that this Azure Endpoint should be created within. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input['TrafficManagerAzureEndpointSubnetArgs']]] subnets: One or more `subnet` blocks as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] target_resource_id: The ID of the Azure Resource which should be used as a target.
        :param pulumi.Input[_builtins.int] weight: Specifies how much traffic should be distributed to this endpoint, this must be specified for Profiles using the Weighted traffic routing method. Valid values are between `1` and `1000`. Defaults to `1`.
        """
        if always_serve_enabled is not None:
            pulumi.set(__self__, "always_serve_enabled", always_serve_enabled)
        if custom_headers is not None:
            pulumi.set(__self__, "custom_headers", custom_headers)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if geo_mappings is not None:
            pulumi.set(__self__, "geo_mappings", geo_mappings)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if profile_id is not None:
            pulumi.set(__self__, "profile_id", profile_id)
        if subnets is not None:
            pulumi.set(__self__, "subnets", subnets)
        if target_resource_id is not None:
            pulumi.set(__self__, "target_resource_id", target_resource_id)
        if weight is not None:
            pulumi.set(__self__, "weight", weight)

    @_builtins.property
    @pulumi.getter(name="alwaysServeEnabled")
    def always_serve_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If Always Serve is enabled, probing for endpoint health will be disabled and endpoints will be included in the traffic routing method. Defaults to `false`.
        """
        return pulumi.get(self, "always_serve_enabled")

    @always_serve_enabled.setter
    def always_serve_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "always_serve_enabled", value)

    @_builtins.property
    @pulumi.getter(name="customHeaders")
    def custom_headers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TrafficManagerAzureEndpointCustomHeaderArgs']]]]:
        """
        One or more `custom_header` blocks as defined below.
        """
        return pulumi.get(self, "custom_headers")

    @custom_headers.setter
    def custom_headers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TrafficManagerAzureEndpointCustomHeaderArgs']]]]):
        pulumi.set(self, "custom_headers", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Is the endpoint enabled? Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter(name="geoMappings")
    def geo_mappings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of Geographic Regions used to distribute traffic, such as `WORLD`, `UK` or `DE`. The same location can't be specified in two endpoints. [See the Geographic Hierarchies documentation for more information](https://docs.microsoft.com/rest/api/trafficmanager/geographichierarchies/getdefault).
        """
        return pulumi.get(self, "geo_mappings")

    @geo_mappings.setter
    def geo_mappings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "geo_mappings", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Azure Endpoint. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the priority of this Endpoint, this must be specified for Profiles using the `Priority` traffic routing method. Supports values between 1 and 1000, with no Endpoints sharing the same value. If omitted the value will be computed in order of creation.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "priority", value)

    @_builtins.property
    @pulumi.getter(name="profileId")
    def profile_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Traffic Manager Profile that this Azure Endpoint should be created within. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "profile_id")

    @profile_id.setter
    def profile_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "profile_id", value)

    @_builtins.property
    @pulumi.getter
    def subnets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TrafficManagerAzureEndpointSubnetArgs']]]]:
        """
        One or more `subnet` blocks as defined below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "subnets")

    @subnets.setter
    def subnets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TrafficManagerAzureEndpointSubnetArgs']]]]):
        pulumi.set(self, "subnets", value)

    @_builtins.property
    @pulumi.getter(name="targetResourceId")
    def target_resource_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Azure Resource which should be used as a target.
        """
        return pulumi.get(self, "target_resource_id")

    @target_resource_id.setter
    def target_resource_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "target_resource_id", value)

    @_builtins.property
    @pulumi.getter
    def weight(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies how much traffic should be distributed to this endpoint, this must be specified for Profiles using the Weighted traffic routing method. Valid values are between `1` and `1000`. Defaults to `1`.
        """
        return pulumi.get(self, "weight")

    @weight.setter
    def weight(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "weight", value)


@pulumi.type_token("azure:network/trafficManagerAzureEndpoint:TrafficManagerAzureEndpoint")
class TrafficManagerAzureEndpoint(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 always_serve_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 custom_headers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TrafficManagerAzureEndpointCustomHeaderArgs', 'TrafficManagerAzureEndpointCustomHeaderArgsDict']]]]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 geo_mappings: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 priority: Optional[pulumi.Input[_builtins.int]] = None,
                 profile_id: Optional[pulumi.Input[_builtins.str]] = None,
                 subnets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TrafficManagerAzureEndpointSubnetArgs', 'TrafficManagerAzureEndpointSubnetArgsDict']]]]] = None,
                 target_resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 weight: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        Manages an Azure Endpoint within a Traffic Manager Profile.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_public_ip = azure.network.PublicIp("example",
            name="example-public-ip",
            location=example.location,
            resource_group_name=example.name,
            allocation_method="Static",
            domain_name_label="example-public-ip")
        example_traffic_manager_profile = azure.network.TrafficManagerProfile("example",
            name="example-profile",
            resource_group_name=example.name,
            traffic_routing_method="Weighted",
            dns_config={
                "relative_name": "example-profile",
                "ttl": 100,
            },
            monitor_config={
                "protocol": "HTTP",
                "port": 80,
                "path": "/",
                "interval_in_seconds": 30,
                "timeout_in_seconds": 9,
                "tolerated_number_of_failures": 3,
            },
            tags={
                "environment": "Production",
            })
        example_traffic_manager_azure_endpoint = azure.network.TrafficManagerAzureEndpoint("example",
            name="example-endpoint",
            profile_id=example_traffic_manager_profile.id,
            always_serve_enabled=True,
            weight=100,
            target_resource_id=example_public_ip.id)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Network`: 2022-04-01

        ## Import

        Azure Endpoints can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:network/trafficManagerAzureEndpoint:TrafficManagerAzureEndpoint example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/example-resources/providers/Microsoft.Network/trafficManagerProfiles/example-profile/AzureEndpoints/example-endpoint
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] always_serve_enabled: If Always Serve is enabled, probing for endpoint health will be disabled and endpoints will be included in the traffic routing method. Defaults to `false`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['TrafficManagerAzureEndpointCustomHeaderArgs', 'TrafficManagerAzureEndpointCustomHeaderArgsDict']]]] custom_headers: One or more `custom_header` blocks as defined below.
        :param pulumi.Input[_builtins.bool] enabled: Is the endpoint enabled? Defaults to `true`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] geo_mappings: A list of Geographic Regions used to distribute traffic, such as `WORLD`, `UK` or `DE`. The same location can't be specified in two endpoints. [See the Geographic Hierarchies documentation for more information](https://docs.microsoft.com/rest/api/trafficmanager/geographichierarchies/getdefault).
        :param pulumi.Input[_builtins.str] name: The name of the Azure Endpoint. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] priority: Specifies the priority of this Endpoint, this must be specified for Profiles using the `Priority` traffic routing method. Supports values between 1 and 1000, with no Endpoints sharing the same value. If omitted the value will be computed in order of creation.
        :param pulumi.Input[_builtins.str] profile_id: The ID of the Traffic Manager Profile that this Azure Endpoint should be created within. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[Union['TrafficManagerAzureEndpointSubnetArgs', 'TrafficManagerAzureEndpointSubnetArgsDict']]]] subnets: One or more `subnet` blocks as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] target_resource_id: The ID of the Azure Resource which should be used as a target.
        :param pulumi.Input[_builtins.int] weight: Specifies how much traffic should be distributed to this endpoint, this must be specified for Profiles using the Weighted traffic routing method. Valid values are between `1` and `1000`. Defaults to `1`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TrafficManagerAzureEndpointArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an Azure Endpoint within a Traffic Manager Profile.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_public_ip = azure.network.PublicIp("example",
            name="example-public-ip",
            location=example.location,
            resource_group_name=example.name,
            allocation_method="Static",
            domain_name_label="example-public-ip")
        example_traffic_manager_profile = azure.network.TrafficManagerProfile("example",
            name="example-profile",
            resource_group_name=example.name,
            traffic_routing_method="Weighted",
            dns_config={
                "relative_name": "example-profile",
                "ttl": 100,
            },
            monitor_config={
                "protocol": "HTTP",
                "port": 80,
                "path": "/",
                "interval_in_seconds": 30,
                "timeout_in_seconds": 9,
                "tolerated_number_of_failures": 3,
            },
            tags={
                "environment": "Production",
            })
        example_traffic_manager_azure_endpoint = azure.network.TrafficManagerAzureEndpoint("example",
            name="example-endpoint",
            profile_id=example_traffic_manager_profile.id,
            always_serve_enabled=True,
            weight=100,
            target_resource_id=example_public_ip.id)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Network`: 2022-04-01

        ## Import

        Azure Endpoints can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:network/trafficManagerAzureEndpoint:TrafficManagerAzureEndpoint example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/example-resources/providers/Microsoft.Network/trafficManagerProfiles/example-profile/AzureEndpoints/example-endpoint
        ```

        :param str resource_name: The name of the resource.
        :param TrafficManagerAzureEndpointArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TrafficManagerAzureEndpointArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 always_serve_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 custom_headers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TrafficManagerAzureEndpointCustomHeaderArgs', 'TrafficManagerAzureEndpointCustomHeaderArgsDict']]]]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 geo_mappings: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 priority: Optional[pulumi.Input[_builtins.int]] = None,
                 profile_id: Optional[pulumi.Input[_builtins.str]] = None,
                 subnets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TrafficManagerAzureEndpointSubnetArgs', 'TrafficManagerAzureEndpointSubnetArgsDict']]]]] = None,
                 target_resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 weight: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TrafficManagerAzureEndpointArgs.__new__(TrafficManagerAzureEndpointArgs)

            __props__.__dict__["always_serve_enabled"] = always_serve_enabled
            __props__.__dict__["custom_headers"] = custom_headers
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["geo_mappings"] = geo_mappings
            __props__.__dict__["name"] = name
            __props__.__dict__["priority"] = priority
            if profile_id is None and not opts.urn:
                raise TypeError("Missing required property 'profile_id'")
            __props__.__dict__["profile_id"] = profile_id
            __props__.__dict__["subnets"] = subnets
            if target_resource_id is None and not opts.urn:
                raise TypeError("Missing required property 'target_resource_id'")
            __props__.__dict__["target_resource_id"] = target_resource_id
            __props__.__dict__["weight"] = weight
        super(TrafficManagerAzureEndpoint, __self__).__init__(
            'azure:network/trafficManagerAzureEndpoint:TrafficManagerAzureEndpoint',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            always_serve_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            custom_headers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TrafficManagerAzureEndpointCustomHeaderArgs', 'TrafficManagerAzureEndpointCustomHeaderArgsDict']]]]] = None,
            enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            geo_mappings: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            priority: Optional[pulumi.Input[_builtins.int]] = None,
            profile_id: Optional[pulumi.Input[_builtins.str]] = None,
            subnets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TrafficManagerAzureEndpointSubnetArgs', 'TrafficManagerAzureEndpointSubnetArgsDict']]]]] = None,
            target_resource_id: Optional[pulumi.Input[_builtins.str]] = None,
            weight: Optional[pulumi.Input[_builtins.int]] = None) -> 'TrafficManagerAzureEndpoint':
        """
        Get an existing TrafficManagerAzureEndpoint resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] always_serve_enabled: If Always Serve is enabled, probing for endpoint health will be disabled and endpoints will be included in the traffic routing method. Defaults to `false`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['TrafficManagerAzureEndpointCustomHeaderArgs', 'TrafficManagerAzureEndpointCustomHeaderArgsDict']]]] custom_headers: One or more `custom_header` blocks as defined below.
        :param pulumi.Input[_builtins.bool] enabled: Is the endpoint enabled? Defaults to `true`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] geo_mappings: A list of Geographic Regions used to distribute traffic, such as `WORLD`, `UK` or `DE`. The same location can't be specified in two endpoints. [See the Geographic Hierarchies documentation for more information](https://docs.microsoft.com/rest/api/trafficmanager/geographichierarchies/getdefault).
        :param pulumi.Input[_builtins.str] name: The name of the Azure Endpoint. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] priority: Specifies the priority of this Endpoint, this must be specified for Profiles using the `Priority` traffic routing method. Supports values between 1 and 1000, with no Endpoints sharing the same value. If omitted the value will be computed in order of creation.
        :param pulumi.Input[_builtins.str] profile_id: The ID of the Traffic Manager Profile that this Azure Endpoint should be created within. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[Union['TrafficManagerAzureEndpointSubnetArgs', 'TrafficManagerAzureEndpointSubnetArgsDict']]]] subnets: One or more `subnet` blocks as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] target_resource_id: The ID of the Azure Resource which should be used as a target.
        :param pulumi.Input[_builtins.int] weight: Specifies how much traffic should be distributed to this endpoint, this must be specified for Profiles using the Weighted traffic routing method. Valid values are between `1` and `1000`. Defaults to `1`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TrafficManagerAzureEndpointState.__new__(_TrafficManagerAzureEndpointState)

        __props__.__dict__["always_serve_enabled"] = always_serve_enabled
        __props__.__dict__["custom_headers"] = custom_headers
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["geo_mappings"] = geo_mappings
        __props__.__dict__["name"] = name
        __props__.__dict__["priority"] = priority
        __props__.__dict__["profile_id"] = profile_id
        __props__.__dict__["subnets"] = subnets
        __props__.__dict__["target_resource_id"] = target_resource_id
        __props__.__dict__["weight"] = weight
        return TrafficManagerAzureEndpoint(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="alwaysServeEnabled")
    def always_serve_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        If Always Serve is enabled, probing for endpoint health will be disabled and endpoints will be included in the traffic routing method. Defaults to `false`.
        """
        return pulumi.get(self, "always_serve_enabled")

    @_builtins.property
    @pulumi.getter(name="customHeaders")
    def custom_headers(self) -> pulumi.Output[Optional[Sequence['outputs.TrafficManagerAzureEndpointCustomHeader']]]:
        """
        One or more `custom_header` blocks as defined below.
        """
        return pulumi.get(self, "custom_headers")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Is the endpoint enabled? Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="geoMappings")
    def geo_mappings(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        A list of Geographic Regions used to distribute traffic, such as `WORLD`, `UK` or `DE`. The same location can't be specified in two endpoints. [See the Geographic Hierarchies documentation for more information](https://docs.microsoft.com/rest/api/trafficmanager/geographichierarchies/getdefault).
        """
        return pulumi.get(self, "geo_mappings")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Azure Endpoint. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def priority(self) -> pulumi.Output[_builtins.int]:
        """
        Specifies the priority of this Endpoint, this must be specified for Profiles using the `Priority` traffic routing method. Supports values between 1 and 1000, with no Endpoints sharing the same value. If omitted the value will be computed in order of creation.
        """
        return pulumi.get(self, "priority")

    @_builtins.property
    @pulumi.getter(name="profileId")
    def profile_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Traffic Manager Profile that this Azure Endpoint should be created within. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "profile_id")

    @_builtins.property
    @pulumi.getter
    def subnets(self) -> pulumi.Output[Optional[Sequence['outputs.TrafficManagerAzureEndpointSubnet']]]:
        """
        One or more `subnet` blocks as defined below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "subnets")

    @_builtins.property
    @pulumi.getter(name="targetResourceId")
    def target_resource_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Azure Resource which should be used as a target.
        """
        return pulumi.get(self, "target_resource_id")

    @_builtins.property
    @pulumi.getter
    def weight(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Specifies how much traffic should be distributed to this endpoint, this must be specified for Profiles using the Weighted traffic routing method. Valid values are between `1` and `1000`. Defaults to `1`.
        """
        return pulumi.get(self, "weight")

