# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['VirtualHubRouteTableRouteInitArgs', 'VirtualHubRouteTableRoute']

@pulumi.input_type
class VirtualHubRouteTableRouteInitArgs:
    def __init__(__self__, *,
                 destinations: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 destinations_type: pulumi.Input[_builtins.str],
                 next_hop: pulumi.Input[_builtins.str],
                 route_table_id: pulumi.Input[_builtins.str],
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 next_hop_type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a VirtualHubRouteTableRoute resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] destinations: A list of destination addresses for this route.
        :param pulumi.Input[_builtins.str] destinations_type: The type of destinations. Possible values are `CIDR`, `ResourceId` and `Service`.
        :param pulumi.Input[_builtins.str] next_hop: The next hop's resource ID.
        :param pulumi.Input[_builtins.str] route_table_id: The ID of the Virtual Hub Route Table to link this route to. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this route. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] next_hop_type: The type of next hop. Currently the only possible value is `ResourceId`. Defaults to `ResourceId`.
        """
        pulumi.set(__self__, "destinations", destinations)
        pulumi.set(__self__, "destinations_type", destinations_type)
        pulumi.set(__self__, "next_hop", next_hop)
        pulumi.set(__self__, "route_table_id", route_table_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if next_hop_type is not None:
            pulumi.set(__self__, "next_hop_type", next_hop_type)

    @_builtins.property
    @pulumi.getter
    def destinations(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        A list of destination addresses for this route.
        """
        return pulumi.get(self, "destinations")

    @destinations.setter
    def destinations(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "destinations", value)

    @_builtins.property
    @pulumi.getter(name="destinationsType")
    def destinations_type(self) -> pulumi.Input[_builtins.str]:
        """
        The type of destinations. Possible values are `CIDR`, `ResourceId` and `Service`.
        """
        return pulumi.get(self, "destinations_type")

    @destinations_type.setter
    def destinations_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "destinations_type", value)

    @_builtins.property
    @pulumi.getter(name="nextHop")
    def next_hop(self) -> pulumi.Input[_builtins.str]:
        """
        The next hop's resource ID.
        """
        return pulumi.get(self, "next_hop")

    @next_hop.setter
    def next_hop(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "next_hop", value)

    @_builtins.property
    @pulumi.getter(name="routeTableId")
    def route_table_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Virtual Hub Route Table to link this route to. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "route_table_id")

    @route_table_id.setter
    def route_table_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "route_table_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this route. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="nextHopType")
    def next_hop_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of next hop. Currently the only possible value is `ResourceId`. Defaults to `ResourceId`.
        """
        return pulumi.get(self, "next_hop_type")

    @next_hop_type.setter
    def next_hop_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "next_hop_type", value)


@pulumi.input_type
class _VirtualHubRouteTableRouteState:
    def __init__(__self__, *,
                 destinations: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 destinations_type: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 next_hop: Optional[pulumi.Input[_builtins.str]] = None,
                 next_hop_type: Optional[pulumi.Input[_builtins.str]] = None,
                 route_table_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering VirtualHubRouteTableRoute resources.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] destinations: A list of destination addresses for this route.
        :param pulumi.Input[_builtins.str] destinations_type: The type of destinations. Possible values are `CIDR`, `ResourceId` and `Service`.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this route. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] next_hop: The next hop's resource ID.
        :param pulumi.Input[_builtins.str] next_hop_type: The type of next hop. Currently the only possible value is `ResourceId`. Defaults to `ResourceId`.
        :param pulumi.Input[_builtins.str] route_table_id: The ID of the Virtual Hub Route Table to link this route to. Changing this forces a new resource to be created.
        """
        if destinations is not None:
            pulumi.set(__self__, "destinations", destinations)
        if destinations_type is not None:
            pulumi.set(__self__, "destinations_type", destinations_type)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if next_hop is not None:
            pulumi.set(__self__, "next_hop", next_hop)
        if next_hop_type is not None:
            pulumi.set(__self__, "next_hop_type", next_hop_type)
        if route_table_id is not None:
            pulumi.set(__self__, "route_table_id", route_table_id)

    @_builtins.property
    @pulumi.getter
    def destinations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of destination addresses for this route.
        """
        return pulumi.get(self, "destinations")

    @destinations.setter
    def destinations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "destinations", value)

    @_builtins.property
    @pulumi.getter(name="destinationsType")
    def destinations_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of destinations. Possible values are `CIDR`, `ResourceId` and `Service`.
        """
        return pulumi.get(self, "destinations_type")

    @destinations_type.setter
    def destinations_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "destinations_type", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this route. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="nextHop")
    def next_hop(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The next hop's resource ID.
        """
        return pulumi.get(self, "next_hop")

    @next_hop.setter
    def next_hop(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "next_hop", value)

    @_builtins.property
    @pulumi.getter(name="nextHopType")
    def next_hop_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of next hop. Currently the only possible value is `ResourceId`. Defaults to `ResourceId`.
        """
        return pulumi.get(self, "next_hop_type")

    @next_hop_type.setter
    def next_hop_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "next_hop_type", value)

    @_builtins.property
    @pulumi.getter(name="routeTableId")
    def route_table_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Virtual Hub Route Table to link this route to. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "route_table_id")

    @route_table_id.setter
    def route_table_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "route_table_id", value)


@pulumi.type_token("azure:network/virtualHubRouteTableRoute:VirtualHubRouteTableRoute")
class VirtualHubRouteTableRoute(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 destinations: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 destinations_type: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 next_hop: Optional[pulumi.Input[_builtins.str]] = None,
                 next_hop_type: Optional[pulumi.Input[_builtins.str]] = None,
                 route_table_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a Route in a Virtual Hub Route Table.

        > **Note:** Route table routes can managed with this resource, or in-line with the virtual_hub_route_table resource. Using both is not supported.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_virtual_network = azure.network.VirtualNetwork("example",
            name="example-vnet",
            address_spaces=["10.5.0.0/16"],
            location=example.location,
            resource_group_name=example.name)
        example_network_security_group = azure.network.NetworkSecurityGroup("example",
            name="example-nsg",
            location=example.location,
            resource_group_name=example.name)
        example_subnet = azure.network.Subnet("example",
            name="examplesubnet",
            resource_group_name=example.name,
            virtual_network_name=example_virtual_network.name,
            address_prefixes=["10.5.1.0/24"])
        example_subnet_network_security_group_association = azure.network.SubnetNetworkSecurityGroupAssociation("example",
            subnet_id=example_subnet.id,
            network_security_group_id=example_network_security_group.id)
        example_virtual_wan = azure.network.VirtualWan("example",
            name="example-vwan",
            resource_group_name=example.name,
            location=example.location)
        example_virtual_hub = azure.network.VirtualHub("example",
            name="example-vhub",
            resource_group_name=example.name,
            location=example.location,
            virtual_wan_id=example_virtual_wan.id,
            address_prefix="10.0.2.0/24")
        example_virtual_hub_route_table = azure.network.VirtualHubRouteTable("example",
            name="example-vhubroutetable",
            virtual_hub_id=example_virtual_hub.id,
            labels=["label1"])
        example_virtual_hub_connection = azure.network.VirtualHubConnection("example",
            name="example-vhubconn",
            virtual_hub_id=example_virtual_hub.id,
            remote_virtual_network_id=example_virtual_network.id,
            routing={
                "associated_route_table_id": example_virtual_hub_route_table.id,
            })
        example_virtual_hub_route_table_route = azure.network.VirtualHubRouteTableRoute("example",
            route_table_id=example_virtual_hub_route_table.id,
            name="example-route",
            destinations_type="CIDR",
            destinations=["10.0.0.0/16"],
            next_hop_type="ResourceId",
            next_hop=example_virtual_hub_connection.id)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Network`: 2024-05-01

        ## Import

        Virtual Hub Route Table Routes can be imported using `<Route Table Resource Id>/routes/<Route Name>`, e.g.

        ```sh
        $ pulumi import azure:network/virtualHubRouteTableRoute:VirtualHubRouteTableRoute example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.Network/virtualHubs/virtualHub1/hubRouteTables/routeTable1/routes/routeName
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] destinations: A list of destination addresses for this route.
        :param pulumi.Input[_builtins.str] destinations_type: The type of destinations. Possible values are `CIDR`, `ResourceId` and `Service`.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this route. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] next_hop: The next hop's resource ID.
        :param pulumi.Input[_builtins.str] next_hop_type: The type of next hop. Currently the only possible value is `ResourceId`. Defaults to `ResourceId`.
        :param pulumi.Input[_builtins.str] route_table_id: The ID of the Virtual Hub Route Table to link this route to. Changing this forces a new resource to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: VirtualHubRouteTableRouteInitArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Route in a Virtual Hub Route Table.

        > **Note:** Route table routes can managed with this resource, or in-line with the virtual_hub_route_table resource. Using both is not supported.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_virtual_network = azure.network.VirtualNetwork("example",
            name="example-vnet",
            address_spaces=["10.5.0.0/16"],
            location=example.location,
            resource_group_name=example.name)
        example_network_security_group = azure.network.NetworkSecurityGroup("example",
            name="example-nsg",
            location=example.location,
            resource_group_name=example.name)
        example_subnet = azure.network.Subnet("example",
            name="examplesubnet",
            resource_group_name=example.name,
            virtual_network_name=example_virtual_network.name,
            address_prefixes=["10.5.1.0/24"])
        example_subnet_network_security_group_association = azure.network.SubnetNetworkSecurityGroupAssociation("example",
            subnet_id=example_subnet.id,
            network_security_group_id=example_network_security_group.id)
        example_virtual_wan = azure.network.VirtualWan("example",
            name="example-vwan",
            resource_group_name=example.name,
            location=example.location)
        example_virtual_hub = azure.network.VirtualHub("example",
            name="example-vhub",
            resource_group_name=example.name,
            location=example.location,
            virtual_wan_id=example_virtual_wan.id,
            address_prefix="10.0.2.0/24")
        example_virtual_hub_route_table = azure.network.VirtualHubRouteTable("example",
            name="example-vhubroutetable",
            virtual_hub_id=example_virtual_hub.id,
            labels=["label1"])
        example_virtual_hub_connection = azure.network.VirtualHubConnection("example",
            name="example-vhubconn",
            virtual_hub_id=example_virtual_hub.id,
            remote_virtual_network_id=example_virtual_network.id,
            routing={
                "associated_route_table_id": example_virtual_hub_route_table.id,
            })
        example_virtual_hub_route_table_route = azure.network.VirtualHubRouteTableRoute("example",
            route_table_id=example_virtual_hub_route_table.id,
            name="example-route",
            destinations_type="CIDR",
            destinations=["10.0.0.0/16"],
            next_hop_type="ResourceId",
            next_hop=example_virtual_hub_connection.id)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Network`: 2024-05-01

        ## Import

        Virtual Hub Route Table Routes can be imported using `<Route Table Resource Id>/routes/<Route Name>`, e.g.

        ```sh
        $ pulumi import azure:network/virtualHubRouteTableRoute:VirtualHubRouteTableRoute example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.Network/virtualHubs/virtualHub1/hubRouteTables/routeTable1/routes/routeName
        ```

        :param str resource_name: The name of the resource.
        :param VirtualHubRouteTableRouteInitArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VirtualHubRouteTableRouteInitArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 destinations: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 destinations_type: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 next_hop: Optional[pulumi.Input[_builtins.str]] = None,
                 next_hop_type: Optional[pulumi.Input[_builtins.str]] = None,
                 route_table_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VirtualHubRouteTableRouteInitArgs.__new__(VirtualHubRouteTableRouteInitArgs)

            if destinations is None and not opts.urn:
                raise TypeError("Missing required property 'destinations'")
            __props__.__dict__["destinations"] = destinations
            if destinations_type is None and not opts.urn:
                raise TypeError("Missing required property 'destinations_type'")
            __props__.__dict__["destinations_type"] = destinations_type
            __props__.__dict__["name"] = name
            if next_hop is None and not opts.urn:
                raise TypeError("Missing required property 'next_hop'")
            __props__.__dict__["next_hop"] = next_hop
            __props__.__dict__["next_hop_type"] = next_hop_type
            if route_table_id is None and not opts.urn:
                raise TypeError("Missing required property 'route_table_id'")
            __props__.__dict__["route_table_id"] = route_table_id
        super(VirtualHubRouteTableRoute, __self__).__init__(
            'azure:network/virtualHubRouteTableRoute:VirtualHubRouteTableRoute',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            destinations: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            destinations_type: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            next_hop: Optional[pulumi.Input[_builtins.str]] = None,
            next_hop_type: Optional[pulumi.Input[_builtins.str]] = None,
            route_table_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'VirtualHubRouteTableRoute':
        """
        Get an existing VirtualHubRouteTableRoute resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] destinations: A list of destination addresses for this route.
        :param pulumi.Input[_builtins.str] destinations_type: The type of destinations. Possible values are `CIDR`, `ResourceId` and `Service`.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this route. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] next_hop: The next hop's resource ID.
        :param pulumi.Input[_builtins.str] next_hop_type: The type of next hop. Currently the only possible value is `ResourceId`. Defaults to `ResourceId`.
        :param pulumi.Input[_builtins.str] route_table_id: The ID of the Virtual Hub Route Table to link this route to. Changing this forces a new resource to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _VirtualHubRouteTableRouteState.__new__(_VirtualHubRouteTableRouteState)

        __props__.__dict__["destinations"] = destinations
        __props__.__dict__["destinations_type"] = destinations_type
        __props__.__dict__["name"] = name
        __props__.__dict__["next_hop"] = next_hop
        __props__.__dict__["next_hop_type"] = next_hop_type
        __props__.__dict__["route_table_id"] = route_table_id
        return VirtualHubRouteTableRoute(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def destinations(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        A list of destination addresses for this route.
        """
        return pulumi.get(self, "destinations")

    @_builtins.property
    @pulumi.getter(name="destinationsType")
    def destinations_type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of destinations. Possible values are `CIDR`, `ResourceId` and `Service`.
        """
        return pulumi.get(self, "destinations_type")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name which should be used for this route. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="nextHop")
    def next_hop(self) -> pulumi.Output[_builtins.str]:
        """
        The next hop's resource ID.
        """
        return pulumi.get(self, "next_hop")

    @_builtins.property
    @pulumi.getter(name="nextHopType")
    def next_hop_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The type of next hop. Currently the only possible value is `ResourceId`. Defaults to `ResourceId`.
        """
        return pulumi.get(self, "next_hop_type")

    @_builtins.property
    @pulumi.getter(name="routeTableId")
    def route_table_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Virtual Hub Route Table to link this route to. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "route_table_id")

