# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['MonitorArgs', 'Monitor']

@pulumi.input_type
class MonitorArgs:
    def __init__(__self__, *,
                 plan: pulumi.Input['MonitorPlanArgs'],
                 resource_group_name: pulumi.Input[_builtins.str],
                 user: pulumi.Input['MonitorUserArgs'],
                 account_creation_source: Optional[pulumi.Input[_builtins.str]] = None,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 identity: Optional[pulumi.Input['MonitorIdentityArgs']] = None,
                 ingestion_key: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 org_creation_source: Optional[pulumi.Input[_builtins.str]] = None,
                 organization_id: Optional[pulumi.Input[_builtins.str]] = None,
                 user_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Monitor resource.
        :param pulumi.Input['MonitorPlanArgs'] plan: A `plan` block as defined below. Changing this forces a new Azure Native New Relic Monitor to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: Specifies the name of the Resource Group where the Azure Native New Relic Monitor should exist. Changing this forces a new Azure Native New Relic Monitor to be created.
        :param pulumi.Input['MonitorUserArgs'] user: A `user` block as defined below. Changing this forces a new Azure Native New Relic Monitor to be created.
        :param pulumi.Input[_builtins.str] account_creation_source: Specifies the source of account creation. Possible values are `LIFTR` and `NEWRELIC`. Defaults to `LIFTR`. Changing this forces a new Azure Native New Relic Monitor to be created.
        :param pulumi.Input[_builtins.str] account_id: Specifies the account id. Changing this forces a new Azure Native New Relic Monitor to be created.
               
               > **Note:** The value of `account_id` must come from an Azure Native New Relic Monitor instance of another different subscription.
        :param pulumi.Input['MonitorIdentityArgs'] identity: An `identity` block as defined below. Changing this forces a new Azure Native New Relic Monitor to be created.
        :param pulumi.Input[_builtins.str] ingestion_key: Specifies the ingestion key of account. Changing this forces a new Azure Native New Relic Monitor to be created.
        :param pulumi.Input[_builtins.str] location: Specifies the Azure Region where the Azure Native New Relic Monitor should exist. Changing this forces a new Azure Native New Relic Monitor to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name which should be used for this Azure Native New Relic Monitor. Changing this forces a new Azure Native New Relic Monitor to be created.
        :param pulumi.Input[_builtins.str] org_creation_source: Specifies the source of org creation. Possible values are `LIFTR` and `NEWRELIC`. Defaults to `LIFTR`. Changing this forces a new Azure Native New Relic Monitor to be created.
        :param pulumi.Input[_builtins.str] organization_id: Specifies the organization id. Changing this forces a new Azure Native New Relic Monitor to be created.
               
               > **Note:** The value of `organization_id` must come from an Azure Native New Relic Monitor instance of another different subscription.
        :param pulumi.Input[_builtins.str] user_id: Specifies the user id. Changing this forces a new Azure Native New Relic Monitor to be created.
        """
        pulumi.set(__self__, "plan", plan)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "user", user)
        if account_creation_source is not None:
            pulumi.set(__self__, "account_creation_source", account_creation_source)
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if ingestion_key is not None:
            pulumi.set(__self__, "ingestion_key", ingestion_key)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if org_creation_source is not None:
            pulumi.set(__self__, "org_creation_source", org_creation_source)
        if organization_id is not None:
            pulumi.set(__self__, "organization_id", organization_id)
        if user_id is not None:
            pulumi.set(__self__, "user_id", user_id)

    @_builtins.property
    @pulumi.getter
    def plan(self) -> pulumi.Input['MonitorPlanArgs']:
        """
        A `plan` block as defined below. Changing this forces a new Azure Native New Relic Monitor to be created.
        """
        return pulumi.get(self, "plan")

    @plan.setter
    def plan(self, value: pulumi.Input['MonitorPlanArgs']):
        pulumi.set(self, "plan", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the name of the Resource Group where the Azure Native New Relic Monitor should exist. Changing this forces a new Azure Native New Relic Monitor to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter
    def user(self) -> pulumi.Input['MonitorUserArgs']:
        """
        A `user` block as defined below. Changing this forces a new Azure Native New Relic Monitor to be created.
        """
        return pulumi.get(self, "user")

    @user.setter
    def user(self, value: pulumi.Input['MonitorUserArgs']):
        pulumi.set(self, "user", value)

    @_builtins.property
    @pulumi.getter(name="accountCreationSource")
    def account_creation_source(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the source of account creation. Possible values are `LIFTR` and `NEWRELIC`. Defaults to `LIFTR`. Changing this forces a new Azure Native New Relic Monitor to be created.
        """
        return pulumi.get(self, "account_creation_source")

    @account_creation_source.setter
    def account_creation_source(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_creation_source", value)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the account id. Changing this forces a new Azure Native New Relic Monitor to be created.

        > **Note:** The value of `account_id` must come from an Azure Native New Relic Monitor instance of another different subscription.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_id", value)

    @_builtins.property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['MonitorIdentityArgs']]:
        """
        An `identity` block as defined below. Changing this forces a new Azure Native New Relic Monitor to be created.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['MonitorIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @_builtins.property
    @pulumi.getter(name="ingestionKey")
    def ingestion_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the ingestion key of account. Changing this forces a new Azure Native New Relic Monitor to be created.
        """
        return pulumi.get(self, "ingestion_key")

    @ingestion_key.setter
    def ingestion_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ingestion_key", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the Azure Region where the Azure Native New Relic Monitor should exist. Changing this forces a new Azure Native New Relic Monitor to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name which should be used for this Azure Native New Relic Monitor. Changing this forces a new Azure Native New Relic Monitor to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="orgCreationSource")
    def org_creation_source(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the source of org creation. Possible values are `LIFTR` and `NEWRELIC`. Defaults to `LIFTR`. Changing this forces a new Azure Native New Relic Monitor to be created.
        """
        return pulumi.get(self, "org_creation_source")

    @org_creation_source.setter
    def org_creation_source(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "org_creation_source", value)

    @_builtins.property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the organization id. Changing this forces a new Azure Native New Relic Monitor to be created.

        > **Note:** The value of `organization_id` must come from an Azure Native New Relic Monitor instance of another different subscription.
        """
        return pulumi.get(self, "organization_id")

    @organization_id.setter
    def organization_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "organization_id", value)

    @_builtins.property
    @pulumi.getter(name="userId")
    def user_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the user id. Changing this forces a new Azure Native New Relic Monitor to be created.
        """
        return pulumi.get(self, "user_id")

    @user_id.setter
    def user_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_id", value)


@pulumi.input_type
class _MonitorState:
    def __init__(__self__, *,
                 account_creation_source: Optional[pulumi.Input[_builtins.str]] = None,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 identity: Optional[pulumi.Input['MonitorIdentityArgs']] = None,
                 ingestion_key: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 org_creation_source: Optional[pulumi.Input[_builtins.str]] = None,
                 organization_id: Optional[pulumi.Input[_builtins.str]] = None,
                 plan: Optional[pulumi.Input['MonitorPlanArgs']] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 user: Optional[pulumi.Input['MonitorUserArgs']] = None,
                 user_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Monitor resources.
        :param pulumi.Input[_builtins.str] account_creation_source: Specifies the source of account creation. Possible values are `LIFTR` and `NEWRELIC`. Defaults to `LIFTR`. Changing this forces a new Azure Native New Relic Monitor to be created.
        :param pulumi.Input[_builtins.str] account_id: Specifies the account id. Changing this forces a new Azure Native New Relic Monitor to be created.
               
               > **Note:** The value of `account_id` must come from an Azure Native New Relic Monitor instance of another different subscription.
        :param pulumi.Input['MonitorIdentityArgs'] identity: An `identity` block as defined below. Changing this forces a new Azure Native New Relic Monitor to be created.
        :param pulumi.Input[_builtins.str] ingestion_key: Specifies the ingestion key of account. Changing this forces a new Azure Native New Relic Monitor to be created.
        :param pulumi.Input[_builtins.str] location: Specifies the Azure Region where the Azure Native New Relic Monitor should exist. Changing this forces a new Azure Native New Relic Monitor to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name which should be used for this Azure Native New Relic Monitor. Changing this forces a new Azure Native New Relic Monitor to be created.
        :param pulumi.Input[_builtins.str] org_creation_source: Specifies the source of org creation. Possible values are `LIFTR` and `NEWRELIC`. Defaults to `LIFTR`. Changing this forces a new Azure Native New Relic Monitor to be created.
        :param pulumi.Input[_builtins.str] organization_id: Specifies the organization id. Changing this forces a new Azure Native New Relic Monitor to be created.
               
               > **Note:** The value of `organization_id` must come from an Azure Native New Relic Monitor instance of another different subscription.
        :param pulumi.Input['MonitorPlanArgs'] plan: A `plan` block as defined below. Changing this forces a new Azure Native New Relic Monitor to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: Specifies the name of the Resource Group where the Azure Native New Relic Monitor should exist. Changing this forces a new Azure Native New Relic Monitor to be created.
        :param pulumi.Input['MonitorUserArgs'] user: A `user` block as defined below. Changing this forces a new Azure Native New Relic Monitor to be created.
        :param pulumi.Input[_builtins.str] user_id: Specifies the user id. Changing this forces a new Azure Native New Relic Monitor to be created.
        """
        if account_creation_source is not None:
            pulumi.set(__self__, "account_creation_source", account_creation_source)
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if ingestion_key is not None:
            pulumi.set(__self__, "ingestion_key", ingestion_key)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if org_creation_source is not None:
            pulumi.set(__self__, "org_creation_source", org_creation_source)
        if organization_id is not None:
            pulumi.set(__self__, "organization_id", organization_id)
        if plan is not None:
            pulumi.set(__self__, "plan", plan)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if user is not None:
            pulumi.set(__self__, "user", user)
        if user_id is not None:
            pulumi.set(__self__, "user_id", user_id)

    @_builtins.property
    @pulumi.getter(name="accountCreationSource")
    def account_creation_source(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the source of account creation. Possible values are `LIFTR` and `NEWRELIC`. Defaults to `LIFTR`. Changing this forces a new Azure Native New Relic Monitor to be created.
        """
        return pulumi.get(self, "account_creation_source")

    @account_creation_source.setter
    def account_creation_source(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_creation_source", value)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the account id. Changing this forces a new Azure Native New Relic Monitor to be created.

        > **Note:** The value of `account_id` must come from an Azure Native New Relic Monitor instance of another different subscription.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_id", value)

    @_builtins.property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['MonitorIdentityArgs']]:
        """
        An `identity` block as defined below. Changing this forces a new Azure Native New Relic Monitor to be created.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['MonitorIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @_builtins.property
    @pulumi.getter(name="ingestionKey")
    def ingestion_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the ingestion key of account. Changing this forces a new Azure Native New Relic Monitor to be created.
        """
        return pulumi.get(self, "ingestion_key")

    @ingestion_key.setter
    def ingestion_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ingestion_key", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the Azure Region where the Azure Native New Relic Monitor should exist. Changing this forces a new Azure Native New Relic Monitor to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name which should be used for this Azure Native New Relic Monitor. Changing this forces a new Azure Native New Relic Monitor to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="orgCreationSource")
    def org_creation_source(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the source of org creation. Possible values are `LIFTR` and `NEWRELIC`. Defaults to `LIFTR`. Changing this forces a new Azure Native New Relic Monitor to be created.
        """
        return pulumi.get(self, "org_creation_source")

    @org_creation_source.setter
    def org_creation_source(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "org_creation_source", value)

    @_builtins.property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the organization id. Changing this forces a new Azure Native New Relic Monitor to be created.

        > **Note:** The value of `organization_id` must come from an Azure Native New Relic Monitor instance of another different subscription.
        """
        return pulumi.get(self, "organization_id")

    @organization_id.setter
    def organization_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "organization_id", value)

    @_builtins.property
    @pulumi.getter
    def plan(self) -> Optional[pulumi.Input['MonitorPlanArgs']]:
        """
        A `plan` block as defined below. Changing this forces a new Azure Native New Relic Monitor to be created.
        """
        return pulumi.get(self, "plan")

    @plan.setter
    def plan(self, value: Optional[pulumi.Input['MonitorPlanArgs']]):
        pulumi.set(self, "plan", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the Resource Group where the Azure Native New Relic Monitor should exist. Changing this forces a new Azure Native New Relic Monitor to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter
    def user(self) -> Optional[pulumi.Input['MonitorUserArgs']]:
        """
        A `user` block as defined below. Changing this forces a new Azure Native New Relic Monitor to be created.
        """
        return pulumi.get(self, "user")

    @user.setter
    def user(self, value: Optional[pulumi.Input['MonitorUserArgs']]):
        pulumi.set(self, "user", value)

    @_builtins.property
    @pulumi.getter(name="userId")
    def user_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the user id. Changing this forces a new Azure Native New Relic Monitor to be created.
        """
        return pulumi.get(self, "user_id")

    @user_id.setter
    def user_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_id", value)


@pulumi.type_token("azure:newrelic/monitor:Monitor")
class Monitor(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_creation_source: Optional[pulumi.Input[_builtins.str]] = None,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 identity: Optional[pulumi.Input[Union['MonitorIdentityArgs', 'MonitorIdentityArgsDict']]] = None,
                 ingestion_key: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 org_creation_source: Optional[pulumi.Input[_builtins.str]] = None,
                 organization_id: Optional[pulumi.Input[_builtins.str]] = None,
                 plan: Optional[pulumi.Input[Union['MonitorPlanArgs', 'MonitorPlanArgsDict']]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 user: Optional[pulumi.Input[Union['MonitorUserArgs', 'MonitorUserArgsDict']]] = None,
                 user_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages an Azure Native New Relic Monitor.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="East US")
        example_monitor = azure.newrelic.Monitor("example",
            name="example-nrm",
            resource_group_name=example.name,
            location=example.location,
            plan={
                "effective_date": "2023-06-06T00:00:00Z",
            },
            user={
                "email": "user@example.com",
                "first_name": "Example",
                "last_name": "User",
                "phone_number": "+12313803556",
            },
            identity={
                "type": "SystemAssigned",
            })
        ```

        ## Role Assignment

        To enable metrics flow, perform role assignment on the identity created above. `Monitoring reader(43d0d8ad-25c7-4714-9337-8ba259a9fe05)` role is required .

        ### Role assignment on the monitor created

        ```python
        import pulumi
        import pulumi_azure as azure

        primary = azure.core.get_subscription()
        monitoring_reader = azure.authorization.get_role_definition(name="Monitoring Reader")
        example = azure.authorization.Assignment("example",
            scope=primary.id,
            role_definition_id=f"{primary.id}{monitoring_reader.id}",
            principal_id=example_azurerm_new_relic_monitor["identity"][0]["principalId"])
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `NewRelic.Observability`: 2024-03-01

        ## Import

        Azure Native New Relic Monitor can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:newrelic/monitor:Monitor example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resourceGroup1/providers/NewRelic.Observability/monitors/monitor1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_creation_source: Specifies the source of account creation. Possible values are `LIFTR` and `NEWRELIC`. Defaults to `LIFTR`. Changing this forces a new Azure Native New Relic Monitor to be created.
        :param pulumi.Input[_builtins.str] account_id: Specifies the account id. Changing this forces a new Azure Native New Relic Monitor to be created.
               
               > **Note:** The value of `account_id` must come from an Azure Native New Relic Monitor instance of another different subscription.
        :param pulumi.Input[Union['MonitorIdentityArgs', 'MonitorIdentityArgsDict']] identity: An `identity` block as defined below. Changing this forces a new Azure Native New Relic Monitor to be created.
        :param pulumi.Input[_builtins.str] ingestion_key: Specifies the ingestion key of account. Changing this forces a new Azure Native New Relic Monitor to be created.
        :param pulumi.Input[_builtins.str] location: Specifies the Azure Region where the Azure Native New Relic Monitor should exist. Changing this forces a new Azure Native New Relic Monitor to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name which should be used for this Azure Native New Relic Monitor. Changing this forces a new Azure Native New Relic Monitor to be created.
        :param pulumi.Input[_builtins.str] org_creation_source: Specifies the source of org creation. Possible values are `LIFTR` and `NEWRELIC`. Defaults to `LIFTR`. Changing this forces a new Azure Native New Relic Monitor to be created.
        :param pulumi.Input[_builtins.str] organization_id: Specifies the organization id. Changing this forces a new Azure Native New Relic Monitor to be created.
               
               > **Note:** The value of `organization_id` must come from an Azure Native New Relic Monitor instance of another different subscription.
        :param pulumi.Input[Union['MonitorPlanArgs', 'MonitorPlanArgsDict']] plan: A `plan` block as defined below. Changing this forces a new Azure Native New Relic Monitor to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: Specifies the name of the Resource Group where the Azure Native New Relic Monitor should exist. Changing this forces a new Azure Native New Relic Monitor to be created.
        :param pulumi.Input[Union['MonitorUserArgs', 'MonitorUserArgsDict']] user: A `user` block as defined below. Changing this forces a new Azure Native New Relic Monitor to be created.
        :param pulumi.Input[_builtins.str] user_id: Specifies the user id. Changing this forces a new Azure Native New Relic Monitor to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MonitorArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an Azure Native New Relic Monitor.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="East US")
        example_monitor = azure.newrelic.Monitor("example",
            name="example-nrm",
            resource_group_name=example.name,
            location=example.location,
            plan={
                "effective_date": "2023-06-06T00:00:00Z",
            },
            user={
                "email": "user@example.com",
                "first_name": "Example",
                "last_name": "User",
                "phone_number": "+12313803556",
            },
            identity={
                "type": "SystemAssigned",
            })
        ```

        ## Role Assignment

        To enable metrics flow, perform role assignment on the identity created above. `Monitoring reader(43d0d8ad-25c7-4714-9337-8ba259a9fe05)` role is required .

        ### Role assignment on the monitor created

        ```python
        import pulumi
        import pulumi_azure as azure

        primary = azure.core.get_subscription()
        monitoring_reader = azure.authorization.get_role_definition(name="Monitoring Reader")
        example = azure.authorization.Assignment("example",
            scope=primary.id,
            role_definition_id=f"{primary.id}{monitoring_reader.id}",
            principal_id=example_azurerm_new_relic_monitor["identity"][0]["principalId"])
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `NewRelic.Observability`: 2024-03-01

        ## Import

        Azure Native New Relic Monitor can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:newrelic/monitor:Monitor example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resourceGroup1/providers/NewRelic.Observability/monitors/monitor1
        ```

        :param str resource_name: The name of the resource.
        :param MonitorArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MonitorArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_creation_source: Optional[pulumi.Input[_builtins.str]] = None,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 identity: Optional[pulumi.Input[Union['MonitorIdentityArgs', 'MonitorIdentityArgsDict']]] = None,
                 ingestion_key: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 org_creation_source: Optional[pulumi.Input[_builtins.str]] = None,
                 organization_id: Optional[pulumi.Input[_builtins.str]] = None,
                 plan: Optional[pulumi.Input[Union['MonitorPlanArgs', 'MonitorPlanArgsDict']]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 user: Optional[pulumi.Input[Union['MonitorUserArgs', 'MonitorUserArgsDict']]] = None,
                 user_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MonitorArgs.__new__(MonitorArgs)

            __props__.__dict__["account_creation_source"] = account_creation_source
            __props__.__dict__["account_id"] = account_id
            __props__.__dict__["identity"] = identity
            __props__.__dict__["ingestion_key"] = None if ingestion_key is None else pulumi.Output.secret(ingestion_key)
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            __props__.__dict__["org_creation_source"] = org_creation_source
            __props__.__dict__["organization_id"] = organization_id
            if plan is None and not opts.urn:
                raise TypeError("Missing required property 'plan'")
            __props__.__dict__["plan"] = plan
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            if user is None and not opts.urn:
                raise TypeError("Missing required property 'user'")
            __props__.__dict__["user"] = user
            __props__.__dict__["user_id"] = user_id
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["ingestionKey"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Monitor, __self__).__init__(
            'azure:newrelic/monitor:Monitor',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_creation_source: Optional[pulumi.Input[_builtins.str]] = None,
            account_id: Optional[pulumi.Input[_builtins.str]] = None,
            identity: Optional[pulumi.Input[Union['MonitorIdentityArgs', 'MonitorIdentityArgsDict']]] = None,
            ingestion_key: Optional[pulumi.Input[_builtins.str]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            org_creation_source: Optional[pulumi.Input[_builtins.str]] = None,
            organization_id: Optional[pulumi.Input[_builtins.str]] = None,
            plan: Optional[pulumi.Input[Union['MonitorPlanArgs', 'MonitorPlanArgsDict']]] = None,
            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            user: Optional[pulumi.Input[Union['MonitorUserArgs', 'MonitorUserArgsDict']]] = None,
            user_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'Monitor':
        """
        Get an existing Monitor resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_creation_source: Specifies the source of account creation. Possible values are `LIFTR` and `NEWRELIC`. Defaults to `LIFTR`. Changing this forces a new Azure Native New Relic Monitor to be created.
        :param pulumi.Input[_builtins.str] account_id: Specifies the account id. Changing this forces a new Azure Native New Relic Monitor to be created.
               
               > **Note:** The value of `account_id` must come from an Azure Native New Relic Monitor instance of another different subscription.
        :param pulumi.Input[Union['MonitorIdentityArgs', 'MonitorIdentityArgsDict']] identity: An `identity` block as defined below. Changing this forces a new Azure Native New Relic Monitor to be created.
        :param pulumi.Input[_builtins.str] ingestion_key: Specifies the ingestion key of account. Changing this forces a new Azure Native New Relic Monitor to be created.
        :param pulumi.Input[_builtins.str] location: Specifies the Azure Region where the Azure Native New Relic Monitor should exist. Changing this forces a new Azure Native New Relic Monitor to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name which should be used for this Azure Native New Relic Monitor. Changing this forces a new Azure Native New Relic Monitor to be created.
        :param pulumi.Input[_builtins.str] org_creation_source: Specifies the source of org creation. Possible values are `LIFTR` and `NEWRELIC`. Defaults to `LIFTR`. Changing this forces a new Azure Native New Relic Monitor to be created.
        :param pulumi.Input[_builtins.str] organization_id: Specifies the organization id. Changing this forces a new Azure Native New Relic Monitor to be created.
               
               > **Note:** The value of `organization_id` must come from an Azure Native New Relic Monitor instance of another different subscription.
        :param pulumi.Input[Union['MonitorPlanArgs', 'MonitorPlanArgsDict']] plan: A `plan` block as defined below. Changing this forces a new Azure Native New Relic Monitor to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: Specifies the name of the Resource Group where the Azure Native New Relic Monitor should exist. Changing this forces a new Azure Native New Relic Monitor to be created.
        :param pulumi.Input[Union['MonitorUserArgs', 'MonitorUserArgsDict']] user: A `user` block as defined below. Changing this forces a new Azure Native New Relic Monitor to be created.
        :param pulumi.Input[_builtins.str] user_id: Specifies the user id. Changing this forces a new Azure Native New Relic Monitor to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MonitorState.__new__(_MonitorState)

        __props__.__dict__["account_creation_source"] = account_creation_source
        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["identity"] = identity
        __props__.__dict__["ingestion_key"] = ingestion_key
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["org_creation_source"] = org_creation_source
        __props__.__dict__["organization_id"] = organization_id
        __props__.__dict__["plan"] = plan
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["user"] = user
        __props__.__dict__["user_id"] = user_id
        return Monitor(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accountCreationSource")
    def account_creation_source(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the source of account creation. Possible values are `LIFTR` and `NEWRELIC`. Defaults to `LIFTR`. Changing this forces a new Azure Native New Relic Monitor to be created.
        """
        return pulumi.get(self, "account_creation_source")

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the account id. Changing this forces a new Azure Native New Relic Monitor to be created.

        > **Note:** The value of `account_id` must come from an Azure Native New Relic Monitor instance of another different subscription.
        """
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter
    def identity(self) -> pulumi.Output[Optional['outputs.MonitorIdentity']]:
        """
        An `identity` block as defined below. Changing this forces a new Azure Native New Relic Monitor to be created.
        """
        return pulumi.get(self, "identity")

    @_builtins.property
    @pulumi.getter(name="ingestionKey")
    def ingestion_key(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the ingestion key of account. Changing this forces a new Azure Native New Relic Monitor to be created.
        """
        return pulumi.get(self, "ingestion_key")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the Azure Region where the Azure Native New Relic Monitor should exist. Changing this forces a new Azure Native New Relic Monitor to be created.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name which should be used for this Azure Native New Relic Monitor. Changing this forces a new Azure Native New Relic Monitor to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="orgCreationSource")
    def org_creation_source(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the source of org creation. Possible values are `LIFTR` and `NEWRELIC`. Defaults to `LIFTR`. Changing this forces a new Azure Native New Relic Monitor to be created.
        """
        return pulumi.get(self, "org_creation_source")

    @_builtins.property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the organization id. Changing this forces a new Azure Native New Relic Monitor to be created.

        > **Note:** The value of `organization_id` must come from an Azure Native New Relic Monitor instance of another different subscription.
        """
        return pulumi.get(self, "organization_id")

    @_builtins.property
    @pulumi.getter
    def plan(self) -> pulumi.Output['outputs.MonitorPlan']:
        """
        A `plan` block as defined below. Changing this forces a new Azure Native New Relic Monitor to be created.
        """
        return pulumi.get(self, "plan")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of the Resource Group where the Azure Native New Relic Monitor should exist. Changing this forces a new Azure Native New Relic Monitor to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter
    def user(self) -> pulumi.Output['outputs.MonitorUser']:
        """
        A `user` block as defined below. Changing this forces a new Azure Native New Relic Monitor to be created.
        """
        return pulumi.get(self, "user")

    @_builtins.property
    @pulumi.getter(name="userId")
    def user_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the user id. Changing this forces a new Azure Native New Relic Monitor to be created.
        """
        return pulumi.get(self, "user_id")

