# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AnalyticsSolutionArgs', 'AnalyticsSolution']

@pulumi.input_type
class AnalyticsSolutionArgs:
    def __init__(__self__, *,
                 plan: pulumi.Input['AnalyticsSolutionPlanArgs'],
                 resource_group_name: pulumi.Input[_builtins.str],
                 solution_name: pulumi.Input[_builtins.str],
                 workspace_name: pulumi.Input[_builtins.str],
                 workspace_resource_id: pulumi.Input[_builtins.str],
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a AnalyticsSolution resource.
        :param pulumi.Input['AnalyticsSolutionPlanArgs'] plan: A `plan` block as documented below.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which the Log Analytics solution is created. Changing this forces a new resource to be created. Note: The solution and its related workspace can only exist in the same resource group.
        :param pulumi.Input[_builtins.str] solution_name: Specifies the name of the solution to be deployed. See [here for options](https://docs.microsoft.com/azure/log-analytics/log-analytics-add-solutions).Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] workspace_name: The full name of the Log Analytics workspace with which the solution will be linked. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] workspace_resource_id: The full resource ID of the Log Analytics workspace with which the solution will be linked. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] location: Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        """
        pulumi.set(__self__, "plan", plan)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "solution_name", solution_name)
        pulumi.set(__self__, "workspace_name", workspace_name)
        pulumi.set(__self__, "workspace_resource_id", workspace_resource_id)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def plan(self) -> pulumi.Input['AnalyticsSolutionPlanArgs']:
        """
        A `plan` block as documented below.
        """
        return pulumi.get(self, "plan")

    @plan.setter
    def plan(self, value: pulumi.Input['AnalyticsSolutionPlanArgs']):
        pulumi.set(self, "plan", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the resource group in which the Log Analytics solution is created. Changing this forces a new resource to be created. Note: The solution and its related workspace can only exist in the same resource group.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="solutionName")
    def solution_name(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the name of the solution to be deployed. See [here for options](https://docs.microsoft.com/azure/log-analytics/log-analytics-add-solutions).Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "solution_name")

    @solution_name.setter
    def solution_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "solution_name", value)

    @_builtins.property
    @pulumi.getter(name="workspaceName")
    def workspace_name(self) -> pulumi.Input[_builtins.str]:
        """
        The full name of the Log Analytics workspace with which the solution will be linked. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "workspace_name")

    @workspace_name.setter
    def workspace_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "workspace_name", value)

    @_builtins.property
    @pulumi.getter(name="workspaceResourceId")
    def workspace_resource_id(self) -> pulumi.Input[_builtins.str]:
        """
        The full resource ID of the Log Analytics workspace with which the solution will be linked. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "workspace_resource_id")

    @workspace_resource_id.setter
    def workspace_resource_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "workspace_resource_id", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _AnalyticsSolutionState:
    def __init__(__self__, *,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 plan: Optional[pulumi.Input['AnalyticsSolutionPlanArgs']] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 solution_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 workspace_name: Optional[pulumi.Input[_builtins.str]] = None,
                 workspace_resource_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering AnalyticsSolution resources.
        :param pulumi.Input[_builtins.str] location: Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input['AnalyticsSolutionPlanArgs'] plan: A `plan` block as documented below.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which the Log Analytics solution is created. Changing this forces a new resource to be created. Note: The solution and its related workspace can only exist in the same resource group.
        :param pulumi.Input[_builtins.str] solution_name: Specifies the name of the solution to be deployed. See [here for options](https://docs.microsoft.com/azure/log-analytics/log-analytics-add-solutions).Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.str] workspace_name: The full name of the Log Analytics workspace with which the solution will be linked. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] workspace_resource_id: The full resource ID of the Log Analytics workspace with which the solution will be linked. Changing this forces a new resource to be created.
        """
        if location is not None:
            pulumi.set(__self__, "location", location)
        if plan is not None:
            pulumi.set(__self__, "plan", plan)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if solution_name is not None:
            pulumi.set(__self__, "solution_name", solution_name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if workspace_name is not None:
            pulumi.set(__self__, "workspace_name", workspace_name)
        if workspace_resource_id is not None:
            pulumi.set(__self__, "workspace_resource_id", workspace_resource_id)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def plan(self) -> Optional[pulumi.Input['AnalyticsSolutionPlanArgs']]:
        """
        A `plan` block as documented below.
        """
        return pulumi.get(self, "plan")

    @plan.setter
    def plan(self, value: Optional[pulumi.Input['AnalyticsSolutionPlanArgs']]):
        pulumi.set(self, "plan", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the resource group in which the Log Analytics solution is created. Changing this forces a new resource to be created. Note: The solution and its related workspace can only exist in the same resource group.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="solutionName")
    def solution_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the solution to be deployed. See [here for options](https://docs.microsoft.com/azure/log-analytics/log-analytics-add-solutions).Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "solution_name")

    @solution_name.setter
    def solution_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "solution_name", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="workspaceName")
    def workspace_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The full name of the Log Analytics workspace with which the solution will be linked. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "workspace_name")

    @workspace_name.setter
    def workspace_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "workspace_name", value)

    @_builtins.property
    @pulumi.getter(name="workspaceResourceId")
    def workspace_resource_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The full resource ID of the Log Analytics workspace with which the solution will be linked. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "workspace_resource_id")

    @workspace_resource_id.setter
    def workspace_resource_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "workspace_resource_id", value)


@pulumi.type_token("azure:operationalinsights/analyticsSolution:AnalyticsSolution")
class AnalyticsSolution(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 plan: Optional[pulumi.Input[Union['AnalyticsSolutionPlanArgs', 'AnalyticsSolutionPlanArgsDict']]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 solution_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 workspace_name: Optional[pulumi.Input[_builtins.str]] = None,
                 workspace_resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a Log Analytics (formally Operational Insights) Solution.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure
        import pulumi_random as random

        example = azure.core.ResourceGroup("example",
            name="k8s-log-analytics-test",
            location="West Europe")
        workspace = random.RandomId("workspace",
            keepers={
                "group_name": example.name,
            },
            byte_length=8)
        example_analytics_workspace = azure.operationalinsights.AnalyticsWorkspace("example",
            name=workspace.hex.apply(lambda hex: f"k8s-workspace-{hex}"),
            location=example.location,
            resource_group_name=example.name,
            sku="PerGB2018")
        example_analytics_solution = azure.operationalinsights.AnalyticsSolution("example",
            solution_name="ContainerInsights",
            location=example.location,
            resource_group_name=example.name,
            workspace_resource_id=example_analytics_workspace.id,
            workspace_name=example_analytics_workspace.name,
            plan={
                "publisher": "Microsoft",
                "product": "OMSGallery/ContainerInsights",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.OperationsManagement`: 2015-11-01-preview

        ## Import

        Log Analytics Solutions can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:operationalinsights/analyticsSolution:AnalyticsSolution solution1 /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.OperationsManagement/solutions/solution1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] location: Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['AnalyticsSolutionPlanArgs', 'AnalyticsSolutionPlanArgsDict']] plan: A `plan` block as documented below.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which the Log Analytics solution is created. Changing this forces a new resource to be created. Note: The solution and its related workspace can only exist in the same resource group.
        :param pulumi.Input[_builtins.str] solution_name: Specifies the name of the solution to be deployed. See [here for options](https://docs.microsoft.com/azure/log-analytics/log-analytics-add-solutions).Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.str] workspace_name: The full name of the Log Analytics workspace with which the solution will be linked. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] workspace_resource_id: The full resource ID of the Log Analytics workspace with which the solution will be linked. Changing this forces a new resource to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AnalyticsSolutionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Log Analytics (formally Operational Insights) Solution.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure
        import pulumi_random as random

        example = azure.core.ResourceGroup("example",
            name="k8s-log-analytics-test",
            location="West Europe")
        workspace = random.RandomId("workspace",
            keepers={
                "group_name": example.name,
            },
            byte_length=8)
        example_analytics_workspace = azure.operationalinsights.AnalyticsWorkspace("example",
            name=workspace.hex.apply(lambda hex: f"k8s-workspace-{hex}"),
            location=example.location,
            resource_group_name=example.name,
            sku="PerGB2018")
        example_analytics_solution = azure.operationalinsights.AnalyticsSolution("example",
            solution_name="ContainerInsights",
            location=example.location,
            resource_group_name=example.name,
            workspace_resource_id=example_analytics_workspace.id,
            workspace_name=example_analytics_workspace.name,
            plan={
                "publisher": "Microsoft",
                "product": "OMSGallery/ContainerInsights",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.OperationsManagement`: 2015-11-01-preview

        ## Import

        Log Analytics Solutions can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:operationalinsights/analyticsSolution:AnalyticsSolution solution1 /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.OperationsManagement/solutions/solution1
        ```

        :param str resource_name: The name of the resource.
        :param AnalyticsSolutionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AnalyticsSolutionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 plan: Optional[pulumi.Input[Union['AnalyticsSolutionPlanArgs', 'AnalyticsSolutionPlanArgsDict']]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 solution_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 workspace_name: Optional[pulumi.Input[_builtins.str]] = None,
                 workspace_resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AnalyticsSolutionArgs.__new__(AnalyticsSolutionArgs)

            __props__.__dict__["location"] = location
            if plan is None and not opts.urn:
                raise TypeError("Missing required property 'plan'")
            __props__.__dict__["plan"] = plan
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            if solution_name is None and not opts.urn:
                raise TypeError("Missing required property 'solution_name'")
            __props__.__dict__["solution_name"] = solution_name
            __props__.__dict__["tags"] = tags
            if workspace_name is None and not opts.urn:
                raise TypeError("Missing required property 'workspace_name'")
            __props__.__dict__["workspace_name"] = workspace_name
            if workspace_resource_id is None and not opts.urn:
                raise TypeError("Missing required property 'workspace_resource_id'")
            __props__.__dict__["workspace_resource_id"] = workspace_resource_id
        super(AnalyticsSolution, __self__).__init__(
            'azure:operationalinsights/analyticsSolution:AnalyticsSolution',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            plan: Optional[pulumi.Input[Union['AnalyticsSolutionPlanArgs', 'AnalyticsSolutionPlanArgsDict']]] = None,
            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            solution_name: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            workspace_name: Optional[pulumi.Input[_builtins.str]] = None,
            workspace_resource_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'AnalyticsSolution':
        """
        Get an existing AnalyticsSolution resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] location: Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['AnalyticsSolutionPlanArgs', 'AnalyticsSolutionPlanArgsDict']] plan: A `plan` block as documented below.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which the Log Analytics solution is created. Changing this forces a new resource to be created. Note: The solution and its related workspace can only exist in the same resource group.
        :param pulumi.Input[_builtins.str] solution_name: Specifies the name of the solution to be deployed. See [here for options](https://docs.microsoft.com/azure/log-analytics/log-analytics-add-solutions).Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.str] workspace_name: The full name of the Log Analytics workspace with which the solution will be linked. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] workspace_resource_id: The full resource ID of the Log Analytics workspace with which the solution will be linked. Changing this forces a new resource to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AnalyticsSolutionState.__new__(_AnalyticsSolutionState)

        __props__.__dict__["location"] = location
        __props__.__dict__["plan"] = plan
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["solution_name"] = solution_name
        __props__.__dict__["tags"] = tags
        __props__.__dict__["workspace_name"] = workspace_name
        __props__.__dict__["workspace_resource_id"] = workspace_resource_id
        return AnalyticsSolution(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def plan(self) -> pulumi.Output['outputs.AnalyticsSolutionPlan']:
        """
        A `plan` block as documented below.
        """
        return pulumi.get(self, "plan")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the resource group in which the Log Analytics solution is created. Changing this forces a new resource to be created. Note: The solution and its related workspace can only exist in the same resource group.
        """
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter(name="solutionName")
    def solution_name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of the solution to be deployed. See [here for options](https://docs.microsoft.com/azure/log-analytics/log-analytics-add-solutions).Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "solution_name")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="workspaceName")
    def workspace_name(self) -> pulumi.Output[_builtins.str]:
        """
        The full name of the Log Analytics workspace with which the solution will be linked. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "workspace_name")

    @_builtins.property
    @pulumi.getter(name="workspaceResourceId")
    def workspace_resource_id(self) -> pulumi.Output[_builtins.str]:
        """
        The full resource ID of the Log Analytics workspace with which the solution will be linked. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "workspace_resource_id")

