# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['FlexibleServerVirtualEndpointArgs', 'FlexibleServerVirtualEndpoint']

@pulumi.input_type
class FlexibleServerVirtualEndpointArgs:
    def __init__(__self__, *,
                 replica_server_id: pulumi.Input[_builtins.str],
                 source_server_id: pulumi.Input[_builtins.str],
                 type: pulumi.Input[_builtins.str],
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a FlexibleServerVirtualEndpoint resource.
        :param pulumi.Input[_builtins.str] replica_server_id: The Resource ID of the *Replica* Postgres Flexible Server this should be associated with
               
               > **Note:** If a fail-over has occurred, you will be unable to update `replica_server_id`. You can remove the resource from state and reimport it back in with `source_server_id` and `replica_server_id` flipped and then update `replica_server_id`.
        :param pulumi.Input[_builtins.str] source_server_id: The Resource ID of the *Source* Postgres Flexible Server this should be associated with.
        :param pulumi.Input[_builtins.str] type: The type of Virtual Endpoint. Currently only `ReadWrite` is supported.
        :param pulumi.Input[_builtins.str] name: The name of the Virtual Endpoint
        """
        pulumi.set(__self__, "replica_server_id", replica_server_id)
        pulumi.set(__self__, "source_server_id", source_server_id)
        pulumi.set(__self__, "type", type)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="replicaServerId")
    def replica_server_id(self) -> pulumi.Input[_builtins.str]:
        """
        The Resource ID of the *Replica* Postgres Flexible Server this should be associated with

        > **Note:** If a fail-over has occurred, you will be unable to update `replica_server_id`. You can remove the resource from state and reimport it back in with `source_server_id` and `replica_server_id` flipped and then update `replica_server_id`.
        """
        return pulumi.get(self, "replica_server_id")

    @replica_server_id.setter
    def replica_server_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "replica_server_id", value)

    @_builtins.property
    @pulumi.getter(name="sourceServerId")
    def source_server_id(self) -> pulumi.Input[_builtins.str]:
        """
        The Resource ID of the *Source* Postgres Flexible Server this should be associated with.
        """
        return pulumi.get(self, "source_server_id")

    @source_server_id.setter
    def source_server_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "source_server_id", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        The type of Virtual Endpoint. Currently only `ReadWrite` is supported.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Virtual Endpoint
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _FlexibleServerVirtualEndpointState:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 replica_server_id: Optional[pulumi.Input[_builtins.str]] = None,
                 source_server_id: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering FlexibleServerVirtualEndpoint resources.
        :param pulumi.Input[_builtins.str] name: The name of the Virtual Endpoint
        :param pulumi.Input[_builtins.str] replica_server_id: The Resource ID of the *Replica* Postgres Flexible Server this should be associated with
               
               > **Note:** If a fail-over has occurred, you will be unable to update `replica_server_id`. You can remove the resource from state and reimport it back in with `source_server_id` and `replica_server_id` flipped and then update `replica_server_id`.
        :param pulumi.Input[_builtins.str] source_server_id: The Resource ID of the *Source* Postgres Flexible Server this should be associated with.
        :param pulumi.Input[_builtins.str] type: The type of Virtual Endpoint. Currently only `ReadWrite` is supported.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if replica_server_id is not None:
            pulumi.set(__self__, "replica_server_id", replica_server_id)
        if source_server_id is not None:
            pulumi.set(__self__, "source_server_id", source_server_id)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Virtual Endpoint
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="replicaServerId")
    def replica_server_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Resource ID of the *Replica* Postgres Flexible Server this should be associated with

        > **Note:** If a fail-over has occurred, you will be unable to update `replica_server_id`. You can remove the resource from state and reimport it back in with `source_server_id` and `replica_server_id` flipped and then update `replica_server_id`.
        """
        return pulumi.get(self, "replica_server_id")

    @replica_server_id.setter
    def replica_server_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "replica_server_id", value)

    @_builtins.property
    @pulumi.getter(name="sourceServerId")
    def source_server_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Resource ID of the *Source* Postgres Flexible Server this should be associated with.
        """
        return pulumi.get(self, "source_server_id")

    @source_server_id.setter
    def source_server_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_server_id", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of Virtual Endpoint. Currently only `ReadWrite` is supported.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.type_token("azure:postgresql/flexibleServerVirtualEndpoint:FlexibleServerVirtualEndpoint")
class FlexibleServerVirtualEndpoint(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 replica_server_id: Optional[pulumi.Input[_builtins.str]] = None,
                 source_server_id: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Allows you to create a Virtual Endpoint associated with a Postgres Flexible Replica.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="East US")
        example_flexible_server = azure.postgresql.FlexibleServer("example",
            name="example",
            resource_group_name=example.name,
            location=example.location,
            version="16",
            public_network_access_enabled=False,
            administrator_login="psqladmin",
            administrator_password="H@Sh1CoR3!",
            zone="1",
            storage_mb=32768,
            storage_tier="P30",
            sku_name="GP_Standard_D2ads_v5")
        example_replica = azure.postgresql.FlexibleServer("example_replica",
            name="example-replica",
            resource_group_name=example_flexible_server.resource_group_name,
            location=example_flexible_server.location,
            create_mode="Replica",
            source_server_id=example_flexible_server.id,
            version="16",
            public_network_access_enabled=False,
            zone="1",
            storage_mb=32768,
            storage_tier="P30",
            sku_name="GP_Standard_D2ads_v5")
        example_flexible_server_virtual_endpoint = azure.postgresql.FlexibleServerVirtualEndpoint("example",
            name="example-endpoint-1",
            source_server_id=example_flexible_server.id,
            replica_server_id=example_replica.id,
            type="ReadWrite")
        ```

        > **Note:** If creating multiple replicas, an error can occur if virtual endpoints are created before all replicas have been completed. To avoid this error, use a `depends_on` property on `postgresql.FlexibleServerVirtualEndpoint` that references all Postgres Flexible Server Replicas.

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.DBforPostgreSQL`: 2024-08-01

        ## Import

        A PostgreSQL Flexible Virtual Endpoint can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:postgresql/flexibleServerVirtualEndpoint:FlexibleServerVirtualEndpoint example "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.DBforPostgreSQL/flexibleServers/sourceServerName/virtualEndpoints/endpointName|/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.DBforPostgreSQL/flexibleServers/replicaServerName/virtualEndpoints/endpointName"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] name: The name of the Virtual Endpoint
        :param pulumi.Input[_builtins.str] replica_server_id: The Resource ID of the *Replica* Postgres Flexible Server this should be associated with
               
               > **Note:** If a fail-over has occurred, you will be unable to update `replica_server_id`. You can remove the resource from state and reimport it back in with `source_server_id` and `replica_server_id` flipped and then update `replica_server_id`.
        :param pulumi.Input[_builtins.str] source_server_id: The Resource ID of the *Source* Postgres Flexible Server this should be associated with.
        :param pulumi.Input[_builtins.str] type: The type of Virtual Endpoint. Currently only `ReadWrite` is supported.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FlexibleServerVirtualEndpointArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Allows you to create a Virtual Endpoint associated with a Postgres Flexible Replica.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="East US")
        example_flexible_server = azure.postgresql.FlexibleServer("example",
            name="example",
            resource_group_name=example.name,
            location=example.location,
            version="16",
            public_network_access_enabled=False,
            administrator_login="psqladmin",
            administrator_password="H@Sh1CoR3!",
            zone="1",
            storage_mb=32768,
            storage_tier="P30",
            sku_name="GP_Standard_D2ads_v5")
        example_replica = azure.postgresql.FlexibleServer("example_replica",
            name="example-replica",
            resource_group_name=example_flexible_server.resource_group_name,
            location=example_flexible_server.location,
            create_mode="Replica",
            source_server_id=example_flexible_server.id,
            version="16",
            public_network_access_enabled=False,
            zone="1",
            storage_mb=32768,
            storage_tier="P30",
            sku_name="GP_Standard_D2ads_v5")
        example_flexible_server_virtual_endpoint = azure.postgresql.FlexibleServerVirtualEndpoint("example",
            name="example-endpoint-1",
            source_server_id=example_flexible_server.id,
            replica_server_id=example_replica.id,
            type="ReadWrite")
        ```

        > **Note:** If creating multiple replicas, an error can occur if virtual endpoints are created before all replicas have been completed. To avoid this error, use a `depends_on` property on `postgresql.FlexibleServerVirtualEndpoint` that references all Postgres Flexible Server Replicas.

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.DBforPostgreSQL`: 2024-08-01

        ## Import

        A PostgreSQL Flexible Virtual Endpoint can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:postgresql/flexibleServerVirtualEndpoint:FlexibleServerVirtualEndpoint example "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.DBforPostgreSQL/flexibleServers/sourceServerName/virtualEndpoints/endpointName|/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.DBforPostgreSQL/flexibleServers/replicaServerName/virtualEndpoints/endpointName"
        ```

        :param str resource_name: The name of the resource.
        :param FlexibleServerVirtualEndpointArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FlexibleServerVirtualEndpointArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 replica_server_id: Optional[pulumi.Input[_builtins.str]] = None,
                 source_server_id: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FlexibleServerVirtualEndpointArgs.__new__(FlexibleServerVirtualEndpointArgs)

            __props__.__dict__["name"] = name
            if replica_server_id is None and not opts.urn:
                raise TypeError("Missing required property 'replica_server_id'")
            __props__.__dict__["replica_server_id"] = replica_server_id
            if source_server_id is None and not opts.urn:
                raise TypeError("Missing required property 'source_server_id'")
            __props__.__dict__["source_server_id"] = source_server_id
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
        super(FlexibleServerVirtualEndpoint, __self__).__init__(
            'azure:postgresql/flexibleServerVirtualEndpoint:FlexibleServerVirtualEndpoint',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            replica_server_id: Optional[pulumi.Input[_builtins.str]] = None,
            source_server_id: Optional[pulumi.Input[_builtins.str]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None) -> 'FlexibleServerVirtualEndpoint':
        """
        Get an existing FlexibleServerVirtualEndpoint resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] name: The name of the Virtual Endpoint
        :param pulumi.Input[_builtins.str] replica_server_id: The Resource ID of the *Replica* Postgres Flexible Server this should be associated with
               
               > **Note:** If a fail-over has occurred, you will be unable to update `replica_server_id`. You can remove the resource from state and reimport it back in with `source_server_id` and `replica_server_id` flipped and then update `replica_server_id`.
        :param pulumi.Input[_builtins.str] source_server_id: The Resource ID of the *Source* Postgres Flexible Server this should be associated with.
        :param pulumi.Input[_builtins.str] type: The type of Virtual Endpoint. Currently only `ReadWrite` is supported.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FlexibleServerVirtualEndpointState.__new__(_FlexibleServerVirtualEndpointState)

        __props__.__dict__["name"] = name
        __props__.__dict__["replica_server_id"] = replica_server_id
        __props__.__dict__["source_server_id"] = source_server_id
        __props__.__dict__["type"] = type
        return FlexibleServerVirtualEndpoint(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Virtual Endpoint
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="replicaServerId")
    def replica_server_id(self) -> pulumi.Output[_builtins.str]:
        """
        The Resource ID of the *Replica* Postgres Flexible Server this should be associated with

        > **Note:** If a fail-over has occurred, you will be unable to update `replica_server_id`. You can remove the resource from state and reimport it back in with `source_server_id` and `replica_server_id` flipped and then update `replica_server_id`.
        """
        return pulumi.get(self, "replica_server_id")

    @_builtins.property
    @pulumi.getter(name="sourceServerId")
    def source_server_id(self) -> pulumi.Output[_builtins.str]:
        """
        The Resource ID of the *Source* Postgres Flexible Server this should be associated with.
        """
        return pulumi.get(self, "source_server_id")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of Virtual Endpoint. Currently only `ReadWrite` is supported.
        """
        return pulumi.get(self, "type")

