# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'FlexibleServerAuthentication',
    'FlexibleServerCustomerManagedKey',
    'FlexibleServerHighAvailability',
    'FlexibleServerIdentity',
    'FlexibleServerMaintenanceWindow',
    'ServerIdentity',
    'ServerThreatDetectionPolicy',
    'GetServerIdentityResult',
]

@pulumi.output_type
class FlexibleServerAuthentication(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "activeDirectoryAuthEnabled":
            suggest = "active_directory_auth_enabled"
        elif key == "passwordAuthEnabled":
            suggest = "password_auth_enabled"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FlexibleServerAuthentication. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FlexibleServerAuthentication.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FlexibleServerAuthentication.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 active_directory_auth_enabled: Optional[_builtins.bool] = None,
                 password_auth_enabled: Optional[_builtins.bool] = None,
                 tenant_id: Optional[_builtins.str] = None):
        """
        :param _builtins.bool active_directory_auth_enabled: Whether Active Directory authentication is allowed to access the PostgreSQL Flexible Server. Defaults to `false`.
        :param _builtins.bool password_auth_enabled: Whether password authentication is allowed to access the PostgreSQL Flexible Server. Defaults to `true`.
        :param _builtins.str tenant_id: The Tenant ID of the Azure Active Directory which is used by the Active Directory authentication. `active_directory_auth_enabled` must be set to `true`.
               
               > **Note:** Setting `active_directory_auth_enabled` to `true` requires a Service Principal for the Postgres Flexible Server. For more details see [this document](https://learn.microsoft.com/en-us/azure/postgresql/flexible-server/how-to-configure-sign-in-azure-ad-authentication).
               
               > **Note:** `tenant_id` is required when `active_directory_auth_enabled` is set to `true`. And it should not be specified when `active_directory_auth_enabled` is set to `false`
        """
        if active_directory_auth_enabled is not None:
            pulumi.set(__self__, "active_directory_auth_enabled", active_directory_auth_enabled)
        if password_auth_enabled is not None:
            pulumi.set(__self__, "password_auth_enabled", password_auth_enabled)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @_builtins.property
    @pulumi.getter(name="activeDirectoryAuthEnabled")
    def active_directory_auth_enabled(self) -> Optional[_builtins.bool]:
        """
        Whether Active Directory authentication is allowed to access the PostgreSQL Flexible Server. Defaults to `false`.
        """
        return pulumi.get(self, "active_directory_auth_enabled")

    @_builtins.property
    @pulumi.getter(name="passwordAuthEnabled")
    def password_auth_enabled(self) -> Optional[_builtins.bool]:
        """
        Whether password authentication is allowed to access the PostgreSQL Flexible Server. Defaults to `true`.
        """
        return pulumi.get(self, "password_auth_enabled")

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[_builtins.str]:
        """
        The Tenant ID of the Azure Active Directory which is used by the Active Directory authentication. `active_directory_auth_enabled` must be set to `true`.

        > **Note:** Setting `active_directory_auth_enabled` to `true` requires a Service Principal for the Postgres Flexible Server. For more details see [this document](https://learn.microsoft.com/en-us/azure/postgresql/flexible-server/how-to-configure-sign-in-azure-ad-authentication).

        > **Note:** `tenant_id` is required when `active_directory_auth_enabled` is set to `true`. And it should not be specified when `active_directory_auth_enabled` is set to `false`
        """
        return pulumi.get(self, "tenant_id")


@pulumi.output_type
class FlexibleServerCustomerManagedKey(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keyVaultKeyId":
            suggest = "key_vault_key_id"
        elif key == "geoBackupKeyVaultKeyId":
            suggest = "geo_backup_key_vault_key_id"
        elif key == "geoBackupUserAssignedIdentityId":
            suggest = "geo_backup_user_assigned_identity_id"
        elif key == "primaryUserAssignedIdentityId":
            suggest = "primary_user_assigned_identity_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FlexibleServerCustomerManagedKey. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FlexibleServerCustomerManagedKey.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FlexibleServerCustomerManagedKey.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key_vault_key_id: _builtins.str,
                 geo_backup_key_vault_key_id: Optional[_builtins.str] = None,
                 geo_backup_user_assigned_identity_id: Optional[_builtins.str] = None,
                 primary_user_assigned_identity_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str key_vault_key_id: The versioned/versionless ID of the Key Vault Key.
        :param _builtins.str geo_backup_key_vault_key_id: The versioned ID of the geo backup Key Vault Key.
               
               > **Note:** The key vault in which this key exists must be in the same region as the geo-redundant backup.
        :param _builtins.str geo_backup_user_assigned_identity_id: The geo backup user managed identity id for a Customer Managed Key. Must be added to `identity.identity_ids`.
               
               > **Note:** This managed identity cannot be the same as `primary_user_assigned_identity_id`, additionally this identity must be created in the same region as the geo-redundant backup.
               
               > **Note:** `primary_user_assigned_identity_id` or `geo_backup_user_assigned_identity_id` is required when `type` is set to `UserAssigned`.
        :param _builtins.str primary_user_assigned_identity_id: Specifies the primary user managed identity id for a Customer Managed Key. Must be added to `identity.identity_ids`.
        """
        pulumi.set(__self__, "key_vault_key_id", key_vault_key_id)
        if geo_backup_key_vault_key_id is not None:
            pulumi.set(__self__, "geo_backup_key_vault_key_id", geo_backup_key_vault_key_id)
        if geo_backup_user_assigned_identity_id is not None:
            pulumi.set(__self__, "geo_backup_user_assigned_identity_id", geo_backup_user_assigned_identity_id)
        if primary_user_assigned_identity_id is not None:
            pulumi.set(__self__, "primary_user_assigned_identity_id", primary_user_assigned_identity_id)

    @_builtins.property
    @pulumi.getter(name="keyVaultKeyId")
    def key_vault_key_id(self) -> _builtins.str:
        """
        The versioned/versionless ID of the Key Vault Key.
        """
        return pulumi.get(self, "key_vault_key_id")

    @_builtins.property
    @pulumi.getter(name="geoBackupKeyVaultKeyId")
    def geo_backup_key_vault_key_id(self) -> Optional[_builtins.str]:
        """
        The versioned ID of the geo backup Key Vault Key.

        > **Note:** The key vault in which this key exists must be in the same region as the geo-redundant backup.
        """
        return pulumi.get(self, "geo_backup_key_vault_key_id")

    @_builtins.property
    @pulumi.getter(name="geoBackupUserAssignedIdentityId")
    def geo_backup_user_assigned_identity_id(self) -> Optional[_builtins.str]:
        """
        The geo backup user managed identity id for a Customer Managed Key. Must be added to `identity.identity_ids`.

        > **Note:** This managed identity cannot be the same as `primary_user_assigned_identity_id`, additionally this identity must be created in the same region as the geo-redundant backup.

        > **Note:** `primary_user_assigned_identity_id` or `geo_backup_user_assigned_identity_id` is required when `type` is set to `UserAssigned`.
        """
        return pulumi.get(self, "geo_backup_user_assigned_identity_id")

    @_builtins.property
    @pulumi.getter(name="primaryUserAssignedIdentityId")
    def primary_user_assigned_identity_id(self) -> Optional[_builtins.str]:
        """
        Specifies the primary user managed identity id for a Customer Managed Key. Must be added to `identity.identity_ids`.
        """
        return pulumi.get(self, "primary_user_assigned_identity_id")


@pulumi.output_type
class FlexibleServerHighAvailability(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "standbyAvailabilityZone":
            suggest = "standby_availability_zone"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FlexibleServerHighAvailability. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FlexibleServerHighAvailability.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FlexibleServerHighAvailability.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 mode: _builtins.str,
                 standby_availability_zone: Optional[_builtins.str] = None):
        """
        :param _builtins.str mode: The high availability mode for the PostgreSQL Flexible Server. Possible value are `SameZone` or `ZoneRedundant`.
        """
        pulumi.set(__self__, "mode", mode)
        if standby_availability_zone is not None:
            pulumi.set(__self__, "standby_availability_zone", standby_availability_zone)

    @_builtins.property
    @pulumi.getter
    def mode(self) -> _builtins.str:
        """
        The high availability mode for the PostgreSQL Flexible Server. Possible value are `SameZone` or `ZoneRedundant`.
        """
        return pulumi.get(self, "mode")

    @_builtins.property
    @pulumi.getter(name="standbyAvailabilityZone")
    def standby_availability_zone(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "standby_availability_zone")


@pulumi.output_type
class FlexibleServerIdentity(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "identityIds":
            suggest = "identity_ids"
        elif key == "principalId":
            suggest = "principal_id"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FlexibleServerIdentity. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FlexibleServerIdentity.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FlexibleServerIdentity.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: _builtins.str,
                 identity_ids: Optional[Sequence[_builtins.str]] = None,
                 principal_id: Optional[_builtins.str] = None,
                 tenant_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str type: Specifies the type of Managed Service Identity that should be configured on this PostgreSQL Flexible Server. Possible values are `UserAssigned`, `SystemAssigned` and `SystemAssigned, UserAssigned`.
               
               > **Note:** Once `UserAssigned` has been added, removing it forces a new resource to be created.
        :param Sequence[_builtins.str] identity_ids: A list of User Assigned Managed Identity IDs to be assigned to this PostgreSQL Flexible Server. Required if used together with `customer_managed_key` block.
               
               > **Note:** `identity_ids` is required when `type` is set to `UserAssigned` or `SystemAssigned, UserAssigned`.
        :param _builtins.str principal_id: The Principal ID associated with this Managed Service Identity.
        :param _builtins.str tenant_id: The Tenant ID associated with this Managed Service Identity.
        """
        pulumi.set(__self__, "type", type)
        if identity_ids is not None:
            pulumi.set(__self__, "identity_ids", identity_ids)
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Specifies the type of Managed Service Identity that should be configured on this PostgreSQL Flexible Server. Possible values are `UserAssigned`, `SystemAssigned` and `SystemAssigned, UserAssigned`.

        > **Note:** Once `UserAssigned` has been added, removing it forces a new resource to be created.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="identityIds")
    def identity_ids(self) -> Optional[Sequence[_builtins.str]]:
        """
        A list of User Assigned Managed Identity IDs to be assigned to this PostgreSQL Flexible Server. Required if used together with `customer_managed_key` block.

        > **Note:** `identity_ids` is required when `type` is set to `UserAssigned` or `SystemAssigned, UserAssigned`.
        """
        return pulumi.get(self, "identity_ids")

    @_builtins.property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[_builtins.str]:
        """
        The Principal ID associated with this Managed Service Identity.
        """
        return pulumi.get(self, "principal_id")

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[_builtins.str]:
        """
        The Tenant ID associated with this Managed Service Identity.
        """
        return pulumi.get(self, "tenant_id")


@pulumi.output_type
class FlexibleServerMaintenanceWindow(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dayOfWeek":
            suggest = "day_of_week"
        elif key == "startHour":
            suggest = "start_hour"
        elif key == "startMinute":
            suggest = "start_minute"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FlexibleServerMaintenanceWindow. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FlexibleServerMaintenanceWindow.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FlexibleServerMaintenanceWindow.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 day_of_week: Optional[_builtins.int] = None,
                 start_hour: Optional[_builtins.int] = None,
                 start_minute: Optional[_builtins.int] = None):
        """
        :param _builtins.int day_of_week: The day of week for maintenance window, where the week starts on a Sunday, i.e. Sunday = `0`, Monday = `1`. Defaults to `0`.
        :param _builtins.int start_hour: The start hour for maintenance window. Defaults to `0`.
        :param _builtins.int start_minute: The start minute for maintenance window. Defaults to `0`.
               
               > **Note:** The specified `maintenance_window` is always defined in UTC time. When unspecified, the maintenance window falls back to the default [system-managed](https://learn.microsoft.com/en-us/azure/postgresql/flexible-server/how-to-maintenance-portal#specify-maintenance-schedule-options).
        """
        if day_of_week is not None:
            pulumi.set(__self__, "day_of_week", day_of_week)
        if start_hour is not None:
            pulumi.set(__self__, "start_hour", start_hour)
        if start_minute is not None:
            pulumi.set(__self__, "start_minute", start_minute)

    @_builtins.property
    @pulumi.getter(name="dayOfWeek")
    def day_of_week(self) -> Optional[_builtins.int]:
        """
        The day of week for maintenance window, where the week starts on a Sunday, i.e. Sunday = `0`, Monday = `1`. Defaults to `0`.
        """
        return pulumi.get(self, "day_of_week")

    @_builtins.property
    @pulumi.getter(name="startHour")
    def start_hour(self) -> Optional[_builtins.int]:
        """
        The start hour for maintenance window. Defaults to `0`.
        """
        return pulumi.get(self, "start_hour")

    @_builtins.property
    @pulumi.getter(name="startMinute")
    def start_minute(self) -> Optional[_builtins.int]:
        """
        The start minute for maintenance window. Defaults to `0`.

        > **Note:** The specified `maintenance_window` is always defined in UTC time. When unspecified, the maintenance window falls back to the default [system-managed](https://learn.microsoft.com/en-us/azure/postgresql/flexible-server/how-to-maintenance-portal#specify-maintenance-schedule-options).
        """
        return pulumi.get(self, "start_minute")


@pulumi.output_type
class ServerIdentity(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "principalId":
            suggest = "principal_id"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServerIdentity. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServerIdentity.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServerIdentity.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: _builtins.str,
                 principal_id: Optional[_builtins.str] = None,
                 tenant_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str type: Specifies the type of Managed Service Identity that should be configured on this PostgreSQL Server. The only possible value is `SystemAssigned`.
        :param _builtins.str principal_id: The Principal ID associated with this Managed Service Identity.
        :param _builtins.str tenant_id: The Tenant ID associated with this Managed Service Identity.
        """
        pulumi.set(__self__, "type", type)
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Specifies the type of Managed Service Identity that should be configured on this PostgreSQL Server. The only possible value is `SystemAssigned`.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[_builtins.str]:
        """
        The Principal ID associated with this Managed Service Identity.
        """
        return pulumi.get(self, "principal_id")

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[_builtins.str]:
        """
        The Tenant ID associated with this Managed Service Identity.
        """
        return pulumi.get(self, "tenant_id")


@pulumi.output_type
class ServerThreatDetectionPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "disabledAlerts":
            suggest = "disabled_alerts"
        elif key == "emailAccountAdmins":
            suggest = "email_account_admins"
        elif key == "emailAddresses":
            suggest = "email_addresses"
        elif key == "retentionDays":
            suggest = "retention_days"
        elif key == "storageAccountAccessKey":
            suggest = "storage_account_access_key"
        elif key == "storageEndpoint":
            suggest = "storage_endpoint"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServerThreatDetectionPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServerThreatDetectionPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServerThreatDetectionPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 disabled_alerts: Optional[Sequence[_builtins.str]] = None,
                 email_account_admins: Optional[_builtins.bool] = None,
                 email_addresses: Optional[Sequence[_builtins.str]] = None,
                 enabled: Optional[_builtins.bool] = None,
                 retention_days: Optional[_builtins.int] = None,
                 storage_account_access_key: Optional[_builtins.str] = None,
                 storage_endpoint: Optional[_builtins.str] = None):
        """
        :param Sequence[_builtins.str] disabled_alerts: Specifies a list of alerts which should be disabled. Possible values are `Sql_Injection`, `Sql_Injection_Vulnerability`, `Access_Anomaly`, `Data_Exfiltration` and `Unsafe_Action`.
        :param _builtins.bool email_account_admins: Should the account administrators be emailed when this alert is triggered?
        :param Sequence[_builtins.str] email_addresses: A list of email addresses which alerts should be sent to.
        :param _builtins.bool enabled: Is the policy enabled?
        :param _builtins.int retention_days: Specifies the number of days to keep in the Threat Detection audit logs.
        :param _builtins.str storage_account_access_key: Specifies the identifier key of the Threat Detection audit storage account.
        :param _builtins.str storage_endpoint: Specifies the blob storage endpoint (e.g. <https://example.blob.core.windows.net>). This blob storage will hold all Threat Detection audit logs.
        """
        if disabled_alerts is not None:
            pulumi.set(__self__, "disabled_alerts", disabled_alerts)
        if email_account_admins is not None:
            pulumi.set(__self__, "email_account_admins", email_account_admins)
        if email_addresses is not None:
            pulumi.set(__self__, "email_addresses", email_addresses)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if retention_days is not None:
            pulumi.set(__self__, "retention_days", retention_days)
        if storage_account_access_key is not None:
            pulumi.set(__self__, "storage_account_access_key", storage_account_access_key)
        if storage_endpoint is not None:
            pulumi.set(__self__, "storage_endpoint", storage_endpoint)

    @_builtins.property
    @pulumi.getter(name="disabledAlerts")
    def disabled_alerts(self) -> Optional[Sequence[_builtins.str]]:
        """
        Specifies a list of alerts which should be disabled. Possible values are `Sql_Injection`, `Sql_Injection_Vulnerability`, `Access_Anomaly`, `Data_Exfiltration` and `Unsafe_Action`.
        """
        return pulumi.get(self, "disabled_alerts")

    @_builtins.property
    @pulumi.getter(name="emailAccountAdmins")
    def email_account_admins(self) -> Optional[_builtins.bool]:
        """
        Should the account administrators be emailed when this alert is triggered?
        """
        return pulumi.get(self, "email_account_admins")

    @_builtins.property
    @pulumi.getter(name="emailAddresses")
    def email_addresses(self) -> Optional[Sequence[_builtins.str]]:
        """
        A list of email addresses which alerts should be sent to.
        """
        return pulumi.get(self, "email_addresses")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[_builtins.bool]:
        """
        Is the policy enabled?
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="retentionDays")
    def retention_days(self) -> Optional[_builtins.int]:
        """
        Specifies the number of days to keep in the Threat Detection audit logs.
        """
        return pulumi.get(self, "retention_days")

    @_builtins.property
    @pulumi.getter(name="storageAccountAccessKey")
    def storage_account_access_key(self) -> Optional[_builtins.str]:
        """
        Specifies the identifier key of the Threat Detection audit storage account.
        """
        return pulumi.get(self, "storage_account_access_key")

    @_builtins.property
    @pulumi.getter(name="storageEndpoint")
    def storage_endpoint(self) -> Optional[_builtins.str]:
        """
        Specifies the blob storage endpoint (e.g. <https://example.blob.core.windows.net>). This blob storage will hold all Threat Detection audit logs.
        """
        return pulumi.get(self, "storage_endpoint")


@pulumi.output_type
class GetServerIdentityResult(dict):
    def __init__(__self__, *,
                 principal_id: _builtins.str,
                 tenant_id: _builtins.str,
                 type: _builtins.str):
        """
        :param _builtins.str principal_id: The ID of the System Managed Service Principal assigned to the PostgreSQL Server.
        :param _builtins.str tenant_id: The ID of the Tenant of the System Managed Service Principal assigned to the PostgreSQL Server.
        :param _builtins.str type: The identity type of the Managed Identity assigned to the PostgreSQL Server.
        """
        pulumi.set(__self__, "principal_id", principal_id)
        pulumi.set(__self__, "tenant_id", tenant_id)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> _builtins.str:
        """
        The ID of the System Managed Service Principal assigned to the PostgreSQL Server.
        """
        return pulumi.get(self, "principal_id")

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> _builtins.str:
        """
        The ID of the Tenant of the System Managed Service Principal assigned to the PostgreSQL Server.
        """
        return pulumi.get(self, "tenant_id")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The identity type of the Managed Identity assigned to the PostgreSQL Server.
        """
        return pulumi.get(self, "type")


