# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'LinkServiceNatIpConfigurationArgs',
    'LinkServiceNatIpConfigurationArgsDict',
    'MxRecordRecordArgs',
    'MxRecordRecordArgsDict',
    'ResolverForwardingRuleTargetDnsServerArgs',
    'ResolverForwardingRuleTargetDnsServerArgsDict',
    'ResolverInboundEndpointIpConfigurationsArgs',
    'ResolverInboundEndpointIpConfigurationsArgsDict',
    'SRVRecordRecordArgs',
    'SRVRecordRecordArgsDict',
    'TxtRecordRecordArgs',
    'TxtRecordRecordArgsDict',
    'ZoneSoaRecordArgs',
    'ZoneSoaRecordArgsDict',
]

MYPY = False

if not MYPY:
    class LinkServiceNatIpConfigurationArgsDict(TypedDict):
        name: pulumi.Input[_builtins.str]
        """
        Specifies the name which should be used for the NAT IP Configuration. Changing this forces a new resource to be created.
        """
        primary: pulumi.Input[_builtins.bool]
        """
        Is this is the Primary IP Configuration? Changing this forces a new resource to be created.
        """
        subnet_id: pulumi.Input[_builtins.str]
        """
        Specifies the ID of the Subnet which should be used for the Private Link Service.

        > **Note:** Verify that the Subnet's `enforce_private_link_service_network_policies` attribute is set to `true`.
        """
        private_ip_address: NotRequired[pulumi.Input[_builtins.str]]
        """
        Specifies a Private Static IP Address for this IP Configuration.
        """
        private_ip_address_version: NotRequired[pulumi.Input[_builtins.str]]
        """
        The version of the IP Protocol which should be used. At this time the only supported value is `IPv4`. Defaults to `IPv4`.
        """
elif False:
    LinkServiceNatIpConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class LinkServiceNatIpConfigurationArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[_builtins.str],
                 primary: pulumi.Input[_builtins.bool],
                 subnet_id: pulumi.Input[_builtins.str],
                 private_ip_address: Optional[pulumi.Input[_builtins.str]] = None,
                 private_ip_address_version: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] name: Specifies the name which should be used for the NAT IP Configuration. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] primary: Is this is the Primary IP Configuration? Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] subnet_id: Specifies the ID of the Subnet which should be used for the Private Link Service.
               
               > **Note:** Verify that the Subnet's `enforce_private_link_service_network_policies` attribute is set to `true`.
        :param pulumi.Input[_builtins.str] private_ip_address: Specifies a Private Static IP Address for this IP Configuration.
        :param pulumi.Input[_builtins.str] private_ip_address_version: The version of the IP Protocol which should be used. At this time the only supported value is `IPv4`. Defaults to `IPv4`.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "primary", primary)
        pulumi.set(__self__, "subnet_id", subnet_id)
        if private_ip_address is not None:
            pulumi.set(__self__, "private_ip_address", private_ip_address)
        if private_ip_address_version is not None:
            pulumi.set(__self__, "private_ip_address_version", private_ip_address_version)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the name which should be used for the NAT IP Configuration. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def primary(self) -> pulumi.Input[_builtins.bool]:
        """
        Is this is the Primary IP Configuration? Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "primary")

    @primary.setter
    def primary(self, value: pulumi.Input[_builtins.bool]):
        pulumi.set(self, "primary", value)

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the ID of the Subnet which should be used for the Private Link Service.

        > **Note:** Verify that the Subnet's `enforce_private_link_service_network_policies` attribute is set to `true`.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "subnet_id", value)

    @_builtins.property
    @pulumi.getter(name="privateIpAddress")
    def private_ip_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies a Private Static IP Address for this IP Configuration.
        """
        return pulumi.get(self, "private_ip_address")

    @private_ip_address.setter
    def private_ip_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_ip_address", value)

    @_builtins.property
    @pulumi.getter(name="privateIpAddressVersion")
    def private_ip_address_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The version of the IP Protocol which should be used. At this time the only supported value is `IPv4`. Defaults to `IPv4`.
        """
        return pulumi.get(self, "private_ip_address_version")

    @private_ip_address_version.setter
    def private_ip_address_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_ip_address_version", value)


if not MYPY:
    class MxRecordRecordArgsDict(TypedDict):
        exchange: pulumi.Input[_builtins.str]
        """
        The FQDN of the exchange to MX record points to.
        """
        preference: pulumi.Input[_builtins.int]
        """
        The preference of the MX record.
        """
elif False:
    MxRecordRecordArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class MxRecordRecordArgs:
    def __init__(__self__, *,
                 exchange: pulumi.Input[_builtins.str],
                 preference: pulumi.Input[_builtins.int]):
        """
        :param pulumi.Input[_builtins.str] exchange: The FQDN of the exchange to MX record points to.
        :param pulumi.Input[_builtins.int] preference: The preference of the MX record.
        """
        pulumi.set(__self__, "exchange", exchange)
        pulumi.set(__self__, "preference", preference)

    @_builtins.property
    @pulumi.getter
    def exchange(self) -> pulumi.Input[_builtins.str]:
        """
        The FQDN of the exchange to MX record points to.
        """
        return pulumi.get(self, "exchange")

    @exchange.setter
    def exchange(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "exchange", value)

    @_builtins.property
    @pulumi.getter
    def preference(self) -> pulumi.Input[_builtins.int]:
        """
        The preference of the MX record.
        """
        return pulumi.get(self, "preference")

    @preference.setter
    def preference(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "preference", value)


if not MYPY:
    class ResolverForwardingRuleTargetDnsServerArgsDict(TypedDict):
        ip_address: pulumi.Input[_builtins.str]
        """
        DNS server IP address.
        """
        port: NotRequired[pulumi.Input[_builtins.int]]
        """
        DNS server port.
        """
elif False:
    ResolverForwardingRuleTargetDnsServerArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ResolverForwardingRuleTargetDnsServerArgs:
    def __init__(__self__, *,
                 ip_address: pulumi.Input[_builtins.str],
                 port: Optional[pulumi.Input[_builtins.int]] = None):
        """
        :param pulumi.Input[_builtins.str] ip_address: DNS server IP address.
        :param pulumi.Input[_builtins.int] port: DNS server port.
        """
        pulumi.set(__self__, "ip_address", ip_address)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @_builtins.property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> pulumi.Input[_builtins.str]:
        """
        DNS server IP address.
        """
        return pulumi.get(self, "ip_address")

    @ip_address.setter
    def ip_address(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "ip_address", value)

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        DNS server port.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "port", value)


if not MYPY:
    class ResolverInboundEndpointIpConfigurationsArgsDict(TypedDict):
        subnet_id: pulumi.Input[_builtins.str]
        """
        The subnet ID of the IP configuration.
        """
        private_ip_address: NotRequired[pulumi.Input[_builtins.str]]
        """
        Private IP address of the IP configuration.
        """
        private_ip_allocation_method: NotRequired[pulumi.Input[_builtins.str]]
        """
        Private IP address allocation method. Allowed value is `Dynamic` and `Static`. Defaults to `Dynamic`.
        """
elif False:
    ResolverInboundEndpointIpConfigurationsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ResolverInboundEndpointIpConfigurationsArgs:
    def __init__(__self__, *,
                 subnet_id: pulumi.Input[_builtins.str],
                 private_ip_address: Optional[pulumi.Input[_builtins.str]] = None,
                 private_ip_allocation_method: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] subnet_id: The subnet ID of the IP configuration.
        :param pulumi.Input[_builtins.str] private_ip_address: Private IP address of the IP configuration.
        :param pulumi.Input[_builtins.str] private_ip_allocation_method: Private IP address allocation method. Allowed value is `Dynamic` and `Static`. Defaults to `Dynamic`.
        """
        pulumi.set(__self__, "subnet_id", subnet_id)
        if private_ip_address is not None:
            pulumi.set(__self__, "private_ip_address", private_ip_address)
        if private_ip_allocation_method is not None:
            pulumi.set(__self__, "private_ip_allocation_method", private_ip_allocation_method)

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Input[_builtins.str]:
        """
        The subnet ID of the IP configuration.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "subnet_id", value)

    @_builtins.property
    @pulumi.getter(name="privateIpAddress")
    def private_ip_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Private IP address of the IP configuration.
        """
        return pulumi.get(self, "private_ip_address")

    @private_ip_address.setter
    def private_ip_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_ip_address", value)

    @_builtins.property
    @pulumi.getter(name="privateIpAllocationMethod")
    def private_ip_allocation_method(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Private IP address allocation method. Allowed value is `Dynamic` and `Static`. Defaults to `Dynamic`.
        """
        return pulumi.get(self, "private_ip_allocation_method")

    @private_ip_allocation_method.setter
    def private_ip_allocation_method(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_ip_allocation_method", value)


if not MYPY:
    class SRVRecordRecordArgsDict(TypedDict):
        port: pulumi.Input[_builtins.int]
        """
        The Port the service is listening on.
        """
        priority: pulumi.Input[_builtins.int]
        """
        The priority of the SRV record.
        """
        target: pulumi.Input[_builtins.str]
        """
        The FQDN of the service.
        """
        weight: pulumi.Input[_builtins.int]
        """
        The Weight of the SRV record.
        """
elif False:
    SRVRecordRecordArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SRVRecordRecordArgs:
    def __init__(__self__, *,
                 port: pulumi.Input[_builtins.int],
                 priority: pulumi.Input[_builtins.int],
                 target: pulumi.Input[_builtins.str],
                 weight: pulumi.Input[_builtins.int]):
        """
        :param pulumi.Input[_builtins.int] port: The Port the service is listening on.
        :param pulumi.Input[_builtins.int] priority: The priority of the SRV record.
        :param pulumi.Input[_builtins.str] target: The FQDN of the service.
        :param pulumi.Input[_builtins.int] weight: The Weight of the SRV record.
        """
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "priority", priority)
        pulumi.set(__self__, "target", target)
        pulumi.set(__self__, "weight", weight)

    @_builtins.property
    @pulumi.getter
    def port(self) -> pulumi.Input[_builtins.int]:
        """
        The Port the service is listening on.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "port", value)

    @_builtins.property
    @pulumi.getter
    def priority(self) -> pulumi.Input[_builtins.int]:
        """
        The priority of the SRV record.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "priority", value)

    @_builtins.property
    @pulumi.getter
    def target(self) -> pulumi.Input[_builtins.str]:
        """
        The FQDN of the service.
        """
        return pulumi.get(self, "target")

    @target.setter
    def target(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "target", value)

    @_builtins.property
    @pulumi.getter
    def weight(self) -> pulumi.Input[_builtins.int]:
        """
        The Weight of the SRV record.
        """
        return pulumi.get(self, "weight")

    @weight.setter
    def weight(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "weight", value)


if not MYPY:
    class TxtRecordRecordArgsDict(TypedDict):
        value: pulumi.Input[_builtins.str]
        """
        The value of the TXT record. Max length: 1024 characters
        """
elif False:
    TxtRecordRecordArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class TxtRecordRecordArgs:
    def __init__(__self__, *,
                 value: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input[_builtins.str] value: The value of the TXT record. Max length: 1024 characters
        """
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def value(self) -> pulumi.Input[_builtins.str]:
        """
        The value of the TXT record. Max length: 1024 characters
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "value", value)


if not MYPY:
    class ZoneSoaRecordArgsDict(TypedDict):
        email: pulumi.Input[_builtins.str]
        """
        The email contact for the SOA record.
        """
        expire_time: NotRequired[pulumi.Input[_builtins.int]]
        """
        The expire time for the SOA record. Defaults to `2419200`.
        """
        fqdn: NotRequired[pulumi.Input[_builtins.str]]
        """
        The fully qualified domain name of the Record Set.
        """
        host_name: NotRequired[pulumi.Input[_builtins.str]]
        """
        The domain name of the authoritative name server for the SOA record.
        """
        minimum_ttl: NotRequired[pulumi.Input[_builtins.int]]
        """
        The minimum Time To Live for the SOA record. By convention, it is used to determine the negative caching duration. Defaults to `10`.
        """
        refresh_time: NotRequired[pulumi.Input[_builtins.int]]
        """
        The refresh time for the SOA record. Defaults to `3600`.
        """
        retry_time: NotRequired[pulumi.Input[_builtins.int]]
        """
        The retry time for the SOA record. Defaults to `300`.
        """
        serial_number: NotRequired[pulumi.Input[_builtins.int]]
        """
        The serial number for the SOA record.
        """
        tags: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]
        """
        A mapping of tags to assign to the Record Set.
        """
        ttl: NotRequired[pulumi.Input[_builtins.int]]
        """
        The Time To Live of the SOA Record in seconds. Defaults to `3600`.
        """
elif False:
    ZoneSoaRecordArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ZoneSoaRecordArgs:
    def __init__(__self__, *,
                 email: pulumi.Input[_builtins.str],
                 expire_time: Optional[pulumi.Input[_builtins.int]] = None,
                 fqdn: Optional[pulumi.Input[_builtins.str]] = None,
                 host_name: Optional[pulumi.Input[_builtins.str]] = None,
                 minimum_ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 refresh_time: Optional[pulumi.Input[_builtins.int]] = None,
                 retry_time: Optional[pulumi.Input[_builtins.int]] = None,
                 serial_number: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 ttl: Optional[pulumi.Input[_builtins.int]] = None):
        """
        :param pulumi.Input[_builtins.str] email: The email contact for the SOA record.
        :param pulumi.Input[_builtins.int] expire_time: The expire time for the SOA record. Defaults to `2419200`.
        :param pulumi.Input[_builtins.str] fqdn: The fully qualified domain name of the Record Set.
        :param pulumi.Input[_builtins.str] host_name: The domain name of the authoritative name server for the SOA record.
        :param pulumi.Input[_builtins.int] minimum_ttl: The minimum Time To Live for the SOA record. By convention, it is used to determine the negative caching duration. Defaults to `10`.
        :param pulumi.Input[_builtins.int] refresh_time: The refresh time for the SOA record. Defaults to `3600`.
        :param pulumi.Input[_builtins.int] retry_time: The retry time for the SOA record. Defaults to `300`.
        :param pulumi.Input[_builtins.int] serial_number: The serial number for the SOA record.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the Record Set.
        :param pulumi.Input[_builtins.int] ttl: The Time To Live of the SOA Record in seconds. Defaults to `3600`.
        """
        pulumi.set(__self__, "email", email)
        if expire_time is not None:
            pulumi.set(__self__, "expire_time", expire_time)
        if fqdn is not None:
            pulumi.set(__self__, "fqdn", fqdn)
        if host_name is not None:
            pulumi.set(__self__, "host_name", host_name)
        if minimum_ttl is not None:
            pulumi.set(__self__, "minimum_ttl", minimum_ttl)
        if refresh_time is not None:
            pulumi.set(__self__, "refresh_time", refresh_time)
        if retry_time is not None:
            pulumi.set(__self__, "retry_time", retry_time)
        if serial_number is not None:
            pulumi.set(__self__, "serial_number", serial_number)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if ttl is not None:
            pulumi.set(__self__, "ttl", ttl)

    @_builtins.property
    @pulumi.getter
    def email(self) -> pulumi.Input[_builtins.str]:
        """
        The email contact for the SOA record.
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "email", value)

    @_builtins.property
    @pulumi.getter(name="expireTime")
    def expire_time(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The expire time for the SOA record. Defaults to `2419200`.
        """
        return pulumi.get(self, "expire_time")

    @expire_time.setter
    def expire_time(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "expire_time", value)

    @_builtins.property
    @pulumi.getter
    def fqdn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The fully qualified domain name of the Record Set.
        """
        return pulumi.get(self, "fqdn")

    @fqdn.setter
    def fqdn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "fqdn", value)

    @_builtins.property
    @pulumi.getter(name="hostName")
    def host_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The domain name of the authoritative name server for the SOA record.
        """
        return pulumi.get(self, "host_name")

    @host_name.setter
    def host_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "host_name", value)

    @_builtins.property
    @pulumi.getter(name="minimumTtl")
    def minimum_ttl(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The minimum Time To Live for the SOA record. By convention, it is used to determine the negative caching duration. Defaults to `10`.
        """
        return pulumi.get(self, "minimum_ttl")

    @minimum_ttl.setter
    def minimum_ttl(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "minimum_ttl", value)

    @_builtins.property
    @pulumi.getter(name="refreshTime")
    def refresh_time(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The refresh time for the SOA record. Defaults to `3600`.
        """
        return pulumi.get(self, "refresh_time")

    @refresh_time.setter
    def refresh_time(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "refresh_time", value)

    @_builtins.property
    @pulumi.getter(name="retryTime")
    def retry_time(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The retry time for the SOA record. Defaults to `300`.
        """
        return pulumi.get(self, "retry_time")

    @retry_time.setter
    def retry_time(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "retry_time", value)

    @_builtins.property
    @pulumi.getter(name="serialNumber")
    def serial_number(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The serial number for the SOA record.
        """
        return pulumi.get(self, "serial_number")

    @serial_number.setter
    def serial_number(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "serial_number", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the Record Set.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def ttl(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The Time To Live of the SOA Record in seconds. Defaults to `3600`.
        """
        return pulumi.get(self, "ttl")

    @ttl.setter
    def ttl(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "ttl", value)


